/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibEContact" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://edsintegration/LibGLib.jsm");
Cu.import("resource://edsintegration/libebook-ctypes.jsm");

XPCOMUtils.defineLazyGetter(this, "EContact", function() {
  return ctypes.StructType("EContact");
});

XPCOMUtils.defineLazyGetter(this, "EContactAddress", function() {
  return ctypes.StructType("EContactAddress", [{address_format: LibGLib.gchar.ptr},
                                            {po: LibGLib.gchar.ptr},
                                            {ext: LibGLib.gchar.ptr},
                                            {street: LibGLib.gchar.ptr},
                                            {locality: LibGLib.gchar.ptr},
                                            {region: LibGLib.gchar.ptr},
                                            {code: LibGLib.gchar.ptr},
                                            {country: LibGLib.gchar.ptr}]);
});

XPCOMUtils.defineLazyGetter(this, "EContactDate", function() {
  return ctypes.StructType("EContactDate", [{year: LibGLib.guint},
                                            {month: LibGLib.guint},
                                            {day: LibGLib.guint}]);
});

XPCOMUtils.defineLazyGetter(this, "EContactName", function() {
  return ctypes.StructType("EContactName", [{family: LibGLib.gchar.ptr},
                                            {given: LibGLib.gchar.ptr},
                                            {additional: LibGLib.gchar.ptr},
                                            {prefixes: LibGLib.gchar.ptr},
                                            {suffixes: LibGLib.gchar.ptr}]);
});

XPCOMUtils.defineLazyGetter(this, "EContactPhoto", function() {
  var inlined = ctypes.StructType("inlined", [{mime_type: LibGLib.gchar.ptr},
                                              {length: LibGLib.gsize},
                                              {data: LibGLib.guchar.ptr}]);
  return ctypes.StructType("EContactPhoto", [{type: EContactPhotoType},
                                             {data: inlined}]);
});

XPCOMUtils.defineLazyGetter(this, "EContactPhotoType", function() {
  return ctypes.int;
});

XPCOMUtils.defineLazyGetter(this, "EContactField", function() {
  return ctypes.int;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_address_new", function() {
  var e_contact_address_new =
    libebook.declare("e_contact_address_new",
                     ctypes.default_abi,
                     EContactAddress.ptr);
  if (!e_contact_address_new)
    throw "e_contact_address_new is unavailable";

  return e_contact_address_new;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_address_free", function() {
  var e_contact_address_free =
    libebook.declare("e_contact_address_free",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EContactAddress.ptr);
  if (!e_contact_address_free)
    throw "e_contact_address_free is unavailable";

  return e_contact_address_free;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_address_get_type", function() {
  var e_contact_address_get_type =
    libebook.declare("e_contact_address_get_type",
                     ctypes.default_abi,
                     LibGLib.GType);
  
  if (!e_contact_address_get_type)
    throw "e_contact_address_get_type is unavailable";

  return e_contact_address_get_type;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_date_free", function() {
  var e_contact_date_free =
    libebook.declare("e_contact_date_free",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EContactDate.ptr);
  if (!e_contact_date_free)
    throw "e_contact_date_free is unavailable";

  return e_contact_date_free;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_duplicate", function() {
  var e_contact_duplicate =
    libebook.declare("e_contact_duplicate",
                     ctypes.default_abi,
                     EContact.ptr,
                     EContact.ptr);
  if (!e_contact_duplicate)
    throw "e_contact_duplicate is unavailable";

  return e_contact_duplicate;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_field_name", function() {
  var e_contact_field_name =
    libebook.declare("e_contact_field_name",
                     ctypes.default_abi,
                     LibGLib.gchar.ptr,
                     EContactField);
  if (!e_contact_field_name)
    throw "e_contact_field_name is unavailable";

  return e_contact_field_name;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_field_id", function() {
  var e_contact_field_id =
    libebook.declare("e_contact_field_id",
                     ctypes.default_abi,
                     EContactField,
                     LibGLib.gchar.ptr);
  if (!e_contact_field_id)
    throw "e_contact_field_id is unavailable";

  return e_contact_field_id;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_photo_free", function() {
  var e_contact_photo_free =
    libebook.declare("e_contact_photo_free",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EContactPhoto.ptr);
  if (!e_contact_photo_free)
    throw "e_contact_photo_free is unavailable";

  return e_contact_photo_free;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_pretty_name", function() {
  var e_contact_pretty_name =
    libebook.declare("e_contact_pretty_name",
                     ctypes.default_abi,
                     LibGLib.gchar.ptr,
                     EContactField);
  if (!e_contact_pretty_name)
    throw "e_contact_pretty_name is unavailable";

  return e_contact_pretty_name;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_get", function() {
  var e_contact_get =
    libebook.declare("e_contact_get",
                     ctypes.default_abi,
                     LibGLib.gpointer,
                     EContact.ptr,
                     EContactField);
  if (!e_contact_get)
    throw "e_contact_get is unavailable";

  return e_contact_get;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_get_attributes", function() {
  var e_contact_get_attributes =
    libebook.declare("e_contact_get_attributes",
                     ctypes.default_abi,
                     LibGLib.GList.ptr,
                     EContact.ptr,
                     EContactField);
  if (!e_contact_get_attributes)
    throw "e_contact_get_attributes is unavailable";

  return e_contact_get_attributes;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_get_const", function() {
  var e_contact_get_const =
    libebook.declare("e_contact_get_const",
                     ctypes.default_abi,
                     LibGLib.gconstpointer,
                     EContact.ptr,
                     EContactField);
  if (!e_contact_get_const)
    throw "e_contact_get_const is unavailable";

  return e_contact_get_const;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_name_free", function() {
  var e_contact_name_free =
    libebook.declare("e_contact_name_free",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EContactName.ptr);
  if (!e_contact_name_free)
    throw "e_contact_name_free is unavailable";

  return e_contact_name_free;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_name_from_string", function() {
  var e_contact_name_from_string =
    libebook.declare("e_contact_name_from_string",
                     ctypes.default_abi,
                     EContactName.ptr,
                     LibGLib.gchar.ptr);
  if (!e_contact_name_from_string)
    throw "e_contact_name_from_string is unavailable";

  return e_contact_name_from_string;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_name_new", function() {
  var e_contact_name_new =
    libebook.declare("e_contact_name_new",
                     ctypes.default_abi,
                     EContactName.ptr);
  if (!e_contact_name_new)
    throw "e_contact_name_new is unavailable";

  return e_contact_name_new;
});


XPCOMUtils.defineLazyGetter(this, "e_contact_new", function() {
  var e_contact_new =
    libebook.declare("e_contact_new",
                     ctypes.default_abi,
                     EContact.ptr)
  if (!e_contact_new)
    throw "e_contact_new is unavailable";

  return e_contact_new;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_set", function() {
  var e_contact_set =
    libebook.declare("e_contact_set",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EContact.ptr,
                     EContactField,
                     LibGLib.gconstpointer);
  if (!e_contact_set)
    throw "e_contact_set is unavailable";

  return e_contact_set;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_set_attributes", function() {
  var e_contact_set_attributes =
    libebook.declare("e_contact_set_attributes",
                     ctypes.default_abi,
                     ctypes.void_t,
                     EContact.ptr,
                     EContactField,
                     LibGLib.GList.ptr);
  if (!e_contact_set_attributes)
    throw "e_contact_set_attributes is unavailable";

  return e_contact_set_attributes;
});

XPCOMUtils.defineLazyGetter(this, "e_contact_vcard_attribute", function() {
  var e_contact_vcard_attribute =
    libebook.declare("e_contact_vcard_attribute",
                     ctypes.default_abi,
                     LibGLib.gchar.ptr,
                     EContactField);

  if (!e_contact_vcard_attribute)
    throw "e_contact_vcard_attribute is unavailable";

  return e_contact_vcard_attribute;
});


var LibEContact = {
  EContact: EContact,
  EContactAddress: EContactAddress,
  EContactDate: EContactDate,
  EContactName: EContactName,
  EContactPhoto: EContactPhoto,
  E_CONTACT_PHOTO_TYPE_INLINED: 0,
  E_CONTACT_PHOTO_TYPE_URI: 1,



  castPtr: function LEC_castPtr(aPointer) {
    return ctypes.cast(aPointer, EContact.ptr);
  },

  duplicate: function LEC_duplicate(aEContact) {
    return e_contact_duplicate(aEContact);
  },

  freePhoto: function LEC_freePhoto(aEContactPhoto) {
    e_contact_photo_free(aEContactPhoto);
  },

  getAttributesRaw: function LEV_getAttributesRaw(aEContact, aEContactField) {
    return e_contact_get_attributes(aEContact, aEContactField);
  },

  getAttributes: function LEC_getAttributes(aEContact, aEContactField) {
    let attrs = e_contact_get_attributes(aEContact, aEContactField);
    for (let l = attrs; !l.isNull(); l = l.contents.next) {
      yield l.contents.data;
    }
    yield null;
  },

  getStringProp: function LEC_getStringProp(aEContact, aProp) {
    let aPtr = this.getProp(aEContact, aProp);
    if (aPtr.isNull())
      return null;
    let strValue = ctypes.cast(aPtr, LibGLib.gchar.ptr);
    let result = strValue.readString();
    LibGLib.g_free(aPtr);
    return result;
  },

  getStringConstProp: function LEC_getStringConstProp(aEContact, aProp) {
    let aPtr = this.getConstProp(aEContact, aProp);
    if (aPtr.isNull())
      return null;
    let strValue = ctypes.cast(aPtr, LibGLib.gchar.ptr);
    let result = strValue.readString();
    return result;
  },

  getProp: function LEC_getProp(aEContact, aEContactField) {
    return e_contact_get(aEContact, aEContactField);
  },

  setProp: function LEC_setProp(aEContact, aEContactField, aValue) {
    return e_contact_set(aEContact, aEContactField, aValue);
  },

  getPropList: function LEC_getPropList(aEContact, aEContactField) {
    let aPtr = this.getProp(aEContact, aEContactField);
    let glist = ctypes.cast(aPtr, LibGLib.GList.ptr);
    for (let l = glist; !l.isNull(); l = l.contents.next) {
      yield l.contents.data;
    }
    LibGLib.g_list_free(glist);
    yield null;
  },

  getConstProp: function LEC_getConstProp(aEContact, aEContactField) {
    return e_contact_get_const(aEContact, aEContactField);
  },

  getFieldPrettyName: function LEC_getFieldPrettyName(aEContactField) {
    let result = e_contact_pretty_name(aEContactField);
    if (result.isNull())
      return null;
    let strValue = ctypes.cast(result, LibGLib.gchar.ptr);
    return strValue.readString();
  },

  getFieldName: function LEC_getFieldName(aEContactField) {
    let result = e_contact_field_name(aEContactField);
    if (result.isNull())
      return null;
    let strValue = ctypes.cast(result, LibGLib.gchar.ptr);
    return strValue.readString();
  },

  fieldId: function LEC_fieldId(aFieldName) {
    let result = e_contact_field_id(aFieldName);
    return this.toEnum(result);
  },

  getEnum: function LEC_enum(aEnum) {
    let enumIndex = this.ENUMS.indexOf(aEnum);
    if (enumIndex != -1) {
      // EContact enums are 1-indexed
      return enumIndex + 1;
    }
    // Now for the special enums...
    if (this.SPECIAL_ENUMS[aEnum])
      return this.getEnum(this.SPECIAL_ENUMS[aEnum]);

    throw("Did not recognize the enum: " + aEnum);
  },

  toEnum: function LEC_toEnum(aFieldId) {
    // Convert to 0'th indexed
    aFieldId--;
    if (aFieldId < 0 || aFieldId > this.ENUMS.length)
      return null;
    return this.ENUMS[aFieldId];
  },

  newEContact: function LEC_newEContact() {
    return e_contact_new();
  },

  newName: function LEC_newName() {
    return e_contact_name_new();
  },

  addressNew: function LEC_addressNew() {
    return e_contact_address_new();
  },

  addressFree: function LEC_addressFree(aEContactAddress) {
    e_contact_address_free(aEContactAddress);
  },

  addressGetType: function LEC_addressGetType() {
    return e_contact_address_get_type();
  },

  dateFree: function LEC_dateFree(aEContactDate) {
    e_contact_date_free(aEContactDate);
  },

  nameFree: function LEC_nameFree(aEContactName) {
    e_contact_name_free(aEContactName);
  },

  nameFromString: function LEC_stringToName(aString) {
    return e_contact_name_from_string(aString);
  },

  setAttributes: function LEC_setAttributes(aEContact, aEnum, aGList) {
    return e_contact_set_attributes(aEContact, aEnum, aGList);
  },

  vcardAttribute: function LEC_vcardAttribute(aEContactField) {
    return e_contact_vcard_attribute(aEContactField);
  },

  /* useful constants */
  SPECIAL_ENUMS: {"E_CONTACT_FIELD_FIRST": "E_CONTACT_UID",
                  "E_CONTACT_LAST_SIMPLE_STRING": "E_CONTACT_NAME_OR_ORG",
                  "E_CONTACT_FIRST_PHONE_ID": "E_CONTACT_PHONE_ASSISTANT",
                  "E_CONTACT_LAST_PHONE_ID": "E_CONTACT_PHONE_TTYTDD",
                  "E_CONTACT_FIRST_EMAIL_ID": "E_CONTACT_EMAIL_1",
                  "E_CONTACT_LAST_EMAIL_ID": "E_CONTACT_EMAIL_4",
                  "E_CONTACT_FIRST_ADDRESS_ID": "E_CONTACT_ADDRESS_HOME",
                  "E_CONTACT_LAST_ADDRESS_ID": "E_CONTACT_ADDRESS_OTHER",
                  "E_CONTACT_FIRST_LABEL_ID": "E_CONTACT_ADDRESS_LABEL_HOME",
                  "E_CONTACT_LAST_LABEL_ID": "E_CONTACT_ADDRESS_LABEL_OTHER"},

  ENUMS: ["E_CONTACT_UID",  /* string field */
          "E_CONTACT_FILE_AS",   /* string field */
          "E_CONTACT_BOOK_URI",      /* string field */

          /* Name fields */
          "E_CONTACT_FULL_NAME",   /* string field */
          "E_CONTACT_GIVEN_NAME",  /* synthetic string field */
          "E_CONTACT_FAMILY_NAME",   /* synthetic string field */
          "E_CONTACT_NICKNAME",  /* string field */

          /* Email fields */
          "E_CONTACT_EMAIL_1",   /* synthetic string field */
          "E_CONTACT_EMAIL_2",   /* synthetic string field */
          "E_CONTACT_EMAIL_3",   /* synthetic string field */
          "E_CONTACT_EMAIL_4",       /* synthetic string field */

          "E_CONTACT_MAILER",        /* string field */

           /* Address Labels */
          "E_CONTACT_ADDRESS_LABEL_HOME",  /* synthetic string field */
          "E_CONTACT_ADDRESS_LABEL_WORK",  /* synthetic string field */
          "E_CONTACT_ADDRESS_LABEL_OTHER", /* synthetic string field */

          /* Phone fields */
          "E_CONTACT_PHONE_ASSISTANT",
          "E_CONTACT_PHONE_BUSINESS",
          "E_CONTACT_PHONE_BUSINESS_2",
          "E_CONTACT_PHONE_BUSINESS_FAX",
          "E_CONTACT_PHONE_CALLBACK",
          "E_CONTACT_PHONE_CAR",
          "E_CONTACT_PHONE_COMPANY",
          "E_CONTACT_PHONE_HOME",
          "E_CONTACT_PHONE_HOME_2",
          "E_CONTACT_PHONE_HOME_FAX",
          "E_CONTACT_PHONE_ISDN",
          "E_CONTACT_PHONE_MOBILE",
          "E_CONTACT_PHONE_OTHER",
          "E_CONTACT_PHONE_OTHER_FAX",
          "E_CONTACT_PHONE_PAGER",
          "E_CONTACT_PHONE_PRIMARY",
          "E_CONTACT_PHONE_RADIO",
          "E_CONTACT_PHONE_TELEX",
          "E_CONTACT_PHONE_TTYTDD",


          /* Organizational fields */
          "E_CONTACT_ORG",     /* string field */
          "E_CONTACT_ORG_UNIT",  /* string field */
          "E_CONTACT_OFFICE",  /* string field */
          "E_CONTACT_TITLE",   /* string field */
          "E_CONTACT_ROLE",  /* string field */
          "E_CONTACT_MANAGER",   /* string field */
          "E_CONTACT_ASSISTANT",   /* string field */

          /* Web fields */
          "E_CONTACT_HOMEPAGE_URL",  /* string field */
          "E_CONTACT_BLOG_URL",      /* string field */

          /* Contact categories */
          "E_CONTACT_CATEGORIES",    /* string field */

          /* Collaboration fields */
          "E_CONTACT_CALENDAR_URI",  /* string field */
          "E_CONTACT_FREEBUSY_URL",  /* string field */
          "E_CONTACT_ICS_CALENDAR",  /* string field */
          "E_CONTACT_VIDEO_URL",      /* string field */

          /* misc fields */
          "E_CONTACT_SPOUSE",        /* string field */
          "E_CONTACT_NOTE",          /* string field */

          "E_CONTACT_IM_AIM_HOME_1",       /* Synthetic string field */
          "E_CONTACT_IM_AIM_HOME_2",       /* Synthetic string field */
          "E_CONTACT_IM_AIM_HOME_3",       /* Synthetic string field */
          "E_CONTACT_IM_AIM_WORK_1",       /* Synthetic string field */
          "E_CONTACT_IM_AIM_WORK_2",       /* Synthetic string field */
          "E_CONTACT_IM_AIM_WORK_3",       /* Synthetic string field */
          "E_CONTACT_IM_GROUPWISE_HOME_1", /* Synthetic string field */
          "E_CONTACT_IM_GROUPWISE_HOME_2", /* Synthetic string field */
          "E_CONTACT_IM_GROUPWISE_HOME_3", /* Synthetic string field */
          "E_CONTACT_IM_GROUPWISE_WORK_1", /* Synthetic string field */
          "E_CONTACT_IM_GROUPWISE_WORK_2", /* Synthetic string field */
          "E_CONTACT_IM_GROUPWISE_WORK_3", /* Synthetic string field */
          "E_CONTACT_IM_JABBER_HOME_1",    /* Synthetic string field */
          "E_CONTACT_IM_JABBER_HOME_2",    /* Synthetic string field */
          "E_CONTACT_IM_JABBER_HOME_3",    /* Synthetic string field */
          "E_CONTACT_IM_JABBER_WORK_1",    /* Synthetic string field */
          "E_CONTACT_IM_JABBER_WORK_2",    /* Synthetic string field */
          "E_CONTACT_IM_JABBER_WORK_3",    /* Synthetic string field */
          "E_CONTACT_IM_YAHOO_HOME_1",     /* Synthetic string field */
          "E_CONTACT_IM_YAHOO_HOME_2",     /* Synthetic string field */
          "E_CONTACT_IM_YAHOO_HOME_3",     /* Synthetic string field */
          "E_CONTACT_IM_YAHOO_WORK_1",     /* Synthetic string field */
          "E_CONTACT_IM_YAHOO_WORK_2",     /* Synthetic string field */
          "E_CONTACT_IM_YAHOO_WORK_3",     /* Synthetic string field */
          "E_CONTACT_IM_MSN_HOME_1",       /* Synthetic string field */
          "E_CONTACT_IM_MSN_HOME_2",       /* Synthetic string field */
          "E_CONTACT_IM_MSN_HOME_3",       /* Synthetic string field */
          "E_CONTACT_IM_MSN_WORK_1",       /* Synthetic string field */
          "E_CONTACT_IM_MSN_WORK_2",       /* Synthetic string field */
          "E_CONTACT_IM_MSN_WORK_3",       /* Synthetic string field */
          "E_CONTACT_IM_ICQ_HOME_1",       /* Synthetic string field */
          "E_CONTACT_IM_ICQ_HOME_2",       /* Synthetic string field */
          "E_CONTACT_IM_ICQ_HOME_3",       /* Synthetic string field */
          "E_CONTACT_IM_ICQ_WORK_1",       /* Synthetic string field */
          "E_CONTACT_IM_ICQ_WORK_2",       /* Synthetic string field */
          "E_CONTACT_IM_ICQ_WORK_3",       /* Synthetic string field */

          /* Convenience field for getting a name from the contact.
             Returns the first one of[File-As, Full Name, Org, Email1]
             to be set */
          "E_CONTACT_REV",     /* string field to hold  time of last update to this vcard*/
          "E_CONTACT_NAME_OR_ORG",

          /* Address fields */
          "E_CONTACT_ADDRESS",       /* Multi-valued structured (EContactAddress) */
          "E_CONTACT_ADDRESS_HOME",  /* synthetic structured field (EContactAddress) */
          "E_CONTACT_ADDRESS_WORK",  /* synthetic structured field (EContactAddress) */
          "E_CONTACT_ADDRESS_OTHER", /* synthetic structured field (EContactAddress) */

          "E_CONTACT_CATEGORY_LIST", /* multi-valued */

          /* Photo/Logo */
          "E_CONTACT_PHOTO",   /* structured field (EContactPhoto) */
          "E_CONTACT_LOGO",  /* structured field (EContactPhoto) */

          "E_CONTACT_NAME",    /* structured field (EContactName) */
          "E_CONTACT_EMAIL",   /* Multi-valued */

          /* Instant Messaging fields */
          "E_CONTACT_IM_AIM",  /* Multi-valued */
          "E_CONTACT_IM_GROUPWISE",  /* Multi-valued */
          "E_CONTACT_IM_JABBER",   /* Multi-valued */
          "E_CONTACT_IM_YAHOO",  /* Multi-valued */
          "E_CONTACT_IM_MSN",  /* Multi-valued */
          "E_CONTACT_IM_ICQ",  /* Multi-valued */

          "E_CONTACT_WANTS_HTML",    /* boolean field */

          /* fields used for describing contact lists.  a contact list
             is just a contact with _IS_LIST set to true.  the members
             are listed in the _EMAIL field. */
          "E_CONTACT_IS_LIST",             /* boolean field */
          "E_CONTACT_LIST_SHOW_ADDRESSES", /* boolean field */

          "E_CONTACT_BIRTH_DATE",    /* structured field (EContactDate) */
          "E_CONTACT_ANNIVERSARY",   /* structured field (EContactDate) */

          /* Security Fields */
          "E_CONTACT_X509_CERT",     /* structured field (EContactCert) */

          "E_CONTACT_IM_GADUGADU_HOME_1",  /* Synthetic string field */
          "E_CONTACT_IM_GADUGADU_HOME_2",  /* Synthetic string field */
          "E_CONTACT_IM_GADUGADU_HOME_3",  /* Synthetic string field */
          "E_CONTACT_IM_GADUGADU_WORK_1",  /* Synthetic string field */
          "E_CONTACT_IM_GADUGADU_WORK_2",  /* Synthetic string field */
          "E_CONTACT_IM_GADUGADU_WORK_3",  /* Synthetic string field */

          "E_CONTACT_IM_GADUGADU",   /* Multi-valued */

          "E_CONTACT_GEO", /* structured field (EContactGeo) */

          "E_CONTACT_TEL", /* list of strings */

          "E_CONTACT_IM_SKYPE_HOME_1",     /* Synthetic string field */
          "E_CONTACT_IM_SKYPE_HOME_2",     /* Synthetic string field */
          "E_CONTACT_IM_SKYPE_HOME_3",     /* Synthetic string field */
          "E_CONTACT_IM_SKYPE_WORK_1",     /* Synthetic string field */
          "E_CONTACT_IM_SKYPE_WORK_2",     /* Synthetic string field */
          "E_CONTACT_IM_SKYPE_WORK_3",     /* Synthetic string field */
          "E_CONTACT_IM_SKYPE",   /* Multi-valued */

          "E_CONTACT_SIP",

          "E_CONTACT_FIELD_LAST"]
}
