/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibECredentials" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://edsintegration/libedataserver-ctypes.jsm");
Cu.import("resource://edsintegration/LibGLib.jsm");


XPCOMUtils.defineLazyGetter(this, "ECredentials", function() {
  return ctypes.StructType("ECredentials");
});

XPCOMUtils.defineLazyGetter(this, "e_credentials_free", function() {
  var e_credentials_free =
    libedataserver.declare("e_credentials_free",
                           ctypes.default_abi,
                           ctypes.void_t,
                           ECredentials.ptr);

  if (!e_credentials_free)
    throw "e_credentials_free is unavailable";

  return e_credentials_free;
});


XPCOMUtils.defineLazyGetter(this, "e_credentials_new", function() {
  var e_credentials_new =
    libedataserver.declare("e_credentials_new",
                           ctypes.default_abi,
                           ECredentials.ptr);

  if (!e_credentials_new)
    throw "e_credentials_new is unavailable";

  return e_credentials_new;
});

XPCOMUtils.defineLazyGetter(this, "e_credentials_new_clone", function() {
  var e_credentials_new_clone =
    libedataserver.declare("e_credentials_new_clone",
                           ctypes.default_abi,
                           ECredentials.ptr,
                           ECredentials.ptr);

  if (!e_credentials_new_clone)
    throw "e_credentials_new_clone is unavailable";

  return e_credentials_new_clone;
});


XPCOMUtils.defineLazyGetter(this, "e_credentials_peek", function() {
  var e_credentials_peek =
    libedataserver.declare("e_credentials_peek",
                           ctypes.default_abi,
                           LibGLib.gchar.ptr,
                           ECredentials.ptr,
                           LibGLib.gchar.ptr);

  if (!e_credentials_peek)
    throw "e_credentials_peek is unavailable";

  return e_credentials_peek;
});


XPCOMUtils.defineLazyGetter(this, "e_credentials_set", function() {
  var e_credentials_set =
    libedataserver.declare("e_credentials_set",
                           ctypes.default_abi,
                           ctypes.void_t,
                           ECredentials.ptr,
                           LibGLib.gchar.ptr,
                           LibGLib.gchar.ptr);

  if (!e_credentials_set)
    throw "e_credentials_set is unavailable";

  return e_credentials_set;
});


var LibECredentials = {

  E_CREDENTIALS_KEY_USERNAME: "username",
  E_CREDENTIALS_KEY_PASSWORD:  "password",
  E_CREDENTIALS_KEY_AUTH_METHOD: "auth-method",
  E_CREDENTIALS_KEY_AUTH_DOMAIN: "auth-domain",
  E_CREDENTIALS_KEY_PROMPT_TITLE:  "prompt-title",
  E_CREDENTIALS_KEY_PROMPT_TEXT: "prompt-text",
  E_CREDENTIALS_KEY_PROMPT_REASON: "prompt-reason",
  E_CREDENTIALS_KEY_PROMPT_KEY: "prompt-key",
  E_CREDENTIALS_KEY_PROMPT_FLAGS: "prompt-flags",

  E_CREDENTIALS_AUTH_DOMAIN_ADDRESSBOOK: "Addressbook",
  E_CREDENTIALS_AUTH_DOMAIN_CALENDAR: "Calendar",
  E_CREDENTIALS_AUTH_DOMAIN_MAIL: "Mail",
  E_CREDENTIALS_USED: "used",

  ECredentials: ECredentials,

  free: function LECR_free(aECredentials) {
    return e_credentials_free(aECredentials);
  },

  newClone: function LECR_clone(aECredentials) {
    return e_credentials_new_clone(aECredentials);
  },

  newECredentials: function LECR_newECredentials() {
    return e_credentials_new();
  },

  peek: function LECR_peek(aECredentials, aKey) {
    let resultPtr = e_credentials_peek(aECredentials, aKey);
    if (resultPtr.isNull())
      return null;
    return resultPtr.readString();
  },

  set: function LECR_set(aECredentials, aKey, aValue) {
    return e_credentials_set(aECredentials, aKey, aValue);
  }

}
