/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibEUri" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");

Cu.import("resource://edsintegration/LibGLib.jsm");
Cu.import("resource://edsintegration/libedataserver-ctypes.jsm");


XPCOMUtils.defineLazyGetter(this, "EUri", function() {
  return ctypes.StructType("EBookView");
});

XPCOMUtils.defineLazyGetter(this, "e_uri_free", function() {
  var e_uri_free =
    libedataserver.declare("e_uri_free",
                           ctypes.default_abi,
                           ctypes.void_t,
                           EUri.ptr);
  if (!e_uri_free)
    throw "e_uri_free is unavailable";

  return e_uri_free;
});

XPCOMUtils.defineLazyGetter(this, "e_uri_new", function() {
  var e_uri_new =
    libedataserver.declare("e_uri_new",
                           ctypes.default_abi,
                           EUri.ptr,
                           LibGLib.gchar.ptr);
  if (!e_uri_new)
    throw "e_uri_new is unavailable";

  return e_uri_new;
});

XPCOMUtils.defineLazyGetter(this, "e_uri_to_string", function() {
  var e_uri_to_string =
    libedataserver.declare("e_uri_to_string",
                           ctypes.default_abi,
                           LibGLib.gchar.ptr,
                           EUri.ptr,
                           LibGLib.gboolean);
  if (!e_uri_to_string)
    throw "e_uri_to_string is unavailable";

  return e_uri_to_string;
});


var LibEUri = {
  EUri: EUri,
  
  newEUri: function LE_newEUri(aURI) {
    return e_uri_new(aURI);
  },

  EUriToString: function LE_EUriToString(aEUri, aShowPassword) {
    let resultPtr = e_uri_to_string(aEUri, aShowPassword);
    if (!resultPtr || resultPtr.isNull())
      return null;
    return resultPtr.readString();
  },

  EUriFree: function LE_EUriFree(aEUri) {
    e_uri_free(aEUri);
  },

  castPtr: function LEBV_castPtr(aPointer) {
    return ctypes.cast(aPointer, EBookView.ptr);
  }
}
