#!/usr/bin/python

import sys
import fontforge

import kern_class2pairs as c2p

flags = ("round", "opentype", "dummy-dsig")

def main(infile, outfile):
	font = fontforge.open(infile)
	c2p.class2pair(None,font)
	font.generate(outfile, flags=flags)

if __name__ == '__main__':
    if len(sys.argv) < 3:
        sys.exit("Usage: %s file.sfd file.ttf" % sys.argv[0])
    main(sys.argv[1], sys.argv[2])
