/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __SYNCDAEMON_STATUS_INFO_H__
#define __SYNCDAEMON_STATUS_INFO_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_STATUS_INFO                (syncdaemon_status_info_get_type ())
#define SYNCDAEMON_STATUS_INFO(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_STATUS_INFO, SyncdaemonStatusInfo))
#define SYNCDAEMON_IS_STATUS_INFO(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_STATUS_INFO))
#define SYNCDAEMON_STATUS_INFO_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_STATUS_INFO, SyncdaemonStatusInfoClass))
#define SYNCDAEMON_IS_STATUS_INFO_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_STATUS_INFO))
#define SYNCDAEMON_STATUS_INFO_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_STATUS_INFO, SyncdaemonStatusInfoClass))

typedef struct _SyncdaemonStatusInfoPrivate SyncdaemonStatusInfoPrivate;

typedef struct {
	GObject parent;
	SyncdaemonStatusInfoPrivate *priv;
} SyncdaemonStatusInfo;

typedef struct {
	GObjectClass parent_class;
} SyncdaemonStatusInfoClass;

GType                 syncdaemon_status_info_get_type (void);

SyncdaemonStatusInfo *syncdaemon_status_info_new (void);
SyncdaemonStatusInfo *syncdaemon_status_info_new_from_hash_table (GHashTable *hash);

const gchar          *syncdaemon_status_info_get_connection (SyncdaemonStatusInfo *sinfo);
void                  syncdaemon_status_info_set_connection (SyncdaemonStatusInfo *sinfo, const gchar *connection);
gboolean              syncdaemon_status_info_get_connected (SyncdaemonStatusInfo *sinfo);
void                  syncdaemon_status_info_set_connected (SyncdaemonStatusInfo *sinfo, gboolean connected);
const gchar          *syncdaemon_status_info_get_description (SyncdaemonStatusInfo *sinfo);
void                  syncdaemon_status_info_set_description (SyncdaemonStatusInfo *sinfo, const gchar *description);
const gchar          *syncdaemon_status_info_get_name (SyncdaemonStatusInfo *sinfo);
void                  syncdaemon_status_info_set_name (SyncdaemonStatusInfo *sinfo, const gchar *name);
gboolean              syncdaemon_status_info_get_online (SyncdaemonStatusInfo *sinfo);
void                  syncdaemon_status_info_set_online (SyncdaemonStatusInfo *sinfo, gboolean connected);
const gchar          *syncdaemon_status_info_get_queues (SyncdaemonStatusInfo *sinfo);
void                  syncdaemon_status_info_set_queues (SyncdaemonStatusInfo *sinfo, const gchar *queues);

G_END_DECLS

#endif
