/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __SYNCDAEMON_STATUS_INTERFACE_H__
#define __SYNCDAEMON_STATUS_INTERFACE_H__

#include "syncdaemon-daemon.h"
#include "syncdaemon-interface.h"
#include "syncdaemon-transfer-info.h"

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_STATUS_INTERFACE                (syncdaemon_status_interface_get_type ())
#define SYNCDAEMON_STATUS_INTERFACE(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_STATUS_INTERFACE, SyncdaemonStatusInterface))
#define SYNCDAEMON_IS_STATUS_INTERFACE(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_STATUS_INTERFACE))
#define SYNCDAEMON_STATUS_INTERFACE_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_STATUS_INTERFACE, SyncdaemonStatusInterfaceClass))
#define SYNCDAEMON_IS_STATUS_INTERFACE_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_STATUS_INTERFACE))
#define SYNCDAEMON_STATUS_INTERFACE_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_STATUS_INTERFACE, SyncdaemonStatusInterfaceClass))

typedef struct _SyncdaemonStatusInterfacePrivate SyncdaemonStatusInterfacePrivate;

typedef struct {
	SyncdaemonInterface parent;
	SyncdaemonStatusInterfacePrivate *priv;
} SyncdaemonStatusInterface;

typedef struct {
	SyncdaemonInterfaceClass parent_class;
} SyncdaemonStatusInterfaceClass;

GType                      syncdaemon_status_interface_get_type (void);

SyncdaemonStatusInterface *syncdaemon_status_interface_new (SyncdaemonDaemon *daemon);
SyncdaemonStatusInfo      *syncdaemon_status_interface_get_current_status (SyncdaemonStatusInterface *interface);
GSList                    *syncdaemon_status_interface_get_current_downloads (SyncdaemonStatusInterface *interface);
GSList                    *syncdaemon_status_interface_get_current_uploads (SyncdaemonStatusInterface *interface);

G_END_DECLS

#endif
