"""Platform related code."""
import sys

setup_action_queue_test = None
setup_main_test = None
get_main_params = None
_GeneralINotifyProcessor = None
IPCTestCase = None

if sys.platform.startswith('linux'):
    from tests.platform import linux as linux_test
    setup_action_queue_test = linux_test.setup_action_queue_test
    setup_main_test = linux_test.setup_main_test
    get_main_params = linux_test.get_main_params
    from ubuntuone.platform.linux import filesystem_notifications
    _GeneralINotifyProcessor = filesystem_notifications._GeneralINotifyProcessor
    from tests.platform.linux.test_dbus import DBusTwistedTestCase
    IPCTestCase = DBusTwistedTestCase
else:
    from tests.platform import windows as windows_test
    setup_action_queue_test = windows_test.setup_action_queue_test
    setup_main_test = windows_test.setup_main_test
    get_main_params = windows_test.get_main_params
    from ubuntuone.platform.windows import filesystem_notifications
    _GeneralINotifyProcessor = filesystem_notifications.NotifyProcessor
    from tests.platform.windows.test_ipc import PerspectiveBrokerTestCase
    IPCTestCase = PerspectiveBrokerTestCase

