# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Linux test code."""



def _setup_service_busname(testcase):
    # monkeypatch __del__ to avoid issues with gc
    import dbus
    dbus.service.BusName.__del__ = lambda _: None

setup_action_queue_test = _setup_service_busname

setup_main_test = _setup_service_busname


def get_main_params(testcase, params):
    """Return the parameters used to create the main object for tests."""
    from dbus.mainloop.glib import DBusGMainLoop
    # set glib_loop and return the common params
    params['glib_loop'] = DBusGMainLoop(set_as_default=True)
    return params
