# tests.platform.windows.test_tools_irl
#
# Author: Manuel de la Pena <manuel@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Small example of how to use the sdtools on windows."""

# we use the standard reactor on windows
from twisted.internet import reactor, defer
from ubuntuone.platform.windows import tools


@defer.inlineCallbacks
def print_test():
    """Print the current downloads."""
    sdtool = tools.SyncDaemonTool()
    yield sdtool.client.connect()
    result = yield sdtool.get_current_downloads()
    print 'Current downloads are: '
    for download in result:
        print download
    result = yield sdtool.get_current_uploads()
    print 'Current Uplaods are: '
    for upload in result:
        print upload
    print 'The current config is:'
    shares_link = yield sdtool.get_shares_dir_link()
    print '\tShares link: %s' % shares_link
    shares_dir = yield sdtool.get_shares_dir()
    print '\tShares dir: %s' % shares_dir
    root_dir = yield sdtool.get_root_dir()
    print '\tRoot dir: %s' % root_dir
    is_udf_autosubscribe_enabled = yield sdtool.is_udf_autosubscribe_enabled()
    print '\tAutosubscribe enabled: %s' % is_udf_autosubscribe_enabled
    is_share_autosubscribe_enabled = yield sdtool.is_share_autosubscribe_enabled()
    print '\tAutosubscribe enabled: %s' % is_share_autosubscribe_enabled
    is_show_all_notifications_enabled =\
                            yield sdtool.is_show_all_notifications_enabled()
    print '\tShow all notifications: %s' % is_show_all_notifications_enabled
    reactor.stop()
    

if __name__ == '__main__':
    reactor.callLater(0, print_test)
    reactor.run()
