/* daemon.c generated by valac 0.12.0, the Vala compiler
 * generated from daemon.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <unity.h>
#include <unity-package-search.h>
#include <zeitgeist.h>
#include <gee.h>
#include <gio/gio.h>
#include <gnome-menus/gmenu-tree.h>
#include <dee.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>


#define UNITY_APPLICATIONS_PLACE_TYPE_DAEMON (unity_applications_place_daemon_get_type ())
#define UNITY_APPLICATIONS_PLACE_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, UnityApplicationsPlaceDaemon))
#define UNITY_APPLICATIONS_PLACE_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, UnityApplicationsPlaceDaemonClass))
#define UNITY_APPLICATIONS_PLACE_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON))
#define UNITY_APPLICATIONS_PLACE_IS_DAEMON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON))
#define UNITY_APPLICATIONS_PLACE_DAEMON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, UnityApplicationsPlaceDaemonClass))

typedef struct _UnityApplicationsPlaceDaemon UnityApplicationsPlaceDaemon;
typedef struct _UnityApplicationsPlaceDaemonClass UnityApplicationsPlaceDaemonClass;
typedef struct _UnityApplicationsPlaceDaemonPrivate UnityApplicationsPlaceDaemonPrivate;

#define UNITY_APPLICATIONS_PLACE_TYPE_RUNNER (unity_applications_place_runner_get_type ())
#define UNITY_APPLICATIONS_PLACE_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_APPLICATIONS_PLACE_TYPE_RUNNER, UnityApplicationsPlaceRunner))
#define UNITY_APPLICATIONS_PLACE_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_APPLICATIONS_PLACE_TYPE_RUNNER, UnityApplicationsPlaceRunnerClass))
#define UNITY_APPLICATIONS_PLACE_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_APPLICATIONS_PLACE_TYPE_RUNNER))
#define UNITY_APPLICATIONS_PLACE_IS_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_APPLICATIONS_PLACE_TYPE_RUNNER))
#define UNITY_APPLICATIONS_PLACE_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_APPLICATIONS_PLACE_TYPE_RUNNER, UnityApplicationsPlaceRunnerClass))

typedef struct _UnityApplicationsPlaceRunner UnityApplicationsPlaceRunner;
typedef struct _UnityApplicationsPlaceRunnerClass UnityApplicationsPlaceRunnerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _unity_package_searcher_free0(var) ((var == NULL) ? NULL : (var = (unity_package_searcher_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _gmenu_tree_unref0(var) ((var == NULL) ? NULL : (var = (gmenu_tree_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define UNITY_APPLICATIONS_PLACE_TYPE_GROUP (unity_applications_place_group_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_APPLICATIONS_PLACE_TYPE_SECTION (unity_applications_place_section_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _unity_package_search_result_free0(var) ((var == NULL) ? NULL : (var = (unity_package_search_result_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _UnityApplicationsPlaceDaemonUpdateEntrySearchData UnityApplicationsPlaceDaemonUpdateEntrySearchData;
typedef struct _UnityApplicationsPlaceDaemonUpdateGlobalSearchData UnityApplicationsPlaceDaemonUpdateGlobalSearchData;
typedef struct _UnityApplicationsPlaceDaemonActivateData UnityApplicationsPlaceDaemonActivateData;
typedef struct _UnityApplicationsPlaceRunnerPrivate UnityApplicationsPlaceRunnerPrivate;

struct _UnityApplicationsPlaceDaemon {
	GObject parent_instance;
	UnityApplicationsPlaceDaemonPrivate * priv;
	UnityPackageSearcher* appsearcher;
};

struct _UnityApplicationsPlaceDaemonClass {
	GObjectClass parent_class;
};

struct _UnityApplicationsPlaceDaemonPrivate {
	ZeitgeistLog* log;
	ZeitgeistIndex* zg_index;
	UnityPackageSearcher* pkgsearcher;
	UnityPlaceController* control;
	UnityPlaceEntryInfo* applications;
	UnityApplicationsPlaceRunner* runner;
	GeeList* section_queries;
	GeeList* image_extensions;
	GHashTable* file_icon_cache;
	UnityPlaceSearch* previous_search;
	UnityPlaceSearch* previous_global_search;
	guint previous_active_section;
	GPtrArray* zg_templates;
	guint app_menu_changed_reindex_timeout;
	GMenuTree* app_menu;
	gboolean all_models_synced;
	GRegex* uri_regex;
};

typedef enum  {
	UNITY_APPLICATIONS_PLACE_GROUP_MOST_USED,
	UNITY_APPLICATIONS_PLACE_GROUP_INSTALLED,
	UNITY_APPLICATIONS_PLACE_GROUP_AVAILABLE,
	UNITY_APPLICATIONS_PLACE_GROUP_EMPTY_SEARCH,
	UNITY_APPLICATIONS_PLACE_GROUP_EMPTY_SECTION
} UnityApplicationsPlaceGroup;

typedef enum  {
	UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS = 0,
	UNITY_APPLICATIONS_PLACE_SECTION_ACCESSORIES,
	UNITY_APPLICATIONS_PLACE_SECTION_UNIVERSAL_ACCESS,
	UNITY_APPLICATIONS_PLACE_SECTION_DEVELOPER_TOOLS,
	UNITY_APPLICATIONS_PLACE_SECTION_EDUCATION,
	UNITY_APPLICATIONS_PLACE_SECTION_SCIENCE,
	UNITY_APPLICATIONS_PLACE_SECTION_GAMES,
	UNITY_APPLICATIONS_PLACE_SECTION_GRAPHICS,
	UNITY_APPLICATIONS_PLACE_SECTION_INTERNET,
	UNITY_APPLICATIONS_PLACE_SECTION_MULTIMEDIA,
	UNITY_APPLICATIONS_PLACE_SECTION_OFFICE,
	UNITY_APPLICATIONS_PLACE_SECTION_THEMES,
	UNITY_APPLICATIONS_PLACE_SECTION_SYSTEM,
	UNITY_APPLICATIONS_PLACE_SECTION_LAST_SECTION
} UnityApplicationsPlaceSection;

struct _UnityApplicationsPlaceDaemonUpdateEntrySearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsPlaceDaemon* self;
	UnityPlaceSearch* search;
	UnityApplicationsPlaceSection section;
	UnityPlaceRendererInfo* _tmp0_;
	DeeModel* _tmp1_;
	DeeModel* _tmp2_;
	DeeModel* model;
	gchar* _tmp3_;
	gchar* pkg_search_string;
	gboolean _tmp4_;
	gboolean has_search;
	GTimer* _tmp5_;
	GTimer* timer;
	GeeHashSet* _tmp6_;
	GeeSet* installed_uris;
	GeeHashSet* _tmp7_;
	GeeSet* available_uris;
	UnityPackageSort _tmp8_;
	UnityPackageSearchResult* _tmp9_;
	UnityPackageSearchResult* appresults;
	gdouble _tmp10_;
	DeeModel* _tmp11_;
	gchar* _tmp12_;
	gchar* zg_search_string;
	ZeitgeistTimeRange* _tmp13_;
	ZeitgeistTimeRange* _tmp14_;
	GPtrArray* _tmp15_;
	ZeitgeistResultSet* _tmp16_;
	ZeitgeistResultSet* _tmp17_;
	ZeitgeistResultSet* results;
	guint _tmp18_;
	guint _tmp19_;
	gdouble _tmp20_;
	GError * e;
	gchar* _tmp21_;
	gchar* _tmp22_;
	DeeModel* _tmp23_;
	gboolean _tmp24_;
	UnityPackageSearchResult* _tmp25_;
	UnityPackageSearchResult* pkgresults;
	gdouble _tmp26_;
	gchar* _tmp27_;
	gpointer _tmp28_;
	gchar* _tmp29_;
	gchar* category;
	UnityPackageSearchResult* _tmp30_;
	UnityPackageSearchResult* random_pkgresults;
	gdouble _tmp31_;
	GError * _inner_error_;
};

struct _UnityApplicationsPlaceDaemonUpdateGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsPlaceDaemon* self;
	UnityPlaceSearch* search;
	UnityPlaceRendererInfo* _tmp0_;
	DeeModel* _tmp1_;
	DeeModel* _tmp2_;
	DeeModel* model;
	gboolean _tmp3_;
	gchar* _tmp4_;
	gchar* search_string;
	GeeHashSet* _tmp5_;
	GeeSet* installed_uris;
	GeeHashSet* _tmp6_;
	GeeSet* available_uris;
	GTimer* _tmp7_;
	GTimer* timer;
	UnityPackageSearchResult* _tmp8_;
	UnityPackageSearchResult* appresults;
	gdouble _tmp9_;
};

struct _UnityApplicationsPlaceDaemonActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityApplicationsPlaceDaemon* self;
	gchar* uri;
	guint32 result;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gchar* exec_or_dir;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* pkg;
	gchar** _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gchar* orig;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GError * _error_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint i;
	gboolean _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GError * err;
	const gchar* _tmp22_;
	const gchar* home_dir;
	GError * e;
	GError * _inner_error_;
};

struct _UnityApplicationsPlaceRunner {
	GObject parent_instance;
	UnityApplicationsPlaceRunnerPrivate * priv;
	UnityPlaceEntryInfo* place_entry;
};

struct _UnityApplicationsPlaceRunnerClass {
	GObjectClass parent_class;
};


static gpointer unity_applications_place_daemon_parent_class = NULL;
static UnityActivationIface* unity_applications_place_daemon_unity_activation_parent_iface = NULL;

#define CONFIG_DATADIR "/usr/share"
#define UNITY_APPLICATIONS_PLACE_ICON_PATH CONFIG_DATADIR "/icons/unity-icon-theme/places/svg/"
GType unity_applications_place_daemon_get_type (void) G_GNUC_CONST;
GType unity_applications_place_runner_get_type (void) G_GNUC_CONST;
#define UNITY_APPLICATIONS_PLACE_DAEMON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_APPLICATIONS_PLACE_TYPE_DAEMON, UnityApplicationsPlaceDaemonPrivate))
enum  {
	UNITY_APPLICATIONS_PLACE_DAEMON_DUMMY_PROPERTY
};
static void unity_applications_place_daemon_check_models_synced (UnityApplicationsPlaceDaemon* self, GObject* obj, GParamSpec* pspec);
static void unity_applications_place_daemon_populate_sections (UnityApplicationsPlaceDaemon* self);
static void unity_applications_place_daemon_populate_groups (UnityApplicationsPlaceDaemon* self, DeeModel* groups);
GType unity_applications_place_group_get_type (void) G_GNUC_CONST;
static void unity_applications_place_daemon_populate_section_queries (UnityApplicationsPlaceDaemon* self);
static gboolean unity_applications_place_daemon_build_app_menu_index (UnityApplicationsPlaceDaemon* self);
static void _lambda2_ (GMenuTree* menu, UnityApplicationsPlaceDaemon* self);
static gboolean unity_applications_place_daemon_build_app_menu_index_and_result_models (UnityApplicationsPlaceDaemon* self);
static gboolean _unity_applications_place_daemon_build_app_menu_index_and_result_models_gsource_func (gpointer self);
static void __lambda2__gmenu_tree_changed_func (GMenuTree* tree, gpointer self);
static void unity_applications_place_daemon_populate_zg_templates (UnityApplicationsPlaceDaemon* self);
GType unity_applications_place_section_get_type (void) G_GNUC_CONST;
static gchar* unity_applications_place_daemon_prepare_zg_search_string (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section);
static void unity_applications_place_daemon_update_entry_search_data_free (gpointer _data);
static void unity_applications_place_daemon_update_entry_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_place_daemon_update_entry_search_finish (UnityApplicationsPlaceDaemon* self, GAsyncResult* _res_);
static gboolean unity_applications_place_daemon_update_entry_search_co (UnityApplicationsPlaceDaemonUpdateEntrySearchData* data);
static gchar* unity_applications_place_daemon_prepare_pkg_search_string (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section);
gboolean unity_applications_place_utils_search_is_invalid (UnityPlaceSearch* search);
static void unity_applications_place_daemon_add_pkg_search_result (UnityApplicationsPlaceDaemon* self, UnityPackageSearchResult* results, GeeSet* installed_uris, GeeSet* available_uris, DeeModel* model, UnityApplicationsPlaceGroup group, guint max_add);
static void unity_applications_place_daemon_update_entry_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void unity_applications_place_daemon_append_events_with_group (UnityApplicationsPlaceDaemon* self, ZeitgeistResultSet* events, DeeModel* results, guint group_id, gint section_filter);
void unity_applications_place_daemon_check_empty_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, DeeModel* results_model);
void unity_applications_place_daemon_check_empty_section (UnityApplicationsPlaceDaemon* self, UnityApplicationsPlaceSection section, DeeModel* results_model);
static gboolean _lambda3_ (UnityApplicationsPlaceDaemon* self);
static gboolean __lambda3__gsource_func (gpointer self);
static void unity_applications_place_daemon_update_global_search_data_free (gpointer _data);
static void unity_applications_place_daemon_update_global_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_applications_place_daemon_update_global_search_finish (UnityApplicationsPlaceDaemon* self, GAsyncResult* _res_);
static gboolean unity_applications_place_daemon_update_global_search_co (UnityApplicationsPlaceDaemonUpdateGlobalSearchData* data);
static gboolean _lambda4_ (UnityApplicationsPlaceDaemon* self);
static gboolean __lambda4__gsource_func (gpointer self);
GIcon* unity_applications_place_daemon_find_pkg_icon (UnityApplicationsPlaceDaemon* self, UnityPackageInfo* pkginfo);
static void unity_applications_place_daemon_on_appinfo_changed (UnityApplicationsPlaceDaemon* self, const gchar* id, GAppInfo* appinfo);
const gchar* unity_applications_place_group_to_string (UnityApplicationsPlaceGroup self);
static void unity_applications_place_daemon_real_activate_data_free (gpointer _data);
static void unity_applications_place_daemon_real_activate (UnityActivation* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_applications_place_daemon_real_activate_co (UnityApplicationsPlaceDaemonActivateData* data);
gchar* unity_applications_place_utils_subst_tilde (const gchar* s);
void unity_applications_place_runner_add_history (UnityApplicationsPlaceRunner* self, const gchar* last_command);
GAppInfo* unity_applications_place_utils_get_app_info_for_actor (const gchar* actor);
UnityApplicationsPlaceDaemon* unity_applications_place_daemon_new (void);
UnityApplicationsPlaceDaemon* unity_applications_place_daemon_construct (GType object_type);
static GObject * unity_applications_place_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define CONFIG_PREFIX "/usr"
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _lambda5_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self);
static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda6_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self);
gboolean unity_applications_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search);
static void __lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda7_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self);
static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_applications_place_daemon_on_appinfo_changed_unity_app_info_manager_changed (UnityAppInfoManager* _sender, const gchar* id, GAppInfo* new_appinfo, gpointer self);
UnityApplicationsPlaceRunner* unity_applications_place_runner_new (UnityApplicationsPlaceDaemon* daemon);
UnityApplicationsPlaceRunner* unity_applications_place_runner_construct (GType object_type, UnityApplicationsPlaceDaemon* daemon);
static void _unity_applications_place_daemon_check_models_synced_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_applications_place_daemon_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void unity_applications_place_daemon_check_models_synced (UnityApplicationsPlaceDaemon* self, GObject* obj, GParamSpec* pspec) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	DeeModel* _tmp4_ = NULL;
	DeeModel* _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp4_ = unity_place_entry_info_get_sections_model (self->priv->applications);
	_tmp5_ = _tmp4_;
	g_object_get (DEE_IS_SHARED_MODEL (_tmp5_) ? ((DeeSharedModel*) _tmp5_) : NULL, "synchronized", &_tmp6_, NULL);
	if (_tmp6_) {
		UnityPlaceRendererInfo* _tmp7_ = NULL;
		DeeModel* _tmp8_ = NULL;
		DeeModel* _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = unity_place_entry_info_get_entry_renderer_info (self->priv->applications);
		_tmp8_ = unity_place_renderer_info_get_groups_model (_tmp7_);
		_tmp9_ = _tmp8_;
		g_object_get (DEE_IS_SHARED_MODEL (_tmp9_) ? ((DeeSharedModel*) _tmp9_) : NULL, "synchronized", &_tmp10_, NULL);
		_tmp3_ = _tmp10_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		UnityPlaceRendererInfo* _tmp11_ = NULL;
		DeeModel* _tmp12_ = NULL;
		DeeModel* _tmp13_;
		gboolean _tmp14_;
		_tmp11_ = unity_place_entry_info_get_entry_renderer_info (self->priv->applications);
		_tmp12_ = unity_place_renderer_info_get_results_model (_tmp11_);
		_tmp13_ = _tmp12_;
		g_object_get (DEE_IS_SHARED_MODEL (_tmp13_) ? ((DeeSharedModel*) _tmp13_) : NULL, "synchronized", &_tmp14_, NULL);
		_tmp2_ = _tmp14_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		UnityPlaceRendererInfo* _tmp15_ = NULL;
		DeeModel* _tmp16_ = NULL;
		DeeModel* _tmp17_;
		gboolean _tmp18_;
		_tmp15_ = unity_place_entry_info_get_global_renderer_info (self->priv->applications);
		_tmp16_ = unity_place_renderer_info_get_groups_model (_tmp15_);
		_tmp17_ = _tmp16_;
		g_object_get (DEE_IS_SHARED_MODEL (_tmp17_) ? ((DeeSharedModel*) _tmp17_) : NULL, "synchronized", &_tmp18_, NULL);
		_tmp1_ = _tmp18_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		UnityPlaceRendererInfo* _tmp19_ = NULL;
		DeeModel* _tmp20_ = NULL;
		DeeModel* _tmp21_;
		gboolean _tmp22_;
		_tmp19_ = unity_place_entry_info_get_global_renderer_info (self->priv->applications);
		_tmp20_ = unity_place_renderer_info_get_results_model (_tmp19_);
		_tmp21_ = _tmp20_;
		g_object_get (DEE_IS_SHARED_MODEL (_tmp21_) ? ((DeeSharedModel*) _tmp21_) : NULL, "synchronized", &_tmp22_, NULL);
		_tmp0_ = _tmp22_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		if (self->priv->all_models_synced == FALSE) {
			UnityPlaceRendererInfo* _tmp23_ = NULL;
			DeeModel* _tmp24_ = NULL;
			UnityPlaceRendererInfo* _tmp25_ = NULL;
			DeeModel* _tmp26_ = NULL;
			self->priv->all_models_synced = TRUE;
			unity_applications_place_daemon_populate_sections (self);
			_tmp23_ = unity_place_entry_info_get_entry_renderer_info (self->priv->applications);
			_tmp24_ = unity_place_renderer_info_get_groups_model (_tmp23_);
			unity_applications_place_daemon_populate_groups (self, _tmp24_);
			_tmp25_ = unity_place_entry_info_get_global_renderer_info (self->priv->applications);
			_tmp26_ = unity_place_renderer_info_get_groups_model (_tmp25_);
			unity_applications_place_daemon_populate_groups (self, _tmp26_);
			g_object_notify ((GObject*) self->priv->applications, "active-search");
			g_object_notify ((GObject*) self->priv->applications, "active-global-search");
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_applications_place_daemon_populate_sections (UnityApplicationsPlaceDaemon* self) {
	DeeModel* _tmp0_ = NULL;
	DeeModel* _tmp1_;
	DeeModel* sections;
	guint _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_place_entry_info_get_sections_model (self->priv->applications);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sections = _tmp1_;
	_tmp2_ = dee_model_get_n_rows (sections);
	if (_tmp2_ != 0) {
		g_debug ("daemon.vala:249: Sections model already populated. We probably cloned " \
"it off Unity. Rebuilding.");
		dee_model_clear (sections);
	}
	_tmp3_ = _ ("All Applications");
	dee_model_append (sections, _tmp3_, "", NULL);
	_tmp4_ = _ ("Accessories");
	dee_model_append (sections, _tmp4_, "", NULL);
	_tmp5_ = _ ("Universal Access");
	dee_model_append (sections, _tmp5_, "", NULL);
	_tmp6_ = _ ("Developer Tools");
	dee_model_append (sections, _tmp6_, "", NULL);
	_tmp7_ = _ ("Education");
	dee_model_append (sections, _tmp7_, "", NULL);
	_tmp8_ = _ ("Science & Engineering");
	dee_model_append (sections, _tmp8_, "", NULL);
	_tmp9_ = _ ("Games");
	dee_model_append (sections, _tmp9_, "", NULL);
	_tmp10_ = _ ("Graphics");
	dee_model_append (sections, _tmp10_, "", NULL);
	_tmp11_ = _ ("Internet");
	dee_model_append (sections, _tmp11_, "", NULL);
	_tmp12_ = _ ("Multimedia");
	dee_model_append (sections, _tmp12_, "", NULL);
	_tmp13_ = _ ("Office");
	dee_model_append (sections, _tmp13_, "", NULL);
	_tmp14_ = _ ("Themes & Tweaks");
	dee_model_append (sections, _tmp14_, "", NULL);
	_tmp15_ = _ ("System");
	dee_model_append (sections, _tmp15_, "", NULL);
	_g_object_unref0 (sections);
}


static void unity_applications_place_daemon_populate_groups (UnityApplicationsPlaceDaemon* self, DeeModel* groups) {
	guint _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	UnityPlaceRendererInfo* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (groups != NULL);
	_tmp0_ = dee_model_get_n_rows (groups);
	if (_tmp0_ != 0) {
		g_debug ("daemon.vala:272: The groups model already populated. We probably clone" \
"d it off Unity. Rebuilding.");
		dee_model_clear (groups);
	}
	_tmp1_ = _ ("Most Frequently Used");
	dee_model_append (groups, "UnityShowcaseRenderer", _tmp1_, UNITY_APPLICATIONS_PLACE_ICON_PATH "group-mostused.svg", NULL);
	_tmp2_ = _ ("Installed");
	dee_model_append (groups, "UnityDefaultRenderer", _tmp2_, UNITY_APPLICATIONS_PLACE_ICON_PATH "group-installed.svg", NULL);
	_tmp3_ = _ ("Apps Available for Download");
	dee_model_append (groups, "UnityDefaultRenderer", _tmp3_, UNITY_APPLICATIONS_PLACE_ICON_PATH "group-available.svg", NULL);
	dee_model_append (groups, "UnityEmptySearchRenderer", "No search results", "", NULL);
	dee_model_append (groups, "UnityEmptySectionRenderer", "Empty section", "", NULL);
	_tmp4_ = unity_place_entry_info_get_entry_renderer_info (self->priv->applications);
	_tmp5_ = g_strdup_printf ("%u", (guint) UNITY_APPLICATIONS_PLACE_GROUP_INSTALLED);
	_tmp6_ = _tmp5_;
	unity_place_renderer_info_set_hint (_tmp4_, "ExpandedGroups", _tmp6_);
	_g_free0 (_tmp6_);
}


static void unity_applications_place_daemon_populate_section_queries (UnityApplicationsPlaceDaemon* self) {
	g_return_if_fail (self != NULL);
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "NOT category:XYZ");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "(category:Utility AND NOT category:Accessibility)");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "(category:Accessibility AND NOT category:Settings)");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "category:Development");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "(category:Education AND NOT category:Science)");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "(category:Science OR category:Engineering)");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "category:Game");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "category:Graphics");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "category:Network");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "category:AudioVideo");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "category:Office");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "category:Settings");
	gee_collection_add ((GeeCollection*) self->priv->section_queries, "(category:System OR category:Security)");
}


static gpointer _gmenu_tree_ref0 (gpointer self) {
	return self ? gmenu_tree_ref (self) : NULL;
}


static gboolean _unity_applications_place_daemon_build_app_menu_index_and_result_models_gsource_func (gpointer self) {
	gboolean result;
	result = unity_applications_place_daemon_build_app_menu_index_and_result_models (self);
	return result;
}


static void _lambda2_ (GMenuTree* menu, UnityApplicationsPlaceDaemon* self) {
	guint _tmp0_;
	g_return_if_fail (menu != NULL);
	if (self->priv->app_menu_changed_reindex_timeout != 0) {
		g_source_remove (self->priv->app_menu_changed_reindex_timeout);
	}
	_tmp0_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, _unity_applications_place_daemon_build_app_menu_index_and_result_models_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->app_menu_changed_reindex_timeout = _tmp0_;
}


static void __lambda2__gmenu_tree_changed_func (GMenuTree* tree, gpointer self) {
	_lambda2_ (tree, self);
}


static gboolean unity_applications_place_daemon_build_app_menu_index (UnityApplicationsPlaceDaemon* self) {
	gboolean result = FALSE;
	UnityPackageSearcher* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->app_menu == NULL) {
		GMenuTree* _tmp0_ = NULL;
		GMenuTree* _tmp1_;
		g_debug ("daemon.vala:323: Building initial application menu");
		_tmp0_ = gmenu_tree_lookup ("unity-place-applications.menu", GMENU_TREE_FLAGS_INCLUDE_NODISPLAY);
		_tmp1_ = _gmenu_tree_ref0 (_tmp0_);
		_gmenu_tree_unref0 (self->priv->app_menu);
		self->priv->app_menu = _tmp1_;
		gmenu_tree_add_monitor (self->priv->app_menu, __lambda2__gmenu_tree_changed_func, self);
	}
	g_debug ("daemon.vala:344: Indexing application menu");
	_tmp2_ = unity_package_searcher_new_for_menu (self->priv->app_menu);
	_unity_package_searcher_free0 (self->appsearcher);
	self->appsearcher = _tmp2_;
	self->priv->app_menu_changed_reindex_timeout = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean unity_applications_place_daemon_build_app_menu_index_and_result_models (UnityApplicationsPlaceDaemon* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	unity_applications_place_daemon_build_app_menu_index (self);
	g_debug ("daemon.vala:359: Updating result models");
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = NULL;
	_g_object_unref0 (self->priv->previous_global_search);
	self->priv->previous_global_search = NULL;
	g_object_notify ((GObject*) self->priv->applications, "active-search");
	g_object_notify ((GObject*) self->priv->applications, "active-global-search");
	result = FALSE;
	return result;
}


static void unity_applications_place_daemon_populate_zg_templates (UnityApplicationsPlaceDaemon* self) {
	GPtrArray* _tmp0_ = NULL;
	ZeitgeistSubject* _tmp1_ = NULL;
	ZeitgeistSubject* _tmp2_;
	ZeitgeistEvent* _tmp3_ = NULL;
	ZeitgeistEvent* _tmp4_;
	ZeitgeistEvent* ev;
	ZeitgeistEvent* _tmp5_;
	GObject* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_ptr_array_sized_new ((guint) 1);
	_g_ptr_array_unref0 (self->priv->zg_templates);
	self->priv->zg_templates = _tmp0_;
	_tmp1_ = zeitgeist_subject_new_full ("application://*", "", "", "", "", "", "");
	_tmp2_ = g_object_ref_sink (_tmp1_);
	_tmp3_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, "", _tmp2_, NULL);
	_tmp4_ = g_object_ref_sink (_tmp3_);
	_g_object_unref0 (_tmp2_);
	ev = _tmp4_;
	_tmp5_ = ev;
	_tmp6_ = g_object_ref (G_IS_OBJECT (_tmp5_) ? ((GObject*) _tmp5_) : NULL);
	g_ptr_array_add (self->priv->zg_templates, _tmp6_);
	_g_object_unref0 (ev);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* unity_applications_place_daemon_prepare_zg_search_string (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	if (search != NULL) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = unity_place_search_get_search_string (search);
		_g_free0 (s);
		s = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		_g_free0 (s);
		s = _tmp1_;
	}
	_tmp2_ = string_strip (s);
	_g_free0 (s);
	s = _tmp2_;
	_tmp4_ = g_str_has_suffix (s, "*");
	if (!_tmp4_) {
		_tmp3_ = g_strcmp0 (s, "") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp5_;
		_tmp5_ = g_strconcat (s, "*", NULL);
		_g_free0 (s);
		s = _tmp5_;
	}
	if (g_strcmp0 (s, "") != 0) {
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp6_ = string_to_string (s);
		_tmp7_ = g_strconcat ("app:(", _tmp6_, ")", NULL);
		_g_free0 (s);
		s = _tmp7_;
	} else {
		gpointer _tmp8_ = NULL;
		_tmp8_ = gee_list_get (self->priv->section_queries, (gint) section);
		result = (gchar*) _tmp8_;
		_g_free0 (s);
		return result;
	}
	if (section == UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS) {
		result = s;
		return result;
	} else {
		gpointer _tmp9_ = NULL;
		gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp9_ = gee_list_get (self->priv->section_queries, (gint) section);
		_tmp10_ = (gchar*) _tmp9_;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = g_strconcat (" AND ", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (s, _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp10_);
		result = _tmp15_;
		_g_free0 (s);
		return result;
	}
	_g_free0 (s);
}


static void unity_applications_place_daemon_update_entry_search_data_free (gpointer _data) {
	UnityApplicationsPlaceDaemonUpdateEntrySearchData* data;
	data = _data;
	_g_object_unref0 (data->search);
	_g_object_unref0 (data->self);
	g_slice_free (UnityApplicationsPlaceDaemonUpdateEntrySearchData, data);
}


static void unity_applications_place_daemon_update_entry_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsPlaceDaemonUpdateEntrySearchData* _data_;
	_data_ = g_slice_new0 (UnityApplicationsPlaceDaemonUpdateEntrySearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_place_daemon_update_entry_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_place_daemon_update_entry_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->search = _g_object_ref0 (search);
	_data_->section = section;
	unity_applications_place_daemon_update_entry_search_co (_data_);
}


static void unity_applications_place_daemon_update_entry_search_finish (UnityApplicationsPlaceDaemon* self, GAsyncResult* _res_) {
	UnityApplicationsPlaceDaemonUpdateEntrySearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


static void unity_applications_place_daemon_update_entry_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityApplicationsPlaceDaemonUpdateEntrySearchData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	unity_applications_place_daemon_update_entry_search_co (data);
}


static gboolean _lambda3_ (UnityApplicationsPlaceDaemon* self) {
	gboolean result = FALSE;
	g_object_thaw_notify ((GObject*) self->priv->applications);
	result = FALSE;
	return result;
}


static gboolean __lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda3_ (self);
	return result;
}


static gboolean unity_applications_place_daemon_update_entry_search_co (UnityApplicationsPlaceDaemonUpdateEntrySearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_object_freeze_notify ((GObject*) data->self->priv->applications);
	data->_tmp0_ = NULL;
	data->_tmp0_ = unity_place_entry_info_get_entry_renderer_info (data->self->priv->applications);
	data->_tmp1_ = NULL;
	data->_tmp1_ = unity_place_renderer_info_get_results_model (data->_tmp0_);
	data->_tmp2_ = _g_object_ref0 (data->_tmp1_);
	data->model = data->_tmp2_;
	dee_model_clear (data->model);
	data->_tmp3_ = NULL;
	data->_tmp3_ = unity_applications_place_daemon_prepare_pkg_search_string (data->self, data->search, data->section);
	data->pkg_search_string = data->_tmp3_;
	data->_tmp4_ = unity_applications_place_utils_search_is_invalid (data->search);
	data->has_search = !data->_tmp4_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = g_timer_new ();
	data->timer = data->_tmp5_;
	data->_tmp6_ = NULL;
	data->_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	data->installed_uris = (GeeSet*) data->_tmp6_;
	data->_tmp7_ = NULL;
	data->_tmp7_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	data->available_uris = (GeeSet*) data->_tmp7_;
	if (data->has_search) {
		data->_tmp8_ = UNITY_PACKAGE_SORT_BY_RELEVANCY;
	} else {
		data->_tmp8_ = UNITY_PACKAGE_SORT_BY_NAME;
	}
	data->_tmp9_ = NULL;
	data->_tmp9_ = unity_package_searcher_search (data->self->appsearcher, data->pkg_search_string, (guint) 0, UNITY_PACKAGE_SEARCHTYPE_PREFIX, data->_tmp8_);
	data->appresults = data->_tmp9_;
	unity_applications_place_daemon_add_pkg_search_result (data->self, data->appresults, data->installed_uris, data->available_uris, data->model, UNITY_APPLICATIONS_PLACE_GROUP_INSTALLED, (guint) 0);
	g_timer_stop (data->timer);
	data->_tmp10_ = g_timer_elapsed (data->timer, NULL);
	g_debug ("daemon.vala:431: Entry search listed %i Installed apps in %fms for que" \
"ry: %s", data->appresults->num_hits, data->_tmp10_ * 1000, data->pkg_search_string);
	data->_tmp11_ = data->model;
	dee_shared_model_flush_revision_queue (DEE_IS_SHARED_MODEL (data->_tmp11_) ? ((DeeSharedModel*) data->_tmp11_) : NULL);
	data->_tmp12_ = NULL;
	data->_tmp12_ = unity_applications_place_daemon_prepare_zg_search_string (data->self, data->search, data->section);
	data->zg_search_string = data->_tmp12_;
	g_timer_start (data->timer);
	data->_tmp13_ = NULL;
	data->_tmp13_ = zeitgeist_time_range_new_anytime ();
	data->_tmp14_ = g_object_ref_sink (data->_tmp13_);
	data->_tmp15_ = _g_ptr_array_ref0 (data->self->priv->zg_templates);
	data->_state_ = 1;
	zeitgeist_index_search (data->self->priv->zg_index, data->zg_search_string, data->_tmp14_, data->_tmp15_, (guint32) ZEITGEIST_STORAGE_STATE_ANY, (guint32) 20, ZEITGEIST_RESULT_TYPE_MOST_POPULAR_SUBJECTS, NULL, unity_applications_place_daemon_update_entry_search_ready, data);
	return FALSE;
	_state_1:
	data->_tmp16_ = NULL;
	data->_tmp16_ = zeitgeist_index_search_finish (data->self->priv->zg_index, data->_res_, &data->_inner_error_);
	data->_tmp17_ = data->_tmp16_;
	_g_object_unref0 (data->_tmp14_);
	data->results = data->_tmp17_;
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	unity_applications_place_daemon_append_events_with_group (data->self, data->results, data->model, (guint) UNITY_APPLICATIONS_PLACE_GROUP_MOST_USED, (gint) data->section);
	g_timer_stop (data->timer);
	data->_tmp18_ = zeitgeist_result_set_size (data->results);
	data->_tmp19_ = zeitgeist_result_set_estimated_matches (data->results);
	data->_tmp20_ = g_timer_elapsed (data->timer, NULL);
	g_debug ("daemon.vala:455: Entry search found %u/%u Most Used apps in %fms for q" \
"uery '%s'", data->_tmp18_, data->_tmp19_, data->_tmp20_ * 1000, data->zg_search_string);
	_g_object_unref0 (data->results);
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		data->_tmp21_ = NULL;
		data->_tmp21_ = unity_place_search_get_search_string (data->search);
		data->_tmp22_ = data->_tmp21_;
		g_warning ("daemon.vala:460: Error performing search '%s': %s", data->_tmp22_, data->e->message);
		_g_free0 (data->_tmp22_);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_free0 (data->zg_search_string);
		_unity_package_search_result_free0 (data->appresults);
		_g_object_unref0 (data->available_uris);
		_g_object_unref0 (data->installed_uris);
		_g_timer_destroy0 (data->timer);
		_g_free0 (data->pkg_search_string);
		_g_object_unref0 (data->model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp23_ = data->model;
	dee_shared_model_flush_revision_queue (DEE_IS_SHARED_MODEL (data->_tmp23_) ? ((DeeSharedModel*) data->_tmp23_) : NULL);
	if (data->has_search) {
		data->_tmp24_ = data->self->priv->pkgsearcher != NULL;
	} else {
		data->_tmp24_ = FALSE;
	}
	if (data->_tmp24_) {
		g_timer_start (data->timer);
		data->_tmp25_ = NULL;
		data->_tmp25_ = unity_package_searcher_search (data->self->priv->pkgsearcher, data->pkg_search_string, (guint) 50, UNITY_PACKAGE_SEARCHTYPE_PREFIX, UNITY_PACKAGE_SORT_BY_RELEVANCY);
		data->pkgresults = data->_tmp25_;
		unity_applications_place_daemon_add_pkg_search_result (data->self, data->pkgresults, data->installed_uris, data->available_uris, data->model, UNITY_APPLICATIONS_PLACE_GROUP_AVAILABLE, (guint) 0);
		g_timer_stop (data->timer);
		data->_tmp26_ = g_timer_elapsed (data->timer, NULL);
		g_debug ("daemon.vala:480: Entry search listed %i Available apps in %fms for que" \
"ry: %s", data->pkgresults->num_hits, data->_tmp26_ * 1000, data->pkg_search_string);
		_unity_package_search_result_free0 (data->pkgresults);
	} else {
		if (data->self->priv->pkgsearcher != NULL) {
			g_timer_start (data->timer);
			if (data->section == UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS) {
				_g_free0 (data->_tmp27_);
				data->_tmp27_ = NULL;
			} else {
				data->_tmp28_ = NULL;
				data->_tmp28_ = gee_list_get (data->self->priv->section_queries, (gint) data->section);
				_g_free0 (data->_tmp27_);
				data->_tmp27_ = (gchar*) data->_tmp28_;
			}
			data->_tmp29_ = g_strdup (data->_tmp27_);
			data->category = data->_tmp29_;
			data->_tmp30_ = NULL;
			data->_tmp30_ = unity_package_searcher_get_random_apps (data->self->priv->pkgsearcher, data->category, (guint) 12);
			data->random_pkgresults = data->_tmp30_;
			unity_applications_place_daemon_add_pkg_search_result (data->self, data->random_pkgresults, data->installed_uris, data->available_uris, data->model, UNITY_APPLICATIONS_PLACE_GROUP_AVAILABLE, (guint) 6);
			g_timer_stop (data->timer);
			data->_tmp31_ = g_timer_elapsed (data->timer, NULL);
			g_debug ("daemon.vala:492: Entry search listed %i random Available apps in %fms", data->random_pkgresults->num_hits, data->_tmp31_ * 1000);
			_unity_package_search_result_free0 (data->random_pkgresults);
			_g_free0 (data->category);
			_g_free0 (data->_tmp27_);
		}
	}
	if (data->has_search) {
		unity_applications_place_daemon_check_empty_search (data->self, data->search, data->model);
	} else {
		unity_applications_place_daemon_check_empty_section (data->self, data->section, data->model);
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda3__gsource_func, g_object_ref (data->self), g_object_unref);
	if (data->search != NULL) {
		unity_place_search_finished (data->search);
	}
	_g_free0 (data->zg_search_string);
	_unity_package_search_result_free0 (data->appresults);
	_g_object_unref0 (data->available_uris);
	_g_object_unref0 (data->installed_uris);
	_g_timer_destroy0 (data->timer);
	_g_free0 (data->pkg_search_string);
	_g_object_unref0 (data->model);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void unity_applications_place_daemon_update_global_search_data_free (gpointer _data) {
	UnityApplicationsPlaceDaemonUpdateGlobalSearchData* data;
	data = _data;
	_g_object_unref0 (data->search);
	_g_object_unref0 (data->self);
	g_slice_free (UnityApplicationsPlaceDaemonUpdateGlobalSearchData, data);
}


static void unity_applications_place_daemon_update_global_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsPlaceDaemonUpdateGlobalSearchData* _data_;
	_data_ = g_slice_new0 (UnityApplicationsPlaceDaemonUpdateGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_place_daemon_update_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_place_daemon_update_global_search_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->search = _g_object_ref0 (search);
	unity_applications_place_daemon_update_global_search_co (_data_);
}


static void unity_applications_place_daemon_update_global_search_finish (UnityApplicationsPlaceDaemon* self, GAsyncResult* _res_) {
	UnityApplicationsPlaceDaemonUpdateGlobalSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _lambda4_ (UnityApplicationsPlaceDaemon* self) {
	gboolean result = FALSE;
	g_object_thaw_notify ((GObject*) self->priv->applications);
	result = FALSE;
	return result;
}


static gboolean __lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda4_ (self);
	return result;
}


static gboolean unity_applications_place_daemon_update_global_search_co (UnityApplicationsPlaceDaemonUpdateGlobalSearchData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = unity_place_entry_info_get_global_renderer_info (data->self->priv->applications);
	data->_tmp1_ = NULL;
	data->_tmp1_ = unity_place_renderer_info_get_results_model (data->_tmp0_);
	data->_tmp2_ = _g_object_ref0 (data->_tmp1_);
	data->model = data->_tmp2_;
	dee_model_clear (data->model);
	data->_tmp3_ = unity_applications_place_utils_search_is_invalid (data->search);
	if (data->_tmp3_) {
		_g_object_unref0 (data->model);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	g_object_freeze_notify ((GObject*) data->self->priv->applications);
	data->_tmp4_ = NULL;
	data->_tmp4_ = unity_applications_place_daemon_prepare_pkg_search_string (data->self, data->search, UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS);
	data->search_string = data->_tmp4_;
	data->_tmp5_ = NULL;
	data->_tmp5_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	data->installed_uris = (GeeSet*) data->_tmp5_;
	data->_tmp6_ = NULL;
	data->_tmp6_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	data->available_uris = (GeeSet*) data->_tmp6_;
	data->_tmp7_ = NULL;
	data->_tmp7_ = g_timer_new ();
	data->timer = data->_tmp7_;
	data->_tmp8_ = NULL;
	data->_tmp8_ = unity_package_searcher_search (data->self->appsearcher, data->search_string, (guint) 0, UNITY_PACKAGE_SEARCHTYPE_PREFIX, UNITY_PACKAGE_SORT_BY_RELEVANCY);
	data->appresults = data->_tmp8_;
	unity_applications_place_daemon_add_pkg_search_result (data->self, data->appresults, data->installed_uris, data->available_uris, data->model, UNITY_APPLICATIONS_PLACE_GROUP_INSTALLED, (guint) 0);
	g_timer_stop (data->timer);
	data->_tmp9_ = g_timer_elapsed (data->timer, NULL);
	g_debug ("daemon.vala:542: Global search listed %i Installed apps in %fms for qu" \
"ery: %s", data->appresults->num_hits, data->_tmp9_ * 1000, data->search_string);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda4__gsource_func, g_object_ref (data->self), g_object_unref);
	if (data->search != NULL) {
		unity_place_search_finished (data->search);
	}
	_unity_package_search_result_free0 (data->appresults);
	_g_timer_destroy0 (data->timer);
	_g_object_unref0 (data->available_uris);
	_g_object_unref0 (data->installed_uris);
	_g_free0 (data->search_string);
	_g_object_unref0 (data->model);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}


static gchar* unity_applications_place_daemon_prepare_pkg_search_string (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, UnityApplicationsPlaceSection section) {
	gchar* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unity_applications_place_utils_search_is_invalid (search);
	if (_tmp0_) {
		if (section == UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("type:Application");
			result = _tmp1_;
			return result;
		} else {
			gpointer _tmp2_ = NULL;
			gchar* _tmp3_;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp2_ = gee_list_get (self->priv->section_queries, (gint) section);
			_tmp3_ = (gchar*) _tmp2_;
			_tmp4_ = string_to_string (_tmp3_);
			_tmp5_ = g_strconcat ("type:Application AND ", _tmp4_, NULL);
			_tmp6_ = _tmp5_;
			_g_free0 (_tmp3_);
			result = _tmp6_;
			return result;
		}
	} else {
		gchar* _tmp7_ = NULL;
		gchar* s;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp7_ = unity_place_search_get_search_string (search);
		s = _tmp7_;
		_tmp8_ = string_strip (s);
		_g_free0 (s);
		s = _tmp8_;
		_tmp9_ = string_delimit (s, "-", ' ');
		_g_free0 (s);
		s = _tmp9_;
		if (section == UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS) {
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp10_ = string_to_string (s);
			_tmp11_ = g_strconcat ("type:Application AND ", _tmp10_, NULL);
			result = _tmp11_;
			_g_free0 (s);
			return result;
		} else {
			gpointer _tmp12_ = NULL;
			gchar* _tmp13_;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp12_ = gee_list_get (self->priv->section_queries, (gint) section);
			_tmp13_ = (gchar*) _tmp12_;
			_tmp14_ = string_to_string (_tmp13_);
			_tmp15_ = string_to_string (s);
			_tmp16_ = g_strconcat ("type:Application AND ", _tmp14_, " AND ", _tmp15_, NULL);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp13_);
			result = _tmp17_;
			_g_free0 (s);
			return result;
		}
		_g_free0 (s);
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


GIcon* unity_applications_place_daemon_find_pkg_icon (UnityApplicationsPlaceDaemon* self, UnityPackageInfo* pkginfo) {
	GIcon* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* desktop_id;
	UnityAppInfoManager* _tmp1_ = NULL;
	UnityAppInfoManager* _tmp2_;
	GAppInfo* _tmp3_ = NULL;
	GAppInfo* _tmp4_;
	gboolean _tmp5_;
	gboolean installed;
	gboolean _tmp7_;
	GThemedIcon* _tmp37_ = NULL;
	GThemedIcon* icon;
	gchar* _tmp38_;
	GIcon* _tmp39_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkginfo != NULL, NULL);
	_tmp0_ = g_path_get_basename (pkginfo->desktop_file);
	desktop_id = _tmp0_;
	_tmp1_ = unity_app_info_manager_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = unity_app_info_manager_lookup (_tmp2_, desktop_id);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	installed = _tmp5_;
	if (installed) {
		GThemedIcon* _tmp6_ = NULL;
		_tmp6_ = (GThemedIcon*) g_themed_icon_new (pkginfo->icon);
		result = (GIcon*) _tmp6_;
		_g_free0 (desktop_id);
		return result;
	}
	_tmp7_ = g_str_has_prefix (pkginfo->icon, "/");
	if (_tmp7_) {
		GFile* _tmp8_ = NULL;
		GFile* _tmp9_;
		GFileIcon* _tmp10_ = NULL;
		GIcon* _tmp11_;
		_tmp8_ = g_file_new_for_path (pkginfo->icon);
		_tmp9_ = _tmp8_;
		_tmp10_ = (GFileIcon*) g_file_icon_new (_tmp9_);
		_tmp11_ = (GIcon*) _tmp10_;
		_g_object_unref0 (_tmp9_);
		result = _tmp11_;
		_g_free0 (desktop_id);
		return result;
	} else {
		gconstpointer _tmp12_ = NULL;
		GIcon* _tmp13_;
		GIcon* icon;
		gchar* path = NULL;
		gboolean _tmp14_;
		_tmp12_ = g_hash_table_lookup (self->priv->file_icon_cache, pkginfo->icon);
		_tmp13_ = _g_object_ref0 ((GIcon*) _tmp12_);
		icon = _tmp13_;
		if (icon != NULL) {
			result = icon;
			_g_free0 (desktop_id);
			return result;
		}
		_tmp14_ = string_contains (pkginfo->icon, ".");
		if (_tmp14_) {
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gboolean _tmp18_;
			_tmp15_ = string_to_string (CONFIG_DATADIR);
			_tmp16_ = string_to_string (pkginfo->icon);
			_tmp17_ = g_strconcat (_tmp15_, "/app-install/icons/", _tmp16_, NULL);
			_g_free0 (path);
			path = _tmp17_;
			_tmp18_ = g_file_test (path, G_FILE_TEST_EXISTS);
			if (_tmp18_) {
				GFile* _tmp19_ = NULL;
				GFile* _tmp20_;
				GFileIcon* _tmp21_ = NULL;
				gchar* _tmp22_;
				GIcon* _tmp23_;
				_tmp19_ = g_file_new_for_path (path);
				_tmp20_ = _tmp19_;
				_tmp21_ = (GFileIcon*) g_file_icon_new (_tmp20_);
				_g_object_unref0 (icon);
				icon = (GIcon*) _tmp21_;
				_g_object_unref0 (_tmp20_);
				_tmp22_ = g_strdup (pkginfo->icon);
				_tmp23_ = _g_object_ref0 (icon);
				g_hash_table_insert (self->priv->file_icon_cache, _tmp22_, _tmp23_);
				result = icon;
				_g_free0 (path);
				_g_free0 (desktop_id);
				return result;
			}
		}
		{
			GeeList* _tmp24_;
			GeeList* _ext_list;
			gint _tmp25_;
			gint _ext_size;
			gint _ext_index;
			_tmp24_ = _g_object_ref0 (self->priv->image_extensions);
			_ext_list = _tmp24_;
			_tmp25_ = gee_collection_get_size ((GeeCollection*) _ext_list);
			_ext_size = _tmp25_;
			_ext_index = -1;
			while (TRUE) {
				gpointer _tmp26_ = NULL;
				gchar* ext;
				const gchar* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				gboolean _tmp31_;
				_ext_index = _ext_index + 1;
				if (!(_ext_index < _ext_size)) {
					break;
				}
				_tmp26_ = gee_list_get (_ext_list, _ext_index);
				ext = (gchar*) _tmp26_;
				_tmp27_ = string_to_string (CONFIG_DATADIR);
				_tmp28_ = string_to_string (pkginfo->icon);
				_tmp29_ = string_to_string (ext);
				_tmp30_ = g_strconcat (_tmp27_, "/app-install/icons/", _tmp28_, ".", _tmp29_, NULL);
				_g_free0 (path);
				path = _tmp30_;
				_tmp31_ = g_file_test (path, G_FILE_TEST_EXISTS);
				if (_tmp31_) {
					GFile* _tmp32_ = NULL;
					GFile* _tmp33_;
					GFileIcon* _tmp34_ = NULL;
					gchar* _tmp35_;
					GIcon* _tmp36_;
					_tmp32_ = g_file_new_for_path (path);
					_tmp33_ = _tmp32_;
					_tmp34_ = (GFileIcon*) g_file_icon_new (_tmp33_);
					_g_object_unref0 (icon);
					icon = (GIcon*) _tmp34_;
					_g_object_unref0 (_tmp33_);
					_tmp35_ = g_strdup (pkginfo->icon);
					_tmp36_ = _g_object_ref0 (icon);
					g_hash_table_insert (self->priv->file_icon_cache, _tmp35_, _tmp36_);
					result = icon;
					_g_free0 (ext);
					_g_object_unref0 (_ext_list);
					_g_free0 (path);
					_g_free0 (desktop_id);
					return result;
				}
				_g_free0 (ext);
			}
			_g_object_unref0 (_ext_list);
		}
		_g_free0 (path);
		_g_object_unref0 (icon);
	}
	_tmp37_ = (GThemedIcon*) g_themed_icon_new ("applications-other");
	icon = _tmp37_;
	_tmp38_ = g_strdup (pkginfo->icon);
	_tmp39_ = _g_object_ref0 ((GIcon*) icon);
	g_hash_table_insert (self->priv->file_icon_cache, _tmp38_, _tmp39_);
	result = (GIcon*) icon;
	_g_free0 (desktop_id);
	return result;
}


static void unity_applications_place_daemon_on_appinfo_changed (UnityApplicationsPlaceDaemon* self, const gchar* id, GAppInfo* appinfo) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_debug ("daemon.vala:670: Application changed: %s", id);
}


static void unity_applications_place_daemon_add_pkg_search_result (UnityApplicationsPlaceDaemon* self, UnityPackageSearchResult* results, GeeSet* installed_uris, GeeSet* available_uris, DeeModel* model, UnityApplicationsPlaceGroup group, guint max_add) {
	UnityAppInfoManager* _tmp0_ = NULL;
	UnityAppInfoManager* appmanager;
	guint n_added;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	g_return_if_fail (installed_uris != NULL);
	g_return_if_fail (available_uris != NULL);
	g_return_if_fail (model != NULL);
	_tmp0_ = unity_app_info_manager_get_instance ();
	appmanager = _tmp0_;
	n_added = (guint) 0;
	{
		GSList* pkginfo_collection;
		GSList* pkginfo_it;
		pkginfo_collection = results->results;
		for (pkginfo_it = pkginfo_collection; pkginfo_it != NULL; pkginfo_it = pkginfo_it->next) {
			UnityPackageInfo* pkginfo;
			pkginfo = (UnityPackageInfo*) pkginfo_it->data;
			{
				gchar* _tmp1_ = NULL;
				gchar* desktop_id;
				GAppInfo* _tmp2_ = NULL;
				GAppInfo* app;
				const gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* uri;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_;
				gchar* display_name = NULL;
				gchar* comment = NULL;
				gboolean _tmp17_ = FALSE;
				GIcon* _tmp22_ = NULL;
				GIcon* icon;
				const gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_;
				gboolean _tmp27_ = FALSE;
				if (pkginfo->desktop_file == NULL) {
					continue;
				}
				_tmp1_ = g_path_get_basename (pkginfo->desktop_file);
				desktop_id = _tmp1_;
				_tmp2_ = unity_app_info_manager_lookup (appmanager, desktop_id);
				app = _tmp2_;
				_tmp3_ = string_to_string (desktop_id);
				_tmp4_ = g_strconcat ("application://", _tmp3_, NULL);
				uri = _tmp4_;
				_tmp6_ = gee_collection_contains ((GeeCollection*) installed_uris, uri);
				if (_tmp6_) {
					_tmp5_ = TRUE;
				} else {
					gboolean _tmp7_;
					_tmp7_ = gee_collection_contains ((GeeCollection*) available_uris, uri);
					_tmp5_ = _tmp7_;
				}
				if (_tmp5_) {
					_g_free0 (uri);
					_g_object_unref0 (app);
					_g_free0 (desktop_id);
					continue;
				}
				switch (group) {
					case UNITY_APPLICATIONS_PLACE_GROUP_INSTALLED:
					{
						const gchar* _tmp8_ = NULL;
						gchar* _tmp9_;
						const gchar* _tmp10_ = NULL;
						gchar* _tmp11_;
						gee_collection_add ((GeeCollection*) installed_uris, uri);
						_tmp8_ = g_app_info_get_display_name (app);
						_tmp9_ = g_strdup (_tmp8_);
						_g_free0 (display_name);
						display_name = _tmp9_;
						_tmp10_ = g_app_info_get_description (app);
						_tmp11_ = g_strdup (_tmp10_);
						_g_free0 (comment);
						comment = _tmp11_;
						break;
					}
					case UNITY_APPLICATIONS_PLACE_GROUP_AVAILABLE:
					{
						gchar* _tmp12_;
						gchar* _tmp13_;
						gee_collection_add ((GeeCollection*) available_uris, uri);
						_tmp12_ = g_strdup (pkginfo->application_name);
						_g_free0 (display_name);
						display_name = _tmp12_;
						_tmp13_ = g_strdup ("");
						_g_free0 (comment);
						comment = _tmp13_;
						break;
					}
					default:
					{
						GEnumValue* _tmp14_;
						gchar* _tmp15_ = NULL;
						gchar* _tmp16_;
						_tmp14_ = g_enum_get_value (g_type_class_ref (UNITY_APPLICATIONS_PLACE_TYPE_GROUP), group);
						_tmp15_ = g_strconcat ("Illegal group for package search ", (_tmp14_ != NULL) ? _tmp14_->value_name : NULL, NULL);
						_tmp16_ = _tmp15_;
						g_warning ("daemon.vala:715: %s", _tmp16_);
						_g_free0 (_tmp16_);
						continue;
					}
				}
				if (app != NULL) {
					gboolean _tmp18_;
					_tmp18_ = g_app_info_should_show (app);
					_tmp17_ = !_tmp18_;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					_g_free0 (comment);
					_g_free0 (display_name);
					_g_free0 (uri);
					_g_object_unref0 (app);
					_g_free0 (desktop_id);
					continue;
				}
				if (group == UNITY_APPLICATIONS_PLACE_GROUP_AVAILABLE) {
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					gchar* _tmp21_ = NULL;
					if (app != NULL) {
						_g_free0 (comment);
						_g_free0 (display_name);
						_g_free0 (uri);
						_g_object_unref0 (app);
						_g_free0 (desktop_id);
						continue;
					}
					_tmp19_ = string_to_string (pkginfo->package_name);
					_tmp20_ = string_to_string (pkginfo->application_name);
					_tmp21_ = g_strconcat ("unity-install://", _tmp19_, "/", _tmp20_, NULL);
					_g_free0 (uri);
					uri = _tmp21_;
					gee_collection_add ((GeeCollection*) available_uris, uri);
				}
				_tmp22_ = unity_applications_place_daemon_find_pkg_icon (self, pkginfo);
				icon = _tmp22_;
				if (display_name != NULL) {
					_tmp23_ = display_name;
				} else {
					_tmp23_ = "";
				}
				if (comment != NULL) {
					_tmp24_ = comment;
				} else {
					_tmp24_ = "";
				}
				_tmp25_ = g_icon_to_string (icon);
				_tmp26_ = _tmp25_;
				dee_model_append (model, uri, _tmp26_, group, "application/x-desktop", _tmp23_, _tmp24_, NULL);
				_g_free0 (_tmp26_);
				n_added++;
				if (max_add > 0) {
					_tmp27_ = n_added >= max_add;
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					_g_object_unref0 (icon);
					_g_free0 (comment);
					_g_free0 (display_name);
					_g_free0 (uri);
					_g_object_unref0 (app);
					_g_free0 (desktop_id);
					_g_object_unref0 (appmanager);
					return;
				}
				_g_object_unref0 (icon);
				_g_free0 (comment);
				_g_free0 (display_name);
				_g_free0 (uri);
				_g_object_unref0 (app);
				_g_free0 (desktop_id);
			}
		}
	}
	_g_object_unref0 (appmanager);
}


static void unity_applications_place_daemon_real_activate_data_free (gpointer _data) {
	UnityApplicationsPlaceDaemonActivateData* data;
	data = _data;
	_g_free0 (data->uri);
	_g_object_unref0 (data->self);
	g_slice_free (UnityApplicationsPlaceDaemonActivateData, data);
}


static void unity_applications_place_daemon_real_activate (UnityActivation* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityApplicationsPlaceDaemon * self;
	UnityApplicationsPlaceDaemonActivateData* _data_;
	self = (UnityApplicationsPlaceDaemon*) base;
	_data_ = g_slice_new0 (UnityApplicationsPlaceDaemonActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_applications_place_daemon_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_applications_place_daemon_real_activate_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->uri = g_strdup (uri);
	unity_applications_place_daemon_real_activate_co (_data_);
}


static guint32 unity_applications_place_daemon_real_activate_finish (UnityActivation* base, GAsyncResult* _res_, GError** error) {
	guint32 result;
	UnityApplicationsPlaceDaemonActivateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
     * Override of the default activation handler. The apps place daemon
     * can handle activation of installable apps using the Software Center
     */
static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static gboolean unity_applications_place_daemon_real_activate_co (UnityApplicationsPlaceDaemonActivateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->args_length1 = 0;
	data->_args_size_ = 0;
	data->exec_or_dir = NULL;
	data->_tmp0_ = g_str_has_prefix (data->uri, "unity-install://");
	if (data->_tmp0_) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = string_offset (data->uri, (glong) 16);
		data->pkg = data->_tmp1_;
		g_debug ("daemon.vala:767: Installing: %s", data->pkg);
		data->_tmp2_ = NULL;
		data->_tmp2_ = g_new0 (gchar*, 2 + 1);
		data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
		data->args = data->_tmp2_;
		data->args_length1 = 2;
		data->_args_size_ = 2;
		data->_tmp3_ = g_strdup ("software-center");
		data->_tmp4_ = data->_tmp3_;
		_g_free0 (data->args[0]);
		data->args[0] = data->_tmp4_;
		data->_tmp5_ = g_strdup (data->pkg);
		data->_tmp6_ = data->_tmp5_;
		_g_free0 (data->args[1]);
		data->args[1] = data->_tmp6_;
	} else {
		data->_tmp7_ = g_str_has_prefix (data->uri, "unity-runner://");
		if (data->_tmp7_) {
			data->_tmp8_ = NULL;
			data->_tmp8_ = string_offset (data->uri, (glong) 15);
			data->_tmp9_ = g_strdup (data->_tmp8_);
			_g_free0 (data->orig);
			data->orig = data->_tmp9_;
			if (data->self->priv->uri_regex != NULL) {
				data->_tmp11_ = g_regex_match (data->self->priv->uri_regex, data->orig, 0, NULL);
				data->_tmp10_ = data->_tmp11_;
			} else {
				data->_tmp10_ = FALSE;
			}
			if (data->_tmp10_) {
				g_app_info_launch_default_for_uri (data->orig, NULL, &data->_inner_error_);
				if (data->_inner_error_ != NULL) {
					goto __catch1_g_error;
				}
				goto __finally1;
				__catch1_g_error:
				{
					data->_error_ = data->_inner_error_;
					data->_inner_error_ = NULL;
					g_warning ("daemon.vala:780: Failed to launch URI %s", data->orig);
					data->result = (guint32) UNITY_ACTIVATION_STATUS_NOT_ACTIVATED;
					_g_error_free0 (data->_error_);
					_g_free0 (data->orig);
					_g_free0 (data->exec_or_dir);
					data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				__finally1:
				if (data->_inner_error_ != NULL) {
					_g_free0 (data->orig);
					_g_free0 (data->exec_or_dir);
					data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
					g_clear_error (&data->_inner_error_);
					return FALSE;
				}
				data->result = (guint32) UNITY_ACTIVATION_STATUS_ACTIVATED_HIDE_DASH;
				_g_free0 (data->orig);
				_g_free0 (data->exec_or_dir);
				data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			} else {
				data->_tmp12_ = NULL;
				data->_tmp12_ = unity_applications_place_utils_subst_tilde (data->orig);
				_g_free0 (data->exec_or_dir);
				data->exec_or_dir = data->_tmp12_;
				data->_tmp14_ = NULL;
				data->_tmp14_ = data->_tmp13_ = g_strsplit (data->exec_or_dir, " ", 0);
				data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
				data->args = data->_tmp14_;
				data->args_length1 = _vala_array_length (data->_tmp13_);
				data->_args_size_ = _vala_array_length (data->_tmp13_);
				{
					data->i = 0;
					{
						data->_tmp15_ = TRUE;
						while (TRUE) {
							if (!data->_tmp15_) {
								data->i++;
							}
							data->_tmp15_ = FALSE;
							if (!(data->i < data->args_length1)) {
								break;
							}
							data->_tmp16_ = NULL;
							data->_tmp16_ = unity_applications_place_utils_subst_tilde (data->args[data->i]);
							data->_tmp17_ = data->_tmp16_;
							_g_free0 (data->args[data->i]);
							data->args[data->i] = data->_tmp17_;
						}
					}
				}
			}
			unity_applications_place_runner_add_history (data->self->priv->runner, data->orig);
			_g_free0 (data->orig);
		} else {
			g_debug ("daemon.vala:794: Declined activation of URI '%s': Expected URI scheme " \
"unity-install:// or unity-runner://", data->uri);
			data->result = (guint32) UNITY_ACTIVATION_STATUS_NOT_ACTIVATED;
			_g_free0 (data->exec_or_dir);
			data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->exec_or_dir != NULL) {
		data->_tmp19_ = g_file_test (data->exec_or_dir, G_FILE_TEST_IS_DIR);
		data->_tmp18_ = data->_tmp19_;
	} else {
		data->_tmp18_ = FALSE;
	}
	if (data->_tmp18_) {
		data->_tmp20_ = g_strconcat ("file://", data->exec_or_dir, NULL);
		data->_tmp21_ = data->_tmp20_;
		g_app_info_launch_default_for_uri (data->_tmp21_, NULL, &data->_inner_error_);
		_g_free0 (data->_tmp21_);
		if (data->_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		goto __finally2;
		__catch2_g_error:
		{
			data->err = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_warning ("daemon.vala:803: Failed to open current folder '%s' in file manager: %" \
"s", data->exec_or_dir, data->err->message);
			data->result = (guint32) UNITY_ACTIVATION_STATUS_NOT_ACTIVATED;
			_g_error_free0 (data->err);
			_g_free0 (data->exec_or_dir);
			data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		__finally2:
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->exec_or_dir);
			data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	} else {
		data->_tmp22_ = NULL;
		data->_tmp22_ = g_get_home_dir ();
		data->home_dir = data->_tmp22_;
		g_spawn_async (data->home_dir, data->args, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			_g_free0 (data->exec_or_dir);
			data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		goto __finally3;
		__catch3_g_spawn_error:
		{
			data->e = data->_inner_error_;
			data->_inner_error_ = NULL;
			g_warning ("daemon.vala:814: Failed to spawn software-center or direct URI activat" \
"ion '%s': %s", data->uri, data->e->message);
			data->result = (guint32) UNITY_ACTIVATION_STATUS_NOT_ACTIVATED;
			_g_error_free0 (data->e);
			_g_free0 (data->exec_or_dir);
			data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
		__finally3:
		if (data->_inner_error_ != NULL) {
			_g_free0 (data->exec_or_dir);
			data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	data->result = (guint32) UNITY_ACTIVATION_STATUS_ACTIVATED_HIDE_DASH;
	_g_free0 (data->exec_or_dir);
	data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	_g_free0 (data->exec_or_dir);
	data->args = (_vala_array_free (data->args, data->args_length1, (GDestroyNotify) g_free), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


void unity_applications_place_daemon_append_events_with_group (UnityApplicationsPlaceDaemon* self, ZeitgeistResultSet* events, DeeModel* results, guint group_id, gint section_filter) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (events != NULL);
	g_return_if_fail (results != NULL);
	{
		ZeitgeistResultSet* _tmp0_ = NULL;
		ZeitgeistResultSet* _ev_it;
		ZeitgeistEvent* ev = NULL;
		_tmp0_ = _vala_zeitgeist_result_set_iterator (events);
		_ev_it = _tmp0_;
		while (TRUE) {
			ZeitgeistEvent* _tmp1_ = NULL;
			gchar* app_uri = NULL;
			gint _tmp2_;
			GAppInfo* _tmp6_ = NULL;
			GAppInfo* app;
			gboolean _tmp7_;
			GIcon* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			_tmp1_ = _vala_zeitgeist_result_set_next_value (_ev_it);
			ev = _tmp1_;
			if (!(ev != NULL)) {
				break;
			}
			_tmp2_ = zeitgeist_event_num_subjects (ev);
			if (_tmp2_ > 0) {
				ZeitgeistSubject* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				_tmp3_ = zeitgeist_event_get_subject (ev, 0);
				_tmp4_ = zeitgeist_subject_get_uri (_tmp3_);
				_tmp5_ = g_strdup (_tmp4_);
				_g_free0 (app_uri);
				app_uri = _tmp5_;
			} else {
				g_warning ("daemon.vala:838: Unexpected event without subject");
				_g_free0 (app_uri);
				continue;
			}
			_tmp6_ = unity_applications_place_utils_get_app_info_for_actor (app_uri);
			app = _tmp6_;
			if (app == NULL) {
				_g_object_unref0 (app);
				_g_free0 (app_uri);
				continue;
			}
			_tmp7_ = g_app_info_should_show (app);
			if (!_tmp7_) {
				_g_object_unref0 (app);
				_g_free0 (app_uri);
				continue;
			}
			_tmp8_ = g_app_info_get_icon (app);
			_tmp9_ = g_icon_to_string (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_app_info_get_display_name (app);
			_tmp12_ = g_app_info_get_description (app);
			dee_model_append (results, app_uri, _tmp10_, group_id, "application/x-desktop", _tmp11_, _tmp12_, NULL);
			_g_free0 (_tmp10_);
			_g_object_unref0 (app);
			_g_free0 (app_uri);
		}
		_g_object_unref0 (_ev_it);
	}
}


void unity_applications_place_daemon_check_empty_search (UnityApplicationsPlaceDaemon* self, UnityPlaceSearch* search, DeeModel* results_model) {
	guint _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results_model != NULL);
	_tmp0_ = dee_model_get_n_rows (results_model);
	if (_tmp0_ > 0) {
		return;
	}
	_tmp1_ = unity_applications_place_utils_search_is_invalid (search);
	if (_tmp1_) {
		return;
	}
	_tmp2_ = _ ("Your search did not match any applications");
	dee_model_append (results_model, "", "", UNITY_APPLICATIONS_PLACE_GROUP_EMPTY_SEARCH, "", _tmp2_, "", NULL);
	_tmp3_ = unity_place_search_get_search_string (search);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("http://google.com/#q=", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _ ("Search the web");
	dee_model_append (results_model, _tmp7_, "", UNITY_APPLICATIONS_PLACE_GROUP_EMPTY_SEARCH, "", _tmp8_, "", NULL);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
}


void unity_applications_place_daemon_check_empty_section (UnityApplicationsPlaceDaemon* self, UnityApplicationsPlaceSection section, DeeModel* results_model) {
	guint _tmp0_;
	gchar* msg = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results_model != NULL);
	_tmp0_ = dee_model_get_n_rows (results_model);
	if (_tmp0_ > 0) {
		return;
	}
	switch (section) {
		case UNITY_APPLICATIONS_PLACE_SECTION_ALL_APPLICATIONS:
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			_tmp1_ = _ ("There are no applications installed on this computer");
			_tmp2_ = g_strdup (_tmp1_);
			_g_free0 (msg);
			msg = _tmp2_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_ACCESSORIES:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = _ ("There are no accessories installed on this computer");
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (msg);
			msg = _tmp4_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_UNIVERSAL_ACCESS:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp5_ = _ ("There are no universal access applications installed on this computer");
			_tmp6_ = g_strdup (_tmp5_);
			_g_free0 (msg);
			msg = _tmp6_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_DEVELOPER_TOOLS:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp7_ = _ ("There are no developer tools installed on this computer");
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (msg);
			msg = _tmp8_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_EDUCATION:
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			_tmp9_ = _ ("There are no educational applications installed on this computer");
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (msg);
			msg = _tmp10_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_SCIENCE:
		{
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			_tmp11_ = _ ("There are no scientific or engineering applications installed on this " \
"computer");
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (msg);
			msg = _tmp12_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_GAMES:
		{
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp13_ = _ ("There are no games installed on this computer");
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (msg);
			msg = _tmp14_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_GRAPHICS:
		{
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			_tmp15_ = _ ("There are no graphics applications installed on this computer");
			_tmp16_ = g_strdup (_tmp15_);
			_g_free0 (msg);
			msg = _tmp16_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_INTERNET:
		{
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			_tmp17_ = _ ("There are no internet applications installed on this computer");
			_tmp18_ = g_strdup (_tmp17_);
			_g_free0 (msg);
			msg = _tmp18_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_MULTIMEDIA:
		{
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			_tmp19_ = _ ("There are no multimedia applications installed on this computer");
			_tmp20_ = g_strdup (_tmp19_);
			_g_free0 (msg);
			msg = _tmp20_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_OFFICE:
		{
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			_tmp21_ = _ ("There are no office applications installed on this computer");
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (msg);
			msg = _tmp22_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_THEMES:
		{
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			_tmp23_ = _ ("There are no theming or tweaking applications installed on this comput" \
"er");
			_tmp24_ = g_strdup (_tmp23_);
			_g_free0 (msg);
			msg = _tmp24_;
			break;
		}
		case UNITY_APPLICATIONS_PLACE_SECTION_SYSTEM:
		{
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			_tmp25_ = _ ("There are no system applications installed on this computer");
			_tmp26_ = g_strdup (_tmp25_);
			_g_free0 (msg);
			msg = _tmp26_;
			break;
		}
		default:
		{
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_;
			_tmp27_ = _ ("There are no applications installed on this computer");
			_tmp28_ = g_strdup (_tmp27_);
			_g_free0 (msg);
			msg = _tmp28_;
			g_warning ("daemon.vala:928: Unknown section: %u", (guint) section);
			break;
		}
	}
	dee_model_append (results_model, "", "", UNITY_APPLICATIONS_PLACE_GROUP_EMPTY_SECTION, "", msg, "", NULL);
	_g_free0 (msg);
}


UnityApplicationsPlaceDaemon* unity_applications_place_daemon_construct (GType object_type) {
	UnityApplicationsPlaceDaemon * self = NULL;
	self = (UnityApplicationsPlaceDaemon*) g_object_new (object_type, NULL);
	return self;
}


UnityApplicationsPlaceDaemon* unity_applications_place_daemon_new (void) {
	return unity_applications_place_daemon_construct (UNITY_APPLICATIONS_PLACE_TYPE_DAEMON);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _lambda5_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self) {
	guint _tmp0_;
	UnityPlaceSearch* _tmp1_ = NULL;
	UnityPlaceSearch* _tmp2_;
	UnityPlaceSearch* search;
	guint _tmp3_;
	UnityApplicationsPlaceSection section;
	UnityPlaceSearch* _tmp4_;
	guint _tmp5_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	if (!self->priv->all_models_synced) {
		return;
	}
	_tmp0_ = unity_place_entry_info_get_active_section (self->priv->applications);
	if (self->priv->previous_active_section == _tmp0_) {
		return;
	}
	_tmp1_ = unity_place_entry_info_get_active_search (self->priv->applications);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	search = _tmp2_;
	_tmp3_ = unity_place_entry_info_get_active_section (self->priv->applications);
	section = (UnityApplicationsPlaceSection) _tmp3_;
	unity_applications_place_daemon_update_entry_search (self, search, section, NULL, NULL);
	_tmp4_ = _g_object_ref0 (search);
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = _tmp4_;
	_tmp5_ = unity_place_entry_info_get_active_section (self->priv->applications);
	self->priv->previous_active_section = _tmp5_;
	_g_object_unref0 (search);
}


static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda5_ (_sender, pspec, self);
}


static void _lambda6_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self) {
	UnityPlaceSearch* _tmp0_ = NULL;
	UnityPlaceSearch* _tmp1_;
	UnityPlaceSearch* search;
	guint _tmp2_;
	UnityApplicationsPlaceSection section;
	gboolean _tmp3_;
	UnityPlaceSearch* _tmp4_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	if (!self->priv->all_models_synced) {
		return;
	}
	_tmp0_ = unity_place_entry_info_get_active_search (self->priv->applications);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	search = _tmp1_;
	_tmp2_ = unity_place_entry_info_get_active_section (self->priv->applications);
	section = (UnityApplicationsPlaceSection) _tmp2_;
	_tmp3_ = unity_applications_place_utils_search_has_really_changed (self->priv->previous_search, search);
	if (!_tmp3_) {
		_g_object_unref0 (search);
		return;
	}
	unity_applications_place_daemon_update_entry_search (self, search, section, NULL, NULL);
	_tmp4_ = _g_object_ref0 (search);
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = _tmp4_;
	_g_object_unref0 (search);
}


static void __lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda6_ (_sender, pspec, self);
}


static void _lambda7_ (GObject* obj, GParamSpec* pspec, UnityApplicationsPlaceDaemon* self) {
	UnityPlaceSearch* _tmp0_ = NULL;
	UnityPlaceSearch* _tmp1_;
	UnityPlaceSearch* search;
	gboolean _tmp2_;
	UnityPlaceSearch* _tmp3_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	if (!self->priv->all_models_synced) {
		return;
	}
	_tmp0_ = unity_place_entry_info_get_active_global_search (self->priv->applications);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	search = _tmp1_;
	_tmp2_ = unity_applications_place_utils_search_has_really_changed (self->priv->previous_global_search, search);
	if (!_tmp2_) {
		_g_object_unref0 (search);
		return;
	}
	unity_applications_place_daemon_update_global_search (self, search, NULL, NULL);
	_tmp3_ = _g_object_ref0 (search);
	_g_object_unref0 (self->priv->previous_global_search);
	self->priv->previous_global_search = _tmp3_;
	_g_object_unref0 (search);
}


static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda7_ (_sender, pspec, self);
}


static void _unity_applications_place_daemon_on_appinfo_changed_unity_app_info_manager_changed (UnityAppInfoManager* _sender, const gchar* id, GAppInfo* new_appinfo, gpointer self) {
	unity_applications_place_daemon_on_appinfo_changed (self, id, new_appinfo);
}


static void _unity_applications_place_daemon_check_models_synced_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_applications_place_daemon_check_models_synced (self, _sender, pspec);
}


static GObject * unity_applications_place_daemon_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityApplicationsPlaceDaemon * self;
	DeeSharedModel* _tmp0_ = NULL;
	DeeSharedModel* sections_model;
	DeeSharedModel* _tmp1_ = NULL;
	DeeSharedModel* groups_model;
	DeeSharedModel* _tmp2_ = NULL;
	DeeSharedModel* global_groups_model;
	DeeSharedModel* _tmp3_ = NULL;
	DeeSharedModel* results_model;
	DeeSharedModel* _tmp4_ = NULL;
	DeeSharedModel* global_results_model;
	GeeArrayList* _tmp5_ = NULL;
	UnityPlaceEntryInfo* _tmp6_ = NULL;
	UnityPlaceRendererInfo* _tmp7_ = NULL;
	UnityPlaceRendererInfo* _tmp8_ = NULL;
	UnityPlaceRendererInfo* _tmp9_ = NULL;
	UnityPlaceRendererInfo* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	ZeitgeistLog* _tmp14_ = NULL;
	ZeitgeistIndex* _tmp15_ = NULL;
	UnityPackageSearcher* _tmp16_ = NULL;
	GeeArrayList* _tmp17_ = NULL;
	GHashTable* _tmp18_ = NULL;
	UnityAppInfoManager* _tmp19_ = NULL;
	UnityAppInfoManager* _tmp20_;
	UnityApplicationsPlaceRunner* _tmp21_ = NULL;
	GRegex* _tmp22_ = NULL;
	GRegex* _tmp23_;
	UnityPlaceController* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_applications_place_daemon_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_APPLICATIONS_PLACE_DAEMON (obj);
	_tmp0_ = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.ApplicationsPlace.SectionsModel");
	sections_model = _tmp0_;
	dee_model_set_schema ((DeeModel*) sections_model, "s", "s", NULL);
	_tmp1_ = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.ApplicationsPlace.GroupsModel");
	groups_model = _tmp1_;
	dee_model_set_schema ((DeeModel*) groups_model, "s", "s", "s", NULL);
	_tmp2_ = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.ApplicationsPlace.GlobalGroupsModel");
	global_groups_model = _tmp2_;
	dee_model_set_schema ((DeeModel*) global_groups_model, "s", "s", "s", NULL);
	_tmp3_ = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.ApplicationsPlace.ResultsModel");
	results_model = _tmp3_;
	dee_model_set_schema ((DeeModel*) results_model, "s", "s", "u", "s", "s", "s", NULL);
	_tmp4_ = (DeeSharedModel*) dee_shared_model_new ("com.canonical.Unity.ApplicationsPlace.GlobalResultsModel");
	global_results_model = _tmp4_;
	dee_model_set_schema ((DeeModel*) global_results_model, "s", "s", "u", "s", "s", "s", NULL);
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->priv->section_queries);
	self->priv->section_queries = (GeeList*) _tmp5_;
	unity_applications_place_daemon_populate_section_queries (self);
	unity_applications_place_daemon_populate_zg_templates (self);
	_tmp6_ = unity_place_entry_info_new ("/com/canonical/unity/applicationsplace/applications");
	_g_object_unref0 (self->priv->applications);
	self->priv->applications = _tmp6_;
	unity_place_entry_info_set_sections_model (self->priv->applications, (DeeModel*) sections_model);
	_tmp7_ = unity_place_entry_info_get_entry_renderer_info (self->priv->applications);
	unity_place_renderer_info_set_groups_model (_tmp7_, (DeeModel*) groups_model);
	_tmp8_ = unity_place_entry_info_get_entry_renderer_info (self->priv->applications);
	unity_place_renderer_info_set_results_model (_tmp8_, (DeeModel*) results_model);
	_tmp9_ = unity_place_entry_info_get_global_renderer_info (self->priv->applications);
	unity_place_renderer_info_set_groups_model (_tmp9_, (DeeModel*) global_groups_model);
	_tmp10_ = unity_place_entry_info_get_global_renderer_info (self->priv->applications);
	unity_place_renderer_info_set_results_model (_tmp10_, (DeeModel*) global_results_model);
	_tmp11_ = string_to_string (CONFIG_PREFIX);
	_tmp12_ = g_strconcat (_tmp11_, "/share/unity/themes/applications.png", NULL);
	_tmp13_ = _tmp12_;
	unity_place_entry_info_set_icon (self->priv->applications, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = zeitgeist_log_new ();
	_g_object_unref0 (self->priv->log);
	self->priv->log = _tmp14_;
	_tmp15_ = zeitgeist_index_new ();
	_g_object_unref0 (self->priv->zg_index);
	self->priv->zg_index = _tmp15_;
	_tmp16_ = unity_package_searcher_new ();
	_unity_package_searcher_free0 (self->priv->pkgsearcher);
	self->priv->pkgsearcher = _tmp16_;
	if (self->priv->pkgsearcher == NULL) {
		g_critical ("daemon.vala:107: Failed to load Software Center index. 'Apps Available" \
" for Download' will not be listed");
	}
	_tmp17_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_g_object_unref0 (self->priv->image_extensions);
	self->priv->image_extensions = (GeeList*) _tmp17_;
	gee_collection_add ((GeeCollection*) self->priv->image_extensions, "png");
	gee_collection_add ((GeeCollection*) self->priv->image_extensions, "xpm");
	gee_collection_add ((GeeCollection*) self->priv->image_extensions, "svg");
	gee_collection_add ((GeeCollection*) self->priv->image_extensions, "tiff");
	gee_collection_add ((GeeCollection*) self->priv->image_extensions, "ico");
	gee_collection_add ((GeeCollection*) self->priv->image_extensions, "tif");
	gee_collection_add ((GeeCollection*) self->priv->image_extensions, "jpg");
	_g_object_unref0 (self->priv->previous_search);
	self->priv->previous_search = NULL;
	_g_object_unref0 (self->priv->previous_global_search);
	self->priv->previous_global_search = NULL;
	self->priv->previous_active_section = (guint) UNITY_APPLICATIONS_PLACE_SECTION_LAST_SECTION;
	unity_applications_place_daemon_build_app_menu_index (self);
	_tmp18_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->file_icon_cache);
	self->priv->file_icon_cache = _tmp18_;
	g_signal_connect_object ((GObject*) self->priv->applications, "notify::active-section", (GCallback) __lambda5__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->applications, "notify::active-search", (GCallback) __lambda6__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self->priv->applications, "notify::active-global-search", (GCallback) __lambda7__g_object_notify, self, 0);
	_tmp19_ = unity_app_info_manager_get_instance ();
	_tmp20_ = _tmp19_;
	g_signal_connect_object (_tmp20_, "changed", (GCallback) _unity_applications_place_daemon_on_appinfo_changed_unity_app_info_manager_changed, self, 0);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = unity_applications_place_runner_new (self);
	_g_object_unref0 (self->priv->runner);
	self->priv->runner = _tmp21_;
	_tmp22_ = g_regex_new ("[a-z]+:.+", 0, 0, &_inner_error_);
	_tmp23_ = _tmp22_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch4_g_regex_error;
		}
		_g_object_unref0 (global_results_model);
		_g_object_unref0 (results_model);
		_g_object_unref0 (global_groups_model);
		_g_object_unref0 (groups_model);
		_g_object_unref0 (sections_model);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_g_regex_unref0 (self->priv->uri_regex);
	self->priv->uri_regex = _tmp23_;
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_regex_unref0 (self->priv->uri_regex);
		self->priv->uri_regex = NULL;
		g_critical ("daemon.vala:189: Failed to compile URI regex. URL launching will be di" \
"sabled");
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (global_results_model);
		_g_object_unref0 (results_model);
		_g_object_unref0 (global_groups_model);
		_g_object_unref0 (groups_model);
		_g_object_unref0 (sections_model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp24_ = unity_place_controller_new ("/com/canonical/unity/applicationsplace");
	_g_object_unref0 (self->priv->control);
	self->priv->control = _tmp24_;
	unity_place_controller_add_entry (self->priv->control, self->priv->applications);
	unity_place_controller_add_entry (self->priv->control, self->priv->runner->place_entry);
	unity_place_controller_set_activation (self->priv->control, (UnityActivation*) self);
	unity_place_controller_export (self->priv->control, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch5_g_io_error;
		}
		_g_object_unref0 (global_results_model);
		_g_object_unref0 (results_model);
		_g_object_unref0 (global_groups_model);
		_g_object_unref0 (groups_model);
		_g_object_unref0 (sections_model);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	goto __finally5;
	__catch5_g_io_error:
	{
		GError * _error_;
		const gchar* _tmp25_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = unity_place_controller_get_dbus_path (self->priv->control);
		g_critical ("daemon.vala:202: Failed to export DBus service for '%s': %s", _tmp25_, _error_->message);
		_g_error_free0 (_error_);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (global_results_model);
		_g_object_unref0 (results_model);
		_g_object_unref0 (global_groups_model);
		_g_object_unref0 (groups_model);
		_g_object_unref0 (sections_model);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	g_signal_connect_object ((GObject*) sections_model, "notify::synchronized", (GCallback) _unity_applications_place_daemon_check_models_synced_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) groups_model, "notify::synchronized", (GCallback) _unity_applications_place_daemon_check_models_synced_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) global_groups_model, "notify::synchronized", (GCallback) _unity_applications_place_daemon_check_models_synced_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) results_model, "notify::synchronized", (GCallback) _unity_applications_place_daemon_check_models_synced_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) global_results_model, "notify::synchronized", (GCallback) _unity_applications_place_daemon_check_models_synced_g_object_notify, self, 0);
	self->priv->all_models_synced = FALSE;
	_g_object_unref0 (global_results_model);
	_g_object_unref0 (results_model);
	_g_object_unref0 (global_groups_model);
	_g_object_unref0 (groups_model);
	_g_object_unref0 (sections_model);
	return obj;
}


static void unity_applications_place_daemon_class_init (UnityApplicationsPlaceDaemonClass * klass) {
	unity_applications_place_daemon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityApplicationsPlaceDaemonPrivate));
	G_OBJECT_CLASS (klass)->constructor = unity_applications_place_daemon_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_applications_place_daemon_finalize;
}


static void unity_applications_place_daemon_unity_activation_interface_init (UnityActivationIface * iface) {
	unity_applications_place_daemon_unity_activation_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (guint32 (*)(UnityActivation* ,const gchar* ,GError**)) unity_applications_place_daemon_real_activate;
	iface->activate_finish = unity_applications_place_daemon_real_activate_finish;
}


static void unity_applications_place_daemon_instance_init (UnityApplicationsPlaceDaemon * self) {
	self->priv = UNITY_APPLICATIONS_PLACE_DAEMON_GET_PRIVATE (self);
	self->priv->app_menu_changed_reindex_timeout = (guint) 0;
	self->priv->app_menu = NULL;
}


static void unity_applications_place_daemon_finalize (GObject* obj) {
	UnityApplicationsPlaceDaemon * self;
	self = UNITY_APPLICATIONS_PLACE_DAEMON (obj);
	_g_object_unref0 (self->priv->log);
	_g_object_unref0 (self->priv->zg_index);
	_unity_package_searcher_free0 (self->priv->pkgsearcher);
	_unity_package_searcher_free0 (self->appsearcher);
	_g_object_unref0 (self->priv->control);
	_g_object_unref0 (self->priv->applications);
	_g_object_unref0 (self->priv->runner);
	_g_object_unref0 (self->priv->section_queries);
	_g_object_unref0 (self->priv->image_extensions);
	_g_hash_table_unref0 (self->priv->file_icon_cache);
	_g_object_unref0 (self->priv->previous_search);
	_g_object_unref0 (self->priv->previous_global_search);
	_g_ptr_array_unref0 (self->priv->zg_templates);
	_gmenu_tree_unref0 (self->priv->app_menu);
	_g_regex_unref0 (self->priv->uri_regex);
	G_OBJECT_CLASS (unity_applications_place_daemon_parent_class)->finalize (obj);
}


GType unity_applications_place_daemon_get_type (void) {
	static volatile gsize unity_applications_place_daemon_type_id__volatile = 0;
	if (g_once_init_enter (&unity_applications_place_daemon_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityApplicationsPlaceDaemonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_applications_place_daemon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityApplicationsPlaceDaemon), 0, (GInstanceInitFunc) unity_applications_place_daemon_instance_init, NULL };
		static const GInterfaceInfo unity_activation_info = { (GInterfaceInitFunc) unity_applications_place_daemon_unity_activation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_applications_place_daemon_type_id;
		unity_applications_place_daemon_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityApplicationsPlaceDaemon", &g_define_type_info, 0);
		g_type_add_interface_static (unity_applications_place_daemon_type_id, UNITY_TYPE_ACTIVATION, &unity_activation_info);
		g_once_init_leave (&unity_applications_place_daemon_type_id__volatile, unity_applications_place_daemon_type_id);
	}
	return unity_applications_place_daemon_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



