/* utils.c generated by valac 0.12.0, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <unity.h>
#include <gee.h>
#include <pwd.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))



GAppInfo* unity_applications_place_utils_get_app_info_for_actor (const gchar* actor);
gchar* unity_applications_place_utils_get_desktop_id_for_actor (const gchar* actor);
gboolean unity_applications_place_utils_check_actor_has_category (const gchar* actor, GeeSet* categories);
gboolean unity_applications_place_utils_search_is_invalid (UnityPlaceSearch* search);
gboolean unity_applications_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search);
gchar* unity_applications_place_utils_subst_tilde (const gchar* s);


GAppInfo* unity_applications_place_utils_get_app_info_for_actor (const gchar* actor) {
	GAppInfo* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* desktop_id;
	UnityAppInfoManager* _tmp1_ = NULL;
	UnityAppInfoManager* _tmp2_;
	GAppInfo* _tmp3_ = NULL;
	GAppInfo* _tmp4_;
	g_return_val_if_fail (actor != NULL, NULL);
	_tmp0_ = unity_applications_place_utils_get_desktop_id_for_actor (actor);
	desktop_id = _tmp0_;
	_tmp1_ = unity_app_info_manager_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = unity_app_info_manager_lookup (_tmp2_, desktop_id);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	_g_free0 (desktop_id);
	return result;
}


gboolean unity_applications_place_utils_check_actor_has_category (const gchar* actor, GeeSet* categories) {
	gboolean result = FALSE;
	UnityAppInfoManager* _tmp0_ = NULL;
	UnityAppInfoManager* appman;
	gchar* _tmp1_ = NULL;
	gchar* desktop_id;
	GAppInfo* _tmp2_ = NULL;
	GAppInfo* appinfo;
	gint _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** actor_cats;
	gint actor_cats_length1;
	gint _actor_cats_size_;
	g_return_val_if_fail (actor != NULL, FALSE);
	if (categories == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = unity_app_info_manager_get_instance ();
	appman = _tmp0_;
	_tmp1_ = unity_applications_place_utils_get_desktop_id_for_actor (actor);
	desktop_id = _tmp1_;
	_tmp2_ = unity_app_info_manager_lookup (appman, desktop_id);
	appinfo = _tmp2_;
	if (appinfo == NULL) {
		result = FALSE;
		_g_object_unref0 (appinfo);
		_g_free0 (desktop_id);
		_g_object_unref0 (appman);
		return result;
	}
	_tmp4_ = unity_app_info_manager_get_categories (appman, desktop_id, &_tmp3_);
	actor_cats = _tmp4_;
	actor_cats_length1 = _tmp3_;
	_actor_cats_size_ = _tmp3_;
	if (actor_cats == NULL) {
		result = FALSE;
		_g_object_unref0 (appinfo);
		_g_free0 (desktop_id);
		_g_object_unref0 (appman);
		return result;
	}
	{
		gchar** cat_collection;
		int cat_collection_length1;
		int cat_it;
		cat_collection = actor_cats;
		cat_collection_length1 = actor_cats_length1;
		for (cat_it = 0; cat_it < actor_cats_length1; cat_it = cat_it + 1) {
			gchar* _tmp5_;
			gchar* cat;
			_tmp5_ = g_strdup (cat_collection[cat_it]);
			cat = _tmp5_;
			{
				gboolean _tmp6_;
				_tmp6_ = gee_collection_contains ((GeeCollection*) categories, cat);
				if (_tmp6_) {
					result = TRUE;
					_g_free0 (cat);
					_g_object_unref0 (appinfo);
					_g_free0 (desktop_id);
					_g_object_unref0 (appman);
					return result;
				}
				_g_free0 (cat);
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (appinfo);
	_g_free0 (desktop_id);
	_g_object_unref0 (appman);
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


gchar* unity_applications_place_utils_get_desktop_id_for_actor (const gchar* actor) {
	gchar* result = NULL;
	gboolean _tmp0_;
	gchar* _tmp13_;
	g_return_val_if_fail (actor != NULL, NULL);
	_tmp0_ = g_str_has_prefix (actor, "application://");
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp1_ = string_substring (actor, (glong) 14, (glong) (-1));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		result = _tmp4_;
		return result;
	} else {
		gboolean _tmp5_;
		_tmp5_ = g_str_has_prefix (actor, "app://");
		if (_tmp5_) {
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp6_ = string_substring (actor, (glong) 6, (glong) (-1));
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strdup (_tmp7_);
			_tmp9_ = _tmp8_;
			_g_free0 (_tmp7_);
			result = _tmp9_;
			return result;
		} else {
			gboolean _tmp10_;
			_tmp10_ = g_str_has_prefix (actor, "/");
			if (_tmp10_) {
				GFile* _tmp11_ = NULL;
				GFile* f;
				gchar* _tmp12_ = NULL;
				_tmp11_ = g_file_new_for_path (actor);
				f = _tmp11_;
				_tmp12_ = g_file_get_basename (f);
				result = _tmp12_;
				_g_object_unref0 (f);
				return result;
			}
		}
	}
	_tmp13_ = g_strdup (actor);
	result = _tmp13_;
	return result;
}


gboolean unity_applications_place_utils_search_is_invalid (UnityPlaceSearch* search) {
	gboolean result = FALSE;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_;
	if (search == NULL) {
		result = TRUE;
		return result;
	} else {
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = unity_place_search_get_search_string (search);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_ == NULL;
		_g_free0 (_tmp1_);
		if (_tmp2_) {
			result = TRUE;
			return result;
		}
	}
	_tmp3_ = unity_place_search_get_search_string (search);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "") == 0;
	_g_free0 (_tmp4_);
	result = _tmp5_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


gboolean unity_applications_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* s1 = NULL;
	gchar* s2 = NULL;
	if (old_search == NULL) {
		_tmp0_ = new_search == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (old_search == NULL) {
		gchar* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = unity_place_search_get_search_string (new_search);
		_g_free0 (s1);
		s1 = _tmp1_;
		if (s1 == NULL) {
			_tmp2_ = TRUE;
		} else {
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = string_strip (s1);
			_tmp4_ = _tmp3_;
			_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
			_g_free0 (_tmp4_);
		}
		if (_tmp2_) {
			result = FALSE;
			_g_free0 (s2);
			_g_free0 (s1);
			return result;
		} else {
			result = TRUE;
			_g_free0 (s2);
			_g_free0 (s1);
			return result;
		}
	} else {
		if (new_search == NULL) {
			gchar* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			_tmp5_ = unity_place_search_get_search_string (old_search);
			_g_free0 (s2);
			s2 = _tmp5_;
			if (s2 == NULL) {
				_tmp6_ = TRUE;
			} else {
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				_tmp7_ = string_strip (s2);
				_tmp8_ = _tmp7_;
				_tmp6_ = g_strcmp0 (_tmp8_, "") == 0;
				_g_free0 (_tmp8_);
			}
			if (_tmp6_) {
				result = FALSE;
				_g_free0 (s2);
				_g_free0 (s1);
				return result;
			} else {
				result = TRUE;
				_g_free0 (s2);
				_g_free0 (s1);
				return result;
			}
		} else {
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp9_ = unity_place_search_get_search_string (new_search);
			_g_free0 (s1);
			s1 = _tmp9_;
			_tmp10_ = unity_place_search_get_search_string (old_search);
			_g_free0 (s2);
			s2 = _tmp10_;
			if (s1 == NULL) {
				gboolean _tmp11_ = FALSE;
				if (s2 == NULL) {
					_tmp11_ = TRUE;
				} else {
					gchar* _tmp12_ = NULL;
					gchar* _tmp13_;
					_tmp12_ = string_strip (s2);
					_tmp13_ = _tmp12_;
					_tmp11_ = g_strcmp0 (_tmp13_, "") == 0;
					_g_free0 (_tmp13_);
				}
				if (_tmp11_) {
					result = FALSE;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				} else {
					result = TRUE;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				}
			} else {
				if (s2 == NULL) {
					gboolean _tmp14_ = FALSE;
					if (s1 == NULL) {
						_tmp14_ = TRUE;
					} else {
						gchar* _tmp15_ = NULL;
						gchar* _tmp16_;
						_tmp15_ = string_strip (s1);
						_tmp16_ = _tmp15_;
						_tmp14_ = g_strcmp0 (_tmp16_, "") == 0;
						_g_free0 (_tmp16_);
					}
					if (_tmp14_) {
						result = FALSE;
						_g_free0 (s2);
						_g_free0 (s1);
						return result;
					} else {
						result = TRUE;
						_g_free0 (s2);
						_g_free0 (s1);
						return result;
					}
				} else {
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_;
					gchar* _tmp19_ = NULL;
					gchar* _tmp20_;
					gboolean _tmp21_;
					_tmp17_ = string_strip (s1);
					_tmp18_ = _tmp17_;
					_tmp19_ = string_strip (s2);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_strcmp0 (_tmp18_, _tmp20_) != 0;
					_g_free0 (_tmp20_);
					_g_free0 (_tmp18_);
					result = _tmp21_;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				}
			}
		}
	}
	_g_free0 (s2);
	_g_free0 (s1);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	result = ((gchar*) self)[index];
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	if (_result_ != NULL) {
		result = (gint) (_result_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* unity_applications_place_utils_subst_tilde (const gchar* s) {
	gchar* result = NULL;
	gint k = 0;
	gchar* name = NULL;
	struct passwd* pw = NULL;
	gchar _tmp0_;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_;
	gint _tmp10_;
	struct passwd* _tmp13_ = NULL;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = string_get (s, (glong) 0);
	if (_tmp0_ != '~') {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (s);
		result = _tmp1_;
		_g_free0 (name);
		return result;
	}
	_tmp3_ = strlen (s);
	if (_tmp3_ == 1) {
		_tmp2_ = TRUE;
	} else {
		gchar _tmp4_;
		_tmp4_ = string_get (s, (glong) 1);
		_tmp2_ = _tmp4_ == '/';
	}
	if (_tmp2_) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = g_get_home_dir ();
		_tmp6_ = string_substring (s, (glong) 1, (glong) (-1));
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp5_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		_g_free0 (name);
		return result;
	}
	_tmp10_ = string_index_of (s, "/", 0);
	k = _tmp10_;
	if (k == (-1)) {
		gchar* _tmp11_ = NULL;
		_tmp11_ = string_substring (s, (glong) 1, (glong) (-1));
		_g_free0 (name);
		name = _tmp11_;
	} else {
		gchar* _tmp12_ = NULL;
		_tmp12_ = string_substring (s, (glong) 1, (glong) (k - 1));
		_g_free0 (name);
		name = _tmp12_;
	}
	_tmp13_ = getpwnam (name);
	pw = _tmp13_;
	if (pw == NULL) {
		gchar* _tmp14_;
		_tmp14_ = g_strdup (s);
		result = _tmp14_;
		_g_free0 (name);
		return result;
	}
	if (k == (-1)) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (pw->pw_dir);
		result = _tmp15_;
		_g_free0 (name);
		return result;
	} else {
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp16_ = string_substring (s, (glong) k, (glong) (-1));
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat (pw->pw_dir, _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		result = _tmp19_;
		_g_free0 (name);
		return result;
	}
	_g_free0 (name);
}



