/*****************************************************************************
 *
 * utouch-frame - Touch Frame Library
 *
 * Copyright (C) 2011-2012 Canonical Ltd.
 *
 * This library is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 ****************************************************************************/

#ifndef FRAME_IMPL_H
#define FRAME_IMPL_H

#include <utouch/frame.h>

struct utouch_frame_engine {
	int num_frames;
	int num_slots;
	int hold_ms;
	int frame;
	int slot;
	struct utouch_surface *surface;
	struct utouch_frame **frames;
	struct utouch_frame *next;
	int *evmap;
	float map[9];
	unsigned int semi_mt_num_active;
	utouch_coordinate_transform_cb coordinate_transform;
	void *coordinate_transform_user_data;
};

#endif
