// ==UserScript==
// @include       http://*.live.com/*
// @include       https://*.live.com/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    var i, ids = ['c_murc', 'c_mocc'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function messagingIndicatorSetup() {
    var inboxCountElement = document.getElementById('c_murc');
    var messengerCountElement = document.getElementById('c_mocc');
    var checkMessangesCount = wrapCallback(function () {
        var count = inboxCountElement.textContent.match(/\d+/)[0];

        Unity.MessagingIndicator.showIndicator("Inbox", { count: count });

        count = '0';
        if (messengerCountElement.textContent.length) {
            count = messengerCountElement.textContent.match(/\d+/)[0];
        }

        Unity.MessagingIndicator.showIndicator("Messenger", { count: count });
    });

    inboxCountElement.addEventListener('DOMSubtreeModified', checkMessangesCount, false);
    messengerCountElement.addEventListener('DOMSubtreeModified', checkMessangesCount, false);

    checkMessangesCount();
}

setTimeout(function self() {
    var i, ids = ['c_murc', 'c_mocc'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            setTimeout(self, 1000);
            return;
        }
    }
    Unity.init({ name: "live.com",
		 domain: 'mail.live.com',
		 homepage: 'http://mail.live.com',
                 iconUrl: "icon://unity-webapps-hotmail",
                 onInit: wrapCallback(messagingIndicatorSetup) });
}, 1000);
