// ==UserScript==
// @include       https://www.google.*/reader/view/*
// @include       http://www.google.*/reader/view/*
// @require       utils.js
// @require       google-common.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function forEachFolder(callback) {
    function expandNode(node, path) {
        var i, childs = node.childNodes;
        for (i = 0; i < childs.length; i++) {
            var link = childs[i].childNodes[1];

            callback(link.textContent, link.href, path);
            var title = link.textContent.match(/^[^(]+/)[0];
            if (childs[i].childNodes.length > 2) {
                expandNode(childs[i].childNodes[2], path + '/' + title);
            }
        }
    }
    var root = document.evaluate('//div[@id="sub-tree-container"]/ul/li/ul',
                                 document, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;
    expandNode(root, '/Subscriptions');
}

function isCorrectPage() {
    var i, ids = ['reading-list-unread-count'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function messagingIndicatorSetup() {
    var countElement = document.getElementById('lhn-subscriptions');
    var checkMessangesCount = wrapCallback(function () {
        Unity.MessagingIndicator.clearIndicators();
        forEachFolder(function (text, link, path) {
            var title = text.match(/^[^(]+/)[0];
            var count = '0';
            if (text.match(/\d+/)) {
                count = text.match(/\d+/)[0];
            }
            Unity.MessagingIndicator.showIndicator(title, { count: count,
                                                            callback: makeRedirector(link) });
        });
    });

    countElement.addEventListener('DOMSubtreeModified', checkMessangesCount, false);

    checkMessangesCount();

    doMainMenuIntegration(document);
    forEachFolder(function (text, link, path) {
        var title = text.match(/^[^(]+/)[0];
        Unity.addAction(path + '/' + title, makeRedirector(link.href));
    });
}

if (isCorrectPage()) {
    Unity.init({ name: 'Google Reader',
		 domain: window.location.hostname,
                 homepage: 'http://' + window.location.hostname + '/reader/view/',
		 iconUrl: 'icon://unity-webapps-google-reader',
                 onInit: wrapCallback(messagingIndicatorSetup) });
}
