// ==UserScript==
// @include       http://*
// @require       utils.js
// ==/UserScript==

function getIconURL() {
    try {
        var logo = document.getElementById('logo');

        return logo.firstChild.src;
    } catch (x) { return null; }
}

function isCorrectPage() {
    try {
        return getIconURL().match('/assets/images/subway.png$');
    } catch (x) { return false; }
}

function update() {
    var i, snapshot = document.evaluate('//div[@id="channels"]/div[@class="channel"]',
					document, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null);

    Unity.MessagingIndicator.clearIndicators();

    var totalMentions = 0;
    for (i = 0; i < snapshot.snapshotLength; i++) {
        var node = snapshot.snapshotItem(i);

        var unread = document.evaluate('span[@class="unread"]', node, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;
        var unreadMentions = document.evaluate('span[@class="unread-mentions"]', node, null, XPathResult.ANY_UNORDERED_NODE_TYPE, null).singleNodeValue;

        var unreadCount = 0, unreadMentionsCount = 0;
        if (unread.style.display !== 'none' && unread.textContent) {
            unreadCount = Number(unread.textContent);
        }
        if (unreadMentions.style.display !== 'none' && unreadMentions.textContent) {
            unreadMentionsCount = Number(unreadMentions.textContent);
        }

        totalMentions += unreadMentionsCount;

        if (unreadCount !== 0) {
            var name = node.firstChild.textContent;

            Unity.MessagingIndicator.showIndicator(name, { count: unreadCount,
							   callback: node.click.bind(node) });
        }
    }

    if (totalMentions) {
        Unity.Launcher.setCount(Number(totalMentions));
    } else {
        Unity.Launcher.clearCount();
    }
}

function onInit() {
    setInterval(wrapCallback(update), 500);
    update();
}

setTimeout(function () {
    if (isCorrectPage()) {
        window.Unity = external.getUnityObject(1);

        Unity.init({ name: "Subway IRC",
		     domain: window.location.hostname,
		     homepage: window.location.toString(),
                     iconUrl: getIconURL(),
                     onInit: wrapCallback(onInit) });
    }
}, 1000);

