function Test(browser) {
    this._init(browser);
}

Test.prototype = {
    _init: function (browser) {
        this._state = 0;
        this._login = browser.getLogin();
        this._password = browser.getPassword();
        this._url = browser.getUrl();
        this._browser = browser;
        browser.open(this._url);
    },

    onLoad: function () {
        if (!this._login) {
            this._browser.skipTest();
        }
        if (this._state === 0) {
            this._state++;
            this._browser.injectScript(makeAuthorizer('session_key-login', 'session_password-login', this._login, this._password));
        } else {
            setTimeout(this._browser.finish.bind(this._browser),  5000);
        }
    },

    validateCallLog: function (log) {
        assertEquals('Unity.init', log[0].func, 'Unity.init');
        assertEquals('Unity.Launcher.addAction', log[1].func, 'Unity.Launcher.addAction');
        assertEquals('Unity.addAction', log[2].func, 'Unity.addAction');
        var i, found = false;
        for (i = 0; i < log.length; i++) {
            if (log[i].func === 'Unity.MessagingIndicator.showIndicator') {
                found = true;
            }
        }
        assertTrue('Unity.MessagingIndicator.showIndicator', found);
    },

    scriptName: 'LinkedIn/LinkedIn.user.js'
};
