/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.UserModKeyRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.UpdateAccessKeyRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMUserModKeyDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMUserModKeyDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof UserModKeyRequest) {
            UserModKeyRequest req = (UserModKeyRequest)request;
            LOG.debug((Object)("Modifying keys " + req));
            UpdateAccessKeyRequest accessKeyRequest = new UpdateAccessKeyRequest();
            accessKeyRequest.setStatus(req.getStatus().name());
            accessKeyRequest.setAccessKeyId(req.getKeyId());
            accessKeyRequest.setUserName(req.getUserName());
            LOG.debug((Object)"Updating accesskey status");
            this.getClient().updateAccessKey(accessKeyRequest);
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

