/* NumericValueDelegate.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.values;

import be.ugent.caagt.jmathtex.TeXConstants;
import be.ugent.caagt.jmathtex.TeXFormula;

import javax.swing.JLabel;

import org.jdom.Element;

/**
 *
 */
public abstract class NumericValueDelegate<T extends NumericValue> extends AbstractInvariantValueDelegate<T> {
    
    //
    public void saveValue (Element element, T value) {
        element.setText (Double.toHexString (value.value));
    }
    
    //
    private static final TeXFormula INFINITY_FORMULA
            = new TeXFormula().addSymbol("infty");
    
    /**
     * Initialize a label which is used to display this invariant value.
     * The standard implementation renders the text returned by
     * {@link InvariantValue#toText} if the value is finite. If the value is infinite,
     * the icon is set to display the symbol for infinity.
     */
    @Override
    public void initLabel(JLabel label, T value) {
        if (Double.isInfinite(value.asDouble())) {
            label.setIcon(INFINITY_FORMULA.createTeXIcon(
                    TeXConstants.STYLE_DISPLAY, label.getFont().getSize()+2));
            label.setText(null);
        } else
            super.initLabel(label, value);
    }

    
}
