/* ConjectureHistoryListSaver.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io.list;

import java.io.IOException;
import java.io.OutputStream;

import org.grinvin.conjecture.history.ConjectureHistoryEntry;
import org.grinvin.io.LoaderSaverHelper;
import org.grinvin.io.SectionSaver;
import org.grinvin.list.ConjectureHistoryList;

import org.jdom.DocType;
import org.jdom.Element;

/**
 * Helper methods for saving the conjecture history to disk.
 */
public final class ConjectureHistoryListSaver {
    
    //
    private static final String PUBLIC_ID = "-//GrInvIn IO//HistoryList 1.0//EN";
    
    // do not instantiate
    private ConjectureHistoryListSaver () {}
    
    private static void save(ConjectureHistoryList list, OutputStream out) throws IOException {
        Element element = new Element("historylist");
        for (ConjectureHistoryEntry entry : list) {
            element.addContent(entry.getDelegate().toElement(entry));
        }
        LoaderSaverHelper.outputXML(element,
                new DocType("historylist", PUBLIC_ID, "http://downloads.grinvin.org/dtds/io/historylist-1.0.dtd"),
                out);
    }
    
    public static void saveIntoWorkspace(ConjectureHistoryList list, SectionSaver ssaver) throws IOException {
        saveContentsIntoWorkspace(list, ssaver);
        String name = LoaderSaverHelper.prepareSessionURI(list, "conjecturehistorylists", "ghl");
        save(list, ssaver.createSection(name));
    }
    
    private static void saveContentsIntoWorkspace(ConjectureHistoryList list, SectionSaver ssaver) throws IOException {
        for (ConjectureHistoryEntry entry : list)
            entry.getDelegate().saveIntoWorkspace(ssaver, entry);
    }
    
    /**
     * Save a list of conjecture history entries as a directory with an XML file. 
     */
    public static void save(ConjectureHistoryList history, SectionSaver ssaver) throws IOException {
        OutputStream out = ssaver.createSection("chist.xml");
        saveContentsIntoWorkspace(history, ssaver);
        save(history, out);
    }
    
}
