#line 1 "cfunc.mod"
#include "cm.h"
#line 1 "cfunc.mod"
/* $Id: cfunc.mod,v 1.2 2003/08/05 17:20:43 pnenzi Exp $ */

void ucm_d_to_real (Mif_Private_t *private)
{

    Digital_State_t     in;

    double              *out;
    double              delay;
    double              zero;
    double              one;
    double              ena;


    in = ((Digital_t*)(private->conn[0]->port[0]->input.pvalue))->state;
    if(private->conn[1]->is_null)
        ena = 1.0;
    else if(((Digital_t*)(private->conn[1]->port[0]->input.pvalue))->state == ONE)
        ena = 1.0;
    else
        ena = 0.0;
    out = private->conn[2]->port[0]->output.pvalue;

    zero  = private->param[0]->element[0].rvalue;
    one   = private->param[1]->element[0].rvalue;
    delay = private->param[2]->element[0].rvalue;


    if(in == ZERO)
        *out = zero * ena;
    else if(in == UNKNOWN)
        *out = (zero + one) / 2.0 * ena;
    else
        *out = one * ena;

    if(private->circuit.time > 0.0)
        private->conn[2]->port[0]->delay = delay;

}




