/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_BOOTSOURCESETTING_H_
#define OPENDRIM_BOOTSOURCESETTING_H_

#include <Instance.h>

const static char* OpenDRIM_BootSourceSetting_classnames[] = {"OpenDRIM_BootSourceSetting"};
static string OpenDRIM_BootSourceSetting_NAMESPACE = _NAMESPACE;

class OpenDRIM_BootSourceSetting {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string BootString;
	bool BootString_isNULL;
	
	string BIOSBootString;
	bool BIOSBootString_isNULL;
	
	string StructuredBootString;
	bool StructuredBootString_isNULL;
	
	unsigned short FailThroughSupported;
	bool FailThroughSupported_isNULL;
	
	OpenDRIM_BootSourceSetting() {
		Caption_isNULL = true;
		Description_isNULL = true;
		InstanceID_isNULL = true;
		ElementName_isNULL = true;
		BootString_isNULL = true;
		BIOSBootString_isNULL = true;
		StructuredBootString_isNULL = true;
		FailThroughSupported_isNULL = true;
	}
	
	~OpenDRIM_BootSourceSetting() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getBootString(string& value) const {
		if (BootString_isNULL==true)
			return NOT_FOUND;
		value = BootString;
		return OK;
	}
	
	int setBootString(const string& newValue) {
		BootString = newValue;
		BootString_isNULL = false;
		return OK;
	}

	int getBIOSBootString(string& value) const {
		if (BIOSBootString_isNULL==true)
			return NOT_FOUND;
		value = BIOSBootString;
		return OK;
	}
	
	int setBIOSBootString(const string& newValue) {
		BIOSBootString = newValue;
		BIOSBootString_isNULL = false;
		return OK;
	}

	int getStructuredBootString(string& value) const {
		if (StructuredBootString_isNULL==true)
			return NOT_FOUND;
		value = StructuredBootString;
		return OK;
	}
	
	int setStructuredBootString(const string& newValue) {
		StructuredBootString = newValue;
		StructuredBootString_isNULL = false;
		return OK;
	}

	int getFailThroughSupported(unsigned short& value) const {
		if (FailThroughSupported_isNULL==true)
			return NOT_FOUND;
		value = FailThroughSupported;
		return OK;
	}
	
	int setFailThroughSupported(const unsigned short& newValue) {
		FailThroughSupported = newValue;
		FailThroughSupported_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_BOOTSOURCESETTING_H_*/
