/*###############################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_COMPUTERSYSTEMMEMORYACCESS_H_
#define OPENDRIM_COMPUTERSYSTEMMEMORYACCESS_H_

#include "SystemMemory_Common.h"

#include "OpenDRIM_ComputerSystemMemory.h"
#include "assocOpenDRIM_ComputerSystemMemory.h"

int SystemMemory_OpenDRIM_ComputerSystemMemory_load(const CMPIBroker* broker, string& errorMessage);

int SystemMemory_OpenDRIM_ComputerSystemMemory_unload(string& errorMessage);

int SystemMemory_OpenDRIM_ComputerSystemMemory_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ComputerSystemMemory>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_ComputerSystemMemory_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ComputerSystemMemory& instance, const char** properties, string& errorMessage);

int SystemMemory_OpenDRIM_ComputerSystemMemory_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemMemory& newInstance, const OpenDRIM_ComputerSystemMemory& oldInstance, const char** properties, string& errorMessage);

int SystemMemory_OpenDRIM_ComputerSystemMemory_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemMemory& instance, string& errorMessage);

int SystemMemory_OpenDRIM_ComputerSystemMemory_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemMemory& instance, string& errorMessage);

int SystemMemory_OpenDRIM_ComputerSystemMemory_associatorPartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const char** properties, vector<Instance>& GroupComponent_associatedInstances, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_ComputerSystemMemory_associatorGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const char** properties, vector<Instance>& PartComponent_associatedInstances, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_ComputerSystemMemory_referencePartComponentToGroupComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& PartComponent_instance, const vector<Instance>& GroupComponent_instances, vector<OpenDRIM_ComputerSystemMemory>& OpenDRIM_ComputerSystemMemory_instances, const char** properties, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_ComputerSystemMemory_referenceGroupComponentToPartComponent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& GroupComponent_instance, const vector<Instance>& PartComponent_instances, vector<OpenDRIM_ComputerSystemMemory>& OpenDRIM_ComputerSystemMemory_instances, const char** properties, string& errorMessage, const string& discriminant);

int SystemMemory_OpenDRIM_ComputerSystemMemory_populate(OpenDRIM_ComputerSystemMemory& instance, string& errorMessage);

#endif /*OPENDRIM_COMPUTERSYSTEMMEMORYACCESS_H_*/
