/*###############################################################################
# Linux Management Providers (LMP), System Memory provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "SystemMemory_Common.h"

bool CF_isVolatileMemory(BYTE memtype,  WORD memtype_detail)
{
	if(	(memtype >= ROM && memtype <= EPROM) ||
		memtype_detail & (1 << Non_Volatile))
		return false;

	return true;
}

int CF_getAccess(BYTE memtype)
{
	if(memtype == ROM)
		return ACCESS_READABLE;
	if(memtype <= Unknown_MemoryType)
		return ACCESS_UNKNOWN;

	return ACCESS_READWRITE;
}


int CF_getOperationalStatus(vector<unsigned short>& output,vector<void*> mem_error)
{
	output.clear();

	if(mem_error.size()==0)
		output.push_back(OPS_OK);
	else
	{

		output.push_back(OPS_SUPPORTING_ENTITY_IN_ERROR);

		for(unsigned int i=0;i<mem_error.size();i++)
		{
			if(((memory_error_information*)mem_error[i])->error_type==Uncorrectable_error)
				output.push_back(OPS_NON_RECOVERABLE_ERROR);
		}

	}

	return OK;
}

int CF_getHealthState(vector<void*> mem_error)
{
	if(mem_error.size()==0)
		return HS_OK;
	else
	{
		int tmp=5;

		for(unsigned int i=0;i<mem_error.size();i++)
		{
			if(((memory_error_information*)mem_error[i])->error_type==Uncorrectable_error)
				return HS_NON_RECOVERABLE_ERROR;
			else if(((memory_error_information*)mem_error[i])->error_granularity==Device_level)
				return HS_CRITICAL_FAILURE;
		}

		tmp+=mem_error.size()*5;
		if(tmp>HS_NON_RECOVERABLE_ERROR)
			tmp=HS_NON_RECOVERABLE_ERROR;
		return tmp;
	}

	return HS_UNKNOWN;
}
