/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd.h LibDvd header file
 * @ingroup core
 *
 * libdvd
 */
 
#include <glib-object.h>

#ifndef __DVD_H_
#define __DVD_H_

#define __DVD_H_INSIDE__
#include <dvd-language.h>
#include <dvd-types.h>
#include <dvd-audio.h>
#include <dvd-video.h>
#include <dvd-time.h>
#include <dvd-decoder.h>
#include <dvd-decoder-ac3.h>
#include <dvd-decoder-dts.h>
#include <dvd-decoder-lpcm.h>
#include <dvd-decoder-m2v.h>
#include <dvd-demux.h>
#include <dvd-chapter.h>
#include <dvd-title.h>
#include <dvd-obj.h>
#include <dvd-file-io.h>
#include <dvd-file-track.h>
#include <dvd-chapter-disk.h>
#include <dvd-title-disk.h>
#include <dvd-disk.h>

#undef __DVD_H_INSIDE__

#endif /* __DVD_H_ */
