/*
 *  Part of the shrinkta program, a dvd copy tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>

#include <bonobo.h>
#include <gnome.h>

#include <dvd.h>

#include "preferences.h"
#include "app.h"
#include "dialogs.h"
#include "pipe.h"
#include "image.h"

static void
child_setup_func		(gpointer	 data)
{
	PipeHandle *handle;

	handle = (PipeHandle *) data;
}

gboolean
make_udf_filesystem	(const gchar	*dvd_path,
			 guint		 size_mb,
			 const gchar	*disk_name,
			 const gchar	*volume_set,
			 const gchar	*provider,
			 const gchar	*udf_path,
			 progress_func	 func)
{
	PipeHandle file_handle;
	gchar *args[10];
	gboolean ok;
	
	/* open files */
	func ("Creating DVD file system", 0.0);
	file_handle.write_fd = open (udf_path, O_WRONLY | O_CREAT | O_TRUNC, 0664);
	if (file_handle.write_fd < 1) {
		g_warning ("Unable to open file %s", udf_path);
		return FALSE;
	}
	
	/* setup mkisofs */
	file_handle.read_mbs = size_mb;
	file_handle.func = func;

	if ((disk_name == NULL) ||
	    (*disk_name == '\0')) {
		disk_name = "Unknown Disk";
	}
	if ((volume_set == NULL) ||
	    (*volume_set == '\0')) {
		volume_set = "Unknown";
	}
	if ((provider == NULL) ||
	    (*provider == '\0')) {
		provider = "Unknown";
	}
	
	/* why isn't the args param of g_spawn_async_with_pipes () a constant? */
	args[0] = "genisoimage";
	args[1] = "-V";
	args[2] = g_strdup (disk_name);
	args[3] = "-volset";
	args[4] = g_strdup (volume_set);
	args[5] = "-p";
	args[6] = g_strdup (provider);
	args[7] = "-dvd-video";
	args[8] = g_strdup_printf ("%s", dvd_path);
	args[9] = NULL;

	ok = g_spawn_async_with_pipes (NULL,
				       args,
				       NULL,
				       G_SPAWN_SEARCH_PATH,
				       child_setup_func,
				       &file_handle,
				       &file_handle.child,
				       NULL,
				       &file_handle.read_fd,
				       NULL, NULL);
	
	if (ok == FALSE) {
		g_warning ("can't spawn genisoimage process");
		close (file_handle.write_fd);
		return FALSE;
	}
	g_message ("dvd dir %s", args[8]);
	
	/* pipe into file thread */
	file_handle.thread = g_thread_create (pipe_thread_func,
					      &file_handle,
					      TRUE,
					      NULL);
	
	g_message ("join file thread");
	g_thread_join (file_handle.thread);
	g_message ("close file fds");
	close (file_handle.read_fd);
	close (file_handle.write_fd);
	g_free (args[2]);
	g_free (args[4]);
	g_free (args[6]);
	g_free (args[8]);
	g_message ("file system created");
	
	return TRUE;
}
