/*
 *  Part of the  program, a dvd copy tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/

#ifndef __PREFERENCES_H__
#define __PREFERENCES_H__

/* --- type macros --- */
#define PREFERENCES_TYPE		(preferences_get_type())
#define PREFERENCES(o)			(G_TYPE_CHECK_INSTANCE_CAST (o, PREFERENCES_TYPE, Preferences))
#define PREFERENCES_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST    (k, PREFERENCES_TYPE, PreferencesClass))
#define IS_PREFERENCES(o)		(G_TYPE_CHECK_INSTANCE_TYPE (o, PREFERENCES_TYPE))
#define IS_PREFERENCES_CLASS(k)		(G_TYPE_CHECK_CLASS_TYPE    (k, PREFERENCES_TYPE))

/* --- typedefs & structures --- */
typedef struct	_Preferences		Preferences;
typedef struct	_PreferencesClass	PreferencesClass;

struct _Preferences {
	GObject	      parent;
	
	GMutex	      *mutex;
	
	/* General */
	gchar	      *drive_path;
	gchar	      *burn_command;
	gchar	      *img_folder;
	gchar	      *tmp_folder;
	
	/* Media */
	DvdMedia       media;
	gboolean       region_free;	/* make all disks region free */
	
	/* Audio */
	DvdAudioFormat audio_format;	/* preferred audio track format */
	gboolean       include_dts;	/* if preferred is AC3 - include DTS as well? */
	DvdLanguage    language;	/* audio language */
	gboolean       allow_undefined;	/* allow undefined language audio tracks? */
	
	/* Video */
	gfloat	       max_shrink;	/* maximum allowed shrink factor */
	gboolean       drop_dts;	/* if we drop dts track to reduce shrink factor < max_shrink */
	
	/* burner programs found on users system */
	gboolean       have_nautilus_cd_burner;
	gboolean       have_brasero;
};

struct _PreferencesClass {
	GObjectClass	parent;
};

#define BURNER_COMMAND_NAUTILUS_CD_BURNER "nautilus-cd-burner --source-iso="
#define BURNER_COMMAND_BRASERO "brasero --image="

/* --- prototypes --- */
GType		preferences_get_type		(void);
Preferences*	preferences_new			(void);
gchar*		preferences_get_drive_path	(Preferences	*prefs);
gboolean	preferences_set_drive_path	(Preferences	*prefs,
						 const gchar	*drive_path);
gchar*		preferences_get_burn_command	(Preferences	*prefs);
gboolean	preferences_set_burn_command	(Preferences	*prefs,
						 const gchar	*burn_command);
gchar*		preferences_get_image_folder	(Preferences	*prefs);
gboolean	preferences_set_image_folder	(Preferences	*prefs,
						 const gchar	*image_folder);
gchar*		preferences_get_temp_folder	(Preferences	*prefs);
gboolean	preferences_set_temp_folder	(Preferences	*prefs,
						 const gchar	*temp_folder);
DvdMedia	preferences_get_media		(Preferences	*prefs);
void		preferences_set_media		(Preferences	*prefs,
						 DvdMedia	 media);
gboolean	preferences_get_region_free	(Preferences	*prefs);
void		preferences_set_region_free	(Preferences	*prefs,
						 gboolean	 region_free);
DvdAudioFormat	preferences_get_audio_format	(Preferences	*prefs);
void		preferences_set_audio_format	(Preferences	*prefs,
						 DvdAudioFormat	 audio_format);
gboolean	preferences_get_include_dts	(Preferences	*prefs);
void		preferences_set_include_dts	(Preferences	*prefs,
						 gboolean	 include_dts);
DvdLanguage	preferences_get_language	(Preferences	*prefs);
void		preferences_set_language	(Preferences	*prefs,
						 DvdLanguage	 language);
gboolean	preferences_get_use_undefined	(Preferences	*prefs);
void		preferences_set_use_undefined	(Preferences	*prefs,
						 gboolean	 use_undefined);
gfloat		preferences_get_maximum_shrink	(Preferences	*prefs);
void		preferences_set_maximum_shrink	(Preferences	*prefs,
						 gfloat		 maximum_shrink);
gboolean	preferences_get_drop_dts	(Preferences	*prefs);
void		preferences_set_drop_dts	(Preferences	*prefs,
						 gboolean	 drop_dts);

#endif /*__PREFERENCES_H__*/
