/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.SQLException;

class FdocaConstants {
    static final int FDOCA_TYPE_FIXEDBYTES = 1;
    static final int FDOCA_TYPE_NFIXEDBYTES = 129;
    static final int FDOCA_TYPE_VARBYTES = 2;
    static final int FDOCA_TYPE_NVARBYTES = 130;
    static final int FDOCA_TYPE_NTBYTES = 3;
    static final int FDOCA_TYPE_NNTBYTES = 131;
    static final int FDOCA_TYPE_PSCLBYTE = 7;
    static final int FDOCA_TYPE_NPSCLBYTE = 135;
    static final int FDOCA_TYPE_FIXEDCHAR = 16;
    static final int FDOCA_TYPE_NFIXEDCHAR = 144;
    static final int FDOCA_TYPE_VARCHAR = 17;
    static final int FDOCA_TYPE_NVARCHAR = 145;
    static final int FDOCA_TYPE_NTCHAR = 20;
    static final int FDOCA_TYPE_NNTCHAR = 148;
    static final int FDOCA_TYPE_PSCLCHAR = 25;
    static final int FDOCA_TYPE_NPSCLCHAR = 153;
    static final int FDOCA_TYPE_INTEGER_BE = 35;
    static final int FDOCA_TYPE_NINTEGER_BE = 163;
    static final int FDOCA_TYPE_INTEGER_LE = 36;
    static final int FDOCA_TYPE_NINTEGER_LE = 164;
    static final int FDOCA_TYPE_DECIMAL = 48;
    static final int FDOCA_TYPE_NDECIMAL = 176;
    static final int FDOCA_TYPE_NUMERIC_CHAR = 50;
    static final int FDOCA_TYPE_NNUMERIC_CHAR = 178;
    static final int FDOCA_TYPE_ZDECIMAL_IBM = 51;
    static final int FDOCA_TYPE_NZDECIMAL_IBM = 179;
    static final int FDOCA_TYPE_ZDECIMAL = 53;
    static final int FDOCA_TYPE_NZDECIMAL = 181;
    static final int FDOCA_TYPE_FLOAT_370 = 64;
    static final int FDOCA_TYPE_NFLOAT_370 = 192;
    static final int FDOCA_TYPE_FLOAT_X86 = 71;
    static final int FDOCA_TYPE_NFLOAT_X86 = 199;
    static final int FDOCA_TYPE_FLOAT_IEEE = 72;
    static final int FDOCA_TYPE_NFLOAT_IEEE = 200;
    static final int FDOCA_TYPE_FLOAT_VAX = 73;
    static final int FDOCA_TYPE_NFLOAT_VAX = 201;
    static final int FDOCA_TYPE_LOBBYTES = 80;
    static final int FDOCA_TYPE_NLOBBYTES = 208;
    static final int FDOCA_TYPE_LOBCHAR = 81;
    static final int FDOCA_TYPE_NLOBCHAR = 209;
    static final int DRDA_TYPE_INTEGER = 2;
    static final int DRDA_TYPE_NINTEGER = 3;
    static final int DRDA_TYPE_SMALL = 4;
    static final int DRDA_TYPE_NSMALL = 5;
    static final int DRDA_TYPE_1BYTE_INT = 6;
    static final int DRDA_TYPE_N1BYTE_INT = 7;
    static final int DRDA_TYPE_FLOAT16 = 8;
    static final int DRDA_TYPE_NFLOAT16 = 9;
    static final int DRDA_TYPE_FLOAT8 = 10;
    static final int DRDA_TYPE_NFLOAT8 = 11;
    static final int DRDA_TYPE_FLOAT4 = 12;
    static final int DRDA_TYPE_NFLOAT4 = 13;
    static final int DRDA_TYPE_DECIMAL = 14;
    static final int DRDA_TYPE_NDECIMAL = 15;
    static final int DRDA_TYPE_ZDECIMAL = 16;
    static final int DRDA_TYPE_NZDECIMAL = 17;
    static final int DRDA_TYPE_NUMERIC_CHAR = 18;
    static final int DRDA_TYPE_NNUMERIC_CHAR = 19;
    static final int DRDA_TYPE_RSET_LOC = 20;
    static final int DRDA_TYPE_NRSET_LOC = 21;
    static final int DRDA_TYPE_INTEGER8 = 22;
    static final int DRDA_TYPE_NINTEGER8 = 23;
    static final int DRDA_TYPE_LOBLOC = 24;
    static final int DRDA_TYPE_NLOBLOC = 25;
    static final int DRDA_TYPE_CLOBLOC = 26;
    static final int DRDA_TYPE_NCLOBLOC = 27;
    static final int DRDA_TYPE_DBCSCLOBLOC = 28;
    static final int DRDA_TYPE_NDBCSCLOBLOC = 29;
    static final int DRDA_TYPE_ROWID = 30;
    static final int DRDA_TYPE_NROWID = 31;
    static final int DRDA_TYPE_DATE = 32;
    static final int DRDA_TYPE_NDATE = 33;
    static final int DRDA_TYPE_TIME = 34;
    static final int DRDA_TYPE_NTIME = 35;
    static final int DRDA_TYPE_TIMESTAMP = 36;
    static final int DRDA_TYPE_NTIMESTAMP = 37;
    static final int DRDA_TYPE_FIXBYTE = 38;
    static final int DRDA_TYPE_NFIXBYTE = 39;
    static final int DRDA_TYPE_VARBYTE = 40;
    static final int DRDA_TYPE_NVARBYTE = 41;
    static final int DRDA_TYPE_LONGVARBYTE = 42;
    static final int DRDA_TYPE_NLONGVARBYTE = 43;
    static final int DRDA_TYPE_NTERMBYTE = 44;
    static final int DRDA_TYPE_NNTERMBYTE = 45;
    static final int DRDA_TYPE_CSTR = 46;
    static final int DRDA_TYPE_NCSTR = 47;
    static final int DRDA_TYPE_CHAR = 48;
    static final int DRDA_TYPE_NCHAR = 49;
    static final int DRDA_TYPE_VARCHAR = 50;
    static final int DRDA_TYPE_NVARCHAR = 51;
    static final int DRDA_TYPE_LONG = 52;
    static final int DRDA_TYPE_NLONG = 53;
    static final int DRDA_TYPE_GRAPHIC = 54;
    static final int DRDA_TYPE_NGRAPHIC = 55;
    static final int DRDA_TYPE_VARGRAPH = 56;
    static final int DRDA_TYPE_NVARGRAPH = 57;
    static final int DRDA_TYPE_LONGRAPH = 58;
    static final int DRDA_TYPE_NLONGRAPH = 59;
    static final int DRDA_TYPE_MIX = 60;
    static final int DRDA_TYPE_NMIX = 61;
    static final int DRDA_TYPE_VARMIX = 62;
    static final int DRDA_TYPE_NVARMIX = 63;
    static final int DRDA_TYPE_LONGMIX = 64;
    static final int DRDA_TYPE_NLONGMIX = 65;
    static final int DRDA_TYPE_CSTRMIX = 66;
    static final int DRDA_TYPE_NCSTRMIX = 67;
    static final int DRDA_TYPE_PSCLBYTE = 68;
    static final int DRDA_TYPE_NPSCLBYTE = 69;
    static final int DRDA_TYPE_LSTR = 70;
    static final int DRDA_TYPE_NLSTR = 71;
    static final int DRDA_TYPE_LSTRMIX = 72;
    static final int DRDA_TYPE_NLSTRMIX = 73;
    static final int DRDA_TYPE_SDATALINK = 76;
    static final int DRDA_TYPE_NSDATALINK = 77;
    static final int DRDA_TYPE_MDATALINK = 78;
    static final int DRDA_TYPE_NMDATALINK = 79;
    static final int DRDA_TYPE_LOBBYTES = 200;
    static final int DRDA_TYPE_NLOBBYTES = 201;
    static final int DRDA_TYPE_LOBCSBCS = 202;
    static final int DRDA_TYPE_NLOBCSBCS = 203;
    static final int DRDA_TYPE_LOBCDBCS = 204;
    static final int DRDA_TYPE_NLOBCDBCS = 205;
    static final int DRDA_TYPE_LOBCMIXED = 206;
    static final int DRDA_TYPE_NLOBCMIXED = 207;
    static final int CPT_TRIPLET_TYPE = 127;
    static final int MDD_TRIPLET_TYPE = 120;
    static final int NGDA_TRIPLET_TYPE = 118;
    static final int RLO_TRIPLET_TYPE = 113;
    static final int SDA_TRIPLET_TYPE = 112;
    static final int SDA_MD_TYPE = 1;
    static final int GDA_MD_TYPE = 2;
    static final int ROW_MD_TYPE = 3;
    static final int SQLCADTA_LID = 224;
    static final int SQLDTAGRP_LID = 208;
    static final int NULL_LID = 0;
    static final int INDICATOR_NULLABLE = 0;
    static final int NULL_DATA = 255;
    static final int TYP_NULLIND = 1;
    static final int MAX_ENV_LID = 73;
    static final int MAX_VARS_IN_NGDA = 84;
    static final int FULL_NGDA_SIZE = 255;
    static final int MDD_TRIPLET_SIZE = 7;
    static final int SDA_TRIPLET_SIZE = 12;
    static final int SQLDTA_RLO_SIZE = 6;
    static final int RLO_RPT_GRP_SIZE = 3;
    static final int SQLDTAGRP_SIZE = 3;
    static final int CPT_SIZE = 3;
    static final int FDODSC_FOOTER_SIZE = 6;
    static final int SQLDTAGRP_COL_DSC_SIZE = 3;
    static final int MAX_OVERRIDES = 250;
    static final int MDD_REST_SIZE = 5;
    static final byte[] SQLCADTA_MDD = new byte[]{7, 120, 0, 5, 3, 1, -32};
    static final byte[] SQLDTA_MDD = new byte[]{7, 120, 0, 5, 4, 1, -16};
    static final byte[] SQLDTAGRP_MDD = new byte[]{7, 120, 0, 5, 2, 1, -48};
    static final byte[] SQLCADTA_SQLDTARD_RLO = new byte[]{9, 113, -32, 84, 0, 1, -48, 0, 1, 6, 113, -16, -32, 0, 0};
    static final byte[] SQLDTA_RLO = new byte[]{6, 113, -28, -48, 0, 1};
    static final int SQLCADTA_SQLDTARD_RLO_SIZE = SQLCADTA_SQLDTARD_RLO.length;
    protected static int LONGVARCHAR_MAX_LEN = 32700;
    protected static int LONGVARBINARY_MAX_LEN = 32700;
    protected static int LONGVARCHAR_LEN_NUMBYTES = 2;
    protected static int NUMERIC_MAX_PRECISION;
    protected static int NUMERIC_DEFAULT_PRECISION;
    protected static int NUMERIC_DEFAULT_SCALE;

    FdocaConstants() {
    }

    protected static boolean isNullable(int n) {
        return (n & 1) == 1;
    }

    protected static int mapJdbcTypeToDrdaType(int n, boolean bl, int[] nArray) throws SQLException {
        int n2 = 0;
        switch (n) {
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                n2 = 5;
                nArray[0] = 2;
                break;
            }
            case 4: {
                n2 = 3;
                nArray[0] = 4;
                break;
            }
            case -5: {
                n2 = 23;
                nArray[0] = 8;
                break;
            }
            case 7: {
                n2 = 13;
                nArray[0] = 4;
                break;
            }
            case 6: 
            case 8: {
                n2 = 11;
                nArray[0] = 8;
                break;
            }
            case 2: 
            case 3: {
                n2 = 15;
                nArray[0] = -1;
                break;
            }
            case 91: {
                n2 = 33;
                nArray[0] = 10;
                break;
            }
            case 92: {
                n2 = 35;
                nArray[0] = 8;
                break;
            }
            case 93: {
                n2 = 37;
                nArray[0] = 26;
                break;
            }
            case 1: {
                n2 = 63;
                nArray[0] = -1;
                break;
            }
            case 12: {
                n2 = 51;
                nArray[0] = -1;
                break;
            }
            case 2000: {
                n2 = 53;
                nArray[0] = LONGVARCHAR_MAX_LEN;
                break;
            }
            case -1: {
                n2 = 53;
                nArray[0] = LONGVARCHAR_MAX_LEN;
                break;
            }
            case -3: 
            case -2: {
                n2 = 41;
                nArray[0] = -1;
                break;
            }
            case -4: {
                n2 = 43;
                nArray[0] = LONGVARBINARY_MAX_LEN;
                break;
            }
            case 2004: {
                n2 = 201;
                nArray[0] = 32772;
                break;
            }
            case 2005: {
                n2 = 207;
                nArray[0] = 32772;
                break;
            }
            case 0: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: {
                throw new SQLException("Jdbc type" + n + "not Supported yet");
            }
            default: {
                throw new SQLException("unrecognized sql type: " + n);
            }
        }
        if (!bl) {
            --n2;
        }
        return n2;
    }

    static {
        NUMERIC_DEFAULT_PRECISION = NUMERIC_MAX_PRECISION = 31;
        NUMERIC_DEFAULT_SCALE = 15;
    }
}

