#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "interface.h"

#include "treedata.h"

int set_node_name(n, ty, s)
treenode n;
tree_type ty;
char *s;
{
	nodetypedata f,b;

	f=ndta(n)->flower;
	b=ndta(n)->boxed;

	canvas_add_text(tndta(n, ty)->label);

	node_set_name(n, s);

	ttext_set_selection(f->label, -1, -1);
	ttext_insert_string(f->label, s);
	ttext_set_selection(f->label, 0, 0);

	ttext_set_selection(b->label, -1, -1);
	ttext_insert_string(b->label, s);
	ttext_set_selection(b->label, 0, 0);

	canvas_add_text(tndta(n, ty)->label);
	invalidate_refit(tree_get_tree(n), Flower);
	invalidate_refit(tree_get_tree(n), Boxed);
	modify();
	return(1);
}

int shift_node_position(n, ty, offx, offy)
treenode n;
tree_type ty;
int offx, offy;
{
	static double dx, dy;
	treenode p;
	treebranch pb;

	dx=offx;
	dy=offy;

	pb=getparentandbranch(n, &p);
	canvas_add_branch(pb);
	move_node(n, ty, dx, dy);
	canvas_add_branch(pb);
	invalidate_refit(tree_get_tree(n), ty);
	modify();
}

int rotate_node_position(n, ty, a)
treenode n;
tree_type ty;
double a;
{
	static nodetypedata nd;

	nd=tndta(n, ty);
	nd->a=nd->a+a;
	invalidate_format(tree_get_tree(n), ty);
	invalidate_refit(tree_get_tree(n), ty);
	modify();
}

int rotate_subtree(n, ty, a)
treenode n;
tree_type ty;
double a;
{
	list t;

	rotate_node_position(n, ty, a);
	tforsubtree(n, t)
		rotate_subtree(subtree(t), ty, a);
}


int move_node_label(n, ty, lx, ly)
treenode n;
tree_type ty;
int lx, ly;
{
	nodetypedata nd;
	treetypedata td;
	int x, y;

	nd=tndta(n, ty);
	td=ttdta(tree_get_tree(n), ty);

	nd->lx=lx;
	nd->ly=ly;
	x=nodex(nd, td);
	y=nodey(nd, td);
	x+=nd->lx;
	y+=nd->ly;

	ttext_move(nd->label, x, y);
	nd->textisreset=0;
	invalidate_refit(tree_get_tree(n), ty);
	modify();
	return(1);
}

int set_font_of_node(n, ty, f)
treenode n;
tree_type ty;
tfont f;
{
	nodetypedata nd;
	treetypedata td;
	double y;
	int newly;

	nd=tndta(n, ty);
	td=ttdta(tree_get_tree(n), ty);

	y=nodey(nd, td);
	newly=-.5*tfont_height(f);

	nd->font=f;
	tcontext_set_font(nd->gc, f);
	ttext_change_font(nd->label, f);
	if(tdta(tree_get_tree(n))->type==Boxed)
		nd->ly=newly;
	else if(nd->textisreset)
		reset_label_location_flower(n);
	node_update_label_position(n, NoTreeType);
	invalidate_spacing(tree_get_tree(n), ty);
	invalidate_refit(tree_get_tree(n), ty);
	modify();
	return(1);
}

int set_color_of_node(n, ty, c)
treenode n;
tree_type ty;
tcolor c;
{
	nodetypedata nd;

	nd=tndta(n, ty);

	nd->c=c;
	tcontext_set_foreground(nd->gc, c);
	ttext_set_color(nd->label, c);
	modify();
	return(1);
}

write_node_name(f, n)
FILE *f;
treenode n;
{
	if(treeleaf(n))
		if(n->name!=NULL)
			if(n->name[0]!='\0')
				fprintf(f, "%s\n", n->name);
}

write_subtree_names(f, n)
FILE *f;
treenode n;
{
	list t;

	if(treeleaf(n))
		write_node_name(f, n);
	else
		tforsubtree(n, t)
			write_subtree_names(f, subtree(t));
	return(1);
}

int editablelabel(n, ty)
treenode n;
tree_type ty;
{
	treetypedata td;

	td=ttdta(tree_get_tree(n), ty);

	if(treeleaf(n))
		return(td->showterminals);
	else if(n->name!=NULL)
		return(td->showinternals);
	else	
		return(0);
}

int showlabel(n, ty)
treenode n;
tree_type ty;
{
	treetypedata td;

	td=ttdta(tree_get_tree(n), ty);

	if(treeleaf(n))
		return(td->showterminals);
	else if(n->name!=NULL)
		return(td->showinternals &&
			(td->bt==RoomForGroup || td->bt==FlowerBranch) &&
			n->name[0]!='\0');
	else
		return(0);
}

int fix_node_label(n, ty)
treenode n;
tree_type ty;
{
	static nodetypedata nd;

	nd=tndta(n, ty);

	if(tdta(tree_get_tree(n))->type==Boxed)
	{
		nd->lx=INITBOXLX;
		nd->ly=-ttext_height(nd->label)/2;
	}
	else
		reset_label_location_flower(n);
	node_update_label_position(n, NoTreeType);
	invalidate_refit(tree_get_tree(n), ty);
	modify();
}
