#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "interface.h"

#include "treedata.h"

static treenode cnode;
static nodetypedata cdata;

int do_change_text(c, e, x, y, f)
tcanvas c;
tevent e;
int x, y;
int (*f)();
{
	static int result;
	static int dragging=0;
	char *s;

	result=0;

	if(installing)
	{
		canvas_add_event_function(do_change_text, f);
		cnode=(treenode)first_selected_node();
		cdata=ndta(cnode)->td;
		ttext_select(cdata->label);
		dragging=0;
		return(1);
	}
	else if(uninstalling)
	{
		if(canvas_remove_event_function(do_change_text))
		{
			/* was removed, so text was being edited */
			/* store name */
			ttext_unselect(cdata->label);
			s=(char *)strdup(ttext_get_string(cdata->label));
			do_command(SetNodeName, cnode, s, 0.0, 0.0, 0,0,0,0,0);
			free(s);
			cnode=NULL;
			cdata=NULL;
		}
		return(1);
	}
	else if(printing) printf("zchangetext\n");

	switch(tevent_type(e))
	{
		case te_mousedown:
			if(!dragging)
			{
				if(pt_in_text(cdata->label, x, y))
				{
					tcanvas_reset_area(c);
					ttext_handle_event(cdata->label, e);
					tcanvas_clipping_off(c);
					tcanvas_clear_area(c);
					ttext_repaint(cdata->label);
					tcanvas_pop_buffer(c);
					dragging=1;
					install_dragging_function(do_change_text);
					result=1;
				}
			}
			else
				result=1;
			break;
		case te_keydown:
			if(!dragging)
			{
				switch(tevent_special_key(e))
				{
					case tk_left:
					case tk_right:
					case tk_up:
					case tk_down:
					case tk_delete:
					case tk_none:
						tcanvas_reset_area(c);
						ttext_handle_event(cdata->label, e);
						tcanvas_clipping_off(c);
						tcanvas_clear_area(c);
						ttext_repaint(cdata->label);
						tcanvas_pop_buffer(c);
						result=1;
						break;
					default:
						break;
				}
			}
			else
				result=1;
			break;
		case te_drag:
			if(dragging)
			{
				tcanvas_reset_area(c);
				ttext_handle_event(cdata->label, e);
				tcanvas_clipping_off(c);
				tcanvas_clear_area(c);
				ttext_repaint(cdata->label);
				tcanvas_pop_buffer(c);
				result=1;
			}
			break;
		case te_mouseup:
			if(dragging)
			{
				dragging=0;
				uninstall_dragging_function(do_change_text);
				tcanvas_reset_area(c);
				ttext_handle_event(cdata->label, e);
				tcanvas_clipping_off(c);
				tcanvas_clear_area(c);
				ttext_repaint(cdata->label);
				tcanvas_pop_buffer(c);
				result=1;
			}
			break;
		default:
			if(dragging)
				result=1;
			break;
	}
	return(result);
}
