#!/bin/bash

# Copyright (c) 2002-2009 Userful Corporation. All rights reserved.
# http://www.userful.com/

# blank-all-screens.sh

# this script will determine how many screens there are and run a blanking program on each screen

function usage() {
    if [ -n "$*" ] ; then
        echo "ERROR: $*"
    fi
    echo "Usage: ${0##*/} [options]"
    echo "  -u             unblank all screens"
    echo "  -s sceen       (un)blank a particular screen (numbering starts at 0 (zero))"
	echo "  -q             query which screens are blanked (also cleans up invalid files)"
	echo "  -i filename    display an image while blanking the screen"
	return
}

PID_DIR=/tmp/.blanked-screens

# parse arguments:
while getopts "us:hqi:" flag ; do
    case "$flag" in
        u)
			UNBLANK=true
            ;;
        s)
			SCREEN_NUMBER=$OPTARG
			;;
        h)
            usage
            exit 0
            ;;
		i)
			SUPPLIED_IMAGE=$OPTARG
			;;
		q)
			QUERY=true
			;;
        ?)
            usage
            exit 1
            ;;
    esac
done

# unblank blanked screens if requested
if [ -n "$UNBLANK" ] ; then
	if [ ! -d $PID_DIR ] ; then
		echo "no blanking data, screens are not blanked"
		exit 1
	fi

	for F in $PID_DIR/* ; do
		if [ -f $F ] ; then
			PID=`cat $F`
		else
			continue
		fi
		if [ -d /proc/$PID ] ; then

			if [ -z "$SCREEN_NUMBER" ] || [ "$SCREEN_NUMBER" == ${F##*/} ] ; then
				echo "unblanking screen ${F##*/}"
				kill $PID
				rm -f $F
			fi
		else
			echo "found invalid screen blanking data"
			rm -f $F
		fi

	done

	exit 0
fi 

# get he number of stations on this computer
if [ -f /etc/X11/stations ] ; then
	STATIONS=`cat /etc/X11/stations`
else 
	STATIONS=1
fi

mkdir -p $PID_DIR || exit 1

for (( D=0 ; D< $STATIONS ; D++ )) ; do

	if [ -f $PID_DIR/$D ] ; then

		# screen may already be blanked
		OLD_PID=`cat $PID_DIR/$D`
		if [ -d /proc/$OLD_PID ] ; then
			CMD=`cat /proc/$OLD_PID/cmdline`
			if [ "$CMD" == "${CMD//show-pnm}" ] ; then
				echo "found old pid file, but it's bogus, removing"
				rm -f $PID_DIR/$D
			else 
				echo "screen $D is blanked"
				continue
			fi
		else
				echo "found stale pid file, removing"
				rm -f $PID_DIR/$D
		fi
	fi

	# if we were only querying, then we're done
	if [ -n "$QUERY" ] ; then
		exit 0
	fi

	# Easter egg
	if [ -f /opt/userful/debug ] ; then
		OPTS="-f -c -r -i -o -t 1"
		IMAGE_FILE="/opt/userful/images/1pix-white.ppm"
	else
		OPTS="-f -c"
		IMAGE_FILE="/opt/userful/images/1pix-black.ppm"
	fi

	if [ -n "$SUPPLIED_IMAGE" ] && [ -f "$SUPPLIED_IMAGE" ] && [ "${SUPPLIED_IMAGE##*.}" == "ppm" ] ; then
		OPTS="-f -c -p"
		IMAGE_FILE="$SUPPLIED_IMAGE"
	fi

	if [ -e /tmp/.X11-unix/X$D ] ; then
		if [ -z "$SCREEN_NUMBER" ] || [ "$SCREEN_NUMBER" == $D ] ; then
			echo "blanking screen $D"
			DISPLAY=:$D /opt/userful/bin/show-pnm $OPTS $IMAGE_FILE &
			PID=$!
			echo $PID > $PID_DIR/$D
		fi
	else
		echo "screen $D is not a valid screen"
	fi
done

if [ -n "$SCREEN_NUMBER" ] ; then
	if [ -z "$PID" ] ; then
		echo "$SCREEN_NUMBER is not a valid screen"
	fi
fi

exit 0