#!/bin/bash
#
# dm-start-display-manager.sh
#
#    Start Display Manager based on LOGINTYPE and distro.
#
#    Copyright (c) 2005-2009 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
# Called from: prefdm_multi, umx.xinitrc
#
logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

function start_dm()
{
    # Check OSNAME, OSVER
    source /etc/userful/os-info

    if [ -f /etc/init.d/xdm.multi-save ]; then
        ### SuSE, Novell, JDS
		exec /etc/init.d/xdm.multi-save start

    elif [ -f /etc/init.d/kdm.multi-save ]; then
	    ### Xandros, Mepis ###
		exec /etc/init.d/kdm.multi-save start

    elif [ -f /etc/init.d/gdm.multi-save ]; then
	    ### Ubuntu, Linspire, Debian, Freespire, Dreamlinux
	    exec /etc/init.d/gdm.multi-save start

    elif [ -f /etc/init.d/xdm ]; then
        ### SuSE 10.2,10.3,11.0
		exec /etc/init.d/xdm start

    elif [ "$OSNAME" == "mandrake" ]; then
	    ### Mandrake ###
		exec /etc/X11/prefdm -nodaemon

    else
	    ### Fedora, Redhat, CentOS ###
		exec /etc/X11/prefdm -nodaemon
    fi
}

# This is bug fix for locale problem in Educational Linux
if [[ -f /etc/default/locale ]]; then
    echo "`date +"%b %d %T"` [$ProgramName]: source locale" >> $logfile
    source /etc/default/locale 2>> $logfile
    while read line; do
        VARS_NAME=`echo $line | awk -F'=' '{print $1}'`
        export $VARS_NAME >> $logfile
    done < /etc/default/locale

    if [[ -f /etc/bash.bashrc ]]; then
        source /etc/bash.bashrc
    fi
    if [[ -f /etc/profile ]]; then
        source /etc/profile
    fi

    if [[ -f /root/.bashrc ]]; then
        source /root/.bashrc
    fi
    if [[ -f /root/.profile ]]; then
        source /root/.profile
    fi
fi

##
## Load UMx configuration
##
if [ -f /tmp/distro.conf ]; then
    source /tmp/distro.conf
fi
if [ -f /etc/userful/umx.conf ]; then
    # Comment out [section] header to source the file
    rm -f /tmp/umx.conf.tmp
    sed -e "s/^\[/#\[/g" /etc/userful/umx.conf > /tmp/umx.conf.tmp
    source /tmp/umx.conf.tmp
fi
if [ "$LOGINTYPE" == "" ]; then
    LOGINTYPE="local"
fi

##
## Check current X type
##
if [ -f /etc/sysconfig/xtype ]; then
    source /etc/sysconfig/xtype
fi
if [ "$XTYPE" == "" ]; then
    XTYPE="SINGLE"
fi

echo "`date +"%b %d %T"` [$ProgramName]: Current XTYPE=$XTYPE, LOGINTYPE=$LOGINTYPE." >> $logfile

if [ "$XTYPE" == "SINGLE" ]; then

    if [ "$LOGINTYPE" == "urls" ]; then
        # Don't need to start DM separatly
        :
    else
        start_dm
    fi

elif [ "$XTYPE" == "MULTI" ]; then

    if [ "${LOGINTYPE//auto}" != "$LOGINTYPE" ]; then # Auto Login
        sleep 1
        exec /opt/userful/bin/userful-dm.sh auto

    elif [ "${LOGINTYPE//remote}" != "$LOGINTYPE" ]; then # Remote Login
        # Disable firewall
        # This may not be safe to disable firewall.
        if [ -f /etc/init.d/iptables ]; then
            /etc/init.d/iptables stop
        elif [ -f /etc/init.d/SuSEfirewall2_setup ]; then
            /etc/init.d/SuSEfirewall2_setup stop
        fi

        sleep 1
        exec /opt/userful/bin/userful-dm.sh remote

    elif [ "${LOGINTYPE//urls}" != "$LOGINTYPE" ]; then # URLS Login
        sleep 1
        ##
        ## Start the real Display Manager
        if [ -n "$DMINIT" -a -e /etc/init.d/$DMINIT ]; then
            if [ -n "$DMSTART" -a "$DMSTART" == "disable" ]; then
                # Start DM if it's not started already.( it will be XDMCP server for UMx)
                /etc/init.d/$DMINIT start
            fi
        fi
        exec /opt/userful/bin/userful-dm.sh urls

    else
        start_dm  # Start Local display
    fi
else
    echo "`date +"%b %d %T"` [$ProgramName]: Not a valid XTYPE. Check /etc/sysconfig/xtype." >> $logfile
fi
