#!/bin/bash
#
# Copyright (c) 2007 by Userful Corporation
#
# Name:     userful-device-config.sh
# Author:   Jason Kim <jason@userful.com>
# Description:
#  This program updates the type of device configuration based on the
# argument received.
#
# $1: static or dynamic

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

usage()
{
    echo
    echo "Usage: $ProgramName <static|dynamic>"
    echo
    exit 1
}

# Check user 
if [ $UID != 0 ]; then
    echo ""
    echo "   You must be root to configure devices."
    echo ""
    exit 1
fi

# Receive only one argument - <static|dynamic>
if [ $# -ne 1 ]; then
    usage
fi
CONFIG_TYPE="$1"

echo "`date +"%b %d %T"` $ProgramName: Change the type of device configuration to $1 " >> $logfile

if [ "$CONFIG_TYPE" == "static" ]; then
    # Copy usbinput to usbinput.static
    cp -f /etc/usbinput /etc/usbinput.static

elif [ "$CONFIG_TYPE" == "dynamic" ]; then
    rm -f /etc/usbinput.static

else
    echo "`date +"%b %d %T"` $ProgramName: $1 is not a valid argument." >> $logfile
    echo "$1 is not a valid argument."
    exit 1
fi

# Update umx.conf with CONFIG_TYPE
if grep "\#[[:space:]]*DEVCONF=" /etc/userful/umx.conf > /dev/null 2>&1; then
    sed -i -e "s/#[[:space:]]*DEVCONF=.*/DEVCONF=\"$CONFIG_TYPE\"/g" /etc/userful/umx.conf

elif grep "DEVCONF=" /etc/userful/umx.conf > /dev/null 2>&1; then
    sed -i -e "s/DEVCONF=.*/DEVCONF=\"$CONFIG_TYPE\"/g" /etc/userful/umx.conf

else
    echo "DEVCONF=\"$CONFIG_TYPE\"" >> /etc/userful/umx.conf
fi

echo "Set the assignment type to $CONFIG_TYPE.. Done !"
