#!/bin/bash

# Copyright (c) 2002-2009 Userful Corporation. All rights reserved.
# http://userful.com/

# comment this out for distribution
#DEBUG=1
PROGRESS_DLG_PID=-1

function print_usage () {
            echo "usage: $0 [OPTION]...
Submit debug info.

 -g        use graphical interface
 -d text   add a description
 -h        print this text
"
}

function failed() {
    if [ -d /proc/$PROGRESS_DLG_PID ] ; then
        $KILL_PROGRESS
    fi

    INFO=$*
    if [ -z "$INFO" ] ; then
        INFO=unknown
    fi
    if [ -x /usr/share/np-identify/identify.py ] ; then
        /usr/share/np-identify/identify.py --reboot-reason=568 --description="$INFO"
    fi
    exit 1
}

# next block taken from install-license.sh
ERR_DLG=/usr/share/umx-utils/error-dialog.py
if [ ! -x $ERR_DLG ] ; then
    ERR_DLG=./error-dialog.py
fi 
if [ ! -x $ERR_DLG ] ; then
    ERR_DLG=echo
fi

PROGRESS_DLG=./progress-dialog.py
if [ ! -x $PROGRESS_DLG ] ; then
    PROGRESS_DLG=/usr/share/umx-utils/progress-dialog.py
fi
if [ ! -x $PROGRESS_DLG ] ; then
    PROGRESS_DLG=$ERR_DLG
fi


GRAPHICAL=0
DETAILS_PROVIDED=0

# parse arguments:
while getopts "hgd:" flag ; do
    # echo "$flag" $OPTIND $OPTARG
    case "$flag" in
        h)
            print_usage
            exit 0
            ;;
        g)
            GRAPHICAL=1
            ;;
        d)
            DETAILS_PROVIDED=1
            DETAILS=$OPTARG
            ;;
        ?)
            print_usage
            exit 1
            ;;
    esac
done



TMP_SPACE=${TMPDIR:-/tmp}/submit-debug-info.sh.$$
trap "rm -rf $TMP_SPACE 2>/dev/null" 0

ETH_NUM=0
MAC=`LANG=C /sbin/ifconfig -a eth$ETH_NUM | grep "HWaddr" | awk '{ print $5 }'`
if [ -z "$MAC" ] || [ ${#MAC} != 17 ] ; then 
    # MAC is no good
    MAC=unknown
fi

EDATE=`date +%s`

MAC_DASHES=${MAC//:/-}

DEST=$TMP_SPACE/$MAC_DASHES-$EDATE

mkdir -p $DEST

DATE=`date`
echo "DATE=\"$DATE\"" > $TMP_SPACE/details
UPTIME=`uptime`
echo "UPTIME=\"$UPTIME\"" >> $TMP_SPACE/details

echo "$DETAILS" >> $TMP_SPACE/details

if [ "$GRAPHICAL" == 1 ] ; then
    if [ -n "$DISPLAY" ] ; then
        [ -n "$DEBUG" ] && echo "Showing submission dialog..."
        if [ -x /usr/share/umx-utils/submission.py ] ; then
        # put this file in a retreiveable place, so that we can pre-fill the dialog if it faild
            /usr/share/umx-utils/submission.py -f /tmp/details || exit 1
            # /usr/share/umx-utils/submission.py -f /tmp/details || failed "Submission dialog failed"
        else
            if [ "$DETAILS_PROVIDED" == 0 ] ; then
                DETAILS="no deatils"
            fi
            echo "DETAILS=\"$DETAILS\"" > /tmp/details
        fi
    else
        GRAPHICAL=0
        if [ "$DETAILS_PROVIDED" == 0 ] ; then
            DETAILS="no deatils"
        fi
        echo "DETAILS=\"no display\"" > /tmp/details
    fi
fi

if [ "$GRAPHICAL" == 1 ] ; then
    $PROGRESS_DLG &
    PROGRESS_DLG_PID=$!
    KILL_PROGRESS="kill -SIGHUP $PROGRESS_DLG_PID"
fi

if [ -f /tmp/details ] ; then
    cat $TMP_SPACE/details /tmp/details > $DEST/details
else
    mv $TMP_SPACE/details $DEST/details
fi

#########################
# log files
#########################
mkdir $DEST/log

# - /var/log/1box-server.log and old files
if [ -r /var/log/1box-server.log ] ; then
    cp -ar /var/log/1box-server.log* $DEST/log
    cp -ar /var/log/1box-server.log $DEST
fi

# - /var/log/userful-start.log and old files
if [ -r /var/log/userful-start.log ] ; then
    cp -ar /var/log/userful-start.log* $DEST/log
    cp -ar /var/log/userful-start.log $DEST
fi

# - /var/log/userful-multiuser-device.log and old files
if [ -r /var/log/userful-multiuser-device.log ] ; then
    cp -ar /var/log/userful-multiuser-device.log* $DEST/log
    cp -ar /var/log/userful-multiuser-device.log $DEST
fi

# - /var/log/messages
if [ -r /var/log/messages ] ; then
    cp /var/log/messages $DEST
else
    echo "{EE} The messages file was not readable" > $DEST/log/messages
fi

# - /var/log/usbinput.log
if [ -r /var/log/usbinput.log ] ; then
    cp -ar /var/log/usbinput.log* $DEST/log
    cp -ar /var/log/usbinput.log $DEST
fi

# - /var/log/oem.log
if [ -r /var/log/oem.log ] ; then
    cp -ar /var/log/oem.log $DEST/log
fi

# In case there's discoverStation stuff too
if [ -d /var/log/userful ] ; then
    # there may be nothing there or we may not be able to read some files, we'll just try and get something
    cp -ar /var/log/userful $DEST/log/ &> /dev/null
fi

if [ -d /var/log/kiosk ] ; then
    cp -ar /var/log/kiosk $DEST/log/ &> /dev/null
fi

#########################
# system info files
#########################
mkdir $DEST/sys-info

# lspci, lspci -n
if which lspci  > /dev/null 2>&1; then
    lspci &> $DEST/sys-info/lspci
    lspci -n &> $DEST/sys-info/lspci-n
elif [ -x /opt/userful/bin/listpci ]; then
    /opt/userful/bin/listpci &> $DEST/sys-info/lspci
    /opt/userful/bin/listpci -n &> $DEST/sys-info/lspci-n
else
    echo "{EE} lspci not found" > $DEST/sys-info/lspci
    echo "{EE} lspci not found" > $DEST/sys-info/lspci-n
fi

# lsusb
if which lsusb  > /dev/null 2>&1; then
    lsusb &> $DEST/sys-info/lsusb
else
    echo "{EE} lsusb not found" > $DEST/sys-info/lsusb
fi

#- /etc/mvgainfo
if [ -r /etc/mvgainfo ] ; then
    cp -ar /etc/mvgainfo* $DEST/sys-info
    cp -ar /etc/mvgainfo $DEST
else
    echo "{EE} Could not read" > $DEST/sys-info/mvgainfo
fi

#- /etc/usbhub
if [ -r /etc/usbhub ] ; then
    cp -ar /etc/usbhub* $DEST/sys-info
    cp -ar /etc/usbhub $DEST
else
    echo "{EE} Could not read" > $DEST/sys-info/usbhub
fi

#- /etc/usbinput
if [ -r /etc/usbinput ] ; then
    cp -ar /etc/usbinput* $DEST/sys-info
    cp -ar /etc/usbinput $DEST
else
    echo "{EE} Could not read" > $DEST/sys-info/usbinput
fi

#- /etc/usbaudio
if [ -r /etc/usbaudio ] ; then
    cp -ar /etc/usbaudio* $DEST/sys-info
    cp -ar /etc/usbaudio $DEST
fi

#- /etc/multiuserdevices
if [ -r /etc/multiuserdevices ] ; then
    cp -ar /etc/multiuserdevices* $DEST/sys-info
    cp -ar /etc/multiuserdevices $DEST
fi

#- /etc/X11/userful.Mxorg.conf
if [ -r /etc/X11/userful.Mxorg.conf ] ; then
    cp -ar /etc/X11/userful.Mxorg.conf* $DEST/sys-info
    cp -ar /etc/X11/userful.Mxorg.conf $DEST
else
    echo "{EE} Could not read " > $DEST/sys-info/userful.Mxorg.conf
fi

#- /root/xorg.conf.new
if [ -r /root/xorg.conf.new ] ; then
    cp -ar /root/xorg.conf.new $DEST
fi

#- /etc/X11/xorg.conf
if [ -r /etc/X11/xorg.conf ] ; then
    cp -ar /etc/X11/xorg.conf $DEST/sys-info
fi

#- /etc/X11/XFree86-4
if [ -r /etc/X11/XFree86-4 ] ; then
    cp -ar /etc/X11/XFree86-4 $DEST/sys-info
fi

if ls /etc/*-release &> /dev/null ; then
    cp -ar /etc/*-release $DEST
fi

#########################
# /etc/userful 
#########################
if [ -d /etc/userful ] ; then
    cp -ar /etc/userful $DEST
else
    mkdir -p $DEST/userful
    echo "{EE} No /etc/userful directory" > $DEST/userful/missing
fi

##################################
# run /opt/userful/bin/umx-log.sh
##################################
if [ -x /opt/userful/bin/umx-gen-log.sh ]; then
    /opt/userful/bin/umx-gen-log.sh
fi
if [ -f /tmp/umx.log ]; then
    cp -ar /tmp/umx.log $DEST
fi

# - the xtype file
if [ -f /etc/sysconfig/xtype ] ; then
    cp -ar /etc/sysconfig/xtype $DEST
else
    mkdir -p $DEST/userful
    echo "file missing" > $DEST/xtype-missing
fi

# Tar and feather the files
cd $TMP_SPACE
TARGET=$MAC_DASHES-$EDATE.tar.gz
if tar zcf $TARGET $MAC_DASHES-$EDATE ; then
    if [ -w /var/log/userful/ ] || [ -w /var/log/userful/submit.log ] ; then
        echo "`date` Success" > /var/log/userful/submit.log
    fi
else
    failed "Could not tar files"
fi

# send it off
SERVER=np.userful.com
URL="http://$SERVER/upload-bug-report?form:mode=edit&form:id=upload_file_form&__confirmed_p=0&__refreshing_p=0&formbutton:ok=Save"

if [ -n "$DEBUG" ] ; then
    SERVER=np-dev.userful.ca
    URL="http://$SERVER/support/np/upload_file_test?form:mode=edit&form:id=upload_file_form&__confirmed_p=0&__refreshing_p=0&formbutton:ok=Save"
fi

if [ -x /usr/share/umx-utils/post-file.py ] ; then
	echo "Sending file ($TARGET)..."
    if /usr/share/umx-utils/post-file.py -u "$URL" -f $TARGET ; then
        if [ -d /proc/$PROGRESS_DLG_PID ] ; then
            $KILL_PROGRESS
        fi

        if [ "$GRAPHICAL" == 1 ] ; then
            exec $ERR_DLG type=sucess text="Successfully submitted information. Thank you."
        else
            echo "Successfully submitted information. Thank you."
        fi

        exit 0
    fi
else
    failed "python post script missing"
    exit 1
fi

if [ -d /proc/$PROGRESS_DLG_PID ] ; then
    $KILL_PROGRESS
fi

mv -f $TMP_SPACE/$TARGET /tmp

if [ "$GRAPHICAL" == 1 ] ; then
    exec $ERR_DLG type=error text="Failed to submit information. Check your Internet connection and try again. Alternatively you can manually email the file  /tmp/$TARGET to multiplier@userful.com."
else
    echo "$0: ERROR: Failed to send file."
    echo "Remnants are here: /tmp/$TARGET"
fi

failed "Python post script failed"

exit 127
