#!/bin/bash

#****** /bin/esd_session_init.sh
# NAME
# 	esd_session_init.sh
#
# AUTHOR
# 	Rocky
#
# DESCRIPTION
# 	Inital shell script for esd daemon in every session startup.
# 	The process includes:
# 	1) Set $HOME/.esd.conf file to init esd daemon;
# 	2) Set ESPEAKER in .profile.
# 	3) Usage: esd_session_init.sh $alsa_audio_device
# SOURCE
#
# TODO:
# 	This is not used in DM. Need to test with DST.


    alsa_audio_device=$1

    echo "[esd]" > ~/.esd.conf
    echo "default_options=-d hw:$alsa_audio_device -nobeeps -as 1" >> ~/.esd.conf

    gconftool-2 -s /desktop/gnome/sound/enable_esd --type bool true
    gconftool-2 -s /desktop/gnome/sound/event_sounds --type bool false

    #Play sample sound during session startup
    #aplay -D plughw:$alsa_audio_device /usr/share/sounds/userful_session_startup.wav &

#***
