#!/bin/bash
#
# 	multistation-storage-permission-check.sh
#
# 	AUTHOR
# 		Jason Kim <jason@userful.com>
#
# 	Copyright (c) 2002-2007 by Userful Corporation
#
# 	DESCRIPTION
#		  This program compares info.screen to /opt/userful/locks/screen.$HAL_METHOD_INVOKED_BY_UID
#		for permission check.
#
# 	Called from: Mount function. Name of the mount function is different for each distro.
#
# $1 : mount

logfile="/var/log/userful-start.log"
ACTION=$1

if [ "$HAL_METHOD_INVOKED_BY_UID" == "0" ]; then # root has invoked the current method.
	exit 0
fi

PARENT_UDI="$HAL_PROP_INFO_PARENT"

# Assigned screen of the current device
ASSIGNED_SCREEN=`hal-get-property --udi "$PARENT_UDI" --key "info.screen"`
# Login screen of the invoker
LOGIN_SCREEN=`cat /opt/userful/locks/screen.$HAL_METHOD_INVOKED_BY_UID`

if [ "$ASSIGNED_SCREEN" != "$LOGIN_SCREEN" ]; then
	echo "`date +"%b %d %T"` Permission denied for $HAL_PROP_BLOCK_DEVICE, Invoker_uid=$HAL_METHOD_INVOKED_BY_UID" >> $logfile
	exit 1
fi

echo "`date +"%b %d %T"` Permission allowd for $HAL_PROP_BLOCK_DEVICE, Invoker_uid=$HAL_METHOD_INVOKED_BY_UID" >> $logfile
exit 0
