
#ifndef _DLCON_H
#define _DLCON_H

#include <string>
#include <list>
#include <map>
#include <set>

//#include <netinet/in.h>
//#include <netdb.h>

#include "tcpconnect.h"

#include "lockable.h"
#include "fileitem.h"
#include "acfg.h"
#include "acbuf.h"

class tDlJob;


class dlcon : public lockable, tcpconnect
{ 
    public:
        dlcon(bool bManualExecution, mstring *xff=NULL);
        ~dlcon();
                
        void WorkLoop();
        
        void SignalStop();

	    void AddJob(tFileItemPtr m_pItem, tHttpUrl hi);
        void AddJob(tFileItemPtr m_pItem, 
        		acfg::tHostiVec *pBackends, const mstring & sPatSuffix);
    	void EnqJob(tDlJob *);

        mstring m_sXForwardedFor;
        
    private:
    	
    	friend class tDlJob;
    	

    	MYSTD::list<tDlJob*> m_qToReceive;
    	int m_wakepipe[2];
    	
    	//mstring m_sConnectedHost; // used to remember to which host we are connected

    	acbuf m_InBuf;
    	
    	// flags and local copies for input parsing
    	/// remember being attached to an fitem

    	bool m_bSingleRun;
    	    
    	MYSTD::set<mstring> m_MirrorHostBlacklist;

    	//not to be copied
    	dlcon & operator=(const dlcon&);
    	dlcon(const dlcon&);
};

typedef MYSTD::list<tDlJob*>::iterator dljIter; 

#endif


