// Aqsis
// Copyright c 1997 - 2001, Paul C. Gregory
//
// Contact: pgregory@aqsis.org
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA



/** \file
		\brief Implements RiGeometry "bunny" option.
		\author Michel Joron (joron@sympatico.ca) 
*/
/*    References:
 *
 *       The Stanford 3D Scanning Repository
 *           http://graphics.stanford.edu/data/3Dscanrep/#bunny|Bunny]
 */
#include	"aqsis.h"
#include	"bunny.h"


#include	"ri.h"

START_NAMESPACE( Aqsis )

static TqInt Faces01[] = {
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 , 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 , 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
3, 3, 3, 3 };


static TqInt Indexes01[] = { 
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
2, 1, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 27, 35, 36, 37, 38, 39, 40, 41, 42,
43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66,
67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90,
91, 92, 93, 94, 95, 96, 97, 98, 15, 17, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109,
110, 111, 112, 113, 114, 68, 115, 116, 117, 118, 51, 46, 119, 47, 120, 121, 122, 123, 37,
124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 76, 75, 137, 138, 139,
140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157,
158, 159, 160, 13, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174,
175, 99, 17, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190,
191, 61, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 69,
207, 109, 111, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 130, 129, 219, 220,
221, 198, 222, 199, 223, 224, 225, 226, 188, 227, 214, 213, 228, 148, 147, 229, 230, 231,
232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 79, 24,
248, 249, 250, 251, 252, 253, 150, 141, 254, 142, 255, 256, 257, 258, 259, 53, 260, 132,
261, 13, 12, 262, 263, 264, 265, 88, 266, 89, 267, 268, 269, 270, 271, 272, 273, 274, 275,
276, 277, 278, 279, 115, 68, 280, 281, 282, 283, 284, 253, 285, 286, 287, 288, 289, 290,
291, 292, 293, 223, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 268, 223, 305,
306, 260, 307, 308, 309, 8, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321,
322, 323, 324, 325, 326, 327, 328, 104, 329, 330, 331, 332, 196, 135, 194, 101, 333, 102,
234, 334, 335, 70, 249, 336, 337, 338, 339, 340, 341, 342, 44, 343, 42, 344, 345, 346, 347,
348, 349, 350, 351, 352, 353, 228, 354, 115, 355, 116, 356, 357, 358, 359, 322, 360, 361,
339, 338, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 140, 351, 327,
375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 239, 241, 387, 388, 389, 390,
391, 392, 109, 48, 50, 393, 394, 395, 396, 197, 199, 51, 259, 117, 397, 398, 399, 169, 400,
167, 276, 240, 401, 402, 403, 404, 405, 391, 406, 407, 408, 409, 356, 358, 410, 411, 412,
392, 177, 413, 178, 414, 145, 170, 90, 415, 416, 352, 351, 346, 214, 417, 418, 419, 420,
421, 422, 423, 424, 293, 425, 426, 149, 427, 428, 429, 89, 430, 431, 432, 433, 434, 55, 54,
435, 436, 437, 195, 194, 438, 439, 440, 441, 442, 443, 444, 252, 376, 445, 47, 119, 446,
447, 448, 449, 369, 450, 451, 452, 453, 454, 409, 455, 407, 403, 402, 54, 456, 96, 457,
408, 458, 459, 460, 21, 1, 461, 462, 463, 281, 280, 464, 465, 114, 348, 466, 271, 270, 138,
467, 468, 469, 470, 471, 295, 294, 472, 473, 474, 475, 476, 477, 275, 478, 479, 480, 80,
481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 143, 333, 101, 495,
496, 497, 420, 343, 498, 325, 327, 499, 500, 38, 37, 501, 502, 287, 502, 503, 504, 505,
506, 507, 128, 508, 509, 510, 511, 512, 513, 514, 515, 113, 516, 349, 517, 518, 519, 303,
520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 533, 327, 376, 152, 534,
535, 536, 537, 279, 538, 539, 540, 154, 538, 68, 67, 541, 523, 522, 92, 336, 542, 543, 544,
545, 546, 547, 548, 392, 405, 411, 549, 550, 491, 263, 551, 191, 545, 552, 523, 553, 554,
127, 555, 344, 556, 557, 558, 559, 560, 485, 561, 562, 563, 564, 565, 566, 567, 568, 569,
570, 571, 572, 573, 574, 575, 552, 576, 577, 578, 512, 579, 580, 581, 582, 583, 584, 585,
586, 174, 173, 587, 536, 588, 589, 534, 536, 589, 590, 591, 592, 593, 594, 595, 596, 597,
598, 599, 110, 459, 203, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609, 610, 611, 612,
613, 614, 615, 616, 617, 618, 619, 620, 621, 622, 623, 78, 624, 335, 625, 118, 601, 600,
626, 627, 526, 628, 629, 630, 631, 51, 53, 259, 632, 586, 585, 423, 422, 633, 634, 635,
636, 637, 2, 21, 638, 639, 640, 641, 320, 93, 402, 642, 643, 477, 640, 225, 644, 296, 221,
336, 92, 645, 474, 473, 18, 200, 202, 179, 435, 646, 647, 648, 484, 649, 650, 651, 652,
426, 653, 291, 277, 654, 639, 303, 655, 304, 656, 657, 658, 659, 363, 617, 142, 254, 123,
660, 661, 155, 321, 127, 319, 655, 662, 663, 664, 665, 666, 667, 668, 521, 669, 243, 670,
518, 671, 519, 528, 663, 481, 672, 673, 40, 586, 674, 675, 676, 677, 72, 678, 679, 680,
681, 354, 682, 683, 556, 346, 684, 685, 686, 687, 464, 656, 208, 688, 109, 528, 530, 689,
683, 690, 691, 692, 693, 96, 694, 311, 310, 695, 696, 576, 697, 648, 698, 266, 365, 89,
699, 700, 701, 702, 626, 600, 703, 704, 705, 553, 127, 706, 707, 543, 708, 709, 710, 711,
712, 713, 714, 715, 568, 43, 716, 717, 539, 495, 497, 429, 168, 718, 719, 555, 720, 721,
596, 722, 28, 544, 574, 723, 724, 725, 340, 282, 726, 727, 728, 508, 729, 164, 166, 229,
730, 731, 732, 688, 208, 733, 734, 296, 644, 639, 269, 268, 735, 736, 389, 737, 738, 501,
74, 739, 740, 702, 741, 742, 743, 744, 474, 288, 745, 746, 747, 748, 749, 750, 75, 751,
249, 70, 752, 526, 160, 432, 192, 61, 60, 753, 754, 162, 198, 197, 606, 755, 756, 757, 477,
476, 640, 758, 759, 760, 761, 762, 530, 763, 539, 764, 765, 119, 766, 767, 108, 768, 546,
183, 769, 75, 770, 137, 771, 772, 564, 561, 648, 32, 773, 774, 775, 237, 236, 776, 777,
164, 737, 46, 778, 779, 780, 781, 782, 783, 784, 785, 786, 503, 787, 317, 30, 710, 59, 12,
57, 788, 789, 790, 782, 791, 792, 793, 794, 795, 796, 797, 732, 798, 799, 460, 800, 801,
440, 341, 108, 802, 803, 83, 82, 804, 805, 806, 442, 444, 807, 808, 773, 775, 192, 809,
193, 524, 810, 811, 812, 813, 814, 809, 192, 815, 816, 817, 818, 234, 819, 235, 71, 336,
645, 602, 502, 603, 429, 87, 89, 88, 682, 266, 820, 821, 822, 104, 330, 329, 823, 824, 825,
234, 826, 827, 828, 265, 829, 34, 830, 831, 832, 833, 834, 835, 836, 837, 45, 47, 838, 839,
840, 841, 234, 117, 819, 842, 843, 844, 845, 846, 514, 847, 848, 364, 849, 850, 851, 448,
852, 853, 854, 855, 856, 857, 858, 765, 754, 753, 859, 323, 860, 324, 861, 592, 229, 555,
862, 454, 631, 863, 629, 763, 864, 865, 866, 867, 868, 684, 869, 436, 870, 261, 132, 122,
848, 847, 564, 772, 562, 94, 554, 871, 185, 810, 872, 873, 146, 564, 683, 454, 862, 66,
874, 67, 875, 876, 106, 877, 311, 373, 246, 245, 6, 878, 879, 386, 763, 865, 540, 861, 147,
417, 880, 835, 881, 882, 883, 247, 859, 743, 680, 884, 885, 886, 887, 466, 888, 588, 569,
715, 889, 582, 890, 467, 140, 374, 446, 838, 47, 891, 209, 892, 893, 894, 571, 94, 727, 95,
895, 896, 897, 706, 898, 899, 385, 768, 897, 900, 901, 902, 903, 479, 478, 904, 514, 579,
905, 906, 907, 651, 114, 465, 889, 908, 583, 575, 574, 909, 910, 800, 911, 340, 342, 230,
122, 912, 907, 913, 914, 915, 916, 511, 396, 696, 917, 837, 918, 162, 180, 728, 919, 920,
384, 383, 921, 922, 923, 924, 925, 201, 200, 15, 926, 16, 472, 294, 927, 525, 928, 929,
761, 930, 781, 931, 932, 933, 488, 215, 486, 787, 934, 935, 936, 937, 938, 565, 567, 939,
940, 447, 941, 690, 351, 140, 123, 254, 65, 36, 699, 722, 273, 942, 274, 394, 310, 312,
943, 944, 613, 945, 560, 946, 947, 948, 949, 950, 951, 952, 267, 269, 179, 610, 217, 416,
953, 490, 954, 164, 955, 165, 956, 638, 559, 957, 958, 187, 827, 442, 807, 935, 270, 272,
450, 895, 451, 959, 960, 891, 961, 962, 963, 964, 965, 257, 535, 966, 536, 413, 822, 178,
967, 558, 968, 969, 900, 902, 970, 971, 972, 956, 892, 209, 264, 413, 654, 973, 612, 611,
974, 975, 946, 976, 977, 291, 315, 759, 355, 978, 647, 646, 979, 980, 981, 752, 69, 206,
982, 983, 984, 985, 400, 986, 987, 410, 988, 646, 486, 217, 989, 966, 614, 711, 710, 29,
237, 814, 990, 991, 992, 993, 337, 339, 994, 181, 180, 563, 357, 67, 874, 986, 400, 169,
135, 387, 194, 681, 682, 995, 262, 951, 96, 888, 592, 591, 746, 289, 288, 858, 996, 590,
133, 442, 827, 997, 998, 999, 1000, 1001, 1002, 633, 144, 423, 816, 318, 444, 59, 58,
1003, 744, 475, 474, 1004, 233, 21, 1005, 176, 1006, 87, 1007, 458, 28, 30, 597, 86, 1008,
898, 1009, 776, 236, 850, 494, 851, 84, 382, 85, 790, 1010, 1011, 694, 274, 1012, 1013,
452, 454, 924, 1014, 1015, 132, 799, 314, 1016, 709, 719, 193, 809, 1017, 1018, 1019,
1020, 321, 320, 1021, 1022, 211, 210, 1023, 638, 1024, 1025, 1026, 744, 824, 823, 1027,
812, 360, 1028, 231, 1029, 232, 1030, 1031, 1032, 579, 511, 916, 173, 1033, 1034, 1035,
1036, 1037, 570, 1038, 989, 660, 1039, 1040, 662, 655, 303, 1041, 1042, 1043, 52, 1044,
1045, 942, 273, 295, 281, 1046, 1047, 106, 876, 107, 1048, 1000, 964, 582, 889, 583, 92,
994, 361, 495, 169, 1049, 815, 878, 809, 1050, 175, 824, 387, 135, 134, 441, 1051, 1052,
1049, 719, 709, 347, 1053, 465, 1054, 1055, 1056, 209, 1057, 1024, 125, 321, 918, 90, 92,
542, 1058, 616, 615, 274, 325, 275, 1059, 1060, 1061, 936, 954, 797, 1062, 1063, 1064,
1065, 1066, 355, 1067, 488, 572, 154, 1068, 155, 915, 663, 662, 565, 939, 1069, 324,
1070, 1071, 1072, 568, 570, 1022, 981, 1073, 1074, 424, 423, 1075, 475, 1026, 974, 946,
33, 1076, 308, 139, 74, 73, 1077, 1060, 138, 468, 151, 551, 412, 793, 795, 1078, 842,
1079, 1080, 1081, 1082, 595, 623, 79, 78, 69, 71, 157, 589, 419, 1083, 350, 1063, 374,
909, 574, 388, 130, 1084, 1085, 1007, 87, 497, 968, 1086, 4, 572, 487, 573, 525, 1087,
526, 1088, 1089, 1090, 485, 286, 1091, 1092, 910, 1093, 793, 136, 135, 123, 1094, 142,
1095, 460, 131, 547, 769, 18, 335, 117, 234, 1082, 520, 595, 223, 268, 267, 1096, 1097,
1098, 32, 31, 561, 1099, 1100, 774, 1101, 82, 672, 1102, 1103, 86, 431, 9, 731, 164, 229,
592, 920, 919, 53, 990, 814, 813, 550, 1104, 491, 1105, 1106, 1107, 1108, 492, 494, 933,
1011, 1010, 919, 728, 1109, 700, 699, 38, 618, 1110, 619, 96, 693, 97, 1111, 289, 866,
102, 333, 1112, 63, 3, 1113, 1114, 947, 1115, 1079, 842, 844, 1055, 671, 1116, 1117, 105,
739, 280, 871, 1118, 849, 1119, 666, 83, 803, 1120, 615, 1121, 1122, 389, 736, 1123,
1124, 85, 382, 1125, 1126, 1127, 1128, 407, 455, 1129, 204, 941, 1130, 828, 829, 1120,
622, 621, 327, 326, 375, 70, 69, 752, 833, 562, 834, 1108, 494, 666, 442, 133, 306, 375,
326, 694, 1017, 1131, 1132, 1080, 1079, 1133, 978, 646, 217, 376, 375, 445, 1134, 1065,
1135, 738, 737, 888, 1136, 1137, 739, 1138, 1076, 139, 508, 728, 1139, 703, 190, 704,
1140, 950, 952, 792, 1141, 593, 1142, 78, 482, 1143, 1144, 1031, 278, 1023, 1145, 689,
663, 528, 437, 573, 435, 141, 143, 101, 1064, 1146, 1147, 410, 1148, 988, 1149, 121, 120,
1150, 1031, 1030, 1151, 1152, 607, 171, 145, 1153, 231, 1154, 1155, 658, 571, 1156,
1157, 483, 1158, 1159, 1094, 1160, 978, 217, 610, 864, 1068, 865, 1161, 483, 1162, 1163,
1164, 222, 1165, 1166, 1167, 868, 565, 392, 1168, 286, 285, 408, 1128, 458, 600, 973,
741, 1103, 894, 86, 784, 1166, 1165, 1046, 1169, 1047, 634, 1170, 635, 290, 736, 735,
769, 185, 19, 929, 1171, 1172, 429, 430, 985, 200, 822, 821, 14, 1173, 1034, 319, 94, 93,
1110, 1027, 300, 1174, 757, 1018, 1004, 826, 233, 463, 210, 891, 1060, 742, 613, 646,
487, 486, 769, 183, 185, 779, 841, 840, 291, 977, 1175, 496, 1176, 924, 854, 1151, 1006,
1072, 989, 451, 196, 1177, 1178, 429, 986, 169, 1179, 653, 426, 368, 206, 1180, 834,
1181, 832, 1182, 1183, 1184, 941, 204, 940, 884, 1185, 1165, 608, 1186, 1187, 304, 762,
302, 196, 195, 1177, 1188, 1056, 1189, 992, 844, 1190, 626, 493, 492, 808, 1108, 665,
289, 1111, 1191, 597, 1192, 755, 613, 1090, 943, 245, 247, 1161, 1193, 296, 734, 436,
685, 684, 1194, 1195, 150, 240, 1196, 401, 206, 1197, 752, 1198, 707, 708, 812, 359, 360,
1199, 1200, 901, 489, 491, 730, 1201, 1030, 1202, 1064, 841, 1062, 112, 949, 1203, 286,
1168, 1091, 1053, 1167, 1166, 1204, 460, 1, 1106, 406, 391, 1039, 958, 1040, 918, 182,
1205, 1065, 355, 115, 1206, 704, 283, 278, 1145, 241, 235, 103, 1117, 934, 787, 502, 211,
1022, 1207, 450, 369, 368, 728, 920, 1139, 451, 107, 1072, 623, 624, 1208, 138, 140, 467,
221, 323, 644, 1037, 1200, 1035, 1209, 687, 1210, 1095, 131, 133, 1123, 194, 387, 1211,
1171, 1212, 679, 678, 1213, 801, 1214, 1051, 1213, 1190, 1215, 969, 902, 1216, 559, 638,
557, 317, 316, 1192, 427, 989, 616, 419, 1217, 42, 1218, 1187, 648, 399, 1219, 362, 517,
1093, 911, 1220, 108, 767, 1221, 3, 63, 37, 1020, 124, 401, 1196, 677, 1222, 1223, 195,
973, 600, 203, 459, 458, 922, 1224, 139, 138, 980, 979, 1225, 1106, 1226, 1107, 322,
1227, 360, 161, 563, 162, 984, 15, 99, 1228, 1229, 472, 634, 1230, 1231, 609, 1232, 1233,
1100, 1234, 455, 282, 871, 280, 353, 838, 446, 65, 1235, 63, 1101, 750, 82, 192, 1203,
815, 1179, 1011, 1236, 1237, 406, 4, 867, 566, 565, 1080, 909, 1238, 291, 1239, 976, 527,
1240, 525, 1241, 271, 466, 1057, 1131, 1145, 113, 349, 348, 844, 843, 1190, 1242, 468,
1062, 1210, 869, 1209, 1243, 1116, 1048, 468, 467, 1063, 1230, 634, 1244, 283, 189, 284,
93, 95, 531, 1245, 537, 1246, 999, 1247, 1248, 611, 742, 741, 597, 596, 28, 72, 677, 1196,
1001, 1249, 911, 768, 107, 1250, 1033, 57, 1034, 670, 1104, 550, 1120, 668, 622, 15,
1251, 931, 71, 158, 157, 1252, 558, 476, 790, 1253, 1254, 701, 29, 28, 462, 981, 463, 64,
63, 1113, 447, 953, 941, 1210, 573, 437, 1255, 1256, 156, 1257, 790, 1258, 526, 627, 527,
377, 379, 347, 665, 1108, 666, 168, 1044, 718, 1049, 169, 719, 1040, 1176, 1259, 1117,
739, 637, 119, 765, 446, 1260, 1261, 137, 372, 971, 373, 580, 1009, 22, 1262, 1006, 1263,
482, 78, 80, 1264, 1265, 1266, 1100, 49, 1267, 1268, 75, 1269, 251, 33, 1270, 1271, 1272,
1104, 1273, 1028, 360, 322, 324, 1227, 1274, 7, 245, 696, 1275, 917, 1145, 1023, 1057,
441, 1052, 1276, 105, 328, 739, 577, 836, 835, 743, 859, 1025, 737, 164, 592, 1277, 1278,
1181, 728, 1279, 1109, 156, 921, 157, 224, 273, 275, 1280, 1281, 1075, 751, 1282, 750,
1126, 1125, 1093, 1283, 1284, 670, 304, 689, 530, 703, 820, 190, 1285, 684, 686, 1243,
1286, 1189, 1040, 711, 661, 1287, 1288, 1289, 254, 1235, 65, 1238, 842, 1080, 1192, 756,
755, 80, 248, 1290, 1291, 483, 1292, 266, 354, 366, 1293, 1042, 1041, 1294, 970, 394,
260, 261, 478, 1031, 707, 1032, 556, 862, 555, 1098, 1102, 1295, 1292, 883, 1296, 365,
367, 1122, 129, 1297, 365, 1298, 324, 1071, 1281, 533, 1075, 731, 628, 432, 619, 1110,
300, 807, 1299, 335, 807, 334, 827, 861, 1300, 1301, 262, 456, 1302, 301, 541, 299, 711,
1303, 1304, 1269, 1208, 1305, 798, 116, 758, 1218, 608, 1187, 280, 656, 464, 1306, 906,
1307, 1277, 1096, 1295, 778, 46, 45, 207, 383, 385, 992, 991, 1308, 1309, 1054, 434, 409,
109, 50, 649, 1157, 984, 791, 813, 441, 958, 599, 1015, 1299, 317, 625, 404, 403, 1310,
1311, 242, 969, 1250, 895, 768, 851, 1242, 849, 519, 1312, 1313, 290, 735, 288, 820, 413,
263, 452, 1266, 1265, 138, 613, 1314, 331, 1315, 1316, 1274, 691, 7, 1153, 1317, 1318,
338, 1255, 361, 968, 1319, 967, 654, 413, 177, 886, 1185, 884, 1320, 991, 993, 1321,
1243, 1189, 426, 425, 1322, 1323, 818, 1324, 839, 841, 1147, 271, 1325, 453, 1198, 301,
300, 1046, 1209, 1169, 713, 1216, 902, 563, 833, 181, 315, 355, 1066, 338, 1097, 1096,
1296, 1326, 1292, 207, 1180, 206, 756, 816, 818, 1187, 698, 648, 675, 1035, 1200, 703,
821, 820, 1327, 1328, 997, 1329, 471, 470, 430, 89, 365, 878, 1330, 879, 1182, 621, 620,
1331, 1332, 113, 437, 436, 869, 1268, 751, 75, 1333, 1334, 1257, 1232, 1335, 1233, 419,
589, 1217, 1065, 279, 1245, 1232, 1218, 648, 914, 913, 1268, 228, 213, 366, 977, 1291,
1292, 724, 343, 44, 822, 413, 820, 830, 34, 62, 651, 947, 114, 479, 143, 480, 1024, 1057,
1023, 77, 1336, 1329, 953, 449, 549, 212, 1058, 615, 808, 665, 773, 78, 1142, 624, 892,
959, 891, 1102, 85, 1124, 1337, 322, 359, 380, 182, 381, 1338, 1339, 930, 578, 1081, 594,
1127, 1340, 1341, 1088, 1342, 1343, 1120, 1344, 668, 549, 490, 953, 700, 717, 716, 129,
365, 1122, 209, 1024, 956, 1169, 684, 1345, 667, 521, 520, 149, 418, 417, 1246, 1346,
1347, 467, 374, 1063, 1222, 438, 290, 377, 347, 26, 1036, 1144, 1143, 420, 42, 343, 394,
375, 310, 1303, 701, 700, 277, 276, 264, 956, 1024, 638, 1159, 142, 1094, 1182, 533, 532,
628, 731, 730, 152, 411, 1348, 1224, 1179, 426, 225, 305, 223, 49, 1100, 455, 1000, 1048,
1116, 814, 237, 1337, 482, 481, 663, 39, 41, 1047, 1098, 1097, 1349, 328, 329, 740, 957,
110, 599, 1196, 1350, 1351, 1324, 307, 260, 1116, 1249, 1000, 1264, 245, 935, 42, 1217,
43, 887, 1241, 466, 151, 1195, 551, 928, 1240, 712, 1293, 1041, 57, 407, 1128, 408, 69,
157, 207, 906, 905, 1352, 1353, 777, 287, 1097, 338, 337, 1354, 1030, 1355, 907, 1356,
905, 890, 384, 921, 478, 1159, 1160, 935, 245, 787, 1357, 190, 189, 228, 366, 354, 830,
1225, 831, 61, 1358, 1073, 992, 680, 993, 1359, 959, 892, 510, 512, 470, 1360, 1361, 998,
1362, 64, 1363, 786, 787, 245, 113, 1332, 516, 128, 1085, 534, 1327, 372, 1364, 536, 569,
588, 1047, 41, 726, 1365, 1366, 297, 731, 432, 431, 126, 918, 1205, 501, 777, 737, 748,
685, 436, 848, 121, 1367, 1348, 1252, 1368, 183, 1369, 1370, 1371, 91, 416, 1316, 1155,
1372, 1373, 1374, 353, 921, 383, 157, 27, 831, 25, 750, 1101, 75, 1283, 1375, 1267, 255,
1088, 1376, 40, 673, 41, 1377, 1172, 1211, 1086, 968, 1252, 881, 121, 1378, 1142, 915,
1305, 1370, 1369, 548, 1225, 1379, 25, 461, 979, 462, 1302, 13, 262, 919, 258, 53, 928,
712, 714, 223, 295, 224, 71, 645, 158, 90, 1380, 415, 1381, 566, 746, 398, 1382, 1219,
1383, 730, 1272, 409, 459, 110, 476, 275, 499, 1381, 567, 566, 736, 438, 1123, 962, 1319,
963, 1384, 170, 172, 815, 1203, 1385, 749, 435, 647, 1223, 1372, 1177, 798, 68, 116, 779,
778, 1099, 1359, 892, 1346, 1344, 521, 668, 518, 911, 1249, 531, 505, 532, 1362, 1386,
38, 1192, 316, 1387, 1388, 537, 987, 1180, 896, 450, 1099, 664, 779, 299, 522, 659, 514,
513, 845, 1389, 1390, 1289, 1278, 1124, 382, 1391, 1392, 100, 1337, 1393, 846, 581, 802,
582, 676, 332, 1394, 615, 1122, 212, 524, 523, 552, 716, 1303, 700, 1395, 1378, 1149, 15,
1334, 926, 1396, 320, 641, 816, 443, 817, 803, 1344, 1120, 195, 1223, 1177, 77, 1397,
1208, 61, 1132, 1358, 1398, 1291, 977, 1399, 16, 926, 243, 1311, 1400, 1074, 146, 424,
562, 772, 834, 1350, 1196, 239, 669, 208, 584, 1401, 24, 1402, 757, 756, 818, 732, 489,
730, 488, 487, 572, 448, 1108, 808, 1135, 1391, 1134, 1403, 1404, 886, 1405, 1152, 1366,
1113, 1363, 64, 1406, 819, 420, 1407, 118, 625, 38, 699, 36, 1302, 457, 1310, 637, 21,
233, 1268, 913, 1408, 727, 94, 282, 1279, 729, 534, 742, 1059, 702, 1079, 1308, 19, 1257,
1010, 790, 625, 317, 1016, 637, 739, 1137, 1147, 345, 839, 1102, 86, 85, 1051, 1214,
1052, 601, 940, 203, 405, 406, 1237, 709, 1259, 1049, 542, 251, 90, 95, 506, 505, 1381,
1144, 1036, 584, 1199, 244, 908, 1078, 583, 12, 59, 952, 1144, 1381, 745, 506, 95, 727,
1063, 350, 1064, 1409, 364, 848, 577, 835, 1082, 492, 1108, 448, 1410, 1047, 1169, 195,
438, 1222, 831, 1225, 25, 1313, 54, 402, 1161, 786, 245, 161, 873, 564, 334, 234, 827,
1339, 1411, 930, 1329, 1401, 1402, 163, 754, 680, 602, 604, 738, 11, 10, 403, 424, 1215,
1190, 1001, 911, 800, 31, 33, 946, 472, 942, 295, 499, 275, 325, 1319, 962, 967, 802, 342,
341, 567, 864, 939, 824, 175, 825, 1258, 1412, 298, 1276, 792, 791, 565, 1069, 1413, 179,
202, 267, 1289, 237, 990, 399, 1414, 1415, 1356, 473, 905, 1290, 635, 1416, 444, 318,
807, 412, 411, 151, 112, 1331, 113, 1027, 823, 1201, 1218, 609, 608, 1320, 18, 20, 948,
1330, 1385, 460, 1204, 798, 1339, 1170, 634, 1088, 1343, 1417, 527, 712, 1240, 1418,
1148, 650, 584, 208, 585, 886, 1404, 461, 894, 1103, 1419, 252, 445, 1420, 93, 1281,
1280, 561, 31, 560, 734, 1421, 1193, 1141, 1422, 594, 509, 129, 128, 114, 113, 348, 1106,
391, 1226, 669, 733, 208, 242, 1311, 243, 568, 107, 876, 684, 1169, 1209, 412, 866, 868,
1334, 15, 931, 1182, 532, 621, 62, 981, 980, 1023, 639, 638, 503, 285, 504, 899, 898,
1118, 535, 614, 966, 1019, 1160, 1094, 133, 132, 306, 550, 853, 1423, 357, 874, 1077,
915, 1142, 482, 530, 529, 930, 1113, 3, 1424, 571, 894, 1067, 99, 649, 984, 486, 215, 217,
1376, 612, 973, 1323, 1018, 757, 964, 1000, 1425, 1345, 1410, 1169, 770, 1101, 40, 512,
1401, 470, 1297, 430, 365, 1399, 926, 1333, 801, 910, 1092, 1426, 106, 108, 925, 821,
1427, 1176, 1014, 924, 820, 263, 190, 1323, 757, 818, 335, 1299, 625, 1121, 130, 1428,
775, 1283, 852, 840, 119, 46, 493, 626, 1059, 1256, 921, 156, 287, 286, 1353, 1429, 1430,
634, 421, 117, 259, 1220, 767, 1431, 879, 1330, 1350, 1423, 852, 1283, 1286, 205, 1189,
610, 609, 978, 1432, 796, 731, 1433, 901, 1200, 229, 166, 148, 1309, 1055, 1054, 371,
1229, 1228, 61, 1073, 62, 558, 967, 559, 1378, 630, 1434, 1017, 386, 241, 1101, 672, 40,
782, 1435, 1288, 802, 1436, 582, 669, 584, 244, 1437, 1127, 1341, 1199, 584, 586, 1241,
857, 1325, 508, 1045, 509, 544, 723, 545, 928, 525, 1240, 1014, 1040, 958, 514, 904, 515,
1088, 1227, 324, 636, 248, 1438, 517, 911, 518, 571, 1067, 572, 1025, 641, 1026, 174,
1377, 825, 1121, 1439, 1085, 1338, 1170, 1339, 469, 471, 1336, 915, 914, 1305, 12, 952,
951, 373, 971, 877, 1369, 546, 548, 1166, 1418, 652, 839, 766, 840, 1297, 985, 430, 1161,
1162, 786, 367, 212, 1122, 1440, 292, 291, 158, 1255, 156, 1302, 1310, 10, 799, 758, 760,
693, 1127, 1126, 870, 1066, 903, 1409, 848, 1367, 1268, 1305, 914, 456, 262, 96, 402,
643, 1313, 837, 917, 1441, 896, 895, 450, 870, 313, 1066, 137, 770, 1410, 1332, 806, 805,
1317, 889, 1442, 595, 520, 303, 187, 958, 227, 1016, 710, 709, 1443, 975, 370, 400, 985,
1297, 524, 872, 810, 531, 533, 93, 685, 748, 747, 1339, 1231, 1411, 362, 617, 363, 483,
1161, 247, 101, 100, 961, 130, 218, 1428, 1073, 1358, 1022, 918, 180, 182, 388, 574, 389,
1247, 1427, 1248, 1277, 1384, 172, 1386, 1362, 1363, 1, 66, 1204, 902, 1433, 714, 686,
1260, 1345, 573, 487, 435, 1444, 1445, 228, 241, 240, 278, 1398, 977, 1446, 451, 427,
148, 232, 1029, 330, 1442, 889, 890, 1323, 1324, 1160, 602, 738, 466, 589, 588, 1217,
412, 551, 828, 800, 910, 801, 24, 23, 248, 1100, 778, 1234, 1235, 963, 1221, 1447, 1190,
1448, 652, 1053, 1166, 1301, 590, 861, 970, 972, 395, 1259, 709, 711, 1005, 1006, 1262,
499, 327, 1368, 878, 386, 809, 165, 369, 166, 394, 970, 395, 1176, 496, 495, 633, 136,
1078, 41, 673, 726, 215, 1419, 1103, 988, 783, 987, 356, 410, 987, 1244, 634, 1430, 852,
808, 775, 110, 109, 409, 448, 853, 449, 1449, 1214, 1450, 1377, 174, 1172, 676, 72, 332,
793, 135, 196, 557, 476, 558, 512, 511, 579, 144, 1153, 145, 421, 258, 419, 749, 1335,
747, 987, 537, 538, 905, 475, 863, 507, 81, 505, 492, 448, 447, 318, 816, 1387, 1234, 995,
455, 828, 263, 265, 1356, 548, 547, 76, 137, 1336, 1098, 1295, 1096, 1234, 681, 995,
1091, 1162, 485, 772, 1384, 1277, 1121, 1428, 1122, 1034, 57, 12, 687, 1209, 1046, 66, 0,
874, 1419, 1067, 894, 1244, 1430, 1289, 718, 1407, 1016, 1056, 1321, 1189, 1451, 1396,
641, 415, 610, 416, 247, 1292, 483, 1302, 159, 13, 93, 533, 1281, 330, 1315, 331, 1087,
525, 929, 726, 282, 281, 1391, 102, 1134, 1273, 360, 965, 1083, 258, 919, 918, 1021,
1396, 495, 1259, 1176, 1030, 1212, 1355, 601, 626, 492, 143, 142, 480, 1057, 1132, 1131,
481, 1290, 1416, 629, 1183, 630, 1452, 11, 403, 1130, 1453, 1111, 1404, 979, 461, 785,
1185, 959, 1051, 441, 440, 2, 637, 0, 975, 1443, 945, 688, 1284, 1267, 830, 62, 980, 885,
884, 1167, 1454, 1258, 1455, 1026, 641, 1280, 1451, 918, 1396, 1445, 214, 228, 622, 667,
520, 521, 662, 303, 313, 870, 314, 1216, 713, 1272, 1276, 1141, 792, 193, 1132, 61, 1415,
1409, 917, 1174, 1018, 598, 1222, 1394, 1223, 678, 680, 992, 732, 490, 489, 1212, 1201,
823, 1299, 807, 1456, 483, 1157, 649, 563, 180, 162, 648, 1005, 1232, 1235, 1221, 63,
1259, 495, 1049, 1059, 1061, 493, 1210, 1156, 573, 1263, 1006, 1151, 1390, 1230, 1244,
1451, 641, 859, 1122, 218, 129, 940, 601, 447, 340, 232, 724, 227, 188, 187, 686, 1262,
1457, 380, 1205, 182, 753, 918, 1451, 805, 35, 516, 690, 683, 346, 751, 1268, 1408, 1324,
260, 478, 949, 112, 947, 664, 666, 1119, 441, 1276, 791, 1023, 277, 639, 497, 87, 429,
1107, 1424, 3, 345, 1147, 1146, 233, 826, 234, 989, 427, 451, 272, 271, 1264, 1458, 434,
1459, 630, 1395, 631, 720, 839, 721, 1118, 898, 1460, 494, 850, 666, 102, 1391, 100,
1047, 1410, 39, 541, 708, 545, 335, 118, 117, 307, 817, 443, 860, 323, 220, 1461, 138,
1462, 681, 1234, 838, 398, 397, 1293, 1075, 863, 475, 1004, 21, 460, 1430, 238, 1289, 57,
1033, 1293, 1132, 1207, 1358, 414, 771, 564, 652, 651, 465, 309, 246, 8, 398, 1463, 1382,
280, 1118, 657, 730, 1383, 527, 1013, 1274, 1266, 1005, 747, 1232, 490, 797, 954, 1243,
1321, 1116, 136, 793, 1078, 1297, 129, 400, 364, 1414, 362, 455, 409, 50, 1407, 625,
1016, 971, 372, 1327, 613, 742, 611, 1360, 927, 1464, 270, 935, 602, 644, 1465, 734, 733,
669, 1284, 1344, 1282, 521, 175, 174, 825, 155, 1304, 153, 1242, 1119, 849, 1123, 387,
389, 1353, 955, 777, 1292, 247, 883, 1139, 1045, 508, 952, 59, 1140, 573, 1156, 571,
1466, 766, 1325, 432, 159, 433, 696, 837, 836, 108, 341, 1426, 902, 714, 713, 871, 899,
1118, 744, 743, 1025, 420, 419, 42, 1228, 927, 1467, 175, 1050, 173, 675, 674, 1035, 782,
792, 780, 1449, 1052, 1214, 470, 469, 1261, 1371, 216, 1349, 670, 243, 1400, 55, 936, 56,
1264, 935, 272, 1372, 1223, 331, 987, 357, 356, 529, 1338, 930, 1155, 1316, 231, 1091,
1168, 1162, 909, 388, 1238, 1129, 1188, 204, 503, 786, 1162, 599, 459, 922, 688, 48, 109,
361, 158, 645, 792, 593, 780, 271, 1241, 1325, 863, 1075, 629, 579, 916, 1468, 1059, 626,
702, 705, 704, 1469, 1359, 1388, 987, 1075, 1026, 1280, 1412, 1258, 1454, 1013, 454,
683, 717, 700, 1386, 795, 581, 583, 1320, 474, 18, 431, 433, 10, 1261, 510, 470, 538, 357,
987, 479, 903, 1066, 1406, 235, 819, 1450, 1341, 1470, 1304, 716, 153, 718, 1016, 719,
551, 263, 828, 659, 811, 363, 1258, 1254, 1455, 480, 1159, 478, 724, 232, 330, 505, 531,
95, 780, 761, 781, 703, 705, 1427, 722, 699, 701, 1373, 353, 446, 418, 428, 616, 32, 1270,
33, 715, 43, 588, 520, 1471, 1434, 253, 1194, 150, 339, 361, 994, 1045, 167, 509, 1271,
670, 1400, 1464, 267, 202, 846, 1393, 514, 760, 314, 799, 1447, 134, 136, 281, 1047, 726,
344, 555, 721, 316, 318, 1387, 384, 767, 385, 1136, 1077, 1137, 1146, 350, 352, 206, 368,
1197, 27, 516, 35, 361, 645, 92, 1472, 1140, 1473, 44, 725, 724, 1415, 1275, 1042, 1431,
1436, 1220, 1271, 1104, 670, 492, 447, 601, 843, 134, 1447, 1216, 1272, 1311, 857, 765,
1466, 1347, 1346, 956, 871, 282, 94, 673, 727, 726, 858, 1474, 1373, 1121, 615, 614, 338,
172, 1255, 111, 110, 957, 247, 246, 882, 1154, 795, 794, 283, 704, 1357, 370, 1197, 368,
340, 875, 1426, 982, 984, 1157, 680, 754, 859, 1088, 324, 1298, 593, 1141, 594, 1372,
794, 1178, 902, 901, 1433, 466, 738, 888, 325, 274, 326, 468, 851, 1061, 177, 269, 639,
1337, 237, 1393, 364, 363, 847, 1309, 1312, 1055, 1193, 1365, 297, 951, 262, 12, 1320,
680, 743, 981, 462, 979, 501, 738, 604, 86, 898, 84, 473, 1356, 547, 1307, 120, 1306,
1453, 677, 676, 1229, 1012, 942, 937, 1129, 938, 275, 225, 224, 167, 1044, 168, 393, 445,
394, 585, 188, 226, 1380, 32, 697, 336, 249, 542, 310, 375, 694, 1286, 256, 973, 1226,
391, 1069, 39, 1410, 40, 898, 1008, 1460, 498, 103, 1406, 805, 34, 35, 1183, 620, 1434,
1367, 1441, 917, 440, 1002, 800, 75, 77, 1269, 226, 632, 585, 958, 957, 599, 909, 1080,
575, 1081, 595, 594, 143, 479, 333, 951, 950, 692, 16, 856, 855, 1119, 841, 779, 587,
1172, 174, 937, 1458, 1459, 1069, 763, 764, 695, 576, 578, 559, 962, 1392, 790, 1254,
1258, 1336, 137, 469, 214, 1300, 417, 1458, 936, 434, 1012, 1229, 371, 409, 408, 459,
1213, 1215, 679, 675, 1200, 1199, 197, 396, 511, 616, 428, 427, 458, 1007, 922, 1009,
1429, 23, 289, 1191, 290, 843, 1448, 1190, 1209, 869, 684, 1471, 520, 1082, 977, 976,
1446, 19, 185, 1079, 524, 811, 522, 43, 1217, 588, 283, 1357, 189, 1354, 1150, 1030, 257,
1475, 1048, 1411, 1435, 781, 949, 948, 1385, 789, 1253, 790, 659, 522, 811, 554, 553,
871, 575, 872, 524, 345, 344, 721, 1364, 1467, 1328, 347, 1167, 1053, 832, 1181, 1278,
165, 370, 369, 1363, 1113, 1424, 722, 596, 36, 527, 1383, 713, 695, 1473, 1140, 252, 283,
253, 1421, 734, 1476, 302, 762, 593, 848, 122, 121, 134, 1238, 387, 150, 1195, 151, 33,
251, 974, 18, 769, 19, 198, 606, 222, 1327, 997, 1477, 1278, 382, 832, 299, 541, 522,
1282, 1408, 521, 1042, 1293, 397, 322, 846, 323, 735, 543, 1478, 1021, 320, 1396, 822,
200, 179, 771, 414, 170, 1352, 1307, 906, 122, 907, 1306, 429, 985, 986, 1131, 241, 1145,
1422, 1450, 1470, 565, 868, 867, 306, 132, 260, 1181, 834, 772, 133, 827, 826, 1449,
1422, 1141, 1028, 1425, 812, 317, 1192, 597, 1115, 1148, 1479, 853, 550, 549, 463, 960,
461, 391, 390, 1069, 1470, 1341, 1473, 1375, 774, 1267, 442, 306, 443, 614, 535, 1439,
1359, 783, 785, 477, 225, 275, 1370, 847, 811, 596, 598, 36, 1318, 1317, 1442, 720, 1325,
766, 374, 351, 350, 580, 1401, 512, 545, 523, 541, 426, 291, 293, 739, 328, 740, 599, 924,
1015, 511, 510, 1457, 890, 1431, 767, 81, 83, 505, 1457, 1262, 197, 574, 735, 389, 954,
936, 953, 700, 38, 1386, 490, 549, 491, 668, 667, 622, 988, 1166, 784, 1406, 103, 235,
503, 1168, 285, 68, 538, 279, 58, 695, 1003, 237, 776, 1393, 633, 1078, 908, 919, 1109,
1083, 602, 934, 502, 211, 1207, 1132, 745, 1478, 1144, 1459, 1054, 1129, 712, 527, 713,
1465, 1476, 734, 833, 381, 181, 1152, 1399, 1333, 1300, 861, 417, 628, 730, 627, 959,
886, 461, 1429, 1438, 23, 1274, 1013, 691, 1095, 826, 1004, 777, 955, 164, 227, 660, 226,
255, 1376, 256, 928, 1171, 929, 1163, 222, 1480, 1407, 1044, 52, 108, 1220, 802, 1168,
503, 1162, 765, 1373, 446, 456, 457, 1302, 314, 870, 132, 1287, 782, 1288, 51, 118, 1407,
1203, 60, 806, 769, 547, 546, 103, 498, 104, 858, 857, 996, 741, 702, 600, 649, 484, 483,
729, 128, 534, 1424, 1226, 1481, 657, 1118, 1460, 937, 936, 1458, 203, 1286, 973, 1088,
255, 1227, 893, 86, 894, 285, 287, 504, 7, 691, 690, 640, 305, 225, 727, 507, 506, 551,
1194, 191, 500, 1362, 38, 925, 1247, 201, 1335, 1232, 747, 433, 159, 1302, 1222, 290,
1191, 283, 1420, 1206, 1482, 992, 1308, 563, 161, 564, 1037, 1150, 1354, 771, 170, 1384,
317, 710, 1016, 186, 957, 187, 1467, 927, 1328, 1046, 464, 687, 1050, 824, 1027, 440,
439, 1002, 648, 649, 176, 652, 465, 1053, 857, 887, 591, 587, 160, 1087, 1196, 240, 239,
144, 146, 1074, 1237, 1348, 411, 1307, 1395, 1149, 517, 519, 1313, 498, 1406, 420, 45,
1234, 778, 583, 1078, 795, 570, 989, 1072, 385, 1180, 207, 222, 606, 605, 903, 478, 261,
1443, 485, 945, 559, 967, 962, 398, 1219, 399, 22, 1009, 23, 1409, 1415, 1414, 1058, 418,
616, 435, 487, 646, 841, 1064, 1147, 1294, 394, 312, 832, 381, 833, 403, 54, 1452, 987,
783, 1359, 942, 1012, 274, 1389, 1289, 1288, 899, 871, 1483, 378, 377, 26, 129, 509, 400,
652, 1418, 650, 790, 1011, 1179, 1155, 1154, 794, 1246, 1347, 1135, 1478, 745, 288, 451,
148, 369, 1223, 1394, 331, 1246, 1388, 1346, 686, 1345, 1285, 1277, 1124, 1278, 72, 740,
332, 888, 591, 887, 1284, 688, 733, 1386, 1363, 1484, 1257, 1366, 1333, 889, 1317, 908,
1485, 539, 154, 267, 1464, 294, 806, 60, 804, 713, 1383, 1272, 552, 545, 723, 226, 660,
155, 271, 1265, 1264, 564, 146, 414, 378, 1403, 885, 1036, 1143, 1037, 291, 653, 1239,
1376, 1088, 612, 1475, 257, 256, 185, 184, 810, 98, 457, 96, 528, 1416, 529, 231, 230,
1154, 1114, 1351, 1330, 150, 376, 252, 849, 666, 850, 1380, 1186, 415, 957, 186, 111, 25,
1404, 1403, 528, 481, 1416, 1025, 859, 641, 927, 1360, 998, 136, 422, 1447, 405, 392,
391, 1056, 1188, 1054, 1326, 977, 1292, 965, 1227, 255, 521, 1408, 913, 54, 1313, 1312,
1348, 1368, 327, 177, 179, 269, 774, 1100, 1267, 1350, 239, 879, 1130, 829, 677, 935,
934, 602, 431, 10, 9, 750, 1344, 803, 912, 548, 907, 1205, 706, 126, 1430, 236, 238, 154,
540, 865, 605, 607, 1405, 730, 527, 627, 1249, 1116, 671, 1472, 1473, 1341, 1419, 215,
488, 1433, 1354, 1355, 781, 930, 1411, 438, 194, 1123, 1311, 1272, 1400, 577, 1081, 578,
782, 1287, 813, 620, 622, 1434, 622, 520, 1434, 964, 1028, 1273, 1472, 1340, 692, 708,
541, 301, 1411, 1231, 1435, 880, 1471, 835, 1394, 1222, 1191, 131, 799, 132, 1334, 1333,
926, 1075, 1184, 629, 276, 401, 265, 1321, 1055, 1116, 1262, 1263, 606, 1370, 811, 184,
363, 811, 847, 1351, 1114, 1479, 1155, 794, 1372, 1128, 88, 458, 1196, 73, 72, 264, 263,
413, 59, 1003, 1140, 763, 1069, 939, 724, 330, 104, 754, 163, 162, 825, 1211, 823, 298,
297, 1366, 406, 1106, 1105, 141, 1235, 254, 939, 864, 763, 880, 881, 1378, 1097, 337,
1349, 999, 1248, 1477, 1318, 1442, 1256, 504, 287, 502, 1120, 621, 83, 1370, 184, 183,
855, 176, 17, 321, 125, 127, 648, 561, 484, 1237, 1086, 1348, 1228, 472, 927, 178, 822,
179, 369, 148, 166, 124, 1094, 123, 473, 475, 905, 968, 558, 1252, 1402, 1486, 1329, 116,
759, 758, 196, 1178, 793, 115, 279, 1065, 1382, 1050, 1487, 931, 1251, 1488, 1305, 1208,
624, 1401, 580, 22, 727, 673, 507, 395, 1469, 1206, 416, 91, 90, 1176, 1040, 1014, 1198,
1032, 707, 1482, 1308, 1079, 1044, 167, 1045, 972, 1489, 1248, 999, 1361, 1247, 785,
959, 1359, 233, 235, 637, 1456, 318, 317, 126, 706, 127, 1397, 77, 1486, 210, 209, 891,
1135, 1347, 1391, 249, 251, 542, 1100, 1099, 778, 1072, 107, 568, 227, 958, 1039, 1389,
1231, 1230, 589, 1083, 1109, 807, 335, 334, 1387, 756, 1192, 755, 1174, 597, 724, 104,
343, 228, 1374, 1444, 66, 1, 0, 1276, 1449, 1141, 1451, 859, 753, 944, 1314, 613, 1490,
974, 250, 1364, 1328, 1327, 8, 7, 140, 1469, 395, 972, 1475, 1243, 1048, 1308, 991, 20,
1043, 1275, 695, 855, 854, 1006, 1224, 788, 1179, 1114, 1115, 1479, 311, 877, 312, 186,
188, 585, 242, 900, 969, 835, 1471, 1082, 553, 706, 1483, 671, 518, 1249, 550, 1423, 670,
1456, 807, 318, 1178, 1177, 1372, 618, 617, 362, 160, 587, 14, 1295, 1124, 1277, 1441,
121, 881, 1126, 1093, 517, 344, 346, 556, 125, 918, 126, 92, 91, 994, 123, 1362, 500, 795,
1154, 581, 1212, 714, 1355, 633, 908, 144, 607, 1152, 1405, 1230, 1390, 1389, 201, 1464,
202, 983, 1251, 984, 1060, 468, 1061, 1221, 963, 1319, 315, 314, 760, 376, 150, 152, 24,
1401, 22, 337, 994, 1371, 1121, 1085, 1084, 678, 992, 1190, 37, 123, 500, 1453, 1191,
1111, 990, 813, 1287, 1122, 1428, 218, 1352, 863, 631, 635, 1338, 1416, 640, 557, 638,
838, 353, 681, 182, 181, 381, 353, 354, 681, 803, 82, 750, 749, 436, 435, 1058, 212, 214,
1211, 1212, 823, 1462, 138, 1314, 1266, 452, 1013, 245, 7, 6, 676, 1394, 1453, 1245,
1135, 1065, 1399, 1151, 854, 1069, 1491, 1226, 1205, 380, 84, 1259, 711, 1040, 402, 404,
457, 393, 1420, 445, 659, 617, 299, 1153, 1318, 1256, 613, 138, 1060, 1219, 618, 362,
127, 554, 319, 900, 1199, 901, 236, 1430, 1009, 714, 1171, 928, 1075, 533, 1184, 349, 26,
347, 29, 710, 30, 1393, 776, 580, 140, 7, 690, 1202, 1030, 1198, 1270, 32, 1380, 576, 836,
577, 731, 796, 732, 304, 530, 762, 1178, 794, 793, 872, 575, 1133, 1370, 912, 122, 25,
1403, 378, 1295, 1102, 1124, 384, 890, 767, 299, 617, 619, 145, 171, 170, 241, 1131,
1017, 1340, 1472, 1341, 1433, 1200, 1354, 177, 639, 654, 997, 1328, 998, 475, 744, 1026,
864, 567, 674, 323, 846, 845, 587, 929, 1172, 1307, 631, 1395, 696, 836, 576, 871, 553,
1483, 895, 1250, 451, 439, 441, 813, 1477, 997, 999, 717, 1484, 539, 679, 163, 680, 537,
1388, 1246, 867, 746, 566, 1175, 1440, 291, 199, 222, 1164, 1033, 1382, 1463, 1045,
1139, 52, 595, 302, 593, 720, 555, 454, 183, 546, 1369, 844, 992, 1482, 1246, 1135, 1245,
1379, 979, 1404, 759, 116, 355, 1276, 1052, 1449, 1427, 705, 1248, 1103, 1098, 215,
1248, 705, 972, 569, 966, 570, 1004, 460, 1095, 370, 955, 1443, 173, 1050, 1382, 716,
1304, 1303, 422, 1190, 1447, 1347, 956, 1392, 111, 186, 208, 865, 1068, 154, 1269, 77,
1208, 8, 139, 308, 1133, 1079, 185, 34, 805, 804, 1231, 1389, 1435, 1030, 1032, 1198,
1366, 1365, 605, 120, 1307, 1149, 730, 491, 1104, 354, 266, 682, 1187, 1186, 698, 595,
303, 302, 923, 496, 924, 1119, 779, 664, 856, 1399, 854, 1095, 133, 826, 1138, 139, 1322,
137, 1261, 469, 746, 867, 289, 1067, 1419, 488, 5, 1107, 3, 1351, 73, 1196, 424, 146, 873,
1302, 10, 433, 428, 418, 149, 1359, 1346, 1388, 300, 1027, 1202, 458, 88, 87, 802, 1154,
342, 846, 322, 1337, 876, 725, 568, 802, 1220, 1436, 345, 352, 346, 1242, 851, 468, 341,
340, 1426, 900, 242, 244, 682, 88, 1128, 1093, 910, 911, 1156, 1210, 687, 1050, 1110,
1487, 1065, 1134, 1112, 674, 1068, 864, 155, 1068, 632, 1037, 1354, 1200, 537, 1245,
279, 543, 1031, 1144, 1266, 1274, 245, 705, 1469, 972, 224, 295, 273, 1194, 253, 284,
675, 1199, 586, 711, 1304, 661, 1207, 1022, 1358, 1477, 1489, 1327, 1361, 201, 1247,
438, 736, 290, 398, 1293, 1463, 1367, 917, 1409, 813, 812, 439, 74, 740, 72, 899, 1483,
706, 697, 1186, 1380, 1197, 1490, 752, 742, 1060, 1059, 774, 1375, 775, 1486, 77, 1329,
947, 1114, 1330, 238, 237, 1289, 1255, 172, 1153, 1443, 955, 1353, 1353, 286, 1443,
1280, 641, 93, 609, 1218, 1232, 704, 190, 1357, 244, 243, 669, 149, 148, 427, 256, 1286,
1475, 1248, 1489, 1477, 258, 1083, 419, 656, 280, 657, 1197, 975, 1490, 11, 796, 1432,
867, 866, 289, 1435, 782, 781, 1012, 371, 373, 1266, 245, 1264, 1308, 20, 19, 1310, 403,
10, 1386, 1484, 717, 784, 1185, 785, 613, 612, 1088, 77, 76, 1336, 1258, 298, 1257, 635,
1290, 636, 560, 31, 946, 708, 301, 1198, 385, 767, 768, 144, 908, 1317, 114, 947, 112,
1148, 410, 1479, 851, 494, 493, 1044, 1407, 718, 1382, 1033, 173, 607, 606, 1263, 913,
662, 521, 804, 62, 34, 1092, 1093, 1125, 333, 479, 1066, 1077, 874, 1137, 1397, 24, 79,
40, 1410, 770, 879, 239, 386, 693, 1126, 97, 265, 264, 276, 1445, 1300, 214, 543, 545,
708, 1111, 828, 1130, 1086, 1252, 1348, 1242, 1062, 1119, 962, 100, 1392, 732, 797, 490,
497, 922, 1007, 884, 1165, 1167, 1088, 1090, 613, 1345, 684, 1285, 379, 378, 885, 1432,
9, 11, 575, 1080, 1133, 100, 962, 961, 510, 1261, 1457, 1421, 1365, 1193, 283, 252, 1420,
933, 1010, 931, 1415, 397, 399, 949, 1385, 1203, 1015, 1014, 958, 1111, 866, 828, 226,
155, 632, 857, 1466, 1325, 68, 798, 66, 34, 831, 27, 455, 50, 49, 661, 660, 1040, 197,
1262, 606, 1028, 964, 1425, 306, 307, 443, 392, 1413, 390, 799, 131, 460, 499, 1368, 476,
1450, 1092, 1437, 993, 680, 1320, 776, 1009, 580, 975, 945, 946, 1183, 629, 1184, 101,
961, 1235, 862, 556, 683, 1327, 1489, 971, 140, 139, 8, 715, 569, 568, 417, 147, 149,
1430, 1429, 1009, 1290, 248, 636, 1088, 1417, 1089, 1068, 586, 632, 1425, 1000, 1002,
201, 1361, 1360, 1289, 1390, 1244, 878, 815, 1385, 608, 610, 1186, 1326, 1175, 977,
1422, 1449, 1450, 988, 784, 783, 858, 1301, 1474, 1447, 1448, 843, 1031, 543, 707, 567,
1036, 674, 448, 808, 852, 953, 938, 941, 711, 29, 1303, 1425, 439, 812, 756, 1387, 816,
139, 1224, 426, 853, 549, 449, 912, 1370, 548, 211, 1132, 1057, 1282, 751, 1408, 764,
1491, 1069, 1441, 1367, 121, 720, 453, 1325, 683, 691, 1013, 144, 1317, 1153, 873, 679,
424, 45, 838, 1234, 955, 370, 165, 640, 476, 557, 1320, 20, 991, 1030, 1201, 1212, 93,
320, 319, 414, 146, 145, 155, 661, 1304, 1043, 58, 1041, 956, 1346, 892, 284, 189, 191,
618, 1487, 1110, 14, 1034, 12, 1480, 222, 1365, 345, 1146, 352, 36, 598, 1020, 423, 144,
1074, 714, 1212, 1171, 1130, 677, 1453, 439, 1425, 1002, 787, 503, 502, 577, 1082, 1081,
251, 250, 974, 15, 984, 1251, 605, 1365, 222, 562, 833, 563, 747, 1262, 685, 1150, 1037,
1143, 1478, 543, 1144, 214, 418, 1058, 333, 1066, 1112, 1194, 284, 191, 1238, 388, 387,
873, 161, 163, 8, 246, 6, 1160, 1324, 478, 412, 828, 866, 108, 107, 768, 450, 368, 1180,
1096, 172, 338, 819, 421, 420, 94, 319, 554, 1306, 120, 122, 1490, 249, 752, 585, 208,
186, 1366, 1257, 298, 311, 1012, 373, 999, 998, 1361, 1213, 678, 1190, 973, 256, 1376,
1272, 730, 1104, 539, 763, 540, 1066, 313, 315, 453, 720, 454, 1492, 1412, 1454, 674,
1036, 1035, 937, 1459, 1129, 36, 1020, 37, 642, 457, 98, 297, 296, 1193, 1098, 1349, 215,
1022, 210, 463, 532, 83, 621, 817, 1324, 818, 75, 1101, 770, 716, 539, 1485, 440, 801,
1051, 643, 98, 1126, 48, 1267, 49, 105, 1117, 103, 1031, 1150, 1143, 1056, 1055, 1321,
1311, 969, 1216, 773, 664, 1099, 501, 604, 502, 5, 4, 406, 1105, 1107, 5, 141, 101, 1235,
1062, 468, 1063, 382, 381, 832, 171, 1153, 172, 903, 261, 870, 91, 1371, 994, 670, 1423,
1283, 1221, 4, 3, 806, 1332, 1331, 988, 1418, 1166, 1241, 887, 857, 1203, 1331, 112,
1179, 788, 790, 412, 868, 392, 99, 176, 649, 670, 1284, 669, 332, 329, 330, 1412, 221,
296, 1203, 806, 1331, 931, 1488, 932, 750, 1282, 1344, 231, 1315, 1029, 569, 536, 966,
1450, 1437, 1341, 519, 671, 1055, 804, 60, 62, 323, 221, 220, 925, 1427, 1247, 1008, 86,
893, 1023, 278, 277, 1434, 630, 1183, 897, 768, 895, 1412, 219, 221, 211, 1057, 209,
1262, 686, 685, 56, 1452, 54, 888, 737, 592, 766, 1466, 765, 1309, 54, 1312, 524, 552,
575, 950, 1472, 692, 276, 278, 240, 1298, 1342, 1088, 764, 539, 1484, 173, 1034, 1173,
485, 484, 561, 44, 568, 725, 840, 766, 119, 1366, 605, 1405, 235, 1117, 637, 1279, 728,
729, 922, 924, 599, 337, 1371, 1349, 1125, 1127, 1437, 913, 915, 662, 927, 998, 1328,
1364, 371, 1228, 1238, 134, 843, 1020, 1019, 124, 773, 1099, 774, 397, 1415, 1042, 960,
959, 461, 972, 971, 1489, 30, 317, 597, 1315, 231, 1316, 168, 719, 169, 1211, 1172, 1171,
1096, 1277, 172, 695, 58, 1043, 1262, 747, 1005, 176, 1005, 648, 1019, 1323, 1160, 842,
1238, 843, 1339, 634, 1231, 1277, 1181, 772, 445, 375, 394, 996, 857, 591, 704, 1206,
1469, 1379, 1225, 979, 697, 32, 648, 1182, 620, 1183, 1459, 434, 1054, 1224, 138, 1461,
481, 80, 1290, 835, 837, 881, 105, 104, 328, 1375, 1283, 775, 696, 695, 1275, 1481, 1363,
1424, 682, 1128, 995, 1372, 331, 1316, 1415, 917, 1275, 970, 1294, 971, 695, 1140, 1003,
1333, 1366, 1152, 810, 184, 811, 990, 1287, 1289, 980, 1225, 830, 1363, 1481, 1484,
1102, 1098, 1103, 1470, 578, 1422, 1020, 598, 1018, 1170, 1338, 635, 657, 1460, 658,
343, 104, 498, 216, 215, 1349, 841, 1119, 1062, 360, 1227, 965, 1214, 1092, 1450, 1132,
193, 1017, 1397, 623, 1208, 602, 466, 270, 157, 383, 207, 204, 203, 940, 1491, 764, 1481,
1154, 802, 581, 213, 212, 367, 956, 559, 1392, 877, 971, 1294, 516, 27, 349, 716, 1485,
153, 1368, 1252, 476, 753, 162, 918, 362, 1414, 399, 204, 1188, 205, 761, 780, 762, 1338,
529, 1416, 644, 323, 1465, 1471, 880, 1434, 1301, 858, 590, 965, 255, 257, 851, 493,
1061, 1465, 323, 845, 1464, 927, 294, 1092, 1125, 1437, 1000, 1249, 1001, 483, 1291,
1158, 1105, 5, 406, 963, 1235, 961, 650, 1115, 947, 55, 434, 936, 1284, 1283, 1267, 474,
1320, 743, 906, 1306, 907, 372, 371, 1364, 248, 80, 79, 4, 1319, 968, 1439, 535, 534,
1233, 1335, 749, 1162, 483, 485, 655, 663, 689, 1457, 1261, 1260, 1107, 1226, 1424,
1403, 886, 885, 482, 663, 915, 1374, 228, 353, 1330, 1351, 1350, 1334, 1010, 1257, 656,
1156, 687, 633, 422, 136, 936, 797, 56, 332, 740, 329, 98, 643, 642, 502, 604, 603, 416,
217, 216, 872, 1133, 185, 1188, 1129, 1054, 679, 1215, 424, 1432, 731, 9, 158, 361, 1255,
758, 799, 798, 636, 1429, 634, 497, 923, 922, 192, 60, 1203, 358, 1479, 410, 1472, 950,
1140, 1038, 570, 966, 1153, 1256, 1255, 470, 1401, 1329, 107, 451, 1250, 400, 509, 167,
1142, 1305, 624, 1404, 25, 1379, 936, 938, 953, 434, 54, 1309, 123, 64, 1362, 1094, 124,
1019, 392, 565, 1413, 981, 1022, 463, 677, 829, 401, 1279, 534, 589, 1001, 800, 1002,
1229, 942, 472, 1110, 1050, 1027, 1410, 1260, 137, 755, 757, 1174, 56, 11, 1452, 1426,
875, 106, 97, 1126, 98, 1272, 1271, 1400, 321, 1021, 918, 772, 771, 1384, 611, 741, 973,
534, 1085, 1439, 1473, 578, 1470, 1260, 686, 1457, 1491, 1481, 1226, 609, 647, 978, 619,
300, 299, 614, 616, 989, 966, 989, 1038, 567, 1381, 1036, 1008, 658, 1460, 495, 429, 169,
1086, 1237, 4, 931, 1010, 1334, 421, 259, 258, 1137, 874, 0, 1402, 24, 1397, 1438, 1429,
636, 929, 587, 1087, 1389, 1288, 1435, 56, 796, 11, 1482, 1079, 844, 121, 1149, 1378,
432, 160, 159, 880, 1378, 1434, 590, 996, 591, 1042, 1275, 1043, 265, 401, 829, 1184,
533, 1182, 592, 861, 590, 405, 1237, 411, 1041, 58, 57, 597, 1174, 598, 1273, 965, 964,
975, 974, 1490, 571, 658, 1008, 421, 819, 117, 1085, 128, 130, 1165, 1185, 784, 358, 73,
1351, 1046, 281, 464, 1048, 964, 257, 1202, 1027, 1201, 84, 706, 1205, 951, 692, 96, 443,
816, 444, 959, 1185, 886, 62, 1073, 981, 1356, 907, 548, 586, 1068, 674, 746, 745, 1381,
551, 1195, 1194, 1421, 1480, 1365, 274, 694, 326, 1407, 52, 51, 315, 760, 759, 560, 945,
485, 587, 1173, 14, 312, 877, 1294, 358, 1351, 1479, 191, 190, 263, 701, 28, 722, 385,
896, 1180, 128, 729, 508, 1265, 271, 452, 82, 507, 672, 1066, 1065, 1112, 1473, 695, 578,
938, 1129, 941, 519, 1055, 1312, 1307, 1352, 631, 294, 223, 267, 812, 814, 359, 543, 735,
544, 1490, 250, 249, 852, 1423, 853, 1467, 1364, 1228, 552, 723, 574, 25, 378, 26, 614,
1439, 1121, 1377, 1211, 825, 694, 1012, 311, 358, 1077, 73, 1347, 1392, 1391, 813, 791,
782, 809, 386, 1017, 447, 449, 953, 309, 1493, 246, 960, 463, 891, 703, 1427, 821, 90,
251, 1270, 1345, 1260, 1410, 203, 205, 1286, 84, 898, 706, 721, 839, 345, 1323, 1019,
1018, 1256, 1442, 921, 205, 1188, 1189, 1210, 437, 869, 393, 1206, 1420, 1393, 580, 579,
1167, 347, 379, 83, 532, 505, 213, 367, 366, 1485, 154, 153, 1442, 890, 921, 415, 1186,
610, 90, 1270, 1380, 1233, 647, 609, 300, 1202, 1198, 930, 761, 530, 796, 56, 797, 1397,
79, 623, 4, 1221, 1319, 579, 514, 1393, 947, 1330, 948, 1243, 1475, 1286, 348, 347, 465,
764, 1484, 1481, 643, 1126, 517, 16, 1399, 856, 17, 16, 855, 654, 277, 264, 1443, 286,
485, 1151, 1399, 1152, 1438, 248, 23, 568, 44, 43, 988, 1148, 1418, 342, 1154, 230, 1199,
900, 244, 593, 762, 780, 271, 453, 452, 173, 1173, 587, 336, 71, 70, 607, 1263, 1151,
1332, 805, 516, 346, 351, 690, 1373, 765, 858, 1378, 1395, 630, 436, 749, 748, 526, 432,
628, 637, 1137, 0, 920, 52, 1139, 457, 404, 1310, 1109, 1279, 589, 975, 1197, 370, 507,
82, 81, 878, 1385, 1330, 200, 821, 925, 840, 46, 779, 1146, 1064, 350, 814, 1337, 359,
1039, 660, 227, 390, 1413, 1069, 393, 395, 1206, 123, 65, 64, 1394, 332, 331, 749, 647,
1233, 160, 14, 13, 1313, 643, 517, 422, 424, 1190, 1136, 74, 1077, 357, 1077, 358, 160,
526, 1087, 1008, 893, 571, 1409, 1414, 364, 1464, 201, 1360, 688, 1267, 48, 122, 847,
1370, 1006, 176, 855, 618, 1219, 1487, 1457, 197, 511, 1355, 714, 1433, 1121, 1084, 130,
340, 230, 232, 817, 307, 1324, 896, 385, 897, 457, 642, 402, 497, 496, 923, 873, 163, 679,
416, 216, 1371, 673, 672, 507, 151, 411, 152, 142, 1159, 480, 1127, 692, 1340, 1468, 904,
579, 876, 875, 725, 305, 639, 268, 26, 349, 27, 697, 698, 1186, 139, 426, 1322, 1136, 739,
74, 1092, 1214, 801, 861, 229, 147, 658, 1156, 656, 1478, 288, 735, 152, 1348, 327, 639,
305, 640, 1269, 1305, 1268, 1394, 1191, 1453, 1431, 890, 582, 1033, 1463, 1293, 735,
574, 544, 875, 340, 725, 665, 664, 773, 357, 538, 67, 1112, 1134, 102, 995, 1128, 455,
547, 18, 473, 1167, 379, 885, 1436, 1431, 582, 881, 837, 1441, 947, 651, 650, 1486, 1402,
1397, 777, 501, 287, 655, 689, 304, 839, 720, 766, 382, 84, 380, 1179, 1236, 653, 1219,
1382, 1487, 298, 1412, 296, 317, 1299, 1456, 863, 1352, 905, 266, 366, 365, 1127, 693,
692, 1336, 471, 1329, 330, 1029, 1315, 52, 920, 53, 578, 594, 1422, 798, 1204, 66, 1303,
29, 701, 1115, 650, 1148

};

static TqFloat S01[] = {
0.070072, 0.046770, 0.047149, 0.223627, 0.258578,
0.236612, 0.243784, 0.200403, 0.269790, 0.579020, 0.635643, 0.602835, 0.717894,
0.709040, 0.677325, 0.399910, 0.425322, 0.407807, 0.675481, 0.627239, 0.630887,
0.047149, 0.046770, 0.037081, 0.895348, 0.933134, 0.925669, 0.131028, 0.165961,
0.186252, 0.146386, 0.166252, 0.124605, 0.318888, 0.328466, 0.350250, 0.212486,
0.186252, 0.217262, 0.136867, 0.123429, 0.163743, 0.787269, 0.810967, 0.784090,
0.079125, 0.115560, 0.126198, 0.301835, 0.310165, 0.290183, 0.355487, 0.344431,
0.318048, 0.039041, 0.038875, 0.031085, 0.622487, 0.593071, 0.580476, 0.734798,
0.787012, 0.762123, 0.207750, 0.201739, 0.189490, 0.188317, 0.164119, 0.157371,
0.054848, 0.075334, 0.055574, 0.348680, 0.385766, 0.384540, 0.191716, 0.167723,
0.153376, 0.838767, 0.822873, 0.873121, 0.973942, 0.956981, 0.990335, 0.817982,
0.829821, 0.836814, 0.605560, 0.547992, 0.549551, 0.201414, 0.226720, 0.157179,
0.424410, 0.432501, 0.408120, 0.768253, 0.744545, 0.776137, 0.742528, 0.730216,
0.691897, 0.399910, 0.407807, 0.376769, 0.131648, 0.112623, 0.087822, 0.083801,
0.134281, 0.117727, 0.188698, 0.183858, 0.210230, 0.339815, 0.299901, 0.317052,
0.182277, 0.177336, 0.160701, 0.055574, 0.033510, 0.038466, 0.054990, 0.054383,
0.039041, 0.310165, 0.282815, 0.290183, 0.821680, 0.822470, 0.784791, 0.117953,
0.123429, 0.103917, 0.672592, 0.661429, 0.685836, 0.053028, 0.083003, 0.082574,
0.008620, 0.031488, 0.000000, 0.432933, 0.392283, 0.388851, 0.822873, 0.838767,
0.794432, 0.354587, 0.314085, 0.226094, 0.122131, 0.099029, 0.096651, 0.423587,
0.419947, 0.454052, 0.231228, 0.247062, 0.216210, 0.338602, 0.293548, 0.309703,
0.247558, 0.271928, 0.256877, 0.381688, 0.361595, 0.381643, 0.667833, 0.654580,
0.709040, 0.535876, 0.595833, 0.576543, 0.243294, 0.265296, 0.256844, 0.062742,
0.093822, 0.107522, 0.425550, 0.399199, 0.407965, 0.687951, 0.631309, 0.647505,
0.376769, 0.407807, 0.396954, 0.300565, 0.372928, 0.382792, 0.588698, 0.588527,
0.628356, 0.668522, 0.698308, 0.647894, 0.319522, 0.292679, 0.307004, 0.402637,
0.401938, 0.323338, 0.201739, 0.209497, 0.213945, 0.382873, 0.354622, 0.350924,
0.712992, 0.658307, 0.676406, 0.438617, 0.467914, 0.397090, 0.523950, 0.523022,
0.602318, 0.330446, 0.348680, 0.330398, 0.339815, 0.317052, 0.347555, 0.157591,
0.152728, 0.171521, 0.123427, 0.147607, 0.171066, 0.506819, 0.483991, 0.472974,
0.106621, 0.082574, 0.083003, 0.627850, 0.656974, 0.657182, 0.658307, 0.639236,
0.676406, 0.336311, 0.316622, 0.289118, 0.280367, 0.307004, 0.272921, 0.171066,
0.147607, 0.180424, 0.247062, 0.231228, 0.242958, 0.204084, 0.215001, 0.173742,
0.017281, 0.014647, 0.029919, 0.862535, 0.810081, 0.861269, 0.201833, 0.212701,
0.207821, 0.407374, 0.394474, 0.384427, 0.218377, 0.261500, 0.258466, 0.956981,
0.925669, 0.968534, 0.397164, 0.374238, 0.396979, 0.394999, 0.384555, 0.338602,
0.122131, 0.131769, 0.099029, 0.627634, 0.610088, 0.658621, 0.040285, 0.039531,
0.031085, 0.028737, 0.031488, 0.034118, 0.709040, 0.717894, 0.726543, 0.281120,
0.266232, 0.255732, 0.226720, 0.181556, 0.157179, 0.389262, 0.327534, 0.326214,
0.185508, 0.232928, 0.177154, 0.375723, 0.405147, 0.307583, 0.226536, 0.244939,
0.219418, 0.056584, 0.033510, 0.055574, 0.691614, 0.745091, 0.746884, 0.460231,
0.390538, 0.384555, 0.215637, 0.270964, 0.180994, 0.375954, 0.316159, 0.368293,
0.389980, 0.377562, 0.375802, 0.336311, 0.400444, 0.376066, 0.605737, 0.583936,
0.539959, 0.633641, 0.622256, 0.564025, 0.903931, 0.906539, 0.913484, 0.327534,
0.336311, 0.271980, 0.018270, 0.028737, 0.013992, 0.268101, 0.268318, 0.269790,
0.394988, 0.466539, 0.435301, 0.024828, 0.039066, 0.021532, 0.055683, 0.111550,
0.032299, 0.731678, 0.734006, 0.702787, 0.730430, 0.689192, 0.661089, 0.341395,
0.366888, 0.314572, 0.150604, 0.134281, 0.181400, 0.185348, 0.230603, 0.223757,
0.350924, 0.392283, 0.382873, 0.112623, 0.060639, 0.087822, 0.014647, 0.019200,
0.048564, 0.385766, 0.397164, 0.400051, 0.442058, 0.416887, 0.416781, 0.183008,
0.221511, 0.228206, 0.126198, 0.108088, 0.079125, 0.228841, 0.244180, 0.213668,
0.155026, 0.162903, 0.180368, 0.264950, 0.229031, 0.240753, 0.259620, 0.180424,
0.212496, 0.033510, 0.021595, 0.038466, 0.116100, 0.096522, 0.136332, 0.765260,
0.730430, 0.748268, 0.401308, 0.416781, 0.416887, 0.722228, 0.695834, 0.751134,
0.122213, 0.173032, 0.140734, 0.297418, 0.258570, 0.287031, 0.492002, 0.517767,
0.493488, 0.258721, 0.226094, 0.229031, 0.314572, 0.343245, 0.330137, 0.151640,
0.139182, 0.135535, 0.609302, 0.594847, 0.570846, 0.330403, 0.310944, 0.306406,
0.205273, 0.201833, 0.207821, 0.426686, 0.460972, 0.450603, 0.290392, 0.270711,
0.291244, 0.339815, 0.355487, 0.318048, 0.422883, 0.402505, 0.517873, 0.709277,
0.712992, 0.676406, 0.039041, 0.039531, 0.054990, 0.774570, 0.744665, 0.755606,
0.107522, 0.072419, 0.062742, 0.226536, 0.212701, 0.241931, 0.653284, 0.628765,
0.657892, 0.271671, 0.270711, 0.261686, 0.294813, 0.273441, 0.307899, 0.116100,
0.136332, 0.120580, 0.284215, 0.291245, 0.291244, 0.300565, 0.304927, 0.372928,
0.439240, 0.419947, 0.425550, 0.424410, 0.406059, 0.449155, 0.240753, 0.229031,
0.213668, 0.171066, 0.226522, 0.158722, 0.056970, 0.067910, 0.051793, 0.435369,
0.436416, 0.496807, 0.375802, 0.362396, 0.388320, 0.216210, 0.185453, 0.157356,
0.152224, 0.157179, 0.135716, 0.616173, 0.618134, 0.649638, 0.597492, 0.593071,
0.622487, 0.583854, 0.692164, 0.631650, 0.354622, 0.382873, 0.369412, 0.802061,
0.787784, 0.828907, 0.014463, 0.008619, 0.013066, 0.394999, 0.330137, 0.368636,
0.290183, 0.282815, 0.270878, 0.496104, 0.455370, 0.481583, 0.258570, 0.277571,
0.200811, 0.191547, 0.222270, 0.202377, 0.307899, 0.307306, 0.294813, 0.628765,
0.653284, 0.622487, 0.715630, 0.742528, 0.685996, 0.273441, 0.250772, 0.263373,
0.022560, 0.037081, 0.046770, 0.108113, 0.133348, 0.142736, 0.745091, 0.691614,
0.695035, 0.151126, 0.160701, 0.162903, 0.176088, 0.232928, 0.185508, 0.354587,
0.297636, 0.356223, 0.766941, 0.772310, 0.816244, 0.376066, 0.400444, 0.437638,
0.735735, 0.696130, 0.732388, 0.238701, 0.252910, 0.307583, 0.044084, 0.060317,
0.065628, 0.990335, 0.988882, 0.977413, 0.322360, 0.317865, 0.297210, 0.517851,
0.565892, 0.532699, 0.513477, 0.507240, 0.488834, 0.459163, 0.435492, 0.431797,
0.096651, 0.060639, 0.112623, 0.146325, 0.175518, 0.191659, 0.067910, 0.108088,
0.085860, 0.341395, 0.314572, 0.297858, 0.136291, 0.163743, 0.123429, 0.184829,
0.147816, 0.180994, 0.147816, 0.166217, 0.169850, 0.814712, 0.790092, 0.799406,
0.053028, 0.053344, 0.065756, 0.744093, 0.731895, 0.795950, 0.729413, 0.764950,
0.742422, 0.177336, 0.200478, 0.180368, 0.718103, 0.707568, 0.679958, 0.906539,
0.903339, 0.903600, 0.630140, 0.557470, 0.613554, 0.583264, 0.604078, 0.547905,
0.986422, 0.980041, 0.951570, 0.801266, 0.832712, 0.801533, 0.314572, 0.330137,
0.309703, 0.055307, 0.082401, 0.087683, 0.086182, 0.056584, 0.073843, 0.247749,
0.290068, 0.271928, 0.073843, 0.055574, 0.075334, 0.578529, 0.557470, 0.630140,
0.408120, 0.400051, 0.415288, 0.449728, 0.439043, 0.508709, 0.681575, 0.708542,
0.745096, 0.291244, 0.271671, 0.284215, 0.485480, 0.449947, 0.488834, 0.281120,
0.291604, 0.323338, 0.508709, 0.543470, 0.557470, 0.694624, 0.725852, 0.685836,
0.211715, 0.228841, 0.204899, 0.215176, 0.234882, 0.175795, 0.311923, 0.297210,
0.313560, 0.512288, 0.521247, 0.471167, 0.328377, 0.340809, 0.327978, 0.128893,
0.105348, 0.136288, 0.581821, 0.585889, 0.624043, 0.508197, 0.565763, 0.543470,
0.861663, 0.886968, 0.853521, 0.795950, 0.766543, 0.827275, 0.267659, 0.295210,
0.318394, 0.351456, 0.325361, 0.350647, 0.631309, 0.687951, 0.638263, 0.087683,
0.082868, 0.063041, 0.055307, 0.087683, 0.063041, 0.251030, 0.246565, 0.240943,
0.886139, 0.892331, 0.902666, 0.129375, 0.106780, 0.105162, 0.263604, 0.299901,
0.263373, 0.523950, 0.468944, 0.481119, 0.144488, 0.141807, 0.157428, 0.619235,
0.676168, 0.648521, 0.391130, 0.452405, 0.411320, 0.477339, 0.502852, 0.434562,
0.122636, 0.111131, 0.134102, 0.679549, 0.700462, 0.663953, 0.870155, 0.857281,
0.883802, 0.945245, 0.973942, 0.954192, 0.048564, 0.076638, 0.054383, 0.481119,
0.468944, 0.455195, 0.549125, 0.604078, 0.570229, 0.831131, 0.868757, 0.834972,
0.039041, 0.031085, 0.039531, 0.310304, 0.350647, 0.325361, 0.436416, 0.435369,
0.391402, 0.978126, 0.995037, 0.980341, 0.050200, 0.047149, 0.037081, 0.210919,
0.243194, 0.223601, 0.726055, 0.734006, 0.768253, 0.653284, 0.678326, 0.710296,
0.252910, 0.223601, 0.289118, 0.680644, 0.605737, 0.657182, 0.400051, 0.408120,
0.397616, 0.696130, 0.735735, 0.675481, 0.438617, 0.397090, 0.382792, 0.583854,
0.517645, 0.532548, 0.321807, 0.317865, 0.348984, 0.130673, 0.147580, 0.147495,
0.388320, 0.415955, 0.389980, 0.244939, 0.280962, 0.243194, 0.906539, 0.912957,
0.913484, 0.659510, 0.645059, 0.636057, 0.659045, 0.695834, 0.679549, 0.099029,
0.131769, 0.117953, 0.254020, 0.214415, 0.256877, 0.702787, 0.685836, 0.731678,
0.912957, 0.908009, 0.959850, 0.361724, 0.415166, 0.401073, 0.896168, 0.883655,
0.903600, 0.377079, 0.394474, 0.415336, 0.707568, 0.680487, 0.679958, 0.986422,
0.959850, 0.988882, 0.811719, 0.796329, 0.810967, 0.350647, 0.353241, 0.376408,
0.218457, 0.235484, 0.191716, 0.542113, 0.554974, 0.596034, 0.276850, 0.212496,
0.244043, 0.180936, 0.204899, 0.213668, 0.733132, 0.696166, 0.717621, 0.682955,
0.695035, 0.659510, 0.347555, 0.365777, 0.339815, 0.986422, 0.951570, 0.953828,
0.180936, 0.198222, 0.183331, 0.782083, 0.769420, 0.742528, 0.410063, 0.466539,
0.394988, 0.831866, 0.854284, 0.861663, 0.329567, 0.321807, 0.338818, 0.181556,
0.122213, 0.157179, 0.172681, 0.191398, 0.177801, 0.434064, 0.455195, 0.468944,
0.469528, 0.491365, 0.522223, 0.694624, 0.685836, 0.657824, 0.489104, 0.449728,
0.525618, 0.141609, 0.136152, 0.189917, 0.518498, 0.483307, 0.495362, 0.099509,
0.128893, 0.115560, 0.213953, 0.214694, 0.247749, 0.146325, 0.191659, 0.152224,
0.093822, 0.084794, 0.117867, 0.211715, 0.257399, 0.257395, 0.129375, 0.157319,
0.146386, 0.439043, 0.508197, 0.482229, 0.137033, 0.157518, 0.183008, 0.746884,
0.772101, 0.765671, 0.032073, 0.053344, 0.050739, 0.243294, 0.256844, 0.242958,
0.511180, 0.557669, 0.546101, 0.365777, 0.347555, 0.364935, 0.636094, 0.605737,
0.680644, 0.243194, 0.326214, 0.327534, 0.415673, 0.410779, 0.450603, 0.230891,
0.170885, 0.184829, 0.153376, 0.117877, 0.161091, 0.434064, 0.463312, 0.429074,
0.646821, 0.694974, 0.696130, 0.375954, 0.389639, 0.335536, 0.650959, 0.677194,
0.630696, 0.853543, 0.838767, 0.855508, 0.397164, 0.385766, 0.352412, 0.604078,
0.654580, 0.618134, 0.209497, 0.201739, 0.207750, 0.641742, 0.636998, 0.595833,
0.658307, 0.712992, 0.676168, 0.064079, 0.038223, 0.055904, 0.252910, 0.238701,
0.223601, 0.028898, 0.017326, 0.024042, 0.929159, 0.906711, 0.951570, 0.290366,
0.247749, 0.242070, 0.272284, 0.282815, 0.271545, 0.248804, 0.210230, 0.249449,
0.681575, 0.668522, 0.655092, 0.838767, 0.814136, 0.794432, 0.450487, 0.475048,
0.471167, 0.313560, 0.321807, 0.328466, 0.389987, 0.374762, 0.413255, 0.810081,
0.862535, 0.835893, 0.238461, 0.243294, 0.230891, 0.310165, 0.331559, 0.332633,
0.893999, 0.915210, 0.857797, 0.115385, 0.111577, 0.107887, 0.177855, 0.166217,
0.154451, 0.111550, 0.124605, 0.136152, 0.762123, 0.717894, 0.734798, 0.404884,
0.421147, 0.425355, 0.857797, 0.840159, 0.866511, 0.367428, 0.313711, 0.318316,
0.563112, 0.532285, 0.546101, 0.034878, 0.023890, 0.022560, 0.765326, 0.783132,
0.787784, 0.221511, 0.210230, 0.245694, 0.855510, 0.836814, 0.829821, 0.208976,
0.218529, 0.210428, 0.014463, 0.013066, 0.027411, 0.429664, 0.389987, 0.413255,
0.209497, 0.214728, 0.213945, 0.613554, 0.653134, 0.679118, 0.780386, 0.822984,
0.788676, 0.214728, 0.209497, 0.205198, 0.014245, 0.014918, 0.029590, 0.014647,
0.059520, 0.029919, 0.384540, 0.400051, 0.397616, 0.144488, 0.147816, 0.141807,
0.152224, 0.201414, 0.157179, 0.226720, 0.244043, 0.181556, 0.382565, 0.465917,
0.415250, 0.134281, 0.185348, 0.181400, 0.596259, 0.640364, 0.614104, 0.014647,
0.002168, 0.004520, 0.286034, 0.255732, 0.267529, 0.212486, 0.195485, 0.171652,
0.532285, 0.549822, 0.514925, 0.886152, 0.872626, 0.860374, 0.301835, 0.290183,
0.280870, 0.279763, 0.296681, 0.325235, 0.014647, 0.054990, 0.059520, 0.495418,
0.489643, 0.525423, 0.720886, 0.742919, 0.764950, 0.738234, 0.783585, 0.751134,
0.375673, 0.402212, 0.383648, 0.455370, 0.427948, 0.465560, 0.617808, 0.465692,
0.463535, 0.285285, 0.289531, 0.272284, 0.636998, 0.641742, 0.690025, 0.689192,
0.665429, 0.661089, 0.243232, 0.240943, 0.242958, 0.211715, 0.194113, 0.202377,
0.834972, 0.787728, 0.831131, 0.290366, 0.312554, 0.294665, 0.295416, 0.322510,
0.304359, 0.733132, 0.690471, 0.692164, 0.033398, 0.034118, 0.031488, 0.784791,
0.783585, 0.738234, 0.471167, 0.475048, 0.512288, 0.744545, 0.725852, 0.698480,
0.647894, 0.653134, 0.608505, 0.517378, 0.454052, 0.471167, 0.180936, 0.202377,
0.194113, 0.054848, 0.088239, 0.075334, 0.169461, 0.158277, 0.188698, 0.485147,
0.466539, 0.493488, 0.261500, 0.218377, 0.243784, 0.205938, 0.196781, 0.205273,
0.290366, 0.294665, 0.290068, 0.243232, 0.231228, 0.226522, 0.891044, 0.886152,
0.870495, 0.269478, 0.282099, 0.258466, 0.690025, 0.646821, 0.596034, 0.101651,
0.103138, 0.098519, 0.234054, 0.176088, 0.229467, 0.082868, 0.105348, 0.099509,
0.320496, 0.295210, 0.308759, 0.297636, 0.226094, 0.258721, 0.270878, 0.280870,
0.290183, 0.141556, 0.157591, 0.139910, 0.573387, 0.544108, 0.581821, 0.744545,
0.765671, 0.776137, 0.254854, 0.288309, 0.285757, 0.657824, 0.604023, 0.647434,
0.306406, 0.249449, 0.285757, 0.415440, 0.430319, 0.447996, 0.043543, 0.060317,
0.044084, 0.751408, 0.764950, 0.766543, 0.768233, 0.790337, 0.771874, 0.147580,
0.160701, 0.151126, 0.320496, 0.344388, 0.318394, 0.565763, 0.508197, 0.513199,
0.762866, 0.765326, 0.739370, 0.183008, 0.228206, 0.204084, 0.784791, 0.754595,
0.771874, 0.892481, 0.927581, 0.955312, 0.738117, 0.731895, 0.709277, 0.854284,
0.820921, 0.860374, 0.648611, 0.595833, 0.588698, 0.032073, 0.041064, 0.034321,
0.310944, 0.330403, 0.347539, 0.239044, 0.214184, 0.214731, 0.488570, 0.467914,
0.438617, 0.399910, 0.508507, 0.425322, 0.437638, 0.400444, 0.456695, 0.583264,
0.517353, 0.577673, 0.929159, 0.958511, 0.915210, 0.406304, 0.400652, 0.429428,
0.532699, 0.506819, 0.517851, 0.154451, 0.140539, 0.158739, 0.555168, 0.559030,
0.524684, 0.328377, 0.327978, 0.318593, 0.502813, 0.496104, 0.529819, 0.198222,
0.229031, 0.226094, 0.117953, 0.131769, 0.157371, 0.136867, 0.172681, 0.157319,
0.375723, 0.450517, 0.405147, 0.402505, 0.394988, 0.435301, 0.488469, 0.456496,
0.434562, 0.304538, 0.311923, 0.331838, 0.149297, 0.171919, 0.180233, 0.763925,
0.747156, 0.756903, 0.389262, 0.326214, 0.382792, 0.411320, 0.472974, 0.449155,
0.510421, 0.507240, 0.523986, 0.243294, 0.259582, 0.265296, 0.153495, 0.210919,
0.175795, 0.289338, 0.261993, 0.292679, 0.004520, 0.014463, 0.027411, 0.158739,
0.185508, 0.177154, 0.277571, 0.254854, 0.200811, 0.121067, 0.125831, 0.141556,
0.150596, 0.179851, 0.208442, 0.721808, 0.703699, 0.658621, 0.082401, 0.102751,
0.087683, 0.304927, 0.415250, 0.372928, 0.215721, 0.234882, 0.252276, 0.441477,
0.415440, 0.447996, 0.518851, 0.530398, 0.534217, 0.153495, 0.139910, 0.157591,
0.266232, 0.304927, 0.280962, 0.504703, 0.502852, 0.477339, 0.341396, 0.327178,
0.331838, 0.400475, 0.366139, 0.389980, 0.021532, 0.017326, 0.021595, 0.476009,
0.532548, 0.517645, 0.129167, 0.165371, 0.155077, 0.352412, 0.348680, 0.330446,
0.353484, 0.364709, 0.371690, 0.122156, 0.072419, 0.097494, 0.105721, 0.120580,
0.122272, 0.517645, 0.517851, 0.472974, 0.160252, 0.102751, 0.122636, 0.189917,
0.136152, 0.166252, 0.810081, 0.788676, 0.818187, 0.623525, 0.568211, 0.601739,
0.442058, 0.416781, 0.434290, 0.588527, 0.588698, 0.521247, 0.096522, 0.075334,
0.088239, 0.097494, 0.072419, 0.107522, 0.392283, 0.426686, 0.382873, 0.276850,
0.244043, 0.284845, 0.726543, 0.747156, 0.742528, 0.229467, 0.240943, 0.246565,
0.335536, 0.316159, 0.375954, 0.289531, 0.278425, 0.251030, 0.000000, 0.014463,
0.004520, 0.541267, 0.523420, 0.543996, 0.715801, 0.737869, 0.763421, 0.391402,
0.423587, 0.436416, 0.014245, 0.032299, 0.013066, 0.762123, 0.787012, 0.797006,
0.694974, 0.732388, 0.696130, 0.014670, 0.017281, 0.037081, 0.608630, 0.396954,
0.623405, 0.201414, 0.220812, 0.250772, 0.146386, 0.124605, 0.106780, 0.549551,
0.605695, 0.604023, 0.907863, 0.835893, 0.862535, 0.402212, 0.431797, 0.383648,
0.605560, 0.570846, 0.547992, 0.425355, 0.476282, 0.437618, 0.410063, 0.405147,
0.463370, 0.177065, 0.191547, 0.202377, 0.214731, 0.209723, 0.242776, 0.031488,
0.023890, 0.039066, 0.118150, 0.141609, 0.117867, 0.213945, 0.214728, 0.210035,
0.086810, 0.081621, 0.102224, 0.702787, 0.734006, 0.690351, 0.171861, 0.171521,
0.152728, 0.211229, 0.210919, 0.179386, 0.696334, 0.729756, 0.694974, 0.640364,
0.596259, 0.612835, 0.780386, 0.748268, 0.762070, 0.215001, 0.191794, 0.173742,
0.519549, 0.450589, 0.508323, 0.766543, 0.731895, 0.738117, 0.687951, 0.708728,
0.701515, 0.398565, 0.365621, 0.410561, 0.136288, 0.130305, 0.160252, 0.254020,
0.247371, 0.198961, 0.908009, 0.912957, 0.906539, 0.782444, 0.796301, 0.813323,
0.038875, 0.052430, 0.042677, 0.450517, 0.375723, 0.376066, 0.745091, 0.710231,
0.752190, 0.188698, 0.158277, 0.183858, 0.680843, 0.715801, 0.721808, 0.295210,
0.320496, 0.318394, 0.408120, 0.434290, 0.401308, 0.146325, 0.107522, 0.135727,
0.205198, 0.205938, 0.214728, 0.664103, 0.647505, 0.640364, 0.426686, 0.392283,
0.432933, 0.828907, 0.802639, 0.832168, 0.135727, 0.117867, 0.141609, 0.155026,
0.139367, 0.151126, 0.612866, 0.654953, 0.618556, 0.157591, 0.182873, 0.179386,
0.672592, 0.702787, 0.648611, 0.424410, 0.408120, 0.415288, 0.136059, 0.134102,
0.111131, 0.405147, 0.341395, 0.307583, 0.413380, 0.402561, 0.393102, 0.555168,
0.523986, 0.532285, 0.336175, 0.303947, 0.303284, 0.023391, 0.020235, 0.021595,
0.542449, 0.532699, 0.585889, 0.271928, 0.308048, 0.256877, 0.955312, 0.959850,
0.908009, 0.328377, 0.318593, 0.291522, 0.661089, 0.650957, 0.638747, 0.147329,
0.128893, 0.136288, 0.171861, 0.155077, 0.178567, 0.450273, 0.496807, 0.436416,
0.782844, 0.732388, 0.729756, 0.341396, 0.331838, 0.350250, 0.316056, 0.268101,
0.314085, 0.153376, 0.167723, 0.122952, 0.402561, 0.354587, 0.356223, 0.293548,
0.291604, 0.291245, 0.367428, 0.318316, 0.347695, 0.495418, 0.583223, 0.550963,
0.894179, 0.897268, 0.902666, 0.945245, 0.956981, 0.973942, 0.348680, 0.384540,
0.361595, 0.063041, 0.056970, 0.055687, 0.264950, 0.303947, 0.258721, 0.513199,
0.508197, 0.460972, 0.082574, 0.076945, 0.056243, 0.220812, 0.201414, 0.191659,
0.252276, 0.273693, 0.258578, 0.585889, 0.565892, 0.624043, 0.583264, 0.614643,
0.604078, 0.540484, 0.535529, 0.510617, 0.297210, 0.270964, 0.263585, 0.793081,
0.762866, 0.743288, 0.367428, 0.388851, 0.392283, 0.117953, 0.084134, 0.099029,
0.009716, 0.022560, 0.008620, 0.708542, 0.655092, 0.675481, 0.048564, 0.054990,
0.014647, 0.897268, 0.903339, 0.902666, 0.336311, 0.327534, 0.389262, 0.422951,
0.446927, 0.467252, 0.328466, 0.318888, 0.313560, 0.356736, 0.329118, 0.374762,
0.835044, 0.829821, 0.811719, 0.508015, 0.522191, 0.549551, 0.616173, 0.579020,
0.557669, 0.243294, 0.242958, 0.240943, 0.034321, 0.041064, 0.031085, 0.818187,
0.788676, 0.822984, 0.449947, 0.456312, 0.488834, 0.255455, 0.260780, 0.227558,
0.431107, 0.459163, 0.431797, 0.429428, 0.437618, 0.476282, 0.041064, 0.032073,
0.041235, 0.191398, 0.172681, 0.163743, 0.700462, 0.666252, 0.663953, 0.742528,
0.769420, 0.730216, 0.295221, 0.316159, 0.295416, 0.087822, 0.060639, 0.041356,
0.188317, 0.223627, 0.199143, 0.165585, 0.149297, 0.145539, 0.583223, 0.495418,
0.525423, 0.654953, 0.680487, 0.664660, 0.075020, 0.117727, 0.117877, 0.691614,
0.698480, 0.653123, 0.375673, 0.359351, 0.401073, 0.836814, 0.855510, 0.865504,
0.111131, 0.083425, 0.103117, 0.450603, 0.410779, 0.400374, 0.518682, 0.547992,
0.570846, 0.775955, 0.746191, 0.782884, 0.255518, 0.294813, 0.307306, 0.566259,
0.523022, 0.529819, 0.269620, 0.286034, 0.267529, 0.865504, 0.883802, 0.857281,
0.314572, 0.366888, 0.343245, 0.385766, 0.348680, 0.352412, 0.549822, 0.512288,
0.514925, 0.431107, 0.431797, 0.401073, 0.014463, 0.000000, 0.018270, 0.343245,
0.366888, 0.410063, 0.210035, 0.201502, 0.207199, 0.550963, 0.583223, 0.590833,
0.476009, 0.517645, 0.472974, 0.330137, 0.343245, 0.368636, 0.062694, 0.023391,
0.068900, 0.170885, 0.230891, 0.229467, 0.117771, 0.100250, 0.117877, 0.326759,
0.316056, 0.314085, 0.053344, 0.032073, 0.031173, 0.469528, 0.401938, 0.491365,
0.794294, 0.763925, 0.756903, 0.866511, 0.866919, 0.886139, 0.955066, 0.973942,
0.977413, 0.424268, 0.424796, 0.450589, 0.219418, 0.211229, 0.204130, 0.953828,
0.959850, 0.986422, 0.631650, 0.624043, 0.583854, 0.122131, 0.096651, 0.112623,
0.303284, 0.269104, 0.291477, 0.120580, 0.119054, 0.122272, 0.858135, 0.822470,
0.821680, 0.445384, 0.450589, 0.519549, 0.644757, 0.621453, 0.648521, 0.399199,
0.419947, 0.393491, 0.215001, 0.257404, 0.283059, 0.636057, 0.581821, 0.645516,
0.339467, 0.322360, 0.342957, 0.067179, 0.084134, 0.056838, 0.476009, 0.472974,
0.411320, 0.312554, 0.308048, 0.294665, 0.219002, 0.322360, 0.232663, 0.647719,
0.658382, 0.639236, 0.111502, 0.130056, 0.128281, 0.304359, 0.328377, 0.291244,
0.212253, 0.270964, 0.215637, 0.273441, 0.255518, 0.250772, 0.468944, 0.504703,
0.463312, 0.522191, 0.544108, 0.549551, 0.111577, 0.130056, 0.111502, 0.710231,
0.737802, 0.752190, 0.978126, 0.987043, 0.995037, 0.368293, 0.410779, 0.415673,
0.655092, 0.647894, 0.627239, 0.577673, 0.541988, 0.589554, 0.152224, 0.135716,
0.122156, 0.438617, 0.415250, 0.465917, 0.677325, 0.677640, 0.701515, 0.731678,
0.744545, 0.768253, 0.666252, 0.612835, 0.622256, 0.093035, 0.055904, 0.086810,
0.014670, 0.002168, 0.017281, 0.142736, 0.152728, 0.141556, 0.402561, 0.429074,
0.434562, 0.517645, 0.565892, 0.517851, 0.655092, 0.668522, 0.647894, 0.332633,
0.325235, 0.296681, 0.389980, 0.366139, 0.361018, 0.175518, 0.174866, 0.214731,
0.617808, 0.644757, 0.623405, 0.147329, 0.160252, 0.200811, 0.350924, 0.312764,
0.319566, 0.152224, 0.097494, 0.107522, 0.393652, 0.415955, 0.388320, 0.297418,
0.330446, 0.304939, 0.514925, 0.491116, 0.532285, 0.847703, 0.876168, 0.830482,
0.529819, 0.523022, 0.502813, 0.101651, 0.104422, 0.111502, 0.391130, 0.380367,
0.369290, 0.913484, 0.906711, 0.903931, 0.350924, 0.354622, 0.312764, 0.601031,
0.618556, 0.615140, 0.568211, 0.525423, 0.509841, 0.455195, 0.435492, 0.459163,
0.429664, 0.431107, 0.415166, 0.316159, 0.295221, 0.297082, 0.106780, 0.061170,
0.064079, 0.434562, 0.510617, 0.488469, 0.218377, 0.258466, 0.219002, 0.609388,
0.605737, 0.636094, 0.692164, 0.696166, 0.733132, 0.364613, 0.326401, 0.338602,
0.212701, 0.186107, 0.241931, 0.330446, 0.325613, 0.352412, 0.555451, 0.489104,
0.525618, 0.780386, 0.765260, 0.748268, 0.373943, 0.445071, 0.430319, 0.513477,
0.488834, 0.511180, 0.558963, 0.519549, 0.580970, 0.303284, 0.325235, 0.336175,
0.182277, 0.180233, 0.204779, 0.270964, 0.212253, 0.263585, 0.139367, 0.128281,
0.130056, 0.033779, 0.022560, 0.046770, 0.260780, 0.261686, 0.270711, 0.247371,
0.261993, 0.198961, 0.648611, 0.628356, 0.632058, 0.023391, 0.021595, 0.033510,
0.498887, 0.491365, 0.460231, 0.219418, 0.204130, 0.207821, 0.029919, 0.083801,
0.075020, 0.140539, 0.154451, 0.147816, 0.171521, 0.171861, 0.193385, 0.277571,
0.258570, 0.297418, 0.032073, 0.034321, 0.031173, 0.200811, 0.183858, 0.147329,
0.945245, 0.954192, 0.923491, 0.354587, 0.226094, 0.297636, 0.657182, 0.689192,
0.680644, 0.410561, 0.445071, 0.398565, 0.701082, 0.682955, 0.655287, 0.009716,
0.008620, 0.000000, 0.400374, 0.382873, 0.426686, 0.559812, 0.541988, 0.524392,
0.554974, 0.542113, 0.527654, 0.783132, 0.810995, 0.802639, 0.527654, 0.509841,
0.515305, 0.441477, 0.447996, 0.457812, 0.175795, 0.210919, 0.215176, 0.111550,
0.055683, 0.061170, 0.185453, 0.160252, 0.134102, 0.056970, 0.068052, 0.079125,
0.414392, 0.369290, 0.321807, 0.755606, 0.723462, 0.722228, 0.718103, 0.743288,
0.739370, 0.236476, 0.210230, 0.248804, 0.230281, 0.223627, 0.188317, 0.123429,
0.102224, 0.103917, 0.241931, 0.186107, 0.235484, 0.325816, 0.295273, 0.354622,
0.504703, 0.468944, 0.523950, 0.263373, 0.250772, 0.239044, 0.383081, 0.314085,
0.354587, 0.165371, 0.129167, 0.164033, 0.260780, 0.250462, 0.227558, 0.730430,
0.708112, 0.748268, 0.535876, 0.521247, 0.595833, 0.371690, 0.399910, 0.376769,
0.482315, 0.466103, 0.437638, 0.978126, 0.945264, 0.952257, 0.452405, 0.436581,
0.544330, 0.329118, 0.300106, 0.307306, 0.746884, 0.698480, 0.691614, 0.259620,
0.280870, 0.270878, 0.157371, 0.173902, 0.188317, 0.835044, 0.853543, 0.829821,
0.209497, 0.204779, 0.205198, 0.393652, 0.437618, 0.422783, 0.278367, 0.261686,
0.258578, 0.322510, 0.340809, 0.328377, 0.550963, 0.513199, 0.462058, 0.389980,
0.409951, 0.400475, 0.547905, 0.551112, 0.583264, 0.263713, 0.232928, 0.176088,
0.182873, 0.201502, 0.204130, 0.177336, 0.180368, 0.162903, 0.525423, 0.489643,
0.509841, 0.357442, 0.356223, 0.336175, 0.655287, 0.690471, 0.701082, 0.644696,
0.664660, 0.680843, 0.356223, 0.297636, 0.303947, 0.945264, 0.978126, 0.919383,
0.460231, 0.402637, 0.390538, 0.768253, 0.776137, 0.801266, 0.057587, 0.086182,
0.104665, 0.543996, 0.517129, 0.545724, 0.477339, 0.429074, 0.463312, 0.106780,
0.129375, 0.146386, 0.191716, 0.235484, 0.186107, 0.737869, 0.707913, 0.739370,
0.249449, 0.183858, 0.219479, 0.708728, 0.734798, 0.701515, 0.415336, 0.456312,
0.449947, 0.865504, 0.883655, 0.883802, 0.399910, 0.383051, 0.406304, 0.384540,
0.381643, 0.361595, 0.257893, 0.234882, 0.238701, 0.425355, 0.440272, 0.474040,
0.177801, 0.166252, 0.146386, 0.133348, 0.155077, 0.142736, 0.164119, 0.188317,
0.199143, 0.496104, 0.510421, 0.529819, 0.655287, 0.624043, 0.631650, 0.390117,
0.383062, 0.381688, 0.504956, 0.425355, 0.499590, 0.604078, 0.549125, 0.547905,
0.151640, 0.135535, 0.155026, 0.415166, 0.431107, 0.401073, 0.093822, 0.052430,
0.084794, 0.135727, 0.107522, 0.117867, 0.198961, 0.174866, 0.156933, 0.075020,
0.117877, 0.050200, 0.282815, 0.272284, 0.270878, 0.751856, 0.749709, 0.794432,
0.517767, 0.530398, 0.493488, 0.827275, 0.907863, 0.895348, 0.690423, 0.623405,
0.672355, 0.977413, 0.973942, 0.990335, 0.209062, 0.211825, 0.194624, 0.329118,
0.344431, 0.372015, 0.878407, 0.838767, 0.878491, 0.396979, 0.350250, 0.365728,
0.447218, 0.471702, 0.456312, 0.741477, 0.762070, 0.748268, 0.730430, 0.661089,
0.708112, 0.183278, 0.200403, 0.218377, 0.854284, 0.832059, 0.820921, 0.204130,
0.211229, 0.182873, 0.828907, 0.832168, 0.860707, 0.117727, 0.150604, 0.117877,
0.886968, 0.872626, 0.886152, 0.646821, 0.690025, 0.696334, 0.230891, 0.243294,
0.240943, 0.464460, 0.507273, 0.491116, 0.032073, 0.045549, 0.041235, 0.381688,
0.347539, 0.361595, 0.316622, 0.375723, 0.307583, 0.751940, 0.778945, 0.782844,
0.855508, 0.872443, 0.853543, 0.746191, 0.775955, 0.743288, 0.411089, 0.402325,
0.415336, 0.913484, 0.953828, 0.951570, 0.469528, 0.382565, 0.401938, 0.742296,
0.733132, 0.717621, 0.644696, 0.564095, 0.615140, 0.198961, 0.189917, 0.214415,
0.832942, 0.876336, 0.874150, 0.131769, 0.173902, 0.157371, 0.462058, 0.495418,
0.550963, 0.061170, 0.038223, 0.064079, 0.990335, 0.968534, 1.000000, 0.362501,
0.322360, 0.308446, 0.181556, 0.212496, 0.173032, 0.760612, 0.796301, 0.782444,
0.502876, 0.518851, 0.402505, 0.028737, 0.034118, 0.044084, 0.450589, 0.489104,
0.508323, 0.204899, 0.194113, 0.211715, 0.467252, 0.508015, 0.464453, 0.308446,
0.282099, 0.305818, 0.122213, 0.140734, 0.103117, 0.083003, 0.104855, 0.122213,
0.610133, 0.661089, 0.638747, 0.778945, 0.801533, 0.782844, 0.557669, 0.570229,
0.618134, 0.663953, 0.666252, 0.622256, 0.027411, 0.063749, 0.048564, 0.027411,
0.019200, 0.004520, 0.243232, 0.250542, 0.262201, 0.726543, 0.715630, 0.701172,
0.564025, 0.578529, 0.633641, 0.189917, 0.199299, 0.209489, 0.878491, 0.923491,
0.931489, 0.034878, 0.038466, 0.028898, 0.414392, 0.391130, 0.369290, 0.691614,
0.659510, 0.695035, 0.801087, 0.790337, 0.831767, 0.464460, 0.422951, 0.464453,
0.331559, 0.310165, 0.301835, 0.330398, 0.330403, 0.306406, 0.568211, 0.623525,
0.597211, 0.630142, 0.612866, 0.597492, 0.307899, 0.339815, 0.318048, 0.348984,
0.339467, 0.371690, 0.840159, 0.822984, 0.828907, 0.261993, 0.263604, 0.242776,
0.063749, 0.111550, 0.076638, 0.657892, 0.628765, 0.669213, 0.439231, 0.407374,
0.441477, 0.219479, 0.254854, 0.249449, 0.383648, 0.357442, 0.375673, 0.679958,
0.665757, 0.682425, 0.368293, 0.415673, 0.375954, 0.382565, 0.304927, 0.281120,
0.191547, 0.194624, 0.211825, 0.354587, 0.434562, 0.420207, 0.230603, 0.205936,
0.250030, 0.183278, 0.183331, 0.200403, 0.393491, 0.371606, 0.377577, 0.416887,
0.390117, 0.401308, 0.252276, 0.236232, 0.215721, 0.280962, 0.304927, 0.300565,
0.098519, 0.104422, 0.101651, 0.667794, 0.623525, 0.601739, 0.638187, 0.644696,
0.615140, 0.388320, 0.362396, 0.346621, 0.054280, 0.029590, 0.035538, 0.279763,
0.325235, 0.291477, 0.232928, 0.265006, 0.222270, 0.555451, 0.564025, 0.622256,
0.710231, 0.701082, 0.737802, 0.483307, 0.457812, 0.447996, 0.521247, 0.549822,
0.588527, 0.021532, 0.021595, 0.020235, 0.416887, 0.446927, 0.422951, 0.305818,
0.325348, 0.308446, 0.330398, 0.304939, 0.330446, 0.038223, 0.014245, 0.029590,
0.369290, 0.338818, 0.321807, 0.376408, 0.398565, 0.445071, 0.469528, 0.465917,
0.382565, 0.534010, 0.520223, 0.541267, 0.849437, 0.816244, 0.772310, 0.135716,
0.157179, 0.122213, 0.205938, 0.184786, 0.196781, 0.847703, 0.857281, 0.870155,
0.201400, 0.211002, 0.177336, 0.631650, 0.692164, 0.690471, 0.878407, 0.855508,
0.838767, 0.533886, 0.433740, 0.504956, 0.436581, 0.628705, 0.544330, 0.056970,
0.063041, 0.068052, 0.023391, 0.056584, 0.057587, 0.436581, 0.414392, 0.321807,
0.927581, 0.892481, 0.878407, 0.180424, 0.147607, 0.173032, 0.366139, 0.362501,
0.308446, 0.137033, 0.108088, 0.126198, 0.415250, 0.304927, 0.382565, 0.195485,
0.212486, 0.189490, 0.147580, 0.149297, 0.160701, 0.060317, 0.096651, 0.065628,
0.179386, 0.182873, 0.211229, 0.873121, 0.816672, 0.849437, 0.510421, 0.481583,
0.485480, 0.123427, 0.136059, 0.111131, 0.429664, 0.415166, 0.389987, 0.973942,
0.955066, 0.954192, 0.139910, 0.121067, 0.141556, 0.508015, 0.547992, 0.518682,
0.770807, 0.730430, 0.765260, 0.609302, 0.628356, 0.594847, 0.990491, 0.970637,
0.958511, 0.853521, 0.894179, 0.892331, 0.782884, 0.796495, 0.818932, 0.540484,
0.597639, 0.586406, 0.865504, 0.877638, 0.883655, 0.485480, 0.507240, 0.510421,
0.191398, 0.214694, 0.213953, 0.083003, 0.122213, 0.103117, 0.157591, 0.179386,
0.153495, 0.737802, 0.733132, 0.754377, 0.896168, 0.903600, 0.903339, 0.216210,
0.158722, 0.226522, 0.104665, 0.126271, 0.119506, 0.297636, 0.258721, 0.303947,
0.325816, 0.369412, 0.368293, 0.151640, 0.155026, 0.165961, 0.365621, 0.424796,
0.424268, 0.067910, 0.079125, 0.108088, 0.402505, 0.343245, 0.394988, 0.199299,
0.177801, 0.191398, 0.244939, 0.226536, 0.266232, 0.153495, 0.179386, 0.210919,
0.067179, 0.099029, 0.084134, 0.847703, 0.801533, 0.832712, 0.570229, 0.557669,
0.511180, 0.309703, 0.284215, 0.287918, 0.383081, 0.393652, 0.388320, 0.289118,
0.271980, 0.336311, 0.344431, 0.329118, 0.307306, 0.715801, 0.680843, 0.664660,
0.788676, 0.810081, 0.770807, 0.977413, 0.988882, 0.959850, 0.787269, 0.784090,
0.752190, 0.467252, 0.446927, 0.468371, 0.150604, 0.181400, 0.161091, 0.289338,
0.299901, 0.263604, 0.186107, 0.183044, 0.162620, 0.035538, 0.013992, 0.028737,
0.664660, 0.707913, 0.715801, 0.209062, 0.218377, 0.158739, 0.079125, 0.068052,
0.115560, 0.234054, 0.263713, 0.176088, 0.293548, 0.326401, 0.291604, 0.517353,
0.551112, 0.518498, 0.760612, 0.782444, 0.734798, 0.294813, 0.255518, 0.273441,
0.348680, 0.361595, 0.330398, 0.790337, 0.768233, 0.807182, 0.252493, 0.238461,
0.180994, 0.446927, 0.416887, 0.442058, 0.451049, 0.519549, 0.495262, 0.771874,
0.749456, 0.768233, 0.308759, 0.310944, 0.347539, 0.044084, 0.067179, 0.056838,
0.158739, 0.218377, 0.154451, 0.473438, 0.401938, 0.402637, 0.180424, 0.173032,
0.212496, 0.195485, 0.164033, 0.171652, 0.201739, 0.188356, 0.178567, 0.568211,
0.596034, 0.601739, 0.119147, 0.121067, 0.139910, 0.744093, 0.795950, 0.772310,
0.491312, 0.498182, 0.523420, 0.159618, 0.164119, 0.175578, 0.177855, 0.154451,
0.218377, 0.177336, 0.211002, 0.200478, 0.053028, 0.056243, 0.055307, 0.534010,
0.517767, 0.510504, 0.087683, 0.105348, 0.082868, 0.752190, 0.784090, 0.772101,
0.607408, 0.585908, 0.583936, 0.557669, 0.618134, 0.616173, 0.661429, 0.648611,
0.632058, 0.184829, 0.238461, 0.230891, 0.677194, 0.696166, 0.692164, 0.783585,
0.822470, 0.819424, 0.287918, 0.257893, 0.266636, 0.668522, 0.710701, 0.718524,
0.447042, 0.432501, 0.449155, 0.250030, 0.283059, 0.277185, 0.274122, 0.234452,
0.259620, 0.347539, 0.330403, 0.361595, 0.186252, 0.171652, 0.131028, 0.853543,
0.835044, 0.838767, 0.411089, 0.381266, 0.372015, 0.627634, 0.540484, 0.554486,
0.810967, 0.796329, 0.784090, 0.600272, 0.589554, 0.559812, 0.273693, 0.252276,
0.257893, 0.870495, 0.822470, 0.875930, 0.955066, 0.955312, 0.931489, 0.718524,
0.710701, 0.745096, 0.164033, 0.136651, 0.131028, 0.108113, 0.129167, 0.133348,
0.701172, 0.709040, 0.726543, 0.041064, 0.040285, 0.031085, 0.517353, 0.518498,
0.495362, 0.336311, 0.376066, 0.316622, 0.384540, 0.397616, 0.381643, 0.424410,
0.372619, 0.406059, 0.362706, 0.340809, 0.335536, 0.744665, 0.706525, 0.723462,
0.502329, 0.511180, 0.471702, 0.307899, 0.263373, 0.299901, 0.238701, 0.307583,
0.297858, 0.362706, 0.327978, 0.340809, 0.410779, 0.369412, 0.400374, 0.179851,
0.236232, 0.208442, 0.431850, 0.425550, 0.407965, 0.205198, 0.204779, 0.191775,
0.630696, 0.583854, 0.532548, 0.295273, 0.277185, 0.312764, 0.034878, 0.055574,
0.038466, 0.332633, 0.331559, 0.356736, 0.119147, 0.139910, 0.126271, 0.877638,
0.903600, 0.883655, 0.707568, 0.739370, 0.707913, 0.801266, 0.814712, 0.832712,
0.159618, 0.187528, 0.163743, 0.061170, 0.055683, 0.034096, 0.115437, 0.086182,
0.105721, 0.304939, 0.288309, 0.277571, 0.356736, 0.361724, 0.332633, 0.633641,
0.630140, 0.659045, 0.764950, 0.729413, 0.720886, 0.907820, 0.901348, 0.874150,
0.507273, 0.518682, 0.570846, 0.103142, 0.135315, 0.131648, 0.770807, 0.781504,
0.742919, 0.267659, 0.245694, 0.295210, 0.218457, 0.223757, 0.272773, 0.111131,
0.103117, 0.123427, 0.613554, 0.557470, 0.543470, 0.213953, 0.199299, 0.191398,
0.864720, 0.875930, 0.858135, 0.399910, 0.433740, 0.508507, 0.695312, 0.734006,
0.726055, 0.014245, 0.008619, 0.014918, 0.855510, 0.877638, 0.865504, 0.354622,
0.295273, 0.312764, 0.873121, 0.904429, 0.923491, 0.201739, 0.207199, 0.188356,
0.368582, 0.362501, 0.366139, 0.592040, 0.425322, 0.508507, 0.394474, 0.439231,
0.424715, 0.450273, 0.454052, 0.496807, 0.512288, 0.475048, 0.514925, 0.183044,
0.186107, 0.201833, 0.377079, 0.347555, 0.351456, 0.862020, 0.925669, 0.890424,
0.055904, 0.038223, 0.029590, 0.546101, 0.513477, 0.511180, 0.532699, 0.565892,
0.585889, 0.455370, 0.431107, 0.429664, 0.068900, 0.103142, 0.062694, 0.105702,
0.110613, 0.098519, 0.607930, 0.621453, 0.585908, 0.199143, 0.175578, 0.164119,
0.070201, 0.059520, 0.067910, 0.061977, 0.054383, 0.076638, 0.163743, 0.172681,
0.136867, 0.701172, 0.685996, 0.669213, 0.050200, 0.037081, 0.017281, 0.878407,
0.892481, 0.879609, 0.765671, 0.744545, 0.746884, 0.045549, 0.050739, 0.055307,
0.429074, 0.413380, 0.434064, 0.583223, 0.597211, 0.627239, 0.504956, 0.476282,
0.425355, 0.076638, 0.111550, 0.118150, 0.050200, 0.117877, 0.100250, 0.291477,
0.244180, 0.279763, 0.508015, 0.549551, 0.547992, 0.802639, 0.810995, 0.832168,
0.481119, 0.502813, 0.523950, 0.271671, 0.261686, 0.278367, 0.141609, 0.156933,
0.135727, 0.415288, 0.396979, 0.424410, 0.776137, 0.790092, 0.814712, 0.362706,
0.424796, 0.365621, 0.351456, 0.373943, 0.384427, 0.344388, 0.347695, 0.318394,
0.717894, 0.762123, 0.756903, 0.424796, 0.362706, 0.389639, 0.790092, 0.776137,
0.765671, 0.303947, 0.264950, 0.303284, 0.789995, 0.751134, 0.783585, 0.886968,
0.886152, 0.897268, 0.459163, 0.431107, 0.455370, 0.784998, 0.752190, 0.737802,
0.354622, 0.369412, 0.325816, 0.171652, 0.164033, 0.131028, 0.682425, 0.622487,
0.653284, 0.219002, 0.177855, 0.218377, 0.535876, 0.517378, 0.471167, 0.019200,
0.014647, 0.004520, 0.970637, 0.937753, 0.958511, 0.849437, 0.862020, 0.890424,
0.576543, 0.636998, 0.596034, 0.144488, 0.157428, 0.170885, 0.602835, 0.635643,
0.628765, 0.496807, 0.515305, 0.509841, 0.737869, 0.739370, 0.765326, 0.318888,
0.350250, 0.331838, 0.437638, 0.450517, 0.376066, 0.297858, 0.307583, 0.341395,
0.236232, 0.179851, 0.215721, 0.245694, 0.228206, 0.221511, 0.327978, 0.312554,
0.318593, 0.640364, 0.647505, 0.614104, 0.499590, 0.593931, 0.539959, 0.860707,
0.866511, 0.840159, 0.328377, 0.291522, 0.314948, 0.382792, 0.397090, 0.389262,
0.874150, 0.810081, 0.818187, 0.755606, 0.760369, 0.805918, 0.749456, 0.735735,
0.768233, 1.000000, 0.995037, 0.999897, 0.013066, 0.032299, 0.027411, 0.291245,
0.284215, 0.293548, 0.182277, 0.201400, 0.177336, 0.612835, 0.596259, 0.558963,
0.414392, 0.452405, 0.391130, 0.667794, 0.675481, 0.630887, 0.171919, 0.184786,
0.191775, 0.022560, 0.033779, 0.034878, 0.970637, 0.987043, 0.978126, 0.540484,
0.586406, 0.574168, 0.547905, 0.518498, 0.551112, 0.131647, 0.119054, 0.130673,
0.351456, 0.347555, 0.325361, 0.098519, 0.110613, 0.108113, 0.544108, 0.522191,
0.519837, 0.394999, 0.368636, 0.443090, 0.768253, 0.778945, 0.751940, 0.313560,
0.318888, 0.311923, 0.636094, 0.644969, 0.609388, 0.866919, 0.868577, 0.892331,
0.065756, 0.083003, 0.053028, 0.160701, 0.177336, 0.162903, 0.260780, 0.270711,
0.250462, 0.377079, 0.364935, 0.347555, 0.407374, 0.439231, 0.394474, 0.128893,
0.183858, 0.158277, 0.733132, 0.737802, 0.701082, 0.291245, 0.295416, 0.304359,
0.433740, 0.399910, 0.406304, 0.847703, 0.832712, 0.857281, 0.189490, 0.155077,
0.165371, 0.211229, 0.243194, 0.210919, 0.166217, 0.215637, 0.169850, 0.647434,
0.604023, 0.653123, 0.082401, 0.122636, 0.102751, 0.081621, 0.056838, 0.084134,
0.000000, 0.031488, 0.018270, 0.449947, 0.465560, 0.427524, 0.096522, 0.088239,
0.122952, 0.955312, 0.955066, 0.977413, 0.951570, 0.980041, 0.958511, 0.199143,
0.223627, 0.207846, 0.581821, 0.544108, 0.542449, 0.376769, 0.348984, 0.371690,
0.517851, 0.506819, 0.472974, 0.554486, 0.502852, 0.504703, 0.054280, 0.086810,
0.055904, 0.721808, 0.715801, 0.750599, 0.754377, 0.784998, 0.737802, 0.814136,
0.835044, 0.810967, 0.795950, 0.862020, 0.772310, 0.104855, 0.135716, 0.122213,
0.592040, 0.508507, 0.533886, 0.783132, 0.762866, 0.793081, 0.196137, 0.188698,
0.210230, 0.488570, 0.465917, 0.503279, 0.174866, 0.209723, 0.214731, 0.382565,
0.281120, 0.401938, 0.054280, 0.055904, 0.029590, 0.048564, 0.063749, 0.076638,
0.083425, 0.082574, 0.089460, 0.413255, 0.411089, 0.427948, 0.296681, 0.282815,
0.310165, 0.435492, 0.455195, 0.413380, 0.383062, 0.347539, 0.381688, 0.180994,
0.270964, 0.252493, 0.956279, 0.925306, 0.978126, 0.051793, 0.054990, 0.039531,
0.236476, 0.248804, 0.272992, 0.196781, 0.184786, 0.183044, 0.427524, 0.427948,
0.411089, 0.564095, 0.602318, 0.615140, 0.411320, 0.452405, 0.476009, 0.569381,
0.563112, 0.557669, 0.460608, 0.430319, 0.445071, 0.242958, 0.256844, 0.247062,
0.630142, 0.654953, 0.612866, 0.492002, 0.466103, 0.482315, 0.201739, 0.178567,
0.189490, 0.234882, 0.215721, 0.175795, 0.875930, 0.868757, 0.896184, 0.210035,
0.205273, 0.207821, 0.835044, 0.811719, 0.810967, 0.857797, 0.905782, 0.876336,
0.245694, 0.259331, 0.295210, 0.377079, 0.351456, 0.384427, 0.804236, 0.782884,
0.818932, 0.373943, 0.351456, 0.350647, 0.263713, 0.285285, 0.265006, 0.053344,
0.042677, 0.065756, 0.439043, 0.482229, 0.508709, 0.517353, 0.583264, 0.551112,
0.209723, 0.198961, 0.261993, 0.764950, 0.751408, 0.742422, 0.540484, 0.708112,
0.661089, 0.980341, 0.968534, 0.965094, 0.718103, 0.739370, 0.707568, 0.581821,
0.542449, 0.585889, 0.696334, 0.726055, 0.729756, 0.631309, 0.600272, 0.614104,
0.083425, 0.076893, 0.056243, 0.990491, 0.987043, 0.970637, 0.766941, 0.816244,
0.816672, 0.955312, 0.927581, 0.931489, 0.717894, 0.756903, 0.747156, 0.493488,
0.530398, 0.485147, 0.710701, 0.681575, 0.745096, 0.130056, 0.131647, 0.147495,
0.279763, 0.271545, 0.296681, 0.104855, 0.122156, 0.135716, 0.219002, 0.232663,
0.177855, 0.140734, 0.123427, 0.103117, 0.378484, 0.377562, 0.389980, 0.381643,
0.390117, 0.381688, 0.701172, 0.669213, 0.635643, 0.023890, 0.028898, 0.024042,
0.769420, 0.782884, 0.746191, 0.033398, 0.020235, 0.043543, 0.789995, 0.783585,
0.819424, 0.878407, 0.931489, 0.927581, 0.715630, 0.726543, 0.742528, 0.653284,
0.710296, 0.682425, 0.860374, 0.820921, 0.854535, 0.288309, 0.254854, 0.277571,
0.033398, 0.024828, 0.020235, 0.794432, 0.814136, 0.784998, 0.211002, 0.210428,
0.218529, 0.371606, 0.320496, 0.345041, 0.902666, 0.903339, 0.906539, 0.292679,
0.261993, 0.272921, 0.118150, 0.136152, 0.141609, 0.297050, 0.327178, 0.287031,
0.072419, 0.122156, 0.104855, 0.613554, 0.608505, 0.653134, 0.801266, 0.801533,
0.768253, 0.696166, 0.677194, 0.650959, 0.970637, 0.952257, 0.937753, 0.722228,
0.679549, 0.695834, 0.322360, 0.219002, 0.258466, 0.112623, 0.131648, 0.150596,
0.082574, 0.106621, 0.089460, 0.178567, 0.188356, 0.171861, 0.648611, 0.588698,
0.628356, 0.460972, 0.508197, 0.450603, 0.517129, 0.503279, 0.545724, 0.464460,
0.431850, 0.407965, 0.187528, 0.159618, 0.175578, 0.046770, 0.054848, 0.033779,
0.447996, 0.460608, 0.495362, 0.717621, 0.751856, 0.754377, 0.624043, 0.565892,
0.583854, 0.241130, 0.238251, 0.180424, 0.207821, 0.212701, 0.219418, 0.368582,
0.366139, 0.381946, 0.200811, 0.185453, 0.247062, 0.173742, 0.191794, 0.185348,
0.345041, 0.320496, 0.308759, 0.054280, 0.035538, 0.056838, 0.144488, 0.170885,
0.176088, 0.063041, 0.082868, 0.068052, 0.291245, 0.291604, 0.286034, 0.765326,
0.762866, 0.783132, 0.925669, 0.933134, 0.968534, 0.329118, 0.331559, 0.300106,
0.173902, 0.208442, 0.230281, 0.449918, 0.509841, 0.480711, 0.147495, 0.139367,
0.130056, 0.262201, 0.251030, 0.243232, 0.518851, 0.534217, 0.517873, 0.156933,
0.141609, 0.189917, 0.608630, 0.623405, 0.690423, 0.297858, 0.314572, 0.266636,
0.205938, 0.205273, 0.214728, 0.265296, 0.258570, 0.256844, 0.402505, 0.518851,
0.517873, 0.174866, 0.175518, 0.146325, 0.391402, 0.388851, 0.347695, 0.784090,
0.796329, 0.772101, 0.506819, 0.519837, 0.522191, 0.122272, 0.115385, 0.105721,
0.116100, 0.120580, 0.105721, 0.919383, 0.978126, 0.925306, 0.427948, 0.429664,
0.413255, 0.299901, 0.339815, 0.307899, 0.455370, 0.465560, 0.481583, 0.845505,
0.810995, 0.836184, 0.600272, 0.631309, 0.589554, 0.218457, 0.191716, 0.223757,
0.367428, 0.392283, 0.350924, 0.215176, 0.238701, 0.234882, 0.795950, 0.731895,
0.766543, 0.423587, 0.393491, 0.419947, 0.051793, 0.040285, 0.056970, 0.630696,
0.628705, 0.650959, 0.105721, 0.086182, 0.073843, 0.768233, 0.732388, 0.787728,
0.799406, 0.817982, 0.814712, 0.459163, 0.455370, 0.496104, 0.032299, 0.014245,
0.034096, 0.300106, 0.284845, 0.307306, 0.286034, 0.281120, 0.255732, 0.749456,
0.745096, 0.708542, 0.822873, 0.794432, 0.816672, 0.467252, 0.464453, 0.422951,
0.300106, 0.276850, 0.284845, 0.263585, 0.232663, 0.297210, 0.475048, 0.431850,
0.464460, 0.083425, 0.089460, 0.103117, 0.701515, 0.734798, 0.717894, 0.682955,
0.701082, 0.710231, 0.054848, 0.070072, 0.088239, 0.519837, 0.542449, 0.544108,
0.919383, 0.925306, 0.874150, 0.084794, 0.061977, 0.118150, 0.618556, 0.638187,
0.615140, 0.693910, 0.695312, 0.726055, 0.406059, 0.411320, 0.449155, 0.258466,
0.308446, 0.322360, 0.701172, 0.667833, 0.709040, 0.768253, 0.801533, 0.778945,
0.185348, 0.205936, 0.230603, 0.614643, 0.583264, 0.577673, 0.772101, 0.746884,
0.745091, 0.103142, 0.087822, 0.062694, 0.741477, 0.748268, 0.703699, 0.055687,
0.040285, 0.041064, 0.648611, 0.690351, 0.695312, 0.146325, 0.156933, 0.174866,
0.519549, 0.524392, 0.495262, 0.481119, 0.455195, 0.459163, 0.096651, 0.099029,
0.065628, 0.182873, 0.207199, 0.201502, 0.988882, 1.000000, 0.999897, 0.831131,
0.876168, 0.868757, 0.610057, 0.602835, 0.628765, 0.269620, 0.275771, 0.295221,
0.110613, 0.129167, 0.108113, 0.107887, 0.104422, 0.121067, 0.802639, 0.828907,
0.787784, 0.047149, 0.050200, 0.070072, 0.327178, 0.297050, 0.304538, 0.365777,
0.402325, 0.372015, 0.195485, 0.189490, 0.165371, 0.103138, 0.101651, 0.128281,
0.546468, 0.499590, 0.510705, 0.729756, 0.726055, 0.751940, 0.693910, 0.648611,
0.695312, 0.238251, 0.171066, 0.180424, 0.883802, 0.896168, 0.903339, 0.903600,
0.908009, 0.906539, 0.024828, 0.033398, 0.039066, 0.457812, 0.483307, 0.471702,
0.860707, 0.866919, 0.866511, 0.213945, 0.207199, 0.201739, 0.805918, 0.789995,
0.820921, 0.093035, 0.086810, 0.105162, 0.325816, 0.272773, 0.295273, 0.542113,
0.596034, 0.568211, 0.546101, 0.507240, 0.513477, 0.524392, 0.558963, 0.596259,
0.063749, 0.027411, 0.059926, 0.322360, 0.339467, 0.348984, 0.521247, 0.588698,
0.595833, 0.321807, 0.608630, 0.436581, 0.173902, 0.230281, 0.188317, 0.156933,
0.146325, 0.135727, 0.413380, 0.393102, 0.435492, 0.655287, 0.645516, 0.624043,
0.672355, 0.623405, 0.644757, 0.901348, 0.945264, 0.919383, 0.693910, 0.726055,
0.690025, 0.103117, 0.106621, 0.083003, 0.502813, 0.481119, 0.496104, 0.183008,
0.173742, 0.137033, 0.272921, 0.307004, 0.292679, 0.717621, 0.690423, 0.729944,
0.609302, 0.632058, 0.628356, 0.641742, 0.648611, 0.693910, 0.218529, 0.217262,
0.200478, 0.198222, 0.180936, 0.213668, 0.855508, 0.878407, 0.879609, 0.035538,
0.028737, 0.044084, 0.180233, 0.182277, 0.149297, 0.361724, 0.401073, 0.359351,
0.828907, 0.860707, 0.840159, 0.211229, 0.244939, 0.243194, 0.191659, 0.201414,
0.152224, 0.227558, 0.207846, 0.223627, 0.244180, 0.291477, 0.269104, 0.017281,
0.002168, 0.014647, 0.160252, 0.185453, 0.200811, 0.177154, 0.232928, 0.209062,
0.582895, 0.597492, 0.586674, 0.868757, 0.864720, 0.834972, 0.257399, 0.279763,
0.257395, 0.653123, 0.604023, 0.617629, 0.431797, 0.402212, 0.401073, 0.087822,
0.103142, 0.131648, 0.752190, 0.784998, 0.787269, 0.578529, 0.525618, 0.508709,
0.048564, 0.054383, 0.054990, 0.013992, 0.014918, 0.008619, 0.665429, 0.689192,
0.656974, 0.403596, 0.354587, 0.416679, 0.276850, 0.300106, 0.280870, 0.744665,
0.774570, 0.760612, 0.782844, 0.787728, 0.732388, 0.014670, 0.037081, 0.022560,
0.925306, 0.861269, 0.874150, 0.734798, 0.708728, 0.760612, 0.207199, 0.193385,
0.188356, 0.439240, 0.450487, 0.471167, 0.147495, 0.147580, 0.151126, 0.268318,
0.261500, 0.269790, 0.744665, 0.730200, 0.706525, 0.691614, 0.653123, 0.645059,
0.511180, 0.502329, 0.547905, 0.177065, 0.183278, 0.194624, 0.608630, 0.650959,
0.436581, 0.507240, 0.532285, 0.523986, 0.644696, 0.638187, 0.664660, 0.388851,
0.367428, 0.347695, 0.104855, 0.083003, 0.072419, 0.751134, 0.760369, 0.722228,
0.307306, 0.307899, 0.318048, 0.061977, 0.076638, 0.118150, 0.530398, 0.517767,
0.534010, 0.434562, 0.429074, 0.477339, 0.491312, 0.456695, 0.440866, 0.185508,
0.158739, 0.144488, 0.680644, 0.679263, 0.636094, 0.364935, 0.377079, 0.402325,
0.877638, 0.872443, 0.903600, 0.647505, 0.631309, 0.614104, 0.256877, 0.209489,
0.247558, 0.357442, 0.359351, 0.375673, 0.400374, 0.426686, 0.450603, 0.252493,
0.259582, 0.238461, 0.308446, 0.258466, 0.282099, 0.031173, 0.042677, 0.053344,
0.756903, 0.762123, 0.794294, 0.624043, 0.645516, 0.581821, 0.272463, 0.271545,
0.265006, 0.618134, 0.667833, 0.649638, 0.854284, 0.860374, 0.872626, 0.210230,
0.221511, 0.196137, 0.447996, 0.495362, 0.483307, 0.698480, 0.647434, 0.653123,
0.694974, 0.646821, 0.696334, 0.067910, 0.056970, 0.079125, 0.482315, 0.456695,
0.493276, 0.647505, 0.664103, 0.687951, 0.376408, 0.353241, 0.398565, 0.857797,
0.866511, 0.893999, 0.845505, 0.832168, 0.810995, 0.772310, 0.766941, 0.749709,
0.447042, 0.483991, 0.468371, 0.415336, 0.394474, 0.424715, 0.593071, 0.555168,
0.580476, 0.209062, 0.158739, 0.177154, 0.277185, 0.295273, 0.230603, 0.105721,
0.096522, 0.116100, 0.980041, 0.990491, 0.958511, 0.283059, 0.250030, 0.215001,
0.263585, 0.212253, 0.232663, 0.513199, 0.460972, 0.462058, 0.566259, 0.601031,
0.523022, 0.166217, 0.177855, 0.232663, 0.263604, 0.263373, 0.239044, 0.365777,
0.355487, 0.339815, 0.401308, 0.381643, 0.397616, 0.866511, 0.886139, 0.893999,
0.232928, 0.263713, 0.265006, 0.787728, 0.782844, 0.831131, 0.766543, 0.738117,
0.747891, 0.413380, 0.455195, 0.434064, 0.522223, 0.491365, 0.520424, 0.119147,
0.115437, 0.105721, 0.782844, 0.729756, 0.751940, 0.593931, 0.499590, 0.546468,
0.177065, 0.202377, 0.180936, 0.214694, 0.191398, 0.187528, 0.318316, 0.267659,
0.318394, 0.667794, 0.696130, 0.675481, 0.616173, 0.649638, 0.635643, 0.749709,
0.744093, 0.772310, 0.073843, 0.096522, 0.105721, 0.060317, 0.043543, 0.020235,
0.070201, 0.029919, 0.059520, 0.836184, 0.818932, 0.838130, 0.209489, 0.213953,
0.247558, 0.084794, 0.118150, 0.117867, 0.291604, 0.281120, 0.286034, 0.659045,
0.679118, 0.695834, 0.499590, 0.474040, 0.510705, 0.065628, 0.067179, 0.044084,
0.137033, 0.173742, 0.185348, 0.814712, 0.801266, 0.776137, 0.893999, 0.929159,
0.915210, 0.469528, 0.522223, 0.503279, 0.157319, 0.172681, 0.177801, 0.274122,
0.259620, 0.270878, 0.158722, 0.157356, 0.134102, 0.328466, 0.365728, 0.350250,
0.099509, 0.115560, 0.082868, 0.903339, 0.899946, 0.896184, 0.384555, 0.364613,
0.338602, 0.416781, 0.401308, 0.434290, 0.042677, 0.062742, 0.065756, 0.447218,
0.415336, 0.424715, 0.440866, 0.389262, 0.397090, 0.742919, 0.781504, 0.764950,
0.024042, 0.039066, 0.023890, 0.449918, 0.432933, 0.388851, 0.745091, 0.752190,
0.772101, 0.228841, 0.211715, 0.257395, 0.055683, 0.032299, 0.034096, 0.310944,
0.248804, 0.306406, 0.117771, 0.122952, 0.100250, 0.269104, 0.264950, 0.240753,
0.330446, 0.297418, 0.325613, 0.186252, 0.200478, 0.217262, 0.401308, 0.397616,
0.408120, 0.790115, 0.794294, 0.822054, 0.126198, 0.157518, 0.137033, 0.805918,
0.832059, 0.796301, 0.272992, 0.259331, 0.236476, 0.447218, 0.456312, 0.415336,
0.459163, 0.496104, 0.481119, 0.489643, 0.432933, 0.449918, 0.457812, 0.471702,
0.439231, 0.285285, 0.272284, 0.272463, 0.119506, 0.126271, 0.153495, 0.698480,
0.746884, 0.744545, 0.796329, 0.765671, 0.772101, 0.289531, 0.279684, 0.274122,
0.083425, 0.111131, 0.122636, 0.416887, 0.407965, 0.390117, 0.317052, 0.299901,
0.289338, 0.258466, 0.261500, 0.269478, 0.257404, 0.318316, 0.313711, 0.460231,
0.491365, 0.473438, 0.287031, 0.325613, 0.297418, 0.183008, 0.169461, 0.196137,
0.353484, 0.371690, 0.339467, 0.596034, 0.636998, 0.690025, 0.540484, 0.661089,
0.610133, 0.886139, 0.866919, 0.892331, 0.277185, 0.313711, 0.319566, 0.447996,
0.430319, 0.460608, 0.176088, 0.170885, 0.229467, 0.341395, 0.405147, 0.366888,
0.356223, 0.383648, 0.393102, 0.300565, 0.326214, 0.243194, 0.770807, 0.810081,
0.781504, 0.751134, 0.695834, 0.738234, 0.630142, 0.665757, 0.654953, 0.609388,
0.607408, 0.583936, 0.747156, 0.726543, 0.717894, 0.667794, 0.596034, 0.646821,
0.155077, 0.133348, 0.129167, 0.184829, 0.170885, 0.157428, 0.549551, 0.604023,
0.605560, 0.735735, 0.749456, 0.708542, 0.831767, 0.821680, 0.801087, 0.275771,
0.235484, 0.218457, 0.466103, 0.463370, 0.450517, 0.559030, 0.566259, 0.524684,
0.307583, 0.289118, 0.316622, 0.062742, 0.052430, 0.093822, 0.422883, 0.368636,
0.402505, 0.325361, 0.307004, 0.280367, 0.372619, 0.328466, 0.329567, 0.400051,
0.397164, 0.415288, 0.394988, 0.343245, 0.410063, 0.564095, 0.610088, 0.504703,
0.250462, 0.270711, 0.291522, 0.787269, 0.784998, 0.810967, 0.604023, 0.605695,
0.617629, 0.085860, 0.083801, 0.070201, 0.218529, 0.212486, 0.217262, 0.876168,
0.870155, 0.896184, 0.819424, 0.854535, 0.820921, 0.787784, 0.763421, 0.765326,
0.838767, 0.873121, 0.878491, 0.280367, 0.310304, 0.325361, 0.261993, 0.289338,
0.263604, 0.513199, 0.550963, 0.565763, 0.894179, 0.902666, 0.892331, 0.096651,
0.060317, 0.060639, 0.747156, 0.763925, 0.782083, 0.425322, 0.463535, 0.465692,
0.359351, 0.325235, 0.332633, 0.638263, 0.589554, 0.631309, 0.559030, 0.582895,
0.586674, 0.291522, 0.290366, 0.242070, 0.831866, 0.861663, 0.853521, 0.175795,
0.179851, 0.135315, 0.425355, 0.474040, 0.499590, 0.816672, 0.794432, 0.766941,
0.171066, 0.250542, 0.226522, 0.582895, 0.555168, 0.597492, 0.463370, 0.466103,
0.492002, 0.307899, 0.273441, 0.263373, 0.527654, 0.515305, 0.554974, 0.376408,
0.445071, 0.373943, 0.712992, 0.709277, 0.731895, 0.134102, 0.157356, 0.185453,
0.250772, 0.220812, 0.239044, 0.907863, 0.956279, 0.933134, 0.316159, 0.297082,
0.368293, 0.489643, 0.480711, 0.509841, 0.701082, 0.690471, 0.733132, 0.899946,
0.903339, 0.897268, 0.366139, 0.400475, 0.381946, 0.627239, 0.647894, 0.583223,
0.613554, 0.679118, 0.630140, 0.115560, 0.068052, 0.082868, 0.460231, 0.473438,
0.402637, 0.451049, 0.445384, 0.519549, 0.658621, 0.648228, 0.680843, 0.937753,
0.905782, 0.915210, 0.180233, 0.171919, 0.191775, 0.421147, 0.440272, 0.425355,
0.659045, 0.630140, 0.679118, 0.725852, 0.694624, 0.698480, 0.565763, 0.608505,
0.613554, 0.244180, 0.228841, 0.257395, 0.510504, 0.493276, 0.520223, 0.155026,
0.128281, 0.139367, 0.532285, 0.491116, 0.507273, 0.265296, 0.287031, 0.258570,
0.175578, 0.199143, 0.207846, 0.157319, 0.129375, 0.136867, 0.547905, 0.502329,
0.483307, 0.831866, 0.822054, 0.794294, 0.394999, 0.460231, 0.384555, 0.644969,
0.636094, 0.668252, 0.903931, 0.906711, 0.886139, 0.783585, 0.784791, 0.822470,
0.432933, 0.462058, 0.426686, 0.338602, 0.326401, 0.293548, 0.350250, 0.396979,
0.341396, 0.675481, 0.655092, 0.627239, 0.658307, 0.676168, 0.639236, 0.534010,
0.541267, 0.554868, 0.507273, 0.570846, 0.532285, 0.633641, 0.578529, 0.630140,
0.872443, 0.879609, 0.903600, 0.796301, 0.760612, 0.774570, 0.730430, 0.742919,
0.689192, 0.415673, 0.449728, 0.419902, 0.690351, 0.734006, 0.695312, 0.415250,
0.438617, 0.382792, 0.450487, 0.439240, 0.425550, 0.807182, 0.831767, 0.790337,
0.784791, 0.771874, 0.801087, 0.152224, 0.122156, 0.097494, 0.201502, 0.207821,
0.204130, 0.868577, 0.836184, 0.838130, 0.328377, 0.304359, 0.322510, 0.018270,
0.031488, 0.028737, 0.491116, 0.514925, 0.475048, 0.000000, 0.004520, 0.002168,
0.845505, 0.868577, 0.866919, 0.762070, 0.750599, 0.780386, 0.111550, 0.061170,
0.106780, 0.145539, 0.119054, 0.145011, 0.465560, 0.449947, 0.485480, 0.142736,
0.125831, 0.108113, 0.270711, 0.290392, 0.291522, 0.838130, 0.818932, 0.822054,
0.381266, 0.374762, 0.372015, 0.014463, 0.018270, 0.008619, 0.122636, 0.082401,
0.076893, 0.119147, 0.115385, 0.107887, 0.252910, 0.289118, 0.307583, 0.718524,
0.738234, 0.679118, 0.129375, 0.105162, 0.136867, 0.377577, 0.371606, 0.345041,
0.257399, 0.265006, 0.271545, 0.258721, 0.229031, 0.264950, 0.827275, 0.862020,
0.795950, 0.508709, 0.557470, 0.578529, 0.388320, 0.389980, 0.375802, 0.117877,
0.150604, 0.161091, 0.263604, 0.214731, 0.242776, 0.731895, 0.744093, 0.729944,
0.308759, 0.272992, 0.248804, 0.817982, 0.836814, 0.814712, 0.729944, 0.690423,
0.712992, 0.508197, 0.415673, 0.450603, 0.523986, 0.555168, 0.510421, 0.191398,
0.163743, 0.187528, 0.507240, 0.485480, 0.488834, 0.883655, 0.896168, 0.883802,
0.122272, 0.130056, 0.111577, 0.070201, 0.083801, 0.029919, 0.166217, 0.212253,
0.215637, 0.055574, 0.073843, 0.056584, 0.787012, 0.831866, 0.797006, 0.810081,
0.835893, 0.781504, 0.391402, 0.347695, 0.344388, 0.041064, 0.041235, 0.055687,
0.144488, 0.140539, 0.147816, 0.171521, 0.193385, 0.207199, 0.389639, 0.419902,
0.424796, 0.586674, 0.612866, 0.566259, 0.518498, 0.547905, 0.483307, 0.679263,
0.668252, 0.636094, 0.549822, 0.594847, 0.588527, 0.621453, 0.592040, 0.533886,
0.250542, 0.243232, 0.226522, 0.570229, 0.511180, 0.549125, 0.121067, 0.098519,
0.108113, 0.956279, 0.965094, 0.933134, 0.183278, 0.177065, 0.183331, 0.009716,
0.002168, 0.014670, 0.238461, 0.259582, 0.243294, 0.272921, 0.254020, 0.280367,
0.627634, 0.554486, 0.610088, 0.517353, 0.541988, 0.577673, 0.647719, 0.639236,
0.639116, 0.061977, 0.052430, 0.038875, 0.210230, 0.236476, 0.245694, 0.212253,
0.166217, 0.232663, 0.272284, 0.274122, 0.270878, 0.715630, 0.685996, 0.701172,
0.039066, 0.033398, 0.031488, 0.832942, 0.857797, 0.876336, 0.039041, 0.054383,
0.061977, 0.204779, 0.207750, 0.210428, 0.655092, 0.708542, 0.681575, 0.083801,
0.085860, 0.134281, 0.289531, 0.285285, 0.278425, 0.463312, 0.434064, 0.468944,
0.348984, 0.317865, 0.322360, 0.050739, 0.053028, 0.055307, 0.207846, 0.250462,
0.200101, 0.645059, 0.653123, 0.617629, 0.559030, 0.555168, 0.582895, 0.523950,
0.564095, 0.504703, 0.540484, 0.627634, 0.708112, 0.573387, 0.549551, 0.544108,
0.215637, 0.180994, 0.169850, 0.200403, 0.183331, 0.198222, 0.223601, 0.271980,
0.289118, 0.765671, 0.799406, 0.790092, 0.291604, 0.364613, 0.323338, 0.136291,
0.159618, 0.163743, 0.488570, 0.517129, 0.467914, 0.628705, 0.436581, 0.650959,
0.649638, 0.667833, 0.701172, 0.325816, 0.368293, 0.297082, 0.460231, 0.443090,
0.498887, 0.570823, 0.568211, 0.597211, 0.521247, 0.535876, 0.471167, 0.410561,
0.445384, 0.451049, 0.450487, 0.425550, 0.431850, 0.111550, 0.136152, 0.118150,
0.319522, 0.289338, 0.292679, 0.493276, 0.456695, 0.520223, 0.710231, 0.695035,
0.682955, 0.664103, 0.640364, 0.612835, 0.787784, 0.802061, 0.763421, 0.321807,
0.348984, 0.396954, 0.147495, 0.151126, 0.139367, 0.285285, 0.234054, 0.246565,
0.638263, 0.654580, 0.614643, 0.186107, 0.212701, 0.201833, 0.423587, 0.454052,
0.450273, 0.278367, 0.287918, 0.284215, 0.831767, 0.864720, 0.858135, 0.718103,
0.679958, 0.682425, 0.085860, 0.070201, 0.067910, 0.301835, 0.300106, 0.331559,
0.318394, 0.347695, 0.318316, 0.136288, 0.160252, 0.147329, 0.306406, 0.304939,
0.330398, 0.639236, 0.676168, 0.619235, 0.043543, 0.044084, 0.034118, 0.297050,
0.297210, 0.304538, 0.175795, 0.215721, 0.179851, 0.744665, 0.723462, 0.755606,
0.895348, 0.907863, 0.933134, 0.789995, 0.805918, 0.760369, 0.136059, 0.158722,
0.134102, 0.583854, 0.565892, 0.517645, 0.325235, 0.303284, 0.291477, 0.502876,
0.402505, 0.435301, 0.532285, 0.594847, 0.549822, 0.628765, 0.622487, 0.610057,
0.105721, 0.115385, 0.119147, 0.450517, 0.463370, 0.405147, 0.907820, 0.874150,
0.876336, 0.647434, 0.698480, 0.672124, 0.139182, 0.151640, 0.165961, 0.083003,
0.065756, 0.072419, 0.147495, 0.131647, 0.130673, 0.425355, 0.437618, 0.393652,
0.283059, 0.257404, 0.313711, 0.104665, 0.119506, 0.068900, 0.419902, 0.389639,
0.375954, 0.200811, 0.247062, 0.258570, 0.295273, 0.272773, 0.230603, 0.104665,
0.115437, 0.126271, 0.717621, 0.754377, 0.742296, 0.464460, 0.518682, 0.507273,
0.191716, 0.161091, 0.223757, 0.229467, 0.246565, 0.234054, 0.402325, 0.365777,
0.364935, 0.187528, 0.175578, 0.211525, 0.504956, 0.585908, 0.533886, 0.320496,
0.371606, 0.344388, 0.245707, 0.247749, 0.271928, 0.389262, 0.440866, 0.400444,
0.210428, 0.207750, 0.208976, 0.483307, 0.502329, 0.471702, 0.543470, 0.508709,
0.482229, 0.280367, 0.254020, 0.256877, 0.232928, 0.211825, 0.209062, 0.471167,
0.454052, 0.439240, 0.139182, 0.105702, 0.103138, 0.365621, 0.424268, 0.410561,
0.389980, 0.415955, 0.409951, 0.554486, 0.540484, 0.502852, 0.648228, 0.658621,
0.610088, 0.647894, 0.698308, 0.653134, 0.691897, 0.685996, 0.742528, 0.986422,
0.999897, 0.980041, 0.215001, 0.204084, 0.257404, 0.165585, 0.162620, 0.184786,
0.338602, 0.330137, 0.394999, 0.375673, 0.401073, 0.402212, 0.372619, 0.380367,
0.406059, 0.289338, 0.319522, 0.317052, 0.131028, 0.110613, 0.105702, 0.986422,
0.988882, 0.999897, 0.696334, 0.690025, 0.726055, 0.456695, 0.491312, 0.523420,
0.388851, 0.435369, 0.449918, 0.271671, 0.291244, 0.270711, 0.618556, 0.601031,
0.612866, 0.325348, 0.366139, 0.308446, 0.703699, 0.708112, 0.627634, 0.903600,
0.879609, 0.892481, 0.622487, 0.682425, 0.665757, 0.287918, 0.266636, 0.314572,
0.300565, 0.382792, 0.326214, 0.374762, 0.329118, 0.372015, 0.183044, 0.201833,
0.196781, 0.269620, 0.267529, 0.235484, 0.158739, 0.140539, 0.144488, 0.616173,
0.635643, 0.579020, 0.853543, 0.877638, 0.855510, 0.754595, 0.745096, 0.771874,
0.632058, 0.657824, 0.661429, 0.925306, 0.862535, 0.861269, 0.271928, 0.290068,
0.294665, 0.619235, 0.648521, 0.607930, 0.511180, 0.547905, 0.549125, 0.707913,
0.664660, 0.680487, 0.790115, 0.822054, 0.818932, 0.519837, 0.506819, 0.532699,
0.460608, 0.451049, 0.495262, 0.915210, 0.958511, 0.937753, 0.369412, 0.382873,
0.400374, 0.439231, 0.471702, 0.424715, 0.886968, 0.894179, 0.853521, 0.857797,
0.832942, 0.822984, 0.870155, 0.883802, 0.896184, 0.883802, 0.903339, 0.896184,
0.721808, 0.762070, 0.741477, 0.790115, 0.796495, 0.782083, 0.525618, 0.578529,
0.564025, 0.937753, 0.952257, 0.905782, 0.891044, 0.899946, 0.886152, 0.272773,
0.325816, 0.297082, 0.008620, 0.023890, 0.031488, 0.433740, 0.533886, 0.508507,
0.782844, 0.830482, 0.831131, 0.226536, 0.241931, 0.255732, 0.638187, 0.654953,
0.664660, 0.690423, 0.672355, 0.676168, 0.718524, 0.679118, 0.698308, 0.695834,
0.679118, 0.738234, 0.162620, 0.165585, 0.145011, 0.283059, 0.313711, 0.277185,
0.255518, 0.226720, 0.250772, 0.186107, 0.167723, 0.191716, 0.266232, 0.281120,
0.304927, 0.762123, 0.797006, 0.794294, 0.290366, 0.291522, 0.318593, 0.137033,
0.185348, 0.134281, 0.636998, 0.576543, 0.595833, 0.614104, 0.559812, 0.596259,
0.539959, 0.583936, 0.585908, 0.261686, 0.260780, 0.255455, 0.122131, 0.173902,
0.131769, 0.318593, 0.312554, 0.290366, 0.891044, 0.870495, 0.875930, 0.446927,
0.442058, 0.468371, 0.543996, 0.545724, 0.554868, 0.377577, 0.345041, 0.383062,
0.169850, 0.180994, 0.147816, 0.865504, 0.857281, 0.836814, 0.718524, 0.698308,
0.668522, 0.465692, 0.396954, 0.407807, 0.702787, 0.672592, 0.685836, 0.321807,
0.313560, 0.317865, 0.278367, 0.273693, 0.287918, 0.482315, 0.437638, 0.456695,
0.372928, 0.415250, 0.382792, 0.258570, 0.247062, 0.256844, 0.103917, 0.084134,
0.117953, 0.735735, 0.732388, 0.768233, 0.252276, 0.234882, 0.257893, 0.890424,
0.873498, 0.849437, 0.038466, 0.017326, 0.028898, 0.350924, 0.319566, 0.367428,
0.033510, 0.056584, 0.023391, 0.706525, 0.664103, 0.695622, 0.406304, 0.383051,
0.388639, 0.931489, 0.923491, 0.954192, 0.862020, 0.827275, 0.895348, 0.765671,
0.796329, 0.799406, 0.517873, 0.520424, 0.498887, 0.449155, 0.432501, 0.424410,
0.174866, 0.198961, 0.209723, 0.555451, 0.508323, 0.489104, 0.570823, 0.597211,
0.583223, 0.052430, 0.062742, 0.042677, 0.534217, 0.549640, 0.545724, 0.543996,
0.498182, 0.517129, 0.107887, 0.121067, 0.119147, 0.017281, 0.029919, 0.050200,
0.059926, 0.032299, 0.111550, 0.661429, 0.657824, 0.685836, 0.904429, 0.873121,
0.873498, 0.152728, 0.157591, 0.141556, 0.068900, 0.119506, 0.103142, 0.397164,
0.396979, 0.415288, 0.329118, 0.356736, 0.331559, 0.147329, 0.183858, 0.128893,
0.272921, 0.261993, 0.247371, 0.907820, 0.952257, 0.945264, 0.063041, 0.055687,
0.041235, 0.027411, 0.048564, 0.019200, 0.034096, 0.038223, 0.061170, 0.064079,
0.093035, 0.106780, 0.137033, 0.134281, 0.108088, 0.180424, 0.234452, 0.241130,
0.054848, 0.046770, 0.070072, 0.860707, 0.845505, 0.866919, 0.693910, 0.690025,
0.641742, 0.456496, 0.420207, 0.434562, 0.350809, 0.341396, 0.374238, 0.510504,
0.520223, 0.534010, 0.269790, 0.200403, 0.226094, 0.520424, 0.517873, 0.534217,
0.648228, 0.644696, 0.680843, 0.597211, 0.623525, 0.630887, 0.813323, 0.832059,
0.831866, 0.465692, 0.617808, 0.623405, 0.383081, 0.404884, 0.393652, 0.165585,
0.145539, 0.145011, 0.466539, 0.485147, 0.435301, 0.319522, 0.307004, 0.325361,
0.407374, 0.415440, 0.441477, 0.886152, 0.899946, 0.897268, 0.694624, 0.657824,
0.672124, 0.680487, 0.707568, 0.707913, 0.449947, 0.427524, 0.415336, 0.059926,
0.027411, 0.032299, 0.319566, 0.312764, 0.277185, 0.700462, 0.679549, 0.722228,
0.654580, 0.638263, 0.677325, 0.464453, 0.518682, 0.464460, 0.854535, 0.822470,
0.870495, 0.746191, 0.743288, 0.718103, 0.228841, 0.213668, 0.204899, 0.672592,
0.648611, 0.661429, 0.408120, 0.432501, 0.434290, 0.117953, 0.159618, 0.136291,
0.318316, 0.257404, 0.267659, 0.524392, 0.495362, 0.495262, 0.391402, 0.344388,
0.423587, 0.648521, 0.621453, 0.607930, 0.945264, 0.901348, 0.907820, 0.467914,
0.440866, 0.397090, 0.364709, 0.383051, 0.371690, 0.402561, 0.356223, 0.393102,
0.230281, 0.208442, 0.236232, 0.021532, 0.039066, 0.024042, 0.330137, 0.338602,
0.309703, 0.925669, 0.862020, 0.895348, 0.442058, 0.434290, 0.447042, 0.083425,
0.056243, 0.076945, 0.542113, 0.568211, 0.509841, 0.123429, 0.117953, 0.136291,
0.275771, 0.297082, 0.295221, 0.818187, 0.822984, 0.832942, 0.103117, 0.089460,
0.106621, 0.807182, 0.787728, 0.834972, 0.995037, 0.990491, 0.999897, 0.223601,
0.215176, 0.210919, 0.280870, 0.259620, 0.276850, 0.628356, 0.588527, 0.594847,
0.259620, 0.212496, 0.276850, 0.855510, 0.829821, 0.853543, 0.630696, 0.692164,
0.583854, 0.136059, 0.123427, 0.171066, 0.559812, 0.524392, 0.596259, 0.416679,
0.354587, 0.420207, 0.194624, 0.191547, 0.177065, 0.218377, 0.200403, 0.243784,
0.218457, 0.272773, 0.275771, 0.057587, 0.068900, 0.023391, 0.592040, 0.644757,
0.617808, 0.291522, 0.240294, 0.250462, 0.632058, 0.609302, 0.605560, 0.156933,
0.189917, 0.198961, 0.653284, 0.657892, 0.685996, 0.422883, 0.443090, 0.368636,
0.659045, 0.679549, 0.633641, 0.393491, 0.377577, 0.383062, 0.434562, 0.354587,
0.402561, 0.723462, 0.700462, 0.722228, 0.685836, 0.725852, 0.731678, 0.415440,
0.373943, 0.430319, 0.862535, 0.925306, 0.907863, 0.495362, 0.541988, 0.517353,
0.782844, 0.801533, 0.830482, 0.180368, 0.165961, 0.155026, 0.166252, 0.136152,
0.124605, 0.781504, 0.835893, 0.827275, 0.226094, 0.200403, 0.198222, 0.580970,
0.519549, 0.555451, 0.365728, 0.328466, 0.372619, 0.861663, 0.872626, 0.886968,
0.557669, 0.563112, 0.546101, 0.913484, 0.951570, 0.906711, 0.319566, 0.313711,
0.367428, 0.608505, 0.565763, 0.590833, 0.718524, 0.754595, 0.784791, 0.131028,
0.105702, 0.139182, 0.464453, 0.508015, 0.518682, 0.310944, 0.308759, 0.248804,
0.633641, 0.679549, 0.663953, 0.419947, 0.399199, 0.425550, 0.207821, 0.201502,
0.210035, 0.796495, 0.790115, 0.818932, 0.460608, 0.445071, 0.451049, 0.300565,
0.243194, 0.280962, 0.541267, 0.520223, 0.523420, 0.732388, 0.694974, 0.729756,
0.312554, 0.327978, 0.353241, 0.689192, 0.742919, 0.720886, 0.638263, 0.577673,
0.589554, 0.831767, 0.834972, 0.864720, 0.854284, 0.872626, 0.861663, 0.698480,
0.694624, 0.672124, 0.254854, 0.219479, 0.200811, 0.802061, 0.828907, 0.822984,
0.554868, 0.541267, 0.543996, 0.214694, 0.211525, 0.247749, 0.554974, 0.576543,
0.596034, 0.086182, 0.115437, 0.104665, 0.322510, 0.335536, 0.340809, 0.361018,
0.378484, 0.389980, 0.676406, 0.639236, 0.658382, 0.708728, 0.706525, 0.730200,
0.042677, 0.031173, 0.038875, 0.902666, 0.903931, 0.886139, 0.257399, 0.211715,
0.202377, 0.668522, 0.681575, 0.710701, 0.525423, 0.568211, 0.570823, 0.104665,
0.068900, 0.057587, 0.136651, 0.129167, 0.110613, 0.017326, 0.038466, 0.021595,
0.860707, 0.832168, 0.845505, 0.503279, 0.522223, 0.545724, 0.522191, 0.467252,
0.506819, 0.545724, 0.522223, 0.534217, 0.105348, 0.102751, 0.136288, 0.014670,
0.022560, 0.009716, 0.287031, 0.259582, 0.297050, 0.687951, 0.664103, 0.706525,
0.213953, 0.209489, 0.199299, 0.435369, 0.509841, 0.449918, 0.119506, 0.153495,
0.135315, 0.317052, 0.319522, 0.347555, 0.294665, 0.308048, 0.271928, 0.878491,
0.873121, 0.923491, 0.269790, 0.314085, 0.268101, 0.590833, 0.583223, 0.647894,
0.212486, 0.218529, 0.208976, 0.952257, 0.907820, 0.905782, 0.519549, 0.508323,
0.555451, 0.585908, 0.607408, 0.619235, 0.821680, 0.831767, 0.858135, 0.511180,
0.488834, 0.456312, 0.212496, 0.181556, 0.244043, 0.369290, 0.380367, 0.338818,
0.902666, 0.906539, 0.903931, 0.214184, 0.175518, 0.214731, 0.359351, 0.332633,
0.361724, 0.463535, 0.592040, 0.617808, 0.009716, 0.000000, 0.002168, 0.326759,
0.314085, 0.346621, 0.794432, 0.749709, 0.766941, 0.335536, 0.322510, 0.316159,
0.542449, 0.519837, 0.532699, 0.236612, 0.227558, 0.223627, 0.162620, 0.167723,
0.186107, 0.496807, 0.454052, 0.517378, 0.701172, 0.635643, 0.649638, 0.157356,
0.158722, 0.216210, 0.119147, 0.126271, 0.115437, 0.622256, 0.612835, 0.580970,
0.250772, 0.226720, 0.201414, 0.245694, 0.257404, 0.228206, 0.742919, 0.730430,
0.770807, 0.158277, 0.157518, 0.128893, 0.245694, 0.236476, 0.259331, 0.244180,
0.240753, 0.213668, 0.357442, 0.383648, 0.356223, 0.221511, 0.183008, 0.196137,
0.415440, 0.407374, 0.384427, 0.244043, 0.226720, 0.255518, 0.743288, 0.762866,
0.739370, 0.645516, 0.655287, 0.682955, 0.664103, 0.666252, 0.695622, 0.023391,
0.062694, 0.041356, 0.353241, 0.308048, 0.312554, 0.256877, 0.308048, 0.310304,
0.410561, 0.451049, 0.445071, 0.086182, 0.057587, 0.056584, 0.449728, 0.450589,
0.424796, 0.194624, 0.183278, 0.218377, 0.522223, 0.520424, 0.534217, 0.316622,
0.376066, 0.375723, 0.364613, 0.384555, 0.390538, 0.376408, 0.373943, 0.350647,
0.189917, 0.209489, 0.214415, 0.193385, 0.171861, 0.188356, 0.554868, 0.549640,
0.534010, 0.498182, 0.467914, 0.517129, 0.369412, 0.410779, 0.368293, 0.744665,
0.760612, 0.730200, 0.819424, 0.820921, 0.789995, 0.822984, 0.780386, 0.802061,
0.153376, 0.161091, 0.191716, 0.647434, 0.672124, 0.657824, 0.329567, 0.380367,
0.372619, 0.325613, 0.350809, 0.352412, 0.429074, 0.402561, 0.413380, 0.374762,
0.381266, 0.413255, 0.873498, 0.873121, 0.849437, 0.149297, 0.165585, 0.184786,
0.861269, 0.810081, 0.874150, 0.390117, 0.407965, 0.393491, 0.297050, 0.259582,
0.252493, 0.252493, 0.270964, 0.297050, 0.751940, 0.726055, 0.768253, 0.452405,
0.414392, 0.436581, 0.491365, 0.401938, 0.473438, 0.384427, 0.394474, 0.377079,
0.216210, 0.247062, 0.185453, 0.610088, 0.564095, 0.648228, 0.545724, 0.549640,
0.554868, 0.040285, 0.055687, 0.056970, 0.659510, 0.691614, 0.645059, 0.325613,
0.327178, 0.350809, 0.602835, 0.563112, 0.569381, 0.322510, 0.295416, 0.316159,
0.905782, 0.857797, 0.915210, 0.463370, 0.492002, 0.493488, 0.194624, 0.218377,
0.209062, 0.597211, 0.630887, 0.627239, 0.669213, 0.628765, 0.635643, 0.187528,
0.211525, 0.214694, 0.111577, 0.104422, 0.107887, 0.434562, 0.502852, 0.540484,
0.873121, 0.822873, 0.816672, 0.499590, 0.539959, 0.504956, 0.995037, 1.000000,
0.980341, 0.311923, 0.318888, 0.331838, 0.525618, 0.564025, 0.555451, 0.306406,
0.248804, 0.249449, 0.423587, 0.344388, 0.371606, 0.160701, 0.149297, 0.182277,
0.119054, 0.120580, 0.145011, 0.383648, 0.431797, 0.435492, 0.052430, 0.061977,
0.084794, 0.706525, 0.708728, 0.687951, 0.648521, 0.676168, 0.672355, 0.892481,
0.908009, 0.903600, 0.208976, 0.189490, 0.212486, 0.793081, 0.743288, 0.775955,
0.060639, 0.060317, 0.020235, 0.122952, 0.088239, 0.100250, 0.904429, 0.925669,
0.956981, 0.810967, 0.784998, 0.814136, 0.196781, 0.201833, 0.205273, 0.769420,
0.746191, 0.730216, 0.255732, 0.266232, 0.226536, 0.238251, 0.250542, 0.171066,
0.449728, 0.508709, 0.525618, 0.295221, 0.286034, 0.269620, 0.273693, 0.257893,
0.287918, 0.357442, 0.336175, 0.359351, 0.179851, 0.131648, 0.135315, 0.546101,
0.532285, 0.507240, 0.191659, 0.239044, 0.220812, 0.101651, 0.111502, 0.128281,
0.540484, 0.510617, 0.434562, 0.754377, 0.733132, 0.742296, 0.135535, 0.139182,
0.103138, 0.569381, 0.579020, 0.602835, 0.565763, 0.550963, 0.590833, 0.131648,
0.179851, 0.150596, 0.744093, 0.749709, 0.729944, 0.644969, 0.607408, 0.609388,
0.460231, 0.394999, 0.443090, 0.429428, 0.476282, 0.406304, 0.805918, 0.774570,
0.755606, 0.180233, 0.191775, 0.204779, 0.242776, 0.209723, 0.261993, 0.295221,
0.295416, 0.286034, 0.280367, 0.256877, 0.310304, 0.285285, 0.272463, 0.265006,
0.055574, 0.034878, 0.054848, 0.212486, 0.171652, 0.186252, 0.307306, 0.318048,
0.344431, 0.214415, 0.254020, 0.198961, 0.712992, 0.690423, 0.676168, 0.762070,
0.721808, 0.750599, 0.018270, 0.013992, 0.008619, 0.291244, 0.314948, 0.290392,
0.023890, 0.008620, 0.022560, 0.297858, 0.266636, 0.238701, 0.836184, 0.793081,
0.804236, 0.601739, 0.596034, 0.667794, 0.835893, 0.907863, 0.827275, 0.327178,
0.304538, 0.331838, 0.876168, 0.831131, 0.830482, 0.112623, 0.150596, 0.173902,
0.194113, 0.204899, 0.180936, 0.534010, 0.549640, 0.530398, 0.226094, 0.314085,
0.269790, 0.099509, 0.105348, 0.128893, 0.226522, 0.231228, 0.216210, 0.925306,
0.956279, 0.907863, 1.000000, 0.968534, 0.980341, 0.540484, 0.574168, 0.535529,
0.308048, 0.350647, 0.310304, 0.750599, 0.715801, 0.763421, 0.467914, 0.498182,
0.491312, 0.874150, 0.901348, 0.919383, 0.205938, 0.205198, 0.191775, 0.391130,
0.411320, 0.380367, 0.325348, 0.361018, 0.366139, 0.868577, 0.845505, 0.836184,
0.122272, 0.111577, 0.115385, 0.289531, 0.262201, 0.279684, 0.449918, 0.480711,
0.489643, 0.450589, 0.449728, 0.489104, 0.327978, 0.365621, 0.353241, 0.455370,
0.429664, 0.427948, 0.510421, 0.524684, 0.529819, 0.189917, 0.166252, 0.199299,
0.750599, 0.802061, 0.780386, 0.038223, 0.034096, 0.014245, 0.314085, 0.383081,
0.388320, 0.465560, 0.485480, 0.481583, 0.754595, 0.718524, 0.745096, 0.171521,
0.207199, 0.182873, 0.872443, 0.855508, 0.879609, 0.242070, 0.240294, 0.291522,
0.854535, 0.819424, 0.822470, 0.257399, 0.222270, 0.265006, 0.180936, 0.183331,
0.177065, 0.423587, 0.371606, 0.393491, 0.517378, 0.554974, 0.496807, 0.301835,
0.280870, 0.300106, 0.259582, 0.287031, 0.265296, 0.223601, 0.238701, 0.215176,
0.667794, 0.630887, 0.623525, 0.519549, 0.558963, 0.524392, 0.768253, 0.734006,
0.731678, 0.439240, 0.454052, 0.419947, 0.256877, 0.214415, 0.209489, 0.813323,
0.787012, 0.782444, 0.153495, 0.126271, 0.139910, 0.390538, 0.402637, 0.323338,
0.700462, 0.695622, 0.666252, 0.677325, 0.701515, 0.717894, 0.639116, 0.639236,
0.607408, 0.244180, 0.269104, 0.240753, 0.136867, 0.105162, 0.102224, 0.436416,
0.423587, 0.450273, 0.495362, 0.524392, 0.541988, 0.269620, 0.235484, 0.275771,
0.802061, 0.750599, 0.763421, 0.154451, 0.166217, 0.147816, 0.886968, 0.897268,
0.894179, 0.396979, 0.374238, 0.341396, 0.399910, 0.371690, 0.383051, 0.619235,
0.607408, 0.639236, 0.512288, 0.549822, 0.521247, 0.650959, 0.690423, 0.696166,
0.445384, 0.410561, 0.424268, 0.419902, 0.449728, 0.424796, 0.171066, 0.158722,
0.136059, 0.060639, 0.020235, 0.041356, 0.364613, 0.390538, 0.323338, 0.462058,
0.460972, 0.426686, 0.517378, 0.535876, 0.576543, 0.269790, 0.261500, 0.243784,
0.056838, 0.035538, 0.044084, 0.291245, 0.286034, 0.295416, 0.210230, 0.183858,
0.249449, 0.277571, 0.297418, 0.304939, 0.422951, 0.407965, 0.416887, 0.059520,
0.051793, 0.067910, 0.744545, 0.731678, 0.725852, 0.801087, 0.821680, 0.784791,
0.350809, 0.397164, 0.352412, 0.325361, 0.347555, 0.319522, 0.585908, 0.504956,
0.539959, 0.466539, 0.463370, 0.493488, 0.543996, 0.523420, 0.498182, 0.527654,
0.542113, 0.509841, 0.504703, 0.610088, 0.554486, 0.471702, 0.511180, 0.456312,
0.247749, 0.290366, 0.290068, 0.020235, 0.024828, 0.021532, 0.222270, 0.257399,
0.202377, 0.582407, 0.593931, 0.546468, 0.353241, 0.365621, 0.398565, 0.559030,
0.586674, 0.566259, 0.136867, 0.102224, 0.123429, 0.678326, 0.685996, 0.691897,
0.583936, 0.605737, 0.609388, 0.467252, 0.468371, 0.506819, 0.171861, 0.152728,
0.142736, 0.832712, 0.836814, 0.857281, 0.014918, 0.035538, 0.029590, 0.838767,
0.835044, 0.814136, 0.213953, 0.247749, 0.245707, 0.787784, 0.783132, 0.802639,
0.710296, 0.691897, 0.746191, 0.355487, 0.372015, 0.344431, 0.117727, 0.075020,
0.083801, 0.450589, 0.445384, 0.424268, 0.618556, 0.654953, 0.638187, 0.439231,
0.441477, 0.457812, 0.389987, 0.361724, 0.356736, 0.184829, 0.157428, 0.147816,
0.236612, 0.258578, 0.261686, 0.255455, 0.227558, 0.236612, 0.122131, 0.112623,
0.173902, 0.336175, 0.356223, 0.303947, 0.570846, 0.594847, 0.532285, 0.399199,
0.393491, 0.407965, 0.043543, 0.034118, 0.033398, 0.432501, 0.447042, 0.434290,
0.415336, 0.427524, 0.411089, 0.230281, 0.258578, 0.223627, 0.210428, 0.211002,
0.201400, 0.122272, 0.131647, 0.130056, 0.263713, 0.234054, 0.285285, 0.204779,
0.201400, 0.182277, 0.393652, 0.404884, 0.425355, 0.291245, 0.304359, 0.291244,
0.376769, 0.396954, 0.348984, 0.415336, 0.402325, 0.377079, 0.223757, 0.181400,
0.185348, 0.593931, 0.657182, 0.605737, 0.204779, 0.210428, 0.201400, 0.406304,
0.388639, 0.400652, 0.853543, 0.872443, 0.877638, 0.215001, 0.205936, 0.191794,
0.105348, 0.087683, 0.102751, 0.836184, 0.804236, 0.818932, 0.679958, 0.680487,
0.654953, 0.208976, 0.207750, 0.189490, 0.689192, 0.657182, 0.656974, 0.488570,
0.503279, 0.517129, 0.605695, 0.549551, 0.573387, 0.211229, 0.219418, 0.244939,
0.896184, 0.868757, 0.876168, 0.285757, 0.249449, 0.254854, 0.593931, 0.627850,
0.657182, 0.171521, 0.182873, 0.157591, 0.690423, 0.717621, 0.696166, 0.580476,
0.610057, 0.622487, 0.229467, 0.230891, 0.240943, 0.271545, 0.272463, 0.272284,
0.630142, 0.622487, 0.665757, 0.613554, 0.543470, 0.565763, 0.763925, 0.790115,
0.782083, 0.226536, 0.219418, 0.212701, 0.610133, 0.597639, 0.540484, 0.242070,
0.247749, 0.211525, 0.687951, 0.701515, 0.677640, 0.297210, 0.317865, 0.313560,
0.126198, 0.128893, 0.157518, 0.296681, 0.271545, 0.282815, 0.585908, 0.619235,
0.607930, 0.029919, 0.075020, 0.050200, 0.045549, 0.032073, 0.050739, 0.239044,
0.214731, 0.263604, 0.442058, 0.447042, 0.468371, 0.775955, 0.782884, 0.804236,
0.892481, 0.955312, 0.908009, 0.456695, 0.523420, 0.520223, 0.510504, 0.492002,
0.482315, 0.462058, 0.432933, 0.489643, 0.102224, 0.081621, 0.103917, 0.389987,
0.356736, 0.374762, 0.774570, 0.805918, 0.796301, 0.125831, 0.121067, 0.108113,
0.534217, 0.530398, 0.549640, 0.124605, 0.111550, 0.106780, 0.205936, 0.215001,
0.250030, 0.093822, 0.117867, 0.107522, 0.559812, 0.589554, 0.541988, 0.422951,
0.464460, 0.407965, 0.831866, 0.787012, 0.813323, 0.690423, 0.650959, 0.608630,
0.396954, 0.608630, 0.321807, 0.081621, 0.054280, 0.056838, 0.495418, 0.462058,
0.489643, 0.970637, 0.978126, 0.952257, 0.464460, 0.491116, 0.475048, 0.368636,
0.343245, 0.402505, 0.278425, 0.285285, 0.246565, 0.491365, 0.498887, 0.520424,
0.136651, 0.164033, 0.129167, 0.329567, 0.328466, 0.321807, 0.847703, 0.870155,
0.876168, 0.586674, 0.597492, 0.612866, 0.383081, 0.354587, 0.403596, 0.988882,
0.990335, 1.000000, 0.886152, 0.860374, 0.870495, 0.117727, 0.134281, 0.150604,
0.381266, 0.411089, 0.413255, 0.854284, 0.831866, 0.832059, 0.200101, 0.175578,
0.207846, 0.244043, 0.255518, 0.284845, 0.277185, 0.230603, 0.250030, 0.805918,
0.820921, 0.832059, 0.518851, 0.502876, 0.530398, 0.831866, 0.794294, 0.797006,
0.533886, 0.585908, 0.621453, 0.653134, 0.698308, 0.679118, 0.818187, 0.832942,
0.874150, 0.165371, 0.164033, 0.195485, 0.175578, 0.200101, 0.211525, 0.508015,
0.467252, 0.522191, 0.838130, 0.853521, 0.868577, 0.102224, 0.105162, 0.086810,
0.987043, 0.990491, 0.995037, 0.645059, 0.617629, 0.636057, 0.108088, 0.134281,
0.085860, 0.483991, 0.506819, 0.468371, 0.325235, 0.359351, 0.336175, 0.748268,
0.708112, 0.703699, 0.810995, 0.793081, 0.836184, 0.207199, 0.213945, 0.210035,
0.904429, 0.945245, 0.923491, 0.144488, 0.176088, 0.185508, 0.361595, 0.330403,
0.330398, 0.523022, 0.523950, 0.502813, 0.240294, 0.242070, 0.200101, 0.257404,
0.245694, 0.267659, 0.147607, 0.123427, 0.140734, 0.153495, 0.175795, 0.135315,
0.485147, 0.530398, 0.502876, 0.200478, 0.186252, 0.180368, 0.213953, 0.245707,
0.247558, 0.266636, 0.257893, 0.238701, 0.641742, 0.595833, 0.648611, 0.722228,
0.760369, 0.755606, 0.523022, 0.601031, 0.602318, 0.929159, 0.893999, 0.906711,
0.990491, 0.980041, 0.999897, 0.680644, 0.689192, 0.679263, 0.899946, 0.891044,
0.896184, 0.262201, 0.289531, 0.251030, 0.703699, 0.627634, 0.658621, 0.383648,
0.435492, 0.393102, 0.679263, 0.689192, 0.720886, 0.440866, 0.456695, 0.400444,
0.793081, 0.775955, 0.804236, 0.715801, 0.707913, 0.737869, 0.322360, 0.362501,
0.342957, 0.255455, 0.236612, 0.261686, 0.208442, 0.173902, 0.150596, 0.130673,
0.145539, 0.149297, 0.593071, 0.597492, 0.555168, 0.402325, 0.411089, 0.372015,
0.696130, 0.667794, 0.646821, 0.790337, 0.801087, 0.771874, 0.517767, 0.492002,
0.510504, 0.968534, 0.990335, 0.956981, 0.258578, 0.236232, 0.252276, 0.076893,
0.082401, 0.055307, 0.544330, 0.628705, 0.630696, 0.232663, 0.322360, 0.297210,
0.912957, 0.959850, 0.953828, 0.729944, 0.749709, 0.751856, 0.227558, 0.250462,
0.207846, 0.105702, 0.098519, 0.103138, 0.977413, 0.959850, 0.955312, 0.234452,
0.180424, 0.259620, 0.184786, 0.162620, 0.183044, 0.433740, 0.476282, 0.504956,
0.659510, 0.645516, 0.682955, 0.391402, 0.435369, 0.388851, 0.555168, 0.532285,
0.580476, 0.223757, 0.161091, 0.181400, 0.691897, 0.710296, 0.678326, 0.147816,
0.157428, 0.141807, 0.449155, 0.472974, 0.483991, 0.608505, 0.590833, 0.647894,
0.601031, 0.566259, 0.612866, 0.554974, 0.515305, 0.496807, 0.569381, 0.557669,
0.579020, 0.381643, 0.401308, 0.390117, 0.028898, 0.023890, 0.034878, 0.980341,
0.956279, 0.978126, 0.191659, 0.214184, 0.239044, 0.209497, 0.207750, 0.204779,
0.136332, 0.145011, 0.120580, 0.790115, 0.763925, 0.794294, 0.130305, 0.136288,
0.102751, 0.393491, 0.383062, 0.390117, 0.772310, 0.862020, 0.849437, 0.183858,
0.200811, 0.219479, 0.072419, 0.065756, 0.062742, 0.955066, 0.931489, 0.954192,
0.110613, 0.131028, 0.136651, 0.555168, 0.524684, 0.510421, 0.597492, 0.622487,
0.630142, 0.117953, 0.164119, 0.159618, 0.084134, 0.103917, 0.081621, 0.291244,
0.328377, 0.314948, 0.155077, 0.171861, 0.142736, 0.235484, 0.267529, 0.241931,
0.045549, 0.055307, 0.063041, 0.737869, 0.765326, 0.763421, 0.466103, 0.450517,
0.437638, 0.666252, 0.664103, 0.612835, 0.784998, 0.751856, 0.794432, 0.064079,
0.055904, 0.093035, 0.580476, 0.602835, 0.610057, 0.196137, 0.169461, 0.188698,
0.730216, 0.746191, 0.691897, 0.471702, 0.447218, 0.424715, 0.702787, 0.690351,
0.648611, 0.475048, 0.450487, 0.431850, 0.477339, 0.463312, 0.504703, 0.055307,
0.056243, 0.076893, 0.822054, 0.853521, 0.838130, 0.751856, 0.717621, 0.729944,
0.240294, 0.200101, 0.250462, 0.452405, 0.532548, 0.476009, 0.663953, 0.622256,
0.633641, 0.122636, 0.134102, 0.160252, 0.102751, 0.160252, 0.130305, 0.327978,
0.362706, 0.365621, 0.605695, 0.636057, 0.617629, 0.146325, 0.152224, 0.107522,
0.273693, 0.278367, 0.258578, 0.406304, 0.476282, 0.433740, 0.051793, 0.039531,
0.040285, 0.100250, 0.088239, 0.070072, 0.890424, 0.925669, 0.904429, 0.965094,
0.956279, 0.980341, 0.577673, 0.638263, 0.614643, 0.907820, 0.876336, 0.905782,
0.580476, 0.563112, 0.602835, 0.570823, 0.583223, 0.525423, 0.822470, 0.858135,
0.875930, 0.618134, 0.654580, 0.667833, 0.891044, 0.875930, 0.896184, 0.251030,
0.278425, 0.246565, 0.796301, 0.832059, 0.813323, 0.255732, 0.241931, 0.267529,
0.830482, 0.801533, 0.847703, 0.240943, 0.243232, 0.251030, 0.271671, 0.278367,
0.284215, 0.782444, 0.787012, 0.734798, 0.106780, 0.093035, 0.105162, 0.741477,
0.703699, 0.721808, 0.327178, 0.341396, 0.350809, 0.581821, 0.636057, 0.605695,
0.051793, 0.059520, 0.054990, 0.056243, 0.053028, 0.082574, 0.111502, 0.104422,
0.111577, 0.136332, 0.167723, 0.162620, 0.710231, 0.745091, 0.695035, 0.680843,
0.721808, 0.658621, 0.580970, 0.612835, 0.558963, 0.605560, 0.657824, 0.632058,
0.747156, 0.782083, 0.742528, 0.008619, 0.014245, 0.013066, 0.121067, 0.104422,
0.098519, 0.189490, 0.178567, 0.155077, 0.749456, 0.771874, 0.745096, 0.350647,
0.308048, 0.353241, 0.335536, 0.389639, 0.362706, 0.291604, 0.326401, 0.364613,
0.644969, 0.639116, 0.607408, 0.405147, 0.410063, 0.366888, 0.061977, 0.038875,
0.039041, 0.021532, 0.024042, 0.017326, 0.311923, 0.304538, 0.297210, 0.638263,
0.677640, 0.677325, 0.435301, 0.485147, 0.502876, 0.136332, 0.162620, 0.145011,
0.323338, 0.401938, 0.281120, 0.177801, 0.146386, 0.157319, 0.306406, 0.288309,
0.304939, 0.053028, 0.050739, 0.053344, 0.211825, 0.232928, 0.191547, 0.829821,
0.799406, 0.811719, 0.020235, 0.023391, 0.041356, 0.822054, 0.831866, 0.853521,
0.524684, 0.566259, 0.529819, 0.679958, 0.654953, 0.665757, 0.831767, 0.807182,
0.834972, 0.400444, 0.336311, 0.389262, 0.780386, 0.788676, 0.765260, 0.449728,
0.415673, 0.439043, 0.350809, 0.374238, 0.397164, 0.427948, 0.427524, 0.465560,
0.493276, 0.510504, 0.482315, 0.543470, 0.482229, 0.508197, 0.131028, 0.139182,
0.165961, 0.122636, 0.076893, 0.083425, 0.600272, 0.559812, 0.614104, 0.410063,
0.463370, 0.466539, 0.136332, 0.122952, 0.167723, 0.119506, 0.135315, 0.103142,
0.822984, 0.840159, 0.857797, 0.214728, 0.205273, 0.210035, 0.496104, 0.481583,
0.510421, 0.268318, 0.262659, 0.261500, 0.125831, 0.142736, 0.141556, 0.469528,
0.503279, 0.465917, 0.424410, 0.396979, 0.365728, 0.754377, 0.751856, 0.784998,
0.523950, 0.602318, 0.564095, 0.605560, 0.604023, 0.657824, 0.257395, 0.279763,
0.244180, 0.054280, 0.081621, 0.086810, 0.383062, 0.345041, 0.347539, 0.602318,
0.601031, 0.615140, 0.655287, 0.631650, 0.690471, 0.422883, 0.498887, 0.443090,
0.781504, 0.827275, 0.766543, 0.128281, 0.155026, 0.135535, 0.836814, 0.832712,
0.814712, 0.147607, 0.140734, 0.173032, 0.245707, 0.271928, 0.247558, 0.345041,
0.308759, 0.347539, 0.406059, 0.380367, 0.411320, 0.424410, 0.365728, 0.372619,
0.544330, 0.532548, 0.452405, 0.622256, 0.580970, 0.555451, 0.958511, 0.929159,
0.951570, 0.563112, 0.580476, 0.532285, 0.904429, 0.956981, 0.945245, 0.258578,
0.230281, 0.236232, 0.766543, 0.764950, 0.781504, 0.149297, 0.184786, 0.171919,
0.644696, 0.648228, 0.564095, 0.162903, 0.155026, 0.151126, 0.242070, 0.211525,
0.200101, 0.710296, 0.746191, 0.718103, 0.425322, 0.592040, 0.463535, 0.407807,
0.425322, 0.465692, 0.280962, 0.244939, 0.266232, 0.297050, 0.270964, 0.297210,
0.644757, 0.592040, 0.621453, 0.965094, 0.968534, 0.933134, 0.128893, 0.126198,
0.115560, 0.122272, 0.119054, 0.131647, 0.228206, 0.257404, 0.204084, 0.373943,
0.415440, 0.384427, 0.886139, 0.906711, 0.893999, 0.232928, 0.222270, 0.191547,
0.687951, 0.677640, 0.638263, 0.400051, 0.384540, 0.385766, 0.648521, 0.672355,
0.644757, 0.211002, 0.218529, 0.200478, 0.213668, 0.229031, 0.198222, 0.274122,
0.272284, 0.289531, 0.875930, 0.864720, 0.868757, 0.692164, 0.630696, 0.677194,
0.604078, 0.618134, 0.570229, 0.050200, 0.100250, 0.070072, 0.034321, 0.038875,
0.031173, 0.685996, 0.657892, 0.669213, 0.041235, 0.045549, 0.063041, 0.327178,
0.325613, 0.287031, 0.799406, 0.829821, 0.817982, 0.205938, 0.191775, 0.184786,
0.438617, 0.465917, 0.488570, 0.296681, 0.310165, 0.332633, 0.269104, 0.303284,
0.264950, 0.788676, 0.770807, 0.765260, 0.247371, 0.254020, 0.272921, 0.290392,
0.314948, 0.291522, 0.422883, 0.517873, 0.498887, 0.117953, 0.157371, 0.164119,
0.272773, 0.223757, 0.230603, 0.630696, 0.532548, 0.544330, 0.654580, 0.677325,
0.709040, 0.682425, 0.710296, 0.718103, 0.435369, 0.496807, 0.509841, 0.117771,
0.153376, 0.122952, 0.096522, 0.122952, 0.136332, 0.654580, 0.604078, 0.614643,
0.605695, 0.573387, 0.581821, 0.789995, 0.760369, 0.751134, 0.440866, 0.467914,
0.491312, 0.365777, 0.372015, 0.355487, 0.784791, 0.738234, 0.718524, 0.623405,
0.396954, 0.465692, 0.700462, 0.723462, 0.695622, 0.729944, 0.712992, 0.731895,
0.495262, 0.495362, 0.460608, 0.083425, 0.076945, 0.082574, 0.183008, 0.204084,
0.173742, 0.014918, 0.013992, 0.035538, 0.288309, 0.306406, 0.285757, 0.685996,
0.678326, 0.653284, 0.191659, 0.175518, 0.214184, 0.517378, 0.576543, 0.554974,
0.449155, 0.483991, 0.447042, 0.796329, 0.811719, 0.799406, 0.293548, 0.284215,
0.309703, 0.099029, 0.067179, 0.065628, 0.782884, 0.782083, 0.796495, 0.747891,
0.751408, 0.766543, 0.158277, 0.169461, 0.157518, 0.271980, 0.243194, 0.327534,
0.165961, 0.180368, 0.186252, 0.329567, 0.338818, 0.380367, 0.314085, 0.388320,
0.346621, 0.117771, 0.117877, 0.153376, 0.793081, 0.810995, 0.783132, 0.243232,
0.242958, 0.231228, 0.636057, 0.645516, 0.659510, 0.419902, 0.375954, 0.415673,
0.309703, 0.287918, 0.314572, 0.243194, 0.271980, 0.223601, 0.878491, 0.931489,
0.878407, 0.272773, 0.297082, 0.275771, 0.272992, 0.308759, 0.295210, 0.708728,
0.730200, 0.760612, 0.415673, 0.508197, 0.439043, 0.169461, 0.183008, 0.157518,
0.415166, 0.361724, 0.389987, 0.096522, 0.073843, 0.075334, 0.041356, 0.062694,
0.087822, 0.284845, 0.255518, 0.307306, 0.708542, 0.675481, 0.735735, 0.128281,
0.135535, 0.103138, 0.259331, 0.272992, 0.295210, 0.870495, 0.860374, 0.854535,
0.149297, 0.147580, 0.130673, 0.873498, 0.890424, 0.904429, 0.238461, 0.184829,
0.180994, 0.912957, 0.953828, 0.913484, 0.279763, 0.257399, 0.271545, 0.570846,
0.605560, 0.609302, 0.393652, 0.422783, 0.415955, 0.723462, 0.706525, 0.695622,
0.539959, 0.593931, 0.605737, 0.111550, 0.063749, 0.059926, 0.787728, 0.807182,
0.768233, 0.181556, 0.173032, 0.122213, 0.782884, 0.769420, 0.782083, 0.816672,
0.816244, 0.849437, 0.185348, 0.191794, 0.205936, 0.038875, 0.034321, 0.031085,
0.853521, 0.892331, 0.868577, 0.034878, 0.033779, 0.054848, 0.199299, 0.166252,
0.177801, 0.145539, 0.130673, 0.119054
};

static TqFloat T01[] = {
0.613196,
0.633572, 0.610098, 0.729834, 0.769595, 0.748319, 0.007370, 0.009542, 0.008617,
0.344487, 0.340586, 0.312432, 0.452062, 0.410163, 0.446067, 0.037231, 0.034781,
0.011037, 0.512744, 0.539462, 0.515846, 0.610098, 0.633572, 0.600264, 0.051767,
0.073038, 0.078296, 0.954670, 0.924385, 0.935375, 0.507517, 0.496924, 0.490038,
0.042020, 0.038639, 0.081791, 0.939051, 0.935375, 0.907202, 0.555574, 0.606508,
0.590082, 0.120186, 0.143008, 0.155913, 0.410269, 0.398931, 0.411807, 0.199827,
0.142155, 0.155340, 0.304518, 0.290519, 0.299945, 0.447118, 0.412078, 0.420926,
0.238043, 0.232806, 0.265213, 0.486499, 0.463167, 0.457384, 0.871275, 0.870225,
0.910349, 0.749093, 0.682049, 0.711689, 0.685828, 0.711898, 0.711175, 0.177130,
0.152411, 0.208112, 0.618163, 0.689486, 0.618695, 0.135119, 0.115655, 0.111894,
0.171288, 0.114008, 0.179671, 0.251574, 0.228883, 0.275438, 0.263012, 0.232111,
0.202557, 0.280704, 0.266727, 0.255163, 0.105775, 0.108965, 0.172107, 0.323468,
0.223505, 0.269941, 0.322722, 0.277617, 0.287339, 0.037231, 0.011037, 0.010658,
0.796229, 0.776035, 0.786978, 0.507207, 0.505219, 0.522509, 0.329758, 0.272321,
0.313625, 0.339649, 0.347749, 0.374516, 0.785555, 0.824931, 0.789424, 0.711175,
0.736108, 0.712415, 0.494595, 0.481554, 0.447118, 0.142155, 0.133682, 0.155340,
0.509206, 0.538266, 0.556814, 0.644921, 0.606508, 0.614571, 0.293613, 0.283877,
0.274097, 0.303730, 0.284131, 0.273811, 0.633455, 0.648494, 0.601284, 0.509030,
0.522081, 0.476942, 0.115655, 0.135119, 0.088347, 0.010433, 0.010017, 0.010206,
0.742764, 0.686751, 0.744374, 0.392815, 0.363116, 0.393430, 0.176743, 0.187241,
0.178524, 0.790020, 0.726454, 0.780973, 0.531409, 0.541544, 0.516208, 0.290614,
0.253818, 0.264474, 0.406128, 0.424076, 0.410163, 0.403730, 0.401071, 0.417717,
0.114289, 0.127889, 0.144610, 0.353167, 0.380459, 0.353671, 0.335099, 0.319034,
0.283919, 0.525023, 0.505281, 0.531676, 0.010658, 0.011037, 0.004917, 0.796212,
0.825049, 0.854713, 0.379722, 0.358290, 0.333281, 0.577647, 0.596870, 0.584780,
0.404640, 0.411940, 0.438290, 0.779755, 0.783234, 0.737048, 0.870225, 0.844169,
0.815596, 0.554485, 0.581875, 0.543130, 0.007614, 0.007059, 0.014707, 0.866728,
0.904488, 0.875727, 0.095264, 0.117577, 0.117739, 0.184242, 0.177130, 0.249319,
0.339649, 0.374516, 0.404818, 0.805790, 0.865408, 0.838981, 0.221720, 0.195702,
0.177225, 0.157892, 0.132422, 0.083596, 0.250526, 0.273811, 0.284131, 0.043123,
0.040145, 0.040688, 0.007059, 0.005552, 0.014707, 0.896623, 0.889962, 0.863273,
0.495798, 0.438290, 0.450804, 0.177225, 0.195702, 0.185827, 0.187241, 0.176743,
0.157440, 0.450599, 0.476169, 0.452874, 0.552233, 0.526202, 0.532962, 0.051407,
0.037783, 0.065834, 0.712381, 0.698054, 0.737401, 0.420613, 0.404023, 0.431175,
0.006539, 0.002105, 0.003179, 0.114008, 0.078296, 0.113781, 0.118360, 0.102359,
0.102514, 0.817628, 0.799966, 0.790020, 0.742764, 0.714725, 0.686751, 0.017212,
0.056613, 0.051212, 0.420180, 0.455165, 0.420926, 0.638612, 0.648494, 0.690481,
0.410163, 0.452062, 0.374134, 0.717028, 0.726042, 0.701030, 0.266727, 0.230247,
0.255163, 0.898367, 0.866372, 0.839943, 0.066003, 0.047095, 0.031929, 0.927069,
0.934587, 0.870388, 0.718978, 0.754121, 0.740170, 0.752478, 0.736108, 0.711175,
0.177477, 0.139167, 0.184955, 0.815237, 0.773489, 0.799966, 0.024203, 0.048765,
0.047984, 0.615694, 0.624131, 0.612953, 0.004190, 0.015655, 0.013891, 0.896623,
0.921946, 0.927344, 0.036607, 0.034442, 0.034698, 0.640244, 0.629541, 0.632004,
0.262805, 0.279103, 0.261797, 0.866372, 0.896623, 0.835496, 0.612875, 0.638612,
0.599491, 0.004840, 0.002824, 0.008617, 0.874495, 0.946103, 0.892226, 0.707215,
0.675509, 0.720767, 0.504391, 0.487098, 0.516928, 0.282334, 0.334072, 0.296141,
0.013305, 0.011900, 0.010408, 0.878299, 0.880061, 0.816302, 0.534754, 0.505219,
0.547948, 0.523285, 0.544441, 0.573144, 0.543130, 0.522081, 0.554485, 0.776035,
0.763993, 0.786978, 0.526202, 0.525717, 0.501116, 0.152411, 0.118360, 0.162877,
0.175045, 0.229590, 0.205910, 0.426379, 0.405072, 0.429157, 0.411807, 0.449286,
0.410269, 0.094775, 0.085193, 0.072757, 0.869102, 0.840311, 0.885808, 0.043005,
0.031304, 0.056911, 0.176674, 0.185827, 0.209285, 0.736108, 0.733680, 0.712415,
0.731324, 0.695188, 0.710961, 0.036857, 0.013305, 0.030738, 0.232548, 0.205910,
0.229590, 0.616422, 0.629331, 0.603128, 0.244916, 0.207273, 0.220718, 0.181002,
0.204617, 0.121380, 1.000000, 0.968684, 0.961773, 0.018740, 0.010206, 0.031304,
0.816302, 0.825775, 0.807724, 0.899050, 0.929490, 0.879200, 0.300633, 0.331724,
0.292648, 0.286826, 0.301055, 0.268215, 0.754377, 0.712381, 0.737401, 0.545687,
0.562299, 0.580101, 0.658166, 0.679225, 0.676069, 0.339649, 0.304518, 0.299945,
0.840881, 0.854869, 0.854797, 0.020718, 0.007614, 0.014707, 0.447118, 0.455165,
0.494595, 0.555824, 0.573784, 0.592821, 0.353671, 0.310287, 0.353167, 0.718978,
0.698054, 0.691070, 0.271060, 0.293303, 0.308621, 0.723415, 0.679225, 0.738950,
0.280430, 0.303801, 0.319915, 0.731324, 0.710961, 0.745556, 0.725749, 0.704294,
0.676069, 0.796212, 0.749128, 0.825049, 0.365706, 0.363116, 0.335099, 0.105775,
0.083419, 0.094595, 0.056911, 0.031304, 0.072757, 0.177225, 0.166917, 0.186921,
0.407155, 0.434677, 0.465516, 0.463813, 0.433279, 0.422486, 0.013891, 0.015832,
0.006815, 0.178524, 0.193509, 0.199293, 0.303919, 0.255163, 0.266441, 0.365046,
0.403680, 0.371853, 0.190707, 0.232806, 0.238043, 0.066085, 0.038928, 0.070732,
0.581875, 0.554485, 0.598531, 0.114948, 0.149416, 0.171250, 0.578378, 0.565875,
0.548465, 0.817628, 0.807724, 0.830054, 0.155340, 0.133682, 0.169455, 0.190543,
0.192175, 0.222293, 0.204617, 0.213359, 0.210788, 0.047730, 0.063315, 0.070688,
0.319915, 0.260223, 0.280430, 0.293303, 0.271060, 0.238043, 0.344310, 0.322722,
0.318138, 0.303801, 0.304163, 0.338121, 0.645041, 0.600264, 0.633572, 0.901159,
0.906685, 0.891058, 0.139167, 0.177477, 0.147745, 0.813995, 0.789424, 0.840311,
0.076557, 0.047095, 0.066003, 0.010433, 0.012536, 0.019744, 0.041480, 0.015471,
0.040220, 0.927344, 0.921946, 0.963667, 0.476542, 0.470267, 0.442703, 0.802033,
0.829621, 0.870388, 0.699298, 0.746277, 0.714070, 0.179671, 0.235972, 0.225728,
0.004332, 0.003460, 0.003541, 0.087698, 0.083547, 0.111013, 0.317101, 0.280536,
0.322656, 0.120847, 0.099171, 0.113330, 0.744374, 0.763993, 0.776035, 0.357269,
0.357595, 0.326162, 0.434677, 0.449286, 0.482495, 0.878299, 0.816302, 0.830608,
0.622793, 0.590082, 0.606508, 0.065258, 0.009900, 0.047984, 0.009900, 0.005708,
0.024206, 0.293881, 0.241443, 0.222088, 0.303730, 0.331894, 0.321044, 0.012556,
0.009481, 0.013594, 0.020351, 0.011336, 0.021676, 0.824931, 0.881348, 0.885808,
0.182440, 0.156535, 0.185918, 0.279103, 0.346069, 0.281317, 0.639779, 0.628720,
0.631543, 0.442789, 0.430673, 0.431874, 0.249041, 0.240169, 0.258438, 0.318752,
0.321688, 0.364872, 0.816302, 0.807724, 0.780973, 0.324344, 0.287105, 0.304678,
0.763951, 0.752478, 0.743121, 0.587972, 0.573363, 0.541544, 0.743121, 0.711175,
0.711898, 0.636289, 0.628720, 0.639779, 0.172107, 0.162877, 0.121081, 0.605889,
0.598071, 0.619399, 0.560147, 0.515663, 0.535398, 0.676069, 0.723415, 0.725749,
0.282901, 0.302194, 0.322656, 0.717028, 0.715013, 0.737048, 0.619399, 0.617541,
0.628720, 0.242896, 0.245715, 0.274097, 0.086244, 0.094775, 0.078554, 0.795869,
0.795506, 0.799636, 0.030924, 0.003541, 0.014949, 0.351649, 0.380199, 0.382603,
0.618136, 0.613277, 0.583182, 0.335111, 0.310537, 0.269550, 0.143346, 0.118810,
0.099460, 0.598520, 0.603697, 0.617541, 0.425327, 0.402228, 0.378359, 0.013594,
0.007919, 0.016854, 0.425975, 0.382832, 0.414498, 0.446278, 0.465924, 0.512648,
0.505281, 0.525023, 0.465207, 0.304678, 0.340553, 0.335739, 0.324344, 0.304678,
0.335739, 0.134388, 0.105250, 0.124207, 0.240920, 0.339030, 0.296017, 0.521762,
0.500306, 0.539156, 0.365663, 0.347749, 0.338121, 0.095264, 0.088559, 0.112311,
0.037296, 0.016813, 0.047534, 0.011307, 0.009875, 0.037612, 0.014887, 0.014795,
0.060302, 0.021100, 0.017711, 0.012689, 0.240803, 0.235970, 0.219078, 0.633127,
0.613212, 0.627137, 0.343071, 0.315961, 0.314728, 0.134851, 0.171288, 0.174035,
0.501116, 0.485571, 0.481554, 0.112311, 0.088559, 0.098921, 0.420601, 0.430673,
0.402940, 0.403972, 0.407634, 0.439159, 0.447118, 0.420926, 0.455165, 0.494200,
0.512648, 0.465924, 0.433279, 0.463813, 0.452920, 0.129336, 0.168241, 0.122776,
0.574678, 0.610098, 0.600264, 0.789302, 0.789497, 0.800578, 0.365981, 0.334072,
0.323468, 0.271060, 0.276272, 0.234262, 0.829621, 0.800578, 0.863273, 0.012983,
0.036607, 0.040688, 0.162877, 0.172107, 0.206702, 0.470267, 0.476542, 0.512744,
0.866728, 0.875727, 0.854713, 0.066085, 0.070145, 0.046260, 0.003537, 0.003460,
0.006036, 0.759196, 0.773874, 0.801183, 0.006815, 0.007258, 0.004190, 0.754121,
0.778092, 0.789497, 0.279103, 0.259446, 0.261797, 0.139041, 0.176329, 0.137848,
0.639467, 0.629331, 0.633127, 0.686751, 0.714725, 0.644921, 0.476906, 0.497616,
0.516208, 0.296141, 0.274097, 0.282334, 0.259446, 0.247936, 0.258639, 0.129634,
0.149817, 0.120543, 0.296410, 0.273421, 0.281317, 0.384507, 0.404023, 0.346181,
0.156535, 0.145451, 0.185918, 0.249041, 0.258639, 0.235972, 0.187764, 0.183985,
0.143008, 0.512648, 0.558837, 0.529249, 0.618611, 0.648584, 0.618163, 0.477212,
0.432995, 0.435557, 0.205145, 0.209285, 0.227892, 0.036302, 0.078554, 0.072757,
0.068716, 0.012023, 0.012890, 0.099091, 0.147745, 0.139041, 0.404818, 0.322065,
0.339649, 0.249041, 0.258438, 0.265586, 0.036302, 0.022871, 0.017884, 0.327296,
0.298879, 0.322722, 0.918739, 0.946103, 0.874495, 0.402798, 0.475280, 0.425327,
0.028528, 0.003537, 0.006691, 0.230247, 0.244916, 0.255163, 0.549744, 0.558567,
0.521378, 0.054299, 0.098921, 0.088559, 0.821192, 0.815206, 0.839445, 0.242896,
0.274097, 0.247470, 0.613717, 0.605889, 0.627314, 0.446354, 0.474175, 0.501372,
0.437068, 0.421324, 0.499617, 0.329278, 0.335111, 0.398931, 0.552824, 0.581652,
0.587972, 0.357269, 0.326162, 0.303919, 0.380459, 0.408547, 0.421163, 0.086244,
0.102855, 0.104415, 0.521762, 0.522033, 0.507517, 0.598071, 0.598520, 0.606544,
0.438079, 0.411832, 0.426379, 0.184955, 0.172420, 0.205465, 0.370227, 0.331894,
0.332487, 0.114289, 0.144610, 0.157440, 0.383846, 0.377894, 0.301843, 0.322065,
0.404818, 0.378607, 0.009672, 0.036607, 0.012983, 0.789497, 0.839943, 0.866372,
0.597974, 0.589235, 0.580101, 0.096635, 0.075045, 0.065258, 0.618695, 0.562367,
0.572419, 0.054299, 0.060183, 0.027904, 0.436772, 0.448497, 0.470267, 0.615694,
0.610638, 0.623868, 0.007171, 0.021254, 0.024007, 0.183517, 0.135119, 0.161408,
0.118360, 0.152411, 0.125529, 0.430673, 0.424076, 0.403680, 0.844169, 0.870225,
0.871275, 0.392267, 0.411694, 0.401071, 0.007059, 0.007614, 0.009875, 0.526666,
0.535571, 0.559246, 0.829621, 0.802033, 0.800578, 0.689207, 0.704675, 0.684635,
0.240444, 0.248852, 0.258438, 0.601286, 0.587972, 0.623958, 0.144072, 0.133682,
0.117483, 0.313055, 0.313625, 0.277732, 0.560147, 0.577647, 0.554669, 0.135119,
0.124103, 0.088347, 0.345580, 0.324122, 0.382603, 0.014949, 0.003537, 0.038639,
0.162849, 0.197984, 0.245643, 0.037783, 0.051407, 0.032096, 0.088640, 0.114289,
0.096635, 0.142155, 0.215603, 0.121253, 0.222909, 0.208925, 0.158360, 0.777653,
0.793439, 0.814647, 0.002471, 0.005708, 0.005986, 0.487098, 0.490038, 0.474175,
0.457384, 0.452062, 0.486499, 0.032547, 0.036045, 0.031167, 0.158360, 0.153630,
0.190409, 0.498537, 0.489987, 0.458647, 0.292007, 0.256341, 0.301843, 0.673679,
0.659071, 0.645041, 0.162490, 0.187586, 0.149416, 0.405072, 0.313625, 0.400072,
0.230564, 0.275438, 0.228883, 0.891271, 0.884615, 0.854183, 0.578378, 0.548465,
0.539197, 0.199723, 0.162849, 0.245643, 0.844169, 0.805240, 0.815596, 0.631543,
0.608753, 0.628424, 0.076502, 0.116784, 0.052486, 0.805240, 0.844169, 0.813596,
0.544270, 0.580026, 0.570249, 0.526202, 0.497175, 0.532962, 0.208112, 0.162877,
0.206702, 0.037296, 0.009900, 0.016813, 0.303919, 0.280704, 0.255163, 0.266727,
0.227892, 0.230247, 0.787860, 0.837348, 0.824221, 0.505219, 0.523285, 0.547948,
0.577043, 0.568562, 0.551289, 0.526202, 0.566213, 0.563501, 0.682773, 0.701030,
0.681580, 0.939051, 0.953441, 0.961009, 0.291004, 0.338197, 0.310304, 0.433814,
0.439455, 0.481281, 0.199827, 0.155340, 0.185458, 0.105532, 0.118952, 0.094338,
0.526202, 0.494595, 0.497175, 0.540441, 0.520497, 0.516245, 0.010686, 0.014141,
0.011336, 0.604420, 0.576335, 0.603128, 0.087642, 0.105313, 0.068657, 0.192175,
0.253528, 0.258853, 0.034688, 0.014252, 0.029164, 0.090392, 0.131032, 0.144072,
0.411694, 0.392267, 0.411174, 0.011900, 0.030161, 0.010408, 0.150508, 0.124207,
0.157440, 0.086244, 0.069538, 0.070688, 0.439159, 0.430421, 0.403972, 0.601286,
0.576940, 0.553414, 0.657947, 0.632710, 0.661852, 0.068716, 0.070149, 0.038928,
0.707811, 0.690481, 0.648494, 0.556814, 0.576335, 0.604420, 0.382603, 0.324122,
0.351649, 0.223505, 0.245715, 0.197971, 0.584780, 0.608753, 0.603580, 0.413106,
0.393430, 0.382603, 0.036302, 0.070688, 0.069538, 0.685828, 0.662527, 0.711898,
0.401099, 0.327279, 0.329758, 0.922962, 0.946103, 0.961773, 0.002105, 0.006539,
0.007370, 0.768780, 0.735285, 0.754377, 0.601286, 0.553414, 0.573363, 0.150508,
0.176743, 0.166917, 0.418941, 0.433814, 0.470968, 0.003524, 0.012903, 0.003179,
0.411174, 0.436772, 0.435557, 0.860663, 0.894331, 0.884422, 0.089720, 0.076557,
0.098954, 0.340553, 0.310537, 0.329278, 0.374079, 0.382832, 0.338409, 0.012536,
0.010206, 0.018740, 0.169455, 0.185458, 0.155340, 0.849628, 0.805790, 0.808129,
0.188919, 0.168951, 0.143346, 0.223505, 0.205465, 0.269941, 0.235728, 0.237063,
0.260468, 0.247470, 0.235116, 0.226237, 0.268215, 0.277732, 0.260468, 0.447781,
0.487145, 0.436188, 0.737307, 0.746277, 0.699298, 0.022050, 0.011336, 0.007919,
0.450942, 0.481420, 0.515007, 0.773874, 0.789424, 0.813995, 0.374079, 0.386283,
0.414498, 0.603697, 0.598520, 0.577965, 0.200608, 0.162490, 0.158296, 0.426379,
0.429157, 0.450599, 0.556814, 0.551518, 0.515007, 0.220099, 0.201223, 0.239897,
0.017714, 0.009481, 0.020718, 0.475280, 0.539534, 0.481281, 0.365485, 0.401071,
0.379722, 0.370227, 0.388401, 0.402333, 0.301055, 0.286826, 0.328340, 0.350170,
0.366154, 0.386508, 0.871465, 0.904488, 0.866728, 0.037231, 0.038500, 0.034781,
0.963667, 0.921946, 0.952280, 0.442789, 0.475966, 0.481457, 0.240444, 0.225566,
0.208925, 0.035294, 0.034241, 0.032549, 0.111013, 0.157892, 0.087698, 0.005986,
0.017569, 0.014820, 0.229455, 0.180804, 0.187776, 0.618136, 0.583182, 0.598603,
0.136126, 0.190543, 0.138587, 0.022871, 0.031304, 0.010206, 0.644921, 0.714725,
0.711689, 0.555574, 0.549744, 0.522033, 0.927069, 0.977962, 0.934587, 0.854869,
0.874495, 0.892226, 0.011685, 0.011974, 0.012689, 0.050445, 0.030924, 0.073073,
0.755388, 0.760087, 0.772515, 0.357654, 0.352789, 0.413875, 0.898367, 0.839943,
0.854713, 0.060302, 0.083596, 0.094595, 0.195187, 0.280536, 0.225681, 0.114289,
0.100987, 0.127889, 0.794322, 0.789302, 0.799636, 0.379428, 0.408983, 0.411940,
0.563501, 0.578378, 0.539197, 0.014820, 0.066003, 0.031929, 0.213359, 0.235728,
0.210788, 0.834178, 0.872219, 0.849628, 0.784505, 0.798413, 0.777901, 0.064449,
0.021025, 0.051212, 0.287105, 0.261727, 0.304678, 0.749128, 0.824221, 0.825049,
0.797532, 0.795506, 0.786324, 0.407203, 0.447781, 0.436188, 0.883026, 0.918572,
0.848552, 0.794322, 0.808129, 0.805790, 0.726042, 0.749128, 0.778092, 0.066972,
0.017711, 0.021100, 0.092353, 0.087341, 0.073073, 0.005038, 0.004321, 0.004190,
0.720767, 0.704675, 0.733680, 0.055856, 0.046260, 0.070145, 0.932003, 0.923353,
0.907234, 0.125529, 0.177130, 0.184242, 0.020663, 0.034710, 0.034122, 0.291860,
0.310287, 0.320601, 0.753165, 0.745556, 0.766106, 0.070145, 0.087698, 0.083596,
0.231054, 0.261727, 0.240803, 0.501372, 0.474175, 0.496924, 0.037783, 0.052486,
0.080629, 0.485556, 0.504562, 0.462608, 0.175045, 0.205910, 0.155233, 0.358290,
0.379722, 0.380199, 0.695188, 0.711898, 0.662527, 0.320601, 0.310287, 0.353671,
0.522081, 0.545687, 0.554485, 0.205145, 0.227892, 0.242984, 0.374134, 0.352789,
0.322722, 0.098954, 0.124207, 0.105250, 0.623868, 0.624131, 0.615694, 0.131032,
0.106590, 0.134388, 0.601284, 0.578378, 0.563501, 0.949508, 0.945307, 0.907030,
0.095895, 0.129157, 0.123060, 0.452920, 0.392815, 0.433279, 0.544270, 0.516928,
0.548465, 0.457384, 0.463167, 0.437555, 0.448497, 0.442703, 0.470267, 0.586982,
0.552233, 0.600264, 0.007618, 0.004917, 0.012537, 0.280704, 0.311621, 0.304163,
0.507517, 0.490038, 0.500306, 0.202557, 0.192074, 0.235116, 0.058976, 0.032096,
0.051407, 0.105313, 0.113330, 0.068657, 0.263012, 0.292648, 0.232111, 0.031167,
0.033744, 0.031124, 0.918739, 0.934587, 0.972803, 0.025217, 0.047730, 0.070688,
0.386508, 0.423783, 0.392405, 0.648494, 0.659071, 0.675509, 0.461924, 0.446354,
0.421163, 0.815596, 0.805240, 0.781328, 0.575245, 0.599754, 0.582288, 0.296141,
0.334072, 0.319688, 0.883009, 0.838981, 0.865408, 0.770772, 0.789302, 0.788555,
0.416363, 0.408007, 0.448497, 0.568562, 0.577043, 0.600928, 0.076502, 0.030738,
0.066977, 0.476169, 0.479163, 0.452874, 0.591234, 0.596681, 0.609129, 0.007919,
0.009481, 0.017714, 0.525023, 0.520385, 0.490442, 0.545302, 0.586010, 0.557534,
0.269550, 0.255795, 0.231054, 0.476906, 0.440728, 0.451357, 0.247936, 0.259446,
0.279103, 0.488948, 0.522070, 0.464287, 0.412078, 0.398992, 0.360704, 0.977962,
0.927069, 0.927344, 0.139167, 0.120027, 0.115517, 0.329758, 0.327279, 0.272321,
0.076752, 0.095895, 0.064449, 0.382832, 0.374079, 0.414498, 0.172107, 0.155233,
0.232548, 0.357269, 0.353671, 0.404692, 0.813596, 0.768780, 0.805240, 0.581457,
0.531676, 0.568562, 0.545687, 0.522081, 0.509030, 0.171250, 0.188810, 0.200538,
0.404692, 0.421163, 0.446354, 0.869102, 0.830153, 0.813995, 0.163405, 0.161282,
0.142593, 0.805790, 0.787102, 0.788555, 0.293613, 0.296141, 0.365485, 0.105775,
0.172107, 0.121081, 0.205197, 0.219078, 0.235970, 0.934587, 0.878299, 0.870388,
0.051923, 0.019608, 0.055939, 0.229455, 0.225681, 0.256341, 0.062331, 0.023304,
0.067420, 0.761743, 0.747747, 0.733680, 0.130106, 0.111013, 0.118810, 0.541544,
0.526318, 0.516208, 0.239897, 0.258639, 0.247936, 0.618136, 0.598603, 0.630671,
0.010408, 0.010925, 0.012452, 0.271844, 0.335111, 0.269550, 0.883009, 0.907234,
0.896478, 0.407382, 0.422486, 0.433279, 0.409785, 0.442703, 0.408007, 0.092353,
0.073073, 0.081791, 0.005438, 0.004840, 0.010017, 0.618695, 0.689486, 0.674709,
0.019608, 0.010433, 0.019744, 0.726454, 0.715013, 0.704294, 0.498537, 0.458647,
0.436893, 0.540441, 0.548086, 0.570804, 0.363927, 0.391477, 0.296017, 0.134851,
0.114008, 0.171288, 0.177130, 0.208112, 0.253818, 0.335739, 0.407155, 0.386041,
0.043005, 0.023304, 0.018740, 0.577965, 0.598520, 0.562299, 0.273811, 0.281168,
0.302474, 0.311621, 0.280704, 0.326162, 0.786324, 0.767707, 0.769595, 0.118810,
0.083547, 0.099460, 0.442789, 0.444586, 0.430673, 0.010681, 0.012342, 0.011718,
0.003541, 0.048765, 0.006907, 0.244033, 0.200608, 0.207629, 0.498537, 0.476942,
0.522081, 0.644921, 0.633665, 0.686751, 0.611948, 0.645041, 0.633455, 0.515663,
0.554669, 0.512744, 0.501116, 0.494595, 0.526202, 0.391477, 0.346069, 0.296017,
0.896623, 0.866372, 0.898367, 0.264004, 0.206357, 0.211657, 0.038639, 0.042020,
0.014949, 0.171662, 0.238248, 0.197984, 0.168974, 0.228883, 0.187764, 0.206983,
0.178298, 0.202557, 0.365046, 0.344487, 0.377894, 0.114289, 0.157440, 0.124207,
0.402333, 0.388401, 0.420926, 0.080629, 0.052486, 0.116784, 0.302194, 0.335637,
0.322656, 0.724781, 0.702425, 0.701204, 0.130864, 0.120847, 0.113330, 0.032549,
0.031124, 0.033744, 0.388401, 0.370227, 0.364617, 0.558567, 0.549744, 0.590082,
0.613212, 0.603603, 0.627137, 0.322722, 0.298879, 0.277617, 0.634420, 0.624131,
0.657947, 0.786978, 0.763993, 0.772046, 0.749093, 0.729834, 0.713887, 0.739998,
0.755388, 0.738104, 0.548086, 0.540441, 0.516245, 0.161282, 0.145451, 0.113633,
0.529467, 0.522509, 0.562367, 0.177477, 0.197971, 0.205689, 0.087642, 0.097951,
0.120543, 0.275438, 0.230564, 0.293613, 0.235970, 0.262288, 0.235047, 0.580101,
0.589235, 0.576702, 0.233018, 0.232111, 0.292648, 0.248859, 0.226257, 0.290232,
0.262917, 0.280430, 0.260223, 0.145106, 0.117577, 0.138587, 0.651184, 0.682773,
0.681580, 0.293613, 0.314728, 0.315961, 0.816302, 0.880061, 0.825775, 0.152411,
0.177130, 0.125529, 0.338197, 0.351649, 0.310304, 0.130864, 0.113330, 0.120543,
0.578378, 0.601284, 0.612875, 0.825775, 0.880061, 0.918739, 0.781328, 0.781199,
0.828299, 0.570804, 0.548086, 0.573608, 0.055856, 0.070145, 0.083596, 0.807724,
0.825775, 0.830054, 0.783371, 0.761743, 0.784967, 0.075045, 0.096635, 0.098954,
0.614019, 0.611832, 0.562367, 0.005485, 0.005438, 0.010017, 0.331894, 0.370227,
0.369119, 0.821192, 0.783234, 0.815206, 0.397650, 0.357654, 0.413875, 0.190409,
0.254290, 0.240920, 0.201860, 0.171288, 0.225728, 0.579062, 0.595518, 0.596681,
0.740170, 0.770772, 0.765284, 0.265586, 0.258639, 0.249041, 0.070732, 0.099460,
0.066085, 0.742764, 0.744374, 0.776035, 0.067420, 0.073721, 0.088893, 0.745556,
0.761517, 0.766106, 0.481438, 0.538266, 0.509206, 0.573151, 0.596681, 0.591234,
0.035390, 0.040995, 0.037612, 0.319034, 0.363116, 0.334244, 0.476169, 0.474002,
0.496240, 0.137848, 0.143346, 0.107340, 0.006622, 0.004332, 0.007712, 0.671010,
0.633665, 0.632768, 0.055856, 0.083596, 0.060302, 0.576940, 0.526318, 0.553414,
0.003390, 0.004332, 0.002069, 0.013920, 0.021655, 0.005552, 0.824105, 0.790026,
0.844318, 0.661852, 0.618136, 0.676069, 0.004836, 0.048765, 0.024203, 0.303801,
0.262917, 0.304163, 0.088559, 0.066972, 0.060183, 0.178298, 0.168951, 0.202557,
0.793439, 0.790026, 0.824105, 0.120027, 0.092698, 0.115517, 0.129336, 0.161032,
0.168241, 0.612953, 0.589235, 0.597974, 0.554669, 0.584780, 0.539462, 0.481457,
0.507104, 0.497242, 0.303919, 0.266441, 0.291860, 0.866728, 0.824221, 0.837348,
0.446067, 0.490430, 0.490442, 0.282334, 0.223505, 0.323468, 0.603603, 0.600928,
0.629541, 0.544859, 0.559246, 0.575245, 0.586982, 0.566213, 0.552233, 0.891058,
0.865408, 0.849628, 0.019608, 0.027904, 0.012689, 0.070145, 0.083547, 0.087698,
0.554669, 0.577647, 0.584780, 0.121253, 0.094338, 0.118952, 0.004190, 0.004321,
0.017278, 0.357595, 0.391478, 0.386508, 0.034688, 0.035390, 0.012537, 0.271844,
0.231054, 0.210788, 0.543130, 0.550978, 0.513644, 0.303919, 0.320601, 0.353671,
0.013577, 0.007258, 0.006815, 0.181002, 0.184242, 0.202715, 0.310304, 0.298693,
0.291004, 0.343403, 0.374732, 0.373463, 0.138587, 0.117577, 0.136126, 0.860663,
0.834859, 0.824105, 0.014887, 0.062103, 0.005181, 0.261797, 0.248852, 0.262805,
0.543130, 0.581875, 0.550978, 0.132270, 0.142593, 0.110783, 0.504562, 0.516245,
0.464650, 0.098921, 0.099171, 0.120847, 0.199723, 0.130864, 0.149817, 0.624131,
0.634420, 0.617593, 0.500306, 0.509769, 0.526666, 0.012689, 0.011718, 0.011685,
0.006539, 0.003179, 0.003390, 0.011519, 0.036607, 0.009672, 0.038928, 0.012023,
0.068716, 0.763508, 0.749583, 0.790020, 0.698054, 0.701966, 0.691070, 0.184242,
0.133116, 0.125529, 0.623720, 0.613717, 0.627314, 0.076502, 0.036857, 0.030738,
0.504686, 0.531793, 0.487145, 0.317101, 0.322656, 0.383846, 0.590535, 0.591234,
0.611569, 0.067420, 0.094338, 0.062331, 0.785555, 0.772515, 0.827742, 0.048765,
0.004836, 0.006907, 0.830153, 0.844318, 0.790026, 0.653538, 0.645041, 0.633572,
0.702425, 0.738950, 0.679225, 0.440728, 0.408983, 0.451357, 0.365485, 0.333281,
0.273387, 0.761743, 0.733680, 0.736108, 0.835458, 0.815206, 0.815237, 0.740170,
0.765284, 0.737401, 0.532962, 0.507207, 0.529467, 0.017569, 0.005986, 0.009900,
0.838981, 0.883009, 0.843115, 0.213359, 0.204617, 0.181002, 0.370227, 0.402333,
0.369119, 0.210788, 0.272321, 0.271844, 0.134851, 0.174035, 0.143810, 0.010433,
0.010206, 0.012536, 0.040688, 0.011900, 0.012983, 0.557534, 0.531793, 0.545302,
0.092140, 0.099091, 0.083152, 0.611948, 0.633455, 0.601284, 0.576702, 0.554485,
0.545687, 0.551542, 0.507104, 0.563904, 0.432995, 0.477212, 0.451153, 0.187586,
0.224704, 0.188810, 0.451153, 0.464650, 0.432858, 0.407203, 0.436188, 0.407601,
0.799636, 0.789302, 0.795869, 0.487098, 0.504391, 0.509769, 0.193509, 0.231054,
0.219078, 0.407155, 0.375993, 0.410269, 0.003436, 0.005181, 0.003537, 0.592821,
0.598922, 0.616422, 0.182440, 0.207629, 0.158296, 0.351237, 0.313625, 0.313055,
0.764051, 0.729834, 0.749093, 0.606508, 0.582288, 0.614571, 0.691070, 0.701966,
0.648584, 0.603459, 0.583810, 0.581875, 0.066972, 0.088559, 0.095264, 0.338121,
0.304163, 0.350170, 0.009557, 0.010017, 0.010433, 0.923353, 0.932003, 0.962275,
0.702425, 0.679906, 0.701204, 0.013305, 0.011966, 0.030738, 0.403730, 0.380199,
0.401071, 0.034122, 0.037231, 0.010658, 0.996376, 0.990938, 0.963667, 0.129336,
0.132925, 0.154422, 0.014795, 0.002888, 0.012412, 0.238248, 0.224263, 0.260223,
0.184955, 0.197971, 0.177477, 0.176674, 0.185458, 0.169455, 0.711689, 0.766448,
0.749093, 0.168974, 0.183517, 0.228883, 0.844169, 0.827742, 0.813596, 0.013577,
0.031124, 0.015625, 0.745447, 0.738950, 0.769595, 0.632710, 0.613277, 0.618136,
0.570804, 0.577965, 0.539046, 0.004190, 0.007193, 0.005038, 0.431874, 0.445406,
0.442789, 0.067437, 0.047095, 0.076557, 0.787102, 0.781199, 0.765284, 0.824931,
0.885808, 0.840311, 0.516245, 0.520497, 0.464650, 0.057956, 0.019744, 0.062331,
0.083152, 0.070149, 0.092140, 0.090735, 0.113633, 0.076752, 0.019744, 0.012536,
0.023304, 0.132925, 0.129336, 0.093836, 0.815237, 0.779755, 0.773489, 0.323468,
0.269941, 0.318752, 0.773614, 0.763951, 0.780340, 0.907030, 0.874326, 0.870038,
0.021100, 0.027904, 0.060183, 0.500306, 0.521762, 0.507517, 0.618163, 0.648584,
0.701966, 0.129157, 0.124612, 0.158296, 0.277732, 0.272321, 0.237112, 0.520385,
0.486499, 0.490442, 0.346181, 0.335637, 0.302194, 0.293613, 0.273421, 0.314728,
0.037231, 0.034673, 0.035294, 0.208112, 0.264474, 0.253818, 0.786953, 0.795506,
0.802033, 0.031167, 0.038860, 0.040259, 0.521378, 0.496924, 0.507517, 0.906685,
0.907234, 0.891058, 0.682049, 0.749093, 0.713887, 0.190543, 0.195187, 0.138587,
0.083152, 0.099460, 0.070732, 0.281287, 0.309062, 0.290614, 0.033878, 0.031167,
0.036721, 0.430673, 0.420601, 0.431874, 0.899050, 0.879200, 0.869102, 0.149817,
0.130864, 0.120543, 0.380459, 0.398992, 0.408547, 0.404692, 0.353671, 0.421163,
0.451357, 0.391478, 0.412111, 0.529467, 0.562367, 0.574678, 0.133682, 0.144072,
0.169455, 0.062026, 0.043771, 0.088347, 0.968684, 0.918572, 0.961773, 0.016854,
0.058976, 0.051767, 0.008508, 0.012537, 0.011148, 0.225728, 0.171288, 0.179671,
0.018863, 0.037143, 0.014343, 0.238248, 0.290519, 0.281583, 0.168154, 0.135119,
0.136092, 0.102514, 0.081791, 0.084675, 0.355892, 0.392037, 0.335637, 0.039556,
0.066977, 0.030738, 0.013305, 0.010408, 0.011966, 0.011275, 0.009542, 0.006539,
0.475280, 0.502292, 0.539534, 0.765284, 0.770772, 0.787102, 0.171250, 0.200538,
0.211948, 0.522509, 0.534754, 0.562367, 0.402228, 0.439455, 0.433814, 0.436772,
0.411174, 0.416363, 0.096635, 0.114289, 0.124207, 0.263797, 0.265747, 0.298693,
0.370227, 0.340402, 0.364617, 0.290614, 0.328340, 0.253818, 0.889962, 0.927069,
0.870388, 0.369926, 0.370271, 0.409785, 0.161408, 0.208408, 0.183517, 0.226257,
0.248859, 0.207629, 0.295954, 0.333245, 0.346181, 0.261797, 0.265586, 0.258438,
0.821192, 0.787860, 0.783234, 0.062456, 0.068716, 0.012890, 0.090735, 0.085500,
0.110783, 0.451357, 0.501372, 0.497616, 0.110356, 0.127617, 0.094235, 0.714725,
0.766448, 0.711689, 0.539046, 0.540441, 0.570804, 0.509769, 0.535571, 0.526666,
0.179671, 0.113781, 0.181292, 0.004275, 0.004332, 0.003169, 0.230247, 0.209285,
0.207273, 0.517926, 0.522070, 0.488948, 0.900836, 0.883026, 0.854869, 0.638612,
0.690481, 0.699298, 0.596681, 0.613717, 0.609129, 0.078554, 0.069538, 0.086244,
0.211657, 0.206983, 0.238770, 0.003169, 0.012903, 0.016610, 0.244916, 0.220718,
0.235047, 0.284131, 0.276567, 0.244916, 0.011469, 0.010408, 0.012452, 0.370271,
0.364872, 0.409785, 0.377894, 0.402940, 0.403680, 0.627137, 0.603603, 0.629541,
0.539197, 0.504821, 0.501116, 0.539197, 0.525717, 0.563501, 0.150508, 0.156096,
0.149859, 0.374134, 0.344310, 0.378630, 0.632004, 0.636289, 0.640244, 0.501372,
0.523417, 0.518701, 0.136092, 0.143810, 0.178194, 0.673679, 0.712415, 0.689207,
0.003436, 0.014887, 0.005181, 0.177477, 0.139041, 0.147745, 0.510088, 0.481420,
0.473659, 0.263797, 0.264004, 0.238770, 0.215603, 0.142155, 0.199827, 0.249319,
0.286826, 0.268215, 0.504562, 0.485556, 0.513430, 0.188880, 0.163405, 0.190707,
0.319915, 0.339649, 0.299945, 0.006036, 0.006622, 0.034122, 0.153630, 0.116784,
0.171250, 0.408983, 0.365663, 0.392405, 0.504821, 0.487098, 0.485571, 0.308621,
0.293303, 0.335161, 0.391531, 0.420613, 0.407203, 0.237112, 0.235728, 0.277732,
0.068657, 0.057956, 0.087642, 0.185918, 0.197989, 0.216528, 0.612953, 0.597974,
0.615694, 0.787860, 0.749128, 0.717028, 0.047730, 0.014343, 0.037143, 0.010433,
0.012689, 0.011036, 0.544441, 0.508751, 0.508065, 0.011275, 0.017884, 0.009542,
0.334244, 0.363064, 0.334902, 0.229590, 0.281287, 0.232548, 0.786324, 0.783038,
0.797532, 0.778092, 0.749128, 0.796212, 0.884422, 0.834859, 0.860663, 0.475700,
0.485556, 0.462608, 0.123280, 0.090735, 0.110783, 0.006815, 0.015832, 0.005915,
0.593992, 0.570249, 0.619114, 0.105532, 0.094338, 0.088893, 0.047095, 0.093174,
0.063315, 0.623720, 0.632004, 0.629541, 0.120027, 0.092140, 0.092698, 0.421324,
0.407601, 0.436188, 0.380199, 0.338197, 0.358290, 0.720767, 0.733680, 0.747747,
0.229590, 0.206357, 0.264004, 0.016610, 0.019402, 0.003169, 0.249319, 0.202715,
0.184242, 0.535571, 0.544270, 0.570249, 0.005181, 0.006691, 0.003537, 0.529249,
0.545302, 0.531793, 0.821192, 0.837348, 0.787860, 0.972893, 0.978515, 0.949508,
0.052787, 0.040220, 0.015471, 0.266441, 0.255163, 0.244916, 0.768780, 0.748839,
0.735285, 0.343403, 0.315961, 0.343071, 0.825887, 0.849942, 0.824931, 0.070732,
0.038928, 0.070149, 0.168154, 0.161408, 0.135119, 0.036177, 0.034656, 0.033878,
0.002888, 0.013445, 0.012412, 0.407155, 0.335739, 0.375993, 0.761743, 0.752478,
0.773614, 0.002888, 0.003436, 0.003537, 0.201223, 0.220099, 0.168154, 0.185827,
0.195702, 0.207273, 0.004321, 0.004275, 0.003169, 0.438079, 0.449286, 0.411807,
0.824221, 0.749128, 0.787860, 0.953441, 0.939051, 0.910349, 0.773874, 0.755388,
0.789424, 0.746277, 0.744374, 0.714070, 0.788555, 0.787102, 0.770772, 0.111894,
0.073651, 0.052787, 0.195187, 0.222293, 0.282901, 0.221720, 0.205197, 0.235970,
0.199723, 0.149817, 0.162849, 0.171288, 0.201860, 0.174035, 0.808129, 0.834178,
0.849628, 0.206983, 0.232111, 0.233018, 0.034026, 0.013305, 0.036857, 0.300633,
0.333281, 0.331724, 0.212363, 0.193273, 0.225566, 0.378359, 0.363927, 0.339030,
0.290232, 0.337116, 0.326408, 0.010681, 0.013037, 0.011526, 0.293613, 0.248179,
0.273421, 0.282901, 0.280536, 0.195187, 0.558567, 0.581652, 0.552824, 0.284131,
0.244916, 0.235047, 0.805790, 0.788555, 0.794322, 0.092698, 0.068716, 0.076816,
0.296410, 0.281317, 0.346069, 0.178524, 0.186921, 0.166917, 0.780340, 0.790471,
0.793011, 0.012536, 0.018740, 0.023304, 0.603459, 0.598531, 0.612953, 0.899050,
0.869102, 0.924385, 0.586010, 0.595518, 0.579062, 0.434677, 0.410269, 0.449286,
0.854869, 0.825775, 0.874495, 0.523417, 0.521378, 0.558567, 0.754121, 0.718978,
0.726042, 0.794322, 0.788555, 0.789302, 0.671010, 0.686751, 0.633665, 0.343403,
0.364872, 0.321688, 0.402940, 0.377894, 0.383846, 0.780973, 0.725749, 0.762583,
0.009557, 0.013577, 0.006815, 0.863273, 0.835496, 0.896623, 0.290519, 0.238248,
0.260223, 0.095895, 0.076752, 0.113633, 0.052486, 0.037783, 0.034026, 0.225728,
0.235972, 0.258639, 0.120186, 0.155913, 0.115517, 0.211657, 0.206357, 0.176257,
0.534754, 0.547948, 0.572419, 0.379428, 0.347749, 0.365663, 0.701966, 0.722040,
0.707256, 0.619114, 0.599491, 0.638612, 0.113633, 0.124612, 0.095895, 0.018863,
0.006539, 0.014820, 0.410269, 0.375993, 0.398931, 0.089720, 0.067437, 0.076557,
0.726454, 0.749583, 0.715013, 0.475966, 0.445406, 0.437068, 0.517926, 0.488948,
0.486499, 0.280430, 0.262917, 0.303801, 0.177130, 0.253818, 0.249319, 0.481420,
0.450942, 0.461807, 0.079939, 0.088640, 0.047984, 0.206357, 0.229590, 0.175045,
0.558428, 0.591234, 0.560384, 0.515007, 0.488081, 0.450942, 0.338409, 0.301055,
0.328340, 0.699298, 0.671010, 0.632768, 0.014820, 0.006539, 0.005986, 0.809096,
0.783234, 0.779755, 0.185827, 0.207273, 0.209285, 0.953441, 0.962275, 0.961009,
0.870225, 0.873205, 0.896478, 0.504562, 0.435557, 0.462608, 0.799858, 0.834178,
0.808129, 0.012556, 0.013594, 0.015471, 0.931428, 0.905156, 0.945307, 0.633885,
0.682049, 0.644678, 0.002471, 0.005986, 0.006539, 0.824931, 0.849942, 0.881348,
0.303730, 0.302474, 0.324344, 0.972893, 0.968684, 0.995927, 0.304678, 0.310537,
0.340553, 0.115517, 0.155913, 0.172420, 0.010891, 0.036033, 0.034442, 0.377894,
0.403680, 0.365046, 0.283877, 0.365485, 0.273387, 0.065258, 0.088640, 0.096635,
0.021254, 0.012023, 0.038928, 0.576335, 0.538266, 0.544931, 0.762583, 0.786953,
0.798288, 0.577647, 0.571956, 0.586703, 0.134369, 0.108965, 0.094595, 0.508065,
0.496240, 0.554786, 0.149986, 0.172337, 0.176674, 0.328340, 0.286826, 0.253818,
0.935375, 0.961009, 0.954670, 0.183517, 0.168974, 0.135119, 0.295954, 0.265310,
0.281583, 0.017212, 0.010681, 0.021456, 0.143008, 0.183985, 0.155913, 0.522738,
0.497242, 0.551542, 0.767707, 0.786324, 0.786953, 0.470968, 0.538266, 0.451544,
0.201860, 0.239897, 0.178194, 0.586703, 0.571956, 0.535398, 0.962275, 0.954267,
0.954670, 0.901159, 0.932003, 0.906685, 0.378630, 0.410163, 0.374134, 0.388401,
0.420180, 0.420926, 0.475966, 0.437068, 0.499617, 0.896623, 0.927344, 0.889962,
0.208112, 0.206702, 0.264474, 0.105775, 0.079885, 0.083419, 0.608068, 0.613277,
0.623868, 0.573784, 0.561914, 0.598922, 0.408993, 0.383846, 0.392037, 0.319915,
0.338121, 0.347749, 0.802033, 0.870388, 0.830608, 0.608068, 0.583182, 0.613277,
0.589235, 0.598531, 0.576702, 0.798413, 0.783038, 0.777901, 0.307596, 0.335099,
0.283919, 0.813596, 0.827742, 0.784475, 0.024007, 0.066085, 0.046260, 0.583810,
0.554786, 0.550978, 0.673679, 0.711175, 0.712415, 0.121253, 0.215603, 0.171662,
0.799858, 0.808129, 0.790471, 0.248179, 0.281317, 0.273421, 0.156535, 0.158296,
0.124612, 0.318752, 0.293881, 0.321688, 0.633885, 0.601612, 0.590082, 0.509769,
0.504391, 0.518445, 0.783983, 0.763951, 0.753165, 0.202715, 0.237063, 0.213359,
0.171662, 0.129634, 0.121253, 0.640244, 0.639779, 0.639467, 0.011336, 0.020351,
0.010686, 0.143694, 0.113351, 0.094235, 0.265747, 0.233018, 0.292648, 0.795795,
0.800342, 0.796229, 0.034026, 0.013098, 0.014141, 0.425975, 0.400072, 0.382832,
0.618611, 0.573144, 0.607338, 0.235970, 0.235047, 0.221720, 0.631543, 0.628720,
0.617541, 0.552824, 0.523417, 0.558567, 0.438837, 0.451544, 0.481438, 0.037231,
0.034656, 0.038500, 0.361369, 0.334072, 0.365981, 0.544270, 0.565875, 0.580026,
0.230564, 0.248179, 0.293613, 0.581875, 0.583810, 0.550978, 0.111894, 0.096574,
0.143810, 0.870225, 0.828299, 0.873205, 0.004188, 0.004275, 0.004321, 0.039942,
0.034781, 0.038500, 0.404023, 0.391531, 0.377905, 0.407382, 0.393430, 0.422486,
0.351649, 0.324122, 0.310304, 0.722040, 0.701966, 0.712381, 0.384507, 0.404818,
0.446278, 0.039634, 0.078296, 0.061599, 0.559246, 0.535571, 0.570249, 0.301843,
0.317101, 0.383846, 0.111013, 0.083547, 0.118810, 0.192175, 0.130864, 0.199723,
0.784967, 0.795795, 0.783371, 0.930276, 0.944081, 0.884422, 0.034665, 0.040995,
0.036033, 0.713887, 0.644678, 0.682049, 0.497043, 0.497175, 0.434677, 0.456935,
0.481554, 0.485571, 0.590082, 0.549744, 0.555574, 0.378630, 0.318138, 0.335161,
0.574678, 0.600264, 0.552233, 0.168154, 0.220099, 0.196743, 0.205465, 0.223505,
0.184955, 0.340402, 0.332487, 0.324344, 0.027904, 0.051923, 0.054299, 0.548086,
0.513430, 0.539462, 0.033878, 0.033744, 0.031167, 0.485571, 0.487098, 0.461924,
0.574678, 0.562367, 0.611832, 0.088893, 0.085193, 0.105532, 0.206983, 0.202557,
0.232111, 0.188810, 0.224704, 0.200538, 0.112311, 0.136126, 0.095264, 0.723415,
0.738950, 0.745447, 0.446354, 0.412111, 0.404692, 0.121081, 0.102514, 0.105775,
0.269941, 0.241443, 0.293881, 0.608068, 0.595518, 0.586010, 0.446278, 0.504686,
0.431175, 0.386283, 0.436893, 0.414498, 0.452062, 0.457384, 0.413875, 0.595518,
0.608068, 0.610638, 0.241443, 0.269941, 0.205465, 0.023304, 0.043005, 0.067420,
0.574758, 0.603128, 0.576335, 0.402228, 0.433814, 0.391477, 0.120847, 0.130864,
0.192175, 0.099946, 0.115517, 0.092698, 0.581875, 0.598531, 0.603459, 0.961009,
0.962275, 0.954670, 0.216528, 0.238043, 0.271060, 0.003390, 0.002471, 0.006539,
0.403730, 0.413106, 0.382603, 0.525717, 0.526202, 0.563501, 0.193273, 0.182907,
0.225566, 0.052787, 0.039634, 0.061599, 0.417717, 0.411694, 0.435557, 0.037296,
0.047534, 0.075045, 0.312432, 0.340586, 0.293303, 0.422486, 0.432858, 0.464650,
0.129157, 0.158296, 0.162490, 0.042020, 0.081791, 0.073073, 0.963667, 0.977962,
0.927344, 0.830608, 0.870388, 0.878299, 0.783038, 0.798413, 0.797532, 0.400072,
0.429157, 0.405072, 0.583182, 0.576940, 0.598603, 0.568562, 0.531676, 0.551289,
0.036721, 0.040947, 0.034698, 0.211948, 0.190409, 0.153630, 0.618136, 0.630671,
0.634366, 0.854713, 0.875727, 0.898367, 0.094235, 0.037783, 0.080629, 0.592821,
0.595601, 0.552032, 0.488081, 0.476542, 0.450942, 0.181292, 0.168241, 0.215382,
0.548465, 0.516928, 0.539197, 0.704294, 0.725749, 0.726454, 0.785555, 0.825887,
0.824931, 0.600928, 0.577043, 0.590535, 0.003436, 0.014795, 0.014887, 0.475700,
0.512744, 0.515846, 0.760087, 0.748839, 0.784475, 0.645041, 0.653538, 0.673679,
0.193273, 0.161032, 0.129336, 0.010681, 0.011526, 0.013109, 0.431874, 0.437068,
0.445406, 0.781015, 0.761517, 0.759196, 0.446278, 0.404818, 0.465924, 0.884422,
0.944081, 0.901159, 0.168951, 0.178298, 0.145580, 0.817628, 0.830054, 0.824514,
0.323468, 0.370271, 0.369926, 0.014949, 0.042020, 0.030924, 0.009672, 0.006063,
0.011519, 0.254290, 0.332703, 0.339030, 0.321044, 0.284131, 0.303730, 0.789424,
0.824931, 0.840311, 0.702425, 0.679225, 0.679906, 0.384507, 0.378607, 0.404818,
0.420613, 0.391531, 0.404023, 0.335111, 0.272321, 0.327279, 0.068716, 0.092698,
0.092140, 0.704294, 0.657947, 0.661852, 0.034656, 0.037231, 0.035294, 0.343403,
0.321688, 0.315961, 0.910349, 0.907234, 0.923353, 0.770772, 0.789497, 0.789302,
0.005708, 0.024203, 0.024206, 0.226237, 0.235116, 0.205689, 0.287105, 0.240803,
0.261727, 0.599754, 0.632768, 0.633665, 0.601284, 0.648494, 0.612875, 0.302194,
0.258853, 0.304963, 0.695188, 0.662527, 0.674709, 0.239897, 0.201860, 0.225728,
0.258438, 0.240169, 0.225566, 0.713887, 0.729834, 0.680770, 0.143346, 0.168951,
0.130106, 0.010658, 0.006036, 0.034122, 0.087698, 0.157892, 0.083596, 0.021456,
0.017711, 0.066972, 0.593992, 0.575245, 0.559246, 0.064449, 0.095895, 0.100287,
0.076816, 0.099946, 0.092698, 0.124103, 0.168974, 0.143008, 0.013594, 0.039634,
0.015471, 0.276567, 0.266441, 0.244916, 0.039942, 0.038500, 0.036177, 0.187586,
0.200608, 0.244033, 0.397813, 0.329758, 0.313625, 0.871465, 0.837348, 0.847418,
0.391478, 0.423783, 0.386508, 0.787860, 0.717028, 0.783234, 0.593992, 0.559246,
0.570249, 0.501116, 0.504821, 0.485571, 0.262288, 0.273811, 0.251893, 0.245643,
0.295954, 0.253528, 0.118952, 0.133682, 0.142155, 0.099171, 0.098921, 0.051923,
0.309062, 0.328340, 0.290614, 0.047984, 0.048765, 0.079939, 0.096644, 0.080790,
0.129336, 0.465516, 0.494595, 0.455165, 0.351237, 0.313055, 0.341130, 0.735285,
0.748839, 0.722040, 0.304963, 0.253528, 0.295954, 0.085500, 0.117739, 0.110783,
0.060302, 0.014795, 0.055856, 0.326581, 0.292007, 0.377894, 0.508818, 0.487145,
0.531793, 0.157440, 0.144610, 0.187241, 0.188880, 0.161282, 0.163405, 1.000000,
0.990938, 0.996376, 0.870225, 0.896478, 0.910349, 0.795506, 0.797532, 0.799636,
0.451544, 0.407634, 0.362043, 0.781328, 0.754377, 0.737401, 0.168974, 0.187764,
0.143008, 0.158360, 0.168789, 0.127617, 0.400072, 0.368571, 0.382832, 0.384507,
0.446278, 0.431175, 0.278085, 0.290232, 0.326408, 0.504686, 0.446278, 0.512648,
0.067437, 0.090392, 0.093174, 0.331894, 0.360704, 0.321044, 0.598071, 0.606544,
0.619399, 0.475966, 0.442789, 0.445406, 0.423783, 0.451357, 0.408983, 0.011336,
0.022050, 0.021676, 0.010681, 0.011966, 0.010408, 0.122776, 0.113781, 0.101979,
0.182440, 0.158296, 0.156535, 0.143346, 0.130106, 0.118810, 0.416363, 0.365981,
0.408007, 0.505281, 0.522738, 0.551289, 0.262288, 0.278308, 0.302474, 0.212363,
0.161032, 0.193273, 0.041480, 0.040220, 0.073651, 0.239897, 0.201223, 0.178194,
0.452062, 0.413875, 0.352789, 0.961773, 0.918572, 0.922962, 0.571956, 0.560147,
0.535398, 0.790026, 0.781015, 0.801183, 0.105532, 0.117483, 0.118952, 0.276567,
0.291860, 0.266441, 0.003390, 0.002069, 0.002471, 0.220718, 0.221720, 0.235047,
0.020493, 0.015655, 0.004190, 0.264474, 0.281287, 0.290614, 0.378630, 0.335161,
0.340586, 0.659071, 0.689207, 0.684635, 0.298879, 0.290232, 0.226257, 0.707811,
0.747747, 0.737307, 0.574758, 0.576335, 0.544931, 0.168154, 0.178194, 0.201223,
0.344310, 0.374134, 0.322722, 0.271060, 0.234262, 0.216528, 0.481281, 0.539534,
0.496082, 0.237063, 0.235728, 0.213359, 0.707811, 0.707215, 0.747747, 0.088347,
0.124103, 0.099946, 0.849942, 0.854183, 0.884615, 0.363064, 0.374079, 0.348735,
0.296017, 0.346069, 0.279103, 0.411940, 0.408983, 0.450804, 0.461924, 0.474175,
0.446354, 0.079481, 0.087341, 0.121380, 0.310287, 0.291860, 0.276567, 0.631543,
0.603580, 0.608753, 0.318752, 0.364872, 0.323468, 0.012023, 0.021254, 0.007171,
0.193273, 0.154422, 0.182907, 0.616422, 0.633127, 0.629331, 0.004332, 0.003390,
0.003179, 0.776035, 0.796229, 0.784505, 0.273811, 0.250526, 0.251893, 0.896478,
0.873205, 0.883009, 0.365485, 0.379722, 0.333281, 0.562299, 0.598520, 0.580101,
0.874326, 0.847418, 0.870038, 0.263797, 0.307596, 0.283919, 0.601612, 0.633885,
0.644678, 0.633572, 0.685828, 0.653538, 0.436188, 0.508818, 0.499617, 0.012890,
0.062026, 0.076816, 0.099460, 0.083547, 0.066085, 0.163341, 0.159542, 0.185827,
0.737401, 0.698054, 0.740170, 0.004188, 0.004321, 0.004785, 0.210788, 0.193509,
0.187241, 0.452874, 0.479163, 0.523285, 0.348735, 0.374079, 0.338409, 0.593992,
0.619114, 0.632768, 0.037296, 0.075045, 0.076557, 0.335739, 0.340553, 0.375993,
0.704294, 0.715013, 0.682773, 0.162490, 0.200608, 0.187586, 0.078296, 0.073038,
0.113781, 0.238248, 0.215603, 0.224263, 0.766448, 0.777901, 0.764051, 0.487110,
0.464650, 0.485075, 0.801183, 0.830153, 0.790026, 0.149859, 0.134388, 0.150508,
0.883026, 0.848552, 0.854797, 0.412111, 0.446354, 0.501372, 0.007618, 0.012537,
0.008508, 0.830608, 0.816302, 0.798288, 0.768780, 0.754377, 0.805240, 0.127889,
0.204617, 0.144610, 0.854869, 0.883026, 0.854797, 0.391478, 0.357595, 0.357269,
0.452920, 0.476942, 0.436893, 0.155913, 0.183985, 0.172420, 0.157892, 0.145580,
0.178298, 0.766106, 0.777653, 0.753165, 0.731324, 0.745556, 0.753165, 0.093836,
0.129336, 0.080790, 0.253528, 0.199723, 0.245643, 0.347749, 0.339649, 0.319915,
0.192175, 0.258853, 0.222293, 0.247905, 0.224704, 0.277250, 0.522738, 0.505281,
0.497242, 0.618611, 0.618163, 0.573144, 0.498537, 0.522081, 0.543130, 0.795869,
0.802033, 0.795506, 0.013594, 0.009481, 0.007919, 0.392815, 0.334244, 0.363116,
0.465516, 0.420180, 0.407155, 0.024007, 0.013445, 0.007171, 0.753165, 0.763951,
0.743121, 0.450942, 0.442703, 0.430421, 0.222088, 0.251574, 0.293881, 0.120847,
0.192175, 0.190543, 0.516928, 0.544270, 0.518445, 0.224263, 0.242984, 0.260223,
0.682773, 0.717028, 0.701030, 0.488081, 0.535398, 0.515663, 0.115655, 0.088347,
0.073651, 0.211657, 0.238770, 0.264004, 0.224263, 0.205145, 0.242984, 0.006907,
0.002069, 0.003541, 0.324122, 0.307596, 0.263797, 0.262288, 0.251893, 0.235047,
0.490442, 0.486499, 0.452062, 0.099091, 0.092140, 0.120027, 0.685828, 0.613196,
0.662527, 0.145580, 0.130106, 0.168951, 0.093836, 0.080790, 0.094235, 0.408547,
0.456935, 0.461924, 0.142593, 0.123280, 0.110783, 0.378154, 0.361369, 0.365981,
0.083419, 0.060302, 0.094595, 0.003179, 0.003169, 0.004332, 0.378630, 0.406128,
0.410163, 0.323468, 0.364872, 0.370271, 0.523285, 0.508751, 0.544441, 0.444586,
0.442789, 0.481457, 0.172420, 0.184955, 0.139167, 0.795795, 0.786978, 0.783371,
0.039556, 0.030738, 0.021025, 0.386041, 0.420180, 0.388401, 0.365485, 0.319688,
0.361369, 0.357269, 0.412111, 0.391478, 0.591234, 0.563904, 0.560384, 0.112311,
0.098921, 0.120847, 0.744374, 0.686751, 0.714070, 0.787102, 0.828299, 0.781199,
0.235972, 0.181292, 0.215382, 0.403972, 0.374732, 0.407634, 0.280174, 0.312432,
0.293303, 0.651184, 0.617279, 0.634420, 0.944081, 0.932003, 0.901159, 0.814647,
0.834859, 0.834178, 0.188810, 0.171250, 0.149416, 0.610098, 0.574678, 0.613196,
0.087341, 0.079481, 0.050445, 0.322065, 0.333245, 0.281583, 0.953441, 0.910349,
0.923353, 0.894331, 0.860663, 0.844318, 0.041818, 0.036721, 0.042062, 0.408007,
0.365981, 0.369926, 0.378154, 0.365485, 0.361369, 0.159542, 0.177225, 0.185827,
0.314728, 0.296410, 0.346069, 0.281317, 0.247936, 0.279103, 0.707215, 0.707811,
0.675509, 0.407601, 0.421324, 0.392037, 0.211948, 0.254290, 0.190409, 0.815596,
0.828299, 0.870225, 0.552032, 0.574758, 0.539534, 0.544859, 0.575245, 0.539156,
0.603459, 0.607338, 0.583810, 0.477212, 0.435557, 0.504562, 0.301843, 0.280536,
0.317101, 0.563904, 0.590535, 0.577043, 0.504821, 0.539197, 0.514420, 0.004332,
0.006622, 0.006036, 0.380199, 0.379722, 0.401071, 0.003537, 0.007618, 0.002888,
0.766448, 0.764051, 0.749093, 0.412111, 0.357269, 0.404692, 0.051923, 0.055939,
0.099171, 0.083152, 0.107340, 0.099460, 0.011148, 0.012537, 0.035390, 0.113351,
0.132925, 0.093836, 0.378154, 0.365981, 0.411174, 0.235047, 0.250526, 0.284131,
0.136126, 0.112311, 0.190543, 0.426379, 0.452874, 0.438079, 0.450804, 0.438290,
0.411940, 0.012890, 0.008508, 0.014530, 0.300633, 0.273387, 0.333281, 0.392267,
0.365485, 0.378154, 0.884615, 0.907202, 0.881348, 0.022871, 0.036302, 0.072757,
0.161408, 0.168154, 0.196743, 0.619114, 0.638612, 0.699298, 0.772515, 0.785555,
0.755388, 0.129634, 0.120543, 0.097951, 0.171250, 0.211948, 0.153630, 0.770772,
0.754121, 0.789497, 0.326162, 0.280704, 0.303919, 0.701204, 0.680770, 0.729834,
0.085193, 0.088893, 0.073721, 0.552233, 0.566213, 0.526202, 0.231054, 0.193509,
0.210788, 0.031929, 0.047095, 0.018863, 0.196017, 0.190707, 0.168017, 0.407634,
0.438837, 0.439159, 0.102855, 0.105532, 0.104415, 0.205689, 0.235116, 0.202760,
0.113330, 0.105313, 0.120543, 0.786978, 0.795795, 0.796229, 0.115517, 0.099946,
0.120186, 0.636289, 0.627314, 0.619399, 0.501116, 0.481554, 0.494595, 0.599491,
0.580026, 0.565875, 0.030161, 0.011900, 0.040145, 0.010074, 0.010433, 0.009745,
0.205145, 0.224263, 0.185458, 0.573784, 0.555824, 0.517926, 0.409785, 0.430421,
0.442703, 0.586982, 0.600264, 0.645041, 0.080790, 0.065834, 0.094235, 0.486499,
0.520385, 0.517926, 0.828299, 0.843115, 0.873205, 0.365706, 0.345580, 0.382603,
0.801183, 0.773874, 0.813995, 0.002824, 0.002105, 0.008617, 0.573784, 0.551909,
0.561914, 0.177477, 0.205689, 0.176329, 0.383846, 0.408993, 0.431874, 0.025217,
0.011275, 0.014343, 0.007618, 0.007171, 0.002888, 0.280536, 0.256341, 0.225681,
0.090735, 0.123280, 0.113633, 0.476942, 0.498537, 0.436893, 0.276567, 0.284131,
0.310287, 0.603128, 0.595601, 0.616422, 0.260223, 0.319915, 0.299945, 0.456935,
0.485571, 0.461924, 0.918572, 0.968684, 0.972893, 0.012689, 0.027904, 0.021100,
0.931428, 0.952280, 0.916161, 0.066003, 0.014820, 0.037296, 0.012983, 0.010324,
0.009672, 0.378607, 0.384507, 0.333245, 0.248179, 0.208408, 0.281317, 0.531676,
0.505281, 0.551289, 0.516208, 0.518701, 0.531409, 0.057956, 0.097951, 0.087642,
0.576702, 0.545687, 0.580101, 0.079939, 0.100987, 0.088640, 0.003169, 0.003179,
0.012903, 0.369119, 0.360704, 0.331894, 0.413875, 0.457384, 0.397650, 0.099460,
0.107340, 0.143346, 0.115862, 0.117483, 0.093174, 0.403680, 0.406128, 0.371853,
0.475280, 0.481281, 0.439455, 0.313625, 0.405072, 0.397813, 0.436188, 0.499617,
0.421324, 0.197971, 0.226237, 0.205689, 0.448497, 0.436772, 0.416363, 0.434677,
0.407155, 0.410269, 0.996376, 0.952280, 0.983265, 0.531676, 0.581457, 0.525023,
0.529249, 0.558837, 0.545302, 0.158360, 0.190409, 0.222909, 0.247905, 0.200538,
0.224704, 0.015471, 0.041480, 0.043771, 0.134369, 0.132422, 0.176257, 0.346181,
0.404023, 0.377905, 0.232806, 0.229455, 0.265213, 0.018863, 0.014820, 0.031929,
0.554786, 0.583810, 0.544441, 0.753165, 0.695188, 0.731324, 0.240169, 0.212363,
0.225566, 0.496240, 0.508065, 0.476169, 0.006907, 0.004836, 0.002069, 0.577965,
0.562299, 0.539046, 0.145106, 0.132270, 0.117577, 0.005708, 0.002471, 0.002069,
0.365663, 0.338121, 0.350170, 0.322065, 0.304518, 0.339649, 0.232548, 0.264474,
0.206702, 0.190409, 0.240920, 0.222909, 0.047095, 0.067437, 0.093174, 0.430421,
0.409785, 0.403972, 0.007919, 0.017714, 0.018570, 0.051923, 0.098921, 0.054299,
0.839445, 0.815206, 0.834514, 0.799858, 0.783983, 0.753165, 0.409785, 0.408007,
0.369926, 0.040947, 0.036721, 0.041818, 0.025217, 0.070688, 0.036302, 0.581652,
0.558567, 0.601612, 0.458647, 0.425975, 0.414498, 0.475700, 0.470267, 0.512744,
0.365046, 0.371853, 0.340586, 0.043771, 0.012556, 0.015471, 0.743121, 0.695188,
0.753165, 0.746277, 0.737307, 0.747747, 0.497043, 0.532962, 0.497175, 0.277250,
0.326408, 0.328198, 0.518701, 0.552824, 0.531409, 0.408547, 0.461924, 0.421163,
0.715013, 0.717028, 0.682773, 0.639467, 0.628424, 0.629331, 0.036721, 0.040259,
0.042062, 0.714070, 0.671010, 0.699298, 0.438079, 0.452874, 0.523285, 0.293881,
0.318752, 0.269941, 0.222909, 0.240444, 0.208925, 0.821192, 0.839445, 0.847418,
0.522033, 0.549744, 0.521378, 0.149986, 0.176674, 0.169455, 0.186921, 0.199293,
0.219078, 0.038639, 0.084675, 0.081791, 0.329278, 0.398931, 0.340553, 0.346069,
0.386206, 0.362043, 0.799966, 0.763508, 0.790020, 0.205910, 0.232548, 0.155233,
0.360704, 0.353167, 0.321044, 0.355892, 0.346181, 0.377905, 0.916161, 0.898367,
0.875727, 0.014141, 0.013098, 0.011336, 0.684635, 0.675509, 0.659071, 0.487110,
0.509030, 0.476942, 0.139167, 0.115517, 0.172420, 0.094775, 0.086244, 0.104415,
0.504391, 0.516928, 0.518445, 0.301055, 0.313055, 0.268215, 0.614019, 0.674709,
0.611832, 0.073721, 0.043005, 0.056911, 0.184242, 0.181002, 0.133116, 0.935375,
0.881348, 0.907202, 0.232548, 0.206702, 0.172107, 0.368235, 0.397650, 0.358133,
0.411807, 0.411832, 0.438079, 0.552032, 0.502292, 0.522070, 0.341130, 0.368571,
0.351237, 0.355892, 0.335637, 0.346181, 0.120847, 0.190543, 0.112311, 0.520497,
0.509030, 0.487110, 0.407601, 0.392037, 0.391531, 0.090392, 0.144072, 0.115862,
0.793011, 0.790471, 0.794322, 0.197971, 0.184955, 0.223505, 0.183985, 0.205465,
0.172420, 0.131032, 0.147892, 0.149986, 0.262288, 0.235970, 0.240803, 0.229590,
0.283919, 0.281287, 0.374516, 0.347749, 0.379428, 0.003179, 0.002105, 0.003524,
0.474002, 0.458647, 0.489987, 0.815237, 0.815206, 0.809096, 0.121380, 0.133116,
0.181002, 0.426379, 0.401099, 0.397813, 0.020663, 0.034122, 0.006622, 0.435557,
0.411694, 0.411174, 0.010681, 0.010408, 0.011469, 0.240920, 0.254290, 0.339030,
0.554786, 0.489987, 0.513644, 0.436188, 0.487145, 0.508818, 0.076557, 0.075045,
0.098954, 0.878299, 0.934587, 0.880061, 0.019744, 0.068657, 0.055939, 0.796212,
0.839943, 0.789497, 0.034026, 0.037783, 0.013098, 0.603128, 0.629331, 0.604420,
0.188880, 0.197989, 0.161282, 0.011519, 0.010891, 0.034442, 0.352789, 0.374134,
0.452062, 0.475700, 0.435557, 0.436772, 0.907234, 0.906685, 0.932003, 0.065258,
0.075045, 0.047534, 0.202557, 0.235116, 0.263012, 0.476542, 0.488081, 0.515663,
0.473659, 0.509206, 0.510088, 0.617279, 0.648584, 0.618611, 0.990938, 0.972803,
0.977962, 0.180804, 0.145106, 0.187776, 0.870388, 0.863273, 0.889962, 0.353167,
0.398992, 0.380459, 0.840881, 0.830054, 0.854869, 0.465924, 0.438290, 0.495798,
0.079885, 0.038639, 0.028528, 0.162877, 0.118360, 0.121081, 0.874495, 0.825775,
0.918739, 0.085500, 0.056613, 0.066972, 0.679906, 0.679225, 0.630671, 0.120186,
0.099946, 0.143008, 0.235116, 0.192074, 0.202760, 0.482495, 0.507207, 0.497043,
0.884615, 0.939051, 0.907202, 0.374732, 0.343071, 0.362043, 0.544931, 0.496082,
0.539534, 0.149416, 0.123060, 0.162490, 0.135119, 0.111894, 0.136092, 0.495798,
0.494200, 0.465924, 0.408983, 0.379428, 0.365663, 0.577965, 0.570804, 0.603697,
0.363927, 0.296017, 0.339030, 0.744374, 0.746277, 0.763993, 0.352789, 0.357654,
0.327296, 0.034781, 0.029164, 0.014252, 0.097951, 0.094338, 0.121253, 0.465207,
0.497242, 0.505281, 0.180804, 0.196017, 0.168017, 0.630671, 0.601286, 0.623958,
0.402798, 0.425327, 0.378359, 0.799636, 0.798413, 0.800342, 0.031167, 0.040259,
0.036721, 0.073651, 0.088347, 0.041480, 0.177225, 0.156096, 0.166917, 0.196017,
0.229455, 0.190707, 0.972803, 0.990938, 1.000000, 0.319915, 0.303801, 0.338121,
0.451153, 0.432858, 0.432995, 0.529249, 0.531793, 0.504686, 0.007614, 0.020718,
0.009481, 0.219078, 0.199293, 0.193509, 0.304163, 0.311621, 0.350170, 0.058976,
0.096644, 0.073038, 0.624131, 0.617593, 0.612953, 0.520497, 0.485075, 0.464650,
0.092140, 0.070149, 0.068716, 0.386206, 0.346069, 0.391477, 0.004321, 0.005038,
0.004785, 0.539462, 0.584780, 0.548086, 0.631543, 0.628424, 0.639779, 0.398931,
0.375993, 0.340553, 0.815237, 0.809096, 0.779755, 0.558428, 0.573151, 0.591234,
0.051212, 0.069319, 0.076752, 0.182907, 0.168789, 0.208925, 0.772515, 0.760087,
0.784475, 0.036045, 0.038860, 0.031167, 0.639467, 0.639779, 0.628424, 0.245715,
0.242896, 0.197971, 0.603697, 0.603580, 0.631543, 0.085193, 0.094775, 0.104415,
0.995927, 0.983265, 0.978515, 0.869102, 0.844318, 0.830153, 0.291004, 0.298693,
0.265747, 0.127889, 0.121380, 0.204617, 0.644678, 0.713887, 0.680770, 0.522033,
0.521762, 0.555574, 0.431874, 0.408993, 0.421324, 0.402798, 0.358133, 0.397650,
0.817628, 0.815237, 0.799966, 0.006063, 0.009672, 0.011946, 0.262805, 0.248852,
0.240920, 0.576335, 0.556814, 0.538266, 0.509030, 0.539046, 0.545687, 0.790020,
0.749583, 0.726454, 0.081791, 0.102514, 0.092353, 0.512744, 0.554669, 0.539462,
0.007059, 0.009875, 0.005552, 0.972893, 0.949508, 0.917827, 0.265747, 0.292648,
0.291004, 0.640244, 0.636289, 0.639779, 0.208408, 0.196743, 0.281317, 0.522070,
0.517926, 0.555824, 0.013305, 0.014141, 0.011900, 0.597974, 0.605889, 0.600963,
0.319688, 0.334072, 0.361369, 0.824221, 0.866728, 0.854713, 0.345580, 0.365706,
0.335099, 0.461807, 0.473659, 0.481420, 0.556814, 0.515007, 0.510088, 0.303919,
0.291860, 0.320601, 0.781199, 0.737401, 0.765284, 0.332703, 0.277250, 0.328198,
0.618136, 0.661852, 0.632710, 0.612875, 0.648494, 0.638612, 0.298693, 0.310304,
0.324122, 0.601284, 0.563501, 0.566213, 0.247905, 0.332703, 0.254290, 0.066977,
0.100287, 0.076502, 0.487098, 0.509769, 0.500306, 0.738104, 0.761517, 0.722720,
0.258853, 0.302194, 0.282901, 0.891058, 0.872219, 0.901159, 0.679225, 0.658166,
0.630671, 0.328198, 0.326408, 0.358133, 0.265310, 0.197984, 0.281583, 0.578378,
0.612875, 0.565875, 0.240803, 0.287105, 0.278308, 0.799858, 0.777653, 0.814647,
0.829621, 0.863273, 0.870388, 0.586703, 0.604420, 0.628424, 0.521762, 0.539156,
0.555574, 0.334902, 0.363064, 0.348735, 0.102855, 0.093174, 0.117483, 0.018740,
0.031304, 0.043005, 0.016854, 0.039634, 0.013594, 0.619399, 0.628720, 0.636289,
0.006815, 0.004190, 0.013891, 0.562367, 0.534754, 0.572419, 0.365663, 0.386508,
0.392405, 0.009481, 0.012556, 0.014530, 0.338409, 0.341130, 0.313055, 0.251574,
0.275438, 0.293881, 0.014530, 0.008508, 0.007614, 0.598520, 0.597974, 0.580101,
0.225681, 0.229455, 0.195187, 0.558567, 0.590082, 0.601612, 0.280536, 0.282901,
0.322656, 0.273421, 0.296410, 0.314728, 0.766106, 0.790026, 0.793439, 0.497043,
0.507207, 0.532962, 0.005708, 0.004836, 0.024203, 0.711175, 0.743121, 0.752478,
0.463167, 0.402798, 0.437555, 0.037783, 0.032096, 0.013098, 0.452920, 0.436893,
0.386283, 0.388401, 0.364617, 0.386041, 0.037296, 0.017569, 0.009900, 0.838981,
0.843115, 0.828299, 0.610638, 0.600963, 0.595518, 0.168017, 0.163405, 0.145106,
0.437068, 0.431874, 0.421324, 0.010324, 0.011946, 0.009672, 0.338197, 0.331724,
0.358290, 0.040995, 0.039942, 0.036177, 0.156096, 0.150508, 0.166917, 0.402940,
0.383846, 0.420601, 0.834178, 0.884422, 0.901159, 0.096644, 0.101979, 0.073038,
0.011275, 0.025217, 0.017884, 0.611948, 0.566213, 0.586982, 0.088640, 0.100987,
0.114289, 0.450804, 0.476906, 0.495798, 0.017212, 0.021456, 0.056613, 0.475966,
0.507104, 0.481457, 0.013920, 0.005552, 0.006125, 0.456935, 0.398992, 0.412078,
0.313625, 0.351237, 0.400072, 0.004836, 0.005708, 0.002069, 0.144072, 0.149986,
0.169455, 0.344310, 0.318138, 0.378630, 0.675509, 0.707811, 0.648494, 0.110356,
0.158360, 0.127617, 0.447118, 0.481554, 0.456935, 0.827742, 0.871275, 0.854183,
0.554669, 0.515663, 0.560147, 0.507207, 0.482495, 0.505219, 0.131032, 0.090392,
0.106590, 0.060183, 0.054299, 0.088559, 0.006036, 0.003460, 0.004332, 0.332487,
0.303730, 0.324344, 0.680770, 0.679906, 0.655607, 0.176329, 0.205689, 0.202760,
0.180804, 0.229455, 0.196017, 0.095264, 0.085500, 0.066972, 0.010681, 0.017212,
0.011966, 0.188919, 0.202557, 0.168951, 0.024203, 0.047984, 0.024206, 0.009542,
0.017884, 0.022871, 0.800578, 0.835496, 0.863273, 0.205465, 0.222088, 0.241443,
0.715013, 0.763508, 0.737048, 0.622793, 0.633885, 0.590082, 0.871465, 0.874326,
0.904488, 0.013445, 0.002888, 0.007171, 0.371853, 0.406128, 0.378630, 0.603459,
0.612953, 0.617593, 0.815237, 0.824514, 0.835458, 0.527657, 0.504562, 0.513430,
0.380199, 0.403730, 0.382603, 0.557534, 0.573151, 0.558428, 0.345580, 0.335099,
0.307596, 0.487098, 0.474175, 0.461924, 0.404640, 0.379428, 0.411940, 0.983265,
0.952280, 0.978515, 0.120027, 0.147745, 0.099091, 0.581457, 0.568562, 0.600928,
0.149416, 0.114948, 0.123060, 0.003537, 0.006036, 0.004917, 0.801183, 0.813995,
0.830153, 0.090392, 0.089720, 0.105250, 0.465207, 0.424076, 0.444586, 0.701966,
0.698054, 0.712381, 0.392815, 0.393430, 0.407382, 0.745447, 0.762583, 0.725749,
0.473659, 0.438837, 0.481438, 0.182440, 0.185918, 0.216528, 0.482495, 0.497043,
0.434677, 0.199827, 0.224263, 0.215603, 0.414498, 0.436893, 0.458647, 0.269550,
0.231054, 0.271844, 0.268215, 0.202715, 0.249319, 0.005552, 0.009875, 0.011307,
0.737307, 0.699298, 0.690481, 0.079481, 0.003541, 0.050445, 0.799636, 0.797532,
0.798413, 0.573784, 0.598922, 0.592821, 0.051767, 0.058976, 0.073038, 0.574758,
0.552032, 0.595601, 0.205197, 0.186921, 0.219078, 0.066085, 0.083547, 0.070145,
0.094338, 0.067420, 0.088893, 0.900836, 0.854869, 0.892226, 0.291004, 0.331724,
0.338197, 0.293303, 0.238043, 0.280174, 0.753165, 0.777653, 0.799858, 0.977962,
0.972803, 0.934587, 0.143694, 0.094235, 0.127617, 0.226237, 0.197971, 0.228778,
0.929490, 0.899050, 0.924385, 0.284131, 0.321044, 0.310287, 0.801183, 0.781015,
0.759196, 0.031167, 0.031124, 0.013577, 0.496240, 0.474002, 0.489987, 0.780340,
0.793011, 0.784967, 0.600963, 0.610638, 0.615694, 0.210788, 0.187241, 0.204617,
0.583810, 0.607338, 0.544441, 0.780340, 0.783983, 0.790471, 0.012890, 0.076816,
0.062456, 0.263797, 0.233018, 0.265747, 0.618163, 0.572419, 0.573144, 0.098954,
0.105250, 0.089720, 0.333245, 0.322065, 0.378607, 0.601612, 0.644678, 0.611363,
0.033878, 0.036033, 0.036177, 0.374079, 0.363064, 0.386283, 0.554239, 0.587972,
0.541544, 0.898367, 0.916161, 0.921946, 0.854183, 0.871275, 0.891271, 0.421324,
0.408993, 0.392037, 0.617541, 0.619399, 0.606544, 0.495798, 0.476906, 0.516208,
0.047095, 0.037143, 0.018863, 0.382603, 0.393430, 0.365706, 0.929490, 0.930276,
0.894331, 0.586010, 0.579062, 0.557534, 0.004190, 0.007258, 0.007193, 0.021456,
0.010681, 0.017711, 0.069319, 0.051212, 0.056613, 0.584780, 0.596870, 0.608753,
0.287339, 0.318138, 0.322722, 0.249041, 0.215382, 0.240169, 0.476169, 0.450599,
0.474002, 0.739998, 0.707256, 0.748839, 0.790020, 0.807724, 0.817628, 0.087642,
0.120543, 0.105313, 0.079885, 0.062103, 0.083419, 0.379428, 0.404640, 0.374516,
0.954670, 0.944081, 0.930276, 0.249041, 0.235972, 0.215382, 0.416363, 0.411174,
0.365981, 0.952280, 0.931428, 0.945307, 0.476942, 0.463813, 0.487110, 0.723415,
0.676069, 0.679225, 0.142593, 0.132270, 0.163405, 0.019402, 0.004321, 0.003169,
0.021025, 0.011966, 0.017212, 0.281317, 0.196743, 0.220099, 0.238043, 0.216528,
0.197989, 0.762583, 0.798288, 0.816302, 0.796212, 0.854713, 0.839943, 0.197984,
0.238248, 0.281583, 0.722040, 0.712381, 0.735285, 0.651184, 0.681580, 0.648584,
0.014820, 0.017569, 0.037296, 0.365046, 0.340586, 0.344487, 0.183517, 0.248179,
0.230564, 0.551518, 0.535398, 0.515007, 0.273387, 0.247470, 0.283877, 0.080790,
0.051407, 0.065834, 0.541544, 0.573363, 0.553414, 0.011307, 0.037612, 0.034665,
0.383846, 0.431874, 0.420601, 0.124612, 0.113633, 0.145451, 0.368235, 0.358133,
0.326408, 0.145580, 0.157892, 0.111013, 0.508818, 0.558428, 0.560384, 0.208925,
0.225566, 0.182907, 0.598531, 0.554485, 0.576702, 0.391531, 0.392037, 0.377905,
0.402228, 0.363927, 0.378359, 0.158360, 0.110356, 0.116784, 0.343071, 0.314728,
0.362043, 0.314728, 0.346069, 0.362043, 0.064449, 0.066977, 0.039556, 0.368235,
0.337116, 0.327296, 0.627314, 0.636289, 0.632004, 0.182907, 0.154422, 0.168789,
0.418941, 0.386206, 0.433814, 0.607338, 0.603459, 0.617593, 0.633455, 0.659071,
0.648494, 0.034656, 0.036177, 0.038500, 0.409785, 0.373463, 0.403972, 0.718978,
0.691070, 0.701030, 0.123280, 0.161282, 0.113633, 0.008508, 0.011148, 0.009875,
0.586703, 0.628424, 0.596870, 0.629331, 0.628424, 0.604420, 0.707256, 0.739998,
0.722720, 0.496240, 0.489987, 0.554786, 0.262917, 0.266727, 0.304163, 0.701966,
0.689486, 0.618163, 0.726042, 0.717028, 0.749128, 0.457384, 0.437555, 0.397650,
0.601286, 0.630671, 0.598603, 0.438079, 0.523285, 0.505219, 0.411694, 0.417717,
0.401071, 0.551289, 0.551542, 0.577043, 0.034698, 0.034442, 0.036033, 0.738950,
0.702425, 0.724781, 0.742764, 0.766448, 0.714725, 0.598603, 0.576940, 0.601286,
0.418941, 0.470968, 0.451544, 0.206357, 0.175045, 0.176257, 0.907030, 0.870038,
0.917827, 0.334902, 0.348735, 0.309062, 0.024206, 0.047984, 0.009900, 0.293613,
0.315961, 0.275438, 0.586703, 0.596870, 0.577647, 0.014252, 0.004917, 0.011037,
0.296141, 0.293613, 0.274097, 0.003537, 0.014949, 0.003460, 0.745447, 0.767707,
0.762583, 0.996376, 0.963667, 0.952280, 0.825049, 0.824221, 0.854713, 0.204617,
0.187241, 0.144610, 0.614571, 0.633665, 0.644921, 0.476542, 0.442703, 0.450942,
0.786324, 0.795506, 0.786953, 0.061599, 0.079534, 0.052787, 0.712415, 0.704675,
0.689207, 0.543130, 0.513644, 0.498537, 0.736108, 0.752478, 0.761743, 0.561914,
0.581457, 0.584713, 0.035294, 0.034673, 0.034355, 0.178194, 0.143810, 0.174035,
0.039634, 0.016854, 0.051767, 0.205465, 0.183985, 0.222088, 0.854797, 0.834514,
0.835458, 0.094595, 0.108965, 0.105775, 0.391478, 0.451357, 0.423783, 0.623720,
0.609129, 0.613717, 0.527657, 0.513430, 0.548086, 0.398992, 0.353167, 0.360704,
0.848552, 0.875851, 0.870038, 0.907030, 0.905156, 0.874326, 0.814647, 0.834178,
0.799858, 0.552233, 0.532962, 0.574678, 0.514420, 0.516928, 0.487098, 0.283877,
0.247470, 0.274097, 0.096574, 0.111894, 0.079534, 0.865408, 0.805790, 0.849628,
0.784967, 0.793011, 0.795795, 0.118360, 0.102514, 0.121081, 0.238248, 0.171662,
0.215603, 0.271844, 0.272321, 0.335111, 0.450804, 0.408983, 0.440728, 0.143694,
0.154422, 0.132925, 0.335739, 0.386041, 0.364617, 0.539197, 0.501116, 0.525717,
0.518445, 0.535571, 0.509769, 0.526666, 0.544859, 0.500306, 0.438079, 0.505219,
0.449286, 0.185827, 0.172337, 0.163341, 0.685828, 0.633572, 0.613196, 0.211948,
0.247905, 0.254290, 0.378154, 0.411174, 0.392267, 0.011974, 0.011036, 0.012689,
0.107870, 0.092353, 0.102359, 0.995927, 0.978515, 0.972893, 0.008617, 0.009542,
0.010206, 0.834514, 0.854797, 0.848552, 0.069319, 0.090735, 0.076752, 0.513430,
0.485556, 0.515846, 0.464287, 0.502292, 0.402798, 0.014252, 0.034688, 0.012537,
0.009557, 0.032547, 0.013577, 0.739998, 0.738104, 0.722720, 0.946103, 0.922962,
0.892226, 0.404640, 0.438290, 0.465924, 0.420613, 0.447781, 0.407203, 0.433814,
0.386206, 0.391477, 0.242896, 0.247470, 0.228778, 0.145451, 0.156535, 0.124612,
0.302194, 0.304963, 0.346181, 0.514420, 0.539197, 0.516928, 0.513644, 0.550978,
0.554786, 0.613212, 0.633127, 0.616422, 0.424076, 0.465207, 0.446067, 0.238770,
0.233018, 0.263797, 0.496082, 0.538266, 0.470968, 0.226257, 0.207629, 0.182440,
0.094775, 0.072757, 0.078554, 0.293613, 0.365485, 0.283877, 0.172107, 0.108965,
0.155233, 0.644921, 0.633885, 0.622793, 0.458647, 0.474002, 0.425975, 0.563904,
0.499617, 0.560384, 0.452920, 0.386283, 0.392815, 0.037612, 0.040995, 0.034665,
0.132925, 0.113351, 0.143694, 0.904488, 0.916161, 0.875727, 0.034710, 0.034673,
0.034122, 0.019608, 0.019744, 0.055939, 0.764051, 0.777901, 0.783038, 0.720767,
0.675509, 0.684635, 0.807724, 0.790020, 0.780973, 0.078296, 0.039634, 0.051767,
0.175045, 0.155233, 0.134369, 0.262288, 0.302474, 0.281168, 0.477212, 0.504562,
0.464650, 0.606508, 0.644921, 0.622793, 0.617279, 0.617593, 0.634420, 0.080629,
0.116784, 0.110356, 0.235047, 0.251893, 0.250526, 0.461807, 0.430421, 0.439159,
0.168241, 0.212363, 0.215382, 0.800578, 0.795869, 0.789302, 0.185458, 0.176674,
0.205145, 0.333281, 0.358290, 0.331724, 0.176674, 0.209285, 0.205145, 0.230564,
0.228883, 0.183517, 0.024007, 0.038928, 0.066085, 0.205197, 0.221720, 0.177225,
0.551542, 0.563904, 0.577043, 0.009745, 0.010433, 0.011036, 0.014343, 0.047730,
0.025217, 0.006539, 0.009542, 0.007370, 0.618611, 0.607338, 0.617279, 0.773614,
0.784967, 0.761743, 0.039942, 0.035390, 0.034688, 0.630671, 0.649789, 0.679906,
0.273387, 0.300633, 0.263012, 0.412111, 0.501372, 0.451357, 0.271060, 0.308621,
0.318138, 0.840881, 0.824514, 0.830054, 0.639467, 0.633127, 0.640244, 0.334244,
0.334902, 0.309062, 0.012689, 0.010433, 0.019608, 0.598922, 0.613212, 0.616422,
0.274097, 0.245715, 0.282334, 0.447781, 0.504686, 0.487145, 0.051407, 0.080790,
0.058976, 0.499617, 0.507104, 0.475966, 0.409785, 0.364872, 0.373463, 0.885808,
0.924385, 0.869102, 0.496924, 0.474175, 0.490038, 0.013098, 0.032096, 0.016854,
0.010206, 0.009542, 0.022871, 0.611569, 0.591234, 0.623720, 0.084675, 0.038639,
0.079885, 0.425327, 0.439455, 0.402228, 0.377894, 0.292007, 0.301843, 0.261797,
0.258438, 0.248852, 0.513644, 0.489987, 0.498537, 0.603580, 0.603697, 0.573608,
0.586703, 0.551518, 0.556814, 0.954670, 0.930276, 0.929490, 0.238770, 0.206983,
0.233018, 0.301055, 0.338409, 0.313055, 0.640244, 0.633127, 0.627137, 0.363116,
0.319034, 0.335099, 0.737401, 0.781199, 0.781328, 0.337116, 0.368235, 0.326408,
0.508818, 0.531793, 0.558428, 0.796212, 0.789497, 0.778092, 0.949508, 0.978515,
0.945307, 0.442703, 0.448497, 0.408007, 0.576940, 0.583182, 0.558837, 0.011900,
0.014141, 0.010686, 0.465207, 0.481457, 0.497242, 0.473659, 0.439159, 0.438837,
0.475280, 0.439455, 0.425327, 0.197971, 0.242896, 0.228778, 0.235728, 0.237112,
0.210788, 0.114948, 0.171250, 0.116784, 0.917827, 0.949508, 0.907030, 0.581652,
0.611363, 0.587972, 0.432995, 0.417717, 0.435557, 0.763951, 0.783983, 0.780340,
0.632710, 0.623868, 0.613277, 0.017278, 0.020493, 0.004190, 0.014707, 0.005552,
0.021655, 0.520385, 0.561914, 0.551909, 0.360704, 0.369119, 0.412078, 0.296017,
0.262805, 0.240920, 0.102855, 0.086244, 0.070688, 0.577647, 0.560147, 0.571956,
0.516245, 0.504562, 0.527657, 0.780340, 0.784967, 0.773614, 0.954267, 0.932003,
0.944081, 0.704675, 0.712415, 0.733680, 0.211948, 0.200538, 0.247905, 0.847418,
0.839445, 0.870038, 0.178298, 0.211657, 0.157892, 0.870038, 0.839445, 0.848552,
0.310537, 0.261727, 0.269550, 0.586982, 0.645041, 0.611948, 0.121380, 0.100987,
0.079481, 0.525023, 0.581457, 0.561914, 0.552824, 0.518701, 0.523417, 0.463813,
0.464650, 0.487110, 0.793011, 0.794322, 0.800342, 0.374516, 0.404640, 0.404818,
0.553414, 0.526318, 0.541544, 0.136092, 0.111894, 0.143810, 0.008617, 0.010017,
0.004840, 0.573608, 0.548086, 0.584780, 0.939051, 0.884615, 0.891271, 0.154422,
0.143694, 0.168789, 0.591234, 0.609129, 0.623720, 0.036033, 0.010891, 0.011307,
0.509206, 0.473659, 0.481438, 0.383846, 0.322656, 0.335637, 0.209285, 0.230247,
0.227892, 0.005181, 0.062103, 0.006691, 0.296017, 0.279103, 0.262805, 0.366154,
0.357595, 0.386508, 0.097951, 0.121253, 0.129634, 0.029164, 0.039942, 0.034688,
0.611948, 0.601284, 0.566213, 0.005485, 0.010017, 0.005915, 0.088347, 0.043771,
0.041480, 0.623868, 0.632710, 0.624131, 0.130106, 0.145580, 0.111013, 0.748319,
0.701204, 0.729834, 0.707256, 0.689486, 0.701966, 0.422486, 0.393430, 0.413106,
0.378630, 0.340586, 0.371853, 0.199293, 0.186921, 0.178524, 0.799858, 0.790471,
0.783983, 0.629541, 0.600928, 0.611569, 0.304163, 0.266727, 0.280704, 0.400072,
0.474002, 0.429157, 0.014141, 0.013305, 0.034026, 0.327279, 0.411832, 0.335111,
0.400072, 0.351237, 0.368571, 0.085193, 0.056911, 0.072757, 0.057956, 0.068657,
0.019744, 0.405072, 0.426379, 0.397813, 0.447781, 0.420613, 0.431175, 0.227892,
0.266727, 0.262917, 0.207629, 0.200608, 0.158296, 0.107340, 0.083152, 0.099091,
0.581457, 0.603603, 0.584713, 0.761743, 0.783371, 0.772046, 0.558837, 0.526318,
0.576940, 0.516208, 0.526318, 0.494200, 0.557534, 0.558428, 0.531793, 0.763951,
0.773614, 0.752478, 0.605889, 0.596681, 0.595518, 0.014343, 0.011275, 0.006539,
0.839445, 0.834514, 0.848552, 0.889962, 0.927344, 0.927069, 0.763508, 0.799966,
0.773489, 0.529249, 0.504686, 0.512648, 0.501372, 0.518701, 0.497616, 0.843115,
0.883009, 0.873205, 0.917827, 0.875851, 0.972893, 0.905156, 0.904488, 0.874326,
0.598531, 0.589235, 0.612953, 0.573784, 0.517926, 0.551909, 0.544931, 0.539534,
0.574758, 0.116784, 0.076502, 0.114948, 0.618695, 0.572419, 0.618163, 0.226237,
0.228778, 0.247470, 0.028528, 0.062103, 0.079885, 0.133116, 0.107870, 0.125529,
0.027904, 0.019608, 0.051923, 0.197984, 0.265310, 0.245643, 0.079534, 0.111894,
0.052787, 0.755388, 0.739998, 0.748839, 0.065834, 0.037783, 0.094235, 0.281287,
0.283919, 0.334244, 0.079481, 0.100987, 0.079939, 0.079939, 0.048765, 0.079481,
0.369926, 0.365981, 0.323468, 0.014795, 0.003436, 0.002888, 0.815206, 0.783234,
0.809096, 0.431175, 0.404023, 0.384507, 0.178524, 0.187241, 0.193509, 0.056613,
0.085500, 0.069319, 0.870038, 0.875851, 0.917827, 0.420180, 0.386041, 0.407155,
0.139041, 0.177477, 0.176329, 0.133116, 0.087341, 0.107870, 0.312432, 0.292007,
0.326581, 0.632710, 0.657947, 0.624131, 0.168789, 0.158360, 0.208925, 0.972803,
1.000000, 0.961773, 0.014343, 0.006539, 0.018863, 0.513430, 0.515846, 0.539462,
0.335161, 0.293303, 0.340586, 0.601612, 0.611363, 0.581652, 0.793439, 0.834859,
0.814647, 0.012689, 0.017711, 0.010681, 0.111894, 0.115655, 0.073651, 0.036721,
0.034698, 0.033878, 0.168241, 0.181292, 0.122776, 0.030924, 0.042020, 0.073073,
0.627314, 0.632004, 0.623720, 0.268215, 0.313055, 0.277732, 0.392815, 0.386283,
0.363064, 0.789424, 0.755388, 0.785555, 0.761517, 0.745556, 0.722720, 0.068657,
0.113330, 0.099171, 0.398992, 0.456935, 0.408547, 0.561914, 0.520385, 0.525023,
0.037612, 0.009875, 0.011148, 0.220099, 0.247936, 0.281317, 0.891271, 0.910349,
0.939051, 0.244033, 0.207629, 0.248859, 0.763993, 0.746277, 0.747747, 0.674709,
0.662527, 0.611832, 0.096574, 0.078296, 0.114008, 0.143008, 0.099946, 0.124103,
0.735285, 0.712381, 0.754377, 0.298879, 0.226257, 0.277617, 0.701030, 0.726042,
0.718978, 0.159542, 0.156096, 0.177225, 0.605889, 0.619399, 0.627314, 0.634420,
0.682773, 0.651184, 0.767707, 0.786953, 0.762583, 0.057956, 0.062331, 0.097951,
0.798413, 0.796229, 0.800342, 0.301843, 0.256341, 0.280536, 0.326162, 0.350170,
0.311621, 0.860663, 0.824105, 0.844318, 0.010681, 0.011718, 0.012689, 0.076816,
0.068716, 0.062456, 0.879200, 0.929490, 0.894331, 0.326581, 0.344487, 0.312432,
0.603697, 0.570804, 0.573608, 0.796229, 0.798413, 0.784505, 0.012556, 0.043771,
0.014530, 0.006063, 0.010891, 0.011519, 0.815237, 0.817628, 0.824514, 0.032549,
0.033744, 0.035294, 0.552032, 0.555824, 0.592821, 0.772515, 0.784475, 0.827742,
0.392405, 0.423783, 0.408983, 0.634420, 0.657947, 0.682773, 0.495798, 0.516208,
0.494200, 0.090392, 0.115862, 0.093174, 0.711175, 0.673679, 0.685828, 0.939051,
0.961009, 0.935375, 0.260223, 0.299945, 0.290519, 0.497616, 0.476906, 0.451357,
0.007614, 0.008508, 0.009875, 0.066977, 0.064449, 0.100287, 0.612875, 0.599491,
0.565875, 0.676069, 0.634366, 0.658166, 0.659071, 0.633455, 0.645041, 0.830608,
0.798288, 0.802033, 0.277250, 0.244033, 0.278085, 0.462608, 0.435557, 0.475700,
0.032096, 0.058976, 0.016854, 0.087341, 0.050445, 0.073073, 0.374732, 0.403972,
0.373463, 0.776035, 0.784505, 0.766448, 0.069538, 0.078554, 0.036302, 0.972893,
0.875851, 0.918572, 0.010206, 0.010017, 0.008617, 0.329278, 0.310537, 0.335111,
0.166917, 0.176743, 0.178524, 0.080790, 0.096644, 0.058976, 0.181292, 0.113781,
0.122776, 0.010681, 0.013109, 0.012342, 0.526318, 0.512648, 0.494200, 0.100287,
0.095895, 0.123060, 0.904488, 0.905156, 0.931428, 0.094235, 0.113351, 0.093836,
0.768780, 0.813596, 0.784475, 0.014887, 0.060302, 0.062103, 0.019402, 0.017278,
0.004321, 0.332703, 0.247905, 0.277250, 0.766106, 0.793439, 0.777653, 0.131032,
0.149859, 0.147892, 0.487110, 0.485075, 0.520497, 0.596681, 0.605889, 0.613717,
0.583182, 0.586010, 0.558837, 0.192175, 0.199723, 0.253528, 0.195187, 0.187776,
0.138587, 0.501372, 0.496924, 0.523417, 0.100287, 0.114948, 0.076502, 0.535571,
0.518445, 0.544270, 0.010017, 0.009557, 0.006815, 0.258853, 0.282901, 0.222293,
0.551518, 0.586703, 0.535398, 0.838981, 0.828299, 0.787102, 0.208408, 0.161408,
0.196743, 0.623958, 0.649789, 0.630671, 0.496082, 0.544931, 0.538266, 0.102855,
0.063315, 0.093174, 0.036302, 0.017884, 0.025217, 0.392815, 0.363064, 0.334244,
0.413106, 0.432995, 0.422486, 0.199827, 0.185458, 0.224263, 0.100987, 0.121380,
0.127889, 0.800578, 0.802033, 0.795869, 0.475700, 0.515846, 0.485556, 0.591234,
0.590535, 0.563904, 0.323468, 0.334072, 0.282334, 0.365706, 0.393430, 0.363116,
0.516208, 0.497616, 0.518701, 0.464287, 0.463167, 0.488948, 0.794322, 0.790471,
0.808129, 0.773489, 0.779755, 0.737048, 0.613212, 0.584713, 0.603603, 0.446067,
0.490442, 0.452062, 0.006125, 0.005552, 0.010891, 0.085193, 0.073721, 0.056911,
0.555574, 0.539156, 0.582288, 0.433279, 0.392815, 0.407382, 0.499617, 0.563904,
0.507104, 0.651184, 0.648584, 0.617279, 0.114948, 0.100287, 0.123060, 0.005986,
0.005708, 0.009900, 0.402228, 0.391477, 0.363927, 0.102514, 0.102359, 0.092353,
0.037231, 0.034122, 0.034673, 0.011307, 0.010891, 0.005552, 0.351649, 0.338197,
0.380199, 0.007171, 0.008508, 0.012023, 0.573151, 0.557534, 0.579062, 0.600963,
0.605889, 0.595518, 0.177225, 0.186921, 0.205197, 0.763993, 0.747747, 0.772046,
0.763508, 0.773489, 0.737048, 0.539046, 0.562299, 0.545687, 0.413106, 0.403730,
0.417717, 0.008617, 0.002105, 0.007370, 0.632768, 0.619114, 0.699298, 0.704294,
0.682773, 0.657947, 0.313625, 0.272321, 0.277732, 0.213359, 0.181002, 0.202715,
0.264004, 0.283919, 0.229590, 0.497175, 0.465516, 0.434677, 0.223505, 0.282334,
0.245715, 0.510088, 0.509206, 0.556814, 0.107870, 0.118360, 0.125529, 0.465924,
0.404818, 0.404640, 0.036033, 0.033878, 0.034698, 0.946103, 0.972803, 0.961773,
0.907030, 0.945307, 0.905156, 0.451153, 0.477212, 0.464650, 0.066972, 0.056613,
0.021456, 0.392037, 0.383846, 0.335637, 0.587972, 0.601286, 0.573363, 0.747747,
0.707215, 0.720767, 0.063315, 0.102855, 0.070688, 0.042115, 0.040947, 0.041818,
0.558837, 0.586010, 0.545302, 0.180804, 0.168017, 0.145106, 0.555574, 0.582288,
0.606508, 0.276272, 0.318138, 0.287339, 0.034442, 0.036607, 0.011519, 0.211657,
0.176257, 0.157892, 0.883009, 0.865408, 0.891058, 0.321688, 0.275438, 0.315961,
0.580026, 0.619114, 0.570249, 0.135119, 0.168974, 0.124103, 0.552824, 0.587972,
0.554239, 0.149416, 0.187586, 0.188810, 0.234262, 0.287339, 0.226257, 0.304518,
0.281583, 0.290519, 0.522509, 0.529467, 0.507207, 0.596681, 0.573151, 0.579062,
0.142593, 0.161282, 0.123280, 0.391531, 0.407203, 0.407601, 0.162849, 0.129634,
0.171662, 0.065258, 0.047534, 0.009900, 0.748319, 0.769595, 0.738950, 0.724781,
0.701204, 0.748319, 0.742764, 0.776035, 0.766448, 0.062331, 0.019744, 0.023304,
0.292648, 0.331724, 0.291004, 0.319034, 0.334244, 0.283919, 0.737307, 0.690481,
0.707811, 0.108965, 0.134369, 0.155233, 0.346181, 0.304963, 0.295954, 0.764051,
0.769595, 0.729834, 0.854183, 0.849942, 0.825887, 0.766106, 0.781015, 0.790026,
0.067437, 0.089720, 0.090392, 0.827742, 0.825887, 0.785555, 0.013577, 0.032547,
0.031167, 0.704294, 0.661852, 0.676069, 0.010658, 0.004917, 0.006036, 0.346181,
0.333245, 0.384507, 0.573144, 0.547948, 0.523285, 0.040947, 0.040688, 0.036607,
0.827742, 0.854183, 0.825887, 0.035294, 0.034355, 0.034241, 0.183517, 0.208408,
0.248179, 0.476169, 0.508751, 0.479163, 0.310537, 0.304678, 0.261727, 0.277250,
0.278085, 0.326408, 0.185918, 0.145451, 0.161282, 0.891271, 0.871275, 0.910349,
0.011900, 0.040688, 0.040145, 0.871465, 0.847418, 0.874326, 0.192074, 0.202557,
0.188919, 0.770772, 0.740170, 0.754121, 0.362043, 0.407634, 0.374732, 0.260468,
0.277732, 0.235728, 0.040947, 0.043123, 0.040688, 0.838981, 0.787102, 0.805790,
0.008508, 0.012890, 0.012023, 0.265213, 0.280174, 0.238043, 0.098954, 0.096635,
0.124207, 0.117483, 0.115862, 0.144072, 0.188880, 0.238043, 0.197989, 0.631543,
0.617541, 0.603697, 0.357654, 0.368235, 0.327296, 0.718978, 0.740170, 0.698054,
0.011469, 0.013037, 0.010681, 0.623958, 0.587972, 0.611363, 0.525023, 0.490442,
0.490430, 0.003541, 0.003460, 0.014949, 0.411807, 0.335111, 0.411832, 0.118952,
0.117483, 0.133682, 0.036033, 0.011307, 0.034665, 0.532962, 0.529467, 0.574678,
0.340402, 0.370227, 0.332487, 0.350170, 0.386508, 0.365663, 0.175045, 0.134369,
0.176257, 0.248859, 0.290232, 0.278085, 0.220099, 0.239897, 0.247936, 0.952280,
0.945307, 0.978515, 0.995927, 1.000000, 0.996376, 0.539046, 0.509030, 0.520497,
0.582288, 0.599754, 0.614571, 0.162849, 0.171662, 0.197984, 0.555824, 0.552032,
0.522070, 0.872219, 0.834178, 0.901159, 0.848552, 0.918572, 0.875851, 0.490038,
0.487098, 0.500306, 0.508751, 0.476169, 0.508065, 0.380459, 0.421163, 0.353671,
0.551542, 0.497242, 0.507104, 0.264004, 0.263797, 0.283919, 0.402798, 0.463167,
0.464287, 0.008508, 0.007171, 0.007618, 0.004917, 0.007618, 0.003537, 0.599754,
0.593992, 0.632768, 0.540441, 0.539046, 0.520497, 0.193273, 0.129336, 0.154422,
0.263797, 0.298693, 0.324122, 0.830054, 0.825775, 0.854869, 0.106590, 0.090392,
0.105250, 0.815206, 0.835458, 0.834514, 0.954267, 0.962275, 0.932003, 0.028528,
0.038639, 0.003537, 0.343403, 0.343071, 0.374732, 0.168017, 0.190707, 0.163405,
0.009557, 0.010433, 0.010074, 0.235972, 0.179671, 0.181292, 0.433814, 0.481281,
0.470968, 0.522509, 0.505219, 0.534754, 0.265310, 0.295954, 0.245643, 0.475280,
0.402798, 0.502292, 0.655607, 0.644678, 0.680770, 0.227892, 0.262917, 0.242984,
0.554786, 0.544441, 0.508065, 0.552032, 0.539534, 0.502292, 0.883026, 0.900836,
0.918572, 0.402798, 0.397650, 0.437555, 0.036177, 0.036033, 0.040995, 0.608753,
0.596870, 0.628424, 0.080629, 0.110356, 0.094235, 0.923353, 0.962275, 0.953441,
0.644678, 0.655607, 0.611363, 0.206983, 0.211657, 0.178298, 0.328198, 0.378359,
0.332703, 0.582288, 0.539156, 0.575245, 0.161032, 0.212363, 0.168241, 0.176329,
0.202760, 0.137848, 0.449286, 0.505219, 0.482495, 0.132422, 0.157892, 0.176257,
0.094338, 0.097951, 0.062331, 0.030738, 0.011966, 0.021025, 0.224704, 0.244033,
0.277250, 0.828299, 0.815596, 0.781328, 0.096574, 0.134851, 0.143810, 0.037296,
0.076557, 0.066003, 0.253818, 0.286826, 0.249319, 0.117577, 0.095264, 0.136126,
0.649789, 0.623958, 0.655607, 0.474002, 0.400072, 0.425975, 0.195702, 0.221720,
0.220718, 0.794322, 0.799636, 0.800342, 0.922962, 0.918572, 0.900836, 0.881348,
0.935375, 0.885808, 0.552824, 0.554239, 0.531409, 0.798288, 0.786953, 0.802033,
0.392267, 0.401071, 0.365485, 0.616422, 0.595601, 0.592821, 0.117577, 0.132270,
0.117739, 0.240444, 0.222909, 0.248852, 0.212363, 0.240169, 0.215382, 0.012983,
0.011900, 0.010324, 0.386206, 0.418941, 0.362043, 0.149859, 0.131032, 0.134388,
0.021025, 0.017212, 0.051212, 0.068657, 0.099171, 0.055939, 0.010324, 0.011900,
0.010686, 0.916161, 0.952280, 0.921946, 0.244033, 0.248859, 0.278085, 0.095895,
0.124612, 0.129157, 0.004332, 0.004275, 0.007712, 0.724781, 0.748319, 0.738950,
0.777901, 0.766448, 0.784505, 0.759196, 0.738104, 0.755388, 0.232806, 0.190707,
0.229455, 0.333245, 0.295954, 0.281583, 0.470267, 0.475700, 0.436772, 0.481420,
0.510088, 0.515007, 0.968684, 1.000000, 0.995927, 0.113781, 0.179671, 0.114008,
0.769595, 0.783038, 0.786324, 0.278308, 0.287105, 0.324344, 0.012412, 0.013445,
0.024007, 0.002069, 0.004332, 0.003541, 0.259446, 0.258639, 0.265586, 0.014530,
0.043771, 0.062026, 0.701204, 0.679906, 0.680770, 0.930276, 0.884422, 0.894331,
0.225728, 0.258639, 0.239897, 0.172337, 0.185827, 0.176674, 0.748839, 0.707256,
0.722040, 0.034656, 0.033744, 0.033878, 0.139041, 0.107340, 0.099091, 0.452920,
0.463813, 0.476942, 0.229455, 0.256341, 0.265213, 0.573144, 0.572419, 0.547948,
0.287339, 0.234262, 0.276272, 0.009900, 0.047534, 0.016813, 0.094595, 0.083596,
0.132422, 0.603580, 0.573608, 0.584780, 0.132270, 0.145106, 0.163405, 0.432995,
0.432858, 0.422486, 0.326581, 0.377894, 0.344487, 0.264474, 0.232548, 0.281287,
0.689207, 0.659071, 0.673679, 0.122776, 0.096644, 0.129336, 0.326162, 0.366154,
0.350170, 0.844169, 0.871275, 0.827742, 0.710961, 0.722720, 0.745556, 0.368235,
0.357654, 0.397650, 0.255795, 0.269550, 0.261727, 0.334244, 0.309062, 0.281287,
0.015471, 0.039634, 0.052787, 0.272321, 0.210788, 0.237112, 0.310287, 0.321044,
0.353167, 0.201860, 0.178194, 0.174035, 0.944081, 0.954670, 0.954267, 0.229455,
0.187776, 0.195187, 0.190707, 0.238043, 0.188880, 0.644921, 0.682049, 0.633885,
0.633665, 0.614571, 0.599754, 0.676069, 0.618136, 0.634366, 0.907234, 0.883009,
0.891058, 0.648584, 0.681580, 0.691070, 0.340402, 0.324344, 0.335739, 0.129157,
0.162490, 0.123060, 0.990938, 0.977962, 0.963667, 0.603603, 0.581457, 0.600928,
0.099946, 0.062026, 0.088347, 0.526666, 0.559246, 0.544859, 0.265213, 0.312432,
0.280174, 0.397813, 0.401099, 0.329758, 0.277617, 0.226257, 0.287339, 0.392037,
0.355892, 0.377905, 0.296141, 0.319688, 0.365485, 0.324122, 0.345580, 0.307596,
0.021100, 0.060183, 0.066972, 0.324344, 0.302474, 0.278308, 0.358133, 0.378359,
0.328198, 0.062026, 0.012890, 0.014530, 0.649789, 0.655607, 0.679906, 0.014795,
0.046260, 0.055856, 0.627137, 0.629541, 0.640244, 0.240803, 0.219078, 0.231054,
0.261727, 0.231054, 0.255795, 0.583182, 0.608068, 0.586010, 0.192074, 0.137848,
0.202760, 0.357269, 0.303919, 0.353671, 0.767707, 0.745447, 0.769595, 0.035294,
0.033744, 0.034656, 0.465516, 0.455165, 0.420180, 0.611832, 0.662527, 0.613196,
0.061599, 0.078296, 0.096574, 0.101979, 0.096644, 0.122776, 0.481457, 0.465207,
0.444586, 0.143694, 0.127617, 0.168789, 0.265213, 0.292007, 0.312432, 0.527657,
0.548086, 0.516245, 0.538266, 0.481438, 0.451544, 0.403680, 0.424076, 0.406128,
0.418941, 0.451544, 0.362043, 0.134388, 0.106590, 0.105250, 0.522070, 0.502292,
0.464287, 0.701030, 0.691070, 0.681580, 0.373463, 0.364872, 0.343403, 0.124207,
0.150508, 0.134388, 0.723415, 0.745447, 0.725749, 0.488948, 0.463167, 0.486499,
0.500306, 0.544859, 0.539156, 0.039556, 0.021025, 0.064449, 0.087341, 0.092353,
0.107870, 0.143346, 0.137848, 0.192074, 0.465516, 0.497175, 0.494595, 0.302474,
0.303730, 0.273811, 0.824105, 0.834859, 0.793439, 0.710961, 0.689486, 0.707256,
0.120027, 0.139167, 0.147745, 0.076752, 0.064449, 0.051212, 0.611569, 0.600928,
0.590535, 0.263012, 0.247470, 0.273387, 0.352789, 0.327296, 0.322722, 0.565875,
0.544270, 0.548465, 0.834178, 0.834859, 0.884422, 0.910349, 0.896478, 0.907234,
0.488081, 0.515007, 0.535398, 0.512648, 0.526318, 0.558837, 0.623868, 0.610638,
0.608068, 0.715013, 0.749583, 0.763508, 0.006063, 0.006125, 0.010891, 0.934587,
0.918739, 0.880061, 0.456935, 0.412078, 0.447118, 0.720767, 0.684635, 0.704675,
0.030924, 0.050445, 0.003541, 0.465207, 0.490430, 0.446067, 0.892226, 0.922962,
0.900836, 0.710961, 0.707256, 0.722720, 0.737048, 0.783234, 0.717028, 0.521378,
0.507517, 0.522033, 0.268215, 0.237063, 0.202715, 0.303730, 0.332487, 0.331894,
0.037143, 0.047095, 0.047730, 0.228883, 0.222088, 0.187764, 0.747747, 0.761743,
0.772046, 0.358133, 0.402798, 0.378359, 0.187776, 0.145106, 0.138587, 0.185918,
0.161282, 0.197989, 0.473659, 0.461807, 0.439159, 0.921946, 0.896623, 0.898367,
0.076502, 0.052486, 0.036857, 0.605889, 0.597974, 0.598071, 0.107870, 0.102359,
0.118360, 0.253528, 0.304963, 0.258853, 0.983265, 0.995927, 0.996376, 0.617541,
0.606544, 0.598520, 0.954670, 0.929490, 0.924385, 0.240803, 0.278308, 0.262288,
0.522738, 0.551542, 0.551289, 0.918739, 0.972803, 0.946103, 0.710961, 0.674709,
0.689486, 0.793011, 0.800342, 0.795795, 0.116784, 0.153630, 0.158360, 0.805240,
0.754377, 0.781328, 0.190543, 0.222293, 0.195187, 0.002824, 0.000000, 0.002105,
0.872219, 0.891058, 0.849628, 0.821192, 0.847418, 0.837348, 0.105775, 0.102514,
0.084675, 0.076816, 0.062026, 0.099946, 0.095264, 0.117739, 0.085500, 0.263012,
0.235116, 0.247470, 0.104415, 0.105532, 0.085193, 0.593992, 0.599754, 0.575245,
0.309062, 0.348735, 0.328340, 0.117739, 0.132270, 0.110783, 0.083152, 0.070732,
0.070149, 0.840881, 0.835458, 0.824514, 0.013098, 0.016854, 0.007919, 0.844318,
0.869102, 0.879200, 0.275438, 0.321688, 0.293881, 0.195702, 0.220718, 0.207273,
0.554239, 0.541544, 0.531409, 0.348735, 0.338409, 0.328340, 0.083419, 0.062103,
0.060302, 0.105775, 0.084675, 0.079885, 0.012412, 0.046260, 0.014795, 0.629541,
0.611569, 0.623720, 0.225566, 0.240444, 0.258438, 0.292007, 0.265213, 0.256341,
0.096574, 0.114008, 0.134851, 0.769595, 0.764051, 0.783038, 0.007919, 0.011336,
0.013098, 0.755388, 0.748839, 0.760087, 0.090735, 0.069319, 0.085500, 0.840311,
0.869102, 0.813995, 0.623958, 0.611363, 0.655607, 0.234262, 0.226257, 0.182440,
0.034781, 0.039942, 0.029164, 0.011037, 0.034781, 0.014252, 0.778092, 0.754121,
0.726042, 0.079481, 0.048765, 0.003541, 0.035390, 0.039942, 0.040995, 0.101979,
0.113781, 0.073038, 0.335111, 0.411807, 0.398931, 0.766106, 0.761517, 0.781015,
0.429157, 0.474002, 0.450599, 0.504686, 0.447781, 0.431175, 0.240920, 0.248852,
0.222909, 0.047095, 0.063315, 0.047730, 0.525023, 0.490430, 0.465207, 0.162877,
0.208112, 0.152411, 0.037612, 0.011148, 0.035390, 0.849942, 0.884615, 0.881348,
0.072757, 0.031304, 0.022871, 0.149986, 0.144072, 0.131032, 0.451544, 0.438837,
0.407634, 0.038928, 0.024007, 0.021254, 0.430673, 0.403680, 0.402940, 0.574678,
0.611832, 0.613196, 0.402333, 0.412078, 0.369119, 0.318138, 0.308621, 0.335161,
0.364617, 0.340402, 0.335739, 0.087341, 0.133116, 0.121380, 0.222088, 0.228883,
0.251574, 0.768780, 0.784475, 0.748839, 0.866728, 0.837348, 0.871465, 0.118952,
0.142155, 0.121253, 0.073721, 0.067420, 0.043005, 0.052486, 0.034026, 0.036857,
0.440728, 0.476906, 0.450804, 0.658166, 0.634366, 0.630671, 0.840881, 0.854797,
0.835458, 0.644921, 0.711689, 0.682049, 0.607338, 0.573144, 0.544441, 0.024007,
0.046260, 0.012412, 0.424076, 0.446067, 0.410163, 0.216528, 0.234262, 0.182440,
0.463813, 0.422486, 0.464650, 0.614019, 0.618695, 0.674709, 0.695188, 0.674709,
0.710961, 0.424076, 0.430673, 0.444586, 0.192074, 0.188919, 0.143346, 0.574758,
0.595601, 0.603128, 0.916161, 0.904488, 0.931428, 0.322065, 0.281583, 0.304518,
0.556814, 0.604420, 0.586703, 0.012537, 0.004917, 0.014252, 0.613212, 0.598922,
0.584713, 0.014530, 0.007614, 0.009481, 0.560384, 0.499617, 0.508818, 0.262288,
0.281168, 0.273811, 0.426379, 0.450599, 0.452874, 0.580026, 0.599491, 0.619114,
0.237063, 0.268215, 0.260468, 0.318138, 0.276272, 0.271060, 0.326162, 0.357595,
0.366154, 0.413106, 0.417717, 0.432995, 0.094595, 0.132422, 0.134369, 0.183985,
0.187764, 0.222088, 0.726454, 0.725749, 0.780973, 0.686751, 0.671010, 0.714070,
0.290232, 0.327296, 0.337116, 0.018570, 0.022050, 0.007919, 0.327279, 0.401099,
0.411832, 0.835496, 0.789497, 0.866372, 0.924385, 0.885808, 0.935375, 0.028528,
0.006691, 0.062103, 0.010017, 0.006815, 0.005915, 0.614019, 0.562367, 0.618695,
0.244033, 0.224704, 0.187586, 0.150508, 0.157440, 0.176743, 0.137848, 0.107340,
0.139041, 0.600963, 0.615694, 0.597974, 0.780973, 0.762583, 0.816302, 0.789497,
0.835496, 0.800578, 0.136092, 0.178194, 0.168154, 0.607338, 0.617593, 0.617279,
0.341130, 0.338409, 0.382832, 0.520385, 0.551909, 0.517926, 0.597974, 0.598520,
0.598071, 0.401099, 0.426379, 0.411832, 0.149817, 0.129634, 0.162849, 0.695188,
0.743121, 0.711898, 0.772046, 0.783371, 0.786978, 0.242984, 0.262917, 0.260223,
0.515663, 0.512744, 0.476542, 0.844318, 0.879200, 0.894331, 0.368571, 0.341130,
0.382832, 0.470968, 0.481281, 0.496082, 0.755388, 0.773874, 0.759196, 0.079534,
0.061599, 0.096574, 0.088640, 0.065258, 0.047984, 0.259446, 0.265586, 0.261797,
0.105532, 0.102855, 0.117483, 0.292648, 0.263012, 0.300633, 0.013577, 0.015625,
0.007258, 0.598922, 0.561914, 0.584713, 0.034698, 0.040947, 0.036607, 0.487098,
0.504821, 0.514420, 0.430421, 0.461807, 0.450942, 0.230247, 0.207273, 0.244916,
0.290232, 0.298879, 0.327296, 0.073651, 0.040220, 0.052787, 0.523285, 0.479163,
0.508751, 0.412078, 0.402333, 0.420926, 0.378359, 0.339030, 0.332703, 0.673679,
0.653538, 0.685828, 0.523417, 0.496924, 0.521378, 0.738104, 0.759196, 0.761517
};

static TqFloat W01[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 , 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

static TqFloat Points01[] = 
{
67.0304, 17.4123, -2.78, 70.6646, 20.5551, 2.9, 70.6054, 16.9345, 0.746163,
43.0819, 35.4026, 38.4282, 37.631, 41.5353, 28.7154, 41.0568, 38.2537, 34.4078,
39.9383, -76.0303, 28.3177, 46.704, -75.6953, 40.8788, 35.8824, -75.8379,
29.2337, -12.3452, -24.0333, 58.7573, -21.176, -24.6351, 59.0737, -16.0593,
-28.9775, 59.1822, -34.0039, -7.44105, 47.5588, -32.6231, -13.9035, 49.69,
-27.6768, -8.3657, 49.371, 15.5889, -71.4245, -14.2812, 11.6256, -71.8024,
-16.2285, 14.3573, -75.4646, -18.7522, -27.3892, 1.9186, -17.4078, -19.8654,
6.03961, -17.1748, -20.4344, 2.39697, -18.8293, 72.1756, 15.4176, 4.8104,
-61.6797, -69.1825, 8.95456, -67.5728, -65.9016, 13.4345, -66.4086, -65.0906,
4.56071, 57.5237, 70.0812, -52.6525, 52.0755, 65.4101, -55.2079, 48.911, 67.1051,
-59.1126, 55.1285, 1.1123, 47.8226, 52.0302, -0.521539, 39.1882, 58.5254,
-1.58355, 40.1151, 28.225, -70.6858, -20.1652, 26.7312, -71.2074, -21.8843,
23.3338, -64.5516, -20.6849, 44.8195, 67.6722, -59.0111, 44.0747, 62.7598,
-60.7058, 56.613, 8.52473, 55.4651, 58.7088, 16.3807, 54.637, 52.4215, 13.8472,
54.5636, -44.8237, -58.6295, -18.2282, -48.5196, -55.1095, -12.3156, -44.3278,
-53.119, -18.4878, 65.6184, -13.8872, -4.50403, 59.9361, -15.6359, -11.4612,
58.277, -13.65, -12.114, 30.8846, -46.3457, 38.433, 29.5855, -55.2411, 39.3666,
32.7019, -53.2074, 35.6711, 22.5171, -30.1982, 44.6485, 24.2414, -32.3574,
44.9688, 28.356, -30.9035, 43.6564, 71.8699, -8.20352, 20.5049, 71.8959,
-13.6081, 24.3394, 73.1108, -12.2434, 15.8717, -19.1242, -40.4512, 57.4445,
-14.5365, -41.2591, 58.2345, -12.5722, -36.2605, 60.9481, -36.6403, -2.12945,
41.489, -44.7836, -5.72824, 39.7751, -40.9019, -6.62016, 43.1507, 45.5581,
57.2184, -45.4349, 46.4956, 57.0564, -38.9034, 48.406, 63.2452, -46.7537,
48.5889, 38.3731, 40.154, 52.3628, 28.0322, 48.5329, 53.4152, 32.6038, 46.9245,
69.4047, 28.6151, 4.58944, 66.2097, 32.6361, 3.62256, 69.2914, 32.5246, 9.64462,
23.5786, -49.8465, -10.3913, 17.7948, -53.6591, -8.9339, 17.986, -45.0679,
-13.0091, 48.0587, 18.1784, -7.26655, 51.8008, 29.1792, -6.52049, 54.0383,
18.2604, -7.43372, -52.8553, -56.3263, -4.87605, -50.3764, -59.3284, -5.33637,
-58.2132, -59.9085, -5.21902, -73.9371, -50.7476, 2.80295, -71.2919, -59.5824,
3.56472, -76.4939, -49.4546, 6.45267, -49.6136, -38.3643, -16.4347, -51.4601,
-41.8641, -14.7134, -52.5507, -34.6835, -12.1028, -16.4843, -36.6, -33.9902,
-7.50609, -41.3663, -34.6573, -7.74913, -45.9247, -34.323, 46.5463, -33.8713,
42.8248, 42.5996, -36.0271, 43.2381, 53.4452, -37.8107, 37.2208, 11.7678,
-60.8523, -21.6521, 10.506, -60.3602, -23.3139, 14.3084, -50.6213, -16.7337,
-41.858, -27.2754, -23.0859, -38.1605, -42.6936, -26.2948, -43.0875, -35.5314,
-23.0575, -37.8459, -27.3904, 52.4322, -35.9257, -34.3474, 53.7251, -29.9495,
-32.8478, 56.3643, 19.1979, -75.5231, -16.156, 57.427, 45.6433, 26.761, 60.3941,
42.5286, 35.2644, 64.262, 44.2164, 26.7032, 64.8892, 1.06454, 1.57794, 57.0164,
0.757857, -6.98382, 59.5981, 3.42479, -3.4906, 48.5295, -26.3052, -17.5219,
49.2843, -35.1642, -15.0035, 45.1713, -28.7935, -17.7973, 24.9612, -24.7795,
43.9393, 31.1863, -23.5302, 47.3484, 28.5113, -19.4017, 44.663, 49.5309, 43.997,
-49.0237, 50.3015, 50.0703, -55.7806, 52.8959, 44.5936, -49.2925, 72.7326,
36.3703, 11.9546, 71.9597, 32.7158, 14.0102, 69.3825, -0.880693, 14.3495,
69.4772, -2.89218, 19.3825, 33.851, -56.5479, 34.1485, -50.1904, 1.37283,
-4.28575, -50.3136, 5.85515, 4.36167, -44.4372, 8.71597, -1.65164, 59.5628,
22.3055, 54.2985, 61.7519, 17.6243, 55.1338, -26.9386, -31.8802, -30.8284,
-25.1977, -33.3818, -32.4617, -29.0042, -34.8903, -29.3834, 69.6886, -30.3197,
18.338, 65.0136, -33.3426, 24.9019, 65.0806, -34.9344, 18.8728, 76.6144, 20.5371,
21.6241, 73.048, 22.8566, 35.0804, 77.9588, 15.575, 23.2332, 10.4386, 1.34569,
-16.2835, 16.7783, 3.35874, -15.7123, 17.3136, -3.60352, -18.434, -45.9408,
-63.5403, -5.61813, 22.6574, -75.5578, 41.1469, 28.9741, -75.6219, 32.9388,
42.6972, -75.5929, 45.9596, 58.9113, 37.3968, 43.5198, 62.5142, 28.7574, 50.3894,
62.8851, 37.6452, 41.562, 11.8962, -16.5793, -23.0523, 12.4638, -21.1601,
-29.7518, 7.14491, -16.4844, -30.6739, 41.8965, -49.9062, 0.344355, 39.427,
-48.2869, -3.80571, 44.2387, -49.6314, 0.43829, 25.1505, 44.6856, 8.44828,
32.1771, 34.8812, 10.711, 29.6575, 43.2902, 10.7767, 39.3497, 4.79744, 37.3981,
35.5489, 6.36075, 34.8866, 37.8962, 2.45281, 37.244, 18.4308, -32.3428, -18.0373,
21.5644, -38.0181, -15.6249, 18.4377, -36.3745, -17.6293, -26.1964, -14.5259,
52.4462, -24.1295, -11.7575, 50.4854, -5.61649, -14.8957, -31.8428, -14.9673,
-15.3058, -31.4087, -11.9589, -12.7384, -28.5911, 40.0146, -59.5391, 0.266163,
36.5833, -57.4414, -4.46354, 37.9014, -54.8623, -3.18509, 68.1735, -22.6946,
29.3903, 63.3263, -18.4851, 35.9937, 61.1897, -22.6168, 39.2724, 11.59, -25.4813,
-33.9992, 15.6997, -27.9592, -28.066, 14.3326, -33.3754, -31.3725, -29.334,
3.81252, 39.7173, -20.5002, 0.767471, 43.7984, -23.0261, 4.8386, 41.5826,
16.0498, -76.4086, -20.9349, 31.0827, 45.6407, -5.47242, 19.797, 50.0884,
-11.4816, 18.2586, 54.6638, -13.3502, -13.8546, -18.5987, -33.7046, -13.8279,
-21.9044, -34.421, -20.0396, -25.7617, -32.8062, -26.3039, 11.9292, -11.1496,
-30.9493, 14.8942, -3.77819, -23.0867, 13.0294, -9.48375, 28.1262, -14.7554,
44.6726, 32.3126, -13.6294, 46.4347, 30.0785, -9.56526, 43.7828, 15.1636,
43.1023, -1.3801, 15.2725, 43.6389, -4.86393, 27.531, 36.5152, 1.19192, 45.2857,
53.0376, -39.2766, 44.5919, 48.6304, -23.0778, 18.2459, 8.35667, -10.3493,
22.6519, 12.5814, -9.45036, 23.2287, 6.60531, -13.155, -33.2394, -75.9926,
3.62014, -24.7108, -76.0782, 3.06065, -27.5335, -74.8986, 5.24327, 9.5521,
56.517, -15.969, 4.98294, 62.3411, -19.5293, 16.0286, 57.9051, -14.3565,
-3.75644, -62.4735, 49.2726, -3.61166, -59.0319, 51.7102, -15.9787, -59.007,
55.1735, 26.4224, -48.7496, -11.1796, 26.43, -38.7121, -16.4959, 23.7542,
-14.7279, 43.8309, 53.3809, 47.1179, -0.676503, 54.1393, 56.3134, -17.6207,
51.2084, 52.2374, -11.6945, 58.7091, -42.9689, 17.432, 54.938, -46.9819, 19.4621,
51.2793, -49.8318, 14.9103, -1.08476, -52.8137, -33.5018, 2.47555, -56.7423,
-30.0274, 4.19384, -64.2731, -26.0129, 61.3302, -38.5259, 23.9876, -19.9607,
-70.5157, 36.3284, -24.5029, -70.9751, 33.8558, -24.5353, -70.8913, 31.2902,
-21.7364, -76.3107, 6.93911, 25.5077, 61.1281, -6.7224, 28.5784, 60.1007,
-1.60582, 32.868, 55.9841, -0.414936, 34.2328, -0.695232, 39.5075, 35.394,
-7.63511, 42.9711, 49.8199, -48.5051, 22.5043, 40.067, -52.8834, 2.37134,
46.1299, -7.66658, -16.8492, 44.4272, -3.7227, -15.8085, 50.862, -7.31573,
-13.6852, 75.2637, 8.00934, 10.0534, 75.6744, 3.99435, 15.1581, 73.2927, 5.03697,
7.85114, -56.5621, -69.238, 25.9172, -48.3815, -71.3393, 27.2579, -56.3647,
-67.0127, 29.915, 46.481, 32.7105, -6.06167, 44.7859, 30.5008, -4.5016, 45.5471,
36.5696, -5.10765, 14.4248, -12.2917, 46.3114, 16.4367, -14.8506, 46.1055,
18.0036, -10.6626, 44.2992, 43.9008, -76.1585, 20.9175, 37.1752, -76.8423,
17.3686, 37.6485, -76.6767, 11.4541, -73.0938, -59.6175, 7.25141, 16.0171,
-58.9111, -8.60148, 19.5927, -61.3792, -11.7148, 16.046, -61.3552, -17.7136,
16.3548, 48.9438, 4.45901, 17.9836, 46.2196, 4.46171, 57.4081, 33.0721, 47.5697,
-19.927, -74.5123, 47.6307, -17.1905, -68.435, 47.9641, -24.7597, -69.2681,
46.9817, 71.6759, -12.3584, 7.85276, 71.7936, -6.96239, 13.3423, 73.477, 21.3324,
40.6959, 72.6378, 29.3327, 37.7626, -35.3529, -19.4606, 49.6012, 34.1153,
33.4274, 2.46098, 36.4372, 34.8177, 0.60707, 38.0748, 30.9598, -0.590538,
49.6433, -41.6538, 35.661, 17.2495, 61.3971, -13.3414, 26.8766, 56.4622,
-7.84966, 27.0824, 52.3857, -8.38658, 49.0269, -66.9867, 12.2319, 41.6314,
-69.903, 21.3103, 50.3298, -72.2423, 15.8933, 19.3611, 65.824, -3.64039, 14.772,
66.9836, -2.468, 29.9881, 57.0815, 3.93279, 42.6282, 33.7281, -0.973962, 39.7581,
39.1485, -0.0485126, 43.7383, 36.9968, -0.848208, 69.1339, 38.8952, 8.39537,
-29.9053, -49.7929, -27.6375, -38.2456, -55.7019, -25.5834, -38.5252, -48.6396,
-24.6625, 6.18121, 48.5751, -0.933443, 17.0505, 42.1358, 0.554045, 44.3281,
-73.4339, -7.42855, 35.6992, -69.6455, -9.39569, 49.731, -69.7659, -4.35207,
19.325, 17.7975, 9.17404, 28.6507, 19.0989, 4.46362, 20.5198, 17.3748, 1.8318,
17.1375, -76.5207, 14.8959, 19.0743, -74.7524, 19.3792, 19.3488, -75.0244,
24.103, 15.5056, 65.0338, -12.9876, 19.3075, 65.8665, -8.30268, -16.5119,
-71.5208, 23.9338, -13.1119, -71.8546, 15.7138, -6.25316, -71.8152, 24.0322,
-20.8638, 21.5842, 18.493, -19.0882, 19.9334, 26.5161, -10.0066, 20.3132,
21.4344, -63.0182, -36.632, 20.9309, -63.425, -34.1182, 14.0916, -64.5081,
-36.7875, 16.2776, 35.5408, 51.6998, -1.02842, 75.1094, 17.3627, 33.506, 75.7766,
15.2984, 41.2351, 36.1458, -76.4204, 26.4902, 36.1119, -76.7315, 22.5391,
16.3564, 57.715, -3.2794, 5.19736, 68.7599, -12.444, 10.0693, 60.4498, -8.8318,
74.0866, 31.9137, 28.5767, 71.8661, 27.0235, 28.2367, 74.6007, 34.0041, 23.8957,
69.2745, 0.630203, 39.5187, 60.5614, -2.037, 36.4928, 72.9214, 2.564, 36.4004,
-36.1537, -33.6199, -25.9509, -36.5167, -25.6398, -25.8041, -31.6478, -31.4903,
-28.8555, -35.9591, -75.1148, 34.992, -29.5276, -75.3316, 32.8656, -25.1446,
-75.5617, 38.1993, 24.7149, 58.3018, 4.59255, 20.7389, 58.5735, 3.56712, 28.8981,
48.7393, 9.02135, 54.4706, 5.31337, -6.23904, 49.6676, 7.34839, -7.335, 49.0519,
3.54436, -9.94457, 41.994, 6.80751, -11.4253, 43.0616, 11.2347, -7.24678,
68.5016, 40.6712, 31.5417, 74.9644, 3.91948, 20.8622, 70.3847, 0.125104, 19.2242,
15.5669, -52.0449, -10.4942, 9.01546, -50.1681, -29.204, 12.9411, -41.7551,
-27.5117, 12.9576, -45.4074, -26.0813, 49.4169, -11.4024, -14.8266, 43.4119,
-14.6887, -17.4986, 42.3678, -10.9738, -17.574, 61.1014, -7.86918, -7.66296,
42.2688, -62.5489, 39.8444, 39.8765, -64.0268, 44.8937, 44.6352, -65.945,
43.6712, 53.781, 56.8832, -47.5825, 52.5525, 52.4425, -49.2633, 49.8286, 59.46,
-56.5276, 36.6372, -70.5339, 48.8803, 42.2391, -72.3386, 48.2171, 40.4109,
-68.3891, 47.7486, 37.4685, -49.9168, 27.1622, 44.8179, -44.8869, 33.9375,
74.5908, 35.9957, 17.8004, 59.8519, 35.6324, -3.25175, 62.9053, 30.0587,
-2.74366, 56.6964, 32.4916, -5.56895, -41.3912, -71.4822, 34.0102, -38.741,
-72.426, 40.125, 15.3708, -41.2988, -20.5896, -34.6798, 17.9099, 18.9343,
-30.5635, 19.901, 11.1766, -39.1881, 15.8594, 12.7355, 58.8984, -39.3912,
29.4445, 50.9728, -45.1972, 27.7548, 56.0099, -43.1235, 24.2778, 31.5735,
-49.2493, -10.7032, 37.6322, -45.6069, -7.4151, 33.1935, -58.4453, -6.76096,
1.22617, 77.0729, -15.7522, -2.79219, 72.2428, -21.3902, 0.994494, 71.1768,
-16.9975, 37.6087, -74.2766, 48.3241, 24.4263, 50.2004, 4.75275, 26.4707,
47.4163, 6.59674, 54.3091, 61.5024, -49.896, 56.2519, 66.1975, -51.8866, 56.8207,
58.4407, -42.7115, -17.068, -30.7974, -34.0318, -14.8136, -26.0019, -35.7729,
-11.0703, -32.029, -36.1197, 26.4291, -32.927, -17.5726, 29.4639, -30.7323,
-18.0142, 30.1718, -35.7976, -15.338, 45.9444, 39.1881, -16.7708, 11.4128,
6.99967, -12.254, 6.06567, 9.56188, -9.96486, 7.68276, 12.3077, -4.99737,
32.6692, 24.3485, 26.9195, 35.7387, 27.5966, 28.1383, 32.5364, 27.1098, 20.616,
12.006, 52.5304, -2.53984, 15.1842, 54.6879, -3.4878, -2.8087, 54.6768, -10.8505,
-32.66, -73.9714, 5.36695, -42.8431, 8.56331, 31.1605, -38.1791, 11.3334,
33.1443, -39.8855, 14.2696, 25.5997, 66.6643, -29.3083, 30.383, 40.2272, 29.4236,
-3.26208, -23.9273, -35.3588, 58.3903, -20.1034, -31.9279, 57.7018, -24.646,
-29.5654, 56.9532, 35.589, 34.4125, 19.5592, 37.1462, 36.8085, 26.9822, 31.9797,
-33.9135, 45.2661, 35.313, -30.3087, 45.5389, 29.9389, -27.8233, 45.4892,
59.1531, 37.8275, -8.65968, 33.6326, 34.7725, 13.402, 32.5363, 31.4632, 11.7509,
30.4024, 38.3784, -2.09712, 9.45491, -20.7605, -33.1498, 14.6299, -64.3005,
-25.7471, 7.90855, -62.5767, -24.9798, 42.6305, -51.4217, 7.37432, 53.2045,
-48.3363, 9.62382, 69.0738, -14.3675, 0.919834, 67.3675, -10.1224, -2.07791,
69.8812, -5.3658, 8.51865, 10.0587, -5.62848, -21.8121, 9.89535, -10.3381,
-22.2805, 0.476787, -12.0028, -23.0697, 21.4395, -74.725, 25.918, 17.3964,
-76.1159, 26.5479, 49.0355, -47.3202, -1.45874, 53.4175, -46.428, 4.23406,
54.2179, -30.2906, 41.3461, 56.7925, -36.0712, 36.1578, -18.1395, -20.8624,
57.7448, -18.4454, -14.9034, 56.0876, -23.3587, -19.8125, 56.3989, -15.2261,
-47.7523, 58.3545, -13.0991, -66.9741, -23.921, -29.9911, -71.1627, -20.9921,
-20.5533, -66.2573, -23.2585, 20.3453, 15.1504, -4.68236, -47.1306, -59.4374,
38.0197, -44.904, -54.1211, 42.5958, -51.3176, -50.7534, 39.9068, 75.7032,
12.0419, 30.9878, 76.6146, 10.1135, 39.9217, 75.9211, 7.42819, 34.8272, 20.4664,
50.8604, 1.95202, 35.7127, -51.0302, 29.186, 0.586404, -47.7777, 53.7243,
6.93929, -47.526, 44.0918, 2.85109, -42.8806, 53.7185, 34.6689, -44.2586,
-9.67958, 46.6403, -44.6551, -5.62188, 48.0851, -69.8051, 28.4246, 43.2935,
-67.4013, 25.8928, 46.3961, -66.2641, 30.5314, 30.0313, -37.0303, 43.3392,
-33.6508, -24.0606, 52.3345, -29.0291, -28.0975, 55.2153, 38.8484, -30.2529,
46.2724, 36.8831, -25.0152, 47.0954, 74.4403, 22.324, 9.90976, 61.0975, 61.8277,
-37.1142, 57.1618, 62.68, -34.7879, 55.6977, 60.2697, -26.4851, -30.4388,
-54.3788, -27.7522, 54.3892, 48.3835, -40.9568, 50.4961, -65.3588, 8.96412,
31.5395, -75.2334, 45.7501, 22.4023, -74.1217, 44.1259, -41.6533, -70.7692,
-2.65203, -42.4907, -74.7808, 3.01152, -49.3426, -70.9634, -0.286307, 9.70482,
71.4689, -13.1745, -36.7864, -3.66517, -15.1447, -30.6097, -4.63301, -17.6998,
-36.2644, -8.88452, -20.6816, 40.731, 46.5385, 10.9119, 38.515, 50.7937, 5.47785,
71.0835, 30.6927, 40.8342, 68.5518, 37.9387, 35.7204, 67.7234, 32.9711, 42.5651,
-76.2672, -40.7707, 10.3922, -74.4786, -42.3508, 4.48568, 27.6835, -76.4988,
-0.307575, 28.3845, -76.6333, -16.6206, 31.6059, -76.6208, -11.6036, -2.80525,
-63.6405, -27.9077, -10.2977, -64.2807, -28.0284, -5.12096, -60.0444, -29.8015,
-2.12305, -28.2574, 58.5169, -1.15038, -33.8972, 57.755, 1.72021, -27.4006,
59.6037, 6.34777, -58.5275, 44.337, 10.0395, -61.8709, 50.8122, 10.6158, -59.687,
45.5911, 55.1379, -22.0619, 43.0987, 50.585, -22.0116, 45.6857, 48.0677,
-26.8598, 45.8545, 64.5681, -2.74698, -1.69004, 31.5048, 50.9459, 8.92197,
56.7029, 18.8926, 53.813, 49.1328, -67.1016, -0.864311, 54.9054, -75.64, 1.05948,
52.0356, -76.2866, -4.16839, 51.469, -73.4335, -4.78444, -49.1037, -31.8388,
-18.0399, -45.264, -39.9268, -21.068, -46.7166, -42.9121, -18.0752, 69.6393,
-25.9757, 20.8882, 67.7035, -27.6492, 24.2141, -38.0899, -75.2303, 0.565846,
-36.1876, -75.7047, 4.42703, -46.1775, -75.0702, 7.35907, -35.8005, -74.028,
20.723, -41.3428, -75.4186, 18.7133, -37.8294, -73.8237, 19.2039, 46.6923,
58.772, -59.8856, -34.0365, -49.0275, 50.7682, -32.3935, -53.0231, 50.7531,
-28.0875, -48.4911, 53.5756, -62.9259, -23.7894, 8.86249, -62.9667, -33.7767,
5.40832, -20.3178, 21.5124, 8.16159, -8.98419, 19.8067, 5.65687, -17.7311,
20.2422, 2.45306, -13.007, -8.87132, 45.4206, -16.2532, -10.74, 52.2058, -7.4924,
-10.5548, 50.916, -75.8836, -38.755, 15.7481, -74.8884, -40.1233, 21.6206,
-70.448, -37.3055, 22.2017, -47.0066, -28.0028, -18.4785, -51.911, -27.5499,
-16.5782, -47.0482, -20.8892, -18.606, 69.3332, -27.1402, 8.40522, 65.1076,
-32.8839, 1.11083, 64.2838, -30.1735, -3.07252, 64.5178, 40.6648, 3.29216,
66.4423, 37.4519, 4.96501, 39.3199, 13.5217, 41.4819, 32.7198, 11.2685, 34.0851,
-12.2686, 20.9742, 12.4848, 13.1905, -58.4915, -15.3997, 7.8193, 16.2853,
13.5077, 9.48571, 15.0794, 4.38004, -1.37949, 18.3691, 7.62812, -28.3396,
9.23005, -12.9821, -32.5454, 2.36883, -15.2048, -38.2464, 5.41271, -11.1025,
2.24327, -33.5324, 56.8294, 7.78511, -30.5566, 55.6211, 32.4802, 33.1166,
6.36193, -6.80079, 18.0824, 0.145465, -30.3747, -39.7028, -29.9621, -35.245,
-39.268, -27.7107, 44.9397, -63.8648, 35.4231, 46.0027, -65.0509, 39.705, 44.4,
45.5878, 10.9899, 41.3266, 45.5317, 14.9619, 50.5418, 46.1688, 16.9384, 29.3113,
-72.3973, -16.6437, 29.056, -74.8613, -19.548, -1.9377, -22.9287, -37.3447,
-3.33495, -18.5252, -34.9791, 4.47562, -18.1543, -34.0571, 26.7452, 18.1742,
18.1187, 24.8062, 17.4248, 18.2302, 26.8074, 12.7829, 26.4068, 57.8567, -25.4795,
-13.701, 61.5287, -29.2698, -7.01752, 56.7034, -35.5917, -8.39767, -12.782,
-55.0574, -30.6826, -13.4165, -58.8417, -29.7757, -19.3669, -61.8263, -28.4348,
-1.29954, 15.1486, -2.50595, -10.2776, 15.9471, -6.92643, -56.4261, -11.5646,
30.627, -60.3727, -15.1274, 25.1802, -55.1564, -18.8089, 36.6104, -41.5912,
-75.9455, 11.9656, -51.063, -74.5675, 12.6791, 36.2147, -11.4646, -20.8567,
31.9179, -18.119, -20.0934, 28.3021, -13.2348, -20.3381, 23.1457, -8.33312,
42.1903, 27.2155, -5.30286, 43.1048, 23.2719, 1.90383, 37.7264, -21.5847,
-5.4135, 43.8375, 65.0347, -24.6401, -4.61151, 68.127, -25.3826, -1.18065,
38.8082, -56.439, 10.1965, 39.5045, -60.9333, 11.1225, 40.3813, -58.0093,
5.02409, -60.2435, -40.0075, 27.8738, -61.2091, -24.875, 26.6775, -62.821,
-31.5094, 22.2322, 57.7815, 3.3095, 51.8276, 61.3054, 0.000175074, 45.86,
61.5578, 5.99239, 52.0315, 36.8472, -20.7672, 46.5464, 4.82224, -63.5076,
54.0528, 2.92341, -59.8441, 47.5473, 55.4244, -71.4144, 9.1283, 55.8426,
-74.5737, 2.66768, 53.4063, -69.8354, 1.34101, -18.6171, -75.423, 4.92787,
-27.4964, -75.6439, -6.61783, -23.1846, -71.3657, -5.82676, 16.9581, -74.8709,
-29.5005, 7.40171, -74.885, -27.2736, 13.8093, -67.866, -28.3781, 3.51301,
-73.9126, 55.1259, -0.46605, -74.4352, 53.1887, 10.1845, -75.2099, 53.8185,
58.8325, -40.0255, 1.69181, 60.6268, -40.771, 8.13146, 57.0442, -43.3765,
3.44749, -28.0237, 20.4864, 20.1235, -31.2853, 17.4147, 28.2692, -25.5913,
19.5626, 26.6677, -57.7505, -24.2518, -9.27491, -55.7427, -28.4332, -11.9792,
-59.879, -28.6234, -3.29076, -69.4616, -56.3676, -0.75677, -70.857, -50.3239,
-1.15529, 66.0063, -2.27255, 28.6945, 6.96662, -61.9094, 51.7262, -7.68281,
-12.2935, 53.7067, -10.9741, -15.0175, 56.5938, -51.6644, -14.8584, -11.5661,
-57.5326, -14.2935, -4.41944, -52.2634, -9.43116, -10.4926, 29.5638, -0.941676,
40.4546, 16.9157, -7.30861, -20.358, -74.5898, -57.2182, 22.7086, -77.2272,
-51.2176, 17.696, -74.9352, -58.23, 13.7887, 70.1296, 11.4712, -0.469112,
45.0638, 44.5749, 5.23394, 40.0303, 44.6049, 0.909985, 43.086, 46.314, 5.35903,
-35.2768, -20.7182, -24.8914, -27.8329, -34.5548, 56.5304, -32.8189, -41.0345,
53.5667, -28.1945, -75.1645, 29.7904, 15.9466, -45.2853, -16.2151, -2.77314,
-66.3479, -25.2352, -5.0974, -70.0318, -24.8782, 27.7698, -76.6214, -21.8188,
23.5312, -76.236, -11.9729, 57.579, 39.9313, -30.1899, 54.9423, 42.1952,
-42.7369, 54.9555, 46.4074, -37.4685, 13.0864, -76.0475, 17.9735, 34.1399,
42.8459, -3.04324, -64.426, -37.15, 11.4229, -24.8984, -55.7214, -29.1324,
-22.6446, -49.97, -29.2192, -21.2407, -55.9054, -28.9239, -24.8258, 21.4643,
13.3918, 38.3418, -3.6091, 42.0295, 44.5186, -0.414823, 39.2196, -63.6543,
-38.9253, 6.21316, -71.7394, -37.2746, 9.80109, 21.5443, -57.1722, 40.7629,
13.2095, -54.0593, 38.0199, 15.4075, -58.5745, 38.9275, -61.8075, -31.4488,
0.530039, -59.856, -34.9946, -2.87191, 19.1495, -17.8607, 46.2105, 13.183,
-23.7721, 45.3533, -28.1699, -54.7326, 54.0705, -48.6369, -48.2063, -17.1213,
-46.2367, -48.7892, -18.4645, 22.8673, 9.02797, 32.1427, 19.2542, 4.46436,
34.6463, 43.8883, 18.2475, -6.2678, 41.2327, 22.8705, -4.9257, -6.5891, -3.56194,
-21.095, -8.59491, -10.3819, -23.0316, -14.9987, -9.98667, -21.8174, 34.7812,
-45.5254, 36.4351, 39.8979, -42.0169, 38.9372, 49.7401, -71.5678, 37.8629,
-36.3805, -66.5682, -20.4653, -30.6153, -75.3125, -18.2363, -33.9613, -75.1789,
-13.9564, -28.5548, -61.8832, -25.681, 20.9122, -27.4917, 45.8104, -70.8002,
-36.203, 16.6512, 47.0441, -73.6394, 44.1619, 49.3665, -74.4086, 39.8123,
-44.0148, -26.6849, 47.9215, -42.0399, -31.068, 50.0684, 14.0054, 64.5392,
-2.44021, -51.779, -15.0395, 39.8239, -55.2754, -3.85989, 27.5548, 26.5595,
-72.7669, -24.7187, 25.1167, -76.135, -26.7028, 51.0274, 7.6254, 53.9607,
48.1084, 8.98635, 51.8923, 50.2289, 3.25032, 48.5292, 10.2622, -68.7919, 55.433,
4.73129, 49.4935, -10.7101, 1.32548, 48.5703, -7.11622, -3.48707, 52.3089,
-13.6225, -24.6355, -38.9972, -31.9961, 1.67815, 17.4927, 19.9523, -4.01663,
19.5899, 16.995, 55.8735, -8.32147, 39.9202, 56.7246, -4.03031, 38.7415, 48.3393,
0.164595, 38.9885, -2.90607, -9.75366, 45.4018, 2.58226, -12.1821, 46.4384,
0.702223, -0.106129, 42.6995, 62.4393, -26.3792, -8.25034, 44.5907, 8.10051,
42.3631, 44.4751, 12.547, 44.2421, 64.7343, -14.1527, 34.8314, 59.5762, -12.2068,
38.6633, 37.8149, -61.3027, 31.5014, 37.8155, -61.062, 38.2003, 53.4233, 3.35137,
51.6123, 2.75038, 16.3863, 3.99085, 56.5871, -9.59769, -11.6608, 53.3923,
-13.646, -14.4302, -42.4581, -50.5729, -22.452, -41.4552, -45.4761, -22.1271,
72.9567, -20.0633, 14.0562, 70.0455, -25.8843, 13.9084, -1.76486, -17.9626,
57.6558, -9.0152, -18.8806, 58.3932, -7.21112, -30.6108, 59.8173, 21.0436,
-18.7707, 45.1158, -21.2464, -75.6752, 23.2911, 13.1305, 15.0644, 5.54508,
13.8937, 13.7166, -0.247316, 41.949, -62.262, 2.63695, 51.3076, -65.592, 4.85018,
59.5747, 9.57239, -5.73769, 52.8351, 11.1228, -7.49594, 5.70068, -67.8844,
55.5862, 11.0405, -72.8631, 55.9857, -22.9194, -9.79939, -20.1474, -30.4294,
-7.9908, -20.732, 17.1907, 17.0178, 15.5886, 25.6286, 19.0583, 10.7041, -23.5648,
-76.0609, -19.1433, -27.6564, -73.8888, -21.1727, -20.4046, -73.4642, -22.9352,
-55.1597, -48.8614, -8.11744, -55.4662, -52.2714, -3.8345, 22.9967, -57.8054,
-9.34443, -22.1273, -16.6638, -30.2452, -21.3874, -13.6674, -27.4107, 67.9651,
4.06586, 48.5983, 71.9976, 5.43946, 46.9061, 69.24, 9.09098, 50.3927, 73.4518,
29.1362, 16.5849, 75.2566, 31.522, 18.2868, 74.2092, 28.431, 20.924, -66.9529,
-40.0809, 26.0433, -63.4519, -38.7841, 21.8187, 32.6733, 15.5753, 33.6959,
40.2056, 19.0722, 39.8537, 35.4934, -54.9454, 27.213, 35.6086, -59.0465, 31.6307,
39.1554, -28.8814, -19.9828, 39.0547, -34.3296, -17.5057, -24.2094, 8.38515,
-14.0429, -49.0139, -58.0254, -8.06296, 7.70081, -23.8647, -35.9311, 3.87037,
-27.1745, -37.6383, 17.1365, -52.0492, 40.136, 19.511, -46.6299, 42.9752,
13.5075, -39.2791, 41.1546, -52.407, -72.2165, 21.9863, 40.7685, -63.4952,
-1.86837, 26.2489, -43.9124, 42.6696, 26.0814, -58.4649, 40.6454, -61.4693,
-42.7855, 27.4016, -64.7773, -44.9425, 30.3079, -55.8232, -52.7416, 32.6189,
59.9633, 42.7781, -6.59379, 60.5572, 45.213, -15.3764, 61.1327, 48.4841,
-15.4349, 50.2206, -76.7859, 1.42608, 53.8706, -76.2437, 7.60349, 14.8131,
-72.1469, 33.605, 12.2767, -71.6075, 37.5436, 11.6205, -72.3598, 24.5965,
-53.0724, -53.4712, 35.2088, -57.1823, -47.7983, 31.4909, 20.6548, -0.272726,
-17.8722, 29.0324, -1.59139, -17.3165, 28.3142, -6.42538, -19.6741, -9.8642,
-32.1279, 59.4538, -5.05637, -37.629, 57.5736, 72.5193, 26.7412, 13.3103, 74.233,
24.488, 20.5408, -41.4015, -52.1046, 46.1291, -44.1785, -48.2337, 45.6485,
39.6404, -15.46, -20.316, -55.4666, -41.6049, -10.8861, 45.3669, 60.3025,
-50.4043, 43.877, 59.2759, -59.1256, 45.1405, 54.5821, -51.8546, 73.6837,
5.99862, 29.087, 10.9484, -46.3617, 39.1299, 44.4698, 47.0332, -28.4294,
-23.9039, 16.727, -4.95546, -27.9564, 19.761, 2.80562, -43.7502, -65.3674,
38.7139, -50.3937, -59.1542, 34.333, -45.0431, -69.0716, 32.2519, 45.9561,
48.3219, -39.3792, 75.7371, 6.78114, 42.269, 75.6322, 12.2962, 44.5365, 73.344,
10.7882, 47.516, 68.676, -0.482758, 8.84724, 18.294, 44.3524, -7.37429, 5.29433,
51.9854, -13.4557, 13.1964, 49.9608, -12.3177, -15.0337, 11.8361, 37.9397,
-21.9123, 10.5279, 37.5353, -17.8168, 7.86374, 40.9614, 77.6207, 10.1656,
17.9608, 77.2538, 9.74736, 25.9686, 33.3489, 28.1438, 4.40329, 36.235, 27.9598,
0.731353, 47.471, 69.8916, -56.2771, 51.188, 71.059, -57.5189, -5.05638,
-32.2826, -36.5449, -7.79148, -25.0036, -36.569, -2.34889, -29.3058, -37.8484,
-60.2455, -10.2555, 13.5976, -58.1359, -9.38554, 24.2578, -56.2251, -2.93429,
20.8854, 34.1543, -48.5619, 34.0419, 34.327, -60.8897, 38.7875, 31.6884,
-58.8198, 38.5957, 27.2351, -62.6163, 41.6986, 0.693354, 6.19056, -14.4476,
1.59405, 3.11435, -17.0458, -3.98623, 2.45858, -16.7912, -34.4705, -75.5188,
23.5826, -37.9069, -74.9859, 28.0361, -37.1761, 16.0587, 3.77398, -44.2491,
11.7268, 7.96881, 19.3688, -63.6491, 42.0505, 15.2298, -60.9236, 43.9858, 18.125,
-66.5774, 47.9101, 11.216, -38.0628, 42.1166, 5.35014, -37.2416, 53.048,
-18.3945, -71.8167, -12.2064, 5.32949, -74.9688, -18.1005, 5.6659, -72.6688,
-16.8707, 33.4658, -63.225, 18.7765, 32.8036, -56.9567, 16.9788, -29.6575,
-13.7476, -23.2772, -25.8215, -72.515, 35.438, 40.0244, -53.9527, 7.72162,
47.6849, -66.4415, 35.2349, -44.8953, -10.7789, -15.9159, 29.2129, 11.8201,
27.6389, 32.0029, 8.19157, 32.2937, 31.8858, 24.3147, 5.45761, 27.6602, 20.4221,
12.1555, 30.4909, 24.917, 14.7328, -29.727, -66.3473, -23.3332, 72.7501, 32.0057,
32.526, -30.9762, -46.632, -28.3854, -16.9436, 15.9291, -5.18377, -2.73152,
-13.4495, -29.3344, 64.197, 25.0211, -1.70404, 51.5297, -15.3016, -14.7605,
53.2739, -26.6875, -15.7079, 2.29531, 65.1905, -14.9264, 45.8407, 41.4095,
-27.3866, 47.2689, 36.2433, -16.0444, -61.0084, -12.5496, 7.16407, -57.8036,
-4.52494, 8.29523, 35.931, -76.6235, 14.2456, 33.9626, -75.1769, 12.0683,
62.1053, 55.5815, -33.3666, 61.8734, 60.7745, -41.7809, 62.5938, 59.2462,
-36.4323, 41.4557, -63.3286, 11.704, 42.1712, -61.9043, 6.73115, 27.9742,
-19.4691, -20.6271, 29.8047, -24.9709, -20.3451, 55.8818, 53.8795, -13.1079,
56.1384, 47.4787, -1.94354, -11.4666, -48.0282, -34.0283, -6.90031, -51.108,
-32.6932, 38.2117, -40.8083, -13.0702, 32.9941, -40.6025, -12.8297, 33.3922,
-36.9925, -14.4423, -16.2446, -40.9027, -32.5468, -23.015, -42.2723, -30.9395,
13.1668, -8.10134, 44.2989, 10.8462, -2.02984, 40.9946, 8.0893, -9.88946,
46.1288, 71.1678, 36.5552, 32.6604, -39.2308, -73.766, 15.9826, -41.8548,
-7.61372, -16.5756, -45.3022, -2.91288, -11.8294, -42.4226, 2.26763, -9.9757,
24.248, -17.5868, -21.6615, -2.07972, 11.9783, -6.33513, -41.0178, -46.2252,
46.815, -37.3533, -52.7515, 50.1769, -39.7279, 7.89904, -7.61738, -61.2325,
-43.2189, 2.13656, -66.7067, -46.1304, -0.907302, -71.0317, -40.1653, 4.37546,
-37.1579, -74.4348, 8.39257, -50.0721, 6.05067, 23.7495, -23.1986, -20.7946,
-31.3053, 71.5545, -17.26, 8.963, 72.6061, -15.1112, 16.106, 23.7567, -26.5239,
-19.545, 40.6775, -23.1568, 45.8488, 44.5546, -20.6914, 47.3142, 44.4693,
-17.5521, 47.03, 1.76139, 57.2477, -18.0019, -1.34789, -71.2288, -11.7558,
6.73258, 69.7125, -18.4509, -2.72762, -3.75407, 44.6351, -12.135, -2.90709,
45.8566, -71.5306, -42.3757, 27.5624, 14.5917, -71.7233, -3.08027, 15.4731,
-71.8857, 0.969729, 10.9852, -72.1466, 9.34832, 56.0404, -74.4572, 9.47474,
53.2018, -74.8811, 13.0023, -8.6252, -41.7759, 57.3334, -9.22756, -49.2798,
57.8936, -3.87094, -48.2044, 56.3135, 28.271, 15.1614, 24.8312, -0.459857,
-56.171, 52.0338, -4.67171, -55.7914, 52.7279, 7.69612, 73.6738, -9.27391,
1.77711, -75.3647, 46.6702, 6.7637, -75.3201, 45.3981, 30.463, -69.3863,
-10.4211, 26.2053, -65.8963, -15.197, 54.6745, 39.3439, -39.9794, 51.1463,
40.0687, -38.7485, 49.8497, 41.9856, -43.6414, -41.183, -22.0025, 49.5626,
-38.5676, -22.7529, 50.597, -40.0878, -13.3309, 47.9832, -1.64652, -47.0614,
55.0202, -3.76207, -42.358, 55.3845, 37.4744, -61.5908, -4.32424, 54.0197,
45.3492, 6.32179, 32.8337, -18.6441, 45.8913, 37.0983, -14.0855, 44.9843,
59.0772, 51.4966, -12.2869, 58.3342, 57.3639, -22.6333, 54.4719, 43.8349,
33.5968, 49.9092, 45.9802, 27.3283, 45.4502, 42.8163, 35.6582, -34.6144,
-67.2264, 45.7625, -31.7901, -73.9241, 45.5565, 61.9338, -36.7982, -2.78256,
44.3149, 45.8442, 22.6302, 38.6139, 44.1155, 25.3263, 9.10603, -14.36, 45.1969,
-2.96125, 59.0309, -14.8962, -4.76207, 64.5135, -19.9082, -5.35762, 53.7135,
-11.9964, -0.754723, -66.8373, 53.377, 24.7147, -62.9225, -11.3041, 26.9321,
-63.6956, -9.41334, 15.5007, -76.3899, 12.1617, 20.8557, -76.5006, 10.3623,
3.72045, -68.5518, -27.2699, 57.8139, 66.5851, -42.3438, 52.1675, 65.2508,
-44.6788, 53.773, 62.7647, -36.8563, 22.8295, -73.98, -5.803, 21.0788, -71.8134,
-5.90488, 19.99, -71.9041, -9.98983, 58.9073, -32.1505, 36.4152, 62.7536,
-27.7176, 36.0416, 61.4706, 39.0011, -0.88869, 58.8893, 40.9971, -7.79236,
52.9659, -41.5293, -3.75713, -49.6456, -64.7308, 31.6172, -19.2861, -2.27493,
-18.6682, -10.6594, 0.656552, -20.7049, -15.8884, -5.8144, -20.8835, 10.2269,
-53.2239, -25.4613, 33.5344, -39.6892, 40.2795, 34.5357, -60.7266, 15.7668,
-6.45718, 69.2851, -28.6224, -3.67377, 68.6371, -27.3116, -6.88281, 62.7332,
-26.9946, -33.6775, -62.3762, 44.4907, -37.1192, -57.2459, 47.794, -41.1043,
-58.1863, 42.4213, -46.3423, -9.67861, 41.8139, 75.6708, 13.369, 9.91698,
-16.9631, -75.992, -16.8012, -19.2674, -75.2333, -14.3019, 43.5209, -29.1026,
44.7322, -16.5054, -47.5415, -32.7242, -63.6315, -68.0706, 19.0319, 3.6778,
-71.9623, 10.4221, 9.70789, -72.3664, 17.2301, 5.6916, 72.8781, -9.53057,
50.3438, -73.2776, 32.8765, 45.2504, -11.8027, 44.3021, 40.0955, -16.6425,
46.9516, 59.5321, -5.91982, 36.8285, 45.2017, 43.3449, -12.9508, 64.42, 11.5587,
51.0025, 65.2292, 15.339, 53.5471, 62.016, 12.6451, 53.0514, -29.7084, -27.8583,
-29.0541, 51.1554, 59.0282, -26.9297, 45.0155, 41.7168, 1.67952, 49.9817,
44.4596, 3.96653, -30.6415, -12.9472, -21.8903, -35.854, -14.2361, -21.5422,
-17.6189, 15.5201, 33.7392, -40.8937, -66.8365, 41.5545, 48.0466, -3.26099,
-13.0017, -3.07009, 14.0248, 32.6948, 7.68491, 14.865, 20.7728, -1.31929, 16.785,
25.9705, -32.5744, 3.0971, 39.6903, -31.4494, -1.52132, 42.2857, 15.7986,
6.94039, 33.5212, 20.9365, 13.2191, 28.2869, 13.9277, 8.82693, 30.8909, 57.6365,
-37.7132, -6.09449, 39.3788, -9.18917, 44.6404, 46.9289, -7.54971, 43.3324,
-44.0712, -1.75167, 39.2429, -46.2323, 3.3571, 34.0723, -48.887, -5.55541,
36.6684, 69.7819, -15.6265, 28.7722, 71.3029, -21.532, 24.5975, -32.8088,
-58.654, -25.0729, -39.3528, -59.3497, -22.1972, -28.2255, -65.3288, 46.0165,
56.7908, -14.7474, 42.001, -25.6147, 12.5169, 36.6142, -47.2207, -48.0449,
42.7816, -51.8261, -46.2361, 40.6733, 56.2231, 50.8757, -35.4901, -17.6237,
-51.9635, 56.2393, -24.1876, -52.2909, 54.6886, -18.5112, -55.1734, 55.3229,
49.4379, 44.2356, -1.10768, 56.7391, -45.5175, 11.3998, 13.4881, -69.1584,
53.4673, 15.1754, -74.1426, 52.3274, 16.6506, -68.5389, 51.8454, 25.5289,
-67.553, 44.4514, 30.5552, -73.5726, 47.2117, 30.6586, -66.7681, 45.1418,
74.3108, 40.3242, 16.1949, 74.8029, 38.1654, 24.4688, -6.64151, -57.0995,
-32.0613, 29.9157, 4.01223, 35.8393, 32.4931, 20.1077, 32.0531, -23.5645,
-75.482, 39.425, -21.6602, -75.2464, 38.826, 54.9814, -35.2378, -10.8695,
50.1095, 61.1057, -38.5927, 7.73419, -14.3324, -23.5079, -44.1336, -13.9618,
-18.1635, 28.6667, -76.3282, 29.35, 58.7832, 26.9001, -4.82422, 23.7323,
-9.78062, -19.8189, -13.0006, 7.36972, -13.817, -7.96933, 10.8737, -11.1388,
-61.4974, -21.035, 24.2358, -61.9791, -16.7857, 14.3002, 69.2739, -17.624,
3.62053, 65.9585, -33.7997, 13.2546, 69.1871, -30.5135, 10.4714, 35.2736,
41.2441, 16.3572, -17.9009, -8.59403, 45.8224, -6.33515, -75.5195, 48.8392,
-5.56228, -75.2634, 44.4724, -1.67698, -75.3596, 45.3633, 36.8501, -76.1017,
-10.9275, -45.7301, -39.5274, 43.5537, -37.9644, -45.1424, 48.7584, 64.8372,
20.5694, 53.8571, 76.4435, 17.2198, 14.4638, 11.9954, -36.4471, -33.0747, 8.256,
-45.3385, -31.3637, 5.08619, -44.521, -34.493, 22.3222, -50.6899, 42.303,
26.6296, -40.4197, 43.3843, -52.2747, -51.1044, -10.8499, -1.27114, -45.2419,
-36.2127, -3.48212, -49.6663, -34.6538, 6.79233, -25.3984, 56.8428, 38.1181,
34.6231, 31.7949, 37.2875, 31.175, 29.9589, 42.4688, 30.9867, 34.9378, 10.7234,
-56.9826, 37.9919, 71.5278, -20.9285, 6.38677, -25.9499, 15.9327, 32.6407,
31.9161, 20.6859, 1.09435, 71.5089, 41.9133, 23.3222, 46.9005, 32.9429, 40.17,
52.1341, 36.9702, -26.5472, 55.2605, 36.6781, -21.9717, -25.7015, -59.6402,
52.785, 66.2587, 4.49794, 0.080512, -23.9023, -45.4416, -30.9131, 21.9145,
-62.0591, 41.3818, -57.0252, -31.8801, -7.27308, 64.9478, -36.7118, 7.32728,
61.8766, -40.9133, 16.1015, 15.5165, 11.7834, -5.71132, -2.93477, -41.2263,
-36.6739, -43.0591, -38.783, 45.5166, -38.4171, -42.2692, 49.7585, -44.1398,
-32.4016, 47.452, 38.1082, -36.6147, 42.8506, -10.3549, -54.7859, 55.0652,
35.9089, 23.2715, -2.22156, 46.5325, 43.325, -7.55614, 45.6441, 50.5897,
-20.3912, -14.1875, 11.3062, -10.0608, 68.181, 43.6601, 21.388, 67.2132, 43.9062,
14.8946, 59.5912, 17.5393, -6.43497, 62.3238, 17.2019, -4.61747, 26.9975,
-76.321, 27.927, 73.097, -20.2341, 19.8044, -45.9193, -15.8335, 44.7101,
-57.2459, -37.9454, 33.7142, -70.9933, -46.0322, 1.1002, 11.7899, 12.1475,
24.602, 11.7076, 14.6857, 19.6213, 46.1227, 40.8704, -1.44426, 35.9893, -65.7962,
46.409, 32.5, -63.4562, 42.3117, 59.3912, 40.2893, -16.6481, -55.8759, -2.9101,
3.83484, 8.49674, 11.2357, 29.2123, -22.5975, -71.7084, -10.5514, -18.963,
-70.8439, -6.05216, 16.59, -25.6133, -24.1492, 37.814, -4.05701, -17.1591,
33.8129, -0.627059, -17.4645, -22.7159, -60.6109, -27.1499, 25.0155, -76.1456,
-4.08711, 24.4713, -75.9775, -1.72336, 67.4815, 26.3295, 48.5885, 69.0943,
20.4311, 50.6496, 43.8032, -76.6441, 5.70113, 41.6727, -76.8478, -5.11272,
-23.0595, -75.02, 8.086, -24.7225, -73.827, 7.339, 60.5689, 49.9428, -24.0866,
57.6752, 44.6865, -19.2812, 57.9521, 53.0605, -33.74, 44.8559, -76.4211,
-7.97535, -37.1088, -62.8692, -19.7088, -75.9804, -52.3295, 22.6391, -6.56971,
1.04859, 43.8645, -13.9881, -0.472431, 44.7935, -27.726, -1.52318, 41.7097,
63.449, 6.87204, 50.6425, 21.6545, -74.502, 12.0025, 50.6867, -16.7855, 44.0024,
29.1802, 7.81578, -13.611, 28.1193, 2.05741, -15.1219, 16.5649, -75.0729,
31.7842, 30.4005, -45.9002, -12.0445, 1.36437, -31.0966, -37.1915, -54.2489,
-24.2006, -14.4779, -58.6883, -19.3684, -6.76669, -51.5631, -19.5641, -15.6961,
61.6732, 51.6016, -23.511, 18.6368, -67.5883, -27.5384, 20.3643, -76.3679,
-29.0813, -15.778, -56.7657, 56.5995, -17.9784, -60.0799, 53.6756, -1.55598,
-5.49936, -21.1885, 31.6259, 18.0905, -1.32426, 68.4187, 1.45974, 44.7943,
-17.0814, -75.3903, 18.0626, 21.0937, 40.5964, 3.48452, 27.0533, 38.4486,
7.51208, 48.9335, 31.1042, -6.15997, 27.1762, -56.6352, -9.41078, -8.6693,
19.0355, 26.579, 19.6387, 0.67566, 37.6077, 8.54558, 4.85667, 35.97, -9.21703,
13.9171, 35.0836, -12.6493, 17.1613, 31.3761, 46.0215, 50.5039, -45.5673,
72.6907, 23.6346, 6.05917, -20.617, -34.9998, -33.3465, 0.152366, 51.6939,
-5.55213, 47.7984, 52.875, -18.7891, -66.0688, -54.9857, -3.65236, -31.382,
-62.9553, -23.476, -24.2398, -64.3416, -24.0196, -9.34954, 7.90276, 40.3219,
-3.82542, 9.8095, 38.0632, -4.33408, -7.58116, -22.5847, -48.524, -42.5087,
42.4295, -2.40813, -10.4031, -22.1086, 6.55837, -14.2987, 46.5025, 67.3455,
-19.1739, -3.77599, 13.3303, -76.6371, -27.8951, -34.8724, 15.2107, 28.1369,
41.078, -22.9923, -19.665, 42.0442, 40.6801, 36.3234, 27.1445, 15.9104, -6.16017,
31.908, 12.8798, -9.27687, 18.2135, -75.693, 36.2409, 52.3762, 71.2542, -52.986,
38.8967, 27.7017, 33.1337, -32.4784, -75.3213, 42.7183, 2.73693, 76.5139,
-18.5175, 5.26538, 75.6752, -13.4246, -69.4646, -56.6647, 29.149, -70.5552,
-53.3489, 29.9578, 9.86964, -76.7216, -24.6372, -6.93494, -75.2525, -23.3571,
31.1543, -42.5767, 40.5914, 50.837, 41.0499, 39.1286, 12.0215, -74.757, 18.887,
34.5447, 37.8106, 17.0676, 5.89626, 5.97538, -13.2337, 14.0229, -76.0575,
12.5225, -7.9926, -8.46766, 45.6206, 36.8302, -66.7655, 20.7077, 22.2121,
-68.2278, 43.0854, -22.588, -63.172, 51.4584, -65.4282, -62.6937, 28.0667,
68.9775, 42.1552, 11.175, 61.6353, 43.1925, 4.31339, -2.6926, 57.6889, -20.2341,
-7.15231, 57.0275, -21.2991, -32.4473, -57.9468, 48.688, 43.7289, -40.5949,
-12.9423, 18.2182, -71.8191, -1.43173, 37.7378, 44.2125, 15.9095, 9.29402,
-71.1732, 39.3343, 4.02757, -70.9575, 40.4869, 17.1162, -33.7814, -24.4693,
18.2164, -29.4973, -21.1641, -0.794178, -71.9416, 16.7779, 0.0428251, -71.5031,
33.1323, 53.4835, -13.6031, 43.5892, -39.3006, -67.6001, -9.47201, -38.9658,
-70.4158, -4.90148, -29.7195, -75.8548, -11.9386, -26.9016, -75.4475, -11.4146,
45.3535, -74.2576, 20.9828, 44.9225, -71.438, 25.254, 47.6053, -74.9548, 25.3202,
19.9393, -33.7356, 43.6555, -59.0375, -51.2309, -3.06261, -59.0506, -56.1762,
-5.42718, 20.9199, -64.1068, -21.6298, 8.21072, -22.2742, 53.4539, 4.39218,
-16.6993, 53.5306, -37.682, -71.0659, 42.9602, 49.3748, -75.4279, 33.1082,
-51.8091, 0.306531, 29.0597, -56.277, -44.4761, 35.1717, 5.5216, -36.479,
-37.414, -1.15543, -36.1782, -37.4435, 70.855, -24.6635, 6.07169, -39.3138,
-20.1096, -22.4252, -43.5254, -20.0564, -20.9008, -58.1074, -45.0222, -2.99212,
13.8454, -31.5191, 42.603, 15.2122, -25.7674, 43.2936, -37.8097, -67.5338,
-17.2754, -10.0174, -63.9795, 48.747, -51.9468, -60.1457, 32.9628, -58.7146,
-57.4834, 34.2373, -58.3736, -62.6322, 33.8363, -78.0012, -49.2046, 11.6769,
21.4231, -76.5077, 3.93012, 29.8536, -76.6782, 6.78907, -40.6662, 2.71784,
37.2862, -0.469672, 61.7778, -15.3721, 5.52266, -40.3392, -36.3607, 30.2635,
-74.605, 9.617, 61.6056, -34.5094, 30.5923, -17.1975, -75.398, 41.638, 68.0165,
0.696597, 27.1379, 38.8843, -53.0907, 12.6893, 37.0659, -54.0528, 12.8963,
-31.3959, -18.7672, 54.0498, 46.8761, 3.56479, 41.1238, 45.2869, 2.83737,
37.9721, -67.3162, -49.6824, -2.89654, -46.9787, 1.50887, -7.96279, -51.7635,
-4.10987, -7.32342, -15.1823, 2.02444, -18.1916, -20.3182, -48.0342, 58.4832,
-26.4116, -25.4718, 57.1449, 9.4563, -16.7773, 46.7145, -25.8727, -46.6292,
56.7362, -28.4722, -43.7698, 55.7199, 12.4233, -75.4648, 44.4018, 45.841,
1.30266, -13.0955, 38.9642, 1.19693, -15.8222, 20.0031, -21.1681, -22.4159,
19.0719, -25.5118, -20.9947, 41.116, 43.6087, 31.8821, -26.1904, -3.79505,
-18.673, -21.5729, -58.1523, 55.0119, 23.8998, -76.2546, 28.5491, 69.4933,
14.4503, 49.8766, 72.4163, 18.3251, 45.9519, 36.6285, -62.7959, 26.1668, 27.2175,
-74.1744, 9.96267, -5.32541, 72.8919, -25.7093, -3.17518, 73.759, -26.5917,
-54.5194, -69.0251, -1.11512, 49.1396, 38.3339, -29.4034, 46.5484, 50.2177,
-55.4929, 45.0509, 53.9279, -58.0971, -5.30604, -71.587, 2.71896, 10.3127,
-71.8217, -6.67983, -20.094, -75.0933, -21.7118, -49.4093, -65.8071, -3.96576,
-42.2562, -71.9189, 30.4109, -76.5182, -44.4121, 22.5012, -73.4218, -47.3566,
27.8264, -46.2625, -25.1702, 44.7159, -49.7619, -26.8219, 43.5724, -15.249,
-75.1561, 41.031, -13.4971, -75.3892, 42.6395, -58.9176, -38.8879, -5.0167,
-39.6939, -65.3189, -14.8065, 58.2656, 44.7552, 3.55275, 59.3207, 45.1469,
9.35872, 33.0551, 40.4538, 13.4581, 4.91164, -49.9812, -32.3086, 49.4113,
34.2003, -13.8223, 52.5966, 31.9201, -7.72779, -47.9293, -5.9379, -12.4808,
38.58, -64.8372, -5.08042, 7.61325, 8.96494, 33.1652, 0.717674, 9.26663, 36.673,
-38.9263, -1.88547, -13.826, 4.12138, 47.6279, -4.4681, 48.5828, 57.5161,
-29.1944, 59.3767, 46.203, -4.75715, 1.33377, 66.4964, -22.5867, 0.262346,
62.4441, -21.8169, 53.0648, 20.6033, 51.3932, 50.5757, 22.268, 47.467, -1.65934,
76.4447, -22.9159, -16.7725, -75.4871, 11.2529, -13.4194, -71.6093, 9.28979,
-49.8385, 6.88314, 9.54074, 36.3743, 45.9609, 12.7343, -32.8821, 11.0515,
-8.50134, -34.1022, 13.326, -4.53791, 8.2381, -56.4419, -26.4171, 34.7291,
8.40309, -12.5438, 35.2068, -54.0332, 20.1535, 41.3936, -50.5858, 23.3818,
18.4965, -36.2456, 43.6114, -8.5189, -73.8576, 50.7743, -15.6596, 3.46001,
43.5694, -58.6512, -7.5209, 3.28841, 56.6467, 70.019, -48.727, 19.8452, -64.8456,
-24.2398, 21.3912, 16.6213, 21.0604, -32.2309, 9.5026, 36.484, -0.384484,
-14.0839, 53.84, 10.6075, -29.7234, -35.1858, 48.0495, 43.8303, -39.4706, 48.712,
15.6256, 50.6806, 72.6412, 2.79786, 42.1241, 59.9552, 43.7545, -0.0100018,
-63.6248, -55.0037, 33.7282, -62.6155, -59.6837, 32.9767, 61.8727, 45.5763,
19.0327, 56.8551, 46.2777, 18.6016, -43.9246, -75.1467, 20.1034, 35.4172,
16.5087, -3.79274, -56.9029, -9.48085, -3.23142, -30.4821, -21.4295, -28.8354,
-63.0959, -62.2715, -2.63985, 20.4747, -76.521, 6.10647, -14.3758, -71.0063,
-11.5723, 11.7202, -18.879, 45.5583, -56.4819, -71.0539, 4.63261, -60.9117,
-67.6659, 3.71028, 61.4735, 66.3187, -48.3456, 60.7076, 68.4479, -48.2774,
-16.8539, -71.8202, 3.10471, 67.0102, -0.503062, 4.76605, 68.2929, -6.68945,
28.2049, -59.225, -46.8214, -0.764905, -45.2488, 11.4836, 13.7643, -44.4695,
-61.7513, -16.028, -68.2932, -48.9554, 31.6134, -14.6707, -70.8513, 36.8089,
28.8395, 20.6775, 22.5884, -40.6284, 14.6985, 20.581, -47.7321, 7.9783, 26.059,
-77.9852, -43.9465, 16.3827, -11.5885, -75.145, 42.055, 57.4271, 43.2967,
-24.2798, -3.11504, -54.7127, -32.3575, 8.85445, 50.006, 0.464395, -22.6305,
-76.2318, 17.4429, -57.5044, -25.8509, 34.2532, 11.2822, -30.1295, 48.4033,
45.5432, 27.8349, 37.0665, -39.1046, -61.6987, 41.7962, 47.3692, -15.8083,
-17.1474, -0.532564, 53.5386, -15.3943, 64.0067, -38.3151, 17.6145, -71.1825,
-62.2606, 20.2568, -66.3519, -64.706, 24.55, 35.3829, -24.5512, -20.0069,
-10.8418, -26.7952, 58.4697, 6.12231, 1.31308, 40.8568, -61.81, -21.3255,
0.452589, -63.3069, -51.133, 33.5461, 37.5135, -20.3186, -20.8729, -47.4698,
-34.2752, 45.0016, -72.5572, -61.4378, 14.6452, 65.9666, -34.2408, 3.60876,
18.9305, -74.0061, 16.1983, -55.3144, -0.651311, 12.7729, 24.1462, -23.3781,
-19.8577, 31.6309, -64.9079, -8.5287, 40.3521, -51.9733, 19.7482, 40.8011,
-52.5592, 17.1478, 18.3905, -76.4289, 6.45116, 7.78963, -2.03525, -20.1305,
2.98713, -2.34911, -20.7067, -53.9062, -38.9302, 37.9421, -52.4525, -34.404,
40.5153, -30.2634, -18.8405, -27.854, -17.1857, -33.953, 59.8189, 34.9496,
18.0421, -2.72034, -7.26832, -70.717, 39.061, -1.69071, -70.6793, 41.3634,
68.6128, 2.17712, 30.7782, -35.8833, -74.9259, -4.90045, -12.9495, -46.9333,
57.7738, -13.5389, -51.252, 55.2842, -18.3666, -45.8933, -32.8683, 15.014,
-75.6132, 42.2387, 12.9735, -75.664, 42.656, -35.9232, 7.95942, 36.722, 9.2013,
64.1416, -17.4932, -27.979, -75.5747, 22.5314, 35.4655, -59.2964, 25.8308,
1.02754, 74.4917, -22.6086, -38.6823, -74.3028, 11.4473, -3.20656, 51.5483,
-10.8059, -52.756, -26.5458, 39.6521, -62.3968, -17.5986, 8.15694, -45.2675,
-20.3704, 45.5331, -50.2487, -21.9286, 43.8295, 34.3393, -54.3562, 16.7289,
-23.1389, -66.4752, 47.0367, -26.2618, -75.3244, 19.5079, -8.57845, 64.3985,
-26.0821, 12.4709, 15.5254, 13.763, 55.3429, 34.3053, -13.7383, -21.7178,
-76.2223, 10.8976, 46.751, 23.9538, 40.3205, -11.0668, 4.2187, -16.3134,
-26.8657, -41.8803, -29.3612, 44.9693, 17.1295, 43.4481, 39.6383, 8.31881,
40.029, -58.272, -64.8997, -2.16382, -30.5304, 13.0191, 34.3566, 17.3466,
-71.8681, 0.699626, -7.76311, 57.9241, -18.4188, 23.2466, -60.5292, -9.79526,
40.4826, 23.0564, 37.8901, -12.8734, -70.6712, 38.4048, 36.9945, -77.167, 19.488
};



//---------------------------------------------------------------------
/** Constructor.
 */

CqBunny::CqBunny( ) { }

TqFloat *CqBunny::Points( ) {
	return Points01; }

TqFloat *CqBunny::S( ) {
	return S01; }

TqFloat *CqBunny::T( ) {
	return T01; }

TqFloat *CqBunny::W( ) {
	return W01; }

TqInt *CqBunny::Indexes( ) {
	return Indexes01; }

TqInt *CqBunny::Faces( ) 
{
	return Faces01; }

TqInt CqBunny::NFaces( ) 
{
	return sizeof(Faces01) / sizeof(TqInt); 
}

END_NAMESPACE( Aqsis )

//---------------------------------------------------------------------


