# -*- coding: utf-8 -*-
# generated by wxGlade HG on Sat Apr  3 15:44:07 2010

import wx

# begin wxGlade: dependencies
# end wxGlade

# begin wxGlade: extracode

# end wxGlade

from wx.lib.dialogs import *

from CertUtils import CertificateRequest
from CertSignDialog import CertSignDialog
from CertInstallDialog import CertInstallDialog

import sys

class CertRequestWindow(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CertRequestWindow.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.mainPanel = wx.Panel(self, -1)
        self.fullNameLabel = wx.StaticText(self.mainPanel, -1, "Full name")
        self.fullNameText = wx.TextCtrl(self.mainPanel, -1, "")
        self.domainLabel = wx.StaticText(self.mainPanel, -1, "Domain")
        self.domainText = wx.TextCtrl(self.mainPanel, -1, "")
        self.emailLabel = wx.StaticText(self.mainPanel, -1, "Email")
        self.emailText = wx.TextCtrl(self.mainPanel, -1, "")
        self.static_line_1 = wx.StaticLine(self.mainPanel, -1)
        self.CALabel = wx.StaticText(self.mainPanel, -1, "CA")
        self.CAText = wx.TextCtrl(self.mainPanel, -1, "", style=wx.TE_READONLY)
        self.CAEmailLabel = wx.StaticText(self.mainPanel, -1, "CA Email")
        self.CAEmailText = wx.TextCtrl(self.mainPanel, -1, "", style=wx.TE_READONLY)
        self.static_line_2 = wx.StaticLine(self.mainPanel, -1)
        self.certRequestFilenameLabel = wx.StaticText(self.mainPanel, -1, "Certificate request")
        self.certRequestFilenameText = wx.TextCtrl(self.mainPanel, -1, "", style=wx.TE_READONLY)
        self.certRequestViewButton = wx.Button(self.mainPanel, -1, "View")
        self.certFilenameLabel = wx.StaticText(self.mainPanel, -1, "Certificate")
        self.certFilenameText = wx.TextCtrl(self.mainPanel, -1, "", style=wx.TE_READONLY)
        self.privateKeyFilenameLabel = wx.StaticText(self.mainPanel, -1, "Private key")
        self.privateKeyFilenameText = wx.TextCtrl(self.mainPanel, -1, "", style=wx.TE_READONLY)
        self.generateCertRequestButton = wx.Button(self.mainPanel, -1, "1. Generate")
        self.signRequestButton = wx.Button(self.mainPanel, -1, "2. Sign")
        self.installCertRequestButton = wx.Button(self.mainPanel, -1, "3. Install")
        self.certRequestCloseButton = wx.Button(self.mainPanel, -1, "Close")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.onGenerateCertRequest, self.generateCertRequestButton)
        self.Bind(wx.EVT_BUTTON, self.onSignRequest, self.signRequestButton)
        self.Bind(wx.EVT_BUTTON, self.onInstallCertRequest, self.installCertRequestButton)
        self.Bind(wx.EVT_BUTTON, self.onCertRequestClose, self.certRequestCloseButton)
        # end wxGlade

    def __set_properties(self):
        # begin wxGlade: CertRequestWindow.__set_properties
        self.SetTitle("Certificate Request Tool")
        self.SetSize((573, 346))
        self.fullNameLabel.SetMinSize((150, -1))
        self.domainLabel.SetMinSize((150, -1))
        self.emailLabel.SetMinSize((150, -1))
        self.CALabel.SetMinSize((150, -1))
        self.CAText.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_3DFACE))
        self.CAEmailLabel.SetMinSize((150, -1))
        self.CAEmailText.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_3DFACE))
        self.certRequestFilenameLabel.SetMinSize((150, -1))
        self.certRequestFilenameText.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_3DFACE))
        self.certRequestViewButton.SetMinSize((-1, 27))
        self.certFilenameLabel.SetMinSize((150, -1))
        self.certFilenameText.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_3DFACE))
        self.privateKeyFilenameLabel.SetMinSize((150, -1))
        self.privateKeyFilenameText.SetBackgroundColour(wx.SystemSettings_GetColour(wx.SYS_COLOUR_3DFACE))
        self.signRequestButton.Enable(False)
        self.installCertRequestButton.Enable(False)
        # end wxGlade

    def __do_layout(self):
        # begin wxGlade: CertRequestWindow.__do_layout
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        mainRequestSizer = wx.BoxSizer(wx.VERTICAL)
        sizer_4 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_5 = wx.BoxSizer(wx.VERTICAL)
        sizer_7_copy_copy_copy_copy_copy_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_7_copy_copy_copy_copy_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_7_copy_copy_copy_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_7_copy_copy_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_7_copy_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_7_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_7 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_6 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_6.Add(self.fullNameLabel, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        sizer_6.Add(self.fullNameText, 1, 0, 0)
        sizer_5.Add(sizer_6, 0, wx.BOTTOM|wx.EXPAND, 4)
        sizer_7.Add(self.domainLabel, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        sizer_7.Add(self.domainText, 1, 0, 0)
        sizer_5.Add(sizer_7, 0, wx.BOTTOM|wx.EXPAND, 4)
        sizer_7_copy.Add(self.emailLabel, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        sizer_7_copy.Add(self.emailText, 1, 0, 0)
        sizer_5.Add(sizer_7_copy, 0, wx.BOTTOM|wx.EXPAND, 4)
        sizer_5.Add(self.static_line_1, 0, wx.BOTTOM|wx.EXPAND, 4)
        sizer_7_copy_copy.Add(self.CALabel, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        sizer_7_copy_copy.Add(self.CAText, 1, 0, 0)
        sizer_5.Add(sizer_7_copy_copy, 0, wx.BOTTOM|wx.EXPAND, 4)
        sizer_7_copy_copy_copy.Add(self.CAEmailLabel, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        sizer_7_copy_copy_copy.Add(self.CAEmailText, 1, 0, 0)
        sizer_5.Add(sizer_7_copy_copy_copy, 0, wx.BOTTOM|wx.EXPAND, 4)
        sizer_5.Add(self.static_line_2, 0, wx.BOTTOM|wx.EXPAND, 4)
        sizer_7_copy_copy_copy_copy.Add(self.certRequestFilenameLabel, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        sizer_7_copy_copy_copy_copy.Add(self.certRequestFilenameText, 1, 0, 0)
        sizer_7_copy_copy_copy_copy.Add(self.certRequestViewButton, 0, 0, 0)
        sizer_5.Add(sizer_7_copy_copy_copy_copy, 0, wx.BOTTOM|wx.EXPAND, 4)
        sizer_7_copy_copy_copy_copy_copy.Add(self.certFilenameLabel, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        sizer_7_copy_copy_copy_copy_copy.Add(self.certFilenameText, 1, 0, 0)
        sizer_5.Add(sizer_7_copy_copy_copy_copy_copy, 0, wx.BOTTOM|wx.EXPAND, 4)
        sizer_7_copy_copy_copy_copy_copy_copy.Add(self.privateKeyFilenameLabel, 0, wx.ALIGN_CENTER_VERTICAL, 0)
        sizer_7_copy_copy_copy_copy_copy_copy.Add(self.privateKeyFilenameText, 1, 0, 0)
        sizer_5.Add(sizer_7_copy_copy_copy_copy_copy_copy, 0, wx.BOTTOM|wx.EXPAND, 4)
        mainRequestSizer.Add(sizer_5, 1, wx.ALL|wx.EXPAND, 4)
        sizer_4.Add(self.generateCertRequestButton, 0, 0, 0)
        sizer_4.Add(self.signRequestButton, 0, 0, 0)
        sizer_4.Add(self.installCertRequestButton, 0, 0, 0)
        sizer_4.Add(self.certRequestCloseButton, 0, 0, 0)
        mainRequestSizer.Add(sizer_4, 0, wx.TOP|wx.BOTTOM|wx.ALIGN_CENTER_HORIZONTAL, 4)
        self.mainPanel.SetSizer(mainRequestSizer)
        mainSizer.Add(self.mainPanel, 1, wx.ALL|wx.EXPAND, 5)
        self.SetSizer(mainSizer)
        self.Layout()
        self.Centre()
        # end wxGlade
        
        self.__initApp()
        
    def __initApp(self):
        
        self.__certRequest = CertificateRequest()
        if not self.__certRequest.isGlobusConfigOk():
            msg = "Could not find request configuration files:\n"
            msg += "\n/etc/grid-security/directions or\n"
            msg += "/etc/grid-security/grid-security.conf or\n"
            msg += "/etc/grid-security/globus-user-ssl.conf or\n"
            msg += "\nMake sure you have installed the request configuration packages."
            wx.MessageBox(msg, "Certificate Request Tool")
            sys.exit(-1)
        
        requestList = self.__certRequest.checkPendingRequests()
        
        if len(requestList)>0:
            result = wx.MessageBox("Existing request(s) exists. Do you want to open existing request(s)?", "Certificate request", wx.YES_NO)
            if result == wx.YES:
                result = wx.GetSingleChoice("Select certificate request", "Certificate request", requestList)
                if result!=-1:
                    self.__certRequest.loadRequest(result)
        
        self.__updateControls()
                    
    def __clearControls(self):
        """
        Reset controls to initial values.
        """
        self.fullNameText.SetValue("")
        self.domainText.SetValue("")
        self.emailText.SetValue("")
        
                    
    def __updateControls(self):
        """
        Update controls with values from certificate request class instance.
        """
        self.CAText.SetValue(self.__certRequest.CAName)
        self.CAEmailText.SetValue(self.__certRequest.CAEmail)
        self.fullNameText.SetValue(self.__certRequest.name)
        self.domainText.SetValue(self.__certRequest.domain)
        self.emailText.SetValue(self.__certRequest.email)
        self.certRequestFilenameText.SetValue(self.__certRequest.certRequestFilename)
        self.certFilenameText.SetValue(self.__certRequest.certFilename)
        self.privateKeyFilenameText.SetValue(self.__certRequest.keyFilename)
        
        signingStatus = self.__certRequest.signingStatus()
        
        # Update process buttons
        
        if self.__certRequest.isUnknown():
            self.generateCertRequestButton.Enable(True)
            self.signRequestButton.Enable(False)
            self.installCertRequestButton.Enable(False)
        elif self.__certRequest.isGenerated():
            self.generateCertRequestButton.Enable(False)
            self.signRequestButton.Enable(True)
            self.installCertRequestButton.Enable(True)
        elif self.__certRequest.isSent():
            self.generateCertRequestButton.Enable(False)
            self.signRequestButton.Enable(True)
            self.installCertRequestButton.Enable(True)
        elif self.__certRequest.isSigned():
            self.generateCertRequestButton.Enable(False)
            self.signRequestButton.Enable(False)
            self.installCertRequestButton.Enable(False)
        else:
            self.generateCertRequestButton.Enable(True)
            self.signRequestButton.Enable(False)
            self.installCertRequestButton.Enable(False)
            

    def onGenerateCertRequest(self, event): # wxGlade: CertRequestWindow.<event_handler>
        """
        Initiate the certificate request process
        """
        
        # Check dialog input
        
        if self.fullNameText.GetValue() == "":
            wx.MessageBox("Full name not given.", "Certificate request")
            return
        
        if self.domainText.GetValue() == "":
            wx.MessageBox("Domain not given.", "Certificate request")
            return

        if self.emailText.GetValue() == "":
            wx.MessageBox("Email not given.", "Certificate request")
            return
        
        self.__certRequest.name = self.fullNameText.GetValue()
        self.__certRequest.domain = self.domainText.GetValue()
        self.__certRequest.email = self.emailText.GetValue()

        # Ask for private key passphrase. Make some basic checks for
        # password complexity.
        
        passphraseOk = False
        
        while not passphraseOk:
            
            passphrase = wx.GetPasswordFromUser("Enter private key password", "Certificate request", "")
            
            if len(passphrase)==0:
                wx.MessageBox("Certificate request cancelled.", "Certificate request")
                return
            
            if len(passphrase)<8:
                wx.MessageBox("Passphrase too short (<8 characters)", "Certificate request")
                continue
            
            passphraseComplexity = self.__certRequest.checkPassphrase(passphrase)
            
            if passphraseComplexity in ["Blank", "Very Weak", "Weak", "Medium"]:
                result = wx.MessageBox("Passphrase strength is "+passphraseComplexity+". Enter a different passphrase?", "Certificate request", wx.YES_NO)
                if result == wx.YES:
                    passphraseOk = False
                else:
                    passphraseOk = True
            else:
                passphraseOk = True
        
                
        self.__certRequest.generate(passphrase)
        
        message =  "A certificate request has been succesfully generated.\n"
        message += "The request is stored in %s." % self.__certRequest.certRequestFilename
        
        wx.MessageBox(message, "Certificate request")

        self.__updateControls()

    def onInstallCertRequest(self, event): # wxGlade: CertRequestWindow.<event_handler>
        """
        Installed signed certificate
        """
        
        if self.__certRequest.isLoaded():
            if not self.__certRequest.isSigned():
                certInstallDialog = CertInstallDialog(self)
                certInstallDialog.certRequest = self.__certRequest
                certInstallDialog.ShowModal()
                certInstallDialog.Close()
                self.__clearControls()
                self.__updateControls()
            else:
                wx.MessageBox("Certificate already signed.")
        else:
            wx.MessageBox("No request has been loaded or generated.")            
        
    def onCertRequestClose(self, event): # wxGlade: CertRequestWindow.<event_handler>
        """
        Close main window.
        """
        self.Close()

    def onSignRequest(self, event): # wxGlade: CertRequestWindow.<event_handler>
        """
        Show certificate signing dialog.
        """
        
        if self.__certRequest.isLoaded():
            certSignDialog = CertSignDialog(self)
            certSignDialog.certRequest = self.__certRequest
            certSignDialog.ShowModal()
            certSignDialog.Close()
            self.__updateControls()
        else:
            wx.MessageBox("No request has been loaded or generated.")

# end of class CertRequestWindow


