// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __IntroductionUnit_h__
#define __IntroductionUnit_h__

#include <string.h>

#include "ACUnit.h"

#ifdef ACMODEL
class ACM_Introduction;
#else
class JPL_Introduction;
#endif

class IntroductionUnit : public ACUnit {
  Unit *_target_unit;
#ifdef ACMODEL
  ACM_Introduction *_intro;
#else
  JPL_Introduction *_intro;
#endif
public:
  IntroductionUnit (ErrorSink &e, Unit *t = 0) : ACUnit (e), _target_unit (t) {
    name ("intro");
  }
  void target_unit (Unit *t) { _target_unit = t; }
  Unit *target_unit () const { return _target_unit; }
#ifdef ACMODEL
  void intro (ACM_Introduction *i) { _intro = i; }
  ACM_Introduction *intro () const { return _intro; }
#else
  void intro (JPL_Introduction *i) { _intro = i; }
  JPL_Introduction *intro () const { return _intro; }
#endif
  static IntroductionUnit *cast (Unit* u) {
    return (strcmp (u->name (), "intro") == 0) ? (IntroductionUnit*)u : 0;
  }
};

#endif // __IntroductionUnit_h__

