#pragma once
#ifndef	PHYSOBJ_DEFINE
#define	PHYSOBJ_DEFINE

/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "main.h"
#include "virtobj.h"
#include "globaldata.h"
//#include "environment.h"

class PHYSICAL_OBJECT: public VIRTUAL_OBJECT
  {
  private:
    // copy-ctor and assign operator are private, so the compiler won't create implicit ones!
    inline PHYSICAL_OBJECT (PHYSICAL_OBJECT &sourcePhObj _UNUSED)_UNUSED;
    inline const PHYSICAL_OBJECT& operator= (const PHYSICAL_OBJECT &sourcePhObj) { return(sourcePhObj); }

  public:
    int	noimpact;
    int	hitSomething;
    double	mass;
    double	drag;
    int	spin;

    /* --- constructor --- */
    inline PHYSICAL_OBJECT ():VIRTUAL_OBJECT(),hitSomething(0) { }

    /* --- destructor --- */
    inline virtual	~PHYSICAL_OBJECT () {}

    /* --- pure virtual methods --- */
    virtual int	isSubClass (int classNum)_PURE;
    virtual int	getClass ()_PURE;

    /* --- non-virtual methods --- */

    /* --- inline methods --- */
    int	applyPhysics ();


    inline int	checkPixelsBetweenPrevAndNow ()
    {
      double startX = x - xv;
      double startY = y - yv;

      if (checkPixelsBetweenTwoPoints (_global, _env, &startX, &startY, x, y))
        {
          x = startX;
          y = startY;
          return (1);
        }

      return (0);
    }

    inline void	initialise ()
    {
      VIRTUAL_OBJECT::initialise ();
      hitSomething = 0;
    }

    inline void	draw (BITMAP *dest)
    {
      VIRTUAL_OBJECT::draw (dest);
    }
  };

#endif

