{-# OPTIONS -fglasgow-exts -cpp #-}
module CParser (parseC) where

import Monad	  (when)
import Maybe      (catMaybes)

import Common     (Position, Pos(..), nopos)
import Data.Set	  (Set, mkSet, union, elementOf)
import Utils      (Tag(tag))
import UNames     (Name, NameSupply, names)
import Idents     (Ident)
import Attributes (Attrs, newAttrs, newAttrsOnlyPos)

import C2HSState  (CST, raiseFatal, getNameSupply)
import CLexer     (CToken(..), GnuCTok(..), lexC,
                   P, execParser, parseError, getNewName, addTypedef)
import CAST       (CHeader(..), CExtDecl(..), CFunDef(..), CStat(..),
		   CDecl(..), CDeclSpec(..), CStorageSpec(..), CTypeSpec(..),
		   CTypeQual(..), CStructUnion(..), CStructTag(..), CEnum(..),
		   CDeclr(..), CInit(..), CExpr(..), CAssignOp(..),
		   CBinaryOp(..), CUnaryOp(..), CConst (..))
import CBuiltin   (builtinTypeNames)
import Array
#if __GLASGOW_HASKELL__ >= 503
import GHC.Exts
#else
import GlaExts
#endif

-- parser produced by Happy Version 1.15

newtype HappyAbsSyn  = HappyAbsSyn (() -> ())
happyIn4 :: (Attrs -> CHeader) -> (HappyAbsSyn )
happyIn4 x = unsafeCoerce# x
{-# INLINE happyIn4 #-}
happyOut4 :: (HappyAbsSyn ) -> (Attrs -> CHeader)
happyOut4 x = unsafeCoerce# x
{-# INLINE happyOut4 #-}
happyIn5 :: ([CExtDecl]) -> (HappyAbsSyn )
happyIn5 x = unsafeCoerce# x
{-# INLINE happyIn5 #-}
happyOut5 :: (HappyAbsSyn ) -> ([CExtDecl])
happyOut5 x = unsafeCoerce# x
{-# INLINE happyOut5 #-}
happyIn6 :: (CExtDecl) -> (HappyAbsSyn )
happyIn6 x = unsafeCoerce# x
{-# INLINE happyIn6 #-}
happyOut6 :: (HappyAbsSyn ) -> (CExtDecl)
happyOut6 x = unsafeCoerce# x
{-# INLINE happyOut6 #-}
happyIn7 :: (CFunDef) -> (HappyAbsSyn )
happyIn7 x = unsafeCoerce# x
{-# INLINE happyIn7 #-}
happyOut7 :: (HappyAbsSyn ) -> (CFunDef)
happyOut7 x = unsafeCoerce# x
{-# INLINE happyOut7 #-}
happyIn8 :: (CStat) -> (HappyAbsSyn )
happyIn8 x = unsafeCoerce# x
{-# INLINE happyIn8 #-}
happyOut8 :: (HappyAbsSyn ) -> (CStat)
happyOut8 x = unsafeCoerce# x
{-# INLINE happyOut8 #-}
happyIn9 :: ([CStat]) -> (HappyAbsSyn )
happyIn9 x = unsafeCoerce# x
{-# INLINE happyIn9 #-}
happyOut9 :: (HappyAbsSyn ) -> ([CStat])
happyOut9 x = unsafeCoerce# x
{-# INLINE happyOut9 #-}
happyIn10 :: (CStat) -> (HappyAbsSyn )
happyIn10 x = unsafeCoerce# x
{-# INLINE happyIn10 #-}
happyOut10 :: (HappyAbsSyn ) -> (CStat)
happyOut10 x = unsafeCoerce# x
{-# INLINE happyOut10 #-}
happyIn11 :: (CStat) -> (HappyAbsSyn )
happyIn11 x = unsafeCoerce# x
{-# INLINE happyIn11 #-}
happyOut11 :: (HappyAbsSyn ) -> (CStat)
happyOut11 x = unsafeCoerce# x
{-# INLINE happyOut11 #-}
happyIn12 :: (CStat) -> (HappyAbsSyn )
happyIn12 x = unsafeCoerce# x
{-# INLINE happyIn12 #-}
happyOut12 :: (HappyAbsSyn ) -> (CStat)
happyOut12 x = unsafeCoerce# x
{-# INLINE happyOut12 #-}
happyIn13 :: (CStat) -> (HappyAbsSyn )
happyIn13 x = unsafeCoerce# x
{-# INLINE happyIn13 #-}
happyOut13 :: (HappyAbsSyn ) -> (CStat)
happyOut13 x = unsafeCoerce# x
{-# INLINE happyOut13 #-}
happyIn14 :: (CStat) -> (HappyAbsSyn )
happyIn14 x = unsafeCoerce# x
{-# INLINE happyIn14 #-}
happyOut14 :: (HappyAbsSyn ) -> (CStat)
happyOut14 x = unsafeCoerce# x
{-# INLINE happyOut14 #-}
happyIn15 :: (CStat) -> (HappyAbsSyn )
happyIn15 x = unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn ) -> (CStat)
happyOut15 x = unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: (CStat) -> (HappyAbsSyn )
happyIn16 x = unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn ) -> (CStat)
happyOut16 x = unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: (()) -> (HappyAbsSyn )
happyIn17 x = unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn ) -> (())
happyOut17 x = unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (()) -> (HappyAbsSyn )
happyIn18 x = unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn ) -> (())
happyOut18 x = unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: (()) -> (HappyAbsSyn )
happyIn19 x = unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn ) -> (())
happyOut19 x = unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: (()) -> (HappyAbsSyn )
happyIn20 x = unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn ) -> (())
happyOut20 x = unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: (()) -> (HappyAbsSyn )
happyIn21 x = unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn ) -> (())
happyOut21 x = unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: (CDecl) -> (HappyAbsSyn )
happyIn22 x = unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn ) -> (CDecl)
happyOut22 x = unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: ([CDecl]) -> (HappyAbsSyn )
happyIn23 x = unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn ) -> ([CDecl])
happyOut23 x = unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: ([CDeclSpec]) -> (HappyAbsSyn )
happyIn24 x = unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn ) -> ([CDeclSpec])
happyOut24 x = unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: ([CDeclSpec]) -> (HappyAbsSyn )
happyIn25 x = unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn ) -> ([CDeclSpec])
happyOut25 x = unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: ((CDeclr, Maybe CInit)) -> (HappyAbsSyn )
happyIn26 x = unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn ) -> ((CDeclr, Maybe CInit))
happyOut26 x = unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: (()) -> (HappyAbsSyn )
happyIn27 x = unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn ) -> (())
happyOut27 x = unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: ([(CDeclr, Maybe CInit)]) -> (HappyAbsSyn )
happyIn28 x = unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn ) -> ([(CDeclr, Maybe CInit)])
happyOut28 x = unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: (CStorageSpec) -> (HappyAbsSyn )
happyIn29 x = unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn ) -> (CStorageSpec)
happyOut29 x = unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: (CTypeSpec) -> (HappyAbsSyn )
happyIn30 x = unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn ) -> (CTypeSpec)
happyOut30 x = unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: (CTypeQual) -> (HappyAbsSyn )
happyIn31 x = unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn ) -> (CTypeQual)
happyOut31 x = unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: (CStructUnion) -> (HappyAbsSyn )
happyIn32 x = unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn ) -> (CStructUnion)
happyOut32 x = unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: (Located CStructTag) -> (HappyAbsSyn )
happyIn33 x = unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn ) -> (Located CStructTag)
happyOut33 x = unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: ([CDecl]) -> (HappyAbsSyn )
happyIn34 x = unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn ) -> ([CDecl])
happyOut34 x = unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: (CDecl) -> (HappyAbsSyn )
happyIn35 x = unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn ) -> (CDecl)
happyOut35 x = unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: ([CDeclSpec]) -> (HappyAbsSyn )
happyIn36 x = unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn ) -> ([CDeclSpec])
happyOut36 x = unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: ((Maybe CDeclr, Maybe CExpr)) -> (HappyAbsSyn )
happyIn37 x = unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn ) -> ((Maybe CDeclr, Maybe CExpr))
happyOut37 x = unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: ([(Maybe CDeclr, Maybe CExpr)]) -> (HappyAbsSyn )
happyIn38 x = unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn ) -> ([(Maybe CDeclr, Maybe CExpr)])
happyOut38 x = unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: (CEnum) -> (HappyAbsSyn )
happyIn39 x = unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn ) -> (CEnum)
happyOut39 x = unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: ([(Ident,	Maybe CExpr)]) -> (HappyAbsSyn )
happyIn40 x = unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn ) -> ([(Ident,	Maybe CExpr)])
happyOut40 x = unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: ([(Ident,	Maybe CExpr)]) -> (HappyAbsSyn )
happyIn41 x = unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn ) -> ([(Ident,	Maybe CExpr)])
happyOut41 x = unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: ((Ident,	Maybe CExpr)) -> (HappyAbsSyn )
happyIn42 x = unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn ) -> ((Ident,	Maybe CExpr))
happyOut42 x = unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: (CDeclr) -> (HappyAbsSyn )
happyIn43 x = unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn ) -> (CDeclr)
happyOut43 x = unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: (CDeclr) -> (HappyAbsSyn )
happyIn44 x = unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn ) -> (CDeclr)
happyOut44 x = unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: (()) -> (HappyAbsSyn )
happyIn45 x = unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn ) -> (())
happyOut45 x = unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: ([Located [CTypeQual]]) -> (HappyAbsSyn )
happyIn46 x = unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn ) -> ([Located [CTypeQual]])
happyOut46 x = unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: ([CTypeQual]) -> (HappyAbsSyn )
happyIn47 x = unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn ) -> ([CTypeQual])
happyOut47 x = unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: (([CDecl], Bool)) -> (HappyAbsSyn )
happyIn48 x = unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn ) -> (([CDecl], Bool))
happyOut48 x = unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: ([CDecl]) -> (HappyAbsSyn )
happyIn49 x = unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn ) -> ([CDecl])
happyOut49 x = unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: (CDecl) -> (HappyAbsSyn )
happyIn50 x = unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn ) -> (CDecl)
happyOut50 x = unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: (CInit) -> (HappyAbsSyn )
happyIn51 x = unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn ) -> (CInit)
happyOut51 x = unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: ([CInit]) -> (HappyAbsSyn )
happyIn52 x = unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn ) -> ([CInit])
happyOut52 x = unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: (CDecl) -> (HappyAbsSyn )
happyIn53 x = unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn ) -> (CDecl)
happyOut53 x = unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: (CDeclr) -> (HappyAbsSyn )
happyIn54 x = unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn ) -> (CDeclr)
happyOut54 x = unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: (CDeclr) -> (HappyAbsSyn )
happyIn55 x = unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn ) -> (CDeclr)
happyOut55 x = unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: (CExpr) -> (HappyAbsSyn )
happyIn56 x = unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn ) -> (CExpr)
happyOut56 x = unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: (CExpr) -> (HappyAbsSyn )
happyIn57 x = unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn ) -> (CExpr)
happyOut57 x = unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: ([CExpr]) -> (HappyAbsSyn )
happyIn58 x = unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn ) -> ([CExpr])
happyOut58 x = unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: (CExpr) -> (HappyAbsSyn )
happyIn59 x = unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn ) -> (CExpr)
happyOut59 x = unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: (Located CUnaryOp) -> (HappyAbsSyn )
happyIn60 x = unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn ) -> (Located CUnaryOp)
happyOut60 x = unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: (CExpr) -> (HappyAbsSyn )
happyIn61 x = unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn ) -> (CExpr)
happyOut61 x = unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: (CExpr) -> (HappyAbsSyn )
happyIn62 x = unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn ) -> (CExpr)
happyOut62 x = unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: (CExpr) -> (HappyAbsSyn )
happyIn63 x = unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn ) -> (CExpr)
happyOut63 x = unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: (CExpr) -> (HappyAbsSyn )
happyIn64 x = unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn ) -> (CExpr)
happyOut64 x = unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: (CExpr) -> (HappyAbsSyn )
happyIn65 x = unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn ) -> (CExpr)
happyOut65 x = unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: (CExpr) -> (HappyAbsSyn )
happyIn66 x = unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn ) -> (CExpr)
happyOut66 x = unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: (CExpr) -> (HappyAbsSyn )
happyIn67 x = unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn ) -> (CExpr)
happyOut67 x = unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: (CExpr) -> (HappyAbsSyn )
happyIn68 x = unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn ) -> (CExpr)
happyOut68 x = unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: (CExpr) -> (HappyAbsSyn )
happyIn69 x = unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn ) -> (CExpr)
happyOut69 x = unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: (CExpr) -> (HappyAbsSyn )
happyIn70 x = unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn ) -> (CExpr)
happyOut70 x = unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: (CExpr) -> (HappyAbsSyn )
happyIn71 x = unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn ) -> (CExpr)
happyOut71 x = unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: (CExpr) -> (HappyAbsSyn )
happyIn72 x = unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn ) -> (CExpr)
happyOut72 x = unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: (CExpr) -> (HappyAbsSyn )
happyIn73 x = unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn ) -> (CExpr)
happyOut73 x = unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: (Located CAssignOp) -> (HappyAbsSyn )
happyIn74 x = unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn ) -> (Located CAssignOp)
happyOut74 x = unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: (CExpr) -> (HappyAbsSyn )
happyIn75 x = unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn ) -> (CExpr)
happyOut75 x = unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: ([CExpr]) -> (HappyAbsSyn )
happyIn76 x = unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn ) -> ([CExpr])
happyOut76 x = unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: (CExpr) -> (HappyAbsSyn )
happyIn77 x = unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn ) -> (CExpr)
happyOut77 x = unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: (CConst) -> (HappyAbsSyn )
happyIn78 x = unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn ) -> (CConst)
happyOut78 x = unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: (Located String) -> (HappyAbsSyn )
happyIn79 x = unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn ) -> (Located String)
happyOut79 x = unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: ([String]) -> (HappyAbsSyn )
happyIn80 x = unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn ) -> ([String])
happyOut80 x = unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: (()) -> (HappyAbsSyn )
happyIn81 x = unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn ) -> (())
happyOut81 x = unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: (()) -> (HappyAbsSyn )
happyIn82 x = unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn ) -> (())
happyOut82 x = unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: (()) -> (HappyAbsSyn )
happyIn83 x = unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn ) -> (())
happyOut83 x = unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: (()) -> (HappyAbsSyn )
happyIn84 x = unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn ) -> (())
happyOut84 x = unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyIn85 :: (()) -> (HappyAbsSyn )
happyIn85 x = unsafeCoerce# x
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn ) -> (())
happyOut85 x = unsafeCoerce# x
{-# INLINE happyOut85 #-}
happyIn86 :: (()) -> (HappyAbsSyn )
happyIn86 x = unsafeCoerce# x
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn ) -> (())
happyOut86 x = unsafeCoerce# x
{-# INLINE happyOut86 #-}
happyIn87 :: (()) -> (HappyAbsSyn )
happyIn87 x = unsafeCoerce# x
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn ) -> (())
happyOut87 x = unsafeCoerce# x
{-# INLINE happyOut87 #-}
happyInTok :: CToken -> (HappyAbsSyn )
happyInTok x = unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn ) -> CToken
happyOutTok x = unsafeCoerce# x
{-# INLINE happyOutTok #-}

happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\x00\x00\x00\x00\x01\x00\xe8\x02\x00\x00\x00\x00\x17\x03\x11\x00\x00\x00\x8b\x01\x10\x00\x9c\x06\x11\x00\x00\x00\x34\x03\x00\x00\x00\x00\x22\x03\xfb\xff\x2e\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8b\x01\x10\x00\x00\x00\x27\x03\xce\x02\x31\x06\x91\x02\xd9\xff\x00\x00\xfc\x02\x0f\x06\x00\x00\xd9\xff\x06\x03\x23\x03\x11\x00\x00\x00\xf6\x02\x11\x00\x00\x00\x00\x00\xaf\x05\x00\x00\x22\x03\x00\x00\xb5\x01\xf0\x01\xe8\x01\x12\x00\xc8\x01\x08\x03\x07\x03\xfd\x02\xfb\x02\x9c\x01\x00\x00\x0d\x03\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\x12\x03\x12\x03\x00\x00\x00\x00\x00\x00\x00\x00\x02\x03\xb1\x02\x00\x00\x00\x00\x00\x00\xba\x02\x00\x00\x03\x00\x0f\x01\xfe\x02\xd2\x02\x00\x00\x00\x00\x00\x00\xee\x02\x8b\x01\x00\x00\xa0\x02\xa6\x02\xcf\x02\x00\x00\xc7\x02\xc4\x02\x7b\x06\x7b\x06\x7b\x06\x00\x00\x00\x00\x00\x00\x26\x04\x00\x00\x00\x00\xec\x02\xc1\x02\xa1\x02\xbe\x02\xa1\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x96\x02\xb6\x02\xb7\x02\x00\x00\xc3\x02\x80\x02\xca\x00\xec\xff\x00\x00\x00\x00\x86\x02\x00\x00\x0a\x00\x00\x00\x78\x01\x06\x00\x81\x02\x7d\x02\x00\x00\x00\x00\x85\x00\x00\x00\x85\x00\x00\x00\xa1\x02\x00\x00\xba\x06\xba\x06\x20\x00\xcd\x02\xc2\x02\x00\x00\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\xa1\x02\x00\x00\x2a\x02\xa1\x02\x77\x02\x6e\x02\x00\x00\x00\x00\x59\x06\x98\x02\x00\x00\x00\x00\x6d\x02\x17\x02\x00\x00\x00\x00\x00\x00\x17\x02\xc0\x02\xdd\x00\x00\x00\x00\x00\xb3\x02\x0c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\x01\xb5\x01\x9d\x01\x9d\x01\x88\x01\x88\x01\x88\x01\x88\x01\x12\x00\x12\x00\x67\x01\xaf\x02\x9d\x02\x95\x02\x97\x02\x99\x02\x00\x00\xa1\x02\x6e\x01\x00\x00\x31\x00\x00\x00\x00\x00\xa5\x02\xa4\x02\x00\x00\x9c\x02\x00\x00\xa3\x02\xa2\x02\x59\x06\x01\x02\xc8\x00\x00\x00\x00\x00\x00\x00\xfe\x00\x00\x00\x00\x00\x9e\x02\xa1\x02\x4c\x02\x00\x00\x6a\x02\x00\x00\xba\x06\x00\x00\x3e\x00\xeb\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\xc6\x01\x94\x02\xca\x00\x8f\x02\x00\x00\x92\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa1\x02\x00\x00\xa1\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x65\x02\x00\x00\x00\x00\x7a\x01\x64\x02\xa1\x02\x5c\x02\x66\x02\x34\x01\x82\x02\x2f\x02\x7b\x02\xaa\x01\x78\x02\x75\x02\x57\x02\x00\x00\x00\x00\xd1\x00\x49\x01\x00\x00\x34\x01\xa1\x02\xa1\x02\x49\x02\x00\x00\xa1\x02\x46\x02\x9a\x01\x11\x02\x34\x01\x00\x00\x41\x02\x00\x00\x5d\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfa\x00\x00\x00\x00\x00\x3e\x01\x3f\x02\xa1\x02\x00\x00\xa1\x02\x02\x00\x00\x00\x00\x00\xa1\x02\xa1\x02\x34\x01\x00\x00\x5b\x02\x9a\x01\x00\x00\x51\x02\x00\x00\x50\x02\x4f\x02\x00\x00\x00\x00\x00\x00\x34\x01\x34\x01\x34\x01\xa2\x00\xa1\x02\x00\x00\xc3\x00\x00\x00\x00\x00\x00\x00\x25\x02\x09\x00\x4b\x02\x4a\x02\x34\x01\xf5\x01\x00\x00\x00\x00\x34\x01\x00\x00\x34\x01\x03\x02\xb4\x00\x21\x02\x00\x00\x2c\x02\xc7\x00\x00\x00\x26\x02\x22\x02\xa1\x02\x09\x00\xfa\x01\x09\x00\x00\x00\x00\x00\x00\x00\x1b\x00\x00\x00\x00\x00\x12\x02\xba\x01\xba\x01\x06\x02\x05\x02\x00\x00\xd8\x01\xae\x01\x95\x00\x00\x00\x00\x00\xa1\x02\xa1\x02\xf4\x01\xf2\x01\xc7\x01\x87\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\xbc\x00\xbb\x01\x46\x01\x00\x00\x00\x00\x00\x00\x00\x00\xb4\x01\x81\x01\x86\x01\xde\x00\xd1\x03\x5d\x00\x3a\x01\x00\x00\x00\x00\x00\x00\x79\x08\xfa\xff\x00\x00\x00\x00\x73\x01\x5f\x01\x35\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x01\x6b\x00\x00\x00\x00\x00\xf2\x00\x74\x00\x99\x09\x24\x00\x00\x00\x00\x00\x9e\x00\x00\x00\x17\x00\x00\x00\x00\x00\xb0\x01\x00\x00\x00\x00\x96\x01\x44\x01\x00\x00\x00\x00\x00\x00\x29\x0a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf2\x05\x00\x00\x00\x00\x00\x00\xca\x02\xa7\x02\x00\x00\x00\x00\x00\x00\x00\x00\x4d\x01\x17\x01\x00\x00\x00\x00\x00\x00\xee\x00\x00\x00\x48\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe9\x00\x00\x00\xd5\x00\x21\x01\x00\x00\x04\x01\x00\x00\x00\x00\xfd\x00\xe8\x00\xd7\x00\x00\x00\x00\x00\x00\x00\xc1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x81\x09\x00\x00\x69\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc5\x00\xa6\x00\xe2\xff\x06\x01\x00\x00\x00\x00\x00\x00\x00\x00\x7f\x00\x9d\x00\x66\x00\x00\x00\x00\x00\x00\x00\x00\x00\x90\x00\x00\x00\x00\x00\x9f\x02\x51\x09\x00\x00\x00\x00\x00\x00\xc0\x05\x00\x00\x8e\x05\x00\x00\x61\x08\x00\x00\xeb\x04\x8b\x04\x6c\x00\x00\x00\x00\x00\x00\x00\xc9\x09\x49\x08\xff\x02\x99\x03\xad\x01\x04\x02\x59\x04\xf9\x03\xea\x09\xe1\x09\xb9\x04\x2d\x02\x02\x0a\x39\x03\x11\x0a\xf9\x09\x20\x0a\x1a\x0a\x10\x02\x00\x00\x91\x08\x31\x08\x00\x00\x00\x00\x00\x00\x00\x00\x05\x00\x82\x00\x00\x00\x00\x00\xea\xff\x29\x07\x00\x00\x00\x00\x00\x00\xf9\x06\x00\x00\x3e\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xde\x01\x84\x00\x00\x00\x63\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2f\x01\x39\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x21\x09\x64\x00\x00\x00\x00\x00\x00\x00\x89\x03\x00\x00\xe2\xff\xe2\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x25\x03\x00\x00\x00\x00\x00\x00\xdc\x06\x00\x00\xdc\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\x09\x00\x00\x09\x09\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\xf1\x08\x00\x00\x00\x00\xf6\x04\x00\x00\x00\x00\x00\x00\x19\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x07\x00\x00\xde\x04\x01\x08\xe9\x07\x00\x00\x00\x00\xd1\x07\x00\x00\x5c\x05\x00\x00\x96\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd9\x08\x00\x00\xc1\x08\x45\x05\x00\x00\x00\x00\xa9\x08\xb9\x07\x7e\x04\x00\x00\x00\x00\x1d\x05\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x36\x04\x1e\x04\xd6\x03\xa1\x07\x89\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x97\x00\x00\x00\x00\x00\xbe\x03\x00\x00\x00\x00\x00\x00\x76\x03\x00\x00\x56\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x71\x07\x04\x00\x00\x00\x8c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd7\xff\xd0\xff\x00\x00\x00\x00\x00\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x59\x07\x41\x07\x00\x00\x00\x00\x00\x00\xcb\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\xfd\xff\x00\x00\x0e\xff\x00\x00\xfc\xff\xfa\xff\x00\x00\xcc\xff\xca\xff\x0c\xff\x00\x00\x00\x00\x00\x00\x7d\xff\x00\x00\x87\xff\x0d\xff\x00\x00\x7f\xff\x00\x00\xc8\xff\x0c\xff\x0c\xff\x0c\xff\xad\xff\x00\x00\xac\xff\xb8\xff\xb5\xff\xaa\xff\xb0\xff\x00\x00\xba\xff\xb1\xff\xa7\xff\xb3\xff\xb2\xff\xb7\xff\xa8\xff\xb4\xff\xaf\xff\xb9\xff\xa1\xff\xbb\xff\xa0\xff\xae\xff\xb6\xff\xa9\xff\xab\xff\x0c\xff\x00\x00\x0a\xff\x00\x00\x88\xff\x7b\xff\x00\x00\x0e\xff\xbd\xff\xcb\xff\xbf\xff\xf9\xff\x0e\xff\xc1\xff\x00\x00\x00\x00\xf7\xff\x00\x00\xcc\xff\xca\xff\x5f\xff\x55\xff\x47\xff\x00\x00\x45\xff\x41\xff\x3e\xff\x3b\xff\x36\xff\x33\xff\x31\xff\x2f\xff\x2d\xff\x2b\xff\x29\xff\x17\xff\x00\x00\x61\xff\x13\xff\x00\x00\x84\xff\x48\xff\x49\xff\x00\x00\x00\x00\x4b\xff\x4a\xff\x4c\xff\x4d\xff\x00\x00\x00\x00\x15\xff\x16\xff\x14\xff\x12\xff\x62\xff\x74\xff\x00\x00\x00\x00\x7a\xff\x78\xff\x81\xff\x0b\xff\x00\x00\x0c\xff\x09\xff\x8a\xff\x00\x00\x91\xff\x9f\xff\xa3\xff\xa2\xff\xc3\xff\xc5\xff\xc7\xff\x86\xff\x7c\xff\x7e\xff\x47\xff\x27\xff\x19\xff\x00\x00\x1a\xff\x00\x00\x00\x00\x00\x00\x25\xff\x21\xff\x20\xff\x24\xff\x23\xff\x22\xff\x1d\xff\x1c\xff\x1b\xff\x1f\xff\x1e\xff\xc6\xff\xc4\xff\xc2\xff\x9f\xff\x9f\xff\x0e\xff\x00\x00\x00\x00\x90\xff\x8e\xff\x8c\xff\x89\xff\x05\xff\x0e\xff\x83\xff\x82\xff\x00\x00\x76\xff\x6c\xff\x75\xff\x6b\xff\x7b\xff\x00\x00\x11\xff\x10\xff\x51\xff\x00\x00\x4f\xff\x00\x00\x53\xff\x00\x00\x54\xff\x9c\xff\x9a\xff\x6e\xff\x00\x00\x00\x00\x85\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x52\xff\x00\x00\x00\x00\x00\x00\x00\x00\x59\xff\x58\xff\xef\xff\xbf\xff\xc9\xff\xbc\xff\x00\x00\x00\x00\xf8\xff\xc0\xff\x73\xff\x00\x00\x00\x00\x00\x00\x5b\xff\x5a\xff\x00\x00\x00\x00\x57\xff\x5d\xff\x42\xff\x43\xff\x44\xff\x3f\xff\x40\xff\x3c\xff\x3d\xff\x37\xff\x39\xff\x38\xff\x3a\xff\x34\xff\x35\xff\x32\xff\x30\xff\x2e\xff\x2c\xff\x00\x00\x2a\xff\x60\xff\x00\x00\x6c\xff\x6d\xff\x7b\xff\x99\xff\x9b\xff\x00\x00\x00\x00\x0f\xff\x00\x00\x68\xff\x00\x00\x00\x00\x7b\xff\x00\x00\x6a\xff\x80\xff\x77\xff\x79\xff\x00\x00\x07\xff\x03\xff\x04\xff\x00\x00\x8f\xff\x93\xff\x00\x00\x9e\xff\x00\x00\xa4\xff\x0e\xff\x0e\xff\x26\xff\xfb\xff\x18\xff\xa5\xff\xa6\xff\x00\x00\x92\xff\x8d\xff\x8b\xff\x00\x00\x00\x00\x05\xff\x00\x00\x66\xff\x00\x00\x69\xff\x64\xff\x67\xff\x50\xff\x4e\xff\x46\xff\x00\x00\x5c\xff\x00\x00\x5e\xff\xee\xff\xf6\xff\xf4\xff\xf5\xff\xf3\xff\xf2\xff\xf1\xff\xf0\xff\x00\x00\xea\xff\xe8\xff\xd7\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x62\xff\xbe\xff\x70\xff\x00\x00\x00\x00\x72\xff\x00\x00\x00\x00\x00\x00\x00\x00\xdd\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdf\xff\x00\x00\xde\xff\x00\x00\xd6\xff\xe9\xff\x56\xff\x28\xff\x63\xff\x65\xff\x06\xff\x08\xff\x00\xff\x00\x00\x01\xff\x95\xff\x00\x00\x98\xff\x00\x00\x97\xff\x00\x00\x00\x00\x9d\xff\x02\xff\x00\x00\x00\x00\x00\x00\xeb\xff\x00\x00\x00\x00\xe0\xff\x00\x00\xdc\xff\x00\x00\x00\x00\xed\xff\x6f\xff\x71\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xec\xff\x00\x00\xff\xfe\x94\xff\x96\xff\x00\x00\xd5\xff\x00\x00\x00\x00\x00\x00\xe7\xff\xe5\xff\xe4\xff\x00\x00\xe2\xff\x00\x00\x00\x00\x00\x00\xd4\xff\xd3\xff\x00\x00\x00\x00\xdb\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd5\xff\xe3\xff\xe1\xff\xe6\xff\x00\x00\xda\xff\xd2\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd1\xff\x00\x00\x00\x00\x00\x00\xce\xff\xd9\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xcd\xff\xd8\xff\xcf\xff\xd0\xff"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x1f\x00\x01\x00\x01\x00\x01\x00\x2c\x00\x03\x00\x01\x00\x0d\x00\x03\x00\x05\x00\x01\x00\x03\x00\x03\x00\x0d\x00\x0d\x00\x0d\x00\x01\x00\x01\x00\x0d\x00\x10\x00\x1b\x00\x4b\x00\x12\x00\x2d\x00\x14\x00\x2e\x00\x4b\x00\x0d\x00\x02\x00\x0d\x00\x08\x00\x1e\x00\x01\x00\x4b\x00\x03\x00\x2a\x00\x13\x00\x14\x00\x15\x00\x16\x00\x12\x00\x1b\x00\x14\x00\x08\x00\x0d\x00\x52\x00\x4d\x00\x35\x00\x30\x00\x01\x00\x5a\x00\x03\x00\x4b\x00\x12\x00\x31\x00\x14\x00\x1e\x00\x34\x00\x35\x00\x41\x00\x11\x00\x0d\x00\x39\x00\x45\x00\x3b\x00\x3c\x00\x3d\x00\x2c\x00\x5a\x00\x5a\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x51\x00\x47\x00\x48\x00\x4b\x00\x4a\x00\x4b\x00\x4d\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x57\x00\x57\x00\x57\x00\x5a\x00\x5b\x00\x57\x00\x58\x00\x56\x00\x5a\x00\x57\x00\x31\x00\x59\x00\x4d\x00\x34\x00\x35\x00\x57\x00\x57\x00\x59\x00\x39\x00\x2d\x00\x3b\x00\x3c\x00\x3d\x00\x57\x00\x58\x00\x4d\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x4b\x00\x47\x00\x48\x00\x14\x00\x4a\x00\x4b\x00\x2c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x2d\x00\x27\x00\x28\x00\x01\x00\x2a\x00\x14\x00\x58\x00\x26\x00\x5a\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x28\x00\x2e\x00\x10\x00\x2a\x00\x02\x00\x5a\x00\x17\x00\x0e\x00\x0f\x00\x10\x00\x29\x00\x32\x00\x33\x00\x2c\x00\x2d\x00\x2e\x00\x01\x00\x02\x00\x0e\x00\x0f\x00\x10\x00\x57\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x5a\x00\x13\x00\x10\x00\x4d\x00\x2f\x00\x17\x00\x02\x00\x33\x00\x28\x00\x34\x00\x35\x00\x50\x00\x00\x00\x01\x00\x39\x00\x2a\x00\x3b\x00\x4d\x00\x3d\x00\x33\x00\x1e\x00\x02\x00\x41\x00\x42\x00\x43\x00\x01\x00\x45\x00\x03\x00\x47\x00\x48\x00\x49\x00\x50\x00\x4b\x00\x2f\x00\x1e\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x4b\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x58\x00\x01\x00\x4f\x00\x50\x00\x1e\x00\x4b\x00\x1e\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x49\x00\x15\x00\x10\x00\x51\x00\x52\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x23\x00\x2a\x00\x02\x00\x15\x00\x2d\x00\x35\x00\x02\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x28\x00\x46\x00\x2b\x00\x2c\x00\x2d\x00\x23\x00\x2f\x00\x30\x00\x02\x00\x32\x00\x33\x00\x02\x00\x15\x00\x36\x00\x37\x00\x38\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x3e\x00\x3f\x00\x40\x00\x57\x00\x58\x00\x23\x00\x57\x00\x1e\x00\x46\x00\x2a\x00\x50\x00\x49\x00\x50\x00\x2a\x00\x4c\x00\x24\x00\x25\x00\x26\x00\x4f\x00\x50\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x01\x00\x2a\x00\x4e\x00\x50\x00\x2a\x00\x4c\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x50\x00\x14\x00\x10\x00\x24\x00\x25\x00\x26\x00\x02\x00\x03\x00\x01\x00\x34\x00\x35\x00\x50\x00\x37\x00\x38\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x13\x00\x12\x00\x10\x00\x14\x00\x2c\x00\x2d\x00\x2e\x00\x4e\x00\x2b\x00\x2c\x00\x4a\x00\x4b\x00\x2f\x00\x30\x00\x2b\x00\x32\x00\x33\x00\x2a\x00\x2b\x00\x36\x00\x37\x00\x38\x00\x27\x00\x28\x00\x01\x00\x2a\x00\x03\x00\x3e\x00\x3f\x00\x40\x00\x2c\x00\x2d\x00\x14\x00\x2f\x00\x01\x00\x46\x00\x03\x00\x4d\x00\x49\x00\x17\x00\x18\x00\x4c\x00\x34\x00\x35\x00\x4e\x00\x37\x00\x38\x00\x52\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x01\x00\x2a\x00\x03\x00\x2c\x00\x2d\x00\x2e\x00\x49\x00\x4d\x00\x13\x00\x32\x00\x33\x00\x4a\x00\x4b\x00\x11\x00\x12\x00\x01\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x0b\x00\x0c\x00\x10\x00\x01\x00\x16\x00\x4e\x00\x18\x00\x35\x00\x4d\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x1c\x00\x1d\x00\x10\x00\x41\x00\x01\x00\x27\x00\x28\x00\x45\x00\x2a\x00\x4e\x00\x0d\x00\x0e\x00\x0f\x00\x2b\x00\x16\x00\x01\x00\x02\x00\x2f\x00\x16\x00\x51\x00\x18\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x4e\x00\x2b\x00\x10\x00\x27\x00\x28\x00\x2f\x00\x2a\x00\x27\x00\x28\x00\x56\x00\x2a\x00\x17\x00\x18\x00\x34\x00\x35\x00\x49\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x2b\x00\x49\x00\x02\x00\x2f\x00\x02\x00\x4a\x00\x4b\x00\x11\x00\x12\x00\x0b\x00\x0c\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x01\x00\x2b\x00\x56\x00\x04\x00\x01\x00\x01\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x49\x00\x56\x00\x10\x00\x34\x00\x35\x00\x02\x00\x37\x00\x38\x00\x39\x00\x01\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x2b\x00\x04\x00\x10\x00\x4a\x00\x4b\x00\x04\x00\x01\x00\x02\x00\x01\x00\x2b\x00\x3a\x00\x2f\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x34\x00\x35\x00\x10\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x2c\x00\x34\x00\x35\x00\x2f\x00\x37\x00\x38\x00\x39\x00\x49\x00\x2a\x00\x02\x00\x02\x00\x4a\x00\x4b\x00\x2b\x00\x02\x00\x02\x00\x02\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x2f\x00\x4a\x00\x4b\x00\x01\x00\x1e\x00\x01\x00\x1e\x00\x49\x00\x34\x00\x35\x00\x52\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x27\x00\x28\x00\x2b\x00\x2a\x00\x49\x00\x2b\x00\x1e\x00\x01\x00\x4a\x00\x4b\x00\x01\x00\x32\x00\x33\x00\x01\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x01\x00\x01\x00\x1e\x00\x04\x00\x57\x00\x2b\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x2b\x00\x2b\x00\x10\x00\x01\x00\x04\x00\x02\x00\x04\x00\x02\x00\x2d\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x01\x00\x04\x00\x10\x00\x01\x00\x57\x00\x02\x00\x02\x00\x02\x00\x02\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x1a\x00\x2f\x00\x10\x00\x01\x00\x14\x00\x1b\x00\x1e\x00\x19\x00\x04\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x10\x00\x2f\x00\x10\x00\x02\x00\x56\x00\x02\x00\x57\x00\x27\x00\x28\x00\x30\x00\x2a\x00\x49\x00\x2c\x00\x2d\x00\x2e\x00\x57\x00\x02\x00\x2f\x00\x32\x00\x33\x00\x56\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x59\x00\x49\x00\x34\x00\x35\x00\x57\x00\x37\x00\x38\x00\x2f\x00\x2a\x00\x1f\x00\x2d\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x2b\x00\x49\x00\x2a\x00\x4d\x00\x57\x00\x02\x00\x01\x00\x2c\x00\x4a\x00\x4b\x00\x2c\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x59\x00\x49\x00\x2c\x00\x2a\x00\x57\x00\x34\x00\x35\x00\x02\x00\x37\x00\x38\x00\x01\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x56\x00\x04\x00\x10\x00\x01\x00\x4a\x00\x4b\x00\x1b\x00\x1a\x00\x10\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x19\x00\x2b\x00\x10\x00\x01\x00\x01\x00\x1f\x00\x2a\x00\x59\x00\x01\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x0d\x00\x02\x00\x2f\x00\x10\x00\x34\x00\x35\x00\x01\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x2f\x00\x2b\x00\x5b\x00\xff\xff\xff\xff\x21\x00\x22\x00\xff\xff\x4a\x00\x4b\x00\x49\x00\x27\x00\x28\x00\xff\xff\x2a\x00\xff\xff\x2f\x00\xff\xff\xff\xff\xff\xff\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x04\x00\x49\x00\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\xff\xff\x49\x00\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x53\x00\x54\x00\x55\x00\x56\x00\x57\x00\x04\x00\xff\xff\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\x1a\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x20\x00\x34\x00\x35\x00\x23\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x04\x00\xff\xff\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x04\x00\xff\xff\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x4a\x00\x4b\x00\xff\xff\x15\x00\xff\xff\xff\xff\xff\xff\x19\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\x23\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x04\x00\xff\xff\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\xff\xff\xff\xff\xff\xff\x04\x00\xff\xff\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x4a\x00\x4b\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x04\x00\xff\xff\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\xff\xff\xff\xff\xff\xff\x04\x00\xff\xff\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x4a\x00\x4b\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x04\x00\xff\xff\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x04\x00\xff\xff\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\x4a\x00\x4b\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x07\x00\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x04\x00\xff\xff\x06\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x0b\x00\x0c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\x07\x00\x47\x00\x48\x00\x21\x00\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\x27\x00\x28\x00\xff\xff\x2a\x00\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x20\x00\xff\xff\x01\x00\x23\x00\x03\x00\xff\xff\x05\x00\x06\x00\xff\xff\xff\xff\x09\x00\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\xff\xff\xff\xff\x20\x00\xff\xff\xff\xff\x23\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\x2c\x00\x4a\x00\x4b\x00\xff\xff\x30\x00\x31\x00\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\x39\x00\xff\xff\x3b\x00\x3c\x00\x3d\x00\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\x35\x00\x58\x00\xff\xff\x5a\x00\x39\x00\xff\xff\x3b\x00\x3c\x00\x3d\x00\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x57\x00\x58\x00\x31\x00\x5a\x00\xff\xff\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\x39\x00\xff\xff\x3b\x00\x3c\x00\x3d\x00\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\xff\xff\x31\x00\xff\xff\xff\xff\x34\x00\x35\x00\x58\x00\xff\xff\x5a\x00\x39\x00\xff\xff\x3b\x00\x3c\x00\x3d\x00\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x31\x00\xff\xff\xff\xff\x34\x00\x35\x00\xff\xff\x58\x00\x59\x00\x39\x00\xff\xff\x3b\x00\x3c\x00\x3d\x00\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x34\x00\x35\x00\xff\xff\xff\xff\xff\xff\x39\x00\x58\x00\x3b\x00\xff\xff\x3d\x00\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\xff\xff\x4b\x00\xff\xff\xff\xff\x4e\x00\x4f\x00\x50\x00\x51\x00\xff\xff\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\x58\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x4b\x00\x2f\x00\x30\x00\xff\xff\xff\xff\xff\xff\x34\x00\x35\x00\x53\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x2f\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x2f\x00\xff\xff\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\x47\x00\x48\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\x45\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\x43\x00\x44\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x3d\x00\x3e\x00\x3f\x00\x40\x00\x41\x00\x42\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x3b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\xff\xff\x4a\x00\x4b\x00\x34\x00\x35\x00\xff\xff\x37\x00\x38\x00\x39\x00\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x4a\x00\x4b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\x13\x01\x0d\x00\x0d\x00\xa8\x00\x45\x00\xa9\x00\xa8\x00\x0e\x00\xa9\x00\xdd\x00\xa8\x00\x99\x01\xa9\x00\x0e\x00\x0e\x00\x0e\x00\x0d\x00\x0d\x00\x0e\x00\xa5\x01\x7d\x00\xb7\x01\x42\x00\x1c\x01\x43\x00\x0b\x01\xa9\x01\x5b\x01\xad\x01\x0e\x00\xd8\x00\x6b\x01\xfc\x00\xaa\x01\xa9\x00\x7e\x00\xc1\x00\xc2\x00\xc3\x00\xc4\x00\x42\x00\x5c\x01\x43\x00\x41\x00\x0e\x00\x62\x01\x14\x01\x1e\x00\x0f\x00\xfc\x00\x11\x00\xa9\x00\xdc\x00\x42\x00\x0e\xff\x43\x00\xae\x01\x0e\xff\x0e\xff\x23\x00\xae\x01\x0e\x00\x0e\xff\x27\x00\x0e\xff\x0e\xff\x0e\xff\x77\x00\x11\x00\x11\x00\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x30\x00\x0e\xff\x0e\xff\x97\x01\x0e\xff\x0e\xff\x0b\x00\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x10\x00\x10\x00\x10\x00\x11\x00\xfe\xff\x10\x00\x0e\xff\x68\x00\x11\x00\x10\x00\x0e\xff\x35\x00\x0b\x00\x0e\xff\x0e\xff\x10\x00\x10\x00\x35\x00\x0e\xff\x1d\x01\x0e\xff\x0e\xff\x0e\xff\x78\x00\x79\x00\x0b\x00\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x0e\xff\xaf\x01\x0e\xff\x0e\xff\x69\x00\x0e\xff\x0e\xff\x75\x00\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x16\x01\x13\x00\x09\x00\x59\x00\x0a\x00\x69\x00\x0e\xff\x1f\x01\x11\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x71\x00\x09\x01\x62\x00\xf9\x00\xb6\x01\x11\x00\x3e\x00\xa3\x01\x95\x01\x96\x01\x6a\x00\xfa\x00\xa6\x00\x6b\x00\x6c\x00\x6d\x00\x59\x00\x8d\x01\x94\x01\x95\x01\x96\x01\x76\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x11\x00\x3d\x00\x62\x00\x0b\x00\x63\x00\x3e\x00\x9f\x01\x07\x01\x31\x00\x1d\x00\x1e\x00\x72\x00\x03\x00\x02\x00\x1f\x00\xb7\x01\x20\x00\x0b\x00\x22\x00\x07\x01\x16\x01\x89\x01\x23\x00\x24\x00\x25\x00\x06\x01\x27\x00\x07\x01\x28\x00\x29\x00\x64\x00\x6f\x00\x2b\x00\x63\x00\xa0\x01\x2d\x00\x2e\x00\x2f\x00\x30\x00\x97\x01\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x31\x00\x59\x00\x32\x00\x33\x00\x8a\x01\x97\x01\x17\x01\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x64\x00\x92\x00\x62\x00\x0b\x01\x0c\x01\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x1a\x00\x4d\x01\x70\x01\x93\x00\x4e\x01\x0e\x01\x23\x01\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x31\x00\x86\x00\x3b\x01\x45\x00\x3c\x01\x1a\x00\x63\x00\x3d\x01\x2f\x01\x3e\x01\x3f\x01\xa2\x00\x94\x00\x40\x01\x41\x01\x42\x01\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x43\x01\x44\x01\x45\x01\x9b\x01\x9c\x01\x1a\x00\x0f\x01\x97\x00\x46\x01\x71\x01\x6f\x00\x64\x00\x6f\x00\x24\x01\x47\x01\x12\x01\x9a\x00\x9b\x00\x32\x00\x33\x00\x48\x01\x65\x00\x66\x00\x67\x00\x68\x00\x49\x01\x59\x00\x30\x01\x9d\x00\x6f\x00\xa3\x00\xa9\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x6f\x00\x69\x00\x62\x00\x99\x00\x9a\x00\x9b\x00\x04\x00\x05\x00\x59\x00\x45\x00\x46\x00\x6f\x00\xab\x00\x48\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\xd2\x00\x06\x00\x62\x00\x07\x00\x26\x01\x6c\x00\x6d\x00\x73\x00\x3b\x01\x45\x00\x56\x00\x57\x00\x63\x00\x3d\x01\x12\x00\x3e\x01\x3f\x01\x6e\x01\x6f\x01\x40\x01\x41\x01\x42\x01\x08\x00\x09\x00\xfc\x00\x0a\x00\xa9\x00\x43\x01\x44\x01\x45\x01\xdc\x00\x7e\x01\x69\x00\x63\x00\x06\x01\x46\x01\x07\x01\x0b\x00\x64\x00\xbf\x00\xc0\x00\x47\x01\x45\x00\x46\x00\x79\x00\xad\x00\x48\x00\x48\x01\x65\x00\x66\x00\x67\x00\x68\x00\x49\x01\x37\x00\xf9\x00\x38\x00\x03\x01\x6c\x00\x6d\x00\x64\x00\x0b\x00\x38\x00\x04\x01\xa6\x00\x56\x00\x57\x00\xc5\x00\xc6\x00\x59\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\xc7\x00\xc8\x00\x62\x00\x59\x00\x39\x00\x7a\x00\x3a\x00\x1e\x00\x0b\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\xb9\x00\xba\x00\x62\x00\x23\x00\x02\x00\xd3\x00\x09\x00\x27\x00\x0a\x00\x7b\x00\xc9\x00\xca\x00\xcb\x00\x3b\x01\xd5\x00\x59\x00\x67\x01\x63\x00\x39\x00\x30\x00\x3a\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x35\x00\x53\x01\x62\x00\xd3\x00\x09\x00\x63\x00\x0a\x00\x3b\x00\x09\x00\x68\x00\x0a\x00\xbf\x00\xc0\x00\x45\x00\x46\x00\x64\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\xf2\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\xb9\x01\x64\x00\xba\x01\x63\x00\xbb\x01\x56\x00\x57\x00\xc5\x00\xc6\x00\xc7\x00\xc8\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x59\x00\xb1\x01\x68\x00\x26\x01\xb2\x01\xb3\x01\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x64\x00\x68\x00\x62\x00\x45\x00\x46\x00\xac\x01\x47\x00\x48\x00\x2c\x01\x59\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\xa5\x01\xa8\x01\x62\x00\x56\x00\x57\x00\xa9\x01\x59\x00\xe4\x00\x9d\x01\xa1\x01\x91\x01\x63\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x45\x00\x46\x00\x62\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\xf1\x00\xdc\x00\x45\x00\x46\x00\x63\x00\x47\x00\x48\x00\xe4\x00\x64\x00\x9e\x01\x93\x01\x94\x01\x56\x00\x57\x00\x9a\x01\x7f\x01\x80\x01\x81\x01\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x63\x00\x56\x00\x57\x00\x83\x01\x6d\x01\x72\x01\x73\x01\x64\x00\x45\x00\x46\x00\x75\x01\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\xeb\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\xa3\x00\x09\x00\x77\x01\xa4\x00\x64\x00\x79\x01\x4f\x01\x50\x01\x56\x00\x57\x00\x51\x01\xa5\x00\xa6\x00\x54\x01\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x59\x00\x56\x01\x58\x01\x03\x01\x55\x01\x59\x01\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x5b\x01\x5e\x01\x62\x00\x59\x00\x62\x01\x61\x01\x5a\x00\x64\x01\x1f\x01\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x22\x01\x2a\x01\x62\x00\x59\x00\x9d\x00\x28\x01\x29\x01\x2b\x01\x2c\x01\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\xbc\x00\x63\x00\x62\x00\xad\x00\x69\x00\xbb\x00\x2e\x01\xbd\x00\x31\x01\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\xbe\x00\x63\x00\x62\x00\x4a\x01\x68\x00\xf8\x00\xdf\x00\x13\x00\x09\x00\x40\x00\xa4\x00\x64\x00\x03\x01\x6c\x00\x6d\x00\xe0\x00\xf9\x00\x63\x00\x04\x01\xa6\x00\x01\x01\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x35\x00\x64\x00\x45\x00\x46\x00\x09\x01\xaf\x00\x48\x00\x63\x00\x11\x01\x10\x01\x12\x01\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x1a\x01\x64\x00\x85\x00\x0b\x00\x9d\x00\x86\x00\x9f\x00\x96\x00\x56\x00\x57\x00\x97\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x35\x00\x64\x00\x99\x00\xa0\x00\x9d\x00\x45\x00\x46\x00\xa1\x00\xb1\x00\x48\x00\xaf\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\xab\x00\xb8\x00\x62\x00\xb1\x00\x56\x00\x57\x00\xbb\x00\xbc\x00\xbe\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\xbd\x00\xd5\x00\x62\x00\x59\x00\xd7\x00\xd8\x00\x41\x00\x35\x00\x71\x00\x5b\x00\x5c\x00\x5d\x00\x5e\x00\x5f\x00\x60\x00\x61\x00\x7d\x00\x63\x00\x62\x00\x45\x00\x46\x00\x12\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\xf4\x00\x63\x00\x3d\x00\xff\xff\x00\x00\x00\x00\x67\x01\x68\x01\x00\x00\x56\x00\x57\x00\x64\x00\x69\x01\x09\x00\x00\x00\x0a\x00\x00\x00\x63\x00\x00\x00\x00\x00\x00\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\xa1\x01\x64\x00\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x00\x00\x00\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\x00\x00\x64\x00\x00\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\xe9\x00\x65\x00\x66\x00\x67\x00\x68\x00\x69\x00\xa2\x01\x00\x00\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\x00\x00\xb2\x00\xb3\x00\x18\x00\x19\x00\x00\x00\x00\x00\x1d\x01\x45\x00\x46\x00\x1a\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\x91\x01\x00\x00\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\xf3\x00\x8d\x01\x00\x00\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x56\x00\x57\x00\x00\x00\x14\x00\x00\x00\x00\x00\x00\x00\x15\x00\x16\x00\x17\x00\x18\x00\x19\x00\x00\x00\x00\x00\x00\x00\x45\x00\x46\x00\x1a\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\x8e\x01\x00\x00\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\xef\x00\x00\x00\x00\x00\x00\x00\x8f\x01\x00\x00\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x56\x00\x57\x00\x88\x00\x89\x00\x8a\x00\x8b\x00\x8c\x00\x8d\x00\x8e\x00\x8f\x00\x90\x00\x91\x00\x92\x00\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\x83\x01\x00\x00\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\xf0\x00\x00\x00\x00\x00\x00\x00\x73\x01\x00\x00\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x56\x00\x57\x00\xb2\x00\xb3\x00\x18\x00\x19\x00\x00\x00\x00\x00\xfc\x00\x00\x00\x00\x00\x1a\x00\x00\x00\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\x7b\x01\x00\x00\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\xec\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x01\x00\x00\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x56\x00\x57\x00\xb2\x00\xb3\x00\x18\x00\x19\x00\x00\x00\x00\x00\xfd\x00\x00\x00\x00\x00\x1a\x00\x00\x00\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x81\x01\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\x31\x01\x00\x00\x32\x01\x33\x01\x34\x01\x35\x01\x36\x01\x37\x01\x38\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x75\x01\x39\x01\x83\x00\x86\x01\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x69\x01\x09\x00\x00\x00\x0a\x00\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x39\x01\x83\x00\x00\x00\x56\x00\x57\x00\xb2\x00\xb3\x00\x18\x00\x19\x00\x00\x00\x00\x00\xb4\x00\x00\x00\xcd\x00\x1a\x00\xce\x00\x00\x00\xcf\x00\xd0\x00\x00\x00\x00\x00\xd1\x00\xd2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfe\x00\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\xb6\x00\x83\x00\x00\x00\x56\x00\x57\x00\xb2\x00\xb3\x00\x18\x00\x19\x00\x00\x00\x00\x00\xb4\x00\x00\x00\x00\x00\x1a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xff\x00\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\xb6\x00\x83\x00\x00\x00\x56\x00\x57\x00\xb2\x00\xb3\x00\x18\x00\x19\x00\x00\x00\x00\x00\xb4\x00\x00\x00\x00\x00\x1a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\x00\x00\x00\x00\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\xb6\x00\x83\x00\xca\xff\x56\x00\x57\x00\x00\x00\x40\x00\xca\xff\x00\x00\x00\x00\xca\xff\xca\xff\x00\x00\x00\x00\x00\x00\xca\xff\x00\x00\xca\xff\xca\xff\xca\xff\x00\x00\x00\x00\x00\x00\xca\xff\xca\xff\xca\xff\xca\xff\xca\xff\x00\x00\xca\xff\xca\xff\x00\x00\xca\xff\xca\xff\x00\x00\xca\xff\xca\xff\xca\xff\xca\xff\xca\xff\x00\x00\x0e\xff\x00\x00\x00\x00\x0e\xff\x0e\xff\xca\xff\x00\x00\xca\xff\x0e\xff\x00\x00\x0e\xff\x0e\xff\x0e\xff\x00\x00\x00\x00\x00\x00\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x00\x00\x0e\xff\x0e\xff\x00\x00\x0e\xff\x0e\xff\x00\x00\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6f\x00\x0e\xff\x0e\xff\x11\x00\x00\x00\x0e\xff\x0e\xff\x00\x00\x00\x00\x00\x00\x0e\xff\x00\x00\x0e\xff\x0e\xff\x0e\xff\x00\x00\x00\x00\x00\x00\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x00\x00\x0e\xff\x0e\xff\x00\x00\x0e\xff\x0e\xff\x00\x00\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x0e\xff\x00\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x0e\xff\x00\x00\x11\x00\x1f\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x00\x00\x28\x00\x29\x00\x00\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x1c\x00\x00\x00\x00\x00\x1d\x00\x1e\x00\x00\x00\x31\x00\x35\x00\x1f\x00\x00\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x00\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x00\x00\x28\x00\x29\x00\x00\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x1d\x00\x1e\x00\x00\x00\x00\x00\x00\x00\x1f\x00\x31\x00\x20\x00\x00\x00\x22\x00\x00\x00\x00\x00\x00\x00\x23\x00\x24\x00\x25\x00\x00\x00\x27\x00\x00\x00\x28\x00\x29\x00\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x2d\x00\x2e\x00\x2f\x00\x30\x00\x00\x00\x00\x00\x00\x00\x00\x00\x45\x00\x46\x00\x31\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x01\x56\x00\x57\x00\x4a\x01\x4b\x01\x00\x00\x00\x00\x00\x00\x45\x00\x46\x00\x65\x01\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\xda\x00\x00\x00\x7c\x01\x00\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\xda\x00\x00\x00\xd9\x00\x00\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\xda\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\xb3\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\xb4\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\xa6\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x8a\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x8b\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x84\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x77\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x79\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x7a\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x51\x01\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\xe0\x00\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\xf5\x00\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\xb6\x00\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x81\x00\x00\x00\x82\x00\x83\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\xe1\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\xe2\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x85\x01\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x87\x01\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x01\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x59\x01\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x5e\x01\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x20\x01\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x24\x01\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x01\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x18\x01\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x7f\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x80\x00\x1a\x01\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x54\x00\x00\x00\x00\x00\x00\x00\x00\x00\x55\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\x52\x00\x53\x00\x5f\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\x4c\x00\x4d\x00\x4e\x00\x4f\x00\x50\x00\x51\x00\xf6\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\xed\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\x4b\x00\xee\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\xe7\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\x4a\x00\xea\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\x49\x00\xe8\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\xe5\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\xe6\x00\x00\x00\x56\x00\x57\x00\x45\x00\x46\x00\x00\x00\x47\x00\x48\x00\xcb\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x00\x57\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = array (1, 256) [
	(1 , happyReduce_1),
	(2 , happyReduce_2),
	(3 , happyReduce_3),
	(4 , happyReduce_4),
	(5 , happyReduce_5),
	(6 , happyReduce_6),
	(7 , happyReduce_7),
	(8 , happyReduce_8),
	(9 , happyReduce_9),
	(10 , happyReduce_10),
	(11 , happyReduce_11),
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251),
	(252 , happyReduce_252),
	(253 , happyReduce_253),
	(254 , happyReduce_254),
	(255 , happyReduce_255),
	(256 , happyReduce_256)
	]

happy_n_terms = 92 :: Int
happy_n_nonterms = 84 :: Int

happyReduce_1 = happySpecReduce_1 0# happyReduction_1
happyReduction_1 happy_x_1
	 =  case happyOut5 happy_x_1 of { happy_var_1 -> 
	happyIn4
		 (CHeader (reverse happy_var_1)
	)}

happyReduce_2 = happySpecReduce_0 1# happyReduction_2
happyReduction_2  =  happyIn5
		 ([]
	)

happyReduce_3 = happySpecReduce_2 1# happyReduction_3
happyReduction_3 happy_x_2
	happy_x_1
	 =  case happyOut5 happy_x_1 of { happy_var_1 -> 
	case happyOut6 happy_x_2 of { happy_var_2 -> 
	happyIn5
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_4 = happyMonadReduce 6# 1# happyReduction_4
happyReduction_4 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut5 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_2 $ \at -> CAsmExt at : happy_var_1}}
	) (\r -> happyReturn (happyIn5 r))

happyReduce_5 = happySpecReduce_1 2# happyReduction_5
happyReduction_5 happy_x_1
	 =  case happyOut7 happy_x_1 of { happy_var_1 -> 
	happyIn6
		 (CFDefExt happy_var_1
	)}

happyReduce_6 = happySpecReduce_2 2# happyReduction_6
happyReduction_6 happy_x_2
	happy_x_1
	 =  case happyOut22 happy_x_1 of { happy_var_1 -> 
	happyIn6
		 (CDeclExt happy_var_1
	)}

happyReduce_7 = happyMonadReduce 4# 3# happyReduction_7
happyReduction_7 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut24 happy_x_1 of { happy_var_1 -> 
	case happyOut43 happy_x_2 of { happy_var_2 -> 
	case happyOut23 happy_x_3 of { happy_var_3 -> 
	case happyOut12 happy_x_4 of { happy_var_4 -> 
	 withAttrs happy_var_1 $ CFunDef happy_var_1 happy_var_2 (reverse happy_var_3) happy_var_4}}}}
	) (\r -> happyReturn (happyIn7 r))

happyReduce_8 = happyMonadReduce 3# 3# happyReduction_8
happyReduction_8 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut43 happy_x_1 of { happy_var_1 -> 
	case happyOut23 happy_x_2 of { happy_var_2 -> 
	case happyOut12 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_1 $ CFunDef [] happy_var_1 (reverse happy_var_2) happy_var_3}}}
	) (\r -> happyReturn (happyIn7 r))

happyReduce_9 = happySpecReduce_1 4# happyReduction_9
happyReduction_9 happy_x_1
	 =  case happyOut10 happy_x_1 of { happy_var_1 -> 
	happyIn8
		 (happy_var_1
	)}

happyReduce_10 = happySpecReduce_1 4# happyReduction_10
happyReduction_10 happy_x_1
	 =  case happyOut12 happy_x_1 of { happy_var_1 -> 
	happyIn8
		 (happy_var_1
	)}

happyReduce_11 = happySpecReduce_1 4# happyReduction_11
happyReduction_11 happy_x_1
	 =  case happyOut11 happy_x_1 of { happy_var_1 -> 
	happyIn8
		 (happy_var_1
	)}

happyReduce_12 = happySpecReduce_1 4# happyReduction_12
happyReduction_12 happy_x_1
	 =  case happyOut13 happy_x_1 of { happy_var_1 -> 
	happyIn8
		 (happy_var_1
	)}

happyReduce_13 = happySpecReduce_1 4# happyReduction_13
happyReduction_13 happy_x_1
	 =  case happyOut14 happy_x_1 of { happy_var_1 -> 
	happyIn8
		 (happy_var_1
	)}

happyReduce_14 = happySpecReduce_1 4# happyReduction_14
happyReduction_14 happy_x_1
	 =  case happyOut15 happy_x_1 of { happy_var_1 -> 
	happyIn8
		 (happy_var_1
	)}

happyReduce_15 = happySpecReduce_1 4# happyReduction_15
happyReduction_15 happy_x_1
	 =  case happyOut16 happy_x_1 of { happy_var_1 -> 
	happyIn8
		 (happy_var_1
	)}

happyReduce_16 = happySpecReduce_0 5# happyReduction_16
happyReduction_16  =  happyIn9
		 ([]
	)

happyReduce_17 = happySpecReduce_2 5# happyReduction_17
happyReduction_17 happy_x_2
	happy_x_1
	 =  case happyOut9 happy_x_1 of { happy_var_1 -> 
	case happyOut8 happy_x_2 of { happy_var_2 -> 
	happyIn9
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_18 = happyMonadReduce 3# 6# happyReduction_18
happyReduction_18 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { (CTokIdent  _ happy_var_1) -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut8 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CLabel happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn10 r))

happyReduce_19 = happyMonadReduce 4# 6# happyReduction_19
happyReduction_19 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut77 happy_x_2 of { happy_var_2 -> 
	case happyOut8 happy_x_4 of { happy_var_4 -> 
	 withAttrs happy_var_1 $ CCase happy_var_2 happy_var_4}}}
	) (\r -> happyReturn (happyIn10 r))

happyReduce_20 = happyMonadReduce 3# 6# happyReduction_20
happyReduction_20 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut8 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_1 $ CDefault happy_var_3}}
	) (\r -> happyReturn (happyIn10 r))

happyReduce_21 = happyMonadReduce 1# 7# happyReduction_21
happyReduction_21 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CExpr Nothing}
	) (\r -> happyReturn (happyIn11 r))

happyReduce_22 = happyMonadReduce 2# 7# happyReduction_22
happyReduction_22 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut75 happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CExpr (Just happy_var_1)}
	) (\r -> happyReturn (happyIn11 r))

happyReduce_23 = happyMonadReduce 4# 8# happyReduction_23
happyReduction_23 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut23 happy_x_2 of { happy_var_2 -> 
	case happyOut9 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_1 $ CCompound (reverse happy_var_2) (reverse happy_var_3)}}}
	) (\r -> happyReturn (happyIn12 r))

happyReduce_24 = happyMonadReduce 5# 9# happyReduction_24
happyReduction_24 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOut8 happy_x_5 of { happy_var_5 -> 
	 withAttrs happy_var_1 $ CIf happy_var_3 happy_var_5 Nothing}}}
	) (\r -> happyReturn (happyIn13 r))

happyReduce_25 = happyMonadReduce 7# 9# happyReduction_25
happyReduction_25 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOut8 happy_x_5 of { happy_var_5 -> 
	case happyOut8 happy_x_7 of { happy_var_7 -> 
	 withAttrs happy_var_1 $ CIf happy_var_3 happy_var_5 (Just happy_var_7)}}}}
	) (\r -> happyReturn (happyIn13 r))

happyReduce_26 = happyMonadReduce 5# 9# happyReduction_26
happyReduction_26 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOut8 happy_x_5 of { happy_var_5 -> 
	 withAttrs happy_var_1 $ CSwitch happy_var_3 happy_var_5}}}
	) (\r -> happyReturn (happyIn13 r))

happyReduce_27 = happyMonadReduce 5# 10# happyReduction_27
happyReduction_27 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOut8 happy_x_5 of { happy_var_5 -> 
	 withAttrs happy_var_1 $ CWhile happy_var_3 happy_var_5 False}}}
	) (\r -> happyReturn (happyIn14 r))

happyReduce_28 = happyMonadReduce 7# 10# happyReduction_28
happyReduction_28 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut8 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_5 of { happy_var_5 -> 
	 withAttrs happy_var_1 $ CWhile happy_var_5 happy_var_2 True}}}
	) (\r -> happyReturn (happyIn14 r))

happyReduce_29 = happyMonadReduce 6# 10# happyReduction_29
happyReduction_29 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut11 happy_x_3 of { happy_var_3 -> 
	case happyOut11 happy_x_4 of { happy_var_4 -> 
	case happyOut8 happy_x_6 of { happy_var_6 -> 
	 withAttrs happy_var_1 $ case happy_var_3 of
	                    CExpr e3 _ ->
			      case happy_var_4 of
			        CExpr e4 _ -> CFor e3 e4 Nothing happy_var_6}}}}
	) (\r -> happyReturn (happyIn14 r))

happyReduce_30 = happyMonadReduce 7# 10# happyReduction_30
happyReduction_30 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut11 happy_x_3 of { happy_var_3 -> 
	case happyOut11 happy_x_4 of { happy_var_4 -> 
	case happyOut75 happy_x_5 of { happy_var_5 -> 
	case happyOut8 happy_x_7 of { happy_var_7 -> 
	 withAttrs happy_var_1 $ case happy_var_3 of
	                    CExpr e3 _ ->
			      case happy_var_4 of
			        CExpr e4 _ -> CFor e3 e4 (Just happy_var_5) happy_var_7}}}}}
	) (\r -> happyReturn (happyIn14 r))

happyReduce_31 = happyMonadReduce 3# 11# happyReduction_31
happyReduction_31 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (CTokIdent  _ happy_var_2) -> 
	 withAttrs happy_var_1 $ CGoto happy_var_2}}
	) (\r -> happyReturn (happyIn15 r))

happyReduce_32 = happyMonadReduce 2# 11# happyReduction_32
happyReduction_32 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CCont}
	) (\r -> happyReturn (happyIn15 r))

happyReduce_33 = happyMonadReduce 2# 11# happyReduction_33
happyReduction_33 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CBreak}
	) (\r -> happyReturn (happyIn15 r))

happyReduce_34 = happyMonadReduce 2# 11# happyReduction_34
happyReduction_34 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CReturn Nothing}
	) (\r -> happyReturn (happyIn15 r))

happyReduce_35 = happyMonadReduce 3# 11# happyReduction_35
happyReduction_35 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CReturn (Just happy_var_2)}}
	) (\r -> happyReturn (happyIn15 r))

happyReduce_36 = happyMonadReduce 6# 12# happyReduction_36
happyReduction_36 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 CAsm}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_37 = happyMonadReduce 8# 12# happyReduction_37
happyReduction_37 (happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 CAsm}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_38 = happyMonadReduce 10# 12# happyReduction_38
happyReduction_38 (happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 CAsm}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_39 = happyMonadReduce 12# 12# happyReduction_39
happyReduction_39 (happy_x_12 `HappyStk`
	happy_x_11 `HappyStk`
	happy_x_10 `HappyStk`
	happy_x_9 `HappyStk`
	happy_x_8 `HappyStk`
	happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 CAsm}
	) (\r -> happyReturn (happyIn16 r))

happyReduce_40 = happySpecReduce_0 13# happyReduction_40
happyReduction_40  =  happyIn17
		 (()
	)

happyReduce_41 = happySpecReduce_1 13# happyReduction_41
happyReduction_41 happy_x_1
	 =  happyIn17
		 (()
	)

happyReduce_42 = happySpecReduce_0 14# happyReduction_42
happyReduction_42  =  happyIn18
		 (()
	)

happyReduce_43 = happySpecReduce_1 14# happyReduction_43
happyReduction_43 happy_x_1
	 =  happyIn18
		 (()
	)

happyReduce_44 = happySpecReduce_1 15# happyReduction_44
happyReduction_44 happy_x_1
	 =  happyIn19
		 (()
	)

happyReduce_45 = happySpecReduce_3 15# happyReduction_45
happyReduction_45 happy_x_3
	happy_x_2
	happy_x_1
	 =  happyIn19
		 (()
	)

happyReduce_46 = happyReduce 4# 16# happyReduction_46
happyReduction_46 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyIn20
		 (()
	) `HappyStk` happyRest

happyReduce_47 = happyReduce 7# 16# happyReduction_47
happyReduction_47 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyIn20
		 (()
	) `HappyStk` happyRest

happyReduce_48 = happyReduce 7# 16# happyReduction_48
happyReduction_48 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyIn20
		 (()
	) `HappyStk` happyRest

happyReduce_49 = happySpecReduce_1 17# happyReduction_49
happyReduction_49 happy_x_1
	 =  happyIn21
		 (()
	)

happyReduce_50 = happySpecReduce_3 17# happyReduction_50
happyReduction_50 happy_x_3
	happy_x_2
	happy_x_1
	 =  happyIn21
		 (()
	)

happyReduce_51 = happyMonadReduce 1# 18# happyReduction_51
happyReduction_51 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut24 happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CDecl happy_var_1 []}
	) (\r -> happyReturn (happyIn22 r))

happyReduce_52 = happyMonadReduce 2# 18# happyReduction_52
happyReduction_52 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut24 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	 let declrs = reverse happy_var_2
	    in when (isTypeDef happy_var_1)
	            (mapM_ addTypedef (getTypeDefIdents (map fst declrs)))
	    >> getNewName >>= \name ->
	       let attrs = newAttrs (posOf happy_var_1) name
	           declrs' = [ (Just d, i, Nothing) | (d, i) <- declrs ]
	        in attrs `seq`
	           return (CDecl happy_var_1 declrs' attrs)}}
	) (\r -> happyReturn (happyIn22 r))

happyReduce_53 = happySpecReduce_0 19# happyReduction_53
happyReduction_53  =  happyIn23
		 ([]
	)

happyReduce_54 = happySpecReduce_3 19# happyReduction_54
happyReduction_54 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut23 happy_x_1 of { happy_var_1 -> 
	case happyOut22 happy_x_2 of { happy_var_2 -> 
	happyIn23
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_55 = happySpecReduce_2 20# happyReduction_55
happyReduction_55 happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_2 of { happy_var_2 -> 
	happyIn24
		 (happy_var_2
	)}

happyReduce_56 = happySpecReduce_2 21# happyReduction_56
happyReduction_56 happy_x_2
	happy_x_1
	 =  case happyOut29 happy_x_1 of { happy_var_1 -> 
	happyIn25
		 ([CStorageSpec happy_var_1]
	)}

happyReduce_57 = happySpecReduce_3 21# happyReduction_57
happyReduction_57 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut29 happy_x_1 of { happy_var_1 -> 
	case happyOut25 happy_x_3 of { happy_var_3 -> 
	happyIn25
		 (CStorageSpec happy_var_1 : happy_var_3
	)}}

happyReduce_58 = happySpecReduce_2 21# happyReduction_58
happyReduction_58 happy_x_2
	happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn25
		 ([CTypeSpec happy_var_1]
	)}

happyReduce_59 = happySpecReduce_3 21# happyReduction_59
happyReduction_59 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	case happyOut25 happy_x_3 of { happy_var_3 -> 
	happyIn25
		 (CTypeSpec happy_var_1 : happy_var_3
	)}}

happyReduce_60 = happySpecReduce_2 21# happyReduction_60
happyReduction_60 happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	happyIn25
		 ([CTypeQual happy_var_1]
	)}

happyReduce_61 = happySpecReduce_3 21# happyReduction_61
happyReduction_61 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	case happyOut25 happy_x_3 of { happy_var_3 -> 
	happyIn25
		 (CTypeQual happy_var_1 : happy_var_3
	)}}

happyReduce_62 = happySpecReduce_2 22# happyReduction_62
happyReduction_62 happy_x_2
	happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	happyIn26
		 ((happy_var_1, Nothing)
	)}

happyReduce_63 = happyReduce 4# 22# happyReduction_63
happyReduction_63 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut43 happy_x_1 of { happy_var_1 -> 
	case happyOut51 happy_x_4 of { happy_var_4 -> 
	happyIn26
		 ((happy_var_1, Just happy_var_4)
	) `HappyStk` happyRest}}

happyReduce_64 = happySpecReduce_0 23# happyReduction_64
happyReduction_64  =  happyIn27
		 (()
	)

happyReduce_65 = happyReduce 4# 23# happyReduction_65
happyReduction_65 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyIn27
		 (()
	) `HappyStk` happyRest

happyReduce_66 = happySpecReduce_1 24# happyReduction_66
happyReduction_66 happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 ([happy_var_1]
	)}

happyReduce_67 = happySpecReduce_3 24# happyReduction_67
happyReduction_67 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn28
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_68 = happyMonadReduce 1# 25# happyReduction_68
happyReduction_68 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CTypedef}
	) (\r -> happyReturn (happyIn29 r))

happyReduce_69 = happyMonadReduce 1# 25# happyReduction_69
happyReduction_69 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CExtern}
	) (\r -> happyReturn (happyIn29 r))

happyReduce_70 = happyMonadReduce 1# 25# happyReduction_70
happyReduction_70 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CStatic}
	) (\r -> happyReturn (happyIn29 r))

happyReduce_71 = happyMonadReduce 1# 25# happyReduction_71
happyReduction_71 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CAuto}
	) (\r -> happyReturn (happyIn29 r))

happyReduce_72 = happyMonadReduce 1# 25# happyReduction_72
happyReduction_72 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CRegister}
	) (\r -> happyReturn (happyIn29 r))

happyReduce_73 = happyMonadReduce 1# 26# happyReduction_73
happyReduction_73 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CVoidType}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_74 = happyMonadReduce 1# 26# happyReduction_74
happyReduction_74 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CCharType}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_75 = happyMonadReduce 1# 26# happyReduction_75
happyReduction_75 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CShortType}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_76 = happyMonadReduce 1# 26# happyReduction_76
happyReduction_76 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CIntType}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_77 = happyMonadReduce 1# 26# happyReduction_77
happyReduction_77 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CLongType}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_78 = happyMonadReduce 1# 26# happyReduction_78
happyReduction_78 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CFloatType}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_79 = happyMonadReduce 1# 26# happyReduction_79
happyReduction_79 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CDoubleType}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_80 = happyMonadReduce 1# 26# happyReduction_80
happyReduction_80 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CSignedType}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_81 = happyMonadReduce 1# 26# happyReduction_81
happyReduction_81 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CUnsigType}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_82 = happyMonadReduce 1# 26# happyReduction_82
happyReduction_82 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut32 happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CSUType happy_var_1}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_83 = happyMonadReduce 1# 26# happyReduction_83
happyReduction_83 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut39 happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CEnumType happy_var_1}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_84 = happyMonadReduce 1# 26# happyReduction_84
happyReduction_84 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { (CTokTyIdent _ happy_var_1) -> 
	 withAttrs happy_var_1 $ CTypeDef happy_var_1}
	) (\r -> happyReturn (happyIn30 r))

happyReduce_85 = happyMonadReduce 1# 27# happyReduction_85
happyReduction_85 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CConstQual}
	) (\r -> happyReturn (happyIn31 r))

happyReduce_86 = happyMonadReduce 1# 27# happyReduction_86
happyReduction_86 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CVolatQual}
	) (\r -> happyReturn (happyIn31 r))

happyReduce_87 = happyMonadReduce 1# 27# happyReduction_87
happyReduction_87 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CRestrQual}
	) (\r -> happyReturn (happyIn31 r))

happyReduce_88 = happyMonadReduce 1# 27# happyReduction_88
happyReduction_88 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CInlinQual}
	) (\r -> happyReturn (happyIn31 r))

happyReduce_89 = happyMonadReduce 5# 28# happyReduction_89
happyReduction_89 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut33 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (CTokIdent  _ happy_var_2) -> 
	case happyOut34 happy_x_4 of { happy_var_4 -> 
	 withAttrs happy_var_1 $ CStruct (unL happy_var_1) (Just happy_var_2) (reverse happy_var_4)}}}
	) (\r -> happyReturn (happyIn32 r))

happyReduce_90 = happyMonadReduce 5# 28# happyReduction_90
happyReduction_90 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut33 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (CTokTyIdent _ happy_var_2) -> 
	case happyOut34 happy_x_4 of { happy_var_4 -> 
	 withAttrs happy_var_1 $ CStruct (unL happy_var_1) (Just happy_var_2) (reverse happy_var_4)}}}
	) (\r -> happyReturn (happyIn32 r))

happyReduce_91 = happyMonadReduce 4# 28# happyReduction_91
happyReduction_91 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut33 happy_x_1 of { happy_var_1 -> 
	case happyOut34 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_1 $ CStruct (unL happy_var_1) Nothing   (reverse happy_var_3)}}
	) (\r -> happyReturn (happyIn32 r))

happyReduce_92 = happyMonadReduce 2# 28# happyReduction_92
happyReduction_92 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut33 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (CTokIdent  _ happy_var_2) -> 
	 withAttrs happy_var_1 $ CStruct (unL happy_var_1) (Just happy_var_2) []}}
	) (\r -> happyReturn (happyIn32 r))

happyReduce_93 = happyMonadReduce 2# 28# happyReduction_93
happyReduction_93 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut33 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (CTokTyIdent _ happy_var_2) -> 
	 withAttrs happy_var_1 $ CStruct (unL happy_var_1) (Just happy_var_2) []}}
	) (\r -> happyReturn (happyIn32 r))

happyReduce_94 = happySpecReduce_1 29# happyReduction_94
happyReduction_94 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn33
		 (L CStructTag (posOf happy_var_1)
	)}

happyReduce_95 = happySpecReduce_1 29# happyReduction_95
happyReduction_95 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn33
		 (L CUnionTag (posOf happy_var_1)
	)}

happyReduce_96 = happySpecReduce_0 30# happyReduction_96
happyReduction_96  =  happyIn34
		 ([]
	)

happyReduce_97 = happySpecReduce_2 30# happyReduction_97
happyReduction_97 happy_x_2
	happy_x_1
	 =  case happyOut34 happy_x_1 of { happy_var_1 -> 
	case happyOut35 happy_x_2 of { happy_var_2 -> 
	happyIn34
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_98 = happyMonadReduce 4# 31# happyReduction_98
happyReduction_98 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut36 happy_x_2 of { happy_var_2 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CDecl happy_var_2 [(d,Nothing,s) | (d,s) <- reverse happy_var_3]}}
	) (\r -> happyReturn (happyIn35 r))

happyReduce_99 = happySpecReduce_1 32# happyReduction_99
happyReduction_99 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn36
		 ([CTypeSpec happy_var_1]
	)}

happyReduce_100 = happySpecReduce_2 32# happyReduction_100
happyReduction_100 happy_x_2
	happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	case happyOut36 happy_x_2 of { happy_var_2 -> 
	happyIn36
		 (CTypeSpec happy_var_1 : happy_var_2
	)}}

happyReduce_101 = happySpecReduce_1 32# happyReduction_101
happyReduction_101 happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	happyIn36
		 ([CTypeQual happy_var_1]
	)}

happyReduce_102 = happySpecReduce_2 32# happyReduction_102
happyReduction_102 happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	case happyOut36 happy_x_2 of { happy_var_2 -> 
	happyIn36
		 (CTypeQual happy_var_1 : happy_var_2
	)}}

happyReduce_103 = happySpecReduce_1 33# happyReduction_103
happyReduction_103 happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	happyIn37
		 ((Just happy_var_1, Nothing)
	)}

happyReduce_104 = happySpecReduce_2 33# happyReduction_104
happyReduction_104 happy_x_2
	happy_x_1
	 =  case happyOut77 happy_x_2 of { happy_var_2 -> 
	happyIn37
		 ((Nothing, Just happy_var_2)
	)}

happyReduce_105 = happySpecReduce_3 33# happyReduction_105
happyReduction_105 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut43 happy_x_1 of { happy_var_1 -> 
	case happyOut77 happy_x_3 of { happy_var_3 -> 
	happyIn37
		 ((Just happy_var_1, Just happy_var_3)
	)}}

happyReduce_106 = happySpecReduce_1 34# happyReduction_106
happyReduction_106 happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	happyIn38
		 ([happy_var_1]
	)}

happyReduce_107 = happySpecReduce_3 34# happyReduction_107
happyReduction_107 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut37 happy_x_3 of { happy_var_3 -> 
	happyIn38
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_108 = happyMonadReduce 4# 35# happyReduction_108
happyReduction_108 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut40 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_1 $ CEnum Nothing   (reverse happy_var_3)}}
	) (\r -> happyReturn (happyIn39 r))

happyReduce_109 = happyMonadReduce 5# 35# happyReduction_109
happyReduction_109 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (CTokIdent  _ happy_var_2) -> 
	case happyOut40 happy_x_4 of { happy_var_4 -> 
	 withAttrs happy_var_1 $ CEnum (Just happy_var_2) (reverse happy_var_4)}}}
	) (\r -> happyReturn (happyIn39 r))

happyReduce_110 = happyMonadReduce 2# 35# happyReduction_110
happyReduction_110 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (CTokIdent  _ happy_var_2) -> 
	 withAttrs happy_var_1 $ CEnum (Just happy_var_2) []}}
	) (\r -> happyReturn (happyIn39 r))

happyReduce_111 = happySpecReduce_1 36# happyReduction_111
happyReduction_111 happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	happyIn40
		 (happy_var_1
	)}

happyReduce_112 = happySpecReduce_2 36# happyReduction_112
happyReduction_112 happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	happyIn40
		 (happy_var_1
	)}

happyReduce_113 = happySpecReduce_1 37# happyReduction_113
happyReduction_113 happy_x_1
	 =  case happyOut42 happy_x_1 of { happy_var_1 -> 
	happyIn41
		 ([happy_var_1]
	)}

happyReduce_114 = happySpecReduce_3 37# happyReduction_114
happyReduction_114 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOut42 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_115 = happySpecReduce_1 38# happyReduction_115
happyReduction_115 happy_x_1
	 =  case happyOutTok happy_x_1 of { (CTokIdent  _ happy_var_1) -> 
	happyIn42
		 ((happy_var_1, Nothing)
	)}

happyReduce_116 = happySpecReduce_3 38# happyReduction_116
happyReduction_116 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (CTokIdent  _ happy_var_1) -> 
	case happyOut77 happy_x_3 of { happy_var_3 -> 
	happyIn42
		 ((happy_var_1, Just happy_var_3)
	)}}

happyReduce_117 = happyMonadReduce 3# 39# happyReduction_117
happyReduction_117 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CPtrDeclr (map unL happy_var_1) happy_var_2}}
	) (\r -> happyReturn (happyIn43 r))

happyReduce_118 = happyMonadReduce 4# 39# happyReduction_118
happyReduction_118 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_1 $ CPtrDeclr (map unL happy_var_1) happy_var_3}}
	) (\r -> happyReturn (happyIn43 r))

happyReduce_119 = happySpecReduce_2 39# happyReduction_119
happyReduction_119 happy_x_2
	happy_x_1
	 =  case happyOut44 happy_x_1 of { happy_var_1 -> 
	happyIn43
		 (happy_var_1
	)}

happyReduce_120 = happyMonadReduce 1# 40# happyReduction_120
happyReduction_120 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { (CTokIdent  _ happy_var_1) -> 
	 withAttrs happy_var_1 $ CVarDeclr (Just happy_var_1)}
	) (\r -> happyReturn (happyIn44 r))

happyReduce_121 = happySpecReduce_3 40# happyReduction_121
happyReduction_121 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut43 happy_x_2 of { happy_var_2 -> 
	happyIn44
		 (happy_var_2
	)}

happyReduce_122 = happyMonadReduce 4# 40# happyReduction_122
happyReduction_122 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut77 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CArrDeclr happy_var_1 (Just happy_var_3)}}}
	) (\r -> happyReturn (happyIn44 r))

happyReduce_123 = happyMonadReduce 3# 40# happyReduction_123
happyReduction_123 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_2 $ CArrDeclr happy_var_1  Nothing}}
	) (\r -> happyReturn (happyIn44 r))

happyReduce_124 = happyMonadReduce 4# 40# happyReduction_124
happyReduction_124 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ case happy_var_3 of
	                    (parms, variadic) -> CFunDeclr happy_var_1 parms variadic}}}
	) (\r -> happyReturn (happyIn44 r))

happyReduce_125 = happyMonadReduce 4# 40# happyReduction_125
happyReduction_125 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_2 $ CFunDeclr happy_var_1 [] False}}
	) (\r -> happyReturn (happyIn44 r))

happyReduce_126 = happySpecReduce_1 41# happyReduction_126
happyReduction_126 happy_x_1
	 =  happyIn45
		 (()
	)

happyReduce_127 = happySpecReduce_3 41# happyReduction_127
happyReduction_127 happy_x_3
	happy_x_2
	happy_x_1
	 =  happyIn45
		 (()
	)

happyReduce_128 = happySpecReduce_2 42# happyReduction_128
happyReduction_128 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut47 happy_x_2 of { happy_var_2 -> 
	happyIn46
		 ([L (reverse happy_var_2) (posOf happy_var_1)]
	)}}

happyReduce_129 = happySpecReduce_3 42# happyReduction_129
happyReduction_129 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut47 happy_x_2 of { happy_var_2 -> 
	case happyOut46 happy_x_3 of { happy_var_3 -> 
	happyIn46
		 (L (reverse happy_var_2) (posOf happy_var_1) : happy_var_3
	)}}}

happyReduce_130 = happySpecReduce_0 43# happyReduction_130
happyReduction_130  =  happyIn47
		 ([]
	)

happyReduce_131 = happySpecReduce_2 43# happyReduction_131
happyReduction_131 happy_x_2
	happy_x_1
	 =  case happyOut47 happy_x_1 of { happy_var_1 -> 
	case happyOut31 happy_x_2 of { happy_var_2 -> 
	happyIn47
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_132 = happySpecReduce_0 44# happyReduction_132
happyReduction_132  =  happyIn48
		 (([], False)
	)

happyReduce_133 = happySpecReduce_1 44# happyReduction_133
happyReduction_133 happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 ((reverse happy_var_1, False)
	)}

happyReduce_134 = happySpecReduce_3 44# happyReduction_134
happyReduction_134 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 ((reverse happy_var_1, True)
	)}

happyReduce_135 = happySpecReduce_1 45# happyReduction_135
happyReduction_135 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn49
		 ([happy_var_1]
	)}

happyReduce_136 = happySpecReduce_3 45# happyReduction_136
happyReduction_136 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	case happyOut50 happy_x_3 of { happy_var_3 -> 
	happyIn49
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_137 = happyMonadReduce 2# 46# happyReduction_137
happyReduction_137 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut24 happy_x_1 of { happy_var_1 -> 
	case happyOut43 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CDecl happy_var_1 [(Just happy_var_2, Nothing, Nothing)]}}
	) (\r -> happyReturn (happyIn50 r))

happyReduce_138 = happyMonadReduce 2# 46# happyReduction_138
happyReduction_138 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut24 happy_x_1 of { happy_var_1 -> 
	case happyOut54 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CDecl happy_var_1 [(Just happy_var_2, Nothing, Nothing)]}}
	) (\r -> happyReturn (happyIn50 r))

happyReduce_139 = happyMonadReduce 1# 46# happyReduction_139
happyReduction_139 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut24 happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CDecl happy_var_1 []}
	) (\r -> happyReturn (happyIn50 r))

happyReduce_140 = happyMonadReduce 1# 47# happyReduction_140
happyReduction_140 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut73 happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CInitExpr happy_var_1}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_141 = happyMonadReduce 3# 47# happyReduction_141
happyReduction_141 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CInitList happy_var_2}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_142 = happyMonadReduce 4# 47# happyReduction_142
happyReduction_142 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CInitList happy_var_2}}
	) (\r -> happyReturn (happyIn51 r))

happyReduce_143 = happySpecReduce_1 48# happyReduction_143
happyReduction_143 happy_x_1
	 =  case happyOut51 happy_x_1 of { happy_var_1 -> 
	happyIn52
		 ([happy_var_1]
	)}

happyReduce_144 = happySpecReduce_3 48# happyReduction_144
happyReduction_144 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	case happyOut51 happy_x_3 of { happy_var_3 -> 
	happyIn52
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_145 = happyMonadReduce 1# 49# happyReduction_145
happyReduction_145 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut36 happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CDecl happy_var_1 []}
	) (\r -> happyReturn (happyIn53 r))

happyReduce_146 = happyMonadReduce 2# 49# happyReduction_146
happyReduction_146 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut36 happy_x_1 of { happy_var_1 -> 
	case happyOut54 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CDecl happy_var_1 [(Just happy_var_2, Nothing, Nothing)]}}
	) (\r -> happyReturn (happyIn53 r))

happyReduce_147 = happyMonadReduce 1# 50# happyReduction_147
happyReduction_147 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut46 happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CPtrDeclr (map unL happy_var_1) emptyDeclr}
	) (\r -> happyReturn (happyIn54 r))

happyReduce_148 = happySpecReduce_1 50# happyReduction_148
happyReduction_148 happy_x_1
	 =  case happyOut55 happy_x_1 of { happy_var_1 -> 
	happyIn54
		 (happy_var_1
	)}

happyReduce_149 = happyMonadReduce 2# 50# happyReduction_149
happyReduction_149 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut55 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CPtrDeclr (map unL happy_var_1) happy_var_2}}
	) (\r -> happyReturn (happyIn54 r))

happyReduce_150 = happySpecReduce_3 51# happyReduction_150
happyReduction_150 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_2 of { happy_var_2 -> 
	happyIn55
		 (happy_var_2
	)}

happyReduce_151 = happyMonadReduce 2# 51# happyReduction_151
happyReduction_151 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CArrDeclr emptyDeclr  Nothing}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_152 = happyMonadReduce 3# 51# happyReduction_152
happyReduction_152 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut77 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CArrDeclr emptyDeclr (Just happy_var_2)}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_153 = happyMonadReduce 3# 51# happyReduction_153
happyReduction_153 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut55 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_2 $ CArrDeclr happy_var_1  Nothing}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_154 = happyMonadReduce 4# 51# happyReduction_154
happyReduction_154 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut55 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut77 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CArrDeclr happy_var_1 (Just happy_var_3)}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_155 = happyMonadReduce 3# 51# happyReduction_155
happyReduction_155 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut48 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ case happy_var_2 of
	                    (parms, variadic) ->
			      CFunDeclr emptyDeclr parms variadic}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_156 = happyMonadReduce 4# 51# happyReduction_156
happyReduction_156 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut55 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut48 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ case happy_var_3 of (parms, variadic) -> CFunDeclr happy_var_1 parms variadic}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_157 = happyMonadReduce 1# 52# happyReduction_157
happyReduction_157 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { (CTokIdent  _ happy_var_1) -> 
	 withAttrs happy_var_1 $ CVar happy_var_1}
	) (\r -> happyReturn (happyIn56 r))

happyReduce_158 = happyMonadReduce 1# 52# happyReduction_158
happyReduction_158 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut78 happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CConst happy_var_1}
	) (\r -> happyReturn (happyIn56 r))

happyReduce_159 = happySpecReduce_3 52# happyReduction_159
happyReduction_159 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut75 happy_x_2 of { happy_var_2 -> 
	happyIn56
		 (happy_var_2
	)}

happyReduce_160 = happySpecReduce_1 53# happyReduction_160
happyReduction_160 happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	happyIn57
		 (happy_var_1
	)}

happyReduce_161 = happyMonadReduce 4# 53# happyReduction_161
happyReduction_161 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CIndex happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn57 r))

happyReduce_162 = happyMonadReduce 3# 53# happyReduction_162
happyReduction_162 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_2 $ CCall happy_var_1 []}}
	) (\r -> happyReturn (happyIn57 r))

happyReduce_163 = happyMonadReduce 4# 53# happyReduction_163
happyReduction_163 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CCall happy_var_1 (reverse happy_var_3)}}}
	) (\r -> happyReturn (happyIn57 r))

happyReduce_164 = happyMonadReduce 3# 53# happyReduction_164
happyReduction_164 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (CTokIdent  _ happy_var_3) -> 
	 withAttrs happy_var_2 $ CMember happy_var_1 happy_var_3 False}}}
	) (\r -> happyReturn (happyIn57 r))

happyReduce_165 = happyMonadReduce 3# 53# happyReduction_165
happyReduction_165 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (CTokIdent  _ happy_var_3) -> 
	 withAttrs happy_var_2 $ CMember happy_var_1 happy_var_3 True}}}
	) (\r -> happyReturn (happyIn57 r))

happyReduce_166 = happyMonadReduce 2# 53# happyReduction_166
happyReduction_166 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_2 $ CUnary CPostIncOp happy_var_1}}
	) (\r -> happyReturn (happyIn57 r))

happyReduce_167 = happyMonadReduce 2# 53# happyReduction_167
happyReduction_167 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_2 $ CUnary CPostDecOp happy_var_1}}
	) (\r -> happyReturn (happyIn57 r))

happyReduce_168 = happySpecReduce_1 54# happyReduction_168
happyReduction_168 happy_x_1
	 =  case happyOut73 happy_x_1 of { happy_var_1 -> 
	happyIn58
		 ([happy_var_1]
	)}

happyReduce_169 = happySpecReduce_3 54# happyReduction_169
happyReduction_169 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut58 happy_x_1 of { happy_var_1 -> 
	case happyOut73 happy_x_3 of { happy_var_3 -> 
	happyIn58
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_170 = happySpecReduce_1 55# happyReduction_170
happyReduction_170 happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	happyIn59
		 (happy_var_1
	)}

happyReduce_171 = happyMonadReduce 2# 55# happyReduction_171
happyReduction_171 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut59 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CUnary CPreIncOp happy_var_2}}
	) (\r -> happyReturn (happyIn59 r))

happyReduce_172 = happyMonadReduce 2# 55# happyReduction_172
happyReduction_172 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut59 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CUnary CPreDecOp happy_var_2}}
	) (\r -> happyReturn (happyIn59 r))

happyReduce_173 = happyMonadReduce 2# 55# happyReduction_173
happyReduction_173 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut60 happy_x_1 of { happy_var_1 -> 
	case happyOut61 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CUnary (unL happy_var_1) happy_var_2}}
	) (\r -> happyReturn (happyIn59 r))

happyReduce_174 = happyMonadReduce 2# 55# happyReduction_174
happyReduction_174 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut59 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CSizeofExpr happy_var_2}}
	) (\r -> happyReturn (happyIn59 r))

happyReduce_175 = happyMonadReduce 4# 55# happyReduction_175
happyReduction_175 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut53 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_1 $ CSizeofType happy_var_3}}
	) (\r -> happyReturn (happyIn59 r))

happyReduce_176 = happyMonadReduce 2# 55# happyReduction_176
happyReduction_176 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut59 happy_x_2 of { happy_var_2 -> 
	 withAttrs happy_var_1 $ CAlignofExpr happy_var_2}}
	) (\r -> happyReturn (happyIn59 r))

happyReduce_177 = happyMonadReduce 4# 55# happyReduction_177
happyReduction_177 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut53 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_1 $ CAlignofType happy_var_3}}
	) (\r -> happyReturn (happyIn59 r))

happyReduce_178 = happySpecReduce_1 56# happyReduction_178
happyReduction_178 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn60
		 (L CAdrOp (posOf happy_var_1)
	)}

happyReduce_179 = happySpecReduce_1 56# happyReduction_179
happyReduction_179 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn60
		 (L CIndOp (posOf happy_var_1)
	)}

happyReduce_180 = happySpecReduce_1 56# happyReduction_180
happyReduction_180 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn60
		 (L CPlusOp (posOf happy_var_1)
	)}

happyReduce_181 = happySpecReduce_1 56# happyReduction_181
happyReduction_181 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn60
		 (L CMinOp (posOf happy_var_1)
	)}

happyReduce_182 = happySpecReduce_1 56# happyReduction_182
happyReduction_182 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn60
		 (L CCompOp (posOf happy_var_1)
	)}

happyReduce_183 = happySpecReduce_1 56# happyReduction_183
happyReduction_183 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn60
		 (L CNegOp (posOf happy_var_1)
	)}

happyReduce_184 = happySpecReduce_1 57# happyReduction_184
happyReduction_184 happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	happyIn61
		 (happy_var_1
	)}

happyReduce_185 = happyMonadReduce 4# 57# happyReduction_185
happyReduction_185 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut53 happy_x_2 of { happy_var_2 -> 
	case happyOut61 happy_x_4 of { happy_var_4 -> 
	 withAttrs happy_var_1 $ CCast happy_var_2 happy_var_4}}}
	) (\r -> happyReturn (happyIn61 r))

happyReduce_186 = happySpecReduce_1 58# happyReduction_186
happyReduction_186 happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	happyIn62
		 (happy_var_1
	)}

happyReduce_187 = happyMonadReduce 3# 58# happyReduction_187
happyReduction_187 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut62 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut61 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CMulOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn62 r))

happyReduce_188 = happyMonadReduce 3# 58# happyReduction_188
happyReduction_188 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut62 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut61 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CDivOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn62 r))

happyReduce_189 = happyMonadReduce 3# 58# happyReduction_189
happyReduction_189 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut62 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut61 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CRmdOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn62 r))

happyReduce_190 = happySpecReduce_1 59# happyReduction_190
happyReduction_190 happy_x_1
	 =  case happyOut62 happy_x_1 of { happy_var_1 -> 
	happyIn63
		 (happy_var_1
	)}

happyReduce_191 = happyMonadReduce 3# 59# happyReduction_191
happyReduction_191 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut63 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut62 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CAddOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn63 r))

happyReduce_192 = happyMonadReduce 3# 59# happyReduction_192
happyReduction_192 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut63 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut62 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CSubOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn63 r))

happyReduce_193 = happySpecReduce_1 60# happyReduction_193
happyReduction_193 happy_x_1
	 =  case happyOut63 happy_x_1 of { happy_var_1 -> 
	happyIn64
		 (happy_var_1
	)}

happyReduce_194 = happyMonadReduce 3# 60# happyReduction_194
happyReduction_194 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut64 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut63 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CShlOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn64 r))

happyReduce_195 = happyMonadReduce 3# 60# happyReduction_195
happyReduction_195 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut64 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut63 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CShrOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn64 r))

happyReduce_196 = happySpecReduce_1 61# happyReduction_196
happyReduction_196 happy_x_1
	 =  case happyOut64 happy_x_1 of { happy_var_1 -> 
	happyIn65
		 (happy_var_1
	)}

happyReduce_197 = happyMonadReduce 3# 61# happyReduction_197
happyReduction_197 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut65 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut64 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CLeOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_198 = happyMonadReduce 3# 61# happyReduction_198
happyReduction_198 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut65 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut64 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CGrOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_199 = happyMonadReduce 3# 61# happyReduction_199
happyReduction_199 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut65 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut64 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CLeqOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_200 = happyMonadReduce 3# 61# happyReduction_200
happyReduction_200 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut65 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut64 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CGeqOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_201 = happySpecReduce_1 62# happyReduction_201
happyReduction_201 happy_x_1
	 =  case happyOut65 happy_x_1 of { happy_var_1 -> 
	happyIn66
		 (happy_var_1
	)}

happyReduce_202 = happyMonadReduce 3# 62# happyReduction_202
happyReduction_202 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut65 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CEqOp  happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn66 r))

happyReduce_203 = happyMonadReduce 3# 62# happyReduction_203
happyReduction_203 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut65 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CNeqOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn66 r))

happyReduce_204 = happySpecReduce_1 63# happyReduction_204
happyReduction_204 happy_x_1
	 =  case happyOut66 happy_x_1 of { happy_var_1 -> 
	happyIn67
		 (happy_var_1
	)}

happyReduce_205 = happyMonadReduce 3# 63# happyReduction_205
happyReduction_205 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut67 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CAndOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn67 r))

happyReduce_206 = happySpecReduce_1 64# happyReduction_206
happyReduction_206 happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	happyIn68
		 (happy_var_1
	)}

happyReduce_207 = happyMonadReduce 3# 64# happyReduction_207
happyReduction_207 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut68 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut67 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CXorOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn68 r))

happyReduce_208 = happySpecReduce_1 65# happyReduction_208
happyReduction_208 happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	happyIn69
		 (happy_var_1
	)}

happyReduce_209 = happyMonadReduce 3# 65# happyReduction_209
happyReduction_209 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut69 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut68 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary COrOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn69 r))

happyReduce_210 = happySpecReduce_1 66# happyReduction_210
happyReduction_210 happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	happyIn70
		 (happy_var_1
	)}

happyReduce_211 = happyMonadReduce 3# 66# happyReduction_211
happyReduction_211 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut69 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CLndOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn70 r))

happyReduce_212 = happySpecReduce_1 67# happyReduction_212
happyReduction_212 happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 (happy_var_1
	)}

happyReduce_213 = happyMonadReduce 3# 67# happyReduction_213
happyReduction_213 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut71 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CBinary CLorOp happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn71 r))

happyReduce_214 = happySpecReduce_1 68# happyReduction_214
happyReduction_214 happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn72
		 (happy_var_1
	)}

happyReduce_215 = happyMonadReduce 5# 68# happyReduction_215
happyReduction_215 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut71 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	case happyOut72 happy_x_5 of { happy_var_5 -> 
	 withAttrs happy_var_2 $ CCond happy_var_1 happy_var_3 happy_var_5}}}}
	) (\r -> happyReturn (happyIn72 r))

happyReduce_216 = happySpecReduce_1 69# happyReduction_216
happyReduction_216 happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	happyIn73
		 (happy_var_1
	)}

happyReduce_217 = happyMonadReduce 3# 69# happyReduction_217
happyReduction_217 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut74 happy_x_2 of { happy_var_2 -> 
	case happyOut73 happy_x_3 of { happy_var_3 -> 
	 withAttrs happy_var_2 $ CAssign (unL happy_var_2) happy_var_1 happy_var_3}}}
	) (\r -> happyReturn (happyIn73 r))

happyReduce_218 = happySpecReduce_1 70# happyReduction_218
happyReduction_218 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (L CAssignOp (posOf happy_var_1)
	)}

happyReduce_219 = happySpecReduce_1 70# happyReduction_219
happyReduction_219 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (L CMulAssOp (posOf happy_var_1)
	)}

happyReduce_220 = happySpecReduce_1 70# happyReduction_220
happyReduction_220 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (L CDivAssOp (posOf happy_var_1)
	)}

happyReduce_221 = happySpecReduce_1 70# happyReduction_221
happyReduction_221 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (L CRmdAssOp (posOf happy_var_1)
	)}

happyReduce_222 = happySpecReduce_1 70# happyReduction_222
happyReduction_222 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (L CAddAssOp (posOf happy_var_1)
	)}

happyReduce_223 = happySpecReduce_1 70# happyReduction_223
happyReduction_223 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (L CSubAssOp (posOf happy_var_1)
	)}

happyReduce_224 = happySpecReduce_1 70# happyReduction_224
happyReduction_224 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (L CShlAssOp (posOf happy_var_1)
	)}

happyReduce_225 = happySpecReduce_1 70# happyReduction_225
happyReduction_225 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (L CShrAssOp (posOf happy_var_1)
	)}

happyReduce_226 = happySpecReduce_1 70# happyReduction_226
happyReduction_226 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (L CAndAssOp (posOf happy_var_1)
	)}

happyReduce_227 = happySpecReduce_1 70# happyReduction_227
happyReduction_227 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (L CXorAssOp (posOf happy_var_1)
	)}

happyReduce_228 = happySpecReduce_1 70# happyReduction_228
happyReduction_228 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn74
		 (L COrAssOp  (posOf happy_var_1)
	)}

happyReduce_229 = happyMonadReduce 1# 71# happyReduction_229
happyReduction_229 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut76 happy_x_1 of { happy_var_1 -> 
	 case happy_var_1 of
					   [e] -> return e
					   _   -> let es = reverse happy_var_1 
					          in withAttrs es $ CComma es}
	) (\r -> happyReturn (happyIn75 r))

happyReduce_230 = happySpecReduce_1 72# happyReduction_230
happyReduction_230 happy_x_1
	 =  case happyOut73 happy_x_1 of { happy_var_1 -> 
	happyIn76
		 ([happy_var_1]
	)}

happyReduce_231 = happySpecReduce_3 72# happyReduction_231
happyReduction_231 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	case happyOut73 happy_x_3 of { happy_var_3 -> 
	happyIn76
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_232 = happySpecReduce_1 73# happyReduction_232
happyReduction_232 happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 (happy_var_1
	)}

happyReduce_233 = happyMonadReduce 1# 74# happyReduction_233
happyReduction_233 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ case happy_var_1 of CTokILit _ i -> CIntConst i}
	) (\r -> happyReturn (happyIn78 r))

happyReduce_234 = happyMonadReduce 1# 74# happyReduction_234
happyReduction_234 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ case happy_var_1 of CTokCLit _ c -> CCharConst c}
	) (\r -> happyReturn (happyIn78 r))

happyReduce_235 = happyMonadReduce 1# 74# happyReduction_235
happyReduction_235 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOutTok happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ case happy_var_1 of CTokFLit _ f -> CFloatConst f}
	) (\r -> happyReturn (happyIn78 r))

happyReduce_236 = happyMonadReduce 1# 74# happyReduction_236
happyReduction_236 (happy_x_1 `HappyStk`
	happyRest)
	 = happyThen (case happyOut79 happy_x_1 of { happy_var_1 -> 
	 withAttrs happy_var_1 $ CStrConst (unL happy_var_1)}
	) (\r -> happyReturn (happyIn78 r))

happyReduce_237 = happySpecReduce_1 75# happyReduction_237
happyReduction_237 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn79
		 (case happy_var_1 of CTokSLit _ s -> L s (posOf happy_var_1)
	)}

happyReduce_238 = happySpecReduce_2 75# happyReduction_238
happyReduction_238 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	happyIn79
		 (case happy_var_1 of CTokSLit _ s ->
                                       let s' = concat (s : reverse happy_var_2)
				        in L s' (posOf happy_var_1)
	)}}

happyReduce_239 = happySpecReduce_1 76# happyReduction_239
happyReduction_239 happy_x_1
	 =  case happyOutTok happy_x_1 of { happy_var_1 -> 
	happyIn80
		 (case happy_var_1 of CTokSLit _ s -> [s]
	)}

happyReduce_240 = happySpecReduce_2 76# happyReduction_240
happyReduction_240 happy_x_2
	happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { happy_var_2 -> 
	happyIn80
		 (case happy_var_2 of CTokSLit _ s -> s : happy_var_1
	)}}

happyReduce_241 = happySpecReduce_0 77# happyReduction_241
happyReduction_241  =  happyIn81
		 (()
	)

happyReduce_242 = happySpecReduce_1 77# happyReduction_242
happyReduction_242 happy_x_1
	 =  happyIn81
		 (()
	)

happyReduce_243 = happySpecReduce_0 78# happyReduction_243
happyReduction_243  =  happyIn82
		 (()
	)

happyReduce_244 = happySpecReduce_2 78# happyReduction_244
happyReduction_244 happy_x_2
	happy_x_1
	 =  happyIn82
		 (()
	)

happyReduce_245 = happySpecReduce_1 79# happyReduction_245
happyReduction_245 happy_x_1
	 =  happyIn83
		 (()
	)

happyReduce_246 = happySpecReduce_2 79# happyReduction_246
happyReduction_246 happy_x_2
	happy_x_1
	 =  happyIn83
		 (()
	)

happyReduce_247 = happyReduce 6# 80# happyReduction_247
happyReduction_247 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyIn84
		 (()
	) `HappyStk` happyRest

happyReduce_248 = happySpecReduce_1 81# happyReduction_248
happyReduction_248 happy_x_1
	 =  happyIn85
		 (()
	)

happyReduce_249 = happySpecReduce_3 81# happyReduction_249
happyReduction_249 happy_x_3
	happy_x_2
	happy_x_1
	 =  happyIn85
		 (()
	)

happyReduce_250 = happySpecReduce_0 82# happyReduction_250
happyReduction_250  =  happyIn86
		 (()
	)

happyReduce_251 = happySpecReduce_1 82# happyReduction_251
happyReduction_251 happy_x_1
	 =  happyIn86
		 (()
	)

happyReduce_252 = happySpecReduce_1 82# happyReduction_252
happyReduction_252 happy_x_1
	 =  happyIn86
		 (()
	)

happyReduce_253 = happyReduce 4# 82# happyReduction_253
happyReduction_253 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = happyIn86
		 (()
	) `HappyStk` happyRest

happyReduce_254 = happySpecReduce_3 82# happyReduction_254
happyReduction_254 happy_x_3
	happy_x_2
	happy_x_1
	 =  happyIn86
		 (()
	)

happyReduce_255 = happySpecReduce_1 83# happyReduction_255
happyReduction_255 happy_x_1
	 =  happyIn87
		 (()
	)

happyReduce_256 = happySpecReduce_3 83# happyReduction_256
happyReduction_256 happy_x_3
	happy_x_2
	happy_x_1
	 =  happyIn87
		 (()
	)

happyNewToken action sts stk
	= lexC(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	CTokEof -> happyDoAction 91# (error "reading EOF!") action sts stk;
	CTokLParen	_ -> cont 1#;
	CTokRParen	_ -> cont 2#;
	CTokLBracket	_ -> cont 3#;
	CTokRBracket	_ -> cont 4#;
	CTokArrow	_ -> cont 5#;
	CTokDot	_ -> cont 6#;
	CTokExclam	_ -> cont 7#;
	CTokTilde	_ -> cont 8#;
	CTokInc	_ -> cont 9#;
	CTokDec	_ -> cont 10#;
	CTokPlus	_ -> cont 11#;
	CTokMinus	_ -> cont 12#;
	CTokStar	_ -> cont 13#;
	CTokSlash	_ -> cont 14#;
	CTokPercent	_ -> cont 15#;
	CTokAmper	_ -> cont 16#;
	CTokShiftL	_ -> cont 17#;
	CTokShiftR	_ -> cont 18#;
	CTokLess	_ -> cont 19#;
	CTokLessEq	_ -> cont 20#;
	CTokHigh	_ -> cont 21#;
	CTokHighEq	_ -> cont 22#;
	CTokEqual	_ -> cont 23#;
	CTokUnequal	_ -> cont 24#;
	CTokHat	_ -> cont 25#;
	CTokBar	_ -> cont 26#;
	CTokAnd	_ -> cont 27#;
	CTokOr	_ -> cont 28#;
	CTokQuest	_ -> cont 29#;
	CTokColon	_ -> cont 30#;
	CTokAssign	_ -> cont 31#;
	CTokPlusAss	_ -> cont 32#;
	CTokMinusAss	_ -> cont 33#;
	CTokStarAss	_ -> cont 34#;
	CTokSlashAss	_ -> cont 35#;
	CTokPercAss	_ -> cont 36#;
	CTokAmpAss	_ -> cont 37#;
	CTokHatAss	_ -> cont 38#;
	CTokBarAss	_ -> cont 39#;
	CTokSLAss	_ -> cont 40#;
	CTokSRAss	_ -> cont 41#;
	CTokComma	_ -> cont 42#;
	CTokSemic	_ -> cont 43#;
	CTokLBrace	_ -> cont 44#;
	CTokRBrace	_ -> cont 45#;
	CTokEllipsis	_ -> cont 46#;
	CTokAlignof	_ -> cont 47#;
	CTokAsm	_ -> cont 48#;
	CTokAuto	_ -> cont 49#;
	CTokBreak	_ -> cont 50#;
	CTokCase	_ -> cont 51#;
	CTokChar	_ -> cont 52#;
	CTokConst	_ -> cont 53#;
	CTokContinue	_ -> cont 54#;
	CTokDefault	_ -> cont 55#;
	CTokDo	_ -> cont 56#;
	CTokDouble	_ -> cont 57#;
	CTokElse	_ -> cont 58#;
	CTokEnum	_ -> cont 59#;
	CTokExtern	_ -> cont 60#;
	CTokFloat	_ -> cont 61#;
	CTokFor	_ -> cont 62#;
	CTokGoto	_ -> cont 63#;
	CTokIf	_ -> cont 64#;
	CTokInline	_ -> cont 65#;
	CTokInt	_ -> cont 66#;
	CTokLong	_ -> cont 67#;
	CTokRegister	_ -> cont 68#;
	CTokRestrict	_ -> cont 69#;
	CTokReturn	_ -> cont 70#;
	CTokShort	_ -> cont 71#;
	CTokSigned	_ -> cont 72#;
	CTokSizeof	_ -> cont 73#;
	CTokStatic	_ -> cont 74#;
	CTokStruct	_ -> cont 75#;
	CTokSwitch	_ -> cont 76#;
	CTokTypedef	_ -> cont 77#;
	CTokUnion	_ -> cont 78#;
	CTokUnsigned	_ -> cont 79#;
	CTokVoid	_ -> cont 80#;
	CTokVolatile	_ -> cont 81#;
	CTokWhile	_ -> cont 82#;
	CTokCLit   _ _ -> cont 83#;
	CTokILit   _ _ -> cont 84#;
	CTokFLit   _ _ -> cont 85#;
	CTokSLit   _ _ -> cont 86#;
	CTokIdent  _ happy_dollar_dollar -> cont 87#;
	CTokTyIdent _ happy_dollar_dollar -> cont 88#;
	CTokGnuC GnuCAttrTok _ -> cont 89#;
	CTokGnuC GnuCExtTok  _ -> cont 90#;
	_ -> happyError'
	})

happyError_ tk = happyError'

happyThen :: () => P a -> (a -> P b) -> P b
happyThen = (>>=)
happyReturn :: () => a -> P a
happyReturn = (return)
happyThen1 = happyThen
happyReturn1 :: () => a -> P a
happyReturn1 = happyReturn
happyError' :: () => P a
happyError' = happyError

parseCHeader = happySomeParser where
  happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut4 x))

happySeq = happyDontSeq

data Located a = L !a !Position

unL :: Located a -> a
unL (L a pos) = a

instance Pos (Located a) where
  posOf (L _ pos) = pos

{-# INLINE withAttrs #-}
withAttrs :: Pos node => node -> (Attrs -> a) -> P a
withAttrs node mkAttributedNode = do
  name <- getNewName
  let attrs = newAttrs (posOf node) name
  attrs `seq` return (mkAttributedNode attrs)

-- convenient instance, the position of a list of things is the position of
-- the first thing in the list
--
instance Pos a => Pos [a] where
  posOf (x:_) = posOf x

emptyDeclr = CVarDeclr Nothing (newAttrsOnlyPos nopos)

-- extract all identifiers turned into `typedef-name's
--
isTypeDef :: [CDeclSpec] -> Bool
isTypeDef specs = (not . null) [()| CStorageSpec (CTypedef _) <- specs]

getTypeDefIdents :: [CDeclr] -> [Ident]
getTypeDefIdents declrs = catMaybes [declrToOptIdent declr | declr <- declrs]
  where
    declrToOptIdent :: CDeclr -> Maybe Ident
    declrToOptIdent (CVarDeclr optIde    _) = optIde
    declrToOptIdent (CPtrDeclr _ declr   _) = declrToOptIdent declr
    declrToOptIdent (CArrDeclr declr _   _) = declrToOptIdent declr
    declrToOptIdent (CFunDeclr declr _ _ _) = declrToOptIdent declr

happyError :: P a
happyError = parseError

parseC :: String -> Position -> CST s CHeader
parseC input initialPosition  = do
  nameSupply <- getNameSupply
  let (n:ns) = names nameSupply
      at     = newAttrs initialPosition n
  case execParser parseCHeader input
                  initialPosition (map fst builtinTypeNames) ns of
    Left header -> return (header at)
    Right (message, position) -> raiseFatal "Error in C header file."
                                            position message
{-# LINE 1 "GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 1 "<command line>" #-}
{-# LINE 1 "GenericTemplate.hs" #-}
-- $Id$

{-# LINE 28 "GenericTemplate.hs" #-}


data Happy_IntList = HappyCons Int# Happy_IntList





{-# LINE 49 "GenericTemplate.hs" #-}

{-# LINE 59 "GenericTemplate.hs" #-}

{-# LINE 68 "GenericTemplate.hs" #-}

infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
	happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
	(happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
	= {- nothing -}


	  case action of
		0#		  -> {- nothing -}
				     happyFail i tk st
		-1# 	  -> {- nothing -}
				     happyAccept i tk st
		n | (n <# (0# :: Int#)) -> {- nothing -}

				     (happyReduceArr ! rule) i tk st
				     where rule = (I# ((negateInt# ((n +# (1# :: Int#))))))
		n		  -> {- nothing -}


				     happyShift new_state i tk st
				     where new_state = (n -# (1# :: Int#))
   where off    = indexShortOffAddr happyActOffsets st
	 off_i  = (off +# i)
	 check  = if (off_i >=# (0# :: Int#))
			then (indexShortOffAddr happyCheck off_i ==#  i)
			else False
 	 action | check     = indexShortOffAddr happyTable off_i
		| otherwise = indexShortOffAddr happyDefActions st

{-# LINE 127 "GenericTemplate.hs" #-}


indexShortOffAddr (HappyA# arr) off =
#if __GLASGOW_HASKELL__ > 500
	narrow16Int# i
#elif __GLASGOW_HASKELL__ == 500
	intToInt16# i
#else
	(i `iShiftL#` 16#) `iShiftRA#` 16#
#endif
  where
#if __GLASGOW_HASKELL__ >= 503
	i = word2Int# ((high `uncheckedShiftL#` 8#) `or#` low)
#else
	i = word2Int# ((high `shiftL#` 8#) `or#` low)
#endif
	high = int2Word# (ord# (indexCharOffAddr# arr (off' +# 1#)))
	low  = int2Word# (ord# (indexCharOffAddr# arr off'))
	off' = off *# 2#





data HappyAddr = HappyA# Addr#




-----------------------------------------------------------------------------
-- HappyState data type (not arrays)

{-# LINE 170 "GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case unsafeCoerce# x of { (I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k -# (1# :: Int#)) sts of
	 sts1@((HappyCons (st1@(action)) (_))) ->
        	let r = fn stk in  -- it doesn't hurt to always seq here...
       		happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
        happyThen1 (fn stk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))
       where sts1@((HappyCons (st1@(action)) (_))) = happyDrop k (HappyCons (st) (sts))
             drop_stk = happyDropStk k stk

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n -# (1# :: Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n -# (1#::Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off    = indexShortOffAddr happyGotoOffsets st
	 off_i  = (off +# nt)
 	 new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail  0# tk old_st _ stk =
--	trace "failing" $ 
    	happyError_ tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
						(saved_tok `HappyStk` _ `HappyStk` stk) =
--	trace ("discarding state, depth " ++ show (length stk))  $
	happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail  i tk (action) sts stk =
--      trace "entering error recovery" $
	happyDoAction 0# tk action sts ( (unsafeCoerce# (I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--	happySeq = happyDoSeq
-- otherwise it emits
-- 	happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.
