/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import java.io.File;
import java.io.IOException;

import org.gnu.glib.Handle;

/**
 *
 * @deprecated This class is part of the java-gnome 2.x family of libraries,
 *             which, due to their inefficiency and complexity, are no longer
 *             being maintained and have been abandoned by the java-gnome
 *             project. This class may exist in java-gnome 4.0; look out for
 *             <code>org.freedesktop.cairo.PDFSurface</code>.
 *             As this package was never correctly implemented in java-gnome 2.x,
 *             any new code written will likely have a considerably different
 *             public API.
 */
public class PDFSurface extends Surface {

    public PDFSurface(String filename, double widthInches, double heightInches)
            throws IOException {
        super(initialize(filename, widthInches, heightInches));
    }

    public void setDPI(double xDPI, double yDPI) {
        cairo_pdf_surface_set_dpi(getHandle(), xDPI, yDPI);
    }

    private static Handle initialize(String filename, double widthInches,
            double heightInches) throws IOException {
        File f = new File(filename);

        if (f.isDirectory())
            throw new IOException(filename + " is a directory");

        if (f.exists()) {
            if (!f.canWrite())
                throw new IOException("cannot write to file: " + filename);
        } else {
            String parent = f.getParent();
            if (null == parent)
                parent = System.getProperty("user.dir");

            File dir = new File(parent);
            if (!dir.exists()) {
                throw new IOException("destination directory doesn't exist: "
                        + filename);
            }
            if (!dir.canWrite())
                throw new IOException("Cannot write to file: " + filename);
        }
        return cairo_pdf_surface_create(filename, widthInches, heightInches);
    }

    /*
     * Native calls
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    native static final private Handle cairo_pdf_surface_create(
            String filename, double width_inches, double height_inches);

    native static final private void cairo_pdf_surface_set_dpi(Handle handle,
            double x, double y);
}
