/*	$calcurse: vars.c,v 1.20 2009-08-01 13:31:21 culot Exp $	*/

/*
 * Calcurse - text-based organizer
 *
 * Copyright (c) 2004-2008 Frederic Culot <frederic@culot.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the
 *        following disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the
 *        following disclaimer in the documentation and/or other
 *        materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Send your feedback or comments to : calcurse@culot.org
 * Calcurse home page : http://culot.org/calcurse
 *
 */

#include <stdlib.h>
#include <string.h>

#include "i18n.h"
#include "calendar.h"
#include "custom.h"
#include "wins.h"
#include "keys.h"
#include "mem.h"
#include "vars.h"

/*
 * variables to store window size
 */
int col = 0, row = 0;

/* variable to tell if the terminal supports color */
unsigned colorize = 0;

/*
 * To tell if curses interface was launched already or not (in that case
 * calcurse is running in command-line mode).
 * This is useful to konw how to display messages on the screen.
 */
ui_mode_e ui_mode = UI_CMDLINE;

/*
 * variables to store calendar names
 */
int days[12] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
char *monthnames[12] = {
  N_("January"),
  N_("February"),
  N_("March"),
  N_("April"),
  N_("May"),
  N_("June"),
  N_("July"),
  N_("August"),
  N_("September"),
  N_("October"),
  N_("November"),
  N_("December")
};

char *daynames[8] = {
  N_("Sun"),
  N_("Mon"),
  N_("Tue"),
  N_("Wed"),
  N_("Thu"),
  N_("Fri"),
  N_("Sat"),
  N_("Sun")
};

/* 
 * variables to store data path names, which are initialized in
 * io_init() 
 */
char path_dir[] = "";
char path_todo[] = "";
char path_apts[] = "";
char path_conf[] = "";
char path_notes[] = "";
char path_keys[] = "";
char path_cpid[] = "";
char path_dpid[] = "";
char path_dmon_log[] = "";

/* Variable to handle pads. */
struct pad_s apad;

/* Variable to store notify-bar settings. */
struct nbar_s nbar;

/* Variable to store daemon configuration. */
struct dmon_conf_s dmon;

/*
 * Variables init 
 */
void
vars_init (conf_t *conf)
{
  char *PATH_VI = "/usr/bin/vi";
  char *PATH_LESS = "/usr/bin/less";
  char *ed, *pg;

  /* Variables for user configuration */
  conf->confirm_quit = 1;
  conf->confirm_delete = 1;
  conf->auto_save = 1;
  conf->periodic_save = 0;
  conf->skip_system_dialogs = 0;
  conf->skip_progress_bar = 0;
  (void)strncpy (conf->output_datefmt, "%D", 3);
  conf->input_datefmt = 1;

  /* Default external editor and pager */
  ed = getenv ("VISUAL");
  if (ed == NULL || ed[0] == '\0')
    ed = getenv ("EDITOR");
  if (ed == NULL || ed[0] == '\0')
    ed = PATH_VI;
  conf->editor = ed;

  pg = getenv ("PAGER");
  if (pg == NULL || pg[0] == '\0')
    pg = PATH_LESS;
  conf->pager = pg;

  wins_set_layout (1);

  calendar_set_first_day_of_week (MONDAY);

  /* Pad structure to scroll text inside the appointment panel */
  apad.length = 1;
  apad.first_onscreen = 0;

  /* Attribute definitions for color and non-color terminals */
  custom_init_attr ();

  /* Start at the current date */
  calendar_init_slctd_day ();
}
