# This library is for generic functions that really do not belong elsewhere

proc alert msg {
	tk_dialog .alert Alert $msg info 0 "So it goes."
}

proc dispatch {cmdList title} {

	set shellCommand ""
	set systype [exec /bin/uname -s]

	switch $systype {
		"SunOS" { set xdir "/usr/openwin/bin" }
		default { set xdir "/usr/X11R6/bin" }
	}

	foreach cmd $cmdList {
		set tmp [join $cmd "' '"]
		append shellCommand "'$tmp'; "
	}

	regsub -all {\'///PIPE///\'} $shellCommand "|" shellCommand

	append shellCommand "echo Done. Press Enter; read"

	puts $shellCommand

	exec $xdir/xterm -geometry 80x6 -title $title -e sh -c $shellCommand &

}

proc pref_load no_msg {
	#This is a clumsy way of doing this, I'll get back to this later on :)
	global cfg home fp
	set home $::env(HOME)
	#jbh
	append home {/.cdrbq/.config}
	if [file exists $home] {
		set loop 1
		set fp [open $home r]
		fconfigure $fp -buffering line
		gets $fp data
		while {$data != ""} {
			foreach {var val} [split $data] { set cfg($var) $val}
			gets $fp data
			incr loop
		}
		close $fp
		if {!$no_msg} {
			tk_messageBox -message "Preferences loaded" -title "CDRBQ"
		}
	}
}


proc pref_save no_msg {
	# This is a clumsy way of doing this, I'll get back to this later on :)
	# I had originally included a lot of filesystem errorchecking, but tcl is clumsy at that so I am leaving it simple.
	global cfg var vlist prefdir preffile
	set preffile $::env(HOME)
	set prefdir $preffile
	#jbh
	append preffile {/.cdrbq/.config}
	append prefdir {/.cdrbq}
	# according to docs mkdir will not affect an existing directory...here's hoping
	file mkdir $prefdir
	set loop 1
	if {![file exists $preffile] || [file writable $preffile]} {
		set fp [open $preffile w]
		fconfigure $fp
		set vlist [array names cfg]
		foreach var $vlist {
			puts $fp "$var $cfg($var)"
		}

		close $fp
		if {!$no_msg} {
			tk_messageBox -message "Preferences Saved" -title "CDRBQ"
		}


	}
}

proc pref_init no_msg {
	#Initialize global variables
	global cfg ds
	set cfg(device) "/dev/sg0"
	set cfg(speed) 32
	set cfg(joliet) 1
	set cfg(rock) "none"
	set cfg(dummy) 1
	set cfg(eject) 1
	set cfg(ds) "mkisofs"
	set cfg(apad) 1
	set cfg(dpad) 0
	set cfg(bootimg) "~/boot.img"
	set cfg(bootcat) "~/boot.cat"
	set cfg(burnfree) 1
	set cfg(dao) 0
	set cfg(fix) 1
	set cfg(ob) 0
	set cfg(cd_mode) "-data"
	set cfg(cdi) 0
	set cfg(multi) 0
	set cfg(all) 0
	set cfg(follow) 0
	set cfg(trans) 0
	set cfg(mmc) ""
	if {!$no_msg} {
		tk_messageBox -message "Defaults loaded" -title "CDRBQ"
	}
}

proc sure msg {
	return [expr ![tk_dialog .alert Confirmation $msg questhead -1 yes no]]
}


proc version {} {
	# Just return the version of this CDRBQ copy.
	# Keeps everything in one place.

	return "1.23"
}

