/* cdw
 * Copyright (C) 2002 Varkonyi Balazs
 * Copyright (C) 2007 - 2011 Kamil Ignacak
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdw_main_window.h"
#include "cdw_widgets.h"
#include "cdw_ncurses.h"
#include "gettext.h"
#include "cdw_help.h"
#include "cdw_debug.h"





/**
   \brief Show window with list of hotkeys available in main application window
*/
void show_help_main(void)
{
	int n_lines = 20;
	int n_cols = 60;
	cdw_assert (LINES > n_lines, "ERROR: LINES is too small: %d\n", LINES);
	cdw_assert (COLS > n_cols, "ERROR: COLS is too small: %d\n", COLS);
	int begin_y = (LINES - n_lines) / 2;
	int begin_x = (COLS - n_cols) / 2;

	int col = 2;

	WINDOW *window = newwin((int) n_lines, (int) n_cols, (int) begin_y, (int) begin_x);
	if (window == (WINDOW *) NULL) {
		cdw_vdm ("ERROR: failed to create window for help panel\n");
		return;
	}

	wbkgd(window, COLOR_PAIR(CDW_COLORS_DIALOG));
	werase(window);
	keypad(window, TRUE);

	box(window, 0, 0);
	/* 2TRANS: this is title of small help window displaying hotkeys */
	cdw_ncurses_nice_box(window, _("Help"),
			     /* 2TRANS: this is message at the bottom of help window */
			     _("Press ESCAPE to close window"));

	mvwprintw(window, 2, col, "%s",
		  /* 2TRANS: this is label explaining content of
		     help window */
		  _("Hotkeys available in main window:"));

	int r = 4;
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label: "show this help window";
		     keep position of '-' */
		  _("F1, H, ?  - Show this help"));
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label: "show window displaying
		     cdw license"; keep position of '-' */
		  _("F10       - Show license of this program"));
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label; keep position of '-' */
		  _("C         - Show Configuration window"));
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label: "show window with some
		     disc meta-data"; keep position of '-' */
		  _("D         - Show information about disc"));
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label: "eject tray of your
		     CD/DVD drive"; keep position of '-' */
		  _("E         - Eject drive tray"));
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label: "burn files that you
		     selected to optical disc"; keep position of '-' */
		  _("F         - Write selected files to disc"));
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label, it means "copy tracks
		     from audio or data CD to your hard disc";
		     keep position of '-' */
		  _("G         - Read content of CD"));
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label: "burn ISO9660 file
		     to optical disc"; keep position of '-' */
		  _("I         - Write ISO image to disc"));
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label: "show window displaying
		     log file of cdw program"; keep position of '-'  */
		  _("L         - Show log file"));
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label: "read some information
		     about disc that is in drive and display it in app
		     window"; keep position of '-' */
		  _("R         - Refresh information about disc"));
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label: "verify data in disc
		     or on optical media */
		  _("V         - Verify data"));
	mvwprintw(window, r++, col, "%s",
		  /* 2TRANS: this is hotkey label, it means
		    "close application"; keep position of '-' */
		  _("Q         - Quit"));

#if 0
	mvwprintw(window, 5, col, "%s",
		  /* 2TRANS: this is hotkey label: "show window, in which
		     user can enter/edit CD label (volume ID)";
		     keep position of '-' */
		  _("F2        - Show disc label window"));
	mvwprintw(window, 6, col, "%s",
		  /* 2TRANS: this is hotkey label: "show window, in which
		     user can edit additional parameters of 'cdrecord'";
		     keep position of '-' */
		  _("F3        - Edit 'cdrecord' parameters"));

	mvwprintw(window, 7, col, "%s",
		  /* 2TRANS: this is hotkey label: "show dialog with
		     selector of size of disc, to which user want to
		     write data;  keep position of '-' */
		  _("F4        - Select target disc size"));

	mvwprintw(window, 10, 2, "%s", _("C   - Disk catalog"));
	mvwprintw(window, 11, 2, "%s", _("A   - Add disk into Disk catalog"));
#endif
	wrefresh(window);

	int key = 'a';
	while (key != CDW_KEY_ESCAPE) {
		key = wgetch(window);
	}

	delwin(window);
	window = (WINDOW *) NULL;

	cdw_main_ui_main_window_wrefresh_part(n_lines, n_cols, begin_y, begin_x);

	return;
}




void show_help_cddb(void)
{
    int c = 0;
    WINDOW *help=newwin(20,60,(LINES-20)/2,(COLS-60)/2);
    wbkgd(help, COLOR_PAIR(CDW_COLORS_DIALOG));
    werase(help);
    box(help,0,0);
    keypad(help, TRUE);
    mvwaddch(help, 0, 2, ACS_RTEE);
    mvwprintw(help, 0, 3, " %s ", _("Help"));
    waddch(help, ACS_LTEE);
    mvwprintw(help, 19, 2, "( %s )", _("Press ESC to close window"));
    mvwprintw(help, 2, 2, "%s", _("->     - Step into catalogized files window"));
    mvwprintw(help, 3, 2, "%s", _("<-     - Step into menu window"));
    mvwprintw(help, 4, 2, "%s", _("ENTER  - Change category or disk or directory"));
    mvwprintw(help, 5, 2, "%s", _("BSPACE"));
    mvwprintw(help, 6, 2, "%s", _("/      - Move one level up"));
    mvwprintw(help, 7, 2, "%s", _("DEL    - Delete category or disk"));
    mvwprintw(help, 8, 2, "%s", _("A      - Add disk into catalog"));
    mvwprintw(help, 9, 2, "%s", _("S      - Show all disks"));
    mvwprintw(help,10, 2, "%s", _("Q      - Quit Disk catalog"));

    wrefresh(help);
    while (c != CDW_KEY_ESCAPE) {
	c=wgetch(help);
    }
    delwin(help);
}





void display_tooltip(int item)
{
	WINDOW *subwindow = cdw_main_ui_get_tooltips_subwindow();
	cdw_assert (subwindow != (WINDOW *) NULL, "ERROR: tooltips subwindow is not initialized yet\n");

	werase(subwindow);
	switch(item) {
		case CDW_MENU_ADD_FILES:
			/* 2TRANS: this is tooltip displayed at the bottom of main cdw window */
			cdw_textarea_print_message(subwindow, _("Select files from hard drive for further processing."), CDW_ALIGN_LEFT);
			break;
		case CDW_MENU_DELETE_FILES:
			/* 2TRANS: this is tooltip displayed at the bottom of main cdw window */
			cdw_textarea_print_message(subwindow, _("Deselect files from list using Delete key."), CDW_ALIGN_LEFT);
			break;
		case CDW_MENU_CREATE_IMAGE:
			/* 2TRANS: this is tooltip displayed at the bottom of main cdw window */
			cdw_textarea_print_message(subwindow, _("Create ISO9660 image from selected files."), CDW_ALIGN_LEFT);
			break;
		case CDW_MENU_RIP_DISC:
			/* 2TRANS: this is tooltip displayed at the bottom of main cdw window */
			cdw_textarea_print_message(subwindow, _("Copy content of optical disc to to your hard drive."), CDW_ALIGN_LEFT);
			break;
		case CDW_MENU_BURN_FILES:
			/* 2TRANS: this is tooltip displayed at the bottom of main cdw window */
			cdw_textarea_print_message(subwindow, _("Write selected files to optical disc."), CDW_ALIGN_LEFT);
			break;
		case CDW_MENU_BURN_IMAGE:
			/* 2TRANS: this is tooltip displayed at the bottom of main cdw window */
			cdw_textarea_print_message(subwindow, _("Write ISO9660 image file to optical disc."), CDW_ALIGN_LEFT);
			break;
		case CDW_MENU_ERASE_DISC:
			/* 2TRANS: this is tooltip displayed at the bottom of main cdw window */
			cdw_textarea_print_message(subwindow, _("Blank CD-RW or DVD+/-RW disc. Reformat DVD-RW disc."), CDW_ALIGN_LEFT);
			break;
	        case CDW_MENU_VERIFY:
			/* 2TRANS: this is tooltip displayed at the bottom of main cdw window */
			cdw_textarea_print_message(subwindow, _("Calculate a digest of a file or data on optical disc."), CDW_ALIGN_LEFT);
			break;
		case CDW_MENU_CONFIG:
			/* 2TRANS: this is tooltip displayed at the bottom of main cdw window */
			cdw_textarea_print_message(subwindow, _("cdw configuration: hardware, external tools and other."), CDW_ALIGN_LEFT);
			break;
		case CDW_MENU_EXIT_CDW:
			/* 2TRANS: this is tooltip displayed at the bottom of main cdw window */
			cdw_textarea_print_message(subwindow, _("Close this program, return to command line session."), CDW_ALIGN_LEFT);
			break;
		default:
			werase(subwindow);
			break;
	}
	wrefresh(subwindow);

	return;
}



