// This file has been generated by Py++.

#include "boost/python.hpp"
#include "python_CEGUI.h"
#include "WidgetLookManager.pypp.hpp"

namespace bp = boost::python;

void register_WidgetLookManager_class(){

    { //::CEGUI::WidgetLookManager
        typedef bp::class_< CEGUI::WidgetLookManager, bp::bases< CEGUI::Singleton< CEGUI::WidgetLookManager > >, boost::noncopyable > WidgetLookManager_exposer_t;
        WidgetLookManager_exposer_t WidgetLookManager_exposer = WidgetLookManager_exposer_t( "WidgetLookManager", "*!\n\
        \n\
            Manager class that gives top-level access to widget data based look and feel specifications\
            loaded into the system.\n\
        *\n", bp::init< >("*!\n\
        \n\
            Constructor.\n\
        *\n") );
        bp::scope WidgetLookManager_scope( WidgetLookManager_exposer );
        { //::CEGUI::WidgetLookManager::addWidgetLook
        
            typedef void ( ::CEGUI::WidgetLookManager::*addWidgetLook_function_type )( ::CEGUI::WidgetLookFeel const & ) ;
            
            WidgetLookManager_exposer.def( 
                "addWidgetLook"
                , addWidgetLook_function_type( &::CEGUI::WidgetLookManager::addWidgetLook )
                , ( bp::arg("look") )
                , "*!\n\
                    \n\
                        Add the given WidgetLookFeel.\n\
            \n\
                    \note\n\
                        If the WidgetLookFeel specification uses a name that already exists within the system,\
                        it is not an error;\n\
                        the previous definition is overwritten by the new data.  An entry will appear in the log\
                        each time any\n\
                        look & feel component is overwritten.\n\
            \n\
                    @param look\n\
                        WidgetLookFeel object to be added to the system.  NB: The WidgetLookFeel is copied, no\
                        change of ownership of the\n\
                        input object occurrs.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::WidgetLookManager::eraseWidgetLook
        
            typedef void ( ::CEGUI::WidgetLookManager::*eraseWidgetLook_function_type )( ::CEGUI::String const & ) ;
            
            WidgetLookManager_exposer.def( 
                "eraseWidgetLook"
                , eraseWidgetLook_function_type( &::CEGUI::WidgetLookManager::eraseWidgetLook )
                , ( bp::arg("widget") )
                , "*!\n\
                    \n\
                        Erase the WidgetLookFeel that has the specified name.\n\
            \n\
                    @param widget\n\
                        String object holding the name of a widget look to be erased.  If no such WidgetLookFeel\
                        exists, nothing\n\
                        happens.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::WidgetLookManager::getDefaultResourceGroup
        
            typedef ::CEGUI::String const & ( *getDefaultResourceGroup_function_type )(  );
            
            WidgetLookManager_exposer.def( 
                "getDefaultResourceGroup"
                , getDefaultResourceGroup_function_type( &::CEGUI::WidgetLookManager::getDefaultResourceGroup )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                    \n\
                        Returns the default resource group currently set for LookNFeels.\n\
            \n\
                    @return\n\
                        String describing the default resource group identifier that will be\n\
                        used when loading LookNFeel data.\n\
                    *\n" );
        
        }
        { //::CEGUI::WidgetLookManager::getSingleton
        
            typedef ::CEGUI::WidgetLookManager & ( *getSingleton_function_type )(  );
            
            WidgetLookManager_exposer.def( 
                "getSingleton"
                , getSingleton_function_type( &::CEGUI::WidgetLookManager::getSingleton )
                , bp::return_value_policy< bp::reference_existing_object >()
                , "*!\n\
                     \n\
                          Return singleton WidgetLookManager object\n\
            \n\
                     @return\n\
                          Singleton WidgetLookManager object\n\
                     *\n" );
        
        }
        { //::CEGUI::WidgetLookManager::getWidgetLook
        
            typedef ::CEGUI::WidgetLookFeel const & ( ::CEGUI::WidgetLookManager::*getWidgetLook_function_type )( ::CEGUI::String const & ) const;
            
            WidgetLookManager_exposer.def( 
                "getWidgetLook"
                , getWidgetLook_function_type( &::CEGUI::WidgetLookManager::getWidgetLook )
                , ( bp::arg("widget") )
                , bp::return_value_policy< bp::copy_const_reference >()
                , "*!\n\
                    \n\
                        Return a const reference to a WidgetLookFeel object which has the specified name.\n\
            \n\
                    @param widget\n\
                        String object holding the name of a widget look that is to be returned.\n\
            \n\
                    @return\n\
                        const reference to the requested WidgetLookFeel object.\n\
            \n\
                    @exception UnknownObjectException   thrown if no WidgetLookFeel is available with the\
                    requested name.\n\
                    *\n" );
        
        }
        { //::CEGUI::WidgetLookManager::isWidgetLookAvailable
        
            typedef bool ( ::CEGUI::WidgetLookManager::*isWidgetLookAvailable_function_type )( ::CEGUI::String const & ) const;
            
            WidgetLookManager_exposer.def( 
                "isWidgetLookAvailable"
                , isWidgetLookAvailable_function_type( &::CEGUI::WidgetLookManager::isWidgetLookAvailable )
                , ( bp::arg("widget") )
                , "*!\n\
                    \n\
                        Return whether a WidgetLookFeel has been created with the specified name.\n\
            \n\
                    @param widget\n\
                        String object holding the name of a widget look to test for.\n\
            \n\
                    @return\n\
                        - true if a WidgetLookFeel named  widget is available.\n\
                        - false if so such WidgetLookFeel is currently available.\n\
                    *\n" );
        
        }
        { //::CEGUI::WidgetLookManager::parseLookNFeelSpecification
        
            typedef void ( ::CEGUI::WidgetLookManager::*parseLookNFeelSpecification_function_type )( ::CEGUI::String const &,::CEGUI::String const & ) ;
            
            WidgetLookManager_exposer.def( 
                "parseLookNFeelSpecification"
                , parseLookNFeelSpecification_function_type( &::CEGUI::WidgetLookManager::parseLookNFeelSpecification )
                , ( bp::arg("filename"), bp::arg("resourceGroup")="" )
                , "*!\n\
                    \n\
                        Parses a file containing window look & feel specifications (in the form of XML).\n\
            \n\
                    \note\n\
                        If the new file contains specifications for widget types that are already specified, it\
                        is not an error;\n\
                        the previous definitions are overwritten by the new data.  An entry will appear in the\
                        log each time any\n\
                        look & feel component is overwritten.\n\
            \n\
                    @param filename\n\
                        String object containing the filename of a file containing the widget look & feel data\n\
            \n\
                    @param resourceGroup\n\
                        Resource group identifier to pass to the resource provider when loading the file.\n\
            \n\
                    @return\n\
                        Nothing.\n\
            \n\
                    @exception   FileIOException            thrown if there was some problem accessing or\
                    parsing the file  filename\n\
                    @exception   InvalidRequestException    thrown if an invalid filename was provided.\n\
                    *\n" );
        
        }
        { //::CEGUI::WidgetLookManager::setDefaultResourceGroup
        
            typedef void ( *setDefaultResourceGroup_function_type )( ::CEGUI::String const & );
            
            WidgetLookManager_exposer.def( 
                "setDefaultResourceGroup"
                , setDefaultResourceGroup_function_type( &::CEGUI::WidgetLookManager::setDefaultResourceGroup )
                , ( bp::arg("resourceGroup") )
                , "*!\n\
                    \n\
                        Sets the default resource group to be used when loading LookNFeel data\n\
            \n\
                    @param resourceGroup\n\
                        String describing the default resource group identifier to be used.\n\
            \n\
                    @return\n\
                        Nothing.\n\
                    *\n" );
        
        }
        { //::CEGUI::WidgetLookManager::writeWidgetLookSeriesToStream
        
            typedef void ( ::CEGUI::WidgetLookManager::*writeWidgetLookSeriesToStream_function_type )( ::CEGUI::String const &,::CEGUI::OutStream & ) const;
            
            WidgetLookManager_exposer.def( 
                "writeWidgetLookSeriesToStream"
                , writeWidgetLookSeriesToStream_function_type( &::CEGUI::WidgetLookManager::writeWidgetLookSeriesToStream )
                , ( bp::arg("prefix"), bp::arg("out_stream") )
                , "*!\n\
                    \n\
                        Writes a series of complete Widge Look objects to a stream.  Note that xml file header\
                        and\n\
                        falagard openingclosing tags will also be written.\n\
            \n\
                        The  prefix specifies a name prefix common to all widget looks to be written, you\
                        could\n\
                        specify this as TaharezLook and then any defined widget look starting with that prefix,\
                        such\n\
                        as TaharezLookButton and TaharezLookListbox will be written to the stream.\n\
            \n\
                    @param prefix\n\
                        String holding the widget look name prefix, which will be used when searching for the\
                        widget looks\n\
                        to be output to the stream.\n\
            \n\
                    @param out_stream\n\
                        OutStream where XML data should be sent.\n\
                    *\n" );
        
        }
        { //::CEGUI::WidgetLookManager::writeWidgetLookToStream
        
            typedef void ( ::CEGUI::WidgetLookManager::*writeWidgetLookToStream_function_type )( ::CEGUI::String const &,::CEGUI::OutStream & ) const;
            
            WidgetLookManager_exposer.def( 
                "writeWidgetLookToStream"
                , writeWidgetLookToStream_function_type( &::CEGUI::WidgetLookManager::writeWidgetLookToStream )
                , ( bp::arg("name"), bp::arg("out_stream") )
                , "*!\n\
                    \n\
                        Writes a complete Widge Look to a stream.  Note that xml file header and\n\
                        falagard openingclosing tags will also be written.\n\
            \n\
                    @param name\n\
                        String holding the name of the widget look to be output to the stream.\n\
            \n\
                    @param out_stream\n\
                        OutStream where XML data should be sent.\n\
                    *\n" );
        
        }
        WidgetLookManager_exposer.staticmethod( "getDefaultResourceGroup" );
        WidgetLookManager_exposer.staticmethod( "getSingleton" );
        WidgetLookManager_exposer.staticmethod( "setDefaultResourceGroup" );
    }

}
