;;; -*- Mode: Lisp; Package: CLIM-INTERNALS -*-

;;;  (c) copyright 1998,1999,2000 by Michael McDonald (mikemac@mikemac.com)

;;; This library is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU Library General Public
;;; License as published by the Free Software Foundation; either
;;; version 2 of the License, or (at your option) any later version.
;;;
;;; This library is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; Library General Public License for more details.
;;;
;;; You should have received a copy of the GNU Library General Public
;;; License along with this library; if not, write to the 
;;; Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
;;; Boston, MA  02111-1307  USA.

(in-package :clim-internals)

; $XConsortium: rgb.txt,v 10.41 94/02/20 18:39:36 rws Exp $
(defconstant +snow+ (make-named-color "snow" 1.0000 0.9804 0.9804))
(defconstant +ghost-white+ (make-named-color "ghost-white" 0.9725 0.9725 1.0000))
(defconstant +GhostWhite+ (make-named-color "GhostWhite" 0.9725 0.9725 1.0000))
(defconstant +white-smoke+ (make-named-color "white-smoke" 0.9608 0.9608 0.9608))
(defconstant +WhiteSmoke+ (make-named-color "WhiteSmoke" 0.9608 0.9608 0.9608))
(defconstant +gainsboro+ (make-named-color "gainsboro" 0.8627 0.8627 0.8627))
(defconstant +floral-white+ (make-named-color "floral-white" 1.0000 0.9804 0.9412))
(defconstant +FloralWhite+ (make-named-color "FloralWhite" 1.0000 0.9804 0.9412))
(defconstant +old-lace+ (make-named-color "old-lace" 0.9922 0.9608 0.9020))
(defconstant +OldLace+ (make-named-color "OldLace" 0.9922 0.9608 0.9020))
(defconstant +linen+ (make-named-color "linen" 0.9804 0.9412 0.9020))
(defconstant +antique-white+ (make-named-color "antique-white" 0.9804 0.9216 0.8431))
(defconstant +AntiqueWhite+ (make-named-color "AntiqueWhite" 0.9804 0.9216 0.8431))
(defconstant +papaya-whip+ (make-named-color "papaya-whip" 1.0000 0.9373 0.8353))
(defconstant +PapayaWhip+ (make-named-color "PapayaWhip" 1.0000 0.9373 0.8353))
(defconstant +blanched-almond+ (make-named-color "blanched-almond" 1.0000 0.9216 0.8039))
(defconstant +BlanchedAlmond+ (make-named-color "BlanchedAlmond" 1.0000 0.9216 0.8039))
(defconstant +bisque+ (make-named-color "bisque" 1.0000 0.8941 0.7686))
(defconstant +peach-puff+ (make-named-color "peach-puff" 1.0000 0.8549 0.7255))
(defconstant +PeachPuff+ (make-named-color "PeachPuff" 1.0000 0.8549 0.7255))
(defconstant +navajo-white+ (make-named-color "navajo-white" 1.0000 0.8706 0.6784))
(defconstant +NavajoWhite+ (make-named-color "NavajoWhite" 1.0000 0.8706 0.6784))
(defconstant +moccasin+ (make-named-color "moccasin" 1.0000 0.8941 0.7098))
(defconstant +cornsilk+ (make-named-color "cornsilk" 1.0000 0.9725 0.8627))
(defconstant +ivory+ (make-named-color "ivory" 1.0000 1.0000 0.9412))
(defconstant +lemon-chiffon+ (make-named-color "lemon-chiffon" 1.0000 0.9804 0.8039))
(defconstant +LemonChiffon+ (make-named-color "LemonChiffon" 1.0000 0.9804 0.8039))
(defconstant +seashell+ (make-named-color "seashell" 1.0000 0.9608 0.9333))
(defconstant +honeydew+ (make-named-color "honeydew" 0.9412 1.0000 0.9412))
(defconstant +mint-cream+ (make-named-color "mint-cream" 0.9608 1.0000 0.9804))
(defconstant +MintCream+ (make-named-color "MintCream" 0.9608 1.0000 0.9804))
(defconstant +azure+ (make-named-color "azure" 0.9412 1.0000 1.0000))
(defconstant +alice-blue+ (make-named-color "alice-blue" 0.9412 0.9725 1.0000))
(defconstant +AliceBlue+ (make-named-color "AliceBlue" 0.9412 0.9725 1.0000))
(defconstant +lavender+ (make-named-color "lavender" 0.9020 0.9020 0.9804))
(defconstant +lavender-blush+ (make-named-color "lavender-blush" 1.0000 0.9412 0.9608))
(defconstant +LavenderBlush+ (make-named-color "LavenderBlush" 1.0000 0.9412 0.9608))
(defconstant +misty-rose+ (make-named-color "misty-rose" 1.0000 0.8941 0.8824))
(defconstant +MistyRose+ (make-named-color "MistyRose" 1.0000 0.8941 0.8824))
(defconstant +white+ (make-named-color "white" 1.0000 1.0000 1.0000))
(defconstant +black+ (make-named-color "black" 0.0000 0.0000 0.0000))
(defconstant +dark-slate-gray+ (make-named-color "dark-slate-gray" 0.1843 0.3098 0.3098))
(defconstant +DarkSlateGray+ (make-named-color "DarkSlateGray" 0.1843 0.3098 0.3098))
(defconstant +dark-slate-grey+ (make-named-color "dark-slate-grey" 0.1843 0.3098 0.3098))
(defconstant +DarkSlateGrey+ (make-named-color "DarkSlateGrey" 0.1843 0.3098 0.3098))
(defconstant +dim-gray+ (make-named-color "dim-gray" 0.4118 0.4118 0.4118))
(defconstant +DimGray+ (make-named-color "DimGray" 0.4118 0.4118 0.4118))
(defconstant +dim-grey+ (make-named-color "dim-grey" 0.4118 0.4118 0.4118))
(defconstant +DimGrey+ (make-named-color "DimGrey" 0.4118 0.4118 0.4118))
(defconstant +slate-gray+ (make-named-color "slate-gray" 0.4392 0.5020 0.5647))
(defconstant +SlateGray+ (make-named-color "SlateGray" 0.4392 0.5020 0.5647))
(defconstant +slate-grey+ (make-named-color "slate-grey" 0.4392 0.5020 0.5647))
(defconstant +SlateGrey+ (make-named-color "SlateGrey" 0.4392 0.5020 0.5647))
(defconstant +light-slate-gray+ (make-named-color "light-slate-gray" 0.4667 0.5333 0.6000))
(defconstant +LightSlateGray+ (make-named-color "LightSlateGray" 0.4667 0.5333 0.6000))
(defconstant +light-slate-grey+ (make-named-color "light-slate-grey" 0.4667 0.5333 0.6000))
(defconstant +LightSlateGrey+ (make-named-color "LightSlateGrey" 0.4667 0.5333 0.6000))
(defconstant +gray+ (make-named-color "gray" 0.7451 0.7451 0.7451))
(defconstant +grey+ (make-named-color "grey" 0.7451 0.7451 0.7451))
(defconstant +light-grey+ (make-named-color "light-grey" 0.8275 0.8275 0.8275))
(defconstant +LightGrey+ (make-named-color "LightGrey" 0.8275 0.8275 0.8275))
(defconstant +light-gray+ (make-named-color "light-gray" 0.8275 0.8275 0.8275))
(defconstant +LightGray+ (make-named-color "LightGray" 0.8275 0.8275 0.8275))
(defconstant +midnight-blue+ (make-named-color "midnight-blue" 0.0980 0.0980 0.4392))
(defconstant +MidnightBlue+ (make-named-color "MidnightBlue" 0.0980 0.0980 0.4392))
(defconstant +navy+ (make-named-color "navy" 0.0000 0.0000 0.5020))
(defconstant +navy-blue+ (make-named-color "navy-blue" 0.0000 0.0000 0.5020))
(defconstant +NavyBlue+ (make-named-color "NavyBlue" 0.0000 0.0000 0.5020))
(defconstant +cornflower-blue+ (make-named-color "cornflower-blue" 0.3922 0.5843 0.9294))
(defconstant +CornflowerBlue+ (make-named-color "CornflowerBlue" 0.3922 0.5843 0.9294))
(defconstant +dark-slate-blue+ (make-named-color "dark-slate-blue" 0.2824 0.2392 0.5451))
(defconstant +DarkSlateBlue+ (make-named-color "DarkSlateBlue" 0.2824 0.2392 0.5451))
(defconstant +slate-blue+ (make-named-color "slate-blue" 0.4157 0.3529 0.8039))
(defconstant +SlateBlue+ (make-named-color "SlateBlue" 0.4157 0.3529 0.8039))
(defconstant +medium-slate-blue+ (make-named-color "medium-slate-blue" 0.4824 0.4078 0.9333))
(defconstant +MediumSlateBlue+ (make-named-color "MediumSlateBlue" 0.4824 0.4078 0.9333))
(defconstant +light-slate-blue+ (make-named-color "light-slate-blue" 0.5176 0.4392 1.0000))
(defconstant +LightSlateBlue+ (make-named-color "LightSlateBlue" 0.5176 0.4392 1.0000))
(defconstant +medium-blue+ (make-named-color "medium-blue" 0.0000 0.0000 0.8039))
(defconstant +MediumBlue+ (make-named-color "MediumBlue" 0.0000 0.0000 0.8039))
(defconstant +royal-blue+ (make-named-color "royal-blue" 0.2549 0.4118 0.8824))
(defconstant +RoyalBlue+ (make-named-color "RoyalBlue" 0.2549 0.4118 0.8824))
(defconstant +blue+ (make-named-color "blue" 0.0000 0.0000 1.0000))
(defconstant +dodger-blue+ (make-named-color "dodger-blue" 0.1176 0.5647 1.0000))
(defconstant +DodgerBlue+ (make-named-color "DodgerBlue" 0.1176 0.5647 1.0000))
(defconstant +deep-sky-blue+ (make-named-color "deep-sky-blue" 0.0000 0.7490 1.0000))
(defconstant +DeepSkyBlue+ (make-named-color "DeepSkyBlue" 0.0000 0.7490 1.0000))
(defconstant +sky-blue+ (make-named-color "sky-blue" 0.5294 0.8078 0.9216))
(defconstant +SkyBlue+ (make-named-color "SkyBlue" 0.5294 0.8078 0.9216))
(defconstant +light-sky-blue+ (make-named-color "light-sky-blue" 0.5294 0.8078 0.9804))
(defconstant +LightSkyBlue+ (make-named-color "LightSkyBlue" 0.5294 0.8078 0.9804))
(defconstant +steel-blue+ (make-named-color "steel-blue" 0.2745 0.5098 0.7059))
(defconstant +SteelBlue+ (make-named-color "SteelBlue" 0.2745 0.5098 0.7059))
(defconstant +light-steel-blue+ (make-named-color "light-steel-blue" 0.6902 0.7686 0.8706))
(defconstant +LightSteelBlue+ (make-named-color "LightSteelBlue" 0.6902 0.7686 0.8706))
(defconstant +light-blue+ (make-named-color "light-blue" 0.6784 0.8471 0.9020))
(defconstant +LightBlue+ (make-named-color "LightBlue" 0.6784 0.8471 0.9020))
(defconstant +powder-blue+ (make-named-color "powder-blue" 0.6902 0.8784 0.9020))
(defconstant +PowderBlue+ (make-named-color "PowderBlue" 0.6902 0.8784 0.9020))
(defconstant +pale-turquoise+ (make-named-color "pale-turquoise" 0.6863 0.9333 0.9333))
(defconstant +PaleTurquoise+ (make-named-color "PaleTurquoise" 0.6863 0.9333 0.9333))
(defconstant +dark-turquoise+ (make-named-color "dark-turquoise" 0.0000 0.8078 0.8196))
(defconstant +DarkTurquoise+ (make-named-color "DarkTurquoise" 0.0000 0.8078 0.8196))
(defconstant +medium-turquoise+ (make-named-color "medium-turquoise" 0.2824 0.8196 0.8000))
(defconstant +MediumTurquoise+ (make-named-color "MediumTurquoise" 0.2824 0.8196 0.8000))
(defconstant +turquoise+ (make-named-color "turquoise" 0.2510 0.8784 0.8157))
(defconstant +cyan+ (make-named-color "cyan" 0.0000 1.0000 1.0000))
(defconstant +light-cyan+ (make-named-color "light-cyan" 0.8784 1.0000 1.0000))
(defconstant +LightCyan+ (make-named-color "LightCyan" 0.8784 1.0000 1.0000))
(defconstant +cadet-blue+ (make-named-color "cadet-blue" 0.3725 0.6196 0.6275))
(defconstant +CadetBlue+ (make-named-color "CadetBlue" 0.3725 0.6196 0.6275))
(defconstant +medium-aquamarine+ (make-named-color "medium-aquamarine" 0.4000 0.8039 0.6667))
(defconstant +MediumAquamarine+ (make-named-color "MediumAquamarine" 0.4000 0.8039 0.6667))
(defconstant +aquamarine+ (make-named-color "aquamarine" 0.4980 1.0000 0.8314))
(defconstant +dark-green+ (make-named-color "dark-green" 0.0000 0.3922 0.0000))
(defconstant +DarkGreen+ (make-named-color "DarkGreen" 0.0000 0.3922 0.0000))
(defconstant +dark-olive-green+ (make-named-color "dark-olive-green" 0.3333 0.4196 0.1843))
(defconstant +DarkOliveGreen+ (make-named-color "DarkOliveGreen" 0.3333 0.4196 0.1843))
(defconstant +dark-sea-green+ (make-named-color "dark-sea-green" 0.5608 0.7373 0.5608))
(defconstant +DarkSeaGreen+ (make-named-color "DarkSeaGreen" 0.5608 0.7373 0.5608))
(defconstant +sea-green+ (make-named-color "sea-green" 0.1804 0.5451 0.3412))
(defconstant +SeaGreen+ (make-named-color "SeaGreen" 0.1804 0.5451 0.3412))
(defconstant +medium-sea-green+ (make-named-color "medium-sea-green" 0.2353 0.7020 0.4431))
(defconstant +MediumSeaGreen+ (make-named-color "MediumSeaGreen" 0.2353 0.7020 0.4431))
(defconstant +light-sea-green+ (make-named-color "light-sea-green" 0.1255 0.6980 0.6667))
(defconstant +LightSeaGreen+ (make-named-color "LightSeaGreen" 0.1255 0.6980 0.6667))
(defconstant +pale-green+ (make-named-color "pale-green" 0.5961 0.9843 0.5961))
(defconstant +PaleGreen+ (make-named-color "PaleGreen" 0.5961 0.9843 0.5961))
(defconstant +spring-green+ (make-named-color "spring-green" 0.0000 1.0000 0.4980))
(defconstant +SpringGreen+ (make-named-color "SpringGreen" 0.0000 1.0000 0.4980))
(defconstant +lawn-green+ (make-named-color "lawn-green" 0.4863 0.9882 0.0000))
(defconstant +LawnGreen+ (make-named-color "LawnGreen" 0.4863 0.9882 0.0000))
(defconstant +green+ (make-named-color "green" 0.0000 1.0000 0.0000))
(defconstant +chartreuse+ (make-named-color "chartreuse" 0.4980 1.0000 0.0000))
(defconstant +medium-spring-green+ (make-named-color "medium-spring-green" 0.0000 0.9804 0.6039))
(defconstant +MediumSpringGreen+ (make-named-color "MediumSpringGreen" 0.0000 0.9804 0.6039))
(defconstant +green-yellow+ (make-named-color "green-yellow" 0.6784 1.0000 0.1843))
(defconstant +GreenYellow+ (make-named-color "GreenYellow" 0.6784 1.0000 0.1843))
(defconstant +lime-green+ (make-named-color "lime-green" 0.1961 0.8039 0.1961))
(defconstant +LimeGreen+ (make-named-color "LimeGreen" 0.1961 0.8039 0.1961))
(defconstant +yellow-green+ (make-named-color "yellow-green" 0.6039 0.8039 0.1961))
(defconstant +YellowGreen+ (make-named-color "YellowGreen" 0.6039 0.8039 0.1961))
(defconstant +forest-green+ (make-named-color "forest-green" 0.1333 0.5451 0.1333))
(defconstant +ForestGreen+ (make-named-color "ForestGreen" 0.1333 0.5451 0.1333))
(defconstant +olive-drab+ (make-named-color "olive-drab" 0.4196 0.5569 0.1373))
(defconstant +OliveDrab+ (make-named-color "OliveDrab" 0.4196 0.5569 0.1373))
(defconstant +dark-khaki+ (make-named-color "dark-khaki" 0.7412 0.7176 0.4196))
(defconstant +DarkKhaki+ (make-named-color "DarkKhaki" 0.7412 0.7176 0.4196))
(defconstant +khaki+ (make-named-color "khaki" 0.9412 0.9020 0.5490))
(defconstant +pale-goldenrod+ (make-named-color "pale-goldenrod" 0.9333 0.9098 0.6667))
(defconstant +PaleGoldenrod+ (make-named-color "PaleGoldenrod" 0.9333 0.9098 0.6667))
(defconstant +light-goldenrod-yellow+ (make-named-color "light-goldenrod-yellow" 0.9804 0.9804 0.8235))
(defconstant +LightGoldenrodYellow+ (make-named-color "LightGoldenrodYellow" 0.9804 0.9804 0.8235))
(defconstant +light-yellow+ (make-named-color "light-yellow" 1.0000 1.0000 0.8784))
(defconstant +LightYellow+ (make-named-color "LightYellow" 1.0000 1.0000 0.8784))
(defconstant +yellow+ (make-named-color "yellow" 1.0000 1.0000 0.0000))
(defconstant +gold+ (make-named-color "gold" 1.0000 0.8431 0.0000))
(defconstant +light-goldenrod+ (make-named-color "light-goldenrod" 0.9333 0.8667 0.5098))
(defconstant +LightGoldenrod+ (make-named-color "LightGoldenrod" 0.9333 0.8667 0.5098))
(defconstant +goldenrod+ (make-named-color "goldenrod" 0.8549 0.6471 0.1255))
(defconstant +dark-goldenrod+ (make-named-color "dark-goldenrod" 0.7216 0.5255 0.0431))
(defconstant +DarkGoldenrod+ (make-named-color "DarkGoldenrod" 0.7216 0.5255 0.0431))
(defconstant +rosy-brown+ (make-named-color "rosy-brown" 0.7373 0.5608 0.5608))
(defconstant +RosyBrown+ (make-named-color "RosyBrown" 0.7373 0.5608 0.5608))
(defconstant +indian-red+ (make-named-color "indian-red" 0.8039 0.3608 0.3608))
(defconstant +IndianRed+ (make-named-color "IndianRed" 0.8039 0.3608 0.3608))
(defconstant +saddle-brown+ (make-named-color "saddle-brown" 0.5451 0.2706 0.0745))
(defconstant +SaddleBrown+ (make-named-color "SaddleBrown" 0.5451 0.2706 0.0745))
(defconstant +sienna+ (make-named-color "sienna" 0.6275 0.3216 0.1765))
(defconstant +peru+ (make-named-color "peru" 0.8039 0.5216 0.2471))
(defconstant +burlywood+ (make-named-color "burlywood" 0.8706 0.7216 0.5294))
(defconstant +beige+ (make-named-color "beige" 0.9608 0.9608 0.8627))
(defconstant +wheat+ (make-named-color "wheat" 0.9608 0.8706 0.7020))
(defconstant +sandy-brown+ (make-named-color "sandy-brown" 0.9569 0.6431 0.3765))
(defconstant +SandyBrown+ (make-named-color "SandyBrown" 0.9569 0.6431 0.3765))
(defconstant +tan+ (make-named-color "tan" 0.8235 0.7059 0.5490))
(defconstant +chocolate+ (make-named-color "chocolate" 0.8235 0.4118 0.1176))
(defconstant +firebrick+ (make-named-color "firebrick" 0.6980 0.1333 0.1333))
(defconstant +brown+ (make-named-color "brown" 0.6471 0.1647 0.1647))
(defconstant +dark-salmon+ (make-named-color "dark-salmon" 0.9137 0.5882 0.4784))
(defconstant +DarkSalmon+ (make-named-color "DarkSalmon" 0.9137 0.5882 0.4784))
(defconstant +salmon+ (make-named-color "salmon" 0.9804 0.5020 0.4471))
(defconstant +light-salmon+ (make-named-color "light-salmon" 1.0000 0.6275 0.4784))
(defconstant +LightSalmon+ (make-named-color "LightSalmon" 1.0000 0.6275 0.4784))
(defconstant +orange+ (make-named-color "orange" 1.0000 0.6471 0.0000))
(defconstant +dark-orange+ (make-named-color "dark-orange" 1.0000 0.5490 0.0000))
(defconstant +DarkOrange+ (make-named-color "DarkOrange" 1.0000 0.5490 0.0000))
(defconstant +coral+ (make-named-color "coral" 1.0000 0.4980 0.3137))
(defconstant +light-coral+ (make-named-color "light-coral" 0.9412 0.5020 0.5020))
(defconstant +LightCoral+ (make-named-color "LightCoral" 0.9412 0.5020 0.5020))
(defconstant +tomato+ (make-named-color "tomato" 1.0000 0.3882 0.2784))
(defconstant +orange-red+ (make-named-color "orange-red" 1.0000 0.2706 0.0000))
(defconstant +OrangeRed+ (make-named-color "OrangeRed" 1.0000 0.2706 0.0000))
(defconstant +red+ (make-named-color "red" 1.0000 0.0000 0.0000))
(defconstant +hot-pink+ (make-named-color "hot-pink" 1.0000 0.4118 0.7059))
(defconstant +HotPink+ (make-named-color "HotPink" 1.0000 0.4118 0.7059))
(defconstant +deep-pink+ (make-named-color "deep-pink" 1.0000 0.0784 0.5765))
(defconstant +DeepPink+ (make-named-color "DeepPink" 1.0000 0.0784 0.5765))
(defconstant +pink+ (make-named-color "pink" 1.0000 0.7529 0.7961))
(defconstant +light-pink+ (make-named-color "light-pink" 1.0000 0.7137 0.7569))
(defconstant +LightPink+ (make-named-color "LightPink" 1.0000 0.7137 0.7569))
(defconstant +pale-violet-red+ (make-named-color "pale-violet-red" 0.8588 0.4392 0.5765))
(defconstant +PaleVioletRed+ (make-named-color "PaleVioletRed" 0.8588 0.4392 0.5765))
(defconstant +maroon+ (make-named-color "maroon" 0.6902 0.1882 0.3765))
(defconstant +medium-violet-red+ (make-named-color "medium-violet-red" 0.7804 0.0824 0.5216))
(defconstant +MediumVioletRed+ (make-named-color "MediumVioletRed" 0.7804 0.0824 0.5216))
(defconstant +violet-red+ (make-named-color "violet-red" 0.8157 0.1255 0.5647))
(defconstant +VioletRed+ (make-named-color "VioletRed" 0.8157 0.1255 0.5647))
(defconstant +magenta+ (make-named-color "magenta" 1.0000 0.0000 1.0000))
(defconstant +violet+ (make-named-color "violet" 0.9333 0.5098 0.9333))
(defconstant +plum+ (make-named-color "plum" 0.8667 0.6275 0.8667))
(defconstant +orchid+ (make-named-color "orchid" 0.8549 0.4392 0.8392))
(defconstant +medium-orchid+ (make-named-color "medium-orchid" 0.7294 0.3333 0.8275))
(defconstant +MediumOrchid+ (make-named-color "MediumOrchid" 0.7294 0.3333 0.8275))
(defconstant +dark-orchid+ (make-named-color "dark-orchid" 0.6000 0.1961 0.8000))
(defconstant +DarkOrchid+ (make-named-color "DarkOrchid" 0.6000 0.1961 0.8000))
(defconstant +dark-violet+ (make-named-color "dark-violet" 0.5804 0.0000 0.8275))
(defconstant +DarkViolet+ (make-named-color "DarkViolet" 0.5804 0.0000 0.8275))
(defconstant +blue-violet+ (make-named-color "blue-violet" 0.5412 0.1686 0.8863))
(defconstant +BlueViolet+ (make-named-color "BlueViolet" 0.5412 0.1686 0.8863))
(defconstant +purple+ (make-named-color "purple" 0.6275 0.1255 0.9412))
(defconstant +medium-purple+ (make-named-color "medium-purple" 0.5765 0.4392 0.8588))
(defconstant +MediumPurple+ (make-named-color "MediumPurple" 0.5765 0.4392 0.8588))
(defconstant +thistle+ (make-named-color "thistle" 0.8471 0.7490 0.8471))
(defconstant +snow1+ (make-named-color "snow1" 1.0000 0.9804 0.9804))
(defconstant +snow2+ (make-named-color "snow2" 0.9333 0.9137 0.9137))
(defconstant +snow3+ (make-named-color "snow3" 0.8039 0.7882 0.7882))
(defconstant +snow4+ (make-named-color "snow4" 0.5451 0.5373 0.5373))
(defconstant +seashell1+ (make-named-color "seashell1" 1.0000 0.9608 0.9333))
(defconstant +seashell2+ (make-named-color "seashell2" 0.9333 0.8980 0.8706))
(defconstant +seashell3+ (make-named-color "seashell3" 0.8039 0.7725 0.7490))
(defconstant +seashell4+ (make-named-color "seashell4" 0.5451 0.5255 0.5098))
(defconstant +AntiqueWhite1+ (make-named-color "AntiqueWhite1" 1.0000 0.9373 0.8588))
(defconstant +AntiqueWhite2+ (make-named-color "AntiqueWhite2" 0.9333 0.8745 0.8000))
(defconstant +AntiqueWhite3+ (make-named-color "AntiqueWhite3" 0.8039 0.7529 0.6902))
(defconstant +AntiqueWhite4+ (make-named-color "AntiqueWhite4" 0.5451 0.5137 0.4706))
(defconstant +bisque1+ (make-named-color "bisque1" 1.0000 0.8941 0.7686))
(defconstant +bisque2+ (make-named-color "bisque2" 0.9333 0.8353 0.7176))
(defconstant +bisque3+ (make-named-color "bisque3" 0.8039 0.7176 0.6196))
(defconstant +bisque4+ (make-named-color "bisque4" 0.5451 0.4902 0.4196))
(defconstant +PeachPuff1+ (make-named-color "PeachPuff1" 1.0000 0.8549 0.7255))
(defconstant +PeachPuff2+ (make-named-color "PeachPuff2" 0.9333 0.7961 0.6784))
(defconstant +PeachPuff3+ (make-named-color "PeachPuff3" 0.8039 0.6863 0.5843))
(defconstant +PeachPuff4+ (make-named-color "PeachPuff4" 0.5451 0.4667 0.3961))
(defconstant +NavajoWhite1+ (make-named-color "NavajoWhite1" 1.0000 0.8706 0.6784))
(defconstant +NavajoWhite2+ (make-named-color "NavajoWhite2" 0.9333 0.8118 0.6314))
(defconstant +NavajoWhite3+ (make-named-color "NavajoWhite3" 0.8039 0.7020 0.5451))
(defconstant +NavajoWhite4+ (make-named-color "NavajoWhite4" 0.5451 0.4745 0.3686))
(defconstant +LemonChiffon1+ (make-named-color "LemonChiffon1" 1.0000 0.9804 0.8039))
(defconstant +LemonChiffon2+ (make-named-color "LemonChiffon2" 0.9333 0.9137 0.7490))
(defconstant +LemonChiffon3+ (make-named-color "LemonChiffon3" 0.8039 0.7882 0.6471))
(defconstant +LemonChiffon4+ (make-named-color "LemonChiffon4" 0.5451 0.5373 0.4392))
(defconstant +cornsilk1+ (make-named-color "cornsilk1" 1.0000 0.9725 0.8627))
(defconstant +cornsilk2+ (make-named-color "cornsilk2" 0.9333 0.9098 0.8039))
(defconstant +cornsilk3+ (make-named-color "cornsilk3" 0.8039 0.7843 0.6941))
(defconstant +cornsilk4+ (make-named-color "cornsilk4" 0.5451 0.5333 0.4706))
(defconstant +ivory1+ (make-named-color "ivory1" 1.0000 1.0000 0.9412))
(defconstant +ivory2+ (make-named-color "ivory2" 0.9333 0.9333 0.8784))
(defconstant +ivory3+ (make-named-color "ivory3" 0.8039 0.8039 0.7569))
(defconstant +ivory4+ (make-named-color "ivory4" 0.5451 0.5451 0.5137))
(defconstant +honeydew1+ (make-named-color "honeydew1" 0.9412 1.0000 0.9412))
(defconstant +honeydew2+ (make-named-color "honeydew2" 0.8784 0.9333 0.8784))
(defconstant +honeydew3+ (make-named-color "honeydew3" 0.7569 0.8039 0.7569))
(defconstant +honeydew4+ (make-named-color "honeydew4" 0.5137 0.5451 0.5137))
(defconstant +LavenderBlush1+ (make-named-color "LavenderBlush1" 1.0000 0.9412 0.9608))
(defconstant +LavenderBlush2+ (make-named-color "LavenderBlush2" 0.9333 0.8784 0.8980))
(defconstant +LavenderBlush3+ (make-named-color "LavenderBlush3" 0.8039 0.7569 0.7725))
(defconstant +LavenderBlush4+ (make-named-color "LavenderBlush4" 0.5451 0.5137 0.5255))
(defconstant +MistyRose1+ (make-named-color "MistyRose1" 1.0000 0.8941 0.8824))
(defconstant +MistyRose2+ (make-named-color "MistyRose2" 0.9333 0.8353 0.8235))
(defconstant +MistyRose3+ (make-named-color "MistyRose3" 0.8039 0.7176 0.7098))
(defconstant +MistyRose4+ (make-named-color "MistyRose4" 0.5451 0.4902 0.4824))
(defconstant +azure1+ (make-named-color "azure1" 0.9412 1.0000 1.0000))
(defconstant +azure2+ (make-named-color "azure2" 0.8784 0.9333 0.9333))
(defconstant +azure3+ (make-named-color "azure3" 0.7569 0.8039 0.8039))
(defconstant +azure4+ (make-named-color "azure4" 0.5137 0.5451 0.5451))
(defconstant +SlateBlue1+ (make-named-color "SlateBlue1" 0.5137 0.4353 1.0000))
(defconstant +SlateBlue2+ (make-named-color "SlateBlue2" 0.4784 0.4039 0.9333))
(defconstant +SlateBlue3+ (make-named-color "SlateBlue3" 0.4118 0.3490 0.8039))
(defconstant +SlateBlue4+ (make-named-color "SlateBlue4" 0.2784 0.2353 0.5451))
(defconstant +RoyalBlue1+ (make-named-color "RoyalBlue1" 0.2824 0.4627 1.0000))
(defconstant +RoyalBlue2+ (make-named-color "RoyalBlue2" 0.2627 0.4314 0.9333))
(defconstant +RoyalBlue3+ (make-named-color "RoyalBlue3" 0.2275 0.3725 0.8039))
(defconstant +RoyalBlue4+ (make-named-color "RoyalBlue4" 0.1529 0.2510 0.5451))
(defconstant +blue1+ (make-named-color "blue1" 0.0000 0.0000 1.0000))
(defconstant +blue2+ (make-named-color "blue2" 0.0000 0.0000 0.9333))
(defconstant +blue3+ (make-named-color "blue3" 0.0000 0.0000 0.8039))
(defconstant +blue4+ (make-named-color "blue4" 0.0000 0.0000 0.5451))
(defconstant +DodgerBlue1+ (make-named-color "DodgerBlue1" 0.1176 0.5647 1.0000))
(defconstant +DodgerBlue2+ (make-named-color "DodgerBlue2" 0.1098 0.5255 0.9333))
(defconstant +DodgerBlue3+ (make-named-color "DodgerBlue3" 0.0941 0.4549 0.8039))
(defconstant +DodgerBlue4+ (make-named-color "DodgerBlue4" 0.0627 0.3059 0.5451))
(defconstant +SteelBlue1+ (make-named-color "SteelBlue1" 0.3882 0.7216 1.0000))
(defconstant +SteelBlue2+ (make-named-color "SteelBlue2" 0.3608 0.6745 0.9333))
(defconstant +SteelBlue3+ (make-named-color "SteelBlue3" 0.3098 0.5804 0.8039))
(defconstant +SteelBlue4+ (make-named-color "SteelBlue4" 0.2118 0.3922 0.5451))
(defconstant +DeepSkyBlue1+ (make-named-color "DeepSkyBlue1" 0.0000 0.7490 1.0000))
(defconstant +DeepSkyBlue2+ (make-named-color "DeepSkyBlue2" 0.0000 0.6980 0.9333))
(defconstant +DeepSkyBlue3+ (make-named-color "DeepSkyBlue3" 0.0000 0.6039 0.8039))
(defconstant +DeepSkyBlue4+ (make-named-color "DeepSkyBlue4" 0.0000 0.4078 0.5451))
(defconstant +SkyBlue1+ (make-named-color "SkyBlue1" 0.5294 0.8078 1.0000))
(defconstant +SkyBlue2+ (make-named-color "SkyBlue2" 0.4941 0.7529 0.9333))
(defconstant +SkyBlue3+ (make-named-color "SkyBlue3" 0.4235 0.6510 0.8039))
(defconstant +SkyBlue4+ (make-named-color "SkyBlue4" 0.2902 0.4392 0.5451))
(defconstant +LightSkyBlue1+ (make-named-color "LightSkyBlue1" 0.6902 0.8863 1.0000))
(defconstant +LightSkyBlue2+ (make-named-color "LightSkyBlue2" 0.6431 0.8275 0.9333))
(defconstant +LightSkyBlue3+ (make-named-color "LightSkyBlue3" 0.5529 0.7137 0.8039))
(defconstant +LightSkyBlue4+ (make-named-color "LightSkyBlue4" 0.3765 0.4824 0.5451))
(defconstant +SlateGray1+ (make-named-color "SlateGray1" 0.7765 0.8863 1.0000))
(defconstant +SlateGray2+ (make-named-color "SlateGray2" 0.7255 0.8275 0.9333))
(defconstant +SlateGray3+ (make-named-color "SlateGray3" 0.6235 0.7137 0.8039))
(defconstant +SlateGray4+ (make-named-color "SlateGray4" 0.4235 0.4824 0.5451))
(defconstant +LightSteelBlue1+ (make-named-color "LightSteelBlue1" 0.7922 0.8824 1.0000))
(defconstant +LightSteelBlue2+ (make-named-color "LightSteelBlue2" 0.7373 0.8235 0.9333))
(defconstant +LightSteelBlue3+ (make-named-color "LightSteelBlue3" 0.6353 0.7098 0.8039))
(defconstant +LightSteelBlue4+ (make-named-color "LightSteelBlue4" 0.4314 0.4824 0.5451))
(defconstant +LightBlue1+ (make-named-color "LightBlue1" 0.7490 0.9373 1.0000))
(defconstant +LightBlue2+ (make-named-color "LightBlue2" 0.6980 0.8745 0.9333))
(defconstant +LightBlue3+ (make-named-color "LightBlue3" 0.6039 0.7529 0.8039))
(defconstant +LightBlue4+ (make-named-color "LightBlue4" 0.4078 0.5137 0.5451))
(defconstant +LightCyan1+ (make-named-color "LightCyan1" 0.8784 1.0000 1.0000))
(defconstant +LightCyan2+ (make-named-color "LightCyan2" 0.8196 0.9333 0.9333))
(defconstant +LightCyan3+ (make-named-color "LightCyan3" 0.7059 0.8039 0.8039))
(defconstant +LightCyan4+ (make-named-color "LightCyan4" 0.4784 0.5451 0.5451))
(defconstant +PaleTurquoise1+ (make-named-color "PaleTurquoise1" 0.7333 1.0000 1.0000))
(defconstant +PaleTurquoise2+ (make-named-color "PaleTurquoise2" 0.6824 0.9333 0.9333))
(defconstant +PaleTurquoise3+ (make-named-color "PaleTurquoise3" 0.5882 0.8039 0.8039))
(defconstant +PaleTurquoise4+ (make-named-color "PaleTurquoise4" 0.4000 0.5451 0.5451))
(defconstant +CadetBlue1+ (make-named-color "CadetBlue1" 0.5961 0.9608 1.0000))
(defconstant +CadetBlue2+ (make-named-color "CadetBlue2" 0.5569 0.8980 0.9333))
(defconstant +CadetBlue3+ (make-named-color "CadetBlue3" 0.4784 0.7725 0.8039))
(defconstant +CadetBlue4+ (make-named-color "CadetBlue4" 0.3255 0.5255 0.5451))
(defconstant +turquoise1+ (make-named-color "turquoise1" 0.0000 0.9608 1.0000))
(defconstant +turquoise2+ (make-named-color "turquoise2" 0.0000 0.8980 0.9333))
(defconstant +turquoise3+ (make-named-color "turquoise3" 0.0000 0.7725 0.8039))
(defconstant +turquoise4+ (make-named-color "turquoise4" 0.0000 0.5255 0.5451))
(defconstant +cyan1+ (make-named-color "cyan1" 0.0000 1.0000 1.0000))
(defconstant +cyan2+ (make-named-color "cyan2" 0.0000 0.9333 0.9333))
(defconstant +cyan3+ (make-named-color "cyan3" 0.0000 0.8039 0.8039))
(defconstant +cyan4+ (make-named-color "cyan4" 0.0000 0.5451 0.5451))
(defconstant +DarkSlateGray1+ (make-named-color "DarkSlateGray1" 0.5922 1.0000 1.0000))
(defconstant +DarkSlateGray2+ (make-named-color "DarkSlateGray2" 0.5529 0.9333 0.9333))
(defconstant +DarkSlateGray3+ (make-named-color "DarkSlateGray3" 0.4745 0.8039 0.8039))
(defconstant +DarkSlateGray4+ (make-named-color "DarkSlateGray4" 0.3216 0.5451 0.5451))
(defconstant +aquamarine1+ (make-named-color "aquamarine1" 0.4980 1.0000 0.8314))
(defconstant +aquamarine2+ (make-named-color "aquamarine2" 0.4627 0.9333 0.7765))
(defconstant +aquamarine3+ (make-named-color "aquamarine3" 0.4000 0.8039 0.6667))
(defconstant +aquamarine4+ (make-named-color "aquamarine4" 0.2706 0.5451 0.4549))
(defconstant +DarkSeaGreen1+ (make-named-color "DarkSeaGreen1" 0.7569 1.0000 0.7569))
(defconstant +DarkSeaGreen2+ (make-named-color "DarkSeaGreen2" 0.7059 0.9333 0.7059))
(defconstant +DarkSeaGreen3+ (make-named-color "DarkSeaGreen3" 0.6078 0.8039 0.6078))
(defconstant +DarkSeaGreen4+ (make-named-color "DarkSeaGreen4" 0.4118 0.5451 0.4118))
(defconstant +SeaGreen1+ (make-named-color "SeaGreen1" 0.3294 1.0000 0.6235))
(defconstant +SeaGreen2+ (make-named-color "SeaGreen2" 0.3059 0.9333 0.5804))
(defconstant +SeaGreen3+ (make-named-color "SeaGreen3" 0.2627 0.8039 0.5020))
(defconstant +SeaGreen4+ (make-named-color "SeaGreen4" 0.1804 0.5451 0.3412))
(defconstant +PaleGreen1+ (make-named-color "PaleGreen1" 0.6039 1.0000 0.6039))
(defconstant +PaleGreen2+ (make-named-color "PaleGreen2" 0.5647 0.9333 0.5647))
(defconstant +PaleGreen3+ (make-named-color "PaleGreen3" 0.4863 0.8039 0.4863))
(defconstant +PaleGreen4+ (make-named-color "PaleGreen4" 0.3294 0.5451 0.3294))
(defconstant +SpringGreen1+ (make-named-color "SpringGreen1" 0.0000 1.0000 0.4980))
(defconstant +SpringGreen2+ (make-named-color "SpringGreen2" 0.0000 0.9333 0.4627))
(defconstant +SpringGreen3+ (make-named-color "SpringGreen3" 0.0000 0.8039 0.4000))
(defconstant +SpringGreen4+ (make-named-color "SpringGreen4" 0.0000 0.5451 0.2706))
(defconstant +green1+ (make-named-color "green1" 0.0000 1.0000 0.0000))
(defconstant +green2+ (make-named-color "green2" 0.0000 0.9333 0.0000))
(defconstant +green3+ (make-named-color "green3" 0.0000 0.8039 0.0000))
(defconstant +green4+ (make-named-color "green4" 0.0000 0.5451 0.0000))
(defconstant +chartreuse1+ (make-named-color "chartreuse1" 0.4980 1.0000 0.0000))
(defconstant +chartreuse2+ (make-named-color "chartreuse2" 0.4627 0.9333 0.0000))
(defconstant +chartreuse3+ (make-named-color "chartreuse3" 0.4000 0.8039 0.0000))
(defconstant +chartreuse4+ (make-named-color "chartreuse4" 0.2706 0.5451 0.0000))
(defconstant +OliveDrab1+ (make-named-color "OliveDrab1" 0.7529 1.0000 0.2431))
(defconstant +OliveDrab2+ (make-named-color "OliveDrab2" 0.7020 0.9333 0.2275))
(defconstant +OliveDrab3+ (make-named-color "OliveDrab3" 0.6039 0.8039 0.1961))
(defconstant +OliveDrab4+ (make-named-color "OliveDrab4" 0.4118 0.5451 0.1333))
(defconstant +DarkOliveGreen1+ (make-named-color "DarkOliveGreen1" 0.7922 1.0000 0.4392))
(defconstant +DarkOliveGreen2+ (make-named-color "DarkOliveGreen2" 0.7373 0.9333 0.4078))
(defconstant +DarkOliveGreen3+ (make-named-color "DarkOliveGreen3" 0.6353 0.8039 0.3529))
(defconstant +DarkOliveGreen4+ (make-named-color "DarkOliveGreen4" 0.4314 0.5451 0.2392))
(defconstant +khaki1+ (make-named-color "khaki1" 1.0000 0.9647 0.5608))
(defconstant +khaki2+ (make-named-color "khaki2" 0.9333 0.9020 0.5216))
(defconstant +khaki3+ (make-named-color "khaki3" 0.8039 0.7765 0.4510))
(defconstant +khaki4+ (make-named-color "khaki4" 0.5451 0.5255 0.3059))
(defconstant +LightGoldenrod1+ (make-named-color "LightGoldenrod1" 1.0000 0.9255 0.5451))
(defconstant +LightGoldenrod2+ (make-named-color "LightGoldenrod2" 0.9333 0.8627 0.5098))
(defconstant +LightGoldenrod3+ (make-named-color "LightGoldenrod3" 0.8039 0.7451 0.4392))
(defconstant +LightGoldenrod4+ (make-named-color "LightGoldenrod4" 0.5451 0.5059 0.2980))
(defconstant +LightYellow1+ (make-named-color "LightYellow1" 1.0000 1.0000 0.8784))
(defconstant +LightYellow2+ (make-named-color "LightYellow2" 0.9333 0.9333 0.8196))
(defconstant +LightYellow3+ (make-named-color "LightYellow3" 0.8039 0.8039 0.7059))
(defconstant +LightYellow4+ (make-named-color "LightYellow4" 0.5451 0.5451 0.4784))
(defconstant +yellow1+ (make-named-color "yellow1" 1.0000 1.0000 0.0000))
(defconstant +yellow2+ (make-named-color "yellow2" 0.9333 0.9333 0.0000))
(defconstant +yellow3+ (make-named-color "yellow3" 0.8039 0.8039 0.0000))
(defconstant +yellow4+ (make-named-color "yellow4" 0.5451 0.5451 0.0000))
(defconstant +gold1+ (make-named-color "gold1" 1.0000 0.8431 0.0000))
(defconstant +gold2+ (make-named-color "gold2" 0.9333 0.7882 0.0000))
(defconstant +gold3+ (make-named-color "gold3" 0.8039 0.6784 0.0000))
(defconstant +gold4+ (make-named-color "gold4" 0.5451 0.4588 0.0000))
(defconstant +goldenrod1+ (make-named-color "goldenrod1" 1.0000 0.7569 0.1451))
(defconstant +goldenrod2+ (make-named-color "goldenrod2" 0.9333 0.7059 0.1333))
(defconstant +goldenrod3+ (make-named-color "goldenrod3" 0.8039 0.6078 0.1137))
(defconstant +goldenrod4+ (make-named-color "goldenrod4" 0.5451 0.4118 0.0784))
(defconstant +DarkGoldenrod1+ (make-named-color "DarkGoldenrod1" 1.0000 0.7255 0.0588))
(defconstant +DarkGoldenrod2+ (make-named-color "DarkGoldenrod2" 0.9333 0.6784 0.0549))
(defconstant +DarkGoldenrod3+ (make-named-color "DarkGoldenrod3" 0.8039 0.5843 0.0471))
(defconstant +DarkGoldenrod4+ (make-named-color "DarkGoldenrod4" 0.5451 0.3961 0.0314))
(defconstant +RosyBrown1+ (make-named-color "RosyBrown1" 1.0000 0.7569 0.7569))
(defconstant +RosyBrown2+ (make-named-color "RosyBrown2" 0.9333 0.7059 0.7059))
(defconstant +RosyBrown3+ (make-named-color "RosyBrown3" 0.8039 0.6078 0.6078))
(defconstant +RosyBrown4+ (make-named-color "RosyBrown4" 0.5451 0.4118 0.4118))
(defconstant +IndianRed1+ (make-named-color "IndianRed1" 1.0000 0.4157 0.4157))
(defconstant +IndianRed2+ (make-named-color "IndianRed2" 0.9333 0.3882 0.3882))
(defconstant +IndianRed3+ (make-named-color "IndianRed3" 0.8039 0.3333 0.3333))
(defconstant +IndianRed4+ (make-named-color "IndianRed4" 0.5451 0.2275 0.2275))
(defconstant +sienna1+ (make-named-color "sienna1" 1.0000 0.5098 0.2784))
(defconstant +sienna2+ (make-named-color "sienna2" 0.9333 0.4745 0.2588))
(defconstant +sienna3+ (make-named-color "sienna3" 0.8039 0.4078 0.2235))
(defconstant +sienna4+ (make-named-color "sienna4" 0.5451 0.2784 0.1490))
(defconstant +burlywood1+ (make-named-color "burlywood1" 1.0000 0.8275 0.6078))
(defconstant +burlywood2+ (make-named-color "burlywood2" 0.9333 0.7725 0.5686))
(defconstant +burlywood3+ (make-named-color "burlywood3" 0.8039 0.6667 0.4902))
(defconstant +burlywood4+ (make-named-color "burlywood4" 0.5451 0.4510 0.3333))
(defconstant +wheat1+ (make-named-color "wheat1" 1.0000 0.9059 0.7294))
(defconstant +wheat2+ (make-named-color "wheat2" 0.9333 0.8471 0.6824))
(defconstant +wheat3+ (make-named-color "wheat3" 0.8039 0.7294 0.5882))
(defconstant +wheat4+ (make-named-color "wheat4" 0.5451 0.4941 0.4000))
(defconstant +tan1+ (make-named-color "tan1" 1.0000 0.6471 0.3098))
(defconstant +tan2+ (make-named-color "tan2" 0.9333 0.6039 0.2863))
(defconstant +tan3+ (make-named-color "tan3" 0.8039 0.5216 0.2471))
(defconstant +tan4+ (make-named-color "tan4" 0.5451 0.3529 0.1686))
(defconstant +chocolate1+ (make-named-color "chocolate1" 1.0000 0.4980 0.1412))
(defconstant +chocolate2+ (make-named-color "chocolate2" 0.9333 0.4627 0.1294))
(defconstant +chocolate3+ (make-named-color "chocolate3" 0.8039 0.4000 0.1137))
(defconstant +chocolate4+ (make-named-color "chocolate4" 0.5451 0.2706 0.0745))
(defconstant +firebrick1+ (make-named-color "firebrick1" 1.0000 0.1882 0.1882))
(defconstant +firebrick2+ (make-named-color "firebrick2" 0.9333 0.1725 0.1725))
(defconstant +firebrick3+ (make-named-color "firebrick3" 0.8039 0.1490 0.1490))
(defconstant +firebrick4+ (make-named-color "firebrick4" 0.5451 0.1020 0.1020))
(defconstant +brown1+ (make-named-color "brown1" 1.0000 0.2510 0.2510))
(defconstant +brown2+ (make-named-color "brown2" 0.9333 0.2314 0.2314))
(defconstant +brown3+ (make-named-color "brown3" 0.8039 0.2000 0.2000))
(defconstant +brown4+ (make-named-color "brown4" 0.5451 0.1373 0.1373))
(defconstant +salmon1+ (make-named-color "salmon1" 1.0000 0.5490 0.4118))
(defconstant +salmon2+ (make-named-color "salmon2" 0.9333 0.5098 0.3843))
(defconstant +salmon3+ (make-named-color "salmon3" 0.8039 0.4392 0.3294))
(defconstant +salmon4+ (make-named-color "salmon4" 0.5451 0.2980 0.2235))
(defconstant +LightSalmon1+ (make-named-color "LightSalmon1" 1.0000 0.6275 0.4784))
(defconstant +LightSalmon2+ (make-named-color "LightSalmon2" 0.9333 0.5843 0.4471))
(defconstant +LightSalmon3+ (make-named-color "LightSalmon3" 0.8039 0.5059 0.3843))
(defconstant +LightSalmon4+ (make-named-color "LightSalmon4" 0.5451 0.3412 0.2588))
(defconstant +orange1+ (make-named-color "orange1" 1.0000 0.6471 0.0000))
(defconstant +orange2+ (make-named-color "orange2" 0.9333 0.6039 0.0000))
(defconstant +orange3+ (make-named-color "orange3" 0.8039 0.5216 0.0000))
(defconstant +orange4+ (make-named-color "orange4" 0.5451 0.3529 0.0000))
(defconstant +DarkOrange1+ (make-named-color "DarkOrange1" 1.0000 0.4980 0.0000))
(defconstant +DarkOrange2+ (make-named-color "DarkOrange2" 0.9333 0.4627 0.0000))
(defconstant +DarkOrange3+ (make-named-color "DarkOrange3" 0.8039 0.4000 0.0000))
(defconstant +DarkOrange4+ (make-named-color "DarkOrange4" 0.5451 0.2706 0.0000))
(defconstant +coral1+ (make-named-color "coral1" 1.0000 0.4471 0.3373))
(defconstant +coral2+ (make-named-color "coral2" 0.9333 0.4157 0.3137))
(defconstant +coral3+ (make-named-color "coral3" 0.8039 0.3569 0.2706))
(defconstant +coral4+ (make-named-color "coral4" 0.5451 0.2431 0.1843))
(defconstant +tomato1+ (make-named-color "tomato1" 1.0000 0.3882 0.2784))
(defconstant +tomato2+ (make-named-color "tomato2" 0.9333 0.3608 0.2588))
(defconstant +tomato3+ (make-named-color "tomato3" 0.8039 0.3098 0.2235))
(defconstant +tomato4+ (make-named-color "tomato4" 0.5451 0.2118 0.1490))
(defconstant +OrangeRed1+ (make-named-color "OrangeRed1" 1.0000 0.2706 0.0000))
(defconstant +OrangeRed2+ (make-named-color "OrangeRed2" 0.9333 0.2510 0.0000))
(defconstant +OrangeRed3+ (make-named-color "OrangeRed3" 0.8039 0.2157 0.0000))
(defconstant +OrangeRed4+ (make-named-color "OrangeRed4" 0.5451 0.1451 0.0000))
(defconstant +red1+ (make-named-color "red1" 1.0000 0.0000 0.0000))
(defconstant +red2+ (make-named-color "red2" 0.9333 0.0000 0.0000))
(defconstant +red3+ (make-named-color "red3" 0.8039 0.0000 0.0000))
(defconstant +red4+ (make-named-color "red4" 0.5451 0.0000 0.0000))
(defconstant +DeepPink1+ (make-named-color "DeepPink1" 1.0000 0.0784 0.5765))
(defconstant +DeepPink2+ (make-named-color "DeepPink2" 0.9333 0.0706 0.5373))
(defconstant +DeepPink3+ (make-named-color "DeepPink3" 0.8039 0.0627 0.4627))
(defconstant +DeepPink4+ (make-named-color "DeepPink4" 0.5451 0.0392 0.3137))
(defconstant +HotPink1+ (make-named-color "HotPink1" 1.0000 0.4314 0.7059))
(defconstant +HotPink2+ (make-named-color "HotPink2" 0.9333 0.4157 0.6549))
(defconstant +HotPink3+ (make-named-color "HotPink3" 0.8039 0.3765 0.5647))
(defconstant +HotPink4+ (make-named-color "HotPink4" 0.5451 0.2275 0.3843))
(defconstant +pink1+ (make-named-color "pink1" 1.0000 0.7098 0.7725))
(defconstant +pink2+ (make-named-color "pink2" 0.9333 0.6627 0.7216))
(defconstant +pink3+ (make-named-color "pink3" 0.8039 0.5686 0.6196))
(defconstant +pink4+ (make-named-color "pink4" 0.5451 0.3882 0.4235))
(defconstant +LightPink1+ (make-named-color "LightPink1" 1.0000 0.6824 0.7255))
(defconstant +LightPink2+ (make-named-color "LightPink2" 0.9333 0.6353 0.6784))
(defconstant +LightPink3+ (make-named-color "LightPink3" 0.8039 0.5490 0.5843))
(defconstant +LightPink4+ (make-named-color "LightPink4" 0.5451 0.3725 0.3961))
(defconstant +PaleVioletRed1+ (make-named-color "PaleVioletRed1" 1.0000 0.5098 0.6706))
(defconstant +PaleVioletRed2+ (make-named-color "PaleVioletRed2" 0.9333 0.4745 0.6235))
(defconstant +PaleVioletRed3+ (make-named-color "PaleVioletRed3" 0.8039 0.4078 0.5373))
(defconstant +PaleVioletRed4+ (make-named-color "PaleVioletRed4" 0.5451 0.2784 0.3647))
(defconstant +maroon1+ (make-named-color "maroon1" 1.0000 0.2039 0.7020))
(defconstant +maroon2+ (make-named-color "maroon2" 0.9333 0.1882 0.6549))
(defconstant +maroon3+ (make-named-color "maroon3" 0.8039 0.1608 0.5647))
(defconstant +maroon4+ (make-named-color "maroon4" 0.5451 0.1098 0.3843))
(defconstant +VioletRed1+ (make-named-color "VioletRed1" 1.0000 0.2431 0.5882))
(defconstant +VioletRed2+ (make-named-color "VioletRed2" 0.9333 0.2275 0.5490))
(defconstant +VioletRed3+ (make-named-color "VioletRed3" 0.8039 0.1961 0.4706))
(defconstant +VioletRed4+ (make-named-color "VioletRed4" 0.5451 0.1333 0.3216))
(defconstant +magenta1+ (make-named-color "magenta1" 1.0000 0.0000 1.0000))
(defconstant +magenta2+ (make-named-color "magenta2" 0.9333 0.0000 0.9333))
(defconstant +magenta3+ (make-named-color "magenta3" 0.8039 0.0000 0.8039))
(defconstant +magenta4+ (make-named-color "magenta4" 0.5451 0.0000 0.5451))
(defconstant +orchid1+ (make-named-color "orchid1" 1.0000 0.5137 0.9804))
(defconstant +orchid2+ (make-named-color "orchid2" 0.9333 0.4784 0.9137))
(defconstant +orchid3+ (make-named-color "orchid3" 0.8039 0.4118 0.7882))
(defconstant +orchid4+ (make-named-color "orchid4" 0.5451 0.2784 0.5373))
(defconstant +plum1+ (make-named-color "plum1" 1.0000 0.7333 1.0000))
(defconstant +plum2+ (make-named-color "plum2" 0.9333 0.6824 0.9333))
(defconstant +plum3+ (make-named-color "plum3" 0.8039 0.5882 0.8039))
(defconstant +plum4+ (make-named-color "plum4" 0.5451 0.4000 0.5451))
(defconstant +MediumOrchid1+ (make-named-color "MediumOrchid1" 0.8784 0.4000 1.0000))
(defconstant +MediumOrchid2+ (make-named-color "MediumOrchid2" 0.8196 0.3725 0.9333))
(defconstant +MediumOrchid3+ (make-named-color "MediumOrchid3" 0.7059 0.3216 0.8039))
(defconstant +MediumOrchid4+ (make-named-color "MediumOrchid4" 0.4784 0.2157 0.5451))
(defconstant +DarkOrchid1+ (make-named-color "DarkOrchid1" 0.7490 0.2431 1.0000))
(defconstant +DarkOrchid2+ (make-named-color "DarkOrchid2" 0.6980 0.2275 0.9333))
(defconstant +DarkOrchid3+ (make-named-color "DarkOrchid3" 0.6039 0.1961 0.8039))
(defconstant +DarkOrchid4+ (make-named-color "DarkOrchid4" 0.4078 0.1333 0.5451))
(defconstant +purple1+ (make-named-color "purple1" 0.6078 0.1882 1.0000))
(defconstant +purple2+ (make-named-color "purple2" 0.5686 0.1725 0.9333))
(defconstant +purple3+ (make-named-color "purple3" 0.4902 0.1490 0.8039))
(defconstant +purple4+ (make-named-color "purple4" 0.3333 0.1020 0.5451))
(defconstant +MediumPurple1+ (make-named-color "MediumPurple1" 0.6706 0.5098 1.0000))
(defconstant +MediumPurple2+ (make-named-color "MediumPurple2" 0.6235 0.4745 0.9333))
(defconstant +MediumPurple3+ (make-named-color "MediumPurple3" 0.5373 0.4078 0.8039))
(defconstant +MediumPurple4+ (make-named-color "MediumPurple4" 0.3647 0.2784 0.5451))
(defconstant +thistle1+ (make-named-color "thistle1" 1.0000 0.8824 1.0000))
(defconstant +thistle2+ (make-named-color "thistle2" 0.9333 0.8235 0.9333))
(defconstant +thistle3+ (make-named-color "thistle3" 0.8039 0.7098 0.8039))
(defconstant +thistle4+ (make-named-color "thistle4" 0.5451 0.4824 0.5451))
(defconstant +gray0+ (make-named-color "gray0" 0.0000 0.0000 0.0000))
(defconstant +grey0+ (make-named-color "grey0" 0.0000 0.0000 0.0000))
(defconstant +gray1+ (make-named-color "gray1" 0.0118 0.0118 0.0118))
(defconstant +grey1+ (make-named-color "grey1" 0.0118 0.0118 0.0118))
(defconstant +gray2+ (make-named-color "gray2" 0.0196 0.0196 0.0196))
(defconstant +grey2+ (make-named-color "grey2" 0.0196 0.0196 0.0196))
(defconstant +gray3+ (make-named-color "gray3" 0.0314 0.0314 0.0314))
(defconstant +grey3+ (make-named-color "grey3" 0.0314 0.0314 0.0314))
(defconstant +gray4+ (make-named-color "gray4" 0.0392 0.0392 0.0392))
(defconstant +grey4+ (make-named-color "grey4" 0.0392 0.0392 0.0392))
(defconstant +gray5+ (make-named-color "gray5" 0.0510 0.0510 0.0510))
(defconstant +grey5+ (make-named-color "grey5" 0.0510 0.0510 0.0510))
(defconstant +gray6+ (make-named-color "gray6" 0.0588 0.0588 0.0588))
(defconstant +grey6+ (make-named-color "grey6" 0.0588 0.0588 0.0588))
(defconstant +gray7+ (make-named-color "gray7" 0.0706 0.0706 0.0706))
(defconstant +grey7+ (make-named-color "grey7" 0.0706 0.0706 0.0706))
(defconstant +gray8+ (make-named-color "gray8" 0.0784 0.0784 0.0784))
(defconstant +grey8+ (make-named-color "grey8" 0.0784 0.0784 0.0784))
(defconstant +gray9+ (make-named-color "gray9" 0.0902 0.0902 0.0902))
(defconstant +grey9+ (make-named-color "grey9" 0.0902 0.0902 0.0902))
(defconstant +gray10+ (make-named-color "gray10" 0.1020 0.1020 0.1020))
(defconstant +grey10+ (make-named-color "grey10" 0.1020 0.1020 0.1020))
(defconstant +gray11+ (make-named-color "gray11" 0.1098 0.1098 0.1098))
(defconstant +grey11+ (make-named-color "grey11" 0.1098 0.1098 0.1098))
(defconstant +gray12+ (make-named-color "gray12" 0.1216 0.1216 0.1216))
(defconstant +grey12+ (make-named-color "grey12" 0.1216 0.1216 0.1216))
(defconstant +gray13+ (make-named-color "gray13" 0.1294 0.1294 0.1294))
(defconstant +grey13+ (make-named-color "grey13" 0.1294 0.1294 0.1294))
(defconstant +gray14+ (make-named-color "gray14" 0.1412 0.1412 0.1412))
(defconstant +grey14+ (make-named-color "grey14" 0.1412 0.1412 0.1412))
(defconstant +gray15+ (make-named-color "gray15" 0.1490 0.1490 0.1490))
(defconstant +grey15+ (make-named-color "grey15" 0.1490 0.1490 0.1490))
(defconstant +gray16+ (make-named-color "gray16" 0.1608 0.1608 0.1608))
(defconstant +grey16+ (make-named-color "grey16" 0.1608 0.1608 0.1608))
(defconstant +gray17+ (make-named-color "gray17" 0.1686 0.1686 0.1686))
(defconstant +grey17+ (make-named-color "grey17" 0.1686 0.1686 0.1686))
(defconstant +gray18+ (make-named-color "gray18" 0.1804 0.1804 0.1804))
(defconstant +grey18+ (make-named-color "grey18" 0.1804 0.1804 0.1804))
(defconstant +gray19+ (make-named-color "gray19" 0.1882 0.1882 0.1882))
(defconstant +grey19+ (make-named-color "grey19" 0.1882 0.1882 0.1882))
(defconstant +gray20+ (make-named-color "gray20" 0.2000 0.2000 0.2000))
(defconstant +grey20+ (make-named-color "grey20" 0.2000 0.2000 0.2000))
(defconstant +gray21+ (make-named-color "gray21" 0.2118 0.2118 0.2118))
(defconstant +grey21+ (make-named-color "grey21" 0.2118 0.2118 0.2118))
(defconstant +gray22+ (make-named-color "gray22" 0.2196 0.2196 0.2196))
(defconstant +grey22+ (make-named-color "grey22" 0.2196 0.2196 0.2196))
(defconstant +gray23+ (make-named-color "gray23" 0.2314 0.2314 0.2314))
(defconstant +grey23+ (make-named-color "grey23" 0.2314 0.2314 0.2314))
(defconstant +gray24+ (make-named-color "gray24" 0.2392 0.2392 0.2392))
(defconstant +grey24+ (make-named-color "grey24" 0.2392 0.2392 0.2392))
(defconstant +gray25+ (make-named-color "gray25" 0.2510 0.2510 0.2510))
(defconstant +grey25+ (make-named-color "grey25" 0.2510 0.2510 0.2510))
(defconstant +gray26+ (make-named-color "gray26" 0.2588 0.2588 0.2588))
(defconstant +grey26+ (make-named-color "grey26" 0.2588 0.2588 0.2588))
(defconstant +gray27+ (make-named-color "gray27" 0.2706 0.2706 0.2706))
(defconstant +grey27+ (make-named-color "grey27" 0.2706 0.2706 0.2706))
(defconstant +gray28+ (make-named-color "gray28" 0.2784 0.2784 0.2784))
(defconstant +grey28+ (make-named-color "grey28" 0.2784 0.2784 0.2784))
(defconstant +gray29+ (make-named-color "gray29" 0.2902 0.2902 0.2902))
(defconstant +grey29+ (make-named-color "grey29" 0.2902 0.2902 0.2902))
(defconstant +gray30+ (make-named-color "gray30" 0.3020 0.3020 0.3020))
(defconstant +grey30+ (make-named-color "grey30" 0.3020 0.3020 0.3020))
(defconstant +gray31+ (make-named-color "gray31" 0.3098 0.3098 0.3098))
(defconstant +grey31+ (make-named-color "grey31" 0.3098 0.3098 0.3098))
(defconstant +gray32+ (make-named-color "gray32" 0.3216 0.3216 0.3216))
(defconstant +grey32+ (make-named-color "grey32" 0.3216 0.3216 0.3216))
(defconstant +gray33+ (make-named-color "gray33" 0.3294 0.3294 0.3294))
(defconstant +grey33+ (make-named-color "grey33" 0.3294 0.3294 0.3294))
(defconstant +gray34+ (make-named-color "gray34" 0.3412 0.3412 0.3412))
(defconstant +grey34+ (make-named-color "grey34" 0.3412 0.3412 0.3412))
(defconstant +gray35+ (make-named-color "gray35" 0.3490 0.3490 0.3490))
(defconstant +grey35+ (make-named-color "grey35" 0.3490 0.3490 0.3490))
(defconstant +gray36+ (make-named-color "gray36" 0.3608 0.3608 0.3608))
(defconstant +grey36+ (make-named-color "grey36" 0.3608 0.3608 0.3608))
(defconstant +gray37+ (make-named-color "gray37" 0.3686 0.3686 0.3686))
(defconstant +grey37+ (make-named-color "grey37" 0.3686 0.3686 0.3686))
(defconstant +gray38+ (make-named-color "gray38" 0.3804 0.3804 0.3804))
(defconstant +grey38+ (make-named-color "grey38" 0.3804 0.3804 0.3804))
(defconstant +gray39+ (make-named-color "gray39" 0.3882 0.3882 0.3882))
(defconstant +grey39+ (make-named-color "grey39" 0.3882 0.3882 0.3882))
(defconstant +gray40+ (make-named-color "gray40" 0.4000 0.4000 0.4000))
(defconstant +grey40+ (make-named-color "grey40" 0.4000 0.4000 0.4000))
(defconstant +gray41+ (make-named-color "gray41" 0.4118 0.4118 0.4118))
(defconstant +grey41+ (make-named-color "grey41" 0.4118 0.4118 0.4118))
(defconstant +gray42+ (make-named-color "gray42" 0.4196 0.4196 0.4196))
(defconstant +grey42+ (make-named-color "grey42" 0.4196 0.4196 0.4196))
(defconstant +gray43+ (make-named-color "gray43" 0.4314 0.4314 0.4314))
(defconstant +grey43+ (make-named-color "grey43" 0.4314 0.4314 0.4314))
(defconstant +gray44+ (make-named-color "gray44" 0.4392 0.4392 0.4392))
(defconstant +grey44+ (make-named-color "grey44" 0.4392 0.4392 0.4392))
(defconstant +gray45+ (make-named-color "gray45" 0.4510 0.4510 0.4510))
(defconstant +grey45+ (make-named-color "grey45" 0.4510 0.4510 0.4510))
(defconstant +gray46+ (make-named-color "gray46" 0.4588 0.4588 0.4588))
(defconstant +grey46+ (make-named-color "grey46" 0.4588 0.4588 0.4588))
(defconstant +gray47+ (make-named-color "gray47" 0.4706 0.4706 0.4706))
(defconstant +grey47+ (make-named-color "grey47" 0.4706 0.4706 0.4706))
(defconstant +gray48+ (make-named-color "gray48" 0.4784 0.4784 0.4784))
(defconstant +grey48+ (make-named-color "grey48" 0.4784 0.4784 0.4784))
(defconstant +gray49+ (make-named-color "gray49" 0.4902 0.4902 0.4902))
(defconstant +grey49+ (make-named-color "grey49" 0.4902 0.4902 0.4902))
(defconstant +gray50+ (make-named-color "gray50" 0.4980 0.4980 0.4980))
(defconstant +grey50+ (make-named-color "grey50" 0.4980 0.4980 0.4980))
(defconstant +gray51+ (make-named-color "gray51" 0.5098 0.5098 0.5098))
(defconstant +grey51+ (make-named-color "grey51" 0.5098 0.5098 0.5098))
(defconstant +gray52+ (make-named-color "gray52" 0.5216 0.5216 0.5216))
(defconstant +grey52+ (make-named-color "grey52" 0.5216 0.5216 0.5216))
(defconstant +gray53+ (make-named-color "gray53" 0.5294 0.5294 0.5294))
(defconstant +grey53+ (make-named-color "grey53" 0.5294 0.5294 0.5294))
(defconstant +gray54+ (make-named-color "gray54" 0.5412 0.5412 0.5412))
(defconstant +grey54+ (make-named-color "grey54" 0.5412 0.5412 0.5412))
(defconstant +gray55+ (make-named-color "gray55" 0.5490 0.5490 0.5490))
(defconstant +grey55+ (make-named-color "grey55" 0.5490 0.5490 0.5490))
(defconstant +gray56+ (make-named-color "gray56" 0.5608 0.5608 0.5608))
(defconstant +grey56+ (make-named-color "grey56" 0.5608 0.5608 0.5608))
(defconstant +gray57+ (make-named-color "gray57" 0.5686 0.5686 0.5686))
(defconstant +grey57+ (make-named-color "grey57" 0.5686 0.5686 0.5686))
(defconstant +gray58+ (make-named-color "gray58" 0.5804 0.5804 0.5804))
(defconstant +grey58+ (make-named-color "grey58" 0.5804 0.5804 0.5804))
(defconstant +gray59+ (make-named-color "gray59" 0.5882 0.5882 0.5882))
(defconstant +grey59+ (make-named-color "grey59" 0.5882 0.5882 0.5882))
(defconstant +gray60+ (make-named-color "gray60" 0.6000 0.6000 0.6000))
(defconstant +grey60+ (make-named-color "grey60" 0.6000 0.6000 0.6000))
(defconstant +gray61+ (make-named-color "gray61" 0.6118 0.6118 0.6118))
(defconstant +grey61+ (make-named-color "grey61" 0.6118 0.6118 0.6118))
(defconstant +gray62+ (make-named-color "gray62" 0.6196 0.6196 0.6196))
(defconstant +grey62+ (make-named-color "grey62" 0.6196 0.6196 0.6196))
(defconstant +gray63+ (make-named-color "gray63" 0.6314 0.6314 0.6314))
(defconstant +grey63+ (make-named-color "grey63" 0.6314 0.6314 0.6314))
(defconstant +gray64+ (make-named-color "gray64" 0.6392 0.6392 0.6392))
(defconstant +grey64+ (make-named-color "grey64" 0.6392 0.6392 0.6392))
(defconstant +gray65+ (make-named-color "gray65" 0.6510 0.6510 0.6510))
(defconstant +grey65+ (make-named-color "grey65" 0.6510 0.6510 0.6510))
(defconstant +gray66+ (make-named-color "gray66" 0.6588 0.6588 0.6588))
(defconstant +grey66+ (make-named-color "grey66" 0.6588 0.6588 0.6588))
(defconstant +gray67+ (make-named-color "gray67" 0.6706 0.6706 0.6706))
(defconstant +grey67+ (make-named-color "grey67" 0.6706 0.6706 0.6706))
(defconstant +gray68+ (make-named-color "gray68" 0.6784 0.6784 0.6784))
(defconstant +grey68+ (make-named-color "grey68" 0.6784 0.6784 0.6784))
(defconstant +gray69+ (make-named-color "gray69" 0.6902 0.6902 0.6902))
(defconstant +grey69+ (make-named-color "grey69" 0.6902 0.6902 0.6902))
(defconstant +gray70+ (make-named-color "gray70" 0.7020 0.7020 0.7020))
(defconstant +grey70+ (make-named-color "grey70" 0.7020 0.7020 0.7020))
(defconstant +gray71+ (make-named-color "gray71" 0.7098 0.7098 0.7098))
(defconstant +grey71+ (make-named-color "grey71" 0.7098 0.7098 0.7098))
(defconstant +gray72+ (make-named-color "gray72" 0.7216 0.7216 0.7216))
(defconstant +grey72+ (make-named-color "grey72" 0.7216 0.7216 0.7216))
(defconstant +gray73+ (make-named-color "gray73" 0.7294 0.7294 0.7294))
(defconstant +grey73+ (make-named-color "grey73" 0.7294 0.7294 0.7294))
(defconstant +gray74+ (make-named-color "gray74" 0.7412 0.7412 0.7412))
(defconstant +grey74+ (make-named-color "grey74" 0.7412 0.7412 0.7412))
(defconstant +gray75+ (make-named-color "gray75" 0.7490 0.7490 0.7490))
(defconstant +grey75+ (make-named-color "grey75" 0.7490 0.7490 0.7490))
(defconstant +gray76+ (make-named-color "gray76" 0.7608 0.7608 0.7608))
(defconstant +grey76+ (make-named-color "grey76" 0.7608 0.7608 0.7608))
(defconstant +gray77+ (make-named-color "gray77" 0.7686 0.7686 0.7686))
(defconstant +grey77+ (make-named-color "grey77" 0.7686 0.7686 0.7686))
(defconstant +gray78+ (make-named-color "gray78" 0.7804 0.7804 0.7804))
(defconstant +grey78+ (make-named-color "grey78" 0.7804 0.7804 0.7804))
(defconstant +gray79+ (make-named-color "gray79" 0.7882 0.7882 0.7882))
(defconstant +grey79+ (make-named-color "grey79" 0.7882 0.7882 0.7882))
(defconstant +gray80+ (make-named-color "gray80" 0.8000 0.8000 0.8000))
(defconstant +grey80+ (make-named-color "grey80" 0.8000 0.8000 0.8000))
(defconstant +gray81+ (make-named-color "gray81" 0.8118 0.8118 0.8118))
(defconstant +grey81+ (make-named-color "grey81" 0.8118 0.8118 0.8118))
(defconstant +gray82+ (make-named-color "gray82" 0.8196 0.8196 0.8196))
(defconstant +grey82+ (make-named-color "grey82" 0.8196 0.8196 0.8196))
(defconstant +gray83+ (make-named-color "gray83" 0.8314 0.8314 0.8314))
(defconstant +grey83+ (make-named-color "grey83" 0.8314 0.8314 0.8314))
(defconstant +gray84+ (make-named-color "gray84" 0.8392 0.8392 0.8392))
(defconstant +grey84+ (make-named-color "grey84" 0.8392 0.8392 0.8392))
(defconstant +gray85+ (make-named-color "gray85" 0.8510 0.8510 0.8510))
(defconstant +grey85+ (make-named-color "grey85" 0.8510 0.8510 0.8510))
(defconstant +gray86+ (make-named-color "gray86" 0.8588 0.8588 0.8588))
(defconstant +grey86+ (make-named-color "grey86" 0.8588 0.8588 0.8588))
(defconstant +gray87+ (make-named-color "gray87" 0.8706 0.8706 0.8706))
(defconstant +grey87+ (make-named-color "grey87" 0.8706 0.8706 0.8706))
(defconstant +gray88+ (make-named-color "gray88" 0.8784 0.8784 0.8784))
(defconstant +grey88+ (make-named-color "grey88" 0.8784 0.8784 0.8784))
(defconstant +gray89+ (make-named-color "gray89" 0.8902 0.8902 0.8902))
(defconstant +grey89+ (make-named-color "grey89" 0.8902 0.8902 0.8902))
(defconstant +gray90+ (make-named-color "gray90" 0.8980 0.8980 0.8980))
(defconstant +grey90+ (make-named-color "grey90" 0.8980 0.8980 0.8980))
(defconstant +gray91+ (make-named-color "gray91" 0.9098 0.9098 0.9098))
(defconstant +grey91+ (make-named-color "grey91" 0.9098 0.9098 0.9098))
(defconstant +gray92+ (make-named-color "gray92" 0.9216 0.9216 0.9216))
(defconstant +grey92+ (make-named-color "grey92" 0.9216 0.9216 0.9216))
(defconstant +gray93+ (make-named-color "gray93" 0.9294 0.9294 0.9294))
(defconstant +grey93+ (make-named-color "grey93" 0.9294 0.9294 0.9294))
(defconstant +gray94+ (make-named-color "gray94" 0.9412 0.9412 0.9412))
(defconstant +grey94+ (make-named-color "grey94" 0.9412 0.9412 0.9412))
(defconstant +gray95+ (make-named-color "gray95" 0.9490 0.9490 0.9490))
(defconstant +grey95+ (make-named-color "grey95" 0.9490 0.9490 0.9490))
(defconstant +gray96+ (make-named-color "gray96" 0.9608 0.9608 0.9608))
(defconstant +grey96+ (make-named-color "grey96" 0.9608 0.9608 0.9608))
(defconstant +gray97+ (make-named-color "gray97" 0.9686 0.9686 0.9686))
(defconstant +grey97+ (make-named-color "grey97" 0.9686 0.9686 0.9686))
(defconstant +gray98+ (make-named-color "gray98" 0.9804 0.9804 0.9804))
(defconstant +grey98+ (make-named-color "grey98" 0.9804 0.9804 0.9804))
(defconstant +gray99+ (make-named-color "gray99" 0.9882 0.9882 0.9882))
(defconstant +grey99+ (make-named-color "grey99" 0.9882 0.9882 0.9882))
(defconstant +gray100+ (make-named-color "gray100" 1.0000 1.0000 1.0000))
(defconstant +grey100+ (make-named-color "grey100" 1.0000 1.0000 1.0000))
(defconstant +dark-grey+ (make-named-color "dark-grey" 0.6627 0.6627 0.6627))
(defconstant +DarkGrey+ (make-named-color "DarkGrey" 0.6627 0.6627 0.6627))
(defconstant +dark-gray+ (make-named-color "dark-gray" 0.6627 0.6627 0.6627))
(defconstant +DarkGray+ (make-named-color "DarkGray" 0.6627 0.6627 0.6627))
(defconstant +dark-blue+ (make-named-color "dark-blue" 0.0000 0.0000 0.5451))
(defconstant +DarkBlue+ (make-named-color "DarkBlue" 0.0000 0.0000 0.5451))
(defconstant +dark-cyan+ (make-named-color "dark-cyan" 0.0000 0.5451 0.5451))
(defconstant +DarkCyan+ (make-named-color "DarkCyan" 0.0000 0.5451 0.5451))
(defconstant +dark-magenta+ (make-named-color "dark-magenta" 0.5451 0.0000 0.5451))
(defconstant +DarkMagenta+ (make-named-color "DarkMagenta" 0.5451 0.0000 0.5451))
(defconstant +dark-red+ (make-named-color "dark-red" 0.5451 0.0000 0.0000))
(defconstant +DarkRed+ (make-named-color "DarkRed" 0.5451 0.0000 0.0000))
(defconstant +light-green+ (make-named-color "light-green" 0.5647 0.9333 0.5647))
(defconstant +LightGreen+ (make-named-color "LightGreen" 0.5647 0.9333 0.5647))

(defconstant +contrasting-colors+ (vector +black+ +red+ +green+ +blue+ +cyan+ +magenta+ +yellow+ +white+))
