.\" clig manual page template
.\" (C) 1995-2004 Harald Kirsch (clig@geggus.net)
.\"
.\" This file was generated by
.\" clig -- command line interface generator
.\"
.\"
.\" Clig will always edit the lines between pairs of `cligPart ...',
.\" but will not complain, if a pair is missing. So, if you want to
.\" make up a certain part of the manual page by hand rather than have
.\" it edited by clig, remove the respective pair of cligPart-lines.
.\"
.\" cligPart TITLE
.TH "clig" 1 "|Version|" "Clig-manuals" "Programmer's Manual"
.\" cligPart TITLE end

.\" cligPart NAME
.SH NAME
clig \- generate a command line parser and/or basic manual page
.\" cligPart NAME end

.\" cligPart SYNOPSIS
.SH SYNOPSIS
.B clig
[-t types]
[-o outprefix]
[-m manFile]
[-mx manExt]
[-d]
infile
.\" cligPart SYNOPSIS end

.\" cligPart OPTIONS
.SH OPTIONS
.IP -t
the types of output to generate. Currently supported types
are `C', `tcl' and `man',
.br
1 or more String values
.br
Default: `C' `man'
.IP -o
name of .c and .h file if type C is requested
Default: infile with suffix removed,
.br
1 String value
.IP -m
manual page to edit or generate if type man is requested
Default: `Name' specified in input file,
.br
1 String value
.IP -mx
extension of manual page,
.br
1 String value
.br
Default: `.1'
.IP -d
generate the function showOptionValues if type C is
requested .
.IP infile
name of file which contains the command line specification.
.\" cligPart OPTIONS end

.SH DESCRIPTION

.B Clig
reads
.I infile
and creates the output as requested by option
.BR -t .
Most often you will just use the default to create a command line
interpreter for your C program as well as the skeleton of a manual
page. One of the main reasons to use
.B clig
is, that besides the command line interpreter, a
.B usage()
function
and a manual page are generated, which are always up-to-date with
respect to the options actually understood by the program.

Currently, options of type 
.BR Flag ", " String ", " Int ", " Long ", " Float " and " Double
are supported. Except for
.B Flag 
options, all option-descriptions allow
to specify how many arguments are expected for the option and whether
the option is mandatory or not. For non-mandatory options, default
values can be specified and will be returned by
the generated command line interpreter
if necessary. In addition, for floating point
and integer options, a range can be declared, and the interpreter will
exit the program with an error message, if the option's argument lies
outside the given range.

.B Clig
is implemented in Tcl and
.I infile
actually contains tcl-code, but under normal circumstances the user
does not need to know anything about tcl, because the syntax of the
description-file is described below in section "DESCRIPTION FILE" and
in the manual pages
.BR clig_ *
as noted in the section \*(lqSEE ALSO\*(rq. (I admit that this
is probably a lie, because under `normal circumstances'
.I infile
may contain syntax errors resulting in really tcl-ish error messages.)
.\"*********************************************************************
.SH DESCRIPTION FILE
The description-file,
.IR infile ,
is a line-oriented ascii-file. Each line contains a command which
either describes an option or specifies additional information
necessary to generate the command line interpreter or the manual page.
A command starts with the command-name followed by mandatory
parameters and possibly followed by options.  If a command does not
fit on a line, it may be continued on the next line if the previous
line is terminated with a backslash (\\).

The commands are described in detail in their own manual pages, but
let us consider a simple
example, e.g. a command to describe an option named 
.B -fs
which wants exactly one parameter of type 
.B float
and will be used in your program as a font size. (Note the
backslash on the next line!)

.RS
.nf
.B  Float -fs fontsize \\\\
.B "    {size of font in points} -d 11.0 -r 8.0 19.5
.fi
.RE

The command's name is 
.BR Float .
It has three fixed parameters: The first,
.BR -fs ,
is the string to be detected by the command line interpreter. The second,
.BR fontsize ,
is the name of a variable your program will use to receive the value
found on the command line.
The third parameter, i.e. everything between the
braces, is a string which will be printed by 
.BR usage() .
The 
.B -d
(for default) specifies that 
.B fontsize
will be set to the default of 11.0, if 
.B -fs
is not found on the command line. With
.B -r
(for range) you make sure that the command line interpreter will
refuse any values for 
.B -fs
which are not within the given range.

.SS "Mandatory Commands"
The description file
.I infile
must contain the commands 
.BR Name " and " Usage .
The first gives a name to your program and the second declares a short
(one-line) description for it. Both pieces of information will be used
in the
.BR usage() -message
as well as in the manual page.

.SS "Other Commands"
Please read the manual pages listed under "SEE ALSO" below which start 
with
.B clig_
to find a detailed description of all commands available in the
description file 
.IR infile .
An 
.RI example- infile
can be found as |Example|/cmdline.cli.

.\" ----------------------------------------------------------------
.SH "OUTPUT TYPE C"
.B Clig
generates the files
.IR outprefix ".c and " outprefix  .h,
where 
.IR outprefix .h
contains all
declarations necessary to use the services defined in the 
.IR outprefix .c.
If a prefix is not given on the command line, it defaults to
the name of the input file with any suffix removed.

.SS parseCmdline
The output files implement a command line interpreter with the
prototype 

.RS
.B Cmdline *parseCmdline(int argc, char **argv);
.RE

which is meant to be called by your 
.B main()
to interpret the command line given as
.BR argc " and " argv .


.SS usage
The output files also implement the function

.RS
.B void usage(void);
.RE

custom made from the information in 
.IR infile .
IF
.B parseCmdline()
encounters an undeclared option on the command line, it immediately
calls 
.BR usage() .
Therefore you should normally declare neither -h nor --help as options
for your program so that
usage-message can be requested with any of these options. Normally it
is not necessary to call 
.B usage()
directly, but it is possible.


.SS Cmdline
The type
.BR Cmdline ,
a pointer to which is returned by 
.BR parseCmdline() ,
is also declared in the generated header file. It is custom-made
according to what is found in 
.IR infile .
If, for example, 
.IR infile
contains the declaration
.nf

  Float -pi pi {your personal approximation of pi}

.fi
the structure will have the three slots
.BR piP ", " pi " and " piC ,
where
.B piP
is a boolean set to 1 if and only if the option 
.B -r
is found on the command line. In that case 
.B piC 
contains the number of parameters found for 
.BR -r .
The parameters found are stored in 
.B pi
itself. It is either of type
.BR float* " or " float "
depending on whether option
.B -r
may at all have more than one argument. In the example above, this is
not the case, but if you declare
.nf

  Float -ival ival {interval to consider} -c 2 2 

.fi
in
.IR infile ,
.B ival
must store 2 values and consequently it will be of type
.B float*
with sufficient memory allocated.

.SS Program
To be conveniently available for error message and for use in
.BR usage() ", " parseCmdline()
will also set the global variable

.RS
.B char *Program;
.RE

to the tail of 
.BR argv[0] .

.SS showOptionValues
If so requested with option
.BR -d ,
the output will contain a function

.RS
.B void showOptionValues(void);
.RE

which can be called after 
.B parseCmdline()
to print the structure
.BR Cmdline 
to stdout. This is merely for debugging purposes.



.SS Example Main Program
The following example demonstrates the use of the command line parser,
provided that 
.I outprefix
.RB "= " cmdline
and that 
.B clig
was called with option
.B -d
to generate the function
.BR showOptionValues() .

.RS 2
.nf
#include "cmdline.h"

int main(int argc, char **argv)
{
  Cmdline *cmd = parseCmdline(argc, argv);
  showOptionValues();

  /* Program is set by parseCmdline */
  printf("Program = `%s'\\n", Program);

  /*****
    Your code goes here. Option parameters and cleaned-up 
    argc and argv are referenced with cmd->...
  *****/

  return 0;
}
.fi
.RE


.\" ----------------------------------------------------------------
.SH "OUTPUT TYPE tcl"
In fact, output type
.B tcl
is not yet supported. However this does not mean you cannot use 
.B ::clig 
to instrument your Tcl-scripts. It only means that you must have 
.B ::clig
installed on the machine were an instrumented script should run. Read
.BR clig_parseCmdline(n)
to learn how to instrument your Tcl-script with 
.BR ::clig .

.\" ----------------------------------------------------------------
.SH "OUTPUT TYPE man"
Clig can generate or edit a manual page in *roff format. The
name of the manual page can be specified with option
.BR -m
and its suffix can be specified with
.BR -mx .
By default, the name will be the string specified with the
.BR Name -command
in the description file and the default suffix is 
.BR .1 .

If the manual page file exists, clig edits specially marked sections of
the file by filling in up-to-date information. If the file does not yet
exist, it copies a template file into it and then edits the template
in the same way.

Clig is able to fill out the manual page sections `NAME', `SYNOPSIS',
`OPTIONS' and, in a very limited way, `DESCRIPTION'. In addition it will
supply a default title macro (.TH). The lines of the manual page file
which are replaced by clig must be clearly marked by matching pairs of
tag lines like
.nf

  .\\" cligPart <section>

and

  .\\" cligPart <section> end

where <section> is one of the section names listed above.
.fi

The idea is, that you edit the manual page, while
clig fills in the parts that can be deduced from the description
file. If you don't like what clig fills in, simply remove both
tag-lines of a section and clig will leave it alone. You certainly want
to do this for the DESCRIPTION-section.

.SH "SEE ALSO"
|SEEALSO|
