/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Gordon Allott <gord.allott@canonical.com> 
 *
 */

#ifndef _CTK_DND_H_
#define _CTK_DND_H_

#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "ctk-actor.h"
G_BEGIN_DECLS

void    ctk_dnd_init                (GtkWidget *widget,
                                     const GtkTargetEntry *targets,
                                     gint n_targets);
void    ctk_drag_dest_start         (CtkActor *widget);
void    ctk_drag_get_data           (CtkActor *actor, GdkDragContext *context, 
                                     GdkAtom target, guint32 time_);
GdkAtom ctk_drag_dest_find_target   (GdkDragContext *context,
                                     GtkTargetList *target_list);
                        
gboolean ctk_drag_dest_is_dest      (CtkActor *widget);

G_END_DECLS

#endif /* _CTK_DND_H_ */

