/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFTOOLTIPY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_TOOLTIP_H_
#define _CTK_TOOLTIP_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/ctk-actor.h>

G_BEGIN_DECLS

#define CTK_TYPE_TOOLTIP (ctk_tooltip_get_type ())

#define CTK_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_TOOLTIP, CtkTooltip))

#define CTK_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_TOOLTIP, CtkTooltipClass))

#define CTK_IS_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_TOOLTIP))

#define CTK_IS_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_TOOLTIP))

#define CTK_TOOLTIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_TOOLTIP, CtkTooltipClass))

typedef struct _CtkTooltip        CtkTooltip;
typedef struct _CtkTooltipClass   CtkTooltipClass;
typedef struct _CtkTooltipPrivate CtkTooltipPrivate;
 
struct _CtkTooltip
{
  CtkActor parent;	

  CtkTooltipPrivate *priv;
};

struct _CtkTooltipClass
{
  /*< private >*/
  CtkActorClass  parent_class;

  /*< public >*/
  /* signals, not vfuncs */

  /* vtable */

  /*< private >*/
  /* padding */
  void (*_ctk_padding1) (void);
  void (*_ctk_padding2) (void);
  void (*_ctk_padding3) (void);
  void (*_ctk_padding4) (void);
  void (*_ctk_padding5) (void);
  void (*_ctk_padding6) (void);
};

GType ctk_tooltip_get_type (void) G_GNUC_CONST;

ClutterActor * ctk_tooltip_new       (ClutterActor *actor);

void           ctk_tooltip_set_actor (CtkTooltip   *self,
                                      ClutterActor *actor);

ClutterActor * ctk_tooltip_get_actor (CtkTooltip   *self);

void           ctk_tooltip_set_label (CtkTooltip   *self,
                                      const gchar  *label);

const gchar  * ctk_tooltip_get_label (CtkTooltip   *self);

void           ctk_tooltip_show      (CtkTooltip   *self,
                                      gint          x,
                                      gint          y);

void           ctk_tooltip_hide      (CtkTooltip   *self);

G_END_DECLS

#endif /* _CTK_TOOLTIP_H_ */

